﻿--[[
Name: Babble-Vendor-2.2
Revision: $Rev: 79108 $
Authors(s): Kodewulf (kodewulf@gmail.com)
Website: www.wowace.com
Documentation: http://www.wowace.com/wiki/Babble-Vendor-2.2
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Vendor-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 79108 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleVendor = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

BabbleVendor:RegisterTranslations("enUS", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = true,
    ["Alchemy & Herbalism Supplies"] = true,
    ["Alchemy Supplies"] = true,
    ["Alliance Cloth Quartermaster"] = true,
    ["Alpha Gem Vendor"] = true,
    ["Ammunition Vendor"] = true,
    ["Arcane Goods Vendor"] = true,
    ["Arcane Trinkets Vendor"] = true,
    ["Arena Vendor"] = true,
    ["Armor & Shield Merchant"] = true,
    ["Armor Crafter"] = true,
    ["Armor Merchant"] = true,
    ["Armorer"] = true,
    ["Armorsmith"] = true,
    ["Armorsmith & Blacksmithing Supplies"] = true,
    ["Arrow Merchant"] = true,
    ["Axe Merchant"] = true,
    ["Axe Vendor"] = true,
    ["Bag Merchant"] = true,
    ["Bag Vendor"] = true,
    ["Bait and Tackle Supplier"] = true,
    ["Beverage Merchant"] = true,
    ["Blacksmithing Supplier"] = true,
    ["Blacksmithing Supplies"] = true,
    ["Blacksmithing Trainer and Supplies"] = true,
    ["Blade Merchant"] = true,
    ["Blade Vendor"] = true,
    ["Blunt Weapon Merchant"] = true,
    ["Bow & Arrow Merchant"] = true,
    ["Bow & Gun Merchant"] = true,
    ["Bow Merchant"] = true,
    ["Bowyer"] = true,
    ["Bread Merchant"] = true,
    ["Bread Vendor"] = true,
    ["Butcher"] = true,
    ["Cenarion Expedition Quartermaster"] = true,
    ["Cheese Vendor"] = true,
    ["Chef"] = true,
    ["Cloth & Leather Armor Merchant"] = true,
    ["Cloth & Leather Merchant"] = true,
    ["Cloth Armor Merchant"] = true,
    ["Cloth and Leather Merchant"] = true,
    ["Cockroach Vendor"] = true,
    ["Consortium Quartermaster"] = true,
    ["Cooking Supplier"] = true,
    ["Cooking Supplies"] = true,
    ["Cooking Trainer and Supplies"] = true,
    ["Dagger Vendor"] = true,
    ["Darkmoon Faire Drink Vendor"] = true,
    ["Darkmoon Faire Food Vendor"] = true,
    ["Defilers Supply Officer"] = true,
    ["Drink Vendor"] = true,
    ["Enchanting Supplier"] = true,
    ["Enchanting Supplies"] = true,
    ["Enchanting Vendor"] = true,
    ["Engineering & General Goods Supplier"] = true,
    ["Engineering Supplier"] = true,
    ["Engineering Supplies"] = true,
    ["Engineering and Mining Supplies"] = true,
    ["Exotic Reagent Merchant"] = true,
    ["Fireworks Merchant"] = true,
    ["Fireworks Vendor"] = true,
    ["Fish Merchant"] = true,
    ["Fish Merchant & Supplies"] = true,
    ["Fish Vendor"] = true,
    ["Fisherman Supplies"] = true,
    ["Fishing Supplier"] = true,
    ["Fishing Supplies"] = true,
    ["Fishing Trainer & Supplies"] = true,
    ["Food & Drink Merchant"] = true,
    ["Food & Drink Vendor"] = true,
    ["Food Vendor"] = true,
    ["Food and Drink"] = true,
    ["Food & Drink"] = true,
    ["Free Wheeling Merchant"] = true,
    ["Frostwolf Supply Officer"] = true,
    ["Fruit Vendor"] = true,
    ["Fungus Vendor"] = true,
    ["Gem Vendor"] = true,
    ["General & Trade Supplies"] = true,
    ["General Goods"] = true,
    ["General Goods Merchant"] = true,
    ["General Goods Vendor"] = true,
    ["General Supplies"] = true,
    ["General Trade Goods Merchant"] = true,
    ["General Trade Goods Vendor"] = true,
    ["General Trade Supplier"] = true,
    ["Guild Tabard Vendor"] = true,
    ["Gun Merchant"] = true,
    ["Guns Merchant"] = true,
    ["Guns and Ammo Merchant"] = true,
    ["Gunsmith"] = true,
    ["Healing & Sustenance"] = true,
    ["Heavy Armor Merchant"] = true,
    ["Herbalism & Alchemy Supplies"] = true,
    ["Herbalism Supplier"] = true,
    ["Honor Hold Quartermaster"] = true,
    ["Horde Cloth Quartermaster"] = true,
    ["Hunting Supplies"] = true,
    ["Ice Cream Vendor"] = true,
    ["Innkeeper"] = true,
    ["Jewelcrafting Supplier"] = true,
    ["Jewelcrafting Supplies Vendor"] = true,
    ["Keepers of Time Quartermaster"] = true,
    ["Kurenai Quartermaster"] = true,
    ["League of Arathor Supply Officer"] = true,
    ["Leather & Mail Armor Merchant"] = true,
    ["Leather Armor & Leatherworking Supplies"] = true,
    ["Leather Armor Merchant"] = true,
    ["Leatherworking & Tailoring Supplies"] = true,
    ["Leatherworking Supplier"] = true,
    ["Leatherworking Supplies"] = true,
    ["Light Armor & Weapons Merchant"] = true,
    ["Light Armor Merchant"] = true,
    ["Mace & Staff Merchant"] = true,
    ["Mace & Staves Vendor"] = true,
    ["Macecrafter"] = true,
    ["Mag'har Quartermaster"] = true,
    ["Mail & Plate Merchant"] = true,
    ["Mail Armor Merchant"] = true,
    ["Meat Vendor"] = true,
    ["Mechanostrider Merchant"] = true,
    ["Merchant"] = true,
    ["Metalsmith"] = true,
    ["Mining Supplier"] = true,
    ["Mining Supplies"] = true,
    ["Mining and Smithing Supplies"] = true,
    ["Mushroom Merchant"] = true,
    ["Mushroom Vendor"] = true,
    ["Pie Vendor"] = true,
    ["Pirate Supplies"] = true,
    ["Plate Armor Merchant"] = true,
    ["Poison Supplier"] = true,
    ["Poison Supplies"] = true,
    ["Poison Vendor"] = true,
    ["Potions, Scrolls & Reagents"] = true,
    ["Prairie Dog Vendor"] = true,
    ["Quartermaster"] = true,
    ["Rations"] = true,
    ["Reagent Merchant"] = true,
    ["Reagent Supplier"] = true,
    ["Reagent Supplies"] = true,
    ["Reagent Vendor"] = true,
    ["Reagents Vendor"] = true,
    ["Robe Merchant"] = true,
    ["Robe Vendor"] = true,
    ["Scrolls & Potions"] = true,
    ["Scryers: Quartermaster"] = true,
    ["Shield Crafter"] = true,
    ["Shield Merchant"] = true,
    ["Silverwing Supply Officer"] = true,
    ["Special Weapon Crafter"] = true,
    ["Specialist Tailoring Supplies"] = true,
    ["Speciality Dress Maker"] = true,
    ["Speciality Tailoring Supplies"] = true,
    ["Specialty Tailoring Supplies"] = true,
    ["Sporeggar Quartermaster"] = true,
    ["Staff & Mace Merchant"] = true,
    ["Staff Merchant"] = true,
    ["Staff Vendor"] = true,
    ["Staves Merchant"] = true,
    ["Stormpike Supply Officer"] = true,
    ["Superior Armor Crafter"] = true,
    ["Superior Armorer"] = true,
    ["Superior Macecrafter"] = true,
    ["Superior Tradesman"] = true,
    ["Supplies"] = true,
    ["Sword Vendor"] = true,
    ["Sword and Dagger Merchant"] = true,
    ["Tabard Vendor"] = true,
    ["Tailoring Supplier"] = true,
    ["Tailoring Supplies"] = true,
    ["Thrallmar Quartermaster"] = true,
    ["Thrown Weapons Merchant"] = true,
    ["Tools & Supplies"] = true,
    ["Trade Goods"] = true,
    ["Trade Goods Supplier"] = true,
    ["Trade Goods Supplies"] = true,
    ["Trade Goods Vendor"] = true,
    ["Trade Supplier"] = true,
    ["Trade Supplies"] = true,
    ["Tradesman"] = true,
    ["Traveling Merchant"] = true,
    ["Two Handed Weapon Merchant"] = true,
    ["Two-Handed Weapons Merchant"] = true,
    ["Undead Horse Merchant"] = true,
    ["Venture Co. Merchant"] = true,
    ["Wand Merchant"] = true,
    ["Wand Vendor"] = true,
    ["Wands Merchant"] = true,
    ["War Harness Maker"] = true,
    ["War Harness Vendor"] = true,
    ["Warsong Supply Officer"] = true,
    ["Weapon Crafter"] = true,
    ["Weapon Merchant"] = true,
    ["Weapon Vendor"] = true,
    ["Weapons Merchant"] = true,
    ["Weapons and Armor Merchant"] = true,
    ["Weaponsmith"] = true,
    ["Weaponsmith & Gunsmith"] = true,
    ["Wine & Spirits Merchant"] = true,
    ["Wine Vendor"] = true,
} end)

BabbleVendor:RegisterTranslations("deDE", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = "R\195\188stmeister f\195\188r Zubeh\195\182r", -- check
    ["Alchemy & Herbalism Supplies"] = "Alchemie- und Kr\195\164uterkundebedarf",
    ["Alchemy Supplies"] = "Alchimiebedarf",
    ["Alliance Cloth Quartermaster"] = "Stoffr\195\188stmeister der Allianz",
    ["Alpha Gem Vendor"] = "Edelsteinh\195\164ndler",
    ["Ammunition Vendor"] = "Munitionsverk\195\164ufer",
    ["Arcane Goods Vendor"] = "Arkanarienverk\195\164ufer",
    ["Arcane Trinkets Vendor"] = "Verk\195\164uferin arkaner Gegenst\195\164nde", -- female (no male vendor)
    ["Arena Vendor"] = "Arenaverk\195\164ufer",
    ["Armor & Shield Merchant"] = "R\195\188stungs & Schildh\195\164ndler",
    ["Armor Crafter"] = "R\195\188stungsmacher",
    ["Armor Merchant"] = "Waffenh\195\164ndler",
    ["Armorer"] = "Armorer",
    ["Armorsmith"] = "Waffenschmied",
    ["Armorsmith & Blacksmithing Supplies"] = "R\195\188stungsschmied und Schmiedekunstbedarf",
    ["Axe Merchant"] = "Axth\195\164ndler",
    ["Arrow Merchant"] = "Pfeilh\195\164ndler",
    ["Axe Vendor"] = "Axth\195\164ndler",
    ["Bag Merchant"] = "Taschenh\195\164ndler",
    ["Bag Vendor"] = "Taschenverk\195\164ufer",
    ["Bait and Tackle Supplier"] = "Lieferant f\195\188r K\195\182der und Angelzubeh\195\182r",
    ["Beverage Merchant"] = "Getr\195\164nkeh\195\164ndler",
    ["Blacksmithing Supplier"] = "Schmiedekunstbedarf",
    ["Blacksmithing Supplies"] = "Schmiedekunstbedarf",
    ["Blacksmithing Trainer and Supplies"] = "Schmiedekunstlehrer und -bedarf",
    ["Blade Merchant"] = "Klingenh\195\164ndler",
    ["Blade Vendor"] = "Klingenverk\195\164ufer",
    ["Blunt Weapon Merchant"] = "H\195\164ndler f\195\188r stumpfe Waffen",
    ["Bow & Arrow Merchant"] = "Pfeil- und Bogenh\195\164ndler",
    ["Bow & Gun Merchant"] = "Bogen- und Pfeilh\195\164ndlerin", -- female (no male vendor)
    ["Bow Merchant"] = "Bogenh\195\164ndler",
    ["Bowyer"] = "Bogenmacher",
    ["Bread Merchant"] = "Broth\195\164ndler",
    ["Bread Vendor"] = "Brotverk\195\164ufer",
    ["Butcher"] = "Metzger",
    ["Cenarion Expedition Quartermaster"] = "R\195\188stmeister der Expedition des Cenarius",
    ["Cheese Vendor"] = "K\195\164severk\195\164uferin", -- female (no male vendor)
    ["Chef"] = "Koch",
    ["Cloth & Leather Armor Merchant"] = "Tuch- und Lederr\195\188stungsh\195\164ndler",
    ["Cloth & Leather Merchant"] = "Tuch- & Lederh\195\164ndlerin", -- female (no male vendor)
    ["Cloth Armor Merchant"] = "Stoffr\195\188stungsh\195\164ndler",
    ["Cloth and Leather Merchant"] = "Tuch- und Lederh\195\164ndler",
    ["Cockroach Vendor"] = "Kakerlakenverk\195\164ufer",
    ["Consortium Quartermaster"] = "R\195\188stmeister des Konsortiums",
    ["Cooking Supplier"] = "Kochbedarf",
    ["Cooking Supplies"] = "Kochbedarf",
    ["Cooking Trainer and Supplies"] = "Kochkunstlehrer und -bedarf",
    ["Dagger Vendor"] = "Dolchverk\195\164ufer",
    ["Darkmoon Faire Drink Vendor"] = "Getr\195\164nkeverk\195\164ufer des Dunkelmond-Jahrmarkts",
    ["Darkmoon Faire Food Vendor"] = "Lebensmittelverk\195\164ufer des Dunkelmond-Jahrmarkts",
    ["Defilers Supply Officer"] = "Versorgungsoffizier der Entweihten",
    ["Drink Vendor"] = "Getr\195\164nkeverk\195\164ufer",
    ["Enchanting Supplier"] = "Verzauberkunstbedarf",
    ["Enchanting Supplies"] = "Verzauberkunstbedarf",
    ["Enchanting Vendor"] = "Verzauberkunstbedarf",
    ["Engineering & General Goods Supplier"] = "Ingenieursbedarf- und Gemischtwarenlieferant",
    ["Engineering Supplier"] = "Ingenieursbedarf",
    ["Engineering Supplies"] = "Ingenieursbedarf",
    ["Engineering and Mining Supplies"] = "Ingenieurs- und Bergbaubedarf",
    ["Exotic Reagent Merchant"] = "H\195\164ndler f\195\188r exotische Reagenzien",
    ["Fireworks Merchant"] = "Feuerwerkh\195\164ndler",
    ["Fireworks Vendor"] = "Feuerwerkverk\195\164ufer",
    ["Fish Merchant"] = "Fischh\195\164ndler",
    ["Fish Merchant & Supplies"] = "Fischh\195\164ndler und Zubeh\195\182r",
    ["Fish Vendor"] = "Fischverk\195\164ufer",
    ["Fisherman Supplies"] = "Anglerbedarf",
    ["Fishing Supplier"] = "Angelbedarf",
    ["Fishing Supplies"] = "Angelbedarf",
    ["Fishing Trainer & Supplies"] = "Angellehrer & Angelbedarf",
    ["Food & Drink Merchant"] = "Lebensmittel- und Getr\195\164nkeh\195\164ndler",
    ["Food & Drink Vendor"] = "Lebensmittel- und Getr\195\164nkeverk\195\164ufer",
    ["Food Vendor"] = "Lebensmittelverk\195\164ufer",
    ["Food and Drink"] = "Essen und Getr\195\164nke",
    ["Food & Drink"] = "Essen und Getr\195\164nke",
    ["Free Wheeling Merchant"] = "Freier H\195\164ndler",
    ["Frostwolf Supply Officer"] = "Versorgungsoffizier der Frostw\195\182lfe",
    ["Fruit Vendor"] = "Obstverk\195\164ufer",
    ["Fungus Vendor"] = "Pilzverk\195\164ufer",
    ["Gem Vendor"] = "Edelsteinh\195\164ndler",
    ["General & Trade Supplies"] = "Gemischt- und Handwerkswaren",
    ["General Goods"] = "Gemischtwaren",
    ["General Goods Merchant"] = "Gemischtwarenh\195\164ndler",
    ["General Goods Vendor"] = "Gemischtwarenverk\195\164ufer",
    ["General Supplies"] = "Gemischtwaren",
    ["General Trade Goods Merchant"] = "Gemischtwarenh\195\164ndlerin", -- female (no male vendor)
    ["General Trade Goods Vendor"] = "Gemischt- und Handwerkswarenverk\195\164ufer",
    ["General Trade Supplier"] = "Gemischt- und Handwerkswarenlieferant",
    ["Guild Tabard Vendor"] = "Gildenwamsverk\195\164uferin", -- female (no male vendor)
    ["Gun Merchant"] = "Schusswaffenh\195\164ndler",
    ["Guns Merchant"] = "Schusswaffenh\195\164ndler",
    ["Guns and Ammo Merchant"] = "Schusswaffen- und Munitionh\195\164ndlerin", -- female (no male vendor)
    ["Gunsmith"] = "Schusswaffenschmied",
    ["Healing & Sustenance"] = "Heilung & \195\156berleben",
    ["Heavy Armor Merchant"] = "H\195\164ndler f\195\188r schwere R\195\188stungen", -- check
    ["Herbalism & Alchemy Supplies"] = "Kr\195\164uterkunde- und Alchimiebedarf",
    ["Herbalism Supplier"] = "Kr\195\164uterkundebedarf",
    ["Honor Hold Quartermaster"] = "R\195\188stmeisterin der Ehrenfeste", -- female (no male)
    ["Horde Cloth Quartermaster"] = "Stoffr\195\188stmeister der Horde",
    ["Hunting Supplies"] = "Jagdbedarf",
    ["Ice Cream Vendor"] = "Eiskremverk\195\164ufer",
    ["Innkeeper"] = "Gastwirt",
    ["Jewelcrafting Supplier"] = "Juwelenschleiferbedarf",
    ["Jewelcrafting Supplies Vendor"] = "Juwelenschleiferbedarf",
    ["Keepers of Time Quartermaster"] = "R\195\188stmeisterin der H\195\188ter der Zeit", -- female (no male)
    ["Kurenai Quartermaster"] = "R\195\188stmeister der Kurenai",
    ["League of Arathor Supply Officer"] = "Versorgungsoffizier des Bundes von Arathor",
    ["Leather & Mail Armor Merchant"] = "H\195\164ndler f\195\188r Leder- und schwere R\195\188stungen",
    ["Leather Armor & Leatherworking Supplies"] = "Lederr\195\188stungs- und Lederverarbeitungsbedarf",
    ["Leather Armor Merchant"] = "Lederr\195\188stungsh\195\164ndler",
    ["Leatherworking & Tailoring Supplies"] = "Lederverarbeitungs- und Schneiderbedarf",
    ["Leatherworking Supplier"] = "Lederverarbeitungsbedarf",
    ["Leatherworking Supplies"] = "Lederverarbeitungsbedarf",
    ["Light Armor & Weapons Merchant"] = "H\195\164ndlerin f\195\188r leichte R\195\188stungen & Waffen", -- female (no male vendor)
    ["Light Armor Merchant"] = "H\195\164ndler f\195\188r leichte R\195\188stungen",
    ["Mace & Staff Merchant"] = "Streitkolben- und Stabh\195\164ndler",
    ["Mace & Staves Vendor"] = "Streitkolben- und Stabverk\195\164ufer",
    ["Macecrafter"] = "Streitkolbenmacher",
    ["Mag'har Quartermaster"] = "R\195\188stmeister der Mag'har",
    ["Mail & Plate Merchant"] = "Panzer- und Plattenh\195\164ndler",
    ["Mail Armor Merchant"] = "H\195\164ndler f\195\188r schwere R\195\188stungen",
    ["Meat Vendor"] = "Fleischverk\195\164ufer",
    ["Mechanostrider Merchant"] = "Roboschreiterh\195\164ndlerin", -- Milli Featherwhistle, female
    ["Merchant"] = "H\195\164ndler",
    ["Metalsmith"] = "Metallschmied",
    ["Mining Supplier"] = "Bergbaubedarf",
    ["Mining Supplies"] = "Bergbaubedarf",
    ["Mining and Smithing Supplies"] = "Bergbau- und Schmiedekunstbedarf",
    ["Mushroom Merchant"] = "Pilzh\195\164ndler",
    ["Mushroom Vendor"] = "Pilzverk\195\164ufer",
    ["Pie Vendor"] = "Kuchenverk\195\164ufer",
    ["Pirate Supplies"] = "Piratenbedarf",
    ["Plate Armor Merchant"] = "Plattenr\195\188stungsh\195\164ndlerin", -- female (no male vendor)
    ["Poison Supplier"] = "Giftlieferant",
    ["Poison Supplies"] = "Giftbedarf",
    ["Poison Vendor"] = "Giftverk\195\164ufer",
    ["Potions, Scrolls & Reagents"] = "Potions, Scrolls & Reagents",
    ["Prairie Dog Vendor"] = "Pr\195\164riehundverk\195\164ufer",
    ["Quartermaster"] = "R\195\188stmeister",
    ["Rations"] = "Verpflegung",
    ["Reagent Merchant"] = "Reagenzienverk\195\164ufer",
    ["Reagent Supplier"] = "Reagenzienlieferant",
    ["Reagent Supplies"] = "Reagenzienbedarf",
    ["Reagent Vendor"] = "Reagenzienverk\195\164ufer",
    ["Reagents Vendor"] = "Reagenzienverk\195\164ufer",
    ["Robe Merchant"] = "Robenh\195\164ndler",
    ["Robe Vendor"] = "Robenverk\195\164uferin", -- female (no male vendor)
    ["Scrolls & Potions"] = "Schriftrollen und Tr\195\164nke",
    ["Scryers: Quartermaster"] = "R\195\188stmeister der Seher",
    ["Shield Crafter"] = "Schildmacherin", -- female (no male vendor)
    ["Shield Merchant"] = "Schildh\195\164ndler",
    ["Silverwing Supply Officer"] = "Versorgungsoffizier der Silberschwingen",
    ["Special Weapon Crafter"] = "Spezialwaffenmacher",
    ["Specialist Tailoring Supplies"] = "Schneiderspezialbedarf",
    ["Speciality Dress Maker"] = "Spezialdamenschneider",
    ["Speciality Tailoring Supplies"] = "Schneiderspezialbedarf",
    ["Specialty Tailoring Supplies"] = "Schneiderbedarf und Spezialzubeh\195\182r",
    ["Sporeggar Quartermaster"] = "R\195\188stmeister von Sporeggar",
    ["Staff & Mace Merchant"] = "Stab- und Streitkolbenh\195\164ndler",
    ["Staff Merchant"] = "Stabh\195\164ndler",
    ["Staff Vendor"] = "Stabverk\195\164ufer",
    ["Staves Merchant"] = "Stabh\195\164ndler",
    ["Stormpike Supply Officer"] = "Versorgungsoffizier der Sturmlanzen",
    ["Superior Armor Crafter"] = "\195\156berragender R\195\188stungsmacher",
    ["Superior Armorer"] = "Superior Armorer",
    ["Superior Macecrafter"] = "\195\156berragender Streitkolbenmacher",
    ["Superior Tradesman"] = "\195\156berragender Handwerker",
    ["Supplies"] = "Vorr\195\164te",
    ["Sword Vendor"] = "Schwertverk\195\164ufer",
    ["Sword and Dagger Merchant"] = "Schwert- und Dolchh\195\164ndler",
    ["Tabard Vendor"] = "Wamsverk\195\164ufer",
    ["Tailoring Supplier"] = "Schneiderbedarf",
    ["Tailoring Supplies"] = "Schneiderbedarf",
    ["Thrallmar Quartermaster"] = "R\195\188stmeister von Thrallmar",
    ["Thrown Weapons Merchant"] = "Wurfwaffenh\195\164ndler",
    ["Tools & Supplies"] = "Werkzeuge und Bedarfsartikel",
    ["Trade Goods"] = "Handwerkswaren",
    ["Trade Goods Supplier"] = "Handwerkswarenlieferantin", -- female (no male vendor)
    ["Trade Goods Supplies"] = "Handwerkswarenbedarf",
    ["Trade Goods Vendor"] = "Handwerkswarenverk\195\164ufer",
    ["Trade Supplier"] = "Handwerkswarenlieferant", -- check
    ["Trade Supplies"] = "Handwerkswaren",
    ["Tradesman"] = "Handwerker",
    ["Traveling Merchant"] = "Fliegender H\195\164ndler",
    ["Two Handed Weapon Merchant"] = "Zweihandwaffenh\195\164ndler",
    ["Two-Handed Weapons Merchant"] = "Zweihandwaffenh\195\164ndler",
    ["Undead Horse Merchant"] = "Pferdeh\195\164ndler der Untoten",
    ["Venture Co. Merchant"] = "H\195\164ndler von Venture Co.",
    ["Wand Merchant"] = "Zauberstabh\195\164ndler",
    ["Wand Vendor"] = "Zauberstabverk\195\164ufer",
    ["Wands Merchant"] = "Zauberstabh\195\164ndler",
    ["War Harness Maker"] = "Kriegsharnischhersteller",
    ["War Harness Vendor"] = "Kriegsharnischverk\195\164ufer",
    ["Warsong Supply Officer"] = "Versorgungsoffizier des Kriegshymnenklans",
    ["Weapon Crafter"] = "Waffenmacher",
    ["Weapon Merchant"] = "Waffenh\195\164ndler",
    ["Weapon Vendor"] = "Waffenverk\195\164ufer",
    ["Weapons Merchant"] = "Waffenh\195\164ndler",
    ["Weapons and Armor Merchant"] = "Waffen- und R\195\188stungsh\195\164ndler",
    ["Weaponsmith"] = "Waffenschmied",
    ["Weaponsmith & Gunsmith"] = "Weaponsmith & Gunsmith",
    ["Wine & Spirits Merchant"] = "Wein- & Spirituosenh\195\164ndler",
    ["Wine Vendor"] = "Weinverk\195\164ufer",
} end)

BabbleVendor:RegisterTranslations("koKR", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = "비전투장비 병참장교",
    ["Alchemy & Herbalism Supplies"] = "연금술용품 상인",
    ["Alchemy Supplies"] = "연금술용품 상인",
    ["Alliance Cloth Quartermaster"] = "얼라이언스 천 방어구 병참장교",
    ["Alpha Gem Vendor"] = "Alpha Gem Vendor",	--The Burning Crusade Beta NPC
    ["Ammunition Vendor"] = "탄약 상인",
    ["Arcane Goods Vendor"] = "마법용품 상인",
    ["Arcane Trinkets Vendor"] = "마법용품 상인",
    ["Arena Vendor"] = "투기장 사무관",
    ["Armor & Shield Merchant"] = "갑옷 및 방패 상인",
    ["Armor Crafter"] = "방어구 제작자",
    ["Armor Merchant"] = "방어구 상인",
    ["Armorer"] = "방어구 제작자",
    ["Armorsmith"] = "방어구 제작자",
    ["Armorsmith & Blacksmithing Supplies"] = "갑옷 및 대장용품 상인",
    ["Axe Merchant"] = "도끼 상인",
    ["Axe Vendor"] = "도끼 상인",
    ["Bag Merchant"] = "가방 상인",
    ["Bag Vendor"] = "가방 상인",
    ["Bait and Tackle Supplier"] = "낚시용품 상인",
    ["Beverage Merchant"] = "음료 상인",
    ["Blacksmithing Supplier"] = "대장용품 상인",
    ["Blacksmithing Supplies"] = "대장용품 상인",
    ["Blacksmithing Trainer and Supplies"] = "수습 대장장이 및 대장용품 상인",
    ["Blade Merchant"] = "도검류 상인",
    ["Blade Vendor"] = "도검류 상인",
    ["Blunt Weapon Merchant"] = "둔기류 상인",
    ["Bow & Arrow Merchant"] = "화살 상인",
    ["Bow & Gun Merchant"] = "활 및 총기류 상인",
    ["Bow Merchant"] = "활 상인",
    ["Bowyer"] = "활 상인",
    ["Bread Merchant"] = "빵 상인",
    ["Bread Vendor"] = "빵 상인",
    ["Butcher"] = "푸줏간 주인",
    ["Cenarion Expedition Quartermaster"] = "세나리온 원정대 병참장교",
    ["Cheese Vendor"] = "치즈 상인",
    ["Chef"] = "음식 상인",
    ["Cloth & Leather Armor Merchant"] = "천 및 가죽 방어구 상인",
    ["Cloth & Leather Merchant"] = "천 및 가죽 방어구 상인",
    ["Cloth Armor Merchant"] = "천 방어구 상인",
    ["Cloth and Leather Merchant"] = "천 및 가죽 방어구 상인",
    ["Cockroach Vendor"] = "바퀴벌레 상인",
    ["Consortium Quartermaster"] = "무역연합 병참장교",
    ["Cooking Supplier"] = "요리 재료 상인",
    ["Cooking Supplies"] = "요리 재료 상인",
    ["Cooking Trainer and Supplies"] = "전문 요리사 및 요리 용품 상인",
    ["Dagger Vendor"] = "단검 상인",
    ["Darkmoon Faire Drink Vendor"] = "다크문 유랑단 음료 상인",
    ["Darkmoon Faire Food Vendor"] = "다크문 유랑단 음식 상인",
    ["Defilers Supply Officer"] = "파멸단 병참장교",
    ["Drink Vendor"] = "음료 상인",
    ["Enchanting Supplier"] = "마법부여용품 상인",
    ["Enchanting Supplies"] = "마법부여용품 상인",
    ["Enchanting Vendor"] = "마법부여용품 상인",
    ["Engineering & General Goods Supplier"] = "기술용품 상인",
    ["Engineering Supplier"] = "기술용품 상인",
    ["Engineering Supplies"] = "기술용품 상인",
    ["Engineering and Mining Supplies"] = "기술 및 채광용품 상인",
    ["Exotic Reagent Merchant"] = "진귀한 마법 재료 상인",
    ["Fireworks Merchant"] = "폭죽 상인",
    ["Fireworks Vendor"] = "폭죽 상인",
    ["Fish Merchant"] = "생선 상인",
    ["Fish Merchant & Supplies"] = "낚시 용품 상인",
    ["Fish Vendor"] = "생선 상인",
    ["Fisherman Supplies"] = "낚시용품 상인",
    ["Fishing Supplier"] = "낚시용품 상인",
    ["Fishing Supplies"] = "낚시용품 상인",
    ["Fishing Trainer & Supplies"] = "낚시용품 상인",
    ["Food & Drink Merchant"] = "식료품 상인",
    ["Food & Drink Vendor"] = "식료품 상인",
    ["Food Vendor"] = "식료품 상인",
    ["Food and Drink"] = "식료품 상인",
    ["Food & Drink"] = "식료품 상인",
    ["Free Wheeling Merchant"] = "가죽 방어구 상인",
    ["Frostwolf Supply Officer"] = "서리늑대 병참장교",
    ["Fruit Vendor"] = "과일 상인",
    ["Fungus Vendor"] = "버섯 상인",
    ["Gem Vendor"] = "보석 상인",
    ["General & Trade Supplies"] = "일용품 상인",
    ["General Goods"] = "일용품 상인",
    ["General Goods Merchant"] = "일용품 상인",
    ["General Goods Vendor"] = "일용품 상인",
    ["General Supplies"] = "일용품 상인",
    ["General Trade Goods Merchant"] = "직업용품 상인",
    ["General Trade Goods Vendor"] = "직업용품 상인",
    ["General Trade Supplier"] = "직업용품 상인",
    ["Guild Tabard Vendor"] = "길드 휘장 상인",
    ["Gun Merchant"] = "총기류 상인",
    ["Guns Merchant"] = "총기류 상인",
    ["Guns and Ammo Merchant"] = "총기류 상인",
    ["Gunsmith"] = "총기류 상인",
    ["Healing & Sustenance"] = "식료품 상인",
    ["Heavy Armor Merchant"] = "갑옷 및 방패 상인",
    ["Herbalism & Alchemy Supplies"] = "연금술용품 상인",
    ["Herbalism Supplier"] = "연금술용품 상인",
    ["Honor Hold Quartermaster"] = "명예의 요새 병참장교",
    ["Horde Cloth Quartermaster"] = "호드 천 방어구 병참장교",
    ["Ice Cream Vendor"] = "아이스크림 상인",
    ["Innkeeper"] = "여관주인",
    ["Jewelcrafting Supplier"] = "보석세공용품 상인",
    ["Jewelcrafting Supplies Vendor"] = "보석세공용품 상인",
    ["Keepers of Time Quartermaster"] = "시간의 수호자 병참장교",
    ["Kurenai Quartermaster"] = "쿠레나이 병참장교",
    ["League of Arathor Supply Officer"] = "아라소르 연맹 병참장교",
    ["Leather & Mail Armor Merchant"] = "가죽 및 사슬 방어구 상인",
    ["Leather Armor & Leatherworking Supplies"] = "가죽 방어구 상인",
    ["Leather Armor Merchant"] = "가죽 방어구 상인",
    ["Leatherworking & Tailoring Supplies"] = "재봉용품 상인",
    ["Leatherworking Supplier"] = "가죽세공용품 상인",
    ["Leatherworking Supplies"] = "가죽세공용품 상인",
    ["Light Armor & Weapons Merchant"] = "방어구 및 무기 상인",
    ["Light Armor Merchant"] = "천 및 가죽 방어구 상인",
    ["Mace & Staff Merchant"] = "둔기 및 지팡이 상인",
    ["Mace & Staves Vendor"] = "둔기 및 지팡이 상인",
    ["Macecrafter"] = "철퇴제작자",
    ["Mag'har Quartermaster"] = "마그하르 병참장교",
    ["Mail & Plate Merchant"] = "갑옷 및 방패 상인",
    ["Mail Armor Merchant"] = "사슬 방어구 상인",
    ["Meat Vendor"] = "고기 상인",
    ["Mechanostrider Merchant"] = "기계타조 상인",
    ["Merchant"] = "마법재료 상인",
    ["Metalsmith"] = "Metalsmith",
    ["Mining Supplier"] = "채광용품 상인",
    ["Mining Supplies"] = "채광용품 상인",
    ["Mining and Smithing Supplies"] = "대장 및 채광용품 상인",
    ["Mushroom Merchant"] = "버섯 상인",
    ["Mushroom Vendor"] = "버섯 상인",
    ["Pie Vendor"] = "파이 상인",
    ["Pirate Supplies"] = "해적 애완동물 상인",
    ["Plate Armor Merchant"] = "판금 방어구 상인",
    ["Poison Supplier"] = "독극물 재료 상인",
    ["Poison Supplies"] = "독극물 재료 상인",
    ["Poison Vendor"] = "독극물 재료 상인",
    ["Potions, Scrolls & Reagents"] = "물약 및 마법용품 상인",
    ["Prairie Dog Vendor"] = "땅다람쥐 상인",
    ["Quartermaster"] = "병참 장교",
    ["Rations"] = "Rations",
    ["Reagent Merchant"] = "마법 재료 상인",
    ["Reagent Supplier"] = "마법 재료 상인",
    ["Reagent Supplies"] = "마법 재료 상인",
    ["Reagent Vendor"] = "마법 재료 상인",
    ["Reagents Vendor"] = "마법 재료 상인",
    ["Robe Merchant"] = "로브 상인",
    ["Robe Vendor"] = "로브 상인",
    ["Scrolls & Potions"] = "두루마리 및 물약 상인",
    ["Scryers: Quartermaster"] = "점술가 길드 병참장교",
    ["Shield Crafter"] = "버클러 상인",
    ["Shield Merchant"] = "방패 상인",
    ["Silverwing Supply Officer"] = "은빛날개 병참장교",
    ["Special Weapon Crafter"] = "특수 무기제작자",
    ["Specialist Tailoring Supplies"] = "특수 재봉용품 상인",
    ["Speciality Dress Maker"] = "특제 의상 상인",
    ["Speciality Tailoring Supplies"] = "특수 재봉용품 상인",
    ["Specialty Tailoring Supplies"] = "특수 재봉용품 상인",
    ["Sporeggar Quartermaster"] = "스포어가르 보급원",
    ["Staff & Mace Merchant"] = "지팡이 및 둔기 상인",
    ["Staff Merchant"] = "지팡이 상인",
    ["Staff Vendor"] = "지팡이 상인",
    ["Staves Merchant"] = "지팡이 상인",
    ["Stormpike Supply Officer"] = "스톰파이크 병참장교",
    ["Superior Armor Crafter"] = "고급 방어구 제작자",
    ["Superior Armorer"] = "고급 방어구 제작자",
    ["Superior Macecrafter"] = "고급 둔기제작자",
    ["Superior Tradesman"] = "직업용품 상인",
    ["Supplies"] = "Supplies",	--check
    ["Sword Vendor"] = "검 상인",
    ["Sword and Dagger Merchant"] = "검과 단검 상인",
    ["Tabard Vendor"] = "길드 휘장 상인",
    ["Tailoring Supplier"] = "재봉용품 상인",
    ["Tailoring Supplies"] = "재봉용품 상인",
    ["Thrallmar Quartermaster"] = "스랄마 병참장교",
    ["Thrown Weapons Merchant"] = "투척 무기 상인",
    ["Tools & Supplies"] = "독극물 재료 상인",
    ["Trade Goods"] = "직업용품 상인",
    ["Trade Goods Supplier"] = "직업용품 상인",
    ["Trade Goods Supplies"] = "직업용품 상인",
    ["Trade Goods Vendor"] = "직업용품 상인",
    ["Trade Supplier"] = "직업용품 상인",
    ["Trade Supplies"] = "직업용품 상인",
    ["Tradesman"] = "직업용품 상인",
    ["Traveling Merchant"] = "빵 행상인",
    ["Two Handed Weapon Merchant"] = "양손 무기 상인",
    ["Two-Handed Weapons Merchant"] = "양손 무기 상인",
    ["Undead Horse Merchant"] = "언데드 말 조련사",
    ["Venture Co. Merchant"] = "투자개발회사 무기 외판원",
    ["Wand Merchant"] = "마법 재료 상인",
    ["Wand Vendor"] = "마법봉 상인",
    ["Wands Merchant"] = "마법봉 상인",
    ["War Harness Maker"] = "전투 멜빵 상인",
    ["War Harness Vendor"] = "전투 멜빵 상인",
    ["Warsong Supply Officer"] = "전쟁노래 병참장교",
    ["Weapon Crafter"] = "전문 무기제작자",
    ["Weapon Merchant"] = "무기 상인",
    ["Weapon Vendor"] = "무기 상인",
    ["Weapons Merchant"] = "무기 상인",
    ["Weapons and Armor Merchant"] = "무기 및 방어구 상인",
    ["Weaponsmith"] = "무기제작자",
    ["Weaponsmith & Gunsmith"] = "무기 및 총기류 상인",
    ["Wine & Spirits Merchant"] = "와인 및 술 상인",
    ["Wine Vendor"] = "와인 상인",
} end)

BabbleVendor:RegisterTranslations("zhCN", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = "杂货军需官",
    ["Alchemy & Herbalism Supplies"] = "炼金术和草药供应商",
    ["Alchemy Supplies"] = "炼金术供应商",
    ["Alliance Cloth Quartermaster"] = "联盟布匹军需官",
    ["Alpha Gem Vendor"] = "初级宝石商人",
    ["Ammunition Vendor"] = "弹药商人",
    ["Arcane Goods Vendor"] = "魔法货物商人",
    ["Arcane Trinkets Vendor"] = "魔法饰品商人",
    ["Arena Vendor"] = "竞技场商人",
    ["Armor & Shield Merchant"] = "护甲和盾牌商人",
    ["Armor Crafter"] = "铸甲师",
    ["Armor Merchant"] = "护甲商",
    ["Armorer"] = "盔甲师",
    ["Armorsmith"] = "护甲锻造师",
    ["Armorsmith & Blacksmithing Supplies"] = "护甲锻造师和铁匠供应商",
    ["Axe Merchant"] = "斧商",
    ["Axe Vendor"] = "斧商",
    ["Bag Merchant"] = "背包商人",
    ["Bag Vendor"] = "背包商人",
    ["Bait and Tackle Supplier"] = "鱼饵和渔具",
    ["Beverage Merchant"] = "饮料商",
    ["Blacksmithing Supplier"] = "锻造供应商",
    ["Blacksmithing Supplies"] = "锻造供应商",
    ["Blacksmithing Trainer and Supplies"] = "锻造训练和供应商",
    ["Blade Merchant"] = "剑刃武器商",
    ["Blade Vendor"] = "剑刃武器商",
    ["Blunt Weapon Merchant"] = "锤类武器商",
    ["Bow & Arrow Merchant"] = "弓箭商",
    ["Bow & Gun Merchant"] = "弓箭和枪械",
    ["Bow Merchant"] = "弓箭商人",
    ["Bowyer"] = "弓箭商",
    ["Bread Merchant"] = "面包商",
    ["Bread Vendor"] = "面包商",
    ["Butcher"] = "屠夫",
    ["Cenarion Expedition Quartermaster"] = "塞纳里奥远征队军需官",
    ["Cheese Vendor"] = "起士商人",
    ["Chef"] = "厨师",
    ["Cloth & Leather Armor Merchant"] = "布甲和皮甲商人",
    ["Cloth & Leather Merchant"] = "布甲和皮甲商人",
    ["Cloth Armor Merchant"] = "布甲商",
    ["Cloth and Leather Merchant"] = "布甲和皮甲商人",
    ["Cockroach Vendor"] = "蟑螂商人",
    ["Consortium Quartermaster"] = "联合团军需官",
    ["Cooking Supplier"] = "烹饪供应商",
    ["Cooking Supplies"] = "烹饪供应商",
    ["Cooking Trainer and Supplies"] = "烹饪训练师和供应商",
    ["Dagger Vendor"] = "匕首商人",
    ["Darkmoon Faire Drink Vendor"] = "暗月马戏团饮料商",
    ["Darkmoon Faire Food Vendor"] = "暗月马戏团食品商",
    ["Defilers Supply Officer"] = "污染者军需官",
    ["Drink Vendor"] = "饮料商人",
    ["Enchanting Supplier"] = "附魔供应商",
    ["Enchanting Supplies"] = "附魔供应商",
    ["Enchanting Vendor"] = "附魔供应商",
    ["Engineering & General Goods Supplier"] = "工程学和杂货供应商",
    ["Engineering Supplier"] = "工程学供应商",
    ["Engineering Supplies"] = "工程学供应商",
    ["Engineering and Mining Supplies"] = "工程学和采矿供应商",
    ["Exotic Reagent Merchant"] = "奇特试剂商人",
    ["Fireworks Merchant"] = "烟火商人",
    ["Fireworks Vendor"] = "烟火商人",
    ["Fish Merchant"] = "鱼商",
    ["Fish Merchant & Supplies"] = "鱼商",
    ["Fish Vendor"] = "鱼商",
    ["Fisherman Supplies"] = "渔具供应商",
    ["Fishing Supplier"] = "渔具供应商",
    ["Fishing Supplies"] = "渔具供应商",
    ["Fishing Trainer & Supplies"] = "钓鱼训练师和供应商",
    ["Food & Drink Merchant"] = "食物和饮料商人",
    ["Food & Drink Vendor"] = "食物和饮料商人",
    ["Food Vendor"] = "食物商人",
    ["Food and Drink"] = "食物和饮料商人",
    ["Food & Drink"] = "食物和饮料商人",
    ["Free Wheeling Merchant"] = "旅行商人",
    ["Frostwolf Supply Officer"] = "霜狼军需官",
    ["Fruit Vendor"] = "水果商",
    ["Fungus Vendor"] = "蘑菇商人",
    ["Gem Vendor"] = "宝石商",
    ["General & Trade Supplies"] = "杂货商",
    ["General Goods"] = "杂货商",
    ["General Goods Merchant"] = "杂货商",
    ["General Goods Vendor"] = "杂货商",
    ["General Supplies"] = "杂货供应商",
    ["General Trade Goods Merchant"] = "杂货供应商",
    ["General Trade Goods Vendor"] = "杂货供应商",
    ["General Trade Supplier"] = "杂货供应商",
    ["Guild Tabard Vendor"] = "公会徽章商人",
    ["Gun Merchant"] = "枪械商",
    ["Guns Merchant"] = "枪械商",
    ["Guns and Ammo Merchant"] = "枪械和弹药商",
    ["Gunsmith"] = "枪械商",
    ["Healing & Sustenance"] = "治疗与看护",
    ["Heavy Armor Merchant"] = "重甲商",
    ["Herbalism & Alchemy Supplies"] = "草药学和炼金术供应商",
    ["Herbalism Supplier"] = "草药学供应商",
    ["Honor Hold Quartermaster"] = "荣誉堡军需官",
    ["Horde Cloth Quartermaster"] = "部落布匹军需官",
    ["Ice Cream Vendor"] = "冰淇淋商人",
    ["Innkeeper"] = "旅店老板",
    ["Jewelcrafting Supplier"] = "珠宝加工供应商",
    ["Jewelcrafting Supplies Vendor"] = "珠宝加工供应商",
    ["Keepers of Time Quartermaster"] = "时间守护者军需官",
    ["Kurenai Quartermaster"] = "卡尔奈军需官",
    ["League of Arathor Supply Officer"] = "阿拉索联军军需官",
    ["Leather & Mail Armor Merchant"] = "皮货和护甲商",
    ["Leather Armor & Leatherworking Supplies"] = "制皮师",
    ["Leather Armor Merchant"] = "皮甲商",
    ["Leatherworking & Tailoring Supplies"] = "制皮供应商",
    ["Leatherworking Supplier"] = "制皮供应商",
    ["Leatherworking Supplies"] = "制皮供应商",
    ["Light Armor & Weapons Merchant"] = "轻甲商",
    ["Light Armor Merchant"] = "轻甲商",
    ["Mace & Staff Merchant"] = "锤和法杖商人",
    ["Mace & Staves Vendor"] = "锤和法杖商人",
    ["Macecrafter"] = "制锤师",
    ["Mag'har Quartermaster"] = "玛格哈军需官",
    ["Mail & Plate Merchant"] = "锁甲和铠甲商人",
    ["Mail Armor Merchant"] = "锁甲商",
    ["Meat Vendor"] = "肉商",
    ["Mechanostrider Merchant"] = "机械陆行鸟商人",
    ["Merchant"] = "商人",
    ["Metalsmith"] = "金属匠",--need check
    ["Mining Supplier"] = "采矿供应商",
    ["Mining Supplies"] = "采矿供应商",
    ["Mining and Smithing Supplies"] = "采矿和铁匠供应商",
    ["Mushroom Merchant"] = "蘑菇商",
    ["Mushroom Vendor"] = "蘑菇商",
    ["Pie Vendor"] = "馅饼商人",
    ["Pirate Supplies"] = "海盗商人",
    ["Plate Armor Merchant"] = "板甲商人",  --fix
    ["Poison Supplier"] = "毒药商",
    ["Poison Supplies"] = "毒药商",
    ["Poison Vendor"] = "毒药商",
    ["Potions, Scrolls & Reagents"] = "毒药卷轴材料商",--check
    ["Prairie Dog Vendor"] = "草原土拨鼠商人",
    ["Quartermaster"] = "军需官",
    ["Rations"] = "乾粮",
    ["Reagent Merchant"] = "施法材料商",
    ["Reagent Supplier"] = "施法材料供应商",
    ["Reagent Supplies"] = "施法材料供应商",
    ["Reagent Vendor"] = "施法材料商",
    ["Reagents Vendor"] = "施法材料商",
    ["Robe Merchant"] = "长袍商",
    ["Robe Vendor"] = "长袍商",
    ["Scrolls & Potions"] = "卷轴和药剂",
    ["Scryers: Quartermaster"] = "占卜者:军需官",
    ["Shield Crafter"] = "铸盾师",
    ["Shield Merchant"] = "盾牌商",
    ["Silverwing Supply Officer"] = "银翼军需官",
    ["Special Weapon Crafter"] = "特殊武器商",
    ["Specialist Tailoring Supplies"] = "特殊裁缝物资",
    ["Speciality Dress Maker"] = "特殊服装商人",
    ["Speciality Tailoring Supplies"] = "特殊裁缝物资",
    ["Specialty Tailoring Supplies"] = "裁缝供应商",
    ["Sporeggar Quartermaster"] = "斯博格尔粮食供应者",
    ["Staff & Mace Merchant"] = "法杖和铸锤商",
    ["Staff Merchant"] = "法杖商",
    ["Staff Vendor"] = "法杖商",
    ["Staves Merchant"] = "法杖商",
    ["Stormpike Supply Officer"] = "雷矛军需官",
    ["Superior Armor Crafter"] = "高级铸甲师",
    ["Superior Armorer"] = "高级盔甲师",
    ["Superior Macecrafter"] = "高级造锤师",
    ["Superior Tradesman"] = "高级商人",
    ["Supplies"] = "供给物",
    ["Sword Vendor"] = "剑商人",
    ["Sword and Dagger Merchant"] = "剑和匕首商人",
    ["Tabard Vendor"] = "公会徽章商人",
    ["Tailoring Supplier"] = "裁缝供应商",
    ["Tailoring Supplies"] = "裁缝供应商",
    ["Thrallmar Quartermaster"] = "索尔玛军需官",
    ["Thrown Weapons Merchant"] = "投掷武器商人",
    ["Tools & Supplies"] = "工具和补给品",
    ["Trade Goods"] = "商人",
    ["Trade Goods Supplier"] = "商人",
    ["Trade Goods Supplies"] = "商人",
    ["Trade Goods Vendor"] = "交易商人",
    ["Trade Supplier"] = "商人",
    ["Trade Supplies"] = "商人",
    ["Tradesman"] = "商人",
    ["Traveling Merchant"] = "旅行商人",
    ["Two Handed Weapon Merchant"] = "双手武器商人",
    ["Two-Handed Weapons Merchant"] = "双手武器商人",
    ["Undead Horse Merchant"] = "亡灵马商人",
    ["Venture Co. Merchant"] = "风险投资公司商人",
    ["Wand Merchant"] = "魔杖商人",
    ["Wand Vendor"] = "魔杖商人",
    ["Wands Merchant"] = "魔杖商人",
    ["War Harness Maker"] = "护甲商",
    ["War Harness Vendor"] = "护甲商",
    ["Warsong Supply Officer"] = "战歌军需官",
    ["Weapon Crafter"] = "武器铸造师",
    ["Weapon Merchant"] = "武器商",
    ["Weapon Vendor"] = "武器商",
    ["Weapons Merchant"] = "武器商",
    ["Weapons and Armor Merchant"] = "武器和防具商人",
    ["Weaponsmith"] = "武器铸造师",
    ["Weaponsmith & Gunsmith"] = "武器和枪械商",
    ["Wine & Spirits Merchant"] = "酒和烈酒商人",
    ["Wine Vendor"] = "酒商",
} end)

BabbleVendor:RegisterTranslations("zhTW", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = "雜貨軍需官",
    ["Alchemy & Herbalism Supplies"] = "鍊金術和草藥供應商",
    ["Alchemy Supplies"] = "鍊金術供應商",
    ["Alliance Cloth Quartermaster"] = "聯盟布匹軍需官",
    ["Alpha Gem Vendor"] = "初級寶石商人",
    ["Ammunition Vendor"] = "彈藥商人",
    ["Arcane Goods Vendor"] = "魔法貨物商人",
    ["Arcane Trinkets Vendor"] = "魔法飾品商人",
    ["Arena Vendor"] = "競技場商人",
    ["Armor & Shield Merchant"] = "護甲和盾牌商人",
    ["Armor Crafter"] = "鑄甲師",
    ["Armor Merchant"] = "護甲商",
    ["Armorer"] = "護甲商",
    ["Armorsmith"] = "護甲鍛造師",
    ["Armorsmith & Blacksmithing Supplies"] = "護甲鍛造師和鐵匠供應商",
    ["Arrow Merchant"] = "弓箭商",
    ["Axe Merchant"] = "斧商",
    ["Axe Vendor"] = "斧商",
    ["Bag Merchant"] = "背包商人",
    ["Bag Vendor"] = "背包商人",
    ["Bait and Tackle Supplier"] = "魚餌和漁具",
    ["Beverage Merchant"] = "飲料商",
    ["Blacksmithing Supplier"] = "鍛造供應商",
    ["Blacksmithing Supplies"] = "鍛造供應商",
    ["Blacksmithing Trainer and Supplies"] = "鍛造訓練和供應商",
    ["Blade Merchant"] = "劍刃武器商",
    ["Blade Vendor"] = "劍刃武器商",
    ["Blunt Weapon Merchant"] = "錘類武器商",
    ["Bow & Arrow Merchant"] = "弓箭商",
    ["Bow & Gun Merchant"] = "弓箭和槍械",
    ["Bow Merchant"] = "弓箭商人",
    ["Bowyer"] = "弓箭商",
    ["Bread Merchant"] = "麵包商",
    ["Bread Vendor"] = "麵包商",
    ["Butcher"] = "屠夫",
    ["Cenarion Expedition Quartermaster"] = "塞納里奧遠征隊軍需官",
    ["Cheese Vendor"] = "起士商人",
    ["Chef"] = "廚師",
    ["Cloth & Leather Armor Merchant"] = "布甲和皮甲商人",
    ["Cloth & Leather Merchant"] = "布甲和皮甲商人",
    ["Cloth Armor Merchant"] = "布甲商",
    ["Cloth and Leather Merchant"] = "布甲和皮甲商人",
    ["Cockroach Vendor"] = "蟑螂商人",
    ["Consortium Quartermaster"] = "聯合團軍需官",
    ["Cooking Supplier"] = "烹飪供應商",
    ["Cooking Supplies"] = "烹飪供應商",
    ["Cooking Trainer and Supplies"] = "烹飪訓練師和供應商",
    ["Dagger Vendor"] = "匕首商人",
    ["Darkmoon Faire Drink Vendor"] = "暗月馬戲團飲料商",
    ["Darkmoon Faire Food Vendor"] = "暗月馬戲團食品商",
    ["Defilers Supply Officer"] = "污染者軍需官",
    ["Drink Vendor"] = "飲料商人",
    ["Enchanting Supplier"] = "附魔供應商",
    ["Enchanting Supplies"] = "附魔供應商",
    ["Enchanting Vendor"] = "附魔供應商",
    ["Engineering & General Goods Supplier"] = "工程學和雜貨供應商",
    ["Engineering Supplier"] = "工程學供應商",
    ["Engineering Supplies"] = "工程學供應商",
    ["Engineering and Mining Supplies"] = "工程學和採礦供應商",
    ["Exotic Reagent Merchant"] = "奇特試劑商人",
    ["Fireworks Merchant"] = "煙火商人",
    ["Fireworks Vendor"] = "煙火商人",
    ["Fish Merchant"] = "魚商",
    ["Fish Merchant & Supplies"] = "魚商",
    ["Fish Vendor"] = "魚商",
    ["Fisherman Supplies"] = "漁具供應商",
    ["Fishing Supplier"] = "漁具供應商",
    ["Fishing Supplies"] = "漁具供應商",
    ["Fishing Trainer & Supplies"] = "釣魚訓練師和供應商",
    ["Food & Drink Merchant"] = "食物和飲料商人",
    ["Food & Drink Vendor"] = "食物和飲料商人",
    ["Food Vendor"] = "食物商人",
    ["Food and Drink"] = "食物和飲料商人",
    ["Food & Drink"] = "食物和飲料商人",
    ["Free Wheeling Merchant"] = "旅行商人",
    ["Frostwolf Supply Officer"] = "霜狼軍需官",
    ["Fruit Vendor"] = "水果商",
    ["Fungus Vendor"] = "蘑菇商人",
    ["Gem Vendor"] = "寶石商",
    ["General & Trade Supplies"] = "雜貨商",
    ["General Goods"] = "雜貨商",
    ["General Goods Merchant"] = "雜貨商",
    ["General Goods Vendor"] = "雜貨商",
    ["General Supplies"] = "雜貨供應商",
    ["General Trade Goods Merchant"] = "雜貨供應商",
    ["General Trade Goods Vendor"] = "雜貨供應商",
    ["General Trade Supplier"] = "雜貨供應商",
    ["Guild Tabard Vendor"] = "公會徽章商人",
    ["Gun Merchant"] = "槍械商",
    ["Guns Merchant"] = "槍械商",
    ["Guns and Ammo Merchant"] = "槍械和彈藥商",
    ["Gunsmith"] = "槍械商",
    ["Healing & Sustenance"] = "治療與看護",
    ["Heavy Armor Merchant"] = "重甲商",
    ["Herbalism & Alchemy Supplies"] = "草藥學和鍊金術供應商",
    ["Herbalism Supplier"] = "草藥學供應商",
    ["Honor Hold Quartermaster"] = "榮譽堡軍需官",
    ["Horde Cloth Quartermaster"] = "部落布匹軍需官",
    ["Hunting Supplies"] = "Hunting Supplies",
    ["Ice Cream Vendor"] = "冰淇淋商人",
    ["Innkeeper"] = "旅店老闆",
    ["Jewelcrafting Supplier"] = "寶石設計供應商",
    ["Jewelcrafting Supplies Vendor"] = "寶石設計供應商",
    ["Keepers of Time Quartermaster"] = "時間守護者軍需官",
    ["Kurenai Quartermaster"] = "卡爾奈軍需官",
    ["League of Arathor Supply Officer"] = "阿拉索聯軍軍需官",
    ["Leather & Mail Armor Merchant"] = "皮貨和護甲商",
    ["Leather Armor & Leatherworking Supplies"] = "製皮師",
    ["Leather Armor Merchant"] = "皮甲商",
    ["Leatherworking & Tailoring Supplies"] = "製皮供應商",
    ["Leatherworking Supplier"] = "製皮供應商",
    ["Leatherworking Supplies"] = "製皮供應商",
    ["Light Armor & Weapons Merchant"] = "輕甲商",
    ["Light Armor Merchant"] = "輕甲商",
    ["Mace & Staff Merchant"] = "錘和法杖商人",
    ["Mace & Staves Vendor"] = "錘和法杖商人",
    ["Macecrafter"] = "製錘師",
    ["Mag'har Quartermaster"] = "瑪格哈軍需官",
    ["Mail & Plate Merchant"] = "鎖甲和鎧甲商人",
    ["Mail Armor Merchant"] = "鎖甲商",
    ["Meat Vendor"] = "肉商",
    ["Mechanostrider Merchant"] = "機械陸行鳥商人",
    ["Merchant"] = "商人",
    ["Metalsmith"] = "鐵匠",
    ["Mining Supplier"] = "採礦供應商",
    ["Mining Supplies"] = "採礦供應商",
    ["Mining and Smithing Supplies"] = "採礦和鐵匠供應商",
    ["Mushroom Merchant"] = "蘑菇商",
    ["Mushroom Vendor"] = "蘑菇商",
    ["Pie Vendor"] = "餡餅商人",
    ["Pirate Supplies"] = "海盜商人",
    ["Plate Armor Merchant"] = "鎧甲商",
    ["Poison Supplier"] = "毒藥商",
    ["Poison Supplies"] = "毒藥商",
    ["Poison Vendor"] = "毒藥商",
    ["Potions, Scrolls & Reagents"] = "藥劑、卷軸和施法材料",
    ["Prairie Dog Vendor"] = "草原土撥鼠商人",
    ["Quartermaster"] = "軍需官",
    ["Rations"] = "乾糧",
    ["Reagent Merchant"] = "施法材料商",
    ["Reagent Supplier"] = "施法材料供應商",
    ["Reagent Supplies"] = "施法材料供應商",
    ["Reagent Vendor"] = "施法材料商",
    ["Reagents Vendor"] = "施法材料商",
    ["Robe Merchant"] = "長袍商",
    ["Robe Vendor"] = "長袍商",
    ["Scrolls & Potions"] = "卷軸和藥劑",
    ["Scryers: Quartermaster"] = "占卜者:軍需官",
    ["Shield Crafter"] = "鑄盾師",
    ["Shield Merchant"] = "盾牌商",
    ["Silverwing Supply Officer"] = "銀翼軍需官",
    ["Special Weapon Crafter"] = "特殊武器商",
    ["Specialist Tailoring Supplies"] = "特殊裁縫物資",
    ["Speciality Dress Maker"] = "特殊服裝商人",
    ["Speciality Tailoring Supplies"] = "特殊裁縫物資",
    ["Specialty Tailoring Supplies"] = "裁縫供應商",
    ["Sporeggar Quartermaster"] = "斯博格爾糧食供應者",
    ["Staff & Mace Merchant"] = "法杖和鑄錘商",
    ["Staff Merchant"] = "法杖商",
    ["Staff Vendor"] = "法杖商",
    ["Staves Merchant"] = "法杖商",
    ["Stormpike Supply Officer"] = "雷矛軍需官",
    ["Superior Armor Crafter"] = "高級鑄甲師",
    ["Superior Armorer"] = "高級鑄甲師",
    ["Superior Macecrafter"] = "高級造錘師",
    ["Superior Tradesman"] = "高級商人",
    ["Supplies"] = "供給物",
    ["Sword Vendor"] = "劍商人",
    ["Sword and Dagger Merchant"] = "劍和匕首商人",
    ["Tabard Vendor"] = "公會徽章商人",
    ["Tailoring Supplier"] = "裁縫供應商",
    ["Tailoring Supplies"] = "裁縫供應商",
    ["Thrallmar Quartermaster"] = "索爾瑪軍需官",
    ["Thrown Weapons Merchant"] = "投擲武器商人",
    ["Tools & Supplies"] = "工具和補給品",
    ["Trade Goods"] = "商人",
    ["Trade Goods Supplier"] = "商人",
    ["Trade Goods Supplies"] = "商人",
    ["Trade Goods Vendor"] = "交易商人",
    ["Trade Supplier"] = "商人",
    ["Trade Supplies"] = "商人",
    ["Tradesman"] = "商人",
    ["Traveling Merchant"] = "旅行商人",
    ["Two Handed Weapon Merchant"] = "雙手武器商人",
    ["Two-Handed Weapons Merchant"] = "雙手武器商人",
    ["Undead Horse Merchant"] = "亡靈馬商人",
    ["Venture Co. Merchant"] = "風險投資公司商人",
    ["Wand Merchant"] = "魔杖商人",
    ["Wand Vendor"] = "魔杖商人",
    ["Wands Merchant"] = "魔杖商人",
    ["War Harness Maker"] = "護甲商",
    ["War Harness Vendor"] = "護甲商",
    ["Warsong Supply Officer"] = "戰歌軍需官",
    ["Weapon Crafter"] = "武器鑄造師",
    ["Weapon Merchant"] = "武器商",
    ["Weapon Vendor"] = "武器商",
    ["Weapons Merchant"] = "武器商",
    ["Weapons and Armor Merchant"] = "武器和防具商人",
    ["Weaponsmith"] = "武器鑄造師",
    ["Weaponsmith & Gunsmith"] = "武器和槍械",
    ["Wine & Spirits Merchant"] = "酒和烈酒商人",
    ["Wine Vendor"] = "酒商",
} end)

BabbleVendor:RegisterTranslations("esES", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = "Oficial intendente de accesorios",
    ["Alchemy & Herbalism Supplies"] = "Suministros de alquimia y herboristería",
    ["Alchemy Supplies"] = "Suministros de alquimia",
    ["Alliance Cloth Quartermaster"] = "Intendente de género de la Alianza",
    ["Alpha Gem Vendor"] = "Vendedor de gemas alfa",  -- fix
    ["Ammunition Vendor"] = "Vendedor de munición",
    ["Arcane Goods Vendor"] = "Vendedor de artículos Arcanos",
    ["Arcane Trinkets Vendor"] = "Vendedor de abalorios Arcanos",
    ["Arena Vendor"] = "Vendedor de arena",
    ["Armor & Shield Merchant"] = "Mercader de armaduras y escudos",
    ["Armor Crafter"] = "Artesano armero",
    ["Armor Merchant"] = "Mercader de armaduras",
    ["Armorer"] = "Armorer",
    ["Armorsmith"] = "Forjador de armaduras",
    ["Armorsmith & Blacksmithing Supplies"] = "Suministros de herrería y forja de armaduras",
    ["Arrow Merchant"] = "Mercader de flechas",
    ["Axe Merchant"] = "Mercader de hachas",
    ["Axe Vendor"] = "Vendedor de hachas",
    ["Bag Merchant"] = "Mercader de bolsas",
    ["Bag Vendor"] = "Vendedor de bolsas",
    ["Bait and Tackle Supplier"] = "Proveedor de anzuelos y aparejos",
    ["Beverage Merchant"] = "Mercader de bebidas",
    ["Blacksmithing Supplier"] = "Proveedor de herrería",
    ["Blacksmithing Supplies"] = "Suministros de herrería",
    ["Blacksmithing Trainer and Supplies"] = "Instructor de herrería y suministros",
    ["Blade Merchant"] = "Mercader de armas blancas",
    ["Blade Vendor"] = "Vendedor de armas blancas",
    ["Blunt Weapon Merchant"] = "Mercader de armas contundentes",
    ["Bow & Arrow Merchant"] = "Mercader de arcos y flechas",
    ["Bow & Gun Merchant"] = "Mercader de arcos y armas de fuego",
    ["Bow Merchant"] = "Mercader de arcos",
    ["Bowyer"] = "Fabricante de arcos",
    ["Bread Merchant"] = "Mercader de pan",
    ["Bread Vendor"] = "Vendedora de pan",
    ["Butcher"] = "Carnicero",
    ["Cenarion Expedition Quartermaster"] = "Intendente de la expedición de Cenarion",
    ["Cheese Vendor"] = "Vendedor de quesos",
    ["Chef"] = "Chef",
    ["Cloth & Leather Armor Merchant"] = "Mercader de armaduras de tela y cuero",
    ["Cloth & Leather Merchant"] = "Mercader de tela y cuero",
    ["Cloth Armor Merchant"] = "Mercader de armaduras de tela",
    ["Cloth and Leather Merchant"] = "Mercader de tela y cuero",
    ["Cockroach Vendor"] = "Vendedor de cucarachas",
    ["Consortium Quartermaster"] = "Intendente del Consorcio",
    ["Cooking Supplier"] = "Proveedor de artículos de cocina",
    ["Cooking Supplies"] = "Suministros de cocina",
    ["Cooking Trainer and Supplies"] = "Instructor de cocina y suministros",
    ["Dagger Vendor"] = "Vendedor de dagas",
    ["Darkmoon Faire Drink Vendor"] = "Vendedor de bebidas de la Feria de la Luna Negra",
    ["Darkmoon Faire Food Vendor"] = "Vendedor de alimentos de la Feria de la Luna Negra",
    ["Defilers Supply Officer"] = "Oficial de suministros de los Rapiñadores",
    ["Drink Vendor"] = "Vendedor de bebidas",
    ["Enchanting Supplier"] = "Proveedor de objetos de encantamiento",
    ["Enchanting Supplies"] = "Objetos de encantamiento",
    ["Enchanting Vendor"] = "Proveedor de objetos de encantamiento",
    ["Engineering & General Goods Supplier"] = "Proveedor de artículos de ingeniería y objetos diversos",
    ["Engineering Supplier"] = "Proveedor de ingeniería",
    ["Engineering Supplies"] = "Suministros de ingeniería",
    ["Engineering and Mining Supplies"] = "Suministros de ingeniería y minería",
    ["Exotic Reagent Merchant"] = "Mercader de componentes exóticos",
    ["Fireworks Merchant"] = "Mercader de cohetes pirotécnicos",
    ["Fireworks Vendor"] = "Vendedor de cohetes pirotécnicos",
    ["Fish Merchant"] = "Mercader de pescado",
    ["Fish Merchant & Supplies"] = "Mercader y suministros de pesca",
    ["Fish Vendor"] = "Vendedor de pescado",
    ["Fisherman Supplies"] = "Suministros de pesca",
    ["Fishing Supplier"] = "Proveedor de pescadería",
    ["Fishing Supplies"] = "Suministros de pesca",
    ["Fishing Trainer & Supplies"] = "Instructor de pesca y suministros",
    ["Food & Drink Merchant"] = "Mercader de alimentos y bebidas",
    ["Food & Drink Vendor"] = "Vendedor de alimentos y bebidas",
    ["Food Vendor"] = "Vendedor de alimentos",
    ["Food and Drink"] = "Alimentos y bebidas",
    ["Food & Drink"] = "Alimentos y bebidas",
    ["Free Wheeling Merchant"] = "Mercader alocado",
    ["Frostwolf Supply Officer"] = "Oficial de suministros Lobo Gélido",
    ["Fruit Vendor"] = "Vendedor de frutas",
    ["Fungus Vendor"] = "Vendedor de hongos",
    ["Gem Vendor"] = "Vendedor de gemas",
    ["General & Trade Supplies"] = "Suministros generales y objetos comerciables",
    ["General Goods"] = "Pertrechos",
    ["General Goods Merchant"] = "Mercader de pertrechos",
    ["General Goods Vendor"] = "Vendedor de pertrechos",
    ["General Supplies"] = "Suministros generales",
    ["General Trade Goods Merchant"] = "Mercader de pertrechos",
    ["General Trade Goods Vendor"] = "Vendedor de pertrechos",
    ["General Trade Supplier"] = "Proveedor de mercancías",
    ["Guild Tabard Vendor"] = "Vendedor de tabardos de hermandad",
    ["Gun Merchant"] = "Mercader de armas de fuego",
    ["Guns Merchant"] = "Mercader de armas de fuego",
    ["Guns and Ammo Merchant"] = "Mercader de armas de fuego y munición",
    ["Gunsmith"] = "Forjador de armas de fuego",
    ["Healing & Sustenance"] = "Sanación y sustento",
    ["Heavy Armor Merchant"] = "Mercader de armaduras pesadas",
    ["Herbalism & Alchemy Supplies"] = "Suministros de herboristería y alquimia",
    ["Herbalism Supplier"] = "Proveedor de herboristería",
    ["Honor Hold Quartermaster"] = "Intendente del Bastión del Honor",
    ["Horde Cloth Quartermaster"] = "Intendente de género de la Horda",
    ["Hunting Supplies"] = "Suministros de caza",
    ["Ice Cream Vendor"] = "Vendedor de helados",
    ["Innkeeper"] = "Tabernero",
    ["Jewelcrafting Supplier"] = "Proveedor de joyería",
    ["Jewelcrafting Supplies Vendor"] = "Vendedor de suministros de joyería",
    ["Keepers of Time Quartermaster"] = "Intendente de los vigilantes del tiempo",
    ["Kurenai Quartermaster"] = "Intendente Kurenai",
    ["League of Arathor Supply Officer"] = "Oficial de suministros de la Liga de Arathor",
    ["Leather & Mail Armor Merchant"] = "Mercader de armaduras de cuero y malla",
    ["Leather Armor & Leatherworking Supplies"] = "Suministros para armaduras de cuero y peletería",
    ["Leather Armor Merchant"] = "Mercader de armaduras de cuero",
    ["Leatherworking & Tailoring Supplies"] = "Suministros de peletería y sastrería",
    ["Leatherworking Supplier"] = "Proveedor de peletería",
    ["Leatherworking Supplies"] = "Suministros de peletería",
    ["Light Armor & Weapons Merchant"] = "Mercader de armaduras ligeras y armas",
    ["Light Armor Merchant"] = "Mercader de armaduras ligeras",
    ["Mace & Staff Merchant"] = "Mercader de mazas y bastones",
    ["Mace & Staves Vendor"] = "Vendedor de mazas y bastones",
    ["Macecrafter"] = "Vendedor de mazas",
    ["Mag'har Quartermaster"] = "Intendente Mag'har",
    ["Mail & Plate Merchant"] = "Mercader de mallas y placas",
    ["Mail Armor Merchant"] = "Mercader de armaduras",
    ["Meat Vendor"] = "Vendedor de carne",
    ["Mechanostrider Merchant"] = "Mercader de Mecazancudos",
    ["Merchant"] = "Mercader",
    ["Metalsmith"] = "Metalsmith", -- need check
    ["Mining Supplier"] = "Proveedor de minería",
    ["Mining Supplies"] = "Suministros de minería",
    ["Mining and Smithing Supplies"] = "Suministros de minería y herrería",
    ["Mushroom Merchant"] = "Mercader de champiñones",
    ["Mushroom Vendor"] = "Vendedor de champiñones",
    ["Pie Vendor"] = "Vendedor de tartas",
    ["Pirate Supplies"] = "Suministros para piratas",
    ["Plate Armor Merchant"] = "Mercader de armadura de placas",
    ["Poison Supplier"] = "Proveedor de venenos",
    ["Poison Supplies"] = "Suministros para venenos",
    ["Poison Vendor"] = "Vendedor de venenos",
    ["Potions, Scrolls & Reagents"] = "Potions, Scrolls & Reagents",
    ["Prairie Dog Vendor"] = "Vendedor de perros de pradera",
    ["Quartermaster"] = "Intendente",
    ["Rations"] = "Raciones",
    ["Reagent Merchant"] = "Mercader de componentes",
    ["Reagent Supplier"] = "Proveedor de componentes",
    ["Reagent Supplies"] = "Suministros de componentes",
    ["Reagent Vendor"] = "Vendedor de componentes",
    ["Reagents Vendor"] = "Vendedor de componentes",
    ["Robe Merchant"] = "Mercader de túnicas",
    ["Robe Vendor"] = "Vendedor de túnicas",
    ["Scrolls & Potions"] = "Pergaminos y pociones",
    ["Scryers: Quartermaster"] = "Arúspices: Intendente",
    ["Shield Crafter"] = "Artesano de escudos",
    ["Shield Merchant"] = "Mercader de escudos",
    ["Silverwing Supply Officer"] = "Oficial de suministros de Ala de Plata",
    ["Special Weapon Crafter"] = "Artesano de armas especiales",
    ["Specialist Tailoring Supplies"] = "Suministros de sastrería especializada",
    ["Speciality Dress Maker"] = "Alfayate de prendas especiales",
    ["Speciality Tailoring Supplies"] = "Suministros de sastrería especializada",
    ["Specialty Tailoring Supplies"] = "Suministros de sastrería especializada",
    ["Sporeggar Quartermaster"] = "Intendente de Esporaggar",
    ["Staff & Mace Merchant"] = "Mercader de bastones y mazas",
    ["Staff Merchant"] = "Mercader de bastones",
    ["Staff Vendor"] = "Vendedor de bastones",
    ["Staves Merchant"] = "Mercader de bastones",
    ["Stormpike Supply Officer"] = "Oficial de suministros Pico Tormenta",
    ["Superior Armor Crafter"] = "Artesano armero superior",
    ["Superior Armorer"] = "Superior Armorer",
    ["Superior Macecrafter"] = "Fabricante de mazas superior",
    ["Superior Tradesman"] = "Mercader superior",
    ["Supplies"] = "Suministros",
    ["Sword Vendor"] = "Vendedor de espadas",
    ["Sword and Dagger Merchant"] = "Mercader de espadas y puñales",
    ["Tabard Vendor"] = "Vendedor de tabardos",
    ["Tailoring Supplier"] = "Proveedor de sastrería",
    ["Tailoring Supplies"] = "Suministros de sastrería",
    ["Thrallmar Quartermaster"] = "Intendente de Thrallmar",
    ["Thrown Weapons Merchant"] = "Mercader de armas arrojadizas",
    ["Tools & Supplies"] = "Herramientas y suministros",
    ["Trade Goods"] = "Objetos comerciables",
    ["Trade Goods Supplier"] = "Proveedor de objetos comerciables",
    ["Trade Goods Supplies"] = "Suministros de objetos comerciables",
    ["Trade Goods Vendor"] = "Vendedor de pertrechos",
    ["Trade Supplier"] = "Proveedor comercial",
    ["Trade Supplies"] = "Suministros comerciales",
    ["Tradesman"] = "Mercader",
    ["Traveling Merchant"] = "Viajante",
    ["Two Handed Weapon Merchant"] = "Mercader de armas de dos manos",
    ["Two-Handed Weapons Merchant"] = "Mercader de armas de dos manos",
    ["Undead Horse Merchant"] = "Mercader de caballos no-muerto",
    ["Venture Co. Merchant"] = "Mercader de Ventura y Cía.",
    ["Wand Merchant"] = "Mercader de varitas",
    ["Wand Vendor"] = "Vendedor de varitas",
    ["Wands Merchant"] = "Mercader de varitas",
    ["War Harness Maker"] = "Fabricante de arneses de guerra",
    ["War Harness Vendor"] = "Vendedor de arneses de guerra",
    ["Warsong Supply Officer"] = "Oficial de suministros Grito de Guerra",
    ["Weapon Crafter"] = "Artesano de armas",
    ["Weapon Merchant"] = "Mercader de armas",
    ["Weapon Vendor"] = "Vendedor de armas",
    ["Weapons Merchant"] = "Mercader de armas",
    ["Weapons and Armor Merchant"] = "Mercader de armaduras y armas",
    ["Weaponsmith"] = "Forjador de armas",
    ["Weaponsmith & Gunsmith"] = "Weaponsmith & Gunsmith",
    ["Wine & Spirits Merchant"] = "Mercader de vinos y licores",
    ["Wine Vendor"] = "Vendedor de vinos",
} end)
-- Translater: GriffonHeart (Updater: StingerSoft)
BabbleVendor:RegisterTranslations("ruRU", function() return {
    -- Vendor types
    ["Accessories Quartermaster"] = "Начальник снабжения товарами",
    ["Alchemy & Herbalism Supplies"] = "Все для алхимиков и травников",
    ["Alchemy Supplies"] = "Алхимические припасы",
    ["Alliance Cloth Quartermaster"] = "Начальник снабжения одеяний Альянса",
    ["Alpha Gem Vendor"] = "Продавец альфа-самоцветов",
    ["Ammunition Vendor"] = "Продавец боеприпасов",
    ["Arcane Goods Vendor"] = "Продавец чародейских товаров",
    ["Arcane Trinkets Vendor"] = "Продавец чародейских аксессуаров",
    ["Arena Vendor"] = "Продавец Арены",
    ["Armor & Shield Merchant"] = "Торговец доспехами и щитами",
    ["Armor Crafter"] = "Бронник",
    ["Armor Merchant"] = "Торговец доспехами",
    ["Armorer"] = "Бронник",
    ["Armorsmith"] = "Бронник",
    ["Armorsmith & Blacksmithing Supplies"] = "Припасы для кузнецов и бронников",
    ["Arrow Merchant"] = "Торговец стрелами",
    ["Axe Merchant"] = "Торговец топорами",
    ["Axe Vendor"] = "Продавец топоров",
    ["Bag Merchant"] = "Торговец сумками",
    ["Bag Vendor"] = "Продавец сумок",
    ["Bait and Tackle Supplier"] = "Bait and Tackle Supplier",
    ["Beverage Merchant"] = "Торговец напитками",
    ["Blacksmithing Supplier"] = "Поставщик товаров кузнечного дела",
    ["Blacksmithing Supplies"] = "Товары для кузнецов",
    ["Blacksmithing Trainer and Supplies"] = "Кузнечное дело: обучение и товары",
    ["Blade Merchant"] = "Торговец клинками",
    ["Blade Vendor"] = "Продавец клинкового оружия",
    ["Blunt Weapon Merchant"] = "Торговец ударным оружием",
    ["Bow & Arrow Merchant"] = "Торговец луками и стрелами",
    ["Bow & Gun Merchant"] = "Торговец стрелковым оружием",
    ["Bow Merchant"] = "Торговец луками",
    ["Bowyer"] = "Торговец луками",
    ["Bread Merchant"] = "Пекарь",
    ["Bread Vendor"] = "Продавец хлеба",
    ["Butcher"] = "Мясник",
    ["Cenarion Expedition Quartermaster"] = "Интендант экспедиции Кенариуса",
    ["Cheese Vendor"] = "Продавец сыра",
    ["Chef"] = "Повар",
    ["Cloth & Leather Armor Merchant"] = "Торговец одеяниями и кожаными доспехами",
    ["Cloth & Leather Merchant"] = "Торговец тканями и кожей",
    ["Cloth Armor Merchant"] = "Торговец тканевыми доспехами",
    ["Cloth and Leather Merchant"] = "Торговец тканями и кожей",
    ["Cockroach Vendor"] = "Продавец тараканов",
    ["Consortium Quartermaster"] = "Интендант Консорциума",
    ["Cooking Supplier"] = "Поставщик кулинарных товаров",
    ["Cooking Supplies"] = "Товары для кулинарии",
    ["Cooking Trainer and Supplies"] = "Кулинария: обучение и товары",
    ["Dagger Vendor"] = "Продавец кинжалов",
    ["Darkmoon Faire Drink Vendor"] = "Продавец напитков с Ярмарки Темной Луны",
    ["Darkmoon Faire Food Vendor"] = "Ярмарка Темной Луны: продавец еды",
    ["Defilers Supply Officer"] = "Снабженец осквернителей",
    ["Drink Vendor"] = "Продавец напитков",
    ["Enchanting Supplier"] = "Поставщик чародейских товаров",
    ["Enchanting Supplies"] = "Чародейская лавка",
    ["Enchanting Vendor"] = "Припасы для наложения чар",
    ["Engineering & General Goods Supplier"] = "Поставщик инженерных материалов и потребительских товаров",
    ["Engineering Supplier"] = "Поставщик инженерных товаров",
    ["Engineering Supplies"] = "Инженерные материалы",
    ["Engineering and Mining Supplies"] = "Товары для инженеров и горняков",
    ["Exotic Reagent Merchant"] = "Торговец экзотическими реагентами",
    ["Fireworks Merchant"] = "Торговец фейерверками",
    ["Fireworks Vendor"] = "Продавец фейерверков",
    ["Fish Merchant"] = "Торговец рыбой",
    ["Fish Merchant & Supplies"] = "Все для рыболова",
    ["Fish Vendor"] = "Продавец рыбы",
    ["Fisherman Supplies"] = "Товары для Рыбака",
    ["Fishing Supplier"] = "Поставщик рыболовных товаров",
    ["Fishing Supplies"] = "Рыболовные снасти",
    ["Fishing Trainer & Supplies"] = "Рыбная ловля: обучение и припасы",
    ["Food & Drink Merchant"] = "Торговец едой и напитками",
    ["Food & Drink Vendor"] = "Продавец еды и напитков",
    ["Food Vendor"] = "Продавец продовольствия",
    ["Food and Drink"] = "Еда и напитки",
    ["Food & Drink"] = "Еда и напитки",
    ["Free Wheeling Merchant"] = "Странствующий лавочник",
    ["Frostwolf Supply Officer"] = "Снабженец Северного Волка",
    ["Fruit Vendor"] = "Продавец фруктов",
    ["Fungus Vendor"] = "Продавец грибов",
    ["Gem Vendor"] = "Продавец самоцветов",
    ["General & Trade Supplies"] = "Товары и припасы",
    ["General Goods"] = "Потребительские товары",
    ["General Goods Merchant"] = "Торговец потребительских товаров",
    ["General Goods Vendor"] = "Продавец потребительских товаров",
    ["General Supplies"] = "Лавка припасов",
    ["General Trade Goods Merchant"] = "General Trade Goods Merchant",
    ["General Trade Goods Vendor"] = "General Trade Goods Vendor",
    ["General Trade Supplier"] = "Поставщик потребительских товаров",
    ["Guild Tabard Vendor"] = "Продавец таппертов гильдий",
    ["Gun Merchant"] = "Торговец огнестрельным оружием",
    ["Guns Merchant"] = "Торговец огнестрельным оружием",
    ["Guns and Ammo Merchant"] = "Торговец оружием и боеприпасами",
    ["Gunsmith"] = "Оружейник",
    ["Healing & Sustenance"] = "Лечение и поддержка",
    ["Heavy Armor Merchant"] = "Торговец тяжелыми доспехами",
    ["Herbalism & Alchemy Supplies"] = "Товары для травников и алхимиков",
    ["Herbalism Supplier"] = "Постовщик товаров для травников",
    ["Honor Hold Quartermaster"] = "Интендант Оплота Чести",
    ["Horde Cloth Quartermaster"] = "Начальник снабжения одеяниями Орды",
    ["Hunting Supplies"] = "Hunting Supplies",
    ["Ice Cream Vendor"] = "Продавец мороженого",
    ["Innkeeper"] = "Трактирщик",
    ["Jewelcrafting Supplier"] = "Поставщик товаров для ювелиров",
    ["Jewelcrafting Supplies Vendor"] = "Припасы для ювелиров",
    ["Keepers of Time Quartermaster"] = "Интендант Хранителей Времени",
    ["Kurenai Quartermaster"] = "Интендант Куреная",
    ["League of Arathor Supply Officer"] = "Снабженец Лиги Аратора",
    ["Leather & Mail Armor Merchant"] = "Торговец кольчугами и кожаными доспехами",
    ["Leather Armor & Leatherworking Supplies"] = "Лавка кожаной брони и кожевнических припасов",
    ["Leather Armor Merchant"] = "Торговец кожаными доспехами",
    ["Leatherworking & Tailoring Supplies"] = "Все для кожевников и портных",
    ["Leatherworking Supplier"] = "Поставщик товаров для кожевников",
    ["Leatherworking Supplies"] = "Все для кожевников",
    ["Light Armor & Weapons Merchant"] = "Торговец легкими доспехами и оружием",
    ["Light Armor Merchant"] = "Торговец легкими доспехами",
    ["Mace & Staff Merchant"] = "Торговец булавами и посохами",
    ["Mace & Staves Vendor"] = "Продавец булав и посохов",
    ["Macecrafter"] = "Мастер по изготовлению ударного оружия",
    ["Mag'har Quartermaster"] = "Интендант Магхара",
    ["Mail & Plate Merchant"] = "Торговец доспехами",
    ["Mail Armor Merchant"] = "Торговец кольчугами",
    ["Meat Vendor"] = "Продавец мяса",
    ["Mechanostrider Merchant"] = "Торговец механодолгоногами",
    ["Merchant"] = "Торговец",
    ["Metalsmith"] = "Кузнец",
    ["Mining Supplier"] = "Поставщик товаров для рудокопов",
    ["Mining Supplies"] = "Мечта рудокопа",
    ["Mining and Smithing Supplies"] = "Mining and Smithing Supplies",
    ["Mushroom Merchant"] = "Торговец грибами",
    ["Mushroom Vendor"] = "Продавец грибов",
    ["Pie Vendor"] = "Продавец пирогов",
    ["Pirate Supplies"] = "Все для истинных пиратов",
    ["Plate Armor Merchant"] = "Торговец латами",
    ["Poison Supplier"] = "Поставщик ядов",
    ["Poison Supplies"] = "Яды на любой вкус",
    ["Poison Vendor"] = "Продавец ядов",
    ["Potions, Scrolls & Reagents"] = "Зелья, свитки и реагенты",
    ["Prairie Dog Vendor"] = "Продавец луговых собачек",
    ["Quartermaster"] = "Квартирмейсер",
    ["Rations"] = "Продовольствие",
    ["Reagent Merchant"] = "Торговец реагентами",
    ["Reagent Supplier"] = "Поставщик реагентов",
    ["Reagent Supplies"] = "Реагенты",
    ["Reagent Vendor"] = "Продавец реагентов",
    ["Reagents Vendor"] = "Продавец реагентов",
    ["Robe Merchant"] = "Торговец одеяниями",
    ["Robe Vendor"] = "Продавец одеяний",
    ["Scrolls & Potions"] = "Свитки и зелья",
    ["Scryers: Quartermaster"] = "Интендант Видящих",
    ["Shield Crafter"] = "Щитник",
    ["Shield Merchant"] = "Торговец щитами",
    ["Silverwing Supply Officer"] = "Снабженец Серебряных Крыльев",
    ["Special Weapon Crafter"] = "Special Weapon Crafter",
    ["Specialist Tailoring Supplies"] = "Припасы для опытных портных",
    ["Speciality Dress Maker"] = "Элитный портной",
    ["Speciality Tailoring Supplies"] = "Особые припасы для портных",
    ["Specialty Tailoring Supplies"] = "Особые припасы для портных",
    ["Sporeggar Quartermaster"] = "Интендант Спороггара",
    ["Staff & Mace Merchant"] = "Торговец булавами и посохами",
    ["Staff Merchant"] = "Торговец посохами",
    ["Staff Vendor"] = "Продавец посохов",
    ["Staves Merchant"] = "Торговец посохами",
    ["Stormpike Supply Officer"] = "Снабженец Грозового пика",
    ["Superior Armor Crafter"] = "Опытный бронник",
    ["Superior Armorer"] = "Опытный бронник",
    ["Superior Macecrafter"] = "Опытный мастер ударного оружия",
    ["Superior Tradesman"] = "Опытный торговец",
    ["Supplies"] = "Припасы",
    ["Sword Vendor"] = "Продавец мечей",
    ["Sword and Dagger Merchant"] = "Торговец мечами и кинжалами",
    ["Tabard Vendor"] = "Продавец таппертов",
    ["Tailoring Supplier"] = "Поставщик товаров для портных",
    ["Tailoring Supplies"] = "Товары для портных",
    ["Thrallmar Quartermaster"] = "Интендант Траллмара",
    ["Thrown Weapons Merchant"] = "Торговец метательным оружием",
    ["Tools & Supplies"] = "Инструменты и припасы",
    ["Trade Goods"] = "Товары для ремесел",
    ["Trade Goods Supplier"] = "Поставщик хозяйственных товаров",
    ["Trade Goods Supplies"] = "Хозяйственные товары",
    ["Trade Goods Vendor"] = "Продавец хозяйственных товаров",
    ["Trade Supplier"] = "Поставщик товаров",
    ["Trade Supplies"] = "Товары",
    ["Tradesman"] = "Торговец",
    ["Traveling Merchant"] = "Странствующий торговец",
    ["Two Handed Weapon Merchant"] = "Торговец двуручным оружием",
    ["Two-Handed Weapons Merchant"] = "Торговец двуручным оружием",
    ["Undead Horse Merchant"] = "Торговец конями нежити",
    ["Venture Co. Merchant"] = "Купец Торговой компании",
    ["Wand Merchant"] = "Торговец жезлами",
    ["Wand Vendor"] = "Продавец жезлов",
    ["Wands Merchant"] = "Торговец жезлами",
    ["War Harness Maker"] = "Продавец боевых портупей",
    ["War Harness Vendor"] = "Продавец боевых портупей",
    ["Warsong Supply Officer"] = "Снабженец Боевого Клича",
    ["Weapon Crafter"] = "Weapon Crafter",
    ["Weapon Merchant"] = "Хозяин оружейной лавки",
    ["Weapon Vendor"] = "Продавец оружия",
    ["Weapons Merchant"] = "Торговец оружием",
    ["Weapons and Armor Merchant"] = "Weapons and Armor Merchant",
    ["Weaponsmith"] = "Оружейник",
    ["Weaponsmith & Gunsmith"] = "Мастер школы Оружейников",
    ["Wine & Spirits Merchant"] = "Торговец спиртными напитками",
    ["Wine Vendor"] = "Продавец вин",
} end)

BabbleVendor:Debug()
BabbleVendor:SetStrictness(true)

AceLibrary:Register(BabbleVendor, MAJOR_VERSION, MINOR_VERSION)
BabbleVendor = nil
