﻿local AceAddon = AceLibrary("AceAddon-2.0")
--~ local Tablet = AceLibrary("Tablet-2.0")
local Tooltip = AceLibrary("Gratuity-2.0")
local BV = AceLibrary("Babble-Vendor-2.2")

local L = AceLibrary("AceLocale-2.2"):new("Cartographer_Vendors")
L:RegisterTranslations("enUS", function() return {
	["Filter"] = true,
	["Filter out vendors"] = true,
	
    ["Vendors"] = true,
    ["Module description"] = "Vendor Mapnotes for Cartographer",
  
	["Select all"] = true,
	["Select none"] = true,

    ["Icon alpha"] = true,
	["Alpha transparency of the icon"] = true,
	["Icon size"] = true,
	["Size of the icons on the map"] = true,    
    ["Show minimap icons"] = true,
    ["Show vendor icons on the minimap"] = true,
    ["Show minimap tracking icons"] = true,
    ["Show vendor tracking icons on the minimap"] = true,
    
--    ["Import"] = true,
--    ["Import vendors"] = true,
    ["Rebuild"] = true,
    ["Rebuild vendors"] = true,

    ["Cartographer Vendor: Start rebuild."] = true,
    ["Cartographer Vendor: Rebuild complete."] = true,

    -- Filters
    ["Vendor"] = true,
    ["Armorer"] = true,
    ["Merchants"] = true,
    ["Food and Drink"] = true,
    ["Armor"] = true,
    ["Weapons"] = true,
    ["Goods"] = true,
    ["Miscellaneous"] = true,
    ["Trainers"] = true,
  
} end)

L:RegisterTranslations("koKR", function() return {
	["Filter"] = "항목 분류",
	["Filter out vendors"] = "상인 정보를 항목에 따라 분류해서 표시합니다.",

    ["Vendors"] = "상인",
    ["Module description"] = "맵노트에 상인을 표시합니다.",
	
	["Select all"] = "모두 선택",
	["Select none"] = "선택 없음",

    ["Icon alpha"] = "아이콘 투명도",
	["Alpha transparency of the icon"] = "아이콘의 투명도를 조절합니다.",
	["Icon size"] = "아이콘 크기",
	["Size of the icons on the map"] = "아이콘의 크기를 조절합니다.",
    ["Show minimap icons"] = "미니맵 아이콘 보기",
    ["Show vendor icons on the minimap"] = "미니맵에 상인 아이콘을 표시합니다.",
    ["Show minimap tracking icons"] = "미니맵에 추적 아이콘 보기",
    ["Show vendor tracking icons on the minimap"] = "미니맵에 상인 추적 아이콘을 표시합니다.",
    
--    ["Import"] = "외부 데이터 입력",
--    ["Import vendors"] = "상인 정보를 입력합니다.",
    ["Rebuild"] = "재배치",
    ["Rebuild vendors"] = "상인 정보를 재배치 합니다.",
    
    -- Filters
    ["Vendor"] = "상인(소매)",
    ["Armorer"] = "방어구",
    ["Merchants"] = "상인(가판)",
    ["Food and Drink"] = "음료 및 요리",
    ["Armor"] = "방어구 제작자",
    ["Weapons"] = "무기",
    ["Goods"] = "일용품",
    ["Miscellaneous"] = "기타",
    ["Trainers"] = "기술자",
} end)

L:RegisterTranslations("deDE", function() return {
	["Filter"] = "Filter",
	["Filter out vendors"] = "H\195\164ndler filtern",
	
    ["Vendors"] = "H\195\164ndler",
    ["Module description"] = "H\195\164ndler-Kartennotizen f\195\188r Cartographer",

    	["Select all"] = "Alles ausw\195\164hlen",
    	["Select none"] = "Nichts ausw\195\164hlen",

    ["Icon alpha"] = "Transparenz",
    	["Alpha transparency of the icon"] = "Transparenz der Symbole.",
    	["Icon size"] = "Symbolgr\195\182\195\159e",
    	["Size of the icons on the map"] = "Gr\195\182\195\159e der Symbole auf der Karte.",
    ["Show minimap icons"] = "Minimap-Symbole anzeigen",
    ["Show vendor icons on the minimap"] = "H\195\164ndlersymbole auf der Minimap anzeigen.",
    ["Show minimap tracking icons"] = "Ortungssymbole anzeigen",
    ["Show vendor tracking icons on the minimap"] = "H\195\164ndler-Symbole auf der Minimap schalten bei Annäherung auf Ortungskreise um.",

--    ["Import"] = "Import",
--    ["Import vendors"] = "Importiere H\195\164ndlerdaten",
    ["Rebuild"] = "Rekonstruktion",
    ["Rebuild vendors"] = "Rekonstruktion der H\195\164ndlerdaten.",

    ["Cartographer Vendor: Start rebuild."] = "Cartographer Vendor: Starte Importieren.",
    ["Cartographer Vendor: Rebuild complete."] = "Cartographer Vendor: Importieren abgeschlossen.",

    -- Filters
    ["Vendor"] = "H\195\164ndler",
    ["Armorer"] = "Rüstungsschmied",
    ["Merchants"] = "Händler",
    ["Food and Drink"] = "Essen und Getränke",
    ["Armor"] = "Rüstungen",
    ["Weapons"] = "Waffen",
    ["Goods"] = "Waren",
    ["Miscellaneous"] = "Gemischtwaren",
    ["Trainers"] = "Lehrer",

} end)

L:RegisterTranslations("zhTW", function() return {
	["Filter"] = "過濾",
	["Filter out vendors"] = "過濾商人",
	
    ["Vendors"] = "商人",
    ["Module description"] = "Cartographer 模組，紀錄商人位置。",
  
	["Select all"] = "全部選擇",
	["Select none"] = "全部取消",

    ["Icon alpha"] = "圖示透明度",
	["Alpha transparency of the icon"] = "地圖上的圖示透明度",
	["Icon size"] = "圖示大小",
	["Size of the icons on the map"] = "地圖上的圖示大小",    
    ["Show minimap icons"] = "在小地圖上顯示",
    ["Show vendor icons on the minimap"] = "將商人圖示顯示在小地圖上",
    ["Show minimap tracking icons"] = "在小地圖上顯示追蹤圓圈圖示",
    ["Show vendor tracking icons on the minimap"] = "在小地圖上顯示商人追蹤圓圈圖示",
    
--    ["Import"] = "匯入",
--    ["Import vendors"] = "匯入商人資料",
    ["Rebuild"] = "重建",
    ["Rebuild vendors"] = "重建插件預設商人資料",

    ["Cartographer Vendor: Start rebuild."] = "Cartographer Vendor: 開始重建插件預設商人資料。",
    ["Cartographer Vendor: Rebuild complete."] = "Cartographer Vendor: 完成重建插件預設商人資料。",

    -- Filters
    ["Vendor"] = "商人",
    ["Armorer"] = "裝甲",
    ["Merchants"] = "商人",
    ["Food and Drink"] = "食物與飲料",
    ["Armor"] = "裝甲",
    ["Weapons"] = "武器",
    ["Goods"] = "物品",
    ["Miscellaneous"] = "雜物",
    ["Trainers"] = "訓練師",
  
} end)

L:RegisterTranslations("zhCN", function() return {
--***************************************
-- zhCN Chinese Simplify
-- 2007/07/14 CN3羽月 雪夜之狼
-- E-Mail:xionglingfeng@Gmail.com
--***************************************
  	["Filter"] = "过滤",
	  ["Filter out vendors"] = "过滤商人",

    ["Vendors"] = "商人",
    ["Module description"] = "在地图上标记商人位置",

    ["Select all"] = "全部选择",
    ["Select none"] = "全部取消",

    ["Icon alpha"] = "图标透明度",
   	["Alpha transparency of the icon"] = "设定图标的透明度",
  	["Icon size"] = "图标大小",
  	["Size of the icons on the map"] = "设定图标的大小",
    ["Show minimap icons"] = "在小地图上显示",
    ["Show vendor icons on the minimap"] = "在小地图上显示商人图示",

    ["Rebuild"] = "重建",
    ["Rebuild vendors"] = "重建商人资料",

    ["Cartographer Vendor: Start rebuild."] = "Cartographer Vendor: 開始重建.",
    ["Cartographer Vendor: Rebuild complete."] = "Cartographer Vendor: 重建完毕.",

    -- Filters
    ["Vendor"] = "商人",
    ["Armorer"] = "装甲",
    ["Merchants"] = "商人",
    ["Food and Drink"] = "食物与饮料",
    ["Armor"] = "装甲",
    ["Weapons"] = "武器",
    ["Goods"] = "物品",
    ["Miscellaneous"] = "杂物",
    ["Trainers"] = "训练师",
} end)

L:RegisterTranslations("esES", function() return {
	["Filter"] = "Filtrar",
	["Filter out vendors"] = "Filtra vendedores",
	
    ["Vendors"] = "Vendedores",
    ["Module description"] = "Notas de mapa de vendedores para Cartographer",

    ["Select all"] = "Seleccionar todo",
    ["Select none"] = "No seleccionar nada",

    ["Icon alpha"] = "Transparencia de icono",
    ["Alpha transparency of the icon"] = "Transparencia del icono",
    ["Icon size"] = "Tama\195\177o del icono",
    ["Size of the icons on the map"] = "Tama\195\177o de los iconos en el mapa",
    ["Show minimap icons"] = "Mostrar iconos en minimapa",
    ["Show vendor icons on the minimap"] = "Muestra los iconos de vendedores en el minimapa",
    ["Show minimap tracking icons"] = "Mostrar iconos de seguimiento en minimapa",
    ["Show vendor tracking icons on the minimap"] = "Muestra los iconos de seguimiento de vendedores en el minimapa",
    
--    ["Import"] = "Importar",
--    ["Import vendors"] = "Importa vendedores",
    ["Rebuild"] = "Reconstruir",
    ["Rebuild vendors"] = "Reconstruye vendedores",
    
    ["Vendor"] = "Vendedor",

    -- Filters
    ["Vendor"] = "Vendedor",
    ["Armorer"] = "Armero",
    ["Merchants"] = "Mercaderes",
    ["Food and Drink"] = "Comida y Bebida",
    ["Armor"] = "Armadura",
    ["Weapons"] = "Armas",
    ["Goods"] = "Pertrechos",
    ["Miscellaneous"] = "Miscel\195\161neo",
    ["Trainers"] = "Instructores",
} end)

Cartographer_Vendors = Cartographer:NewModule("Vendors", "AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
-- Cartographer_Vendors.revision = tonumber(string.sub("$Revision: 28867 $", 12, -3))
-- Cartographer_Vendors.version = "r" .. Cartographer_Vendors.revision
-- Cartographer_Vendors.date = string.sub("$Date: 2007-02-24 05:37:39 -0500 (Sat, 24 Feb 2007) $", 8, 17)
Cartographer_Vendors.interface = "20400"
Cartographer_Vendors.revision = "1"
Cartographer_Vendors.version = Cartographer_Vendors.interface .. "." .. Cartographer_Vendors.revision
Cartographer_Vendors.date = "2008-08-02"

Cartographer_Vendors:RegisterDB("Cartographer_VendorsDB")

Cartographer_Vendors.filters = {
    ["Armor"] = L["Armor"],
    ["Food and Drink"] = L["Food and Drink"],
    ["Goods"] = L["Goods"],
    ["Merchants"] = L["Merchants"],
    ["Miscellaneous"] = L["Miscellaneous"],
    ["Trainers"] = L["Trainers"],
    ["Weapons"] = L["Weapons"],
}

Cartographer_Vendors.lookups = {
    ["filters"] = {
        [BV["Accessories Quartermaster"]] = "Miscellaneous",
        [BV["Alchemy & Herbalism Supplies"]] = "Merchants",
        [BV["Alchemy Supplies"]] = "Merchants",
        [BV["Alliance Cloth Quartermaster"]] = "Miscellaneous",
        [BV["Ammunition Vendor"]] = "Merchants",
        [BV["Arcane Goods Vendor"]] = "Merchants",
        [BV["Arcane Trinkets Vendor"]] = "Merchants",
        [BV["Arena Vendor"]] = "Merchants",
        [BV["Armor & Shield Merchant"]] = "Merchants",
        [BV["Armor Crafter"]] = "Armor",
        [BV["Armor Merchant"]] = "Merchants",
        [BV["Armorsmith & Blacksmithing Supplies"]] = "Merchants",
        [BV["Armorsmith"]] = "Armor",
        [BV["Axe Merchant"]] = "Merchants",
        [BV["Axe Vendor"]] = "Merchants",
        [BV["Bag Merchant"]] = "Merchants",
        [BV["Bag Vendor"]] = "Merchants",
        [BV["Bait and Tackle Supplier"]] = "Merchants",
        [BV["Beverage Merchant"]] = "Merchants",
        [BV["Blacksmithing Supplier"]] = "Merchants",
        [BV["Blacksmithing Supplies"]] = "Merchants",
        [BV["Blacksmithing Trainer and Supplies"]] = "Merchants",
        [BV["Blade Merchant"]] = "Merchants",
        [BV["Blade Vendor"]] = "Merchants",
        [BV["Blunt Weapon Merchant"]] = "Merchants",
        [BV["Bow & Arrow Merchant"]] = "Merchants",
        [BV["Bow & Gun Merchant"]] = "Merchants",
        [BV["Bow Merchant"]] = "Merchants",
        [BV["Bowyer"]] = "Weapons",
        [BV["Bread Merchant"]] = "Merchants",
        [BV["Bread Vendor"]] = "Merchants",
        [BV["Butcher"]] = "Food and Drink",
        [BV["Cenarion Expedition Quartermaster"]] = "Miscellaneous",
        [BV["Cheese Vendor"]] = "Merchants",
        [BV["Chef"]] = "Food and Drink",
        [BV["Cloth & Leather Armor Merchant"]] = "Merchants",
        [BV["Cloth & Leather Merchant"]] = "Merchants",
        [BV["Cloth Armor Merchant"]] = "Merchants",
        [BV["Cloth and Leather Merchant"]] = "Merchants",
        [BV["Cockroach Vendor"]] = "Merchants",
        [BV["Consortium Quartermaster"]] = "Miscellaneous",
        [BV["Cooking Supplier"]] = "Merchants",
        [BV["Cooking Supplies"]] = "Merchants",
        [BV["Cooking Trainer and Supplies"]] = "Merchants",
        [BV["Dagger Vendor"]] = "Merchants",
        [BV["Darkmoon Faire Drink Vendor"]] = "Merchants",
        [BV["Darkmoon Faire Food Vendor"]] = "Merchants",
        [BV["Defilers Supply Officer"]] = "Merchants",
        [BV["Drink Vendor"]] = "Merchants",
        [BV["Enchanting Supplier"]] = "Merchants",
        [BV["Enchanting Supplies"]] = "Merchants",
        [BV["Enchanting Vendor"]] = "Merchants",
        [BV["Engineering & General Goods Supplier"]] = "Merchants",
        [BV["Engineering Supplier"]] = "Merchants",
        [BV["Engineering Supplies"]] = "Merchants",
        [BV["Engineering and Mining Supplies"]] = "Merchants",
        [BV["Exotic Reagent Merchant"]] = "Merchants",
        [BV["Fireworks Merchant"]] = "Merchants",
        [BV["Fireworks Vendor"]] = "Merchants",
        [BV["Fish Merchant & Supplies"]] = "Merchants",
        [BV["Fish Merchant"]] = "Merchants",
        [BV["Fish Vendor"]] = "Merchants",
        [BV["Fisherman Supplies"]] = "Merchants",
        [BV["Fishing Supplier"]] = "Merchants",
        [BV["Fishing Supplies"]] = "Merchants",
        [BV["Fishing Trainer & Supplies"]] = "Merchants",
        [BV["Food & Drink Merchant"]] = "Merchants",
        [BV["Food & Drink Vendor"]] = "Merchants",
        [BV["Food Vendor"]] = "Merchants",
        [BV["Food and Drink"]] = "Food and Drink",
        [BV["Free Wheeling Merchant"]] = "Merchants",
        [BV["Frostwolf Supply Officer"]] = "Merchants",
        [BV["Fruit Vendor"]] = "Merchants",
        [BV["Gem Vendor"]] = "Merchants",
        [BV["General & Trade Supplies"]] = "Merchants",
        [BV["General Goods Merchant"]] = "Merchants",
        [BV["General Goods Vendor"]] = "Merchants",
        [BV["General Goods"]] = "Goods",
        [BV["General Supplies"]] = "Merchants",
        [BV["General Trade Goods Merchant"]] = "Merchants",
        [BV["General Trade Goods Vendor"]] = "Merchants",
        [BV["General Trade Supplier"]] = "Merchants",
        [BV["Guild Tabard Vendor"]] = "Merchants",
        [BV["Gun Merchant"]] = "Merchants",
        [BV["Guns Merchant"]] = "Merchants",
        [BV["Gunsmith"]] = "Weapons",
        [BV["Healing & Sustenance"]] = "Food and Drink",
        [BV["Heavy Armor Merchant"]] = "Merchants",
        [BV["Herbalism & Alchemy Supplies"]] = "Merchants",
        [BV["Herbalism Supplier"]] = "Merchants",
        [BV["Honor Hold Quartermaster"]] = "Miscellaneous",
        [BV["Horde Cloth Quartermaster"]] = "Miscellaneous",
        [BV["Ice Cream Vendor"]] = "Merchants",
        [BV["Innkeeper"]] = "Food and Drink",
        [BV["Jewelcrafting Supplier"]] = "Merchants",
        [BV["Jewelcrafting Supplies Vendor"]] = "Merchants",
        [BV["Keepers of Time Quartermaster"]] = "Miscellaneous",
        [BV["Kurenai Quartermaster"]] = "Miscellaneous",
        [BV["League of Arathor Supply Officer"]] = "Merchants",
        [BV["Leather & Mail Armor Merchant"]] = "Merchants",
        [BV["Leather Armor & Leatherworking Supplies"]] = "Merchants",
        [BV["Leather Armor Merchant"]] = "Merchants",
        [BV["Leatherworking & Tailoring Supplies"]] = "Merchants",
        [BV["Leatherworking Supplier"]] = "Merchants",
        [BV["Leatherworking Supplies"]] = "Merchants",
        [BV["Light Armor & Weapons Merchant"]] = "Merchants",
        [BV["Light Armor Merchant"]] = "Merchants",
        [BV["Mace & Staff Merchant"]] = "Merchants",
        [BV["Mace & Staves Vendor"]] = "Merchants",
        [BV["Macecrafter"]] = "Weapons",
        [BV["Mag'har Quartermaster"]] = "Miscellaneous",
        [BV["Mail & Plate Merchant"]] = "Merchants",
        [BV["Mail Armor Merchant"]] = "Merchants",
        [BV["Meat Vendor"]] = "Merchants",
        [BV["Mechanostrider Merchant"]] = "Merchants",
        [BV["Merchant"]] = "Merchants",
        [BV["Mining Supplier"]] = "Merchants",
        [BV["Mining Supplies"]] = "Merchants",
        [BV["Mining and Smithing Supplies"]] = "Merchants",
        [BV["Mushroom Merchant"]] = "Merchants",
        [BV["Mushroom Vendor"]] = "Merchants",
        [BV["Pirate Supplies"]] = "Merchants",
        [BV["Plate Armor Merchant"]] = "Merchants",
        [BV["Poison Supplier"]] = "Merchants",
        [BV["Poison Supplies"]] = "Merchants",
        [BV["Poison Vendor"]] = "Merchants",
        [BV["Prairie Dog Vendor"]] = "Merchants",
        [BV["Quartermaster"]] = "Miscellaneous",
        [BV["Rations"]] = "Food and Drink",
        [BV["Reagent Merchant"]] = "Merchants",
        [BV["Reagent Supplier"]] = "Merchants",
        [BV["Reagent Supplies"]] = "Merchants",
        [BV["Reagent Vendor"]] = "Merchants",
        [BV["Reagents Vendor"]] = "Merchants",
        [BV["Robe Merchant"]] = "Merchants",
        [BV["Robe Vendor"]] = "Merchants",
        [BV["Scrolls & Potions"]] = "Miscellaneous",
        [BV["Scryers: Quartermaster"]] = "Miscellaneous",
        [BV["Shield Crafter"]] = "Miscellaneous",
        [BV["Shield Merchant"]] = "Merchants",
        [BV["Silverwing Supply Officer"]] = "Merchants",
        [BV["Special Weapon Crafter"]] = "Miscellaneous",
        [BV["Specialist Tailoring Supplies"]] = "Merchants",
        [BV["Speciality Dress Maker"]] = "Miscellaneous",
        [BV["Speciality Tailoring Supplies"]] = "Merchants",
        [BV["Specialty Tailoring Supplies"]] = "Merchants",
        [BV["Sporeggar Quartermaster"]] = "Miscellaneous",
        [BV["Staff & Mace Merchant"]] = "Merchants",
        [BV["Staff Merchant"]] = "Merchants",
        [BV["Staff Vendor"]] = "Merchants",
        [BV["Staves Merchant"]] = "Merchants",
        [BV["Stormpike Supply Officer"]] = "Merchants",
        [BV["Superior Armor Crafter"]] = "Armor",
        [BV["Superior Macecrafter"]] = "Weapons",
        [BV["Superior Tradesman"]] = "Miscellaneous",
        [BV["Supplies"]] = "Merchants",
        [BV["Sword Vendor"]] = "Merchants",
        [BV["Sword and Dagger Merchant"]] = "Merchants",
        [BV["Tabard Vendor"]] = "Merchants",
        [BV["Tailoring Supplier"]] = "Merchants",
        [BV["Tailoring Supplies"]] = "Merchants",
        [BV["Thrallmar Quartermaster"]] = "Miscellaneous",
        [BV["Thrown Weapons Merchant"]] = "Merchants",
        [BV["Tools & Supplies"]] = "Merchants",
        [BV["Trade Goods Supplier"]] = "Merchants",
        [BV["Trade Goods Supplies"]] = "Merchants",
        [BV["Trade Goods Vendor"]] = "Merchants",
        [BV["Trade Goods"]] = "Goods",
        [BV["Trade Supplier"]] = "Merchants",
        [BV["Trade Supplies"]] = "Merchants",
        [BV["Tradesman"]] = "Miscellaneous",
        [BV["Two Handed Weapon Merchant"]] = "Merchants",
        [BV["Two-Handed Weapons Merchant"]] = "Merchants",
        [BV["Undead Horse Merchant"]] = "Merchants",
        [BV["Venture Co. Merchant"]] = "Merchants",
        [BV["Wand Merchant"]] = "Merchants",
        [BV["Wand Vendor"]] = "Merchants",
        [BV["Wands Merchant"]] = "Merchants",
        [BV["War Harness Maker"]] = "Miscellaneous",
        [BV["War Harness Vendor"]] = "Merchants",
        [BV["Warsong Supply Officer"]] = "Merchants",
        [BV["Weapon Crafter"]] = "Weapons",
        [BV["Weapon Merchant"]] = "Merchants",
        [BV["Weapon Vendor"]] = "Merchants",
        [BV["Weapons Merchant"]] = "Merchants",
        [BV["Weapons and Armor Merchant"]] = "Merchants",
        [BV["Weaponsmith"]] = "Weapons",
        [BV["Wine & Spirits Merchant"]] = "Merchants",
        [BV["Wine Vendor"]] = "Merchants",
    },
}

Cartographer_Vendors.icons = {
	["Vendor"] = {
		text = L["Vendor"],
		path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\INV_Misc_ElvenCoins",
		width = 14,
		height = 14
	},
    ["Armorer"] = {
        text = L["Armorer"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\Repair",
        width = 14,
        height = 14,
    },
	
    ["Armor"] = {
        text = L["Armor"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\Repair",
        width = 14,
        height = 14,
    },
    ["Food and Drink"] = {
        text = L["Food and Drink"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\INV_Misc_ElvenCoins",
        width = 14,
        height = 14,
    },
    ["Goods"] = {
        text = L["Goods"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\INV_Misc_ElvenCoins",
        width = 14,
        height = 14,
    },
    ["Merchants"] = {
        text = L["Merchants"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\INV_Misc_ElvenCoins",
        width = 14,
        height = 14,
    },
    ["Miscellaneous"] = {
        text = L["Miscellaneous"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\INV_Misc_ElvenCoins",
        width = 14,
        height = 14,
    },
    ["Trainers"] = {
        text = L["Trainers"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\INV_Misc_ElvenCoins",
        width = 14,
        height = 14,
    },	
    ["Weapons"] = {
        text = L["Weapons"],
        path = "Interface\\AddOns\\Cartographer_Vendors\\Artwork\\Repair",
        width = 14,
        height = 14,
    },		
}

Cartographer_Vendors.vendors = {}

Cartographer_Vendors.noteDefaults = {
	titleCol = Cartographer_Notes.getColorID(0, 0.8, 0)
}

Cartographer_Vendors.noteLocaleHandler = BV

function Cartographer_Vendors:OnInitialize()
	self:RegisterDefaults("profile", {
		filters = {
			['*'] = true,
		},
        iconAlpha = 1,
		iconScale = 1,
        minimapIcons = true,
        minimapTracking = true,
        noteRadius = 15,        
	})
    
    self:RegisterDefaults("faction", {
        vendors = {
            ['*'] = {
                ['*'] = {},
            },
        },
    })

	local aceopts = {}
	aceopts.toggle = {
		name = Cartographer.L["Enabled"],
		desc = Cartographer.L["Suspend/resume this module."],
		type  = 'toggle',
		order = -1,
		get   = function() return Cartographer:IsModuleActive(self) end,
		set   = function() Cartographer:ToggleModuleActive(self) end,
	}

	aceopts.alpha = {
		name = L["Icon alpha"],
		desc = L["Alpha transparency of the icon"],
		type = 'range',
		min = 0.1,
		max = 1,
		step = 0.01,
		bigStep = 0.05,
		isPercent = true,
        set = function(v)
            self.db.profile.iconAlpha = v
            Cartographer_Notes:RefreshMap()
        end,
        get = function() return self.db.profile.iconAlpha end,
		order = 1
	}
	aceopts.scale = {
		name = L["Icon size"],
		desc = L["Size of the icons on the map"],
		type = 'range',
		min = 0.5,
		max = 2,
		step = 0.01,
		bigStep = 0.05,
		isPercent = true,
        set = function(v) 
            self.db.profile.iconScale = v
            Cartographer_Notes:RefreshMap()
        end,
        get = function() return self.db.profile.iconScale end,
		order = 2
	}    
    aceopts.minimapicons = {
		name = L["Show minimap icons"],
		desc = L["Show vendor icons on the minimap"],
		type = 'toggle',
        set = function()
            self.db.profile.minimapIcons = not self.db.profile.minimapIcons
            Cartographer_Notes:RefreshMap()
        end,
        get = function() return self.db.profile.minimapIcons end,
		order = 3,
	}
    aceopts.minimaptracking = {
        name = L["Show minimap tracking icons"],
        desc = L["Show vendor tracking icons on the minimap"],
        type = 'toggle',
        set = function() 
            self.db.profile.minimapTracking = not self.db.profile.minimapTracking
            Cartographer_Notes:RefreshMap()
        end,
        get = function() return self.db.profile.minimapTracking end,
        order = 4,
        hidden = function() return not self.db.profile.minimapIcons end,
    }
	aceopts.filter = {
		name = L["Filter"],
		desc = L["Filter out vendors"],
		type = 'group',
		args = {
			all = {
				name = L["Select all"],
				desc = L["Select all"],
				type = 'execute',
				func = function()
					for k in pairs(self.filters) do
						self:ToggleShowingVendors(k, true)
					end
				end,
				order = 1,
			},
			none = {
				name = L["Select none"],
				desc = L["Select none"],
				type = 'execute',
				func = function()
					for k in pairs(self.filters) do
						self:ToggleShowingVendors(k, false)
					end
				end,
				order = 2,
			},
			blank = {
				type = 'header',
				order = 3,
			}
		},
        order = 5,
        -- hidden = true,
	}

    aceopts.rebuild = {
        name = L["Rebuild"],
        desc = L["Rebuild vendors"],
        type = 'execute',
        func = "RebuildVendors",
        order = 6,
    }

   	Cartographer.options.args.Vendors = {
		name = L["Vendors"],
		desc = L["Module description"],
		type = 'group',
		args = aceopts,
		handler = self,
	}
	-- AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, Cartographer.options.args.Vendors)

	for k,v in pairs(self.filters) do
		local k = k
		aceopts.filter.args[k] = {
			name = v,
			desc = v,
			type = 'toggle',
			get = function()
				return self:IsShowingVendors(k)
			end,
			set = function(value)
				return self:ToggleShowingVendors(k, value)
			end,
		}
	end
    
    if (not self.db.faction.notes) then self.db.faction.notes = {} end
    
    local oldDB = Cartographer:AcquireDBNamespace("Vendors")
    if (oldDB.faction.notes) then
        for k, v in pairs(oldDB.faction.notes) do
            if (k ~= "version") and (v ~= nil) then
                if (not self.db.faction.notes[k]) then self.db.faction.notes[k] = {} end
                for vk, vv in pairs(v) do
                    if (vv ~= nil) then
                        if (not self.db.faction.notes[k][vk]) then
                            -- self.db.faction.notes[k][vk] = {}
                            self.db.faction.notes[k][vk] = vv
                        end
                    end
                end
            end
        end
    end
    oldDB = nil    
   
end

function Cartographer_Vendors:OnEnable()
	if Cartographer_Notes then
		if not self.iconsregistered then
			for k,v in pairs(self.icons) do
				Cartographer_Notes:RegisterIcon(k, v)
			end
			self.iconsregistered = true
		end

		Cartographer_Notes:RegisterNotesDatabase('Vendors', self.db.faction.notes, self)
	else
		Cartographer:ToggleModuleActive(self, false)
	end

    self:RegisterEvent("MERCHANT_SHOW", function() self:RegisterVendor(UnitName("NPC")) end, 2)
end

function Cartographer_Vendors:OnDisable()
	self:UnregisterAllEvents()

	if Cartographer_Notes then
		Cartographer_Notes:UnregisterNotesDatabase('Vendors')
	end
end

function Cartographer_Vendors:SetNote(vendor)
    if (type(vendor) == "string") then vendor = {["name"] = vendor} end
    if (type(vendor) ~= "table") then return end
    
    if (not vendor.x) or (not vendor.y) then vendor.x, vendor.y = GetPlayerMapPosition("player") end
    if (vendor.x == 0) and (vendor.y == 0) then return end
    
    if (not vendor.zone) then vendor.zone = GetRealZoneText() end
    
    local note = {}
    note.title = vendor.name
    note.icon = "Vendor"
    note.info = L["Vendor"]

    if (vendor.type) then
        if (self.filters[self.lookups.filters[vendor.type]] and self.icons[vendor.type]) then note.icon = vendor.type end
        note.info = vendor.type
    end
    
    for zone, x_p, y_p, icon, creator, data in Cartographer_Notes:IterateNearbyNotes(vendor.zone, vendor.x, vendor.y, (self.db.profile.noteRadius or 15), "Vendors", nil, true) do
		if data.title == note.title then
			Cartographer_Notes:DeleteNote(zone, x_p, y_p)
		end
	end
	Cartographer_Notes:SetNote(vendor.zone, vendor.x, vendor.y, note.icon, "Vendors", note)
end

function Cartographer_Vendors:RegisterVendor(vendor)
    if (not vendor) then return end
    if (type(vendor) ~= "string") then return end
    
    local zone = GetRealZoneText()
    local x,y = GetPlayerMapPosition("player")
	
	local entry = self.db.faction.vendors[zone][vendor]
    if (not entry.name) then entry.name = vendor end
    if (not entry.zone) then entry.zone = zone end
    if (not entry.x) then entry.x = x end
    if (not entry.y) then entry.y = y end
    if (not entry.type) then
        Tooltip:SetUnit("npc")
        local result = Tooltip:GetLine(2)
        if (result) then entry.type = result end
    end
    if (not entry.faction) then entry.faction = UnitFactionGroup("player") end
    self.db.faction.vendors[zone][vendor] = entry

	-- DEFAULT_CHAT_FRAME:AddMessage(string.format("\nname: %s (%s)\nzone: %s (%s,%s)", entry.name, entry.type, entry.zone, entry.x, entry.y))
    self:SetNote(entry)
end

function Cartographer_Vendors:IsNoteHidden(zone, id, vendor)
	if type(vendor) == "table" then
		return not self.db.profile.filters[self.lookups.filters[vendor.info]]
    else
		return not self.db.profile.filters[self.lookups.filters[vendor]]
	end
end

function Cartographer_Vendors:IsShowingVendors(vendortype)
	return self.db.profile.filters[vendortype]
end

function Cartographer_Vendors:ToggleShowingVendors(vendortype, value)
	if value == nil then
		value = not self.db.profile.filters[vendortype]
	end
	self.db.profile.filters[vendortype] = value

	Cartographer_Notes:RefreshMap()
end

function Cartographer_Vendors:IsTracking(zone,id,data)
    return self.db.profile.minimapTracking
end

function Cartographer_Vendors:IsMiniNoteHidden(zone,id,data)
	return not self.db.profile.minimapIcons
end

function Cartographer_Vendors:GetNoteTransparency(zone,id,data)
	return self.db.profile.iconAlpha
end

function Cartographer_Vendors:GetNoteScaling(zone,id,data)
	return self.db.profile.iconScale
end

function Cartographer_Vendors:RebuildVendors()
    local result = self.db.faction.vendors
    
    if (self.module_import) then
        for k,v in pairs(self:ImportVendors()) do
            if (v ~= nil) then
                if (not result[k]) then result[k] = {} end
                for vk,vv in pairs(v) do
                    if (vv ~= nil) then
                        result[k][vk] = vv
                    end
                end
            end
        end
    end
            
    if (result) then
        DEFAULT_CHAT_FRAME:AddMessage(L["Cartographer Vendor: Start rebuild."])
        -- for k, v in pairs(self.db.faction.vendors) do
        for k,v in pairs(result) do
            if (v ~= nil) then
                for kv, vv in pairs(v) do
                    if (vv ~= nil) then
                        local entry = vv
                        if (not entry.name) then entry.name = kv end
                        entry.zone = k
                        
                        if (entry.x ~= 0) and (entry.y ~= 0) then
                            local note = {}
                            note.title = entry.name
                            note.icon = "Vendor"
                            note.info = L["Vendor"]
                            
                            if (entry.type) then
                                if (self.filters[self.lookups.filters[entry.type]] and self.icons[entry.type]) then note.icon = entry.type end
                                note.info = entry.type
                            end
                            
                            for zone, x_p, y_p, icon, creator, data in Cartographer_Notes:IterateNearbyNotes(entry.zone, entry.x, entry.y, (self.db.profile.noteRadius or 15), "Vendors", nil, true) do

                                if data.title == note.title then
                                    Cartographer_Notes:DeleteNote(zone, x_p, y_p)
                                end
                            end
                            
                            -- DEFAULT_CHAT_FRAME:AddMessage(string.format("Cartographer Vendor: Rebuilding note ==> %s in %s (%s,%s)", entry.name, entry.zone, entry.x, entry.y))
                            -- DEFAULT_CHAT_FRAME:AddMessage(string.format("Cartographer Vendor: Rebuilding note ==> %s in %s (%s,%s)", entry.name, entry.zone, entry.x * 100, entry.y * 100))
                            Cartographer_Notes:SetNote(entry.zone, entry.x, entry.y, note.icon, "Vendors", note)                            
                        end
                    end
                end
            end
        end
        self.db.faction.vendors = result
        DEFAULT_CHAT_FRAME:AddMessage(L["Cartographer Vendor: Rebuild complete."])
    end
end