﻿-- Cartographer_Routes
-- enUS and enGB Localization file

--if ( GetLocale() ~= "enUS" and GetLocale() ~= "enGB" ) then
--return
--end

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("Cartographer_Routes")

L:AddTranslations("enUS", function() return {
	-- Module name and description
	["Routes"] = "Routes",
	["Module description"] = "Routes for Cartographer",

	-- These are used in the Rock Configuration menus
	["Enabled"] = true,
	["Suspend/resume this module."] = true,
	["Settings"] = true,
	["Default values?"] = true,
	["Normal lines"] = true,
	["Hidden lines"] = true,
	["Minimap lines"] = true,
	["Line settings"] = true,
	["Width (Map)"] = true,
	["Width of the line in the map"] = true,
	["Width (Minimap)"] = true,
	["Width of the line in the Minimap"] = true,
	["Width (Zone Map)"] = true,
	["Width of the line in the Zone Map"] = true,
	["Color"] = true,
	["Change default route color"] = true,
	["Show"] = true,
	["Show hidden routes?"] = true,
	["Line gaps"] = true,
	["Shorten the lines drawn on the minimap slightly so that they do not overlap the icons and minimap tracking blips."] = true,
	["Change default hidden route color"] = true,
	["Update distance"] = true,
	["Yards to move before triggering a minimap update"] = true,
	["Name"] = true,
	["Name of the route to add to %s"] = true,
	["Zone"] = true,
	["Zone to create route in"] = true,
	["Add"] = true,
	["Herbalism"] = true,
	["Mining"] = true,
	["Fishing"] = true,
	["Treasure"] = true,
	["Exists, overwrite?"] = true,
	["Data"] = true,
	["Which nodes to use in the route"] = true,
	["No Herbalism/Mining/Fishing data found"] = true,
	["Unknown Zone!"] = true,
	["Are you sure to override the existing route: '%s'"] = true,
	["<new item>"] = true,
	["Zones"] = true,
	["Select Item"] = true,
	["Routes in %s"] = true,
	["Line width"] = true,
	["Width of the line"] = true,
	["Route color"] = true,
	["Change a color"] = true,
	["Hidden"] = true,
	["Route hidden?"] = true,
	["Active for edit"] = true,
	["Active editing wise?"] = true,
	["Looped"] = true,
	["Connect start and end for this route?"] = true,
	["Defaults"] = true,
	['Reset'] = true,
	['Reset to defaults'] = true,
	["Delete"] = true,
	["Permanently delete a route"] = true,
	["Are you sure?"] = true,
	['Optimize route [%d nodes, %d yards]'] = true,
	['Background'] = true,
	['Foreground'] = true,
	['Foreground Disclaimer'] = "Generate close to optimal path for the set of nodes in this route. Please keep in mind that doing this will 'hang' your client for some time. Depending on the amount of nodes (more cause near exponential increase in time) and CPU speed you might even get a disconnect if it takes too long.",
	['Background Disclaimer'] = "This will perform the TSP route generation in the background much more slowly without locking up WoW. Please note that your WoW will still take a noticable performance hit.",
	["Optimize"] = true,
	["Worldmap drawing"] = true,
	["Minimap drawing"] = true,
	["Zone map drawing"] = true,
	["Extra optimization"] = true,
	["ExtraOptDesc"] = "Turning on this option will make optimizing the route take approximately 40% longer, but will generate -slightly- better routes. Recommended setting is OFF.",

	-- Various messages that are displayed with self:Print()
	["No name given for new route"] = true,
	["No data selected for new route"] = true,
	["Path with %d nodes found with length %.2f yards after %d iterations in %.2f seconds."] = true,
	["Now running TSP in the background..."] = true,
	["There is already a TSP running in background. Wait for it to complete first."] = true,
	["The following error occured in the background path generation coroutine, please report to Grum or Xinhuan:"] = true,
	["Routes requires the Notes module to operate."] = true,

	["Map Drawing"] = true,
	["Auto Show/Hide Routes"] = true,
	["Auto show and hide routes based on your professions"] = true,
	["Use Auto Show/Hide"] = true,
	["Routes with Fish"] = true,
	["Routes with Herbs"] = true,
	["Routes with Ore"] = true,
	["Routes with Treasure"] = true,
	["Routes with Gas"] = true,
	["Always show"] = true,
	["Only show when you have the profession"] = true,
	["Only show when tracking skill is active"] = true,
	["Never show"] = true,
	["ExtractGas"] = "Gas",
	["You may not delete a route that is being optimized in the background."] = true,
	["%s - Node %d"] = true,
	["Direction changed"] = true,
	["Cartographer_Waypoints module is missing or disabled"] = true,
	["Cartographer_Waypoints support"] = true,
	["Integrated support options for Cartographer_Waypoints"] = true,
	["Waypoint hit distance"] = true,
	["This is the distance in yards away from a waypoint to consider as having reached it so that the next node in the route can be added as the waypoint"] = true,
	["Start using Waypoints"] = true,
	["Start using Cartographer_Waypoints by finding the closest visible route/node in the current zone and using that as the waypoint"] = true,
	["Change direction"] = true,
	["Change the direction of the nodes in the route being added as the next waypoint"] = true,
	["Stop using Waypoints"] = true,
	["Stop using Cartographer_Waypoints by clearing the last queued node"] = true,
} end)

-- vim: ts=4 noexpandtab
