﻿--[[
Name: Babble-Herbs-2.2
Revision: $Rev: 81944 $
Authors(s): kagaro (sal.scotto@gmail.com)
Website: www.wowace.com
Documentation: http://www.wowace.com/wiki/Babble-Herbs-2.2
SVN: http://svn.wowace.com/wowace/trunk/Babble-2.2/Babble-Herbs-2.2
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Herbs-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 81944 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleHerbs = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

BabbleHerbs:RegisterTranslations("enUS", function() return {
	["Peacebloom"] = true,
	["Silverleaf"] = true,
	["Earthroot"] = true,
	["Mageroyal"] = true,
	["Briarthorn"] = true,
	["Swiftthistle"] = true,
	["Stranglekelp"] = true,
	["Bruiseweed"] = true,
	["Wild Steelbloom"] = true,
	["Grave Moss"] = true,
	["Kingsblood"] = true,
	["Liferoot"] = true,
	["Fadeleaf"] = true,
	["Goldthorn"] = true,
	["Khadgar's Whisker"] = true,
	["Wintersbite"] = true,
	["Firebloom"] = true,
	["Purple Lotus"] = true,
	["Wildvine"] = true,
	["Arthas' Tears"] = true,
	["Sungrass"] = true,
	["Blindweed"] = true,
	["Ghost Mushroom"] = true,
	["Gromsblood"] = true,
	["Golden Sansam"] = true,
	["Dreamfoil"] = true,
	["Mountain Silversage"] = true,
	["Plaguebloom"] = true,
	["Icecap"] = true,
	["Bloodvine"] = true,
	["Black Lotus"] = true,
	["Felweed"] = true,
	["Dreaming Glory"] = true,
	["Terocone"] = true,
	["Ancient Lichen"] = true,
	["Bloodthistle"] = true,
	["Mana Thistle"] = true,
	["Netherbloom"] = true,
	["Nightmare Vine"] = true,
	["Ragveil"] = true,
	["Flame Cap"] = true,
	["Fel Lotus"] = true,
	["Netherdust Bush"] = true,
} end)

BabbleHerbs:RegisterTranslations("koKR", function() return {
	["Peacebloom"] = "평온초",
	["Silverleaf"] = "은엽수 덤불",
	["Earthroot"] = "뱀뿌리",
	["Mageroyal"] = "마법초",
	["Briarthorn"] = "찔레가시",
	["Swiftthistle"] = "토끼엉겅퀴풀",
	["Stranglekelp"] = "갈래물풀",
	["Bruiseweed"] = "생채기풀",
	["Wild Steelbloom"] = "야생 철쭉",
	["Grave Moss"] = "무덤이끼",
	["Kingsblood"] = "왕꽃잎풀",
	["Liferoot"] = "생명의 뿌리",
	["Fadeleaf"] = "미명초",
	["Goldthorn"] = "황금가시",
	["Khadgar's Whisker"] = "카드가의 수염",
	["Wintersbite"] = "겨울서리풀",
	["Firebloom"] = "화염초",
	["Purple Lotus"] = "보라 연꽃",
	["Wildvine"] = "야생덩굴",
	["Arthas' Tears"] = "아서스의 눈물",
	["Sungrass"] = "태양풀",
	["Blindweed"] = "실명초",
	["Ghost Mushroom"] = "유령버섯",
	["Gromsblood"] = "그롬의 피",
	["Golden Sansam"] = "황금 산삼",
	["Dreamfoil"] = "꿈풀",
	["Mountain Silversage"] = "은초롱이",
	["Plaguebloom"] = "역병초",
	["Icecap"] = "얼음송이",
	["Bloodvine"] = "붉은덩굴",
	["Black Lotus"] = "검은 연꽃",
	["Felweed"] = "지옥풀",
	["Dreaming Glory"] = "꿈초롱이",
	["Terocone"] = "테로열매",
	["Ancient Lichen"] = "고대 이끼",
	["Bloodthistle"] = "피 엉겅퀴",
	["Mana Thistle"] = "마나 엉겅퀴",
	["Netherbloom"] = "황천꽃",
	["Nightmare Vine"] = "악몽의 덩굴",
	["Ragveil"] = "가림막이버섯",
	["Flame Cap"] = "불꽃송이",
	["Fel Lotus"] = "지옥 연꽃",
	["Netherdust Bush"] = "황천티끌 덤불",
} end)

BabbleHerbs:RegisterTranslations("deDE", function() return {
	["Peacebloom"] = "Friedensblume",
	["Silverleaf"] = "Silberblatt",
	["Earthroot"] = "Erdwurzel",
	["Mageroyal"] = "Maguskönigskraut",
	["Briarthorn"] = "Wilddornrose",
	["Swiftthistle"] = "Flitzdistel",
	["Stranglekelp"] = "Würgetang",
	["Bruiseweed"] = "Beulengras",
	["Wild Steelbloom"] = "Wildstahlblume",
	["Grave Moss"] = "Grabmoos",
	["Kingsblood"] = "Königsblut",
	["Liferoot"] = "Lebenswurz",
	["Fadeleaf"] = "Blassblatt",
	["Goldthorn"] = "Golddorn",
	["Khadgar's Whisker"] = "Khadgars Schnurrbart",
	["Wintersbite"] = "Winterbiss",
	["Firebloom"] = "Feuerblüte",
	["Purple Lotus"] = "Lila Lotus",
	["Wildvine"] = "Wildranke",
	["Arthas' Tears"] = "Arthas’ Tränen",
	["Sungrass"] = "Sonnengras",
	["Blindweed"] = "Blindkraut",
	["Ghost Mushroom"] = "Geisterpilz",
	["Gromsblood"] = "Gromsblut",
	["Golden Sansam"] = "Goldener Sansam",
	["Dreamfoil"] = "Traumblatt",
	["Mountain Silversage"] = "Bergsilbersalbei",
	["Plaguebloom"] = "Pestblüte",
	["Icecap"] = "Eiskappe",
	["Bloodvine"] = "Blutrebe",
	["Black Lotus"] = "Schwarzer Lotus",
	["Felweed"] = "Teufelsgras",
	["Dreaming Glory"] = "Traumwinde",
	["Terocone"] = "Terozapfen",
	["Ancient Lichen"] = "Urflechte",
	["Bloodthistle"] = "Blutdistel",
	["Mana Thistle"] = "Manadistel",
	["Netherbloom"] = "Netherblüte",
	["Nightmare Vine"] = "Alptraumranke",
	["Ragveil"] = "Zottelkappe",
	["Flame Cap"] = "Flammenkappe",
	["Fel Lotus"] = "Teufelslotus",
	["Netherdust Bush"] = "Netherstaubbusch",
} end)

BabbleHerbs:RegisterTranslations("frFR", function() return {
	["Peacebloom"] = "Pacifique",
	["Silverleaf"] = "Feuillargent",
	["Earthroot"] = "Terrestrine",
	["Mageroyal"] = "Mage royal",
	["Briarthorn"] = "Eglantine",
	["Swiftthistle"] = "Chardonnier",
	["Stranglekelp"] = "Etouffante",
	["Bruiseweed"] = "Doulourante",
	["Wild Steelbloom"] = "Aciérite sauvage",
	["Grave Moss"] = "Tombeline",
	["Kingsblood"] = "Sang-royal",
	["Liferoot"] = "Vietérule",
	["Fadeleaf"] = "Pâlerette",
	["Goldthorn"] = "Dorépine",
	["Khadgar's Whisker"] = "Moustache de Khadgar",
	["Wintersbite"] = "Hivernale",
	["Firebloom"] = "Fleur de feu",
	["Purple Lotus"] = "Lotus pourpre",
	["Wildvine"] = "Sauvageonne",
	["Arthas' Tears"] = "Larmes d'Arthas",
	["Sungrass"] = "Soleillette",
	["Blindweed"] = "Aveuglette",
	["Ghost Mushroom"] = "Champignon fantôme",
	["Gromsblood"] = "Gromsang",
	["Golden Sansam"] = "Sansam doré",
	["Dreamfoil"] = "Feuillerêve",
	["Mountain Silversage"] = "Sauge-argent des montagnes",
	["Plaguebloom"] = "Fleur de peste",
	["Icecap"] = "Calot de glace",
	["Bloodvine"] = "Vignesang",
	["Black Lotus"] = "Lotus noir",
	["Felweed"] = "Gangrelette",
	["Dreaming Glory"] = "Glaurier",
	["Terocone"] = "Terocône",
	["Ancient Lichen"] = "Lichen ancien",
	["Bloodthistle"] = "Chardon sanglant",
	["Mana Thistle"] = "Chardon de mana",
	["Netherbloom"] = "Néantine",
	["Nightmare Vine"] = "Cauchemardelle",
	["Ragveil"] = "Voile-misère",
	["Flame Cap"] = "Chapeflamme",
	["Fel Lotus"] = "Gangrelotus",
	["Netherdust Bush"] = "Buisson de pruinéante",
} end)

BabbleHerbs:RegisterTranslations("esES", function() return {
	["Peacebloom"] = "Flor de paz",
	["Silverleaf"] = "Hojaplata",
	["Earthroot"] = "Raíz de tierra",
	["Mageroyal"] = "Marregal",
	["Briarthorn"] = "Brezospina",
	["Swiftthistle"] = "Cardoveloz",
	["Stranglekelp"] = "Alga estranguladora",
	["Bruiseweed"] = "Hierba cardenal",
	["Wild Steelbloom"] = "Acérita salvaje",
	["Grave Moss"] = "Musgo de tumba",
	["Kingsblood"] = "Sangrerregia",
	["Liferoot"] = "Vidarraíz",
	["Fadeleaf"] = "Pálida",
	["Goldthorn"] = "Espina de oro",
	["Khadgar's Whisker"] = "Mostacho de Khadgar",
	["Wintersbite"] = "Ivernalia",
	["Firebloom"] = "Flor de Fuego",
	["Purple Lotus"] = "Loto cárdeno",
	["Wildvine"] = "Atriplex salvaje",
	["Arthas' Tears"] = "Lágrimas de Arthas",
	["Sungrass"] = "Solea",
	["Blindweed"] = "Carolina",
	["Ghost Mushroom"] = "Champiñón fantasma",
	["Gromsblood"] = "Gromsanguina",
	["Golden Sansam"] = "Sansam dorado",
	["Dreamfoil"] = "Hojasueño",
	["Mountain Silversage"] = "Salviargenta de montaña",
	["Plaguebloom"] = "Flor de peste",
	["Icecap"] = "Setelo",
	["Bloodvine"] = "Vid de sangre",
	["Black Lotus"] = "Loto negro",
	["Felweed"] = "Hierba vil",
	["Dreaming Glory"] = "Gloria de ensueño",
	["Terocone"] = "Teropiña",
	["Ancient Lichen"] = "Liquen antiguo",
	["Bloodthistle"] = "Cardo de sangre",
	["Mana Thistle"] = "Cardo de maná",  
	["Netherbloom"] = "Flor abisal",  
	["Nightmare Vine"] = "Vid Pesadilla", 
	["Ragveil"] = "Velada",
	["Flame Cap"] = "Seta flamígera",
	["Fel Lotus"] = "Lotus vil",
	["Netherdust Bush"] = "Arbusto de polvo abisal",
} end)

BabbleHerbs:RegisterTranslations("zhCN", function() return {
	["Peacebloom"] = "宁神花",
	["Silverleaf"] = "银叶草",
	["Earthroot"] = "地根草",
	["Mageroyal"] = "魔皇草",
	["Briarthorn"] = "石南草",
	["Swiftthistle"] = "雨燕草",
	["Stranglekelp"] = "荆棘藻",
	["Bruiseweed"] = "跌打草",
	["Wild Steelbloom"] = "野钢花",
	["Grave Moss"] = "墓地苔",
	["Kingsblood"] = "皇血草",
	["Liferoot"] = "活根草",
	["Fadeleaf"] = "枯叶草",
	["Goldthorn"] = "金棘草",
	["Khadgar's Whisker"] = "卡德加的胡须",
	["Wintersbite"] = "冬刺草",
	["Firebloom"] = "火焰花",
	["Purple Lotus"] = "紫莲花",
	["Wildvine"] = "野葡萄藤",
	["Arthas' Tears"] = "阿尔萨斯之泪",
	["Sungrass"] = "太阳草",
	["Blindweed"] = "盲目草",
	["Ghost Mushroom"] = "幽灵菇",
	["Gromsblood"] = "格罗姆之血",
	["Golden Sansam"] = "黄金参",
	["Dreamfoil"] = "梦叶草",
	["Mountain Silversage"] = "山鼠草",
	["Plaguebloom"] = "瘟疫花",
	["Icecap"] = "冰盖草",
	["Bloodvine"] = "血藤",
	["Black Lotus"] = "黑莲花",
	["Felweed"] = "魔草",
	["Dreaming Glory"] = "梦露花",
	["Terocone"] = "泰罗果",
	["Ancient Lichen"] = "远古苔",
	["Bloodthistle"] = "血蓟",
	["Mana Thistle"] = "法力蓟",
	["Netherbloom"] = "虚空花",
	["Nightmare Vine"] = "噩梦藤",
	["Ragveil"] = "邪雾草",
	["Flame Cap"] = "烈焰菇",
	["Fel Lotus"] = "魔莲花",
	["Netherdust Bush"] = "灵尘灌木丛",
} end)

BabbleHerbs:RegisterTranslations("zhTW", function() return {
	["Peacebloom"] = "寧神花",
	["Silverleaf"] = "銀葉草",
	["Earthroot"] = "地根草",
	["Mageroyal"] = "魔皇草",
	["Briarthorn"] = "石南草",
	["Swiftthistle"] = "雨燕草",
	["Stranglekelp"] = "荊棘藻",
	["Bruiseweed"] = "跌打草",
	["Wild Steelbloom"] = "野鋼花",
	["Grave Moss"] = "墓地苔",
	["Kingsblood"] = "皇血草",
	["Liferoot"] = "活根草",
	["Fadeleaf"] = "枯葉草",
	["Goldthorn"] = "金棘草",
	["Khadgar's Whisker"] = "卡德加的鬍鬚",
	["Wintersbite"] = "冬刺草",
	["Firebloom"] = "火焰花",
	["Purple Lotus"] = "紫蓮花",
	["Wildvine"] = "野葡萄藤",
	["Arthas' Tears"] = "阿薩斯之淚",
	["Sungrass"] = "太陽草",
	["Blindweed"] = "盲目草",
	["Ghost Mushroom"] = "鬼魂菇",
	["Gromsblood"] = "格羅姆之血",
	["Golden Sansam"] = "黃金蔘",
	["Dreamfoil"] = "夢葉草",
	["Mountain Silversage"] = "山鼠草",
	["Plaguebloom"] = "瘟疫花",
	["Icecap"] = "冰蓋草",
	["Bloodvine"] = "血藤",
	["Black Lotus"] = "黑蓮花",
	["Felweed"] = "魔獄草",
	["Dreaming Glory"] = "譽夢草",
	["Terocone"] = "泰魯草",
	["Ancient Lichen"] = "古老青苔",
	["Bloodthistle"] = "血薊",
	["Mana Thistle"] = "法力薊",
	["Netherbloom"] = "虛空花",
	["Nightmare Vine"] = "夢魘根",
	["Ragveil"] = "拉格維花",
	["Flame Cap"] = "火帽花",
	["Fel Lotus"] = "魔獄蓮花",
	["Netherdust Bush"] = "虛空之塵灌木叢",
} end)
-- Translater: StingerSoft
BabbleHerbs:RegisterTranslations("ruRU", function() return {
	["Peacebloom"] = "Мироцвет",
	["Silverleaf"] = "Сребролист",
	["Earthroot"] = "Землекорень",
	["Mageroyal"] = "Магороза",
	["Briarthorn"] = "Остротерн",
	["Swiftthistle"] = "Быстрорепей",
	["Stranglekelp"] = "Удавник",
	["Bruiseweed"] = "Синячник",
	["Wild Steelbloom"] = "Дикий сталецвет",
	["Grave Moss"] = "Могильный мох",
	["Kingsblood"] = "Королевская кровь",
	["Liferoot"] = "Жизнекорень",
	["Fadeleaf"] = "Бледнолист",
	["Goldthorn"] = "Златошип",
	["Khadgar's Whisker"] = "Кадгаров ус",
	["Wintersbite"] = "Зимник",
	["Firebloom"] = "Огнецвет",
	["Purple Lotus"] = "Пурпурный лотос",
	["Wildvine"] = "Дикий виноград",
	["Arthas' Tears"] = "Слезы Артаса",
	["Sungrass"] = "Солнечник",
	["Blindweed"] = "Слепырник",
	["Ghost Mushroom"] = "Призрачная поганка",
	["Gromsblood"] = "Кровь Грома",
	["Golden Sansam"] = "Золотой сансам",
	["Dreamfoil"] = "Снолист",
	["Mountain Silversage"] = "Горный серебряный шалфей",
	["Plaguebloom"] = "Чумоцвет",
	["Icecap"] = "Льдяник",
	["Bloodvine"] = "Кровавая Лоза",
	["Black Lotus"] = "Черный лотос",
	["Felweed"] = "Скверноплевел",
	["Dreaming Glory"] = "Соннославник",
	["Terocone"] = "Терошишка",
	["Ancient Lichen"] = "Древний лишайник",
	["Bloodthistle"] = "Кровопийка",
	["Mana Thistle"] = "Манрепейник",
	["Netherbloom"] = "Пустоцвет",
	["Nightmare Vine"] = "Лозный кошмарник",
	["Ragveil"] = "Кисейница",
	["Flame Cap"] = "Огнеголовик",
	["Fel Lotus"] = "Оскверненный лотос",
	["Netherdust Bush"] = "Пыльца Хаотического Пыльника",
} end)

BabbleHerbs:Debug()
BabbleHerbs:SetStrictness(true)

AceLibrary:Register(BabbleHerbs, MAJOR_VERSION, MINOR_VERSION)
BabbleHerbs = nil
