function Cartographer_Quicknotes_OnInit()
  SLASH_CARTOGRAPHERYELLOWNOTE1 = "/ynote";
  SLASH_CARTOGRAPHERYELLOWNOTE2 = "/yellownote";
  SLASH_CARTOGRAPHERREDNOTE1 = "/rnote";
  SLASH_CARTOGRAPHERREDNOTE2 = "/rednote";
  SLASH_CARTOGRAPHERPURPLENOTE1 = "/pnote";
  SLASH_CARTOGRAPHERPURPLENOTE2 = "/purplenote";
  SLASH_CARTOGRAPHERGREENNOTE1 = "/gnote";
  SLASH_CARTOGRAPHERGREENNOTE2 = "/greennote";
  SlashCmdList["CARTOGRAPHERYELLOWNOTE"] = Cartographer_Quicknotes_Yellow;
  SlashCmdList["CARTOGRAPHERREDNOTE"] = Cartographer_Quicknotes_Red;
  SlashCmdList["CARTOGRAPHERPURPLENOTE"] = Cartographer_Quicknotes_Purple;
  SlashCmdList["CARTOGRAPHERGREENNOTE"] = Cartographer_Quicknotes_Green;
end


function Cartographer_Quicknotes_Yellow(text)
   local icon = "Yellow Square".."metamap_iconpack"
   if not Cartographer_Notes:IsIconRegistered(icon) then
      icon = "Star"
   end
   Cartographer_Quicknotes_CreateNote(text,icon)
end

function Cartographer_Quicknotes_Red(text)
   local icon = "Red Square".."metamap_iconpack"
   if not Cartographer_Notes:IsIconRegistered(icon) then
      icon = "Cross"
   end
   Cartographer_Quicknotes_CreateNote(text,icon)
end

function Cartographer_Quicknotes_Purple(text)
   local icon = "Purple Square".."metamap_iconpack"
   if not Cartographer_Notes:IsIconRegistered(icon) then
      icon = "Diamond"
   end
   Cartographer_Quicknotes_CreateNote(text,icon)
end


function Cartographer_Quicknotes_Green(text)
   local icon = "Green Square".."metamap_iconpack"
   if not Cartographer_Notes:IsIconRegistered(icon) then
      icon = "Triangle"     
   end
   Cartographer_Quicknotes_CreateNote(text,icon)
end


function Cartographer_Quicknotes_CreateNote(text,icon)
  local original_arg = text
  text = text:gsub("[%s,]+", " "):trim()
  if text:match("^%d%d?%.%d%d? [^%d].*$") or text:match("^%d%d?%.%d%d?$") then
     text = text:gsub("^(%d%d?)%.(%d%d?)", "%1 %2", 1)
  end
  local x, y, title = (" "):split(text, 3)
  x, y = tonumber(x), tonumber(y)
  if not x or not y then
       x, y = GetPlayerMapPosition("player");
       if x == 0 and y == 0 then
         DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF00Failed: |cFF0000FFUnable to find your location. ");
         return      
       end
       if (original_arg == nil) or (original_arg:len() == 0) then
         if UnitExists("target") then
           if not UnitIsPlayer("target") then
             title = UnitName("target")
           else
             title = "qnote"
           end
         else
            title = "qnote"
         end
       else
          title = original_arg
       end
  else
       x, y = x / 100, y / 100
  end
  if title and title:len() == 0 then
     title = "qnote"
  elseif title == nil then
     title = "qnote"     
  end
  if icon == nil then
     icon = "Square";
  end
  Cartographer_Notes:SetNote(GetRealZoneText(), x, y, icon, (UnitName("player")), 'manual', true, 'title', title);
  DEFAULT_CHAT_FRAME:AddMessage(string.format( "%s %.1f, %.1f%s","|cFFFFFF00Added Note: |r"..title.." ("..GetRealZoneText().." - ", x*100, y*100, ")")); 

end