local L = AceLibrary("AceLocale-2.2"):new("Cartographer_QuestObjectives")

L:RegisterTranslations("enUS", function() return {

	-- GENERAL
	["Quest Objectives"] = true,
	["Quest Objective"] = true,
	
	["Module description"] = "Quest objective mapnotes for Cartographer",

	-- MENU	
	["Select all"] = true,
	["Select none"] = true,
	
	["Icon alpha"] = true,
	["Alpha transparency of the icon"] = true,
	["Icon size"] = true,
	["Size of the icons on the map"] = true,
	["Show minimap icons"] = true,
	["Show quest icons on the minimap"] = true,
	
	["Use Objective Icons"] = true,
	["Use Objective Icons Description"] = "Use icons that represent the objective type",
	
	["Color Icons"] = true,
	["Color Icons Description"] = "Color the icons based on quest difficulty. Only has an effect if 'Use Objective Icons' is off",
	
	["Filter"] = true,
	["Filter out objective types"] = true,
	
	["Only Show Tracked"] = true,
	["Only Show Tracked Description"] = "Only show objectives that are currently being tracked",
	
	["Hide Completed Objectives"] = true,
	["Hide Completed Objectives Description"] = "Completed objectives will not be shown on the map",
	
	["Hide Inactive Quests"] = true,
	["Hide Inactive Quests Description"] = "Only objectives for quests you have in your log will be shown",
	
	["Show Party Quests"] = true,
	["Show Party Quests Description"] = "Show objectives for quests your party members have even if you do not have it",
	
	["Note Sharing"] = true,
	["Note Sharing Description"] = "Options for note sharing",
	
	["Enable Sharing"] = true,
	["Enable Sharing Description"] = "Enable sharing. If disabled, you will not send notes to guildmates or party members when requested. It is recommended to leave this option on.",
	
	["Auto Request Notes"] = true,
	["Auto Request Notes Description"] = "Automatically request notes when you have a quest that is missing notes.",
	
	["Auto Request From Guild"] = true,
	["Auto Request From Guild Description"] = "Automatically request notes from your guild.",
	
	["Auto Request From Group"] = true,
	["Auto Request From Group Description"] = "Automatically request notes from your group.",
	
	["Manual Request"] = true,
	["Manual Request Description"] = "Manually request notes for all quests that need it.",
	
	["Current Quests"] = true,
	["Current Quests Description"] = "Request notes for quests you are currently on.",
	
	["ALL Quests"] = true,
	["ALL Quests Description"] = "Request notes for every quest. This can take a while to finish.",
	
	["Request From Guild"] = true,
	["Request From Guild Description"] = "Request notes from your guild.",
	
	["Request From Group"] = true,
	["Request From Group Description"] = "Request notes from your group.",
	
	["(done)"] = true,
	["N/A"] = true,
	
	-- TOOLTIP
	
	["Source"] = true,

	['Objective Type'] = true,
	["ObjectiveTypes"] = {
		unknown     = "Unknown",
		item        = "Item",
		object      = "Special",
		monster     = "Monster",
		reputation  = "Reputation",
		event       = "Event",
	},
	["QuestDifficulties"] = {
		gray        = "Trivial",
		green       = "Easy",
		yellow      = "Moderate",
		orange      = "Challenging",
		red         = "Impossible",
	},
	
	--DROPDOWN
	
	['Delete'] = true,
	['This Note'] = true,
	
	['All for This Objective'] = true,
	['All for This Objective Description'] = "Delete all notes for this quest objective.",
	['All for This Objective Forever'] = true,
	['All for This Objective Forever Description'] = "Delete all notes for this quest objective, and add the objective to an 'ignote list' so that no notes will be created for it in the future.",
	
	['All from %s'] = true, -- %s is a player's name. IE "All from Jack"
	['All From This Source'] = true,
	['All From This Source Description'] = "Delete all notes received from this source.",
	['All from %s Forever'] = true, -- %s is a player's name. IE "All from Jack Forever"
	['All From This Source Forever'] = true,
	['All From This Source Forever Description'] = "Delete all notes received from this source, and add the source to an 'ignore list' so that no notes will be accepted from it in the future.",
	
	['Confirm Delete'] = true,
	['WARNING: THIS IS NOT UNDOABLE.'] = true,
	
	--FEEDBACK
	
	["%d note has been deleted!"] = true, -- %d is a number, currently always 1, representing the number of notes deleted
	["%d notes have been deleted!"] = true, -- %d is a non-1 number representing the number of notes that were deleted
	
	["Objective database upgraded from version %d to version %d"] = true,
	
	--EXTRA
	["%.0f yd"] = true,
} end)