﻿--local AceAddon = AceLibrary("AceAddon-2.0")
local Tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("Cartographer_Mailboxes")

L:RegisterTranslations("enUS", function() return {
	["Module description"]  = "Mailbox mapnotes for Cartographer (based on Cartographer_Herbalism)",
	["Icon alpha"] = true,
	["Alpha transparency of the icon"] = true,
	["Icon size"] = true,
	["Size of the icons on the map"] = true,
	["Show minimap icons"] = true,
	["Show mailbox icons on the minimap"] = true,
	["Mailboxes"] = true,
	["Mailbox"] = true,
} end)

L:RegisterTranslations("zhTW", function() return {
	["Module description"]  = "Cartographer 模組，紀錄郵箱位置 (靈感來自 Cartographer_Herbalism)。",
	["Icon alpha"] = "圖示透明度",
	["Alpha transparency of the icon"] = "地圖上的圖示透明度",
	["Icon size"] = "圖示大小",
	["Size of the icons on the map"] = "地圖上的圖示大小",
	["Show minimap icons"] = "在小地圖上顯示",
	["Show mailbox icons on the minimap"] = "將郵箱圖示顯示於小地圖上",
	["Mailboxes"] = "郵箱",
	["Mailbox"] = "郵箱",
} end)

L:RegisterTranslations("zhCN", function() return {
--***************************************
-- zhCN Chinese Simplify
-- 2007/07/14 CN3羽月 雪夜之狼
-- E-Mail:xionglingfeng@Gmail.com
--***************************************
	["Module description"]  = "Cartographer 模块，记录邮箱位置 (灵感来自 Cartographer_Herbalism)。",
	["Icon alpha"] = "图标透明度",
	["Alpha transparency of the icon"] = "地图上的图标透明度",
	["Icon size"] = "图标大小",
	["Size of the icons on the map"] = "地图上的图标大小",
	["Show minimap icons"] = "在小地图上显示",
	["Show mailbox icons on the minimap"] = "将邮箱图示显示在小地图上",
	["Mailboxes"] = "邮箱",
	["Mailbox"] = "邮箱",
} end)

L:RegisterTranslations("koKR", function() return {
	["Module description"]  = "맵노트에 우편함을 표시합니다.",
	["Icon alpha"] = "아이콘 투명도",
	["Alpha transparency of the icon"] = "아이콘의 투명도를 조절합니다.",
	["Icon size"] = "아이콘 크기",
	["Size of the icons on the map"] = "아이콘의 크기를 조절합니다.",
	["Show minimap icons"] = "미니맵 아이콘 보기",
	["Show mailbox icons on the minimap"] = "미니맵에 우편함 아이콘을 표시합니다.",
	["Mailboxes"] = "우편함",
	["Mailbox"] = "우편함"
} end)

L:RegisterTranslations("deDE", function() return {
	["Module description"]  = "Briefkasten-Kartennotizen f\195\188r Cartographer (basierend auf Cartographer_Herbalism)",
	["Icon alpha"] = "Tranzparenz",
	["Alpha transparency of the icon"] = "Transparenz der Symbole.",
	["Icon size"] = "Symbolgr\195\182\195\159e",
	["Size of the icons on the map"] = "Gr\195\182\195\159e der Symbole auf der Weltkarte.",
	["Show minimap icons"] = "Minimap-Symbole anzeigen",
	["Show mailbox icons on the minimap"] = "Briefkastensymbole auf der Minimap anzeigen.",
	["Mailboxes"] = "Briefk\195\164sten",
	["Mailbox"] = "Briefkasten",
} end)

L:RegisterTranslations("esES", function() return {
	["Module description"]  = "Notas de Mapa de Buzones para Cartographer (basado en Cartographer_Herbalism)",
	["Icon alpha"] = "Alfa de Icono",
	["Alpha transparency of the icon"] = "Transparencia alfa del icono",
	["Icon size"] = "Tamaño del icono",
	["Size of the icons on the map"] = "Tamaño de los iconos en el mapa",
	["Show minimap icons"] = "Mostrar iconos MiniMapa",
	["Show mailbox icons on the minimap"] = "Mostrar iconos de buzones en el MiniMapa",
	["Mailboxes"] = "Buzones",
	["Mailbox"] = "Buzón",
} end)

local mod = Cartographer:NewModule("Mailboxes", "AceConsole-2.0", "AceEvent-2.0")

mod.icon = {"Interface\\Addons\\Cartographer_Mailboxes\\Artwork\\Mail.tga"}

function mod:OnInitialize()
	local aceopts = {
		transparency = {
			name = L["Icon alpha"],
			desc = L["Alpha transparency of the icon"],
			type = 'range',
			min = 0.1,
			max = 1,
			step = 0.05,
			isPercent = true,
			get = "GetIconAlpha",
			set = "SetIconAlpha",
			order = 1
		},
		iconSize = {
			name = L["Icon size"],
			desc = L["Size of the icons on the map"],
			type = 'range',
			min = 0.5,
			max = 2,
			step = 0.05,
			isPercent = true,
			get = "GetIconScale",
			set = "SetIconScale",
			order = 1
		},
		minimapIcons = {
			name = L["Show minimap icons"],
			desc = L["Show mailbox icons on the minimap"],
			type = 'toggle',
			set = "ToggleShowingMinimapIcons",
			get = "IsShowingMinimapIcons",
			order = 1,
		},
		toggle = {
			name = Cartographer.L["Enabled"],
			desc = Cartographer.L["Suspend/resume this module."],
			type  = 'toggle',
			order = -1,
			get   = function() return Cartographer:IsModuleActive(self) end,
			set   = function() Cartographer:ToggleModuleActive(self) end,
		},
	}

	Cartographer.options.args.Mailboxes = {
		name = L["Mailboxes"],
		desc = L["Module description"],
		type = 'group',
		args = aceopts,
		handler = self,
	}

	AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, Cartographer.options.args.Mailboxes)

	self.db = Cartographer:AcquireDBNamespace("Mailboxes")
	Cartographer:RegisterDefaults("Mailboxes", "profile", {
		iconAlpha = 1,
		iconScale = 1,
		minicons = true,
	})


	if not Cartographer_MailboxesDB then
		Cartographer_MailboxesDB = {}
	end
end

function mod:OnEnable()
	if Cartographer_Notes then
		if not self.iconsregistered then
			Cartographer_Notes:RegisterIcon("mailbox", {	text = L["Mailbox"],
 									path = "Interface\\Addons\\Cartographer_Mailboxes\\Artwork\\Mail.tga",})
			self.iconsregistered = true
		end
		Cartographer_Notes:RegisterNotesDatabase('Mailboxes', Cartographer_MailboxesDB, self)
	else
		Cartographer:ToggleModuleActive(self, false)
	end

	self:RegisterEvent("MAIL_SHOW", function() self:SetNote() end, 2)
end

function mod:OnDisable()
	self:UnregisterAllEvents()
	if Cartographer_Notes then
		Cartographer_Notes:UnregisterNotesDatabase('Mailboxes')
	end
end

function mod:SetNote()
	local x, y = GetPlayerMapPosition("player")
	if x == 0 and y == 0 then return end
	local zone = GetRealZoneText()
	for zone, x_p, y_p, icon, creator, data in Cartographer_Notes:IterateNearbyNotes(zone, x, y, 8, "Mailboxes", nil, true) do
		Cartographer_Notes:DeleteNote(zone, x_p, y_p)
	end
	Cartographer_Notes:SetNote(zone, x, y, "mailbox", "Mailboxes")
end

function mod:OnNoteTooltipRequest(zone, id, mb, minimap)
	Tablet:SetTitle(L["Mailboxes"])
	Tablet:SetTitleColor(0, 0.8, 0)
	if Cartographer_Notes:IsShowingCreator() and not minimap then
		Tablet:AddCategory(
			'columns', 2,
			'hideBlankLine', true
		):AddLine(
			'text', Cartographer_Notes.L["Created by"],
			'text2', L["Mailboxes"]
		)
	end
end

function mod:GetIconScale()
	return self.db.profile.iconScale
end

function mod:SetIconScale(value)
	self.db.profile.iconScale = value
	self:ScheduleEvent("CartographerHerbalism_RefreshMap", Cartographer_Notes.RefreshMap, 0, Cartographer_Notes)
end

function mod:GetIconAlpha()
	return self.db.profile.iconAlpha
end

function mod:SetIconAlpha(value)
	self.db.profile.iconAlpha = value
	self:ScheduleEvent("CartographerHerbalism_RefreshMap", Cartographer_Notes.RefreshMap, 0, Cartographer_Notes)
end

function mod:GetNoteTransparency(zone,id,data)
	return self.db.profile.iconAlpha
end

function mod:GetNoteScaling(zone,id,data)
	return self.db.profile.iconScale
end

function mod:IsShowingMinimapIcons()
	return self.db.profile.minicons
end

function mod:ToggleShowingMinimapIcons()
	self.db.profile.minicons = not self.db.profile.minicons
end

function mod:IsMiniNoteHidden(zone,id,data)
	return not self.db.profile.minicons
end
