-- $Id: pack.lua 46739 2007-08-17 03:02:37Z xionglingfeng $


local L = AceLibrary("AceLocale-2.2"):new("CtMapModIconPack")
L:RegisterTranslations("enUS", function() return {
	["CT_MapMod Iconpack"] = true,
	["White Circle"] = true,
	["Blue Shield"] = true,
	["Green Diamond"] = true,
	["Grey Dot"] = true,
	["Red Cross"] = true,
	["Red Dot"] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
--***************************************
-- zhCN Chinese Simplify
-- 2007/07/14 CN3 ѩҹ֮
-- E-Mail:xionglingfeng@Gmail.com
--***************************************
	["CT_MapMod Iconpack"] = "CT_MapMod ͼ",
	["White Circle"] = "Ȧ",
	["Blue Shield"] = "ʯ",
	["Green Diamond"] = "",
	["Grey Dot"] = "ҵ",
	["Red Cross"] = "ʮ",
	["Red Dot"] = "",
} end)

L:RegisterTranslations("zhTW", function() return {
	["CT_MapMod Iconpack"] = "CT_MapMod D˰",
	["White Circle"] = "Ȧ",
	["Blue Shield"] = "{@ʯ",
	["Green Diamond"] = "G",
	["Grey Dot"] = "c",
	["Red Cross"] = "tʮ",
	["Red Dot"] = "tc",
} end)

local pack = AceLibrary("AceAddon-2.0"):new()

function pack:OnInitialize()
	local iconPath = "Interface\\Addons\\Cartographer_Icons_CtMapModPack\\"

    Cartographer_Icons:RegisterPack('ctmapmod_iconpack',
                                    L["CT_MapMod Iconpack"])

    Cartographer_Icons:RegisterNewIcon('ctmapmod_iconpack',
        "whitecircle",
        L["White Circle"],
        iconPath .. "WhiteCircle")

    Cartographer_Icons:RegisterNewIcon('ctmapmod_iconpack',
        "blueshield",
        L["Blue Shield"],
        iconPath .. "BlueShield")

    Cartographer_Icons:RegisterNewIcon('ctmapmod_iconpack',
        "greendiamond",
        L["Green Diamond"],
        iconPath .. "GreenDiamond")

    Cartographer_Icons:RegisterNewIcon('ctmapmod_iconpack',
        "greydot",
        L["Grey Dot"],
        iconPath .. "GreyDot")

    Cartographer_Icons:RegisterNewIcon('ctmapmod_iconpack',
        "redcross",
        L["Red Cross"],
        iconPath .. "RedCross")

    Cartographer_Icons:RegisterNewIcon('ctmapmod_iconpack',
        "reddot",
        L["Red Dot"],
        iconPath .. "RedDot")
end
