﻿local Tablet = AceLibrary("Tablet-2.0")

local L = AceLibrary("AceLocale-2.2"):new("Cartographer_Icons")

local AceOO = AceLibrary("AceOO-2.0")

L:RegisterTranslations("enUS", function() return {

	["Icon packs"] = true,
	["%s already registered for iconpack %s"] = true,
	["%s not a registered iconpack"] = true,
	["Icon %q override already registered for iconpack %s"] = true,

} end)

L:RegisterTranslations("zhCN", function() return {
--***************************************
-- zhCN Chinese Simplify
-- 2007/07/14 CN3羽月 雪夜之狼
-- E-Mail:xionglingfeng@Gmail.com
--***************************************
	["Icon packs"] = "图标库",
	["%s already registered for iconpack %s"] = "%s 已经加载 %s 图标库",
	["%s not a registered iconpack"] = "%s 不是一个可加载的库",
	["Icon %q override already registered for iconpack %s"] = "图标 %q 成功覆盖到 %s 图标库中",

} end)

L:RegisterTranslations("koKR", function() return {

	["Icon packs"] = "아이콘 모음",
	["%s already registered for iconpack %s"] = "%s|1은;는; %s 아이콘 모음에 이미 등록되어 있습니다.",
	["%s not a registered iconpack"] = "%s|1은;는; 아이콘 모음에 등록되어 있지 않습니다.",
--	["Icon %q override already registered for iconpack %s"] = true,

} end)

L:RegisterTranslations("deDE", function() return {

	["Icon packs"] = "Symbolpakete",

} end)

L:RegisterTranslations("esES", function() return {

	["Icon packs"] = "Paquetes de Iconos",
	["%s already registered for iconpack %s"] = "%s ya está registrado para el paquete de iconos %s",
	["%s not a registered iconpack"] = "%s no es un paquete de iconos registrado",
	["Icon %q override already registered for iconpack %s"] = "Icono %q sobreescribe siempre a registrado por paquete de iconos %s",

} end)


-- which packs are overrinding  a particular icon

local effective_icons = {}

-- original icon texture path

local overrides = {}

-- packs we have

local packs = {}



Cartographer_Icons = Cartographer:NewModule("Icons", "AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")

Cartographer_Icons:RegisterDB("Cartographer_IconsDB")



-- icons we have overwritten

function Cartographer_Icons:OnInitialize()

	self:RegisterDefaults("profile", {

		packs = {},

	})

	-- menu options

	local aceopts = {}

	aceopts.toggle = {

		name = Cartographer.L["Enabled"],

		desc = Cartographer.L["Suspend/resume this module."],

		type  = 'toggle',

		order = -1,

		get   = function() return Cartographer:IsModuleActive(self) end,

		set   = function() Cartographer:ToggleModuleActive(self) end,

	}

	Cartographer.options.args.Icons = {

		name = L["Icon packs"],

		desc = self.notes,

		type = 'group',

		args = aceopts,

		handler = self,

	}

end



function Cartographer_Icons:RegisterPack(pack,displayName)

	if not packs[pack] then

		packs[pack] = {}

		packs[pack].newicons = {}

		packs[pack].override = {}

	end

	packs[pack].name = displayName

	Cartographer.options.args.Icons.args[pack] = {

		name = displayName,

		desc = displayName,

		type = 'toggle',

		get = function()

			return self.db.profile.packs[pack]

		end,

		set = function()

			self.db.profile.packs[pack] = not self.db.profile.packs[pack]

			self:ApplyIconPack(pack)

			self:OnUpdate()

		end,

		disabled = function() return not Cartographer:IsModuleActive(self) end

	}

end



function Cartographer_Icons:RegisterNewIcon(pack,icon,iconDisplayName,texture)

	if not packs[pack] then

		error(L["%s not a registered iconpack"]:format(pack))

		return

	end

	if packs[pack].newicons[icon..pack] then

		error(L["%s already registered for iconpack %s"]:format(iconDisplayName,pack))

	end

	packs[pack].newicons[icon..pack] = {}

	packs[pack].newicons[icon..pack].name = iconDisplayName

	packs[pack].newicons[icon..pack].texture = texture

	self:ApplyIconPack(pack)

end

function Cartographer_Icons:RegisterOverride(pack,icon,texture)

	if not packs[pack] then

		error(L["%s not a registered iconpack"]:format(pack))

	end

	if packs[pack].override[icon] then

		error(L["Icon %q override already registered for iconpack %s"]:format(icon,pack))

	end

	packs[pack].override[icon] = texture

	self:ApplyIconPack(pack)

end



function Cartographer_Icons:OnEnable()

	if not Cartographer_Notes then

		Cartographer:ToggleModuleActive(self, false)

	else

		for pack,_ in pairs(packs) do

			self:ApplyIconPack(k)

		end

		self:OnUpdate()

		self:RegisterEvent("ZONE_CHANGED_NEW_AREA","OnUpdate")

		self:RegisterEvent("Cartographer_MapOpened","OnUpdate")

		self:RegisterEvent("Cartographer_MapClosed","OnUpdate")

		self:RegisterEvent("Cartographer_ChangeZone","OnUpdate")

	end

end



function Cartographer_Icons:OnUpdate()

	-- icon updater

	for k,v in pairs(effective_icons) do

		if Cartographer_Notes:IsIconRegistered(k) then

			if not overrides[k] then

				local origPath = Cartographer_Notes:OverrideIconGraphic(k,packs[v].override[k])

				overrides[k] = origPath

			else

				Cartographer_Notes:OverrideIconGraphic(k,packs[v].override[k])

			end

		end

	end

	Cartographer_Notes:RefreshMap()

end



function Cartographer_Icons:RestoreOriginal(icon)

	if overrides[icon] and Cartographer_Notes:IsIconRegistered(icon) then

		Cartographer_Notes:OverrideIconGraphic(icon,overrides[icon])

		overrides[icon] = nil

	end

end



function Cartographer_Icons:ApplyIconPack(pack)

	-- get the pack state

	local packEnabled = self.db.profile.packs[pack]

	if not packs[pack] then

		return

	end

	-- new icons

	for k,v in pairs(packs[pack].newicons) do

		-- new icon registration

		-- if we are enabled and we havent yet registered an icon lets ad it

		if packEnabled and (not Cartographer_Notes:IsIconRegistered(k)) then

			Cartographer_Notes:RegisterIcon(k,{

				text = v.name,

				path = v.texture,

				showToUser = true,

			})

		-- we have a registered icon but we arent enabled lets cleanup

		elseif (not packEnabled) and Cartographer_Notes:IsIconRegistered(k) then

		 Cartographer_Notes:UnregisterIcon(k)

		end

	end

	-- updated icons

	for k,v in pairs(packs[pack].override) do

		-- override icons .. we can possibly have conflicts in the case last one to override it is the winner

		local hookingPack = effective_icons[k]

		-- we are enabled and we arent the current hook for this icon

		if packEnabled and hookingPack ~= pack then

			effective_icons[k] = pack

		-- if we are hooking this and we are not enabled restore the original

		elseif (not packEnabled) and hookingPack == pack then

			effective_icons[k] = nil

			self:RestoreOriginal(k)

		end

	end

end





-- works

function Cartographer_Icons:OnDisable()

	self:UnregisterAllEvents()

	-- revert the graphics back

	if Cartographer_Notes and Cartographer:IsModuleActive("Notes") then

		for k,v in pairs(effective_icons) do

			self:RestoreOriginal(k)

		end

		effective_icons = {}

		for k,v in pairs(packs) do

			for name,_ in pairs(v.newicons) do

				if Cartographer_Notes:IsIconRegistered(name) then

					Cartographer_Notes:UnregisterIcon(name)

				end

			end

		end

	end

	Cartographer_Notes:RefreshMap()

end