﻿--local AceAddon = AceLibrary("AceAddon-2.0")
local Tablet = AceLibrary("Tablet-2.0")
local Talismonger = AceLibrary("Talismonger-3.0")
local BH = AceLibrary("Babble-Herbs-2.2")
local L = AceLibrary("AceLocale-2.2"):new("Cartographer_Herbalism")
L:RegisterTranslations("enUS", function() return {
	["Filter"] = true,
	["Filter out herbs"] = true,
	["Module description"]  = "Herbalism mapnotes for Cartographer (based on PinPoint by Ammo)",
	["Select all"] = true,
	["Select none"] = true,
	["Icon alpha"] = true,
	["Alpha transparency of the icon"] = true,
	["Icon size"] = true,
	["Size of the icons on the map"] = true,
	["Show minimap icons"] = true,
	["Show herbalism icons on the minimap"] = true,
} end)

L:RegisterTranslations("deDE", function() return {
	["Filter"] = "Filter",
	["Filter out herbs"] = "Kr\195\164uter filtern",
	["Module description"]  = "Kr\195\164uterkunde-Kartennotizen f\195\188r Cartographer (basiert auf PinPoint von Ammo)",  
	["Select all"] = "Alle ausw\195\164hlen",
	["Select none"] = "Nichts ausw\195\164hlen",
	["Icon alpha"] = "Transparenz",
	["Alpha transparency of the icon"] = "Transparenz der Symbole",
	["Icon size"] = "Symbolgr\195\182\195\159e",
	["Size of the icons on the map"] = "Gr\195\182\195\159e der Symbole auf der Weltkarte",
	["Show minimap icons"] = "Minimap-Symbole anzeigen",
	["Show herbalism icons on the minimap"] = "Kr\195\164utersymbole auf der Minimap anzeigen.",
} end)

L:RegisterTranslations("frFR", function() return {
	["Filter"] = "Filtrer",
	["Filter out herbs"] = "Détermine les types d'herbes à afficher.",
	["Module description"]  = "Notes d'herboristerie pour Cartographer (basé sur PinPoint de Ammo).",
	["Select all"] = "Tout sélectionner",
	["Select none"] = "Ne rien sélectionner",
	["Icon alpha"] = "Transparence des icônes",
	["Alpha transparency of the icon"] = "Détermine la transparence des icônes.",
	["Icon size"] = "Taille des icônes",
	["Size of the icons on the map"] = "Détermine la taille des icônes sur la carte.",
	["Show minimap icons"] = "Afficher les icônes sur la minicarte",
	["Show herbalism icons on the minimap"] = "Affiche les icônes des herbes sur la minicarte.",
} end)

L:RegisterTranslations("koKR", function() return {
	["Filter"] = "항목 분류",
	["Filter out herbs"] = "약초를 항목에 따라 분류하여 표시합니다.",
	["Module description"] = "맵노트에 약초를 표시합니다.",
	["Select all"] = "모두 선택",
	["Select none"] = "선택 해제",
	["Icon alpha"] = "아이콘 투명도",
	["Alpha transparency of the icon"] = "아이콘의 투명도를 조절합니다.",
	["Icon size"] = "아이콘 크기",
	["Size of the icons on the map"] = "아이콘의 크기를 조절합니다.",
	["Show minimap icons"] = "미니맵 아이콘 보기",
	["Show herbalism icons on the minimap"] = "미니맵에 약초 아이콘을 표시합니다.",
} end)

L:RegisterTranslations("zhCN", function() return {
	["Filter"] = "筛选",
	["Filter out herbs"] = "草药筛选",
	["Module description"]  = "Cartographer 采药助手 （灵感来自 Ammo 的 PinPoint 插件）",
	["Select all"] = "全部选择",
	["Select none"] = "全部取消",
	["Icon alpha"] = "图标透明度",
	["Alpha transparency of the icon"] = "设定图标透明度",
	["Icon size"] = "图标大小",
	["Size of the icons on the map"] = "设定图标大小",
	["Show minimap icons"] = "在小地图上显示",
	["Show herbalism icons on the minimap"] = "在小地图上显示草药小图标",
} end)

L:RegisterTranslations("zhTW", function() return {
	["Filter"] = "過濾",
	["Filter out herbs"] = "過濾草藥",	
	["Module description"]  = "Cartographer 模組，紀錄草藥位置 (靈感來自 Ammo 的 PinPoint)。",
	["Select all"] = "全部選取",
	["Select none"] = "全部取消",
	["Icon alpha"] = "圖示透明度",
	["Alpha transparency of the icon"] = "地圖上的圖示透明度",
	["Icon size"] = "圖示大小",
	["Size of the icons on the map"] = "地圖上的圖示大小",
	["Show minimap icons"] = "在小地圖上顯示",
	["Show herbalism icons on the minimap"] = "將草藥圖示顯示於小地圖上",
} end)


L:RegisterTranslations("esES", function() return {
	["Filter"] = "Filtro",
	["Filter out herbs"] = "Filtra las hierbas",  
	["Module description"]  = "Notas de mapa de Herborister\195\173a para Cartographer (basado en PinPoint por Ammo)",
	["Select all"] = "Seleccionar todo",
	["Select none"] = "No seleccionar nada",
	["Icon alpha"] = "Transparencia de icono",
	["Alpha transparency of the icon"] = "Transparencia de los iconos",
	["Icon size"] = "Tama\195\177o de icono",
	["Size of the icons on the map"] = "Tama\195\177o de los iconos en el mapa",
	["Show minimap icons"] = "Mostrar iconos en minimapa",
	["Show herbalism icons on the minimap"] = "Muestra los iconos de herborister\195\173a en el minimapa",
} end)
-- Russian localization by StingerSoft (Eritnull aka Шептун)
L:RegisterTranslations("ruRU", function() return {
	["Filter"] = "Фильтр",
	["Filter out herbs"] = "Фильтр трав",
	["Module description"]  = "Записи на карте о травах для Картографа (основано на PinPoint by Ammo)",
	["Select all"] = "Выбрать все",
	["Select none"] = "Отменить все",
	["Icon alpha"] = "Прозрачность иконки",
	["Alpha transparency of the icon"] = "Прозрачность иконки",
	["Icon size"] = "Размер иконки",
	["Size of the icons on the map"] = "Размер иконки на карте",
	["Show minimap icons"] = "Показ иконку на мини-карте",
	["Show herbalism icons on the minimap"] = "Показать иконки трав на мини-карте",
} end)

local mod = Cartographer:NewModule("Herbalism", "AceConsole-2.0", "AceEvent-2.0")

local herbSpell = GetSpellInfo(9134)

mod.icon = {
	["Black Lotus"] = {
		text = BH["Black Lotus"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbBlackLotus.tga",
		width = 12,
		height = 12
	},
	["Blindweed"] = {
		text = BH["Blindweed"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbBlindweed.tga",
		width = 12,
		height = 12
	},
	["Briarthorn"] = {
		text = BH["Briarthorn"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbBriarthorn.tga",
		width = 12,
		height = 12
	},
	["Bruiseweed"] = {
		text = BH["Bruiseweed"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbBruiseweed.tga",
		width = 12,
		height = 12
	},
	["Dreamfoil"] = {
		text = BH["Dreamfoil"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbDreamfoil.tga",
		width = 12,
		height = 12
	},
	["Earthroot"] = {
		text = BH["Earthroot"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbEarthroot.tga",
		width = 12,
		height = 12
	},
	["Fadeleaf"] = {
		text = BH["Fadeleaf"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbFadeleaf.tga",
		width = 12,
		height = 12
	},
	["Felweed"] = {
		text = BH["Felweed"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbFelweed.tga",
		width = 12,
		height = 12
	},
	["Firebloom"] = {
		text = BH["Firebloom"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbFirebloom.tga",
		width = 12,
		height = 12
	},
	["Goldthorn"] = {
		text = BH["Goldthorn"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbGoldthorn.tga",
		width = 12,
		height = 12
	},
	["Grave Moss"] = {
		text = BH["Grave Moss"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbGraveMoss.tga",
		width = 12,
		height = 12
	},
	["Gromsblood"] = {
		text = BH["Gromsblood"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbGromsblood.tga",
		width = 12,
		height = 12
	},
	["Icecap"] = {
		text = BH["Icecap"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbIcecap.tga",
		width = 12,
		height = 12
	},
	["Kingsblood"] = {
		text = BH["Kingsblood"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbKingsblood.tga",
		width = 12,
		height = 12
	},
	["Liferoot"] = {
		text = BH["Liferoot"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbLiferoot.tga",
		width = 12,
		height = 12
	},
	["Mageroyal"] = {
		text = BH["Mageroyal"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbMageroyal.tga",
		width = 12,
		height = 12
	},
	["Peacebloom"] = {
		text = BH["Peacebloom"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbPeacebloom.tga",
		width = 12,
		height = 12
	},
	["Plaguebloom"] = {
		text = BH["Plaguebloom"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbPlaguebloom.tga",
		width = 12,
		height = 12
	},
	["Silverleaf"] = {
		text = BH["Silverleaf"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbSilverleaf.tga",
		width = 12,
		height = 12
	},
	["Stranglekelp"] = {
		text = BH["Stranglekelp"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbStranglekelp.tga",
		width = 12,
		height = 12
	},
	["Sungrass"] = {
		text = BH["Sungrass"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbSungrass.tga",
		width = 12,
		height = 12
	},
	["Swiftthistle"] = {
		text = BH["Swiftthistle"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbSwiftthistle.tga",
		width = 12,
		height = 12
	},
	["Wildvine"] = {
		text = BH["Wildvine"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbKingsblood.tga",
		width = 12,
		height = 12
	},
	["Wintersbite"] = {
		text = BH["Wintersbite"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbWintersbite.tga",
		width = 12,
		height = 12
	},
	["Arthas' Tears"] = {
		text = BH["Arthas' Tears"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbArthasTears.tga",
		width = 12,
		height = 12
	},
	["Ghost Mushroom"] = {
		text = BH["Ghost Mushroom"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbGhostMushroom.tga",
		width = 12,
		height = 12
	},
	["Golden Sansam"] = {
		text = BH["Golden Sansam"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbGoldenSansam.tga",
		width = 12,
		height = 12
	},
	["Khadgar's Whisker"] = {
		text = BH["Khadgar's Whisker"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbKhadgarsWhisker.tga",
		width = 12,
		height = 12
	},
	["Mountain Silversage"] = {
		text = BH["Mountain Silversage"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbMountainSilversage.tga",
		width = 12,
		height = 12
	},
	["Purple Lotus"] = {
		text = BH["Purple Lotus"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbPurpleLotus.tga",
		width = 12,
		height = 12
	},
	["Wild Steelbloom"] = {
		text = BH["Wild Steelbloom"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbWildSteelbloom.tga",
		width = 12,
		height = 12
	},
	["Bloodthistle"] = {
		text = BH["Bloodthistle"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbGromsblood.tga",
		width = 12,
		height = 12
	},
	["Mana Thistle"] = {
		text = BH["Mana Thistle"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbManaThistle.tga",
		width = 12,
		height = 12
	},
	["Netherbloom"] = {
		text = BH["Netherbloom"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbNetherbloom.tga",
		width = 12,
		height = 12
	},
	["Nightmare Vine"] = {
		text = BH["Nightmare Vine"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbNightmareVine.tga",
		width = 12,
		height = 12
	},
	["Ragveil"] = {
		text = BH["Ragveil"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbRagveil.tga",
		width = 12,
		height = 12
	},
	["Terocone"] = {
		text = BH["Terocone"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbTerocone.tga",
		width = 12,
		height = 12
	},
	["Flame Cap"] = {
		text = BH["Flame Cap"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbFlameCap.tga",
		width = 12,
		height = 12
	},
	["Dreaming Glory"] = {
		text = BH["Dreaming Glory"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbDreamingGlory.tga",
		width = 12,
		height = 12
	},
	["Fel Lotus"] = {
		text = BH["Fel Lotus"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbFelLotus.tga",
		width = 12,
		height = 12
	},
	["Ancient Lichen"] = {
		text = BH["Ancient Lichen"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbAncientLichen.tga",
		width = 12,
		height = 12
	},
	["Netherdust Bush"] = {
		text = BH["Netherdust Bush"],
		path = "Interface\\Addons\\Cartographer_Herbalism\\Artwork\\HerbNetherdust.tga",
		width = 12,
		height = 12
	},
}

function mod:OnInitialize()
	self.db = Cartographer:AcquireDBNamespace("Herbalism")
	Cartographer:RegisterDefaults("Herbalism", "profile", {
		filter = {
			['*'] = true,
		},
		iconAlpha = 1,
		iconScale = 1,
		minicons = true,
	})
	
	local aceopts = {}
	aceopts.trans = {
		name = L["Icon alpha"],
		desc = L["Alpha transparency of the icon"],
		type = 'range',
		min = 0.1,
		max = 1,
		step = 0.01,
		bigStep = 0.05,
		isPercent = true,
		get = "GetIconAlpha",
		set = "SetIconAlpha",
		order = 1
	}
	aceopts.scal = {
		name = L["Icon size"],
		desc = L["Size of the icons on the map"],
		type = 'range',
		min = 0.5,
		max = 2,
		step = 0.01,
		bigStep = 0.05,
		isPercent = true,
		get = "GetIconScale",
		set = "SetIconScale",
		order = 1
	}
	aceopts.minicons = {
		name = L["Show minimap icons"],
		desc = L["Show herbalism icons on the minimap"],
		type = 'toggle',
		set = "ToggleShowingMinimapIcons",
		get = "IsShowingMinimapIcons",
		order = 1,
	}
	aceopts.toggle = {
		name = Cartographer.L["Enabled"],
		desc = Cartographer.L["Suspend/resume this module."],
		type  = 'toggle',
		order = -1,
		get   = function() return Cartographer:IsModuleActive(self) end,
		set   = function() Cartographer:ToggleModuleActive(self) end,
	}
	aceopts.filter = {
		name = L["Filter"],
		desc = L["Filter out herbs"],
		type = 'group',
		args = {
			all = {
				name = L["Select all"],
				desc = L["Select all"],
				type = 'execute',
				func = function()
					for k in pairs(self.icon) do
						self:ToggleShowingHerb(k, true)
					end
				end,
				order = 1,
			},
			none = {
				name = L["Select none"],
				desc = L["Select none"],
				type = 'execute',
				func = function()
					for k in pairs(self.icon) do
						self:ToggleShowingHerb(k, false)
					end
				end,
				order = 2,
			},
			blank = {
				type = 'header',
				order = 3,
			}
		}
	}
	local function isShowingHerb(herb)
		return self:IsShowingHerb(herb)
	end
	local function toggleShowingHerb(herb, value)
		return self:ToggleShowingHerb(herb, value)
	end
	for k,v in pairs(self.icon) do
		local k = k
		aceopts.filter.args[k] = {
			name = v.text,
			desc = v.text,
			type = "toggle",
			get = isShowingHerb,
			set = toggleShowingHerb,
			passValue = k,
		}
	end
	
	Cartographer.options.args["Herbalism"] = {
		name = herbSpell,
		desc = L["Module description"],
		type = 'group',
		args = aceopts,
		handler = self,
	}
	AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, Cartographer.options.args["Herbalism"])
	Cartographer:GetModule('Professions').addons[herbSpell] = self
	
	if not Cartographer_HerbalismDB then
		Cartographer_HerbalismDB = {}
	end
end

function mod:OnEnable()
	if Cartographer_Notes then
		if not self.iconsregistered then
			for k,v in pairs(self.icon) do
				Cartographer_Notes:RegisterIcon(k, v)
			end
			self.iconsregistered = true
		end
		
		Cartographer_Notes:RegisterNotesDatabase('Herbalism', Cartographer_HerbalismDB, self)
	else
		Cartographer:ToggleModuleActive(self, false)
	end
	Talismonger:TrackNode(BH["Silverleaf"])
	Talismonger:TrackNode(BH["Peacebloom"])
	Talismonger:TrackNode(BH["Mageroyal"])
	Talismonger:TrackNode(BH["Bruiseweed"])
	Talismonger:TrackNode(BH["Kingsblood"])
	Talismonger:TrackNode(BH["Fadeleaf"])
	Talismonger:TrackNode(BH["Stranglekelp"])
	Talismonger:TrackNode(BH["Liferoot"])
	Talismonger:TrackNode(BH["Briarthorn"])
	Talismonger:TrackNode(BH["Earthroot"])
	Talismonger:TrackNode(BH["Sungrass"])
	Talismonger:TrackNode(BH["Blindweed"])
	Talismonger:TrackNode(BH["Gromsblood"])
	Talismonger:TrackNode(BH["Dreamfoil"])
	Talismonger:TrackNode(BH["Firebloom"])
	Talismonger:TrackNode(BH["Arthas' Tears"])
	Talismonger:TrackNode(BH["Purple Lotus"])
	Talismonger:TrackNode(BH["Goldthorn"])
	Talismonger:TrackNode(BH["Wildvine"])
	Talismonger:TrackNode(BH["Grave Moss"])
	Talismonger:TrackNode(BH["Mountain Silversage"])
	Talismonger:TrackNode(BH["Black Lotus"])
	Talismonger:TrackNode(BH["Ghost Mushroom"])
	Talismonger:TrackNode(BH["Golden Sansam"])
	Talismonger:TrackNode(BH["Icecap"])
	Talismonger:TrackNode(BH["Khadgar's Whisker"])
	Talismonger:TrackNode(BH["Plaguebloom"])
	Talismonger:TrackNode(BH["Swiftthistle"])
	Talismonger:TrackNode(BH["Wild Steelbloom"])
	Talismonger:TrackNode(BH["Wintersbite"])
	Talismonger:TrackNode(BH["Felweed"])
	Talismonger:TrackNode(BH["Bloodthistle"])
	Talismonger:TrackNode(BH["Mana Thistle"])
	Talismonger:TrackNode(BH["Netherbloom"])
	Talismonger:TrackNode(BH["Nightmare Vine"])
	Talismonger:TrackNode(BH["Ragveil"])
	Talismonger:TrackNode(BH["Terocone"])
	Talismonger:TrackNode(BH["Flame Cap"])
	Talismonger:TrackNode(BH["Dreaming Glory"])
	Talismonger:TrackNode(BH["Fel Lotus"])
	Talismonger:TrackNode(BH["Ancient Lichen"])
	Talismonger:TrackNode(BH["Netherdust Bush"])
	self:RegisterEvent("Talismonger_Node")
end
local herbing = select(1,GetSpellInfo(2366))
function mod:Talismonger_Node(spell, what)
	if spell == "Herb Gathering" or spell == herbing then
		self:SetNote(what)
	end
end

function mod:OnDisable()
	self:UnregisterAllEvents()
	if Cartographer_Notes then
		Cartographer_Notes:UnregisterNotesDatabase('Herbalism')
	end
end

do
	local rares = {
		["Flame Cap"] = "Ragveil",
	}
	function mod:SetNote(what)
		local x, y = GetPlayerMapPosition("player")
		if x == 0 and y == 0 then return end
		local zone = GetRealZoneText()
		local herb = BH:GetReverseTranslation(what)
		local original = herb
		if rares[herb] then herb = rares[herb] end
		for zone, x_p, y_p, icon, creator, data in Cartographer_Notes:IterateNearbyNotes(zone, x, y, 10, "Herbalism", nil, true) do
			if icon == herb or icon == original then
				Cartographer_Notes:DeleteNote(zone, x_p, y_p)
			end
		end
		Cartographer_Notes:SetNote(zone, x, y, herb, "Herbalism")
	end
end

function mod:OnNoteTooltipRequest(zone, id, herb, minimap)
	Tablet:SetTitle(BH[herb])
	Tablet:SetTitleColor(0, 0.8, 0)
	if Cartographer_Notes:IsShowingCreator() and not minimap then
		Tablet:AddCategory(
			'columns', 2,
			'hideBlankLine', true
		):AddLine(
			'text', Cartographer_Notes.L["Created by"],
			'text2', herbSpell 
		)
	end
end

function mod:IsNoteHidden(zone, id, herb)
	return not self.db.profile.filter[herb]
end

function mod:IsShowingHerb(herb)
	return self.db.profile.filter[herb]
end

function mod:ToggleShowingHerb(herb, value)
	if value == nil then
		value = not self.db.profile.filter[herb]
	end
	self.db.profile.filter[herb] = value
	self:ScheduleEvent("CartographerHerbalism_RefreshMap", Cartographer_Notes.RefreshMap, 0, Cartographer_Notes)
end

function mod:GetIconScale()
	return self.db.profile.iconScale
end

function mod:SetIconScale(value)
	self.db.profile.iconScale = value
	self:ScheduleEvent("CartographerHerbalism_RefreshMap", Cartographer_Notes.RefreshMap, 0, Cartographer_Notes)
end
function mod:GetIconAlpha()
	return self.db.profile.iconAlpha
end

function mod:SetIconAlpha(value)
	self.db.profile.iconAlpha = value
	self:ScheduleEvent("CartographerHerbalism_RefreshMap", Cartographer_Notes.RefreshMap, 0, Cartographer_Notes)
end

function mod:GetNoteTransparency(zone,id,data)
	return self.db.profile.iconAlpha
end
function mod:GetNoteScaling(zone,id,data)
	return self.db.profile.iconScale
end
function mod:IsShowingMinimapIcons()
	return self.db.profile.minicons
end
function mod:ToggleShowingMinimapIcons()
	self.db.profile.minicons = not self.db.profile.minicons
end
function mod:IsMiniNoteHidden(zone,id,data)
	return not self.db.profile.minicons
end
