﻿local AceAddon = AceLibrary("AceAddon-2.0")
local Tablet = AceLibrary("Tablet-2.0")
local BG = AceLibrary("Babble-Gas-2.2")
local Talismonger = AceLibrary("Talismonger-3.0")

local L = AceLibrary("AceLocale-2.2"):new("Cartographer_ExtractGas")
L:RegisterTranslations("enUS", function() return {
	["Filter"] = true,
	["Filter out gases"] = true,
	["Module description"] = "Gas Extraction mapnotes for Cartographer (based on PinPoint by Ammo)",
	["Select all"] = true,
	["Select none"] = true,
	["Icon alpha"] = true,
	["Alpha transparency of the icon"] = true,
	["Icon size"] = true,
	["Size of the icons on the map"] = true,
	["Show minimap icons"] = true,
	["Show gas icons on the minimap"] = true,
} end)

L:RegisterTranslations("deDE", function() return {
	["Filter"] = "Filter",
	["Filter out gases"] = "Gase herausfiltern",
	["Module description"] = "Gas-Extraktions Kartenpunkte für Cartographer (basierend auf PinPoint von Ammo)",
	["Select all"] = "Alle ausw\195\164hlen",
	["Select none"] = "Nichts ausw\195\164hlen",
	["Icon alpha"] = "Transparenz",
	["Alpha transparency of the icon"] = "Transparenz der Symbole.",
	["Icon size"] = "Symbolgr\195\182\195\159e",
	["Size of the icons on the map"] = "Gr\195\182\195\159e der Symbole auf der Weltkarte.",
	["Show minimap icons"] = "Minimap-Symbole anzeigen",
	["Show gas icons on the minimap"] = "Gas-Symbole auf der Minimap anzeigen",
} end)

L:RegisterTranslations("frFR", function() return {
	["Filter"] = "Filtrer",
	["Filter out gases"] = "Détermine les types de gaz à afficher.",
	["Module description"] = "Notes d'extraction des gaz pour Cartographer (basé sur PinPoint de Ammo).",
	["Select all"] = "Tout sélectionner",
	["Select none"] = "Ne rien sélectionner",
	["Icon alpha"] = "Transparence des icônes",
	["Alpha transparency of the icon"] = "Détermine la transparence des icônes.",
	["Icon size"] = "Taille des icônes",
	["Size of the icons on the map"] = "Détermine la taille des icônes sur la carte.",
	["Show minimap icons"] = "Afficher les icônes sur la minicarte",
	["Show gas icons on the minimap"] = "Affiche les icônes des gaz sur la minicarte.",
} end)

L:RegisterTranslations("esES", function() return {
	["Filter"] = "Filtro",
	["Select all"] = "Seleccionar todo",
	["Select none"] = "No seleccionar nada",
	["Icon alpha"] = "Transparencia de icono",
	["Alpha transparency of the icon"] = "Transparencia de los iconos",
	["Icon size"] = "Tama\195\177o de icono",
	["Size of the icons on the map"] = "Tama\195\177o de los iconos en el mapa",
	["Show minimap icons"] = "Mostrar iconos en minimapa",
} end)

L:RegisterTranslations("koKR", function() return {
	["Filter"] = "항목 분류",
	["Filter out gases"] = "가스를 항목에 따라 분류하여 표시합니다.",
	["Module description"] = "맵노트에 가스를 표시합니다.",
	["Select all"] = "모두 선택",
	["Select none"] = "선택 해제",
	["Icon alpha"] = "아이콘 투명도",
	["Alpha transparency of the icon"] = "아이콘의 투명도를 조절합니다.",
	["Icon size"] = "아이콘 크기",
	["Size of the icons on the map"] = "아이콘의 크기를 조절합니다.",
	["Show minimap icons"] = "미니맵 아이콘 보기",
	["Show gas icons on the minimap"] = "미니맵에 가스 아이콘을 표시합니다.",
} end)

L:RegisterTranslations("zhTW", function() return {
	["Filter"] = "篩檢",
	--["Filter out gases"] = "",
  	--["Module description"] = "Gas Extraction mapnotes for Cartographer",
	["Select all"] = "全部選擇",
	["Select none"] = "全部取消",
	["Icon alpha"] = "圖標透明度",
	["Alpha transparency of the icon"] = "圖標的透明度",
	["Icon size"] = "圖標大小",
	["Size of the icons on the map"] = "在世界地圖上圖標的大小",
	["Show minimap icons"] = "顯示小地圖圖標",
	["Show gas icons on the minimap"] = "在小地圖上顯示gas圖標",
} end)

L:RegisterTranslations("zhCN", function() return {
	["Filter"] = "筛选",
	["Filter out gases"] = "微粒筛选",
  ["Module description"] = "元素微粒标识工具",
	["Select all"] = "全部选择",
	["Select none"] = "全部取消",
	["Icon alpha"] = "图标透明度",
	["Alpha transparency of the icon"] = "图标的透明度",
	["Icon size"] = "图标大小",
	["Size of the icons on the map"] = "在世界地图上图标的大小",
	["Show minimap icons"] = "显示小地图图标",
	["Show gas icons on the minimap"] = "在小地图上显示微粒图标",
} end)

local extractSpell = GetSpellInfo(30427)
local engineeringSpell = GetSpellInfo(4036)

local mod = Cartographer:NewModule("ExtractGas", "AceConsole-2.0", "AceEvent-2.0")
local icon_path = "Interface\\AddOns\\Cartographer_ExtractGas\\Artwork\\"
local icon_list = {
	["Windy Cloud"]   = "INV_Elemental_Mote_Air01",
	["Arcane Vortex"] = "INV_Elemental_Mote_Mana",
	["Felmist"]       = "INV_Elemental_Mote_Shadow01",
	["Swamp Gas"]     = "INV_Elemental_Mote_Water01",
}
local reverse_list = {
	["Air"]    = "Windy Cloud",
	["Mana"]   = "Arcane Vortex",
	["Shadow"] = "Felmist",
	["Water"]  = "Swamp Gas",
}
mod.icon = {}
function mod:OnInitialize()
	self.db = Cartographer:AcquireDBNamespace("ExtractGas")
	Cartographer:RegisterDefaults("ExtractGas", "profile", {
		filter = {
			['*'] = true,
		},
		iconAlpha = 1,
		iconScale = 1,
		minicons = true,
	})

	local aceopts = {}
	aceopts.toggle = {
		name = Cartographer.L["Enabled"],
		desc = Cartographer.L["Suspend/resume this module."],
		type  = 'toggle',
		order = -1,
		get   = function() return Cartographer:IsModuleActive(self) end,
		set   = function() Cartographer:ToggleModuleActive(self) end,
	}
	aceopts.trans = {
		name = L["Icon alpha"],
		desc = L["Alpha transparency of the icon"],
		type = 'range',
		min = 0.1,
		max = 1,
		step = 0.05,
		isPercent = true,
		get = "GetIconAlpha",
		set = "SetIconAlpha",
		order = 1
	}
	aceopts.scal = {
		name = L["Icon size"],
		desc = L["Size of the icons on the map"],
		type = 'range',
		min = 0.5,
		max = 2,
		step = 0.05,
		isPercent = true,
		get = "GetIconScale",
		set = "SetIconScale",
		order = 1
	}
	aceopts.minicons = {
		name = L["Show minimap icons"],
		desc = L["Show gas icons on the minimap"],
		type = 'toggle',
		set = "ToggleShowingMinimapIcons",
		get = "IsShowingMinimapIcons",
		order = 1,
	}

	aceopts.filter = {
		name = L["Filter"],
		desc = L["Filter out gases"],
		type = 'group',
		args = {
			all = {
				name = L["Select all"],
				desc = L["Select all"],
				type = 'execute',
				func = function()
					for k in pairs(self.icon) do
						self:ToggleShowingGas(k, true)
					end
				end,
				order = 1,
			},
			none = {
				name = L["Select none"],
				desc = L["Select none"],
				type = 'execute',
				func = function()
					for k in pairs(self.icon) do
						self:ToggleShowingGas(k, false)
					end
				end,
				order = 2,
			},
			blank = {
				type = 'header',
				order = 3,
			}
		}
	}
	for k,v in pairs(icon_list) do
		mod.icon[k] = {
			text = BG[k],
			path = icon_path..v,
			width = 14,
			height = 14,
		}
		local k = k
		aceopts.filter.args[k] = {
			name = BG[k],
			desc = BG[k],
			type = 'toggle',
			get = function()
				return self:IsShowingGas(k)
			end,
			set = function(value)
				return self:ToggleShowingGas(k, value)
			end,
		}
		Talismonger:TrackNode(BG[k])
	end
	
	Cartographer.options.args["ExtractGas"] = {
		name = extractSpell,
		desc = L["Module description"],
		type = 'group',
		args = aceopts,
		handler = self,
	}
	Cartographer:GetModule('Professions').addons[engineeringSpell] = self
	AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, Cartographer.options.args["ExtractGas"])

	if not Cartographer_ExtractGasDB then
		Cartographer_ExtractGasDB = {}
	else
		local db_version = Cartographer_ExtractGasDB.version
		for _, zone in pairs(Cartographer_ExtractGasDB) do
			if type(zone) == "table" then
				for id, data in pairs(zone) do
					if reverse_list[data] then
						zone[id] = reverse_list[data]
					end
				end
			end
		end
	end
end

function mod:OnEnable()
	if Cartographer_Notes then
		if not self.iconsregistered then
			for k,v in pairs(self.icon) do
				Cartographer_Notes:RegisterIcon(k, v)
			end
			self.iconsregistered = true
		end

		Cartographer_Notes:RegisterNotesDatabase('ExtractGas', Cartographer_ExtractGasDB, self)
	else
		Cartographer:ToggleModuleActive(self, false)
	end
	self:RegisterEvent("Talismonger_Node")
end

function mod:OnDisable()
	self:UnregisterAllEvents()
	if Cartographer_Notes then
		Cartographer_Notes:UnregisterNotesDatabase('ExtractGas')
	end
end

function mod:SetNote(what)
	local x, y = GetPlayerMapPosition("player")
	if x == 0 and y == 0 then return end
	local zone = GetRealZoneText()
	local addNode = true
	for zone, x_p, y_p, icon, creator, data in Cartographer_Notes:IterateNearbyNotes(zone, x, y, 10, "ExtractGas", nil, true) do
		if icon == what then
			Cartographer_Notes:DeleteNote(zone, x_p, y_p)
		end
	end
	if addNode then
		Cartographer_Notes:SetNote(zone, x, y, what, "ExtractGas")
	end
end

function mod:OnNoteTooltipRequest(zone, id, gas, minimap)
	if not BG:HasTranslation(gas) then
		if reverse_list[gas] then
			mineral = reverse_list[gas]
		end
	end
	Tablet:SetTitle(BG[gas])
	Tablet:SetTitleColor(0, 0.8, 0)
	if Cartographer_Notes:IsShowingCreator() and not minimap then
		Tablet:AddCategory(
			'columns', 2,
			'hideBlankLine', true
		):AddLine(
			'text', Cartographer_Notes.L["Created by"],
			'text2', extractSpell
		)
	end
end

function mod:RegisterGas(what)
	if what and what:len() > 0 then
		self:SetNote(BG.reverse[what])
	end
end

function mod:Talismonger_Node(spell,what)
	if spell == "Extract Gas" or spell == extractSpell then
		self:RegisterGas(what)
	end
end

function mod:IsNoteHidden(zone, id, gas)
	return not self.db.profile.filter[gas]
end

function mod:IsShowingGas(gas)
	return self.db.profile.filter[gas]
end

function mod:ToggleShowingGas(gas, value)
	if value == nil then
		value = not self.db.profile.filter[gas]
	end
	self.db.profile.filter[gas] = value

	Cartographer_Notes:RefreshMap()
end
function mod:GetIconScale()
	return self.db.profile.iconScale
end

function mod:SetIconScale(value)
	self.db.profile.iconScale = value
	Cartographer_Notes:RefreshMap()
end
function mod:GetIconAlpha()
	return self.db.profile.iconAlpha
end

function mod:SetIconAlpha(value)
	self.db.profile.iconAlpha = value
	Cartographer_Notes:RefreshMap()
end

function mod:GetNoteTransparency(zone,id,data)
	return self.db.profile.iconAlpha
end
function mod:GetNoteScaling(zone,id,data)
	return self.db.profile.iconScale
end
function mod:IsShowingMinimapIcons()
	return self.db.profile.minicons
end
function mod:ToggleShowingMinimapIcons()
	self.db.profile.minicons = not self.db.profile.minicons
end
function mod:IsMiniNoteHidden(zone,id,data)
	return not self.db.profile.minicons
end
