﻿Cartographer_InstanceMaps_Rotations = {
	-- currently only 90*k degree rotations are supported since in-between cases causes texture bleeding.
	["Dire Maul"] = 180,
	["Shadowfang Keep"] = 90,
	["The Deadmines"] = 270,
	["Razorfen Kraul"] = 270,
	["Old Hillsbrad Foothills"] = 90,
	["The Black Morass"] = 90,
	["Hellfire Ramparts"] = 90,
	["Zul'Gurub"] = 90,
	["Zul'Farrak"] = 90,
	["Hyjal Summit"] = 90,
	["Black Temple"] = 270,
	["Zul'Aman"] = 90,
}

Cartographer_InstanceMaps_Floors = {
	["Karazhan"] = {5, 140, 260},
	["Upper Blackrock Spire"] = {0},
}

Cartographer_InstanceMaps_MapData = {
	["Ahn'Qiraj"] = 
		"\031\017\245\022\160\143\032\142\248\107\186\241\038\012\115\171\150\118\126\068\081\012\054\068\176\066\004\196" ..
		-- tex:"1f11f516a08f208ef86bbaf1260c73ab"; x:1017.852966; y:728.192505; z:-529.042053
		"\083\191\015\213\120\131\175\219\015\096\092\010\111\094\186\066\075\059\191\068\081\012\118\068\176\066\004\196" ..
		-- tex:"53bf0fd57883afdb0f605c0a6f5eba42"; x:1529.852966; y:984.192505; z:-529.042053
		"\197\002\184\033\019\108\241\241\156\000\130\157\240\178\016\225\075\059\191\068\040\006\155\068\176\066\004\196" ..
		-- tex:"c502b821136cf1f19c00829df0b210e1"; x:1529.852966; y:1240.192505; z:-529.042053
		"\196\240\061\152\020\227\086\175\088\208\216\009\062\186\079\199\075\059\159\068\081\012\118\068\176\066\004\196" ..
		-- tex:"c4f03d9814e356af58d0d8093eba4fc7"; x:1273.852966; y:984.192505; z:-529.042053
		"\080\166\128\233\029\217\119\225\204\000\070\231\107\122\181\192\075\059\159\068\040\006\155\068\176\066\004\196" ..
		-- tex:"50a680e91dd977e1cc0046e76b7ab5c0"; x:1273.852966; y:1240.192505; z:-529.042053
		"\199\098\237\177\037\225\230\245\242\219\047\027\135\146\101\177\150\118\126\068\040\006\155\068\176\066\004\196" ..
		-- tex:"c762edb125e1e6f5f2db2f1b879265b1"; x:1017.852966; y:1240.192505; z:-529.042053
		"\097\095\030\196\038\058\022\189\004\167\114\018\155\121\135\048\075\059\159\068\081\012\054\068\176\066\004\196" ..
		-- tex:"615f1ec4263a16bd04a772129b798730"; x:1273.852966; y:728.192505; z:-529.042053
		"\111\068\170\239\156\206\184\136\039\220\077\113\033\052\094\037\150\118\126\068\081\012\118\068\176\066\004\196" ..
		-- tex:"6f44aaef9cceb88827dc4d7121345e25"; x:1017.852966; y:984.192505; z:-529.042053
		"\044\051\183\164\222\134\162\158\204\010\202\138\207\041\162\052\203\081\166\068\189\144\167\065\152\013\002\196" ..
		-- tex:"2c33b7a4de86a29ecc0aca8acf29a234"; x:1330.556152; y:20.945675; z:-520.212463
		"\021\105\105\136\037\107\047\183\000\243\008\050\226\218\182\136\203\081\166\068\011\121\138\067\152\013\002\196" ..
		-- tex:"15696988256b2fb700f30832e2dab688"; x:1330.556152; y:276.945675; z:-520.212463
		"\004\107\153\248\097\133\060\252\228\132\200\149\248\030\106\088\203\081\198\068\011\121\138\067\152\013\002\196" ..
		-- tex:"046b99f861853cfce484c895f81e6a58"; x:1586.556152; y:276.945675; z:-520.212463
		"\037\020\232\053\205\008\111\183\248\059\080\127\252\081\014\220\203\081\166\068\133\060\005\068\152\013\002\196" ..
		-- tex:"2514e835cd086fb7f83b507ffc510edc"; x:1330.556152; y:532.945675; z:-520.212463
		"\127\101\036\174\150\222\114\128\243\060\224\174\040\220\030\158\203\081\198\068\133\060\005\068\152\013\002\196" ..
		-- tex:"7f6524ae96de7280f33ce0ae28dc1e9e"; x:1586.556152; y:532.945675; z:-520.212463
		"\051\200\223\205\194\096\145\061\045\201\249\081\026\098\104\098\203\081\198\068\189\144\167\065\152\013\002\196" ..
		-- tex:"33c8dfcdc260913d2dc9f9511a626862"; x:1586.556152; y:20.945675; z:-520.212463
		"\090\082\128\180\089\040\071\003\193\009\058\123\103\230\210\073\203\081\166\068\133\060\069\068\152\013\002\196" ..
		-- tex:"5a5280b459284703c1093a7b67e6d249"; x:1330.556152; y:788.945675; z:-520.212463
		"\035\168\111\212\031\136\189\198\010\158\181\141\215\177\228\224\188\135\147\194\052\145\007\195\120\112\001\196" ..
		-- tex:"23a86fd41f88bdc60a9eb58dd7b1e4e0"; x:-73.765114; y:-135.567215; z:-517.757385
		"\073\031\083\161\240\189\252\030\229\252\065\212\041\171\152\125\109\036\129\068\095\108\062\068\057\021\000\196" ..
		-- tex:"491f53a1f0bdfc1ee5fc41d429ab987d"; x:1033.138367; y:761.693329; z:-512.331665
		"\111\247\158\253\245\098\116\165\119\124\148\224\100\089\200\022\109\036\129\068\190\216\252\067\057\021\000\196" ..
		-- tex:"6ff79efdf56274a5777c94e06459c816"; x:1033.138367; y:505.693329; z:-512.331665
		"\199\098\076\247\215\118\149\249\150\176\099\022\162\165\002\020\218\072\066\068\190\216\252\067\057\021\000\196" ..
		-- tex:"c7624cf7d77695f996b06316a2a50214"; x:777.138367; y:505.693329; z:-512.331665
		"\148\079\213\245\064\056\059\221\245\254\101\051\142\099\115\079\218\072\066\068\095\108\062\068\057\021\000\196" ..
		-- tex:"944fd5f540383bddf5fe65338e63734f"; x:777.138367; y:761.693329; z:-512.331665
		"\025\023\038\130\236\081\057\035\135\054\211\035\220\020\240\186\223\142\008\068\200\031\048\068\194\121\247\195" ..
		-- tex:"19172682ec5139238736d323dc14f0ba"; x:546.232422; y:704.496613; z:-494.951263
		"\140\091\195\053\189\003\181\016\226\079\072\190\219\080\085\002\223\142\072\068\144\063\224\067\194\121\247\195" ..
		-- tex:"8c5bc335bd03b510e24f48bedb505502"; x:802.232422; y:448.496613; z:-494.951263
		"\032\047\251\238\181\065\217\117\181\132\148\076\145\045\236\219\223\142\008\068\144\063\224\067\194\121\247\195" ..
		-- tex:"202ffbeeb541d975b584944c912decdb"; x:546.232422; y:448.496613; z:-494.951263
		"\114\166\070\167\252\026\229\043\253\136\079\151\158\189\055\085\022\165\055\195\205\162\161\068\018\030\245\195" ..
		-- tex:"72a646a7fc1ae52bfd884f979ebd3755"; x:-183.644882; y:1293.087646; z:-490.234955
		"\019\250\163\034\133\139\106\243\246\240\248\035\000\037\187\062\022\165\055\195\205\162\193\068\018\030\245\195" ..
		-- tex:"13faa322858b6af3f6f0f8230025bb3e"; x:-183.644882; y:1549.087646; z:-490.234955
		"\007\028\141\237\032\111\169\215\213\149\095\022\094\221\198\079\014\028\001\196\115\074\205\068\018\030\245\195" ..
		-- tex:"071c8ded206fa9d7d5955f165eddc64f"; x:-516.438416; y:1642.326660; z:-490.234955
		"\066\093\043\181\101\189\012\175\232\063\191\089\020\144\040\233\029\056\130\195\115\074\205\068\018\030\245\195" ..
		-- tex:"425d2bb565bd0cafe83fbf59149028e9"; x:-260.438416; y:1642.326660; z:-490.234955
		"\082\102\213\128\071\139\047\201\218\053\055\021\004\035\115\105\029\056\130\195\115\074\237\068\018\030\245\195" ..
		-- tex:"5266d580478b2fc9da35371504237369"; x:-260.438416; y:1898.326660; z:-490.234955
		"\031\088\255\246\072\189\076\117\110\184\170\108\209\128\167\073\014\028\001\196\115\074\237\068\018\030\245\195" ..
		-- tex:"1f58fff648bd4c756eb8aa6cd180a749"; x:-516.438416; y:1898.326660; z:-490.234955
		"\139\098\149\148\038\241\006\066\156\081\086\108\110\017\117\020\010\000\088\196\038\050\191\068\148\021\245\195" ..
		-- tex:"8b62959426f106429c51566c6e117514"; x:-864.000671; y:1529.567261; z:-490.168610
		"\022\092\149\221\214\168\056\235\025\127\068\245\089\102\043\023\010\000\088\196\038\050\223\068\148\021\245\195" ..
		-- tex:"165c95ddd6a838eb197f44f559662b17"; x:-864.000671; y:1785.567261; z:-490.168610
		"\129\057\156\176\116\174\245\040\100\079\069\044\106\016\037\055\010\000\024\196\038\050\223\068\148\021\245\195" ..
		-- tex:"81399cb074aef528644f452c6a102537"; x:-608.000671; y:1785.567261; z:-490.168610
		"\033\085\110\137\212\231\187\166\024\246\159\203\085\089\008\081\010\000\088\196\038\050\159\068\148\021\245\195" ..
		-- tex:"21556e89d4e7bba618f69fcb55590851"; x:-864.000671; y:1273.567261; z:-490.168610
		"\065\182\179\218\156\077\026\201\236\180\131\030\157\190\074\204\010\000\024\196\038\050\191\068\148\021\245\195" ..
		-- tex:"41b6b3da9c4d1ac9ecb4831e9dbe4acc"; x:-608.000671; y:1529.567261; z:-490.168610
		"\167\164\046\020\252\178\092\161\204\175\009\121\117\076\241\043\055\189\144\067\157\181\003\068\107\248\243\195" ..
		-- tex:"a7a42e14fcb25ca1ccaf0979754cf12b"; x:289.478271; y:526.837769; z:-487.940796
		"\239\067\251\030\249\237\232\111\070\042\079\004\022\252\088\062\055\189\144\067\059\107\135\067\107\248\243\195" ..
		-- tex:"ef43fb1ef9ede86f462a4f0416fc583e"; x:289.478271; y:270.837769; z:-487.940796
		"\082\008\147\253\009\238\036\243\212\074\046\103\019\250\218\035\155\094\008\068\157\181\003\068\107\248\243\195" ..
		-- tex:"520893fd09ee24f3d44a2e6713fada23"; x:545.478271; y:526.837769; z:-487.940796
		"\125\164\232\181\224\187\222\176\026\090\016\118\101\176\093\014\155\094\008\068\059\107\135\067\107\248\243\195" ..
		-- tex:"7da4e8b5e0bbdeb01a5a107665b05d0e"; x:545.478271; y:270.837769; z:-487.940796
		"\010\163\252\129\107\177\041\216\189\138\034\034\152\099\197\158\191\233\005\066\157\181\003\068\107\248\243\195" ..
		-- tex:"0aa3fc816bb129d8bd8a22229863c59e"; x:33.478271; y:526.837769; z:-487.940796
		"\221\129\081\047\213\029\106\026\154\086\115\144\252\164\111\108\191\233\005\066\059\107\135\067\107\248\243\195" ..
		-- tex:"dd81512fd51d6a1a9a567390fca46f6c"; x:33.478271; y:270.837769; z:-487.940796
		"\065\063\150\145\134\190\213\027\108\188\122\035\225\111\037\076\099\141\166\067\244\234\136\068\063\030\240\195" ..
		-- tex:"413f969186bed51b6cbc7a23e16f254c"; x:333.104614; y:1095.342407; z:-480.236328
		"\028\239\089\160\000\194\056\110\233\039\091\055\040\189\182\085\177\070\019\068\233\213\017\068\063\030\240\195" ..
		-- tex:"1cef59a000c2386ee9275b3728bdb655"; x:589.104614; y:583.342407; z:-480.236328
		"\108\133\033\071\185\229\253\054\026\017\113\013\103\150\023\165\177\070\019\068\244\234\136\068\063\030\240\195" ..
		-- tex:"6c852147b9e5fd361a11710d679617a5"; x:589.104614; y:1095.342407; z:-480.236328
		"\218\076\102\053\044\239\012\093\162\243\243\070\001\062\023\000\177\070\019\068\233\213\081\068\063\030\240\195" ..
		-- tex:"da4c66352cef0c5da2f3f346013e1700"; x:589.104614; y:839.342407; z:-480.236328
		"\044\192\179\193\140\244\075\174\157\060\227\174\186\177\008\153\099\141\166\067\233\213\081\068\063\030\240\195" ..
		-- tex:"2cc0b3c18cf44bae9d3ce3aebab10899"; x:333.104614; y:839.342407; z:-480.236328
		"\183\139\142\035\196\233\041\200\088\115\047\224\153\097\041\188\099\141\166\067\233\213\017\068\063\030\240\195" ..
		-- tex:"b78b8e23c4e929c858732fe0996129bc"; x:333.104614; y:583.342407; z:-480.236328
		"\077\005\245\052\007\082\226\010\168\248\122\246\061\105\233\109\113\204\134\195\195\153\250\068\016\084\234\195" ..
		-- tex:"4d05f5340752e20aa8f87af63d69e96d"; x:-269.597229; y:2004.805176; z:-468.656769
		"\116\103\027\067\143\007\021\179\104\045\204\075\093\226\222\007\252\233\135\067\036\224\137\068\148\061\228\195" ..
		-- tex:"74671b438f0715b3682dcc4b5de2de07"; x:271.828024; y:1103.004517; z:-456.481110
		"\047\187\234\182\237\186\015\179\045\196\186\023\184\096\250\221\252\233\135\067\036\224\169\068\148\061\228\195" ..
		-- tex:"2fbbeab6edba0fb32dc4ba17b860fadd"; x:271.828024; y:1359.004517; z:-456.481110
		"\098\088\249\154\018\173\012\092\007\166\119\165\196\194\195\249\149\063\125\065\036\224\169\068\148\061\228\195" ..
		-- tex:"6258f99a12ad0c5c07a677a5c4c2c3f9"; x:15.828024; y:1359.004517; z:-456.481110
		"\040\179\058\134\092\135\250\240\015\246\018\218\087\102\092\029\149\063\125\065\036\224\137\068\148\061\228\195" ..
		-- tex:"28b33a865c87faf00ff612da57665c1d"; x:15.828024; y:1103.004517; z:-456.481110
		"\188\101\143\149\003\218\226\235\082\023\114\016\236\236\072\170\177\065\121\195\136\144\243\068\111\250\227\195" ..
		-- tex:"bc658f9503dae2eb52177210ecec48aa"; x:-249.256622; y:1948.516724; z:-455.956543
		"\254\223\143\132\118\154\014\145\185\194\217\197\154\003\079\250\216\160\252\195\136\144\243\068\111\250\227\195" ..
		-- tex:"fedf8f84769a0e91b9c2d9c59a034ffa"; x:-505.256622; y:1948.516724; z:-455.956543
		"\111\189\247\017\056\119\137\038\101\079\187\040\064\082\065\149\216\160\252\195\068\200\009\069\111\250\227\195" ..
		-- tex:"6fbdf71138778926654fbb2840524195"; x:-505.256622; y:2204.516724; z:-455.956543
		"\093\102\231\147\154\218\046\194\027\110\104\218\081\062\236\085\194\174\044\068\241\214\201\195\008\189\221\195" ..
		-- tex:"5d66e7939ada2ec21b6e68da513eec55"; x:690.730652; y:-403.679260; z:-443.476837
		"\149\127\074\055\074\254\191\091\077\162\018\250\182\227\093\045\097\087\150\068\241\214\201\195\008\189\221\195" ..
		-- tex:"957f4a374afebf5b4da212fab6e35d2d"; x:1202.730652; y:-403.679260; z:-443.476837
		"\156\094\122\235\119\202\064\047\167\129\133\073\190\030\063\003\097\087\182\068\120\235\036\196\008\189\221\195" ..
		-- tex:"9c5e7aeb77ca402fa7818549be1e3f03"; x:1458.730652; y:-659.679260; z:-443.476837
		"\014\198\022\073\011\237\053\070\049\046\253\237\132\254\109\197\194\174\044\068\120\235\036\196\008\189\221\195" ..
		-- tex:"0ec616490bed3546312efded84fe6dc5"; x:690.730652; y:-659.679260; z:-443.476837
		"\170\149\003\128\090\016\231\065\193\163\138\047\057\246\071\254\194\174\044\068\120\235\100\196\008\189\221\195" ..
		-- tex:"aa9503805a10e741c1a38a2f39f647fe"; x:690.730652; y:-915.679260; z:-443.476837
		"\088\248\191\073\248\032\063\123\240\131\220\210\244\244\140\017\194\174\108\068\241\214\201\195\008\189\221\195" ..
		-- tex:"58f8bf49f8203f7bf083dcd2f4f48c11"; x:946.730652; y:-403.679260; z:-443.476837
		"\068\015\205\125\171\215\146\215\148\108\160\194\190\248\010\243\097\087\150\068\120\235\036\196\008\189\221\195" ..
		-- tex:"440fcd7dabd792d7946ca0c2bef80af3"; x:1202.730652; y:-659.679260; z:-443.476837
		"\223\172\224\043\140\080\142\246\163\227\129\112\065\122\000\082\097\087\182\068\120\235\100\196\008\189\221\195" ..
		-- tex:"dface02b8c508ef6a3e38170417a0052"; x:1458.730652; y:-915.679260; z:-443.476837
		"\233\026\242\016\122\109\163\184\184\193\139\010\148\180\061\019\097\087\150\068\120\235\100\196\008\189\221\195" ..
		-- tex:"e91af2107a6da3b8b8c18b0a94b43d13"; x:1202.730652; y:-915.679260; z:-443.476837
		"\105\083\045\231\082\196\164\055\122\226\209\111\173\162\025\156\194\174\108\068\120\235\036\196\008\189\221\195" ..
		-- tex:"69532de752c4a4377ae2d16fada2199c"; x:946.730652; y:-659.679260; z:-443.476837
		"\199\035\018\214\185\220\211\105\232\157\190\075\010\247\219\145\194\174\108\068\120\235\100\196\008\189\221\195" ..
		-- tex:"c72312d6b9dcd369e89dbe4b0af7db91"; x:946.730652; y:-915.679260; z:-443.476837
		"\198\055\160\078\020\078\217\102\087\236\178\159\236\148\027\175\053\197\010\196\246\131\137\068\208\180\220\195" ..
		-- tex:"c637a04e144ed96657ecb29fec941baf"; x:-555.081421; y:1100.123901; z:-441.412628
		"\065\101\243\173\207\102\115\102\223\248\102\009\036\134\148\017\053\197\010\196\237\007\083\068\208\180\220\195" ..
		-- tex:"4165f3adcf667366dff8660924869411"; x:-555.081421; y:844.123901; z:-441.412628
		"\097\015\136\029\236\181\097\016\066\204\216\249\029\155\155\228\053\197\074\196\246\131\137\068\208\180\220\195" ..
		-- tex:"610f881decb5611042ccd8f91d9b9be4"; x:-811.081421; y:1100.123901; z:-441.412628
		"\107\111\138\188\054\070\165\054\176\134\196\249\005\007\151\188\053\197\074\196\237\007\083\068\208\180\220\195" ..
		-- tex:"6b6f8abc3646a536b086c4f9050797bc"; x:-811.081421; y:844.123901; z:-441.412628
		"\239\245\020\100\107\227\224\238\157\210\221\121\064\190\110\085\174\198\111\068\184\196\178\195\137\067\205\195" ..
		-- tex:"eff514646be3e0ee9dd2dd7940be6e55"; x:959.104431; y:-357.536896; z:-410.527649
		"\246\018\156\026\148\203\016\054\064\078\213\206\047\235\005\065\023\082\137\068\095\101\143\193\137\067\205\195" ..
		-- tex:"f6129c1a94cb1036404ed5ce2feb0541"; x:1098.565430; y:-17.924500; z:-410.527649
		"\046\031\000\108\043\157\227\250\063\046\005\207\169\187\000\185\047\164\082\068\085\246\136\195\137\067\205\195" ..
		-- tex:"2e1f006c2b9de3fa3f2e05cfa9bb00b9"; x:842.565430; y:-273.924500; z:-410.527649
		"\242\128\098\142\019\208\110\004\018\132\134\040\148\181\227\222\023\082\137\068\085\246\136\195\137\067\205\195" ..
		-- tex:"f280628e13d06e041284862894b5e3de"; x:1098.565430; y:-273.924500; z:-410.527649
		"\108\086\138\057\001\184\211\182\059\008\120\210\015\005\219\209\047\164\082\068\095\101\143\193\137\067\205\195" ..
		-- tex:"6c568a3901b8d3b63b0878d20f05dbd1"; x:842.565430; y:-17.924500; z:-410.527649
		"\043\126\243\015\057\093\031\031\157\253\053\178\236\207\027\213\004\038\211\195\154\249\009\069\117\231\204\195" ..
		-- tex:"2b7ef30f395d1f1f9dfd35b2eccf1bd5"; x:-422.297028; y:2207.600342; z:-409.808289
		"\010\057\097\120\205\001\222\146\163\106\207\075\251\247\046\169\004\038\211\195\154\249\025\069\117\231\204\195" ..
		-- tex:"0a396178cd01de92a36acf4bfbf72ea9"; x:-422.297028; y:2463.600342; z:-409.808289
		"\098\055\027\230\233\214\152\130\157\210\163\006\190\162\237\234\009\076\038\195\154\249\009\069\117\231\204\195" ..
		-- tex:"62371be6e9d698829dd2a306bea2edea"; x:-166.297028; y:2207.600342; z:-409.808289
		"\121\018\082\231\034\032\189\102\122\080\242\162\061\174\219\192\009\076\038\195\154\249\025\069\117\231\204\195" ..
		-- tex:"791252e72220bd667a50f2a23daedbc0"; x:-166.297028; y:2463.600342; z:-409.808289
		"\216\041\182\138\201\248\125\087\028\031\243\047\194\197\007\219\117\096\137\068\214\020\226\194\148\161\196\195" ..
		-- tex:"d829b68ac9f87d571c1ff32fc2c507db"; x:1099.014404; y:-113.040703; z:-393.262360
		"\190\059\164\154\141\022\038\145\254\124\127\103\181\033\042\023\117\096\169\068\214\020\226\194\148\161\196\195" ..
		-- tex:"be3ba49a8d162691fe7c7f67b5212a17"; x:1355.014404; y:-113.040703; z:-393.262360
		"\009\149\053\150\121\094\027\054\110\091\158\201\102\173\148\126\225\015\094\195\090\108\014\068\079\042\193\195" ..
		-- tex:"09953596795e1b366e5b9ec966ad947e"; x:-222.062042; y:569.693054; z:-386.330566
		"\050\054\024\243\198\116\039\085\082\024\203\064\108\201\237\201\225\015\094\195\090\108\078\068\079\042\193\195" ..
		-- tex:"323618f3c67427555218cb406cc9edc9"; x:-222.062042; y:825.693054; z:-386.330566
		"\166\179\136\155\252\231\213\162\027\021\078\181\179\236\178\243\240\007\239\195\090\108\078\068\079\042\193\195" ..
		-- tex:"a6b3889bfce7d5a21b154eb5b3ecb2f3"; x:-478.062042; y:825.693054; z:-386.330566
		"\086\143\034\185\150\211\040\087\215\162\236\244\168\219\180\103\240\007\239\195\090\108\014\068\079\042\193\195" ..
		-- tex:"568f22b996d32857d7a2ecf4a8dbb467"; x:-478.062042; y:569.693054; z:-386.330566
		"\191\002\216\199\030\040\033\182\121\219\179\105\198\167\087\197\230\003\035\068\034\124\211\194\057\244\183\195" ..
		-- tex:"bf02d8c71e2821b679dbb369c6a757c5"; x:652.060974; y:-105.742455; z:-367.908020
		"\115\252\039\138\251\252\228\129\159\248\045\051\193\231\227\226\149\195\207\067\179\003\109\195\255\086\182\195" ..
		-- tex:"73fc278afbfce4819ff82d33c1e7e3e2"; x:415.528015; y:-237.014465; z:-364.679688
		"\108\254\144\176\069\160\029\243\163\024\132\029\235\011\136\149\202\225\039\068\179\003\109\195\255\086\182\195" ..
		-- tex:"6cfe90b045a01df3a318841deb0b8895"; x:671.528015; y:-237.014465; z:-364.679688
		"\114\149\219\212\027\108\135\243\194\078\151\206\181\159\156\070\043\135\031\067\179\003\109\195\255\086\182\195" ..
		-- tex:"7295dbd41b6c87f3c24e97ceb59f9c46"; x:159.528015; y:-237.014465; z:-364.679688
		"\066\087\121\236\076\013\181\162\009\161\083\006\137\226\018\090\170\236\188\195\026\067\243\066\024\234\160\195" ..
		-- tex:"425779ec4c0db5a209a1530689e2125a"; x:-377.848969; y:121.631065; z:-321.828888
		"\117\096\070\163\129\118\189\084\189\055\065\151\147\004\042\220\170\236\188\195\198\208\188\067\024\234\160\195" ..
		-- tex:"756046a38176bd54bd37419793042adc"; x:-377.848969; y:377.631065; z:-321.828888
		"\043\104\079\057\172\024\219\236\190\176\175\075\181\206\172\091\083\154\144\066\117\174\022\195\132\078\160\195" ..
		-- tex:"2b684f39ac18dbecbeb0af4bb5ceac5b"; x:72.301422; y:-150.681488; z:-320.613434
		"\112\233\024\145\152\076\201\123\012\181\234\057\087\048\210\254\083\154\144\066\058\087\203\195\132\078\160\195" ..
		-- tex:"70e91891984cc97b0cb5ea395730d2fe"; x:72.301422; y:-406.681488; z:-320.613434
		"\230\203\182\243\078\045\098\198\037\251\077\043\156\084\226\183\213\178\055\195\117\174\022\195\132\078\160\195" ..
		-- tex:"e6cbb6f34e2d62c625fb4d2b9c54e2b7"; x:-183.698578; y:-150.681488; z:-320.613434
		"\224\235\066\211\141\003\166\065\161\196\024\233\194\006\023\044\213\178\055\195\058\087\203\195\132\078\160\195" ..
		-- tex:"e0eb42d38d03a641a1c418e9c206172c"; x:-183.698578; y:-406.681488; z:-320.613434
		"\238\033\124\107\143\253\138\113\032\104\013\040\071\163\128\214\219\144\005\195\101\172\231\066\207\021\155\195" ..
		-- tex:"ee217c6b8ffd8a7120680d2847a380d6"; x:-133.565857; y:115.836716; z:-310.170410
		"\005\160\108\099\031\188\059\104\243\209\022\176\253\151\044\148\219\144\005\195\204\041\012\195\207\021\155\195" ..
		-- tex:"05a06c631fbc3b68f3d116b0fd972c94"; x:-133.565857; y:-140.163284; z:-310.170410
		"\023\162\189\103\197\158\169\197\203\249\232\112\217\220\189\054\071\222\244\066\204\041\012\195\207\021\155\195" ..
		-- tex:"17a2bd67c59ea9c5cbf9e870d9dcbd36"; x:122.434143; y:-140.163284; z:-310.170410
		"\067\103\108\012\143\134\200\134\244\009\040\094\212\100\066\244\071\222\244\066\101\172\231\066\207\021\155\195" ..
		-- tex:"43676c0c8f86c886f409285ed46442f4"; x:122.434143; y:115.836716; z:-310.170410
		"\206\183\154\009\029\093\106\222\059\006\191\210\164\008\155\028\191\034\216\195\225\093\209\194\209\134\149\195" ..
		-- tex:"ceb79a091d5d6ade3b06bfd2a4089b1c"; x:-432.271484; y:-104.683365; z:-299.053284
		"\222\209\205\157\160\036\164\143\202\186\199\001\062\232\242\050\191\034\216\195\014\081\023\067\209\134\149\195" ..
		-- tex:"ded1cd9da024a48fcabac7013ee8f232"; x:-432.271484; y:151.316635; z:-299.053284
		"\037\113\153\228\021\228\198\027\185\218\056\097\135\081\245\239\127\069\048\195\225\093\209\194\209\134\149\195" ..
		-- tex:"257199e415e4c61bb9da38618751f5ef"; x:-176.271484; y:-104.683365; z:-299.053284
		"\126\189\044\080\160\081\109\016\233\093\164\126\094\219\050\068\158\076\239\064\002\012\004\195\017\153\050\195" ..
		-- tex:"7ebd2c50a0516d10e95da47e5edb3244"; x:7.478103; y:-132.046921; z:-178.597931
		"\230\200\061\159\000\232\113\221\204\235\160\048\025\236\063\081\168\211\006\194\138\053\251\066\043\081\041\195" ..
		-- tex:"e6c83d9f00e871ddcceba03019ec3f51"; x:-33.706699; y:125.604576; z:-169.317078
		"\206\103\153\155\097\093\102\094\050\029\039\000\139\083\212\213\009\099\062\195\248\120\001\195\195\199\027\195" ..
		-- tex:"ce67999b615d665e321d27008b53d4d5"; x:-190.386871; y:-129.472549; z:-155.780334
		"\047\133\145\177\046\246\084\019\209\119\148\017\116\118\069\001\080\069\122\066\050\135\132\066\180\196\003\195" ..
		-- tex:"2f8591b12ef65413d177941174764501"; x:62.567692; y:66.264061; z:-131.768387
		"\182\159\203\207\011\014\182\084\094\143\251\158\095\164\106\203\169\007\210\192\095\227\050\066\230\110\208\194" ..
		-- tex:"b69fcbcf0b0eb6545e8ffb9e5fa46acb"; x:-6.563436; y:44.722046; z:-104.216606
		"\128\073\240\164\211\079\254\018\236\005\142\196\090\238\222\084\194\111\121\067\039\071\083\195\230\110\208\194" ..
		-- tex:"8049f0a4d34ffe12ec058ec45aeede54"; x:249.436564; y:-211.277954; z:-104.216606
		"\132\211\104\074\125\192\112\102\189\001\098\129\251\020\052\210\169\007\210\192\039\071\083\195\230\110\208\194" ..
		-- tex:"84d3684a7dc07066bd016281fb1434d2"; x:-6.563436; y:-211.277954; z:-104.216606
		"\116\137\107\167\029\211\192\134\194\120\192\115\027\041\173\069\147\218\201\194\039\174\243\066\215\155\205\194" ..
		-- tex:"74896ba71dd3c086c278c0731b29ad45"; x:-100.926910; y:121.840149; z:-102.804382
		"\155\104\187\218\207\093\070\186\062\149\061\112\198\172\144\047\147\218\201\194\235\040\006\195\215\155\205\194" ..
		-- tex:"9b68bbdacf5d46ba3e953d70c6ac902f"; x:-100.926910; y:-134.159851; z:-102.804382
		"\047\167\061\137\075\005\172\040\040\111\077\097\055\160\142\123\178\061\174\195\240\085\201\194\146\025\185\194" ..
		-- tex:"2fa73d894b05ac28286f4d6137a08e7b"; x:-348.482025; y:-100.667854; z:-92.549950
		"\210\024\169\092\048\086\199\085\111\118\235\178\153\188\140\133\113\153\243\064\195\140\077\195\198\123\173\194" ..
		-- tex:"d218a95c3056c7556f76ebb299bc8c85"; x:7.612481; y:-205.549866; z:-86.741753
		"\169\255\129\255\174\107\164\227\243\066\065\056\211\182\064\045\203\106\011\067\190\047\045\195\157\074\173\194" ..
		-- tex:"a9ff81ffae6ba4e3f3424138d3b6402d"; x:139.417175; y:-173.186508; z:-86.645737
		"\056\124\124\011\110\097\202\086\035\194\024\176\140\246\146\104\110\142\130\067\236\248\141\194\102\000\172\194" ..
		-- tex:"387c7c0b6e61ca5623c218b08cf69268"; x:261.112762; y:-70.986183; z:-86.000786
		"\018\065\224\215\188\205\197\139\082\139\219\206\141\078\147\024\110\142\130\067\040\131\110\065\102\000\172\194" ..
		-- tex:"1241e0d7bccdc58b528bdbce8d4e9318"; x:261.112762; y:14.907022; z:-86.000786
		"\175\130\160\181\251\039\000\135\018\096\031\229\168\005\056\136\173\214\069\195\049\008\021\195\220\034\143\194" ..
		-- tex:"af82a0b5fb27008712601fe5a8053888"; x:-197.838593; y:-149.032013; z:-71.568092
		"\080\011\008\127\013\249\230\085\125\105\041\241\115\157\228\115\173\214\069\195\155\239\213\066\220\034\143\194" ..
		-- tex:"500b087f0df9e6557d6929f1739de473"; x:-197.838593; y:106.967987; z:-71.568092
		"\025\238\199\110\197\236\120\007\015\047\193\074\114\043\082\020\045\150\119\195\210\182\186\194\161\138\005\194",
		-- tex:"19eec76ec5ec78070f2fc14a722b5214"; x:-247.586639; y:-93.357079; z:-33.385384
	["Armory"] = 
		"\083\095\074\174\085\045\016\122\066\157\242\014\241\226\146\162\019\059\133\196\219\034\089\067\039\201\068\065" ..
		-- tex:"535f4aae552d107a429df20ef1e292a2"; x:-1065.846191; y:217.136169; z:12.299110
		"\194\125\006\107\207\080\160\118\255\021\221\106\013\070\114\201\239\061\050\196\038\025\239\066\109\129\092\065" ..
		-- tex:"c27d066bcf50a076ff15dd6a0d4672c9"; x:-712.967773; y:119.549126; z:13.781599
		"\100\113\189\158\195\032\236\124\143\211\016\235\150\048\221\233\221\203\011\196\230\157\251\066\014\035\122\065" ..
		-- tex:"6471bd9ec320ec7c8fd310eb9630dde9"; x:-559.185425; y:125.808403; z:15.633559
		"\071\113\227\202\073\156\098\148\117\007\034\149\216\200\059\191\017\191\099\196\234\019\239\066\170\036\122\065" ..
		-- tex:"4771e3ca499c629475072295d8c83bbf"; x:-910.985474; y:119.538902; z:15.633952
		"\077\159\198\118\215\216\189\184\225\083\152\047\111\177\070\142\165\095\157\195\209\115\156\065\161\180\202\065" ..
		-- tex:"4d9fc676d7d8bdb8e153982f6fb1468e"; x:-314.747253; y:19.556553; z:25.338200
		"\035\048\162\021\233\174\013\015\226\097\145\022\095\077\186\208\224\188\000\196\092\076\146\066\169\179\229\065" ..
		-- tex:"2330a215e9ae0d0fe26191165f4dbad0"; x:-514.951233; y:73.149147; z:28.712727
		"\162\209\136\172\033\170\252\101\049\200\047\070\131\000\233\045\187\170\111\196\155\088\126\067\246\131\008\066" ..
		-- tex:"a2d188ac21aafc6531c82f468300e92d"; x:-958.667725; y:254.346130; z:34.128872
		"\008\073\129\005\028\144\026\205\052\237\228\047\239\169\131\139\225\009\191\195\030\042\142\066\148\160\013\066" ..
		-- tex:"084981051c901acd34ede42fefa9838b"; x:-382.077209; y:71.082268; z:35.406818
		"\048\036\141\138\114\212\192\153\088\014\008\117\104\160\188\227\019\159\174\195\177\129\140\194\119\133\015\066" ..
		-- tex:"30248d8a72d4c099580e087568a0bce3"; x:-349.242798; y:-70.253311; z:35.880341
		"\030\181\049\247\151\167\132\032\074\118\136\096\161\221\244\134\088\113\173\195\204\128\210\065\099\136\015\066" ..
		-- tex:"1eb531f797a784204a768860a1ddf486"; x:-346.885529; y:26.312891; z:35.883194
		"\060\254\051\075\113\043\084\174\040\063\129\230\246\162\206\009\081\090\109\196\024\223\213\066\095\215\015\066" ..
		-- tex:"3cfe334b712b54ae283f81e6f6a2ce09"; x:-949.411255; y:106.935738; z:35.960327
		"\158\066\012\027\165\031\199\071\068\055\001\231\181\078\216\059\081\090\109\196\105\001\018\067\096\215\015\066" ..
		-- tex:"9e420c1ba51fc747443701e7b54ed83b"; x:-949.411255; y:146.005524; z:35.960331
		"\063\039\068\081\233\139\072\084\117\000\088\069\105\232\043\046\081\090\109\196\006\177\065\067\098\215\015\066" ..
		-- tex:"3f274451e98b48547500584569e82b2e"; x:-949.411255; y:193.691513; z:35.960339
		"\032\011\088\061\244\008\026\226\008\224\140\090\156\236\140\203\082\090\109\196\002\083\040\067\099\215\015\066" ..
		-- tex:"200b583df4081ae208e08c5a9cec8ccb"; x:-949.411316; y:168.324265; z:35.960342
		"\016\002\232\076\061\087\243\080\122\099\018\093\154\244\237\156\019\218\146\195\007\163\167\194\142\173\019\066" ..
		-- tex:"1002e84c3d57f3507a63125d9af4ed9c"; x:-293.703735; y:-83.818420; z:36.919491
		"\211\079\212\237\018\214\171\191\180\114\075\022\186\017\111\209\018\004\147\195\096\243\090\066\015\111\020\066" ..
		-- tex:"d34fd4ed12d6abbfb4724b16ba116fd1"; x:-294.031830; y:54.737675; z:37.108459
		"\250\240\108\183\159\088\118\043\195\002\136\149\082\046\247\083\165\095\157\195\167\229\102\194\205\037\021\066" ..
		-- tex:"faf06cb79f58762bc3028895522ef753"; x:-314.747253; y:-57.724274; z:37.286919
		"\205\179\145\109\013\132\037\205\006\003\194\050\160\048\235\115\054\137\140\195\097\228\077\194\029\049\021\066" ..
		-- tex:"cdb3916d0d8425cd0603c232a030eb73"; x:-281.071991; y:-51.473030; z:37.297966
		"\122\183\254\176\044\232\216\234\081\212\129\208\062\072\032\048\170\233\010\195\114\225\010\194\017\050\021\066" ..
		-- tex:"7ab7feb02ce8d8ea51d481d03e482030"; x:-138.912766; y:-34.720165; z:37.298897
		"\185\184\249\177\177\139\250\237\124\185\239\083\112\090\195\188\175\233\010\195\201\122\072\065\017\050\021\066",
		-- tex:"b9b8f9b1b18bfaed7cb9ef53705ac3bc"; x:-138.912842; y:12.529978; z:37.298897
	["Auchenai Crypts"] = 
		"\233\084\063\189\138\150\067\005\229\213\186\065\221\174\225\058\152\242\203\195\139\054\070\067\160\068\185\195" ..
		-- tex:"e9543fbd8a964305e5d5ba41ddaee13a"; x:-407.895294; y:198.213074; z:-370.536163
		"\202\007\247\077\191\135\149\218\065\080\066\123\120\052\162\175\155\053\208\066\139\054\070\067\160\068\185\195" ..
		-- tex:"ca07f74dbf8795da4150427b7834a2af"; x:104.104706; y:198.213074; z:-370.536163
		"\189\018\253\004\012\050\079\138\208\184\003\204\144\027\010\067\049\229\023\195\139\054\070\067\160\068\185\195" ..
		-- tex:"bd12fd040c324f8ad0b803cc901b0a43"; x:-151.895294; y:198.213074; z:-370.536163
		"\052\154\127\051\240\072\170\249\039\062\082\023\241\224\026\009\156\041\013\196\126\242\173\194\098\043\222\192" ..
		-- tex:"349a7f33f048aaf9273e5217f1e01a09"; x:-564.650208; y:-86.973625; z:-6.942796
		"\199\206\023\094\248\013\249\179\232\003\083\225\203\238\038\071\223\211\024\195\188\139\204\194\118\001\163\192" ..
		-- tex:"c7ce175ef80df9b3e80353e1cbee2647"; x:-152.827637; y:-102.272926; z:-5.093929
		"\177\241\011\154\241\066\013\082\223\168\127\174\194\086\142\220\239\105\204\195\188\139\204\194\118\001\163\192" ..
		-- tex:"b1f10b9af1420d52dfa87faec2568edc"; x:-408.827637; y:-102.272926; z:-5.093929
		"\150\069\213\150\076\070\148\048\089\060\253\088\029\122\022\164\244\097\087\194\018\206\186\193\181\125\005\192" ..
		-- tex:"9645d5964c469430593cfd581d7a16a4"; x:-53.845661; y:-23.350622; z:-2.085798
		"\033\210\194\041\152\086\121\228\023\199\161\040\131\109\174\029\130\039\074\067\018\206\186\193\181\125\005\192" ..
		-- tex:"21d2c229985679e417c7a128836dae1d"; x:202.154339; y:-23.350622; z:-2.085798
		"\240\092\132\165\043\025\098\045\014\108\102\139\178\154\243\134\023\142\055\066\039\086\040\068\092\012\027\066" ..
		-- tex:"f05c84a52b19622d0e6c668bb29af386"; x:45.888763; y:673.346191; z:38.762074
		"\053\099\232\029\043\036\134\164\247\177\113\198\148\136\242\178\121\028\082\195\039\086\040\068\092\012\027\066" ..
		-- tex:"3563e81d2b2486a4f7b171c69488f2b2"; x:-210.111237; y:673.346191; z:38.762074
		"\036\080\233\013\191\068\059\228\101\207\156\166\086\185\069\076\173\121\019\196\008\042\127\067\013\255\045\066" ..
		-- tex:"2450e90dbf443be465cf9ca656b9454c"; x:-589.901245; y:255.164200; z:43.499077
		"\215\194\107\033\174\095\215\161\070\017\160\224\037\085\125\191\082\226\210\066\053\221\013\068\185\064\055\066" ..
		-- tex:"d7c26b21ae5fd7a14611a0e025557dbf"; x:105.442039; y:567.456421; z:45.813210
		"\188\155\031\047\141\206\219\200\065\177\255\160\167\248\212\200\082\226\210\066\107\186\155\067\185\064\055\066" ..
		-- tex:"bc9b1f2f8dcedbc841b1ffa0a7f8d4c8"; x:105.442039; y:311.456421; z:45.813210
		"\240\033\235\193\114\145\142\188\227\008\238\227\246\093\139\237\148\184\180\067\053\221\013\068\185\064\055\066" ..
		-- tex:"f021ebc172918ebce308eee3f65d8bed"; x:361.442039; y:567.456421; z:45.813210
		"\100\017\152\032\155\122\179\166\132\163\230\071\136\229\122\027\148\184\180\067\107\186\155\067\185\064\055\066" ..
		-- tex:"641198209b7ab3a684a3e64788e57a1b"; x:361.442039; y:311.456421; z:45.813210
		"\241\163\182\051\039\186\238\051\209\194\151\085\057\014\223\025\034\126\057\067\030\132\151\067\072\122\084\066" ..
		-- tex:"f1a3b63327baee33d1c29755390edf19"; x:185.492722; y:303.032196; z:53.119419
		"\168\217\199\198\141\231\063\027\142\208\049\016\066\002\220\120\251\225\059\067\043\201\034\068\086\122\084\066" ..
		-- tex:"a8d9c7c68de73f1b8ed031104202dc78"; x:187.882751; y:651.143311; z:53.119473
		"\019\135\032\248\066\059\159\242\123\098\207\252\186\029\008\096\089\182\250\195\165\087\175\066\240\129\084\066",
		-- tex:"138720f8423b9ff27b62cffcba1d0860"; x:-501.424622; y:87.671188; z:53.126896
	["Black Temple"] = 
		"\216\055\249\074\191\061\180\025\002\168\229\149\090\066\004\237\163\098\105\194\255\214\155\063\154\057\064\193" ..
		-- tex:"d837f94abf3db41902a8e5955a4204ed"; x:-58.346329; y:1.217499; z:-12.014064
		"\212\230\072\105\188\021\228\111\050\080\107\062\166\000\181\098\163\098\105\194\081\200\126\195\154\057\064\193" ..
		-- tex:"d4e64869bc15e46f32506b3ea600b562"; x:-58.346329; y:-254.782501; z:-12.014064
		"\155\031\143\214\154\218\102\097\193\161\130\200\216\152\054\210\037\021\038\195\243\067\013\196\161\163\057\066" ..
		-- tex:"9b1f8fd69ada6661c1a182c8d89836d2"; x:-166.082611; y:-565.061768; z:46.409798
		"\072\032\008\249\078\120\204\175\069\005\145\191\070\236\115\009\037\021\038\195\243\067\077\196\161\163\057\066" ..
		-- tex:"482008f94e78ccaf450591bf46ec7309"; x:-166.082611; y:-821.061768; z:46.409798
		"\181\193\009\088\098\146\251\071\022\096\062\219\203\236\087\214\037\021\038\195\231\135\154\195\161\163\057\066" ..
		-- tex:"b5c109586292fb4716603edbcbec57d6"; x:-166.082611; y:-309.061768; z:46.409798
		"\127\183\025\038\097\123\108\125\083\029\134\030\235\172\254\038\113\110\054\195\153\044\147\196\078\110\082\067" ..
		-- tex:"7fb71926617b6c7d531d861eebacfe26"; x:-182.431427; y:-1177.393799; z:210.430893
		"\133\075\200\193\255\094\246\211\212\082\033\047\205\124\180\196\027\035\147\066\051\089\102\196\078\110\082\067" ..
		-- tex:"854bc8c1ff5ef6d3d452212fcd7cb4c4"; x:73.568573; y:-921.393799; z:210.430893
		"\109\012\183\163\126\086\056\150\243\029\165\076\118\133\065\250\113\110\054\195\051\089\102\196\078\110\082\067" ..
		-- tex:"6d0cb7a37e563896f31da54c768541fa"; x:-182.431427; y:-921.393799; z:210.430893
		"\068\055\221\075\008\255\040\252\167\101\182\125\122\227\011\159\027\035\147\066\153\044\147\196\078\110\082\067" ..
		-- tex:"4437dd4b08ff28fca765b67d7ae30b9f"; x:73.568573; y:-1177.393799; z:210.430893
		"\203\025\161\200\032\184\089\225\097\041\230\217\238\047\189\125\231\016\155\195\252\023\132\196\244\140\103\067" ..
		-- tex:"cb19a1c820b859e16129e6d9ee2fbd7d"; x:-310.132080; y:-1056.749634; z:231.550613
		"\058\015\096\170\048\217\068\150\142\137\023\182\104\152\040\056\115\136\077\196\252\023\132\196\244\140\103\067" ..
		-- tex:"3a0f60aa30d944968e8917b668982838"; x:-822.132080; y:-1056.749634; z:231.550613
		"\230\206\090\019\221\028\118\055\134\228\050\199\188\119\155\031\115\136\013\196\252\023\132\196\244\140\103\067" ..
		-- tex:"e6ce5a13dd1c763786e432c7bc779b1f"; x:-566.132080; y:-1056.749634; z:231.550613
		"\132\053\233\187\087\133\112\208\078\173\097\080\166\169\183\098\072\043\009\196\195\197\155\196\060\013\152\067" ..
		-- tex:"8435e9bb578570d04ead6150a6a9b762"; x:-548.676331; y:-1246.180176; z:304.103424
		"\059\104\093\121\091\052\219\247\063\178\031\096\241\047\155\057\205\248\135\195\160\040\156\196\103\194\189\067" ..
		-- tex:"3b685d795b34dbf73fb21f60f12f9b39"; x:-271.943787; y:-1249.269653; z:379.518799
		"\171\028\131\047\072\089\239\096\187\004\171\065\062\071\226\163\205\248\135\195\160\040\188\196\103\194\189\067" ..
		-- tex:"ab1c832f4859ef60bb04ab413e47e2a3"; x:-271.943787; y:-1505.269653; z:379.518799
		"\216\172\028\095\028\228\030\126\136\083\143\245\014\060\007\139\102\252\003\196\160\040\156\196\103\194\189\067" ..
		-- tex:"d8ac1c5f1ce41e7e88538ff50e3c078b"; x:-527.943787; y:-1249.269653; z:379.518799
		"\160\224\115\072\175\140\123\023\106\208\153\082\034\031\175\249\102\252\067\196\160\040\188\196\103\194\189\067" ..
		-- tex:"a0e07348af8c7b176ad09952221faff9"; x:-783.943787; y:-1505.269653; z:379.518799
		"\043\124\122\218\106\034\040\070\193\109\211\165\100\225\107\006\102\252\067\196\160\040\156\196\103\194\189\067" ..
		-- tex:"2b7c7ada6a222846c16dd3a564e16b06"; x:-783.943787; y:-1249.269653; z:379.518799
		"\085\204\018\076\135\013\158\218\137\053\187\047\057\121\131\062\102\252\003\196\160\040\188\196\103\194\189\067" ..
		-- tex:"55cc124c870d9eda8935bb2f3979833e"; x:-527.943787; y:-1505.269653; z:379.518799
		"\144\160\253\085\200\237\122\040\152\103\004\029\024\208\248\052\177\201\226\196\210\051\217\196\013\126\200\067" ..
		-- tex:"90a0fd55c8ed7a289867041d18d0f834"; x:-1814.302979; y:-1737.619507; z:400.984802
		"\208\000\002\106\232\224\167\224\008\135\216\050\045\225\033\142\177\201\226\196\210\051\185\196\013\126\200\067" ..
		-- tex:"d000026ae8e0a7e00887d8322de1218e"; x:-1814.302979; y:-1481.619507; z:400.984802
		"\027\199\182\239\047\074\046\173\092\211\117\145\132\096\211\218\216\100\001\197\210\051\217\196\013\126\200\067" ..
		-- tex:"1bc7b6ef2f4a2ead5cd375918460d3da"; x:-2070.302979; y:-1737.619507; z:400.984802
		"\096\025\006\247\167\094\045\055\226\222\113\038\071\073\056\162\216\100\001\197\210\051\185\196\013\126\200\067" ..
		-- tex:"601906f7a75e2d37e2de7126474938a2"; x:-2070.302979; y:-1481.619507; z:400.984802
		"\130\116\108\144\086\061\209\175\127\204\021\003\051\238\145\191\232\229\130\195\109\161\195\196\045\171\225\067" ..
		-- tex:"82746c90563dd1af7fcc150333ee91bf"; x:-261.796173; y:-1565.044678; z:451.337341
		"\005\249\031\125\167\236\034\077\137\235\102\139\167\078\056\235\122\154\189\196\131\077\003\197\140\062\240\067" ..
		-- tex:"05f91f7da7ec224d89eb668ba74e38eb"; x:-1516.827515; y:-2100.844727; z:480.488678
		"\007\168\024\218\059\008\204\127\115\192\230\165\087\113\011\029\122\154\221\196\131\077\003\197\140\062\240\067" ..
		-- tex:"07a818da3b08cc7f73c0e6a557710b1d"; x:-1772.827515; y:-2100.844727; z:480.488678
		"\153\249\181\223\000\232\077\130\168\170\231\234\069\253\028\087\009\209\223\196\196\150\025\197\117\152\241\067" ..
		-- tex:"99f9b5df00e84d82a8aae7ea45fd1c57"; x:-1790.532471; y:-2457.423096; z:483.191101
		"\185\232\198\245\111\216\218\051\041\081\042\145\096\100\072\160\009\209\191\196\196\150\009\197\117\152\241\067" ..
		-- tex:"b9e8c6f56fd8da3329512a91606448a0"; x:-1534.532471; y:-2201.423096; z:483.191101
		"\090\182\027\055\196\092\195\075\109\250\149\063\059\235\242\224\009\209\191\196\196\150\025\197\117\152\241\067" ..
		-- tex:"5ab61b37c45cc34b6dfa953f3bebf2e0"; x:-1534.532471; y:-2457.423096; z:483.191101
		"\079\041\092\198\190\253\241\109\249\074\110\087\183\085\057\059\009\209\223\196\196\150\009\197\117\152\241\067" ..
		-- tex:"4f295cc6befdf16df94a6e57b755393b"; x:-1790.532471; y:-2201.423096; z:483.191101
		"\082\133\082\246\037\146\151\001\194\062\194\080\005\252\166\041\150\089\235\196\193\076\020\197\181\108\003\068" ..
		-- tex:"528552f625929701c23ec25005fca629"; x:-1882.799683; y:-2372.797363; z:525.698608
		"\237\026\245\101\224\180\211\000\116\205\048\008\013\042\006\042\115\011\227\196\221\124\238\196\094\122\016\068" ..
		-- tex:"ed1af565e0b4d30074cd30080d2a062a"; x:-1816.357910; y:-1907.902100; z:577.912048
		"\072\124\160\240\076\223\063\255\170\106\072\089\072\061\071\039\185\133\001\197\110\062\023\197\094\122\016\068" ..
		-- tex:"487ca0f04cdf3fffaa6a4859483d4727"; x:-2072.357910; y:-2419.902100; z:577.912048
		"\101\159\187\176\216\117\066\158\156\082\066\006\245\235\042\195\115\011\227\196\110\062\007\197\094\122\016\068" ..
		-- tex:"659fbbb0d875429e9c524206f5eb2ac3"; x:-1816.357910; y:-2163.902100; z:577.912048
		"\165\140\185\216\001\249\086\213\246\154\078\051\035\253\068\216\185\133\001\197\110\062\007\197\094\122\016\068" ..
		-- tex:"a58cb9d801f956d5f69a4e3323fd44d8"; x:-2072.357910; y:-2163.902100; z:577.912048
		"\008\145\008\081\172\219\162\167\007\121\215\168\231\129\243\149\115\011\227\196\110\062\023\197\094\122\016\068" ..
		-- tex:"08910851acdba2a70779d7a8e781f395"; x:-1816.357910; y:-2419.902100; z:577.912048
		"\127\066\085\230\022\231\066\222\118\015\007\137\119\017\225\030\185\133\001\197\221\124\238\196\094\122\016\068" ..
		-- tex:"7f4255e616e742de760f07897711e11e"; x:-2072.357910; y:-1907.902100; z:577.912048
		"\229\139\021\024\245\157\062\076\169\115\052\153\125\129\039\087\161\207\225\196\012\160\212\196\044\186\016\068" ..
		-- tex:"e58b1518f59d3e4ca97334997d812757"; x:-1806.488525; y:-1701.001587; z:578.908997
		"\252\186\024\009\042\019\181\198\049\131\053\023\212\154\253\211\250\235\143\196\128\041\018\197\188\211\016\068" ..
		-- tex:"fcba18092a13b5c631833517d49afdd3"; x:-1151.374390; y:-2338.593994; z:579.308411
		"\224\097\236\100\025\142\020\156\054\118\074\054\135\207\164\038\113\054\148\196\000\202\022\197\164\029\017\068" ..
		-- tex:"e061ec64198e149c36764a3687cfa426"; x:-1185.701416; y:-2412.625244; z:580.463196
		"\202\123\084\058\109\243\120\100\173\217\039\003\037\183\195\110\113\054\180\196\000\202\022\197\164\029\017\068" ..
		-- tex:"ca7b543a6df37864add9270325b7c36e"; x:-1441.701416; y:-2412.625244; z:580.463196
		"\141\033\150\065\194\177\119\021\213\249\151\217\209\120\084\198\204\076\216\196\167\089\209\196\157\049\017\068" ..
		-- tex:"8d219641c2b17715d5f997d9d17854c6"; x:-1730.400024; y:-1674.801758; z:580.775269
		"\026\011\157\133\009\086\084\246\184\033\123\060\032\134\002\242\204\076\184\196\211\172\008\197\157\049\017\068" ..
		-- tex:"1a0b9d85095654f6b8217b3c208602f2"; x:-1474.400024; y:-2186.801758; z:580.775269
		"\065\104\209\203\191\165\104\218\133\007\074\054\140\222\223\253\204\076\184\196\167\089\209\196\157\049\017\068" ..
		-- tex:"4168d1cbbfa568da85074a368cdedffd"; x:-1474.400024; y:-1674.801758; z:580.775269
		"\079\230\019\014\168\180\129\017\100\171\168\067\211\145\040\130\204\076\152\196\167\089\241\196\157\049\017\068" ..
		-- tex:"4fe6130ea8b4811164aba843d3912882"; x:-1218.400024; y:-1930.801758; z:580.775269
		"\232\031\037\151\149\168\102\026\111\037\205\254\139\040\209\017\204\076\152\196\167\089\209\196\157\049\017\068" ..
		-- tex:"e81f259795a8661a6f25cdfe8b28d111"; x:-1218.400024; y:-1674.801758; z:580.775269
		"\250\146\162\112\177\089\000\094\083\156\213\112\144\097\244\160\204\076\152\196\211\172\008\197\157\049\017\068" ..
		-- tex:"fa92a270b159005e539cd5709061f4a0"; x:-1218.400024; y:-2186.801758; z:580.775269
		"\137\057\006\005\087\181\138\039\099\144\043\009\073\249\244\226\204\076\216\196\167\089\241\196\157\049\017\068" ..
		-- tex:"8939060557b58a2763902b0949f9f4e2"; x:-1730.400024; y:-1930.801758; z:580.775269
		"\060\130\198\136\225\068\160\055\097\083\240\185\071\024\179\170\204\076\216\196\211\172\008\197\157\049\017\068" ..
		-- tex:"3c82c688e144a0376153f0b94718b3aa"; x:-1730.400024; y:-2186.801758; z:580.775269
		"\215\053\231\253\200\019\171\093\187\202\196\107\146\222\133\047\204\076\184\196\167\089\241\196\157\049\017\068" ..
		-- tex:"d735e7fdc813ab5dbbcac46b92de852f"; x:-1474.400024; y:-1930.801758; z:580.775269
		"\013\009\030\069\182\138\115\052\013\203\059\081\158\184\023\045\067\095\142\196\120\059\228\196\094\132\017\068" ..
		-- tex:"0d091e45b68a73340dcb3b519eb8172d"; x:-1138.977051; y:-1825.858521; z:582.068298
		"\161\103\192\045\228\205\072\117\150\046\005\084\215\132\080\060\066\169\139\196\253\235\249\196\094\132\017\068" ..
		-- tex:"a167c02de4cd4875962e0554d784503c"; x:-1117.289429; y:-1999.374756; z:582.068298
		"\174\218\017\071\077\169\249\066\072\160\132\168\066\041\196\144\116\060\143\196\141\120\242\196\087\134\017\068" ..
		-- tex:"aeda11474da9f94248a084a84229c490"; x:-1145.889282; y:-1939.767334; z:582.099121
		"\025\182\253\175\072\251\005\034\002\099\210\070\007\032\102\099\227\099\142\196\013\138\248\196\224\142\017\068" ..
		-- tex:"19b6fdaf48fb05220263d24607206663"; x:-1139.121582; y:-1988.314209; z:582.232483
		"\139\168\115\027\191\035\012\120\144\061\070\117\255\124\182\025\194\196\151\196\003\100\200\196\164\143\017\068" ..
		-- tex:"8ba8731bbf230c78903d4675ff7cb619"; x:-1214.148804; y:-1603.125488; z:582.244446
		"\149\138\243\128\143\229\228\074\079\055\003\223\042\010\057\166\194\196\183\196\003\100\168\196\164\143\017\068" ..
		-- tex:"958af3808fe5e44a4f3703df2a0a39a6"; x:-1470.148804; y:-1347.125488; z:582.244446
		"\221\165\073\076\154\113\122\016\116\187\121\076\114\217\113\154\194\196\151\196\003\100\168\196\164\143\017\068" ..
		-- tex:"dda5494c9a717a1074bb794c72d9719a"; x:-1214.148804; y:-1347.125488; z:582.244446
		"\080\033\092\203\194\235\054\023\137\050\250\210\063\050\092\007\194\196\183\196\003\100\200\196\164\143\017\068" ..
		-- tex:"50215ccbc2eb36178932fad23f325c07"; x:-1470.148804; y:-1603.125488; z:582.244446
		"\006\006\200\145\058\081\214\079\185\038\229\217\189\112\063\155\146\008\146\196\189\124\012\197\126\252\029\068" ..
		-- tex:"0606c8913a51d64fb926e5d9bd703f9b"; x:-1168.267944; y:-2247.796387; z:631.945251
		"\160\169\240\035\146\254\006\123\251\250\098\199\125\226\227\149\146\008\146\196\123\249\248\196\126\252\029\068" ..
		-- tex:"a0a9f02392fe067bfbfa62c77de2e395"; x:-1168.267944; y:-1991.796387; z:631.945251
		"\225\204\070\083\247\006\219\177\057\149\104\203\104\224\114\031\253\030\237\196\227\051\204\196\127\000\030\068" ..
		-- tex:"e1cc4653f706dbb1399568cb68e0721f"; x:-1896.968506; y:-1633.621582; z:632.007813
		"\169\022\219\065\056\110\109\056\182\160\121\085\195\049\208\090\067\156\133\196\092\088\019\197\028\215\030\068" ..
		-- tex:"a916db41386e6d38b6a07955c331d05a"; x:-1068.883301; y:-2357.522705; z:635.361145
		"\128\055\115\051\040\145\145\054\032\053\129\142\045\042\247\108\011\175\239\196\155\127\214\196\238\218\030\068" ..
		-- tex:"80377333289191362035818e2d2af76c"; x:-1917.470215; y:-1715.987793; z:635.420837
		"\235\028\227\195\043\201\036\187\006\093\048\048\082\084\126\121\179\197\239\196\116\234\181\196\181\130\040\068" ..
		-- tex:"eb1ce3c32bc924bb065d303052547e79"; x:-1918.178223; y:-1455.326782; z:674.042358
		"\113\176\013\028\000\236\141\046\111\244\110\205\005\102\065\211\171\111\240\196\088\230\194\196\090\232\041\068" ..
		-- tex:"71b00d1c00ec8d2e6ff46ecd056641d3"; x:-1923.489746; y:-1559.198364; z:679.630554
		"\056\127\057\024\173\229\071\163\044\048\104\247\016\149\059\106\081\200\223\196\113\167\194\196\156\049\043\068" ..
		-- tex:"387f3918ade547a32c3068f710953b6a"; x:-1790.260010; y:-1557.232666; z:684.775208
		"\075\130\160\063\039\220\138\243\162\253\190\133\001\039\017\171\037\223\164\196\017\218\155\196\176\148\043\068" ..
		-- tex:"4b82a03f27dc8af3a2fdbe85012711ab"; x:-1318.973389; y:-1246.814697; z:686.323303
		"\196\187\056\069\168\090\103\193\232\147\026\012\187\014\060\168\037\223\228\196\017\218\187\196\176\148\043\068" ..
		-- tex:"c4bb3845a85a67c1e8931a0cbb0e3ca8"; x:-1830.973389; y:-1502.814697; z:686.323303
		"\106\063\212\018\134\033\116\108\086\144\001\011\060\135\054\166\037\223\132\196\017\218\187\196\176\148\043\068" ..
		-- tex:"6a3fd4128621746c5690010b3c8736a6"; x:-1062.973389; y:-1502.814697; z:686.323303
		"\017\119\084\011\006\029\196\245\077\074\243\247\229\246\046\021\037\223\164\196\017\218\187\196\176\148\043\068" ..
		-- tex:"1177540b061dc4f54d4af3f7e5f62e15"; x:-1318.973389; y:-1502.814697; z:686.323303
		"\040\047\129\051\033\249\015\015\138\053\000\023\224\143\118\027\037\223\196\196\017\218\155\196\176\148\043\068" ..
		-- tex:"282f813321f90f0f8a350017e08f761b"; x:-1574.973389; y:-1246.814697; z:686.323303
		"\191\159\208\081\137\164\221\055\170\104\029\203\016\202\132\171\146\111\002\197\017\218\187\196\176\148\043\068" ..
		-- tex:"bf9fd05189a4dd37aa681dcb10ca84ab"; x:-2086.973389; y:-1502.814697; z:686.323303
		"\178\052\168\250\024\084\003\006\101\179\228\185\059\236\198\172\037\223\196\196\017\218\187\196\176\148\043\068" ..
		-- tex:"b234a8fa1854030665b3e4b93becc6ac"; x:-1574.973389; y:-1502.814697; z:686.323303
		"\061\031\221\136\166\240\136\135\216\116\010\000\162\215\172\066\091\196\168\196\014\104\204\196\011\134\056\068" ..
		-- tex:"3d1fdd88a6f08887d8740a00a2d7ac42"; x:-1350.136230; y:-1635.251831; z:738.094482
		"\094\188\197\155\052\150\126\128\048\198\118\006\207\215\201\099\149\122\002\197\048\234\025\197\159\206\056\068" ..
		-- tex:"5ebcc59b34967e8030c67606cfd7c963"; x:-2087.661621; y:-2462.636963; z:739.228516
		"\106\028\195\219\122\124\189\032\144\154\098\200\130\067\131\234\043\245\132\196\048\234\025\197\159\206\056\068" ..
		-- tex:"6a1cc3db7a7cbd20909a62c8824383ea"; x:-1063.661621; y:-2462.636963; z:739.228516
		"\136\079\186\107\203\189\243\248\242\091\117\040\174\185\092\046\043\245\164\196\048\234\025\197\159\206\056\068" ..
		-- tex:"884fba6bcbbdf3f8f25b7528aeb95c2e"; x:-1319.661621; y:-2462.636963; z:739.228516
		"\131\249\122\018\243\135\047\125\215\018\026\087\214\139\049\202\043\245\228\196\048\234\025\197\159\206\056\068" ..
		-- tex:"83f97a12f3872f7dd7121a57d68b31ca"; x:-1831.661621; y:-2462.636963; z:739.228516
		"\100\028\187\153\043\174\255\126\136\212\148\146\207\169\104\095\043\245\196\196\048\234\025\197\159\206\056\068" ..
		-- tex:"641cbb992baeff7e88d49492cfa9685f"; x:-1575.661621; y:-2462.636963; z:739.228516
		"\031\231\089\205\170\245\056\026\022\154\066\141\196\109\015\103\043\245\196\196\048\234\009\197\159\206\056\068" ..
		-- tex:"1fe759cdaaf5381a169a428dc46d0f67"; x:-1575.661621; y:-2206.636963; z:739.228516
		"\005\056\025\155\129\131\254\215\060\200\154\087\247\109\052\037\043\245\228\196\048\234\009\197\159\206\056\068" ..
		-- tex:"0538199b8183fed73cc89a57f76d3425"; x:-1831.661621; y:-2206.636963; z:739.228516
		"\163\172\032\232\037\249\161\017\055\007\020\218\168\103\127\254\118\197\164\196\225\088\187\196\154\153\057\068" ..
		-- tex:"a3ac20e825f9a111370714daa8677ffe"; x:-1318.170776; y:-1498.777588; z:742.400085
		"\230\125\070\050\118\248\007\153\075\222\039\172\194\200\157\212\044\090\168\196\248\100\011\197\169\154\057\068" ..
		-- tex:"e67d463276f807994bde27acc2c89dd4"; x:-1346.817993; y:-2230.310791; z:742.416626
		"\050\182\165\155\015\090\195\157\072\092\067\010\247\092\251\080\080\184\159\196\031\204\014\197\018\156\057\068" ..
		-- tex:"32b6a59b0f5ac39d485c430af75cfb50"; x:-1277.759888; y:-2284.757813; z:742.438660
		"\109\224\142\116\026\005\021\244\181\134\206\225\121\135\043\144\145\161\227\196\012\214\014\197\175\156\057\068" ..
		-- tex:"6de08e741a0515f4b586cee179872b90"; x:-1821.049072; y:-2285.378174; z:742.448242
		"\200\198\179\198\034\074\024\197\252\224\238\063\143\174\170\101\113\164\236\196\151\041\214\196\008\183\059\068" ..
		-- tex:"c8c6b3c6224a18c5fce0ee3f8faeaa65"; x:-1893.138916; y:-1713.299805; z:750.859924
		"\218\075\193\059\110\062\114\236\057\099\210\165\201\246\236\133\113\164\172\196\151\041\214\196\008\183\059\068" ..
		-- tex:"da4bc13b6e3e72ec3963d2a5c9f6ec85"; x:-1381.138916; y:-1713.299805; z:750.859924
		"\061\245\206\124\149\110\032\117\183\009\012\032\207\129\021\003\113\164\172\196\151\041\246\196\008\183\059\068" ..
		-- tex:"3df5ce7c956e2075b7090c20cf811503"; x:-1381.138916; y:-1969.299805; z:750.859924
		"\218\003\014\079\192\057\001\082\140\175\021\137\140\097\165\072\113\164\204\196\151\041\214\196\008\183\059\068" ..
		-- tex:"da030e4fc03901528caf15898c61a548"; x:-1637.138916; y:-1713.299805; z:750.859924
		"\117\089\145\181\226\230\238\252\061\200\042\200\041\023\145\206\113\164\204\196\203\020\011\197\008\183\059\068" ..
		-- tex:"755991b5e2e6eefc3dc82ac8291791ce"; x:-1637.138916; y:-2225.299805; z:750.859924
		"\037\208\070\175\091\116\167\085\077\224\192\017\132\199\127\048\113\164\236\196\203\020\011\197\008\183\059\068" ..
		-- tex:"25d046af5b74a7554de0c01184c77f30"; x:-1893.138916; y:-2225.299805; z:750.859924
		"\236\144\005\082\086\199\117\000\186\129\030\239\078\028\008\083\113\164\236\196\151\041\246\196\008\183\059\068" ..
		-- tex:"ec90055256c77500ba811eef4e1c0853"; x:-1893.138916; y:-1969.299805; z:750.859924
		"\148\151\118\085\202\145\158\242\178\122\202\232\145\138\127\077\062\102\176\196\109\022\220\196\086\133\096\068" ..
		-- tex:"94977655ca919ef2b27acae8918a7f4d"; x:-1411.195190; y:-1760.700928; z:898.083435
		"\155\233\217\130\120\135\182\065\161\136\177\192\242\029\136\118\062\102\176\196\109\022\252\196\086\133\096\068" ..
		-- tex:"9be9d9827887b641a188b1c0f21d8876"; x:-1411.195190; y:-2016.700928; z:898.083435
		"\103\157\130\169\123\041\099\185\075\209\138\168\037\187\083\196\062\102\208\196\109\022\252\196\086\133\096\068" ..
		-- tex:"679d82a97b2963b94bd18aa825bb53c4"; x:-1667.195190; y:-2016.700928; z:898.083435
		"\227\023\136\178\215\020\171\048\111\223\058\092\111\238\167\202\062\102\208\196\109\022\220\196\086\133\096\068" ..
		-- tex:"e31788b2d714ab306fdf3a5c6feea7ca"; x:-1667.195190; y:-1760.700928; z:898.083435
		"\243\067\204\237\011\198\251\198\019\226\078\188\010\167\134\247\113\239\188\196\118\063\216\196\011\007\097\068" ..
		-- tex:"f343cced0bc6fbc613e24ebc0aa786f7"; x:-1511.482666; y:-1729.983276; z:900.110107
		"\211\120\198\040\118\184\232\153\191\102\096\046\125\030\106\213\101\046\189\196\198\117\254\196\252\088\117\068" ..
		-- tex:"d378c62876b8e899bf66602e7d1e6ad5"; x:-1513.449951; y:-2035.680542; z:981.390442
		"\206\205\208\233\149\088\095\230\040\162\233\017\224\251\179\169\025\034\206\196\062\161\003\197\147\012\121\068" ..
		-- tex:"cecdd0e995585fe628a2e911e0fbb3a9"; x:-1649.065674; y:-2106.077881; z:996.196533
		"\022\112\100\044\030\213\179\123\146\052\248\156\237\041\090\204\025\034\206\196\125\066\231\196\147\012\121\068" ..
		-- tex:"1670642c1ed5b37b9234f89ced295acc"; x:-1649.065674; y:-1850.077881; z:996.196533
		"\161\127\098\026\085\089\089\247\015\229\190\225\061\079\180\036\025\034\174\196\125\066\231\196\147\012\121\068" ..
		-- tex:"a17f621a555959f70fe5bee13d4fb424"; x:-1393.065674; y:-1850.077881; z:996.196533
		"\019\175\133\088\235\248\003\194\079\097\047\168\235\089\176\141\025\034\174\196\062\161\003\197\147\012\121\068" ..
		-- tex:"13af8558ebf803c24f612fa8eb59b08d"; x:-1393.065674; y:-2106.077881; z:996.196533
		"\020\103\035\250\063\052\147\174\129\222\130\040\046\048\126\184\176\154\188\196\099\222\231\196\144\106\128\068",
		-- tex:"146723fa3f3493ae81de82282e307eb8"; x:-1508.834106; y:-1854.949707; z:1027.330200
	["Blackfathom Deeps"] = 
		"\130\132\132\191\196\070\000\176\059\032\087\034\101\117\114\040\182\235\141\068\101\118\225\195\243\012\033\195" ..
		-- tex:"828484bfc44600b03b20572265757228"; x:1135.366089; y:-450.924988; z:-161.050598
		"\170\224\227\065\113\097\126\083\071\005\139\241\029\188\129\125\109\215\091\068\203\236\066\195\243\012\033\195" ..
		-- tex:"aae0e34171617e5347058bf11dbc817d"; x:879.366089; y:-194.924988; z:-161.050598
		"\106\153\019\246\021\027\120\034\009\156\110\110\026\156\163\253\182\235\141\068\050\187\048\196\243\012\033\195" ..
		-- tex:"6a9913f6151b7822099c6e6e1a9ca3fd"; x:1135.366089; y:-706.924988; z:-161.050598
		"\010\125\124\009\071\236\180\115\118\064\040\070\221\053\110\100\109\215\091\068\050\187\048\196\243\012\033\195" ..
		-- tex:"0a7d7c0947ecb47376402846dd356e64"; x:879.366089; y:-706.924988; z:-161.050598
		"\120\165\004\223\080\228\202\138\176\250\096\024\087\154\121\022\109\215\091\068\101\118\225\195\243\012\033\195" ..
		-- tex:"78a504df50e4ca8ab0fa6018579a7916"; x:879.366089; y:-450.924988; z:-161.050598
		"\073\143\165\059\007\074\051\226\076\093\061\125\196\076\086\079\205\229\022\068\204\135\050\196\197\032\031\195" ..
		-- tex:"498fa53b074a33e24c5d3d7dc44c564f"; x:603.590698; y:-714.121887; z:-159.128021
		"\214\124\120\073\007\144\111\216\058\152\218\185\111\209\228\222\205\229\022\068\051\031\074\195\197\032\031\195" ..
		-- tex:"d67c784907906fd83a98dab96fd1e4de"; x:603.590698; y:-202.121887; z:-159.128021
		"\212\141\218\123\121\024\217\043\246\057\136\066\173\186\007\062\205\229\086\068\204\135\050\196\197\032\031\195" ..
		-- tex:"d48dda7b7918d92bf6398842adba073e"; x:859.590698; y:-714.121887; z:-159.128021
		"\190\109\073\196\056\206\163\250\147\025\073\233\120\167\232\195\205\229\086\068\051\031\074\195\197\032\031\195" ..
		-- tex:"be6d49c438cea3fa931949e978a7e8c3"; x:859.590698; y:-202.121887; z:-159.128021
		"\094\051\094\085\061\014\010\124\183\226\134\074\201\041\180\078\205\229\086\068\153\015\229\195\197\032\031\195" ..
		-- tex:"5e335e553d0e0a7cb7e2864ac929b44e"; x:859.590698; y:-458.121887; z:-159.128021
		"\029\022\046\088\206\253\061\182\000\223\027\197\128\026\150\225\205\229\022\068\153\015\229\195\197\032\031\195" ..
		-- tex:"1d162e58cefd3db600df1bc5801a96e1"; x:603.590698; y:-458.121887; z:-159.128021
		"\137\121\102\179\147\059\253\045\053\111\198\093\142\227\202\197\068\235\014\068\039\225\055\196\001\239\028\195" ..
		-- tex:"897966b3933bfd2d356fc65d8ee3cac5"; x:571.676086; y:-735.518066; z:-156.933624
		"\056\091\133\222\125\205\187\137\180\080\143\113\012\165\195\196\181\016\056\068\245\234\037\195\157\131\023\195" ..
		-- tex:"385b85de7dcdbb89b4508f710ca5c3c4"; x:736.261078; y:-165.917816; z:-151.514130
		"\038\184\166\177\099\065\149\127\147\168\127\160\002\164\049\238\106\033\240\067\245\234\037\195\157\131\023\195" ..
		-- tex:"26b8a6b16341957f93a87fa002a431ee"; x:480.261078; y:-165.917816; z:-151.514130
		"\161\083\172\228\049\205\108\008\012\171\127\142\139\071\158\193\133\217\179\068\139\161\113\067\081\120\238\194" ..
		-- tex:"a153ace431cd6c080cab7f8e8b479ec1"; x:1438.797607; y:241.631042; z:-119.235001
		"\060\057\225\067\188\133\088\034\131\148\067\145\232\102\164\204\053\045\012\068\085\253\149\195\047\119\238\194" ..
		-- tex:"3c39e143bc85582283944391e866a4cc"; x:560.706421; y:-299.979187; z:-119.232788
		"\222\022\136\106\113\102\232\134\110\109\113\021\009\225\011\139\176\183\151\068\247\159\147\195\106\068\238\194" ..
		-- tex:"de16886a7166e8866e6d711509e10b8b"; x:1213.740356; y:-295.249756; z:-119.133629
		"\070\001\021\078\007\229\216\076\233\186\018\206\013\143\222\165\033\225\146\068\055\158\000\196\238\019\233\194" ..
		-- tex:"4601154e07e5d84ce9ba12ce0d8fdea5"; x:1175.035400; y:-514.472168; z:-116.538933
		"\147\248\026\110\010\041\205\081\186\010\106\203\039\202\061\120\133\056\015\068\026\003\084\196\202\118\231\194" ..
		-- tex:"93f81a6e0a29cd51ba0a6acb27ca3d78"; x:572.883179; y:-848.048523; z:-115.732018
		"\122\039\078\196\143\205\069\162\025\080\073\169\229\109\155\185\205\157\143\068\152\186\251\194\250\053\226\194" ..
		-- tex:"7a274ec48fcd45a2195049a9e56d9bb9"; x:1148.931396; y:-125.864449; z:-113.105431
		"\238\199\248\188\019\251\231\083\014\001\216\238\023\008\251\167\200\015\190\067\149\162\219\194\186\048\221\194" ..
		-- tex:"eec7f8bc13fbe7530e01d8ee1708fba7"; x:380.123322; y:-109.817551; z:-110.595177
		"\096\251\223\245\031\036\052\254\130\005\077\168\105\000\236\193\048\117\161\067\252\209\028\195\062\243\213\194" ..
		-- tex:"60fbdff51f2434fe82054da86900ecc1"; x:322.915558; y:-156.820267; z:-106.975090
		"\098\023\204\205\074\069\143\254\176\019\254\139\156\004\026\192\103\219\067\068\056\021\238\194\136\096\205\194" ..
		-- tex:"6217cccd4a458ffeb013fe8b9c041ac0"; x:783.428223; y:-119.041451; z:-102.688545
		"\041\167\221\129\202\048\019\127\114\063\065\027\115\057\064\054\179\237\129\068\056\021\238\194\136\096\205\194" ..
		-- tex:"29a7dd81ca30137f723f411b73394036"; x:1039.428223; y:-119.041451; z:-102.688545
		"\016\061\244\034\068\061\085\226\039\134\006\219\223\231\060\236\150\250\131\068\188\208\079\194\102\122\204\194" ..
		-- tex:"103df422443d55e2278606dbdfe73cec"; x:1055.830933; y:-51.953846; z:-102.239067
		"\128\161\091\218\057\200\047\072\158\085\120\119\184\072\176\098\211\190\136\067\232\163\208\195\246\180\195\194" ..
		-- tex:"80a15bda39c82f489e557877b848b062"; x:273.490845; y:-417.280548; z:-97.853447
		"\054\252\223\087\049\208\116\187\126\067\012\119\017\154\026\089\184\162\025\067\017\010\172\195\099\104\190\194" ..
		-- tex:"36fcdf5731d074bb7e430c77119a1a59"; x:153.635635; y:-344.078674; z:-95.203888
		"\026\072\142\103\200\150\029\092\047\101\125\246\081\001\225\091\117\195\194\068\241\051\097\068\169\203\187\194" ..
		-- tex:"1a488e67c8961d5c2f657df65101e15b"; x:1558.108154; y:900.811646; z:-93.897781
		"\169\252\136\025\239\101\128\082\124\097\084\217\029\135\178\157\117\195\194\068\227\103\194\067\169\203\187\194" ..
		-- tex:"a9fc8819ef6580527c6154d91d87b29d"; x:1558.108154; y:388.811646; z:-93.897781
		"\057\115\108\067\094\007\084\153\249\247\133\030\230\225\139\018\117\195\194\068\241\051\033\068\169\203\187\194" ..
		-- tex:"39736c435e075499f9f7851ee6e18b12"; x:1558.108154; y:644.811646; z:-93.897781
		"\001\024\115\070\214\237\108\105\231\074\131\208\030\021\119\054\160\045\095\068\120\211\054\066\158\021\187\194" ..
		-- tex:"01187346d6ed6c69e74a83d01e157736"; x:892.712952; y:45.706516; z:-93.542229
		"\116\115\218\143\130\068\236\211\190\233\145\230\226\040\001\127\173\106\141\067\026\124\096\195\034\245\184\194" ..
		-- tex:"7473da8f8244ecd3bee991e6e228017f"; x:282.833435; y:-224.484787; z:-92.478783
		"\223\141\040\056\169\049\149\136\143\230\175\031\206\037\240\063\069\199\194\068\088\112\004\066\133\233\183\194" ..
		-- tex:"df8d2838a93195888fe6af1fce25f03f"; x:1558.227295; y:33.109715; z:-91.956100
		"\099\075\185\251\089\223\084\156\217\191\016\251\160\156\233\202\237\115\168\068\006\013\083\067\133\233\183\194" ..
		-- tex:"634bb9fb59df549cd9bf10fba09ce9ca"; x:1347.622803; y:211.050880; z:-91.956100
		"\141\131\000\186\036\230\090\142\213\007\009\156\144\183\022\240\237\115\168\068\229\203\051\194\133\233\183\194" ..
		-- tex:"8d8300ba24e65a8ed507099c90b716f0"; x:1347.622803; y:-44.949120; z:-91.956100
		"\016\156\131\207\132\151\117\004\025\228\009\239\155\157\195\006\078\075\132\068\042\234\067\066\163\023\159\194" ..
		-- tex:"109c83cf8497750419e409ef9b9dc306"; x:1058.353394; y:48.978680; z:-79.546173
		"\184\085\220\043\123\060\017\101\228\002\126\196\136\231\221\044\171\139\161\068\149\145\199\194\226\135\129\194" ..
		-- tex:"b855dc2b7b3c1165e4027ec488e7dd2c"; x:1292.364746; y:-99.784348; z:-64.765404
		"\242\099\012\165\180\163\026\181\039\206\118\134\061\146\156\155\080\247\147\068\158\029\029\064\087\023\108\194" ..
		-- tex:"f2630ca5b4a31ab527ce76863d929c9b"; x:1183.728638; y:2.454933; z:-59.022797
		"\170\186\115\191\140\143\250\013\224\223\029\151\002\004\011\210\016\035\191\068\140\039\079\067\171\148\079\194",
		-- tex:"aaba73bf8c8ffa0de0df1d9702040bd2"; x:1529.095825; y:207.154495; z:-51.895187
	["Blackrock Depths"] = 
		"\015\074\234\019\236\099\185\111\246\049\048\006\248\182\160\150\246\076\026\197\197\108\153\068\121\228\208\195" ..
		-- tex:"0f4aea13ec63b96ff6313006f8b6a096"; x:-2468.810303; y:1227.399109; z:-417.784973
		"\108\089\248\019\011\233\206\011\241\035\045\195\136\084\026\000\246\076\026\197\138\217\114\068\121\228\208\195" ..
		-- tex:"6c59f8130be9ce0bf1232dc388541a00"; x:-2468.810303; y:971.399109; z:-417.784973
		"\022\208\224\153\123\107\016\128\022\182\076\079\157\179\123\128\246\076\010\197\197\108\153\068\121\228\208\195" ..
		-- tex:"16d0e0997b6b108016b64c4f9db37b80"; x:-2212.810303; y:1227.399109; z:-417.784973
		"\124\025\227\034\063\254\039\116\058\054\074\154\117\251\019\009\246\076\010\197\138\217\114\068\121\228\208\195" ..
		-- tex:"7c19e3223ffe27743a364a9a75fb1309"; x:-2212.810303; y:971.399109; z:-417.784973
		"\131\108\206\100\231\162\142\028\168\069\026\184\036\097\085\186\237\153\244\196\138\217\114\068\121\228\208\195" ..
		-- tex:"836cce64e7a28e1ca8451ab8246155ba"; x:-1956.810303; y:971.399109; z:-417.784973
		"\080\124\172\044\037\053\033\103\067\238\049\205\085\118\008\114\101\047\208\196\205\139\238\193\036\230\199\195" ..
		-- tex:"507cac2c2535216743ee31cd55760872"; x:-1665.481201; y:-29.818264; z:-399.798004
		"\143\054\205\217\244\043\155\059\030\080\133\197\115\030\120\152\101\047\208\196\134\046\098\067\036\230\199\195" ..
		-- tex:"8f36cdd9f42b9b3b1e5085c5731e7898"; x:-1665.481201; y:226.181736; z:-399.798004
		"\031\105\074\102\165\027\234\148\026\078\039\032\137\191\006\194\101\047\176\196\161\139\056\068\036\230\199\195" ..
		-- tex:"1f694a66a51bea941a4e272089bf06c2"; x:-1409.481201; y:738.181736; z:-399.798004
		"\111\052\112\085\228\188\093\229\201\117\019\161\252\164\116\010\101\047\240\196\161\139\120\068\036\230\199\195" ..
		-- tex:"6f347055e4bc5de5c97513a1fca4740a"; x:-1921.481201; y:994.181736; z:-399.798004
		"\115\020\185\167\059\168\227\106\238\039\133\026\250\047\193\087\101\047\240\196\161\139\056\068\036\230\199\195" ..
		-- tex:"7314b9a73ba8e36aee27851afa2fc157"; x:-1921.481201; y:738.181736; z:-399.798004
		"\193\179\167\127\091\240\049\143\098\089\207\246\117\158\219\077\101\047\240\196\134\046\098\067\036\230\199\195" ..
		-- tex:"c1b3a77f5bf0318f6259cff6759edb4d"; x:-1921.481201; y:226.181736; z:-399.798004
		"\150\111\048\088\006\015\189\098\195\087\143\032\065\161\151\244\101\047\208\196\067\023\241\067\036\230\199\195" ..
		-- tex:"966f3058060fbd62c3578f2041a197f4"; x:-1665.481201; y:482.181736; z:-399.798004
		"\201\017\248\172\073\054\132\234\138\067\111\074\138\130\244\235\101\047\176\196\067\023\241\067\036\230\199\195" ..
		-- tex:"c911f8ac493684ea8a436f4a8a82f4eb"; x:-1409.481201; y:482.181736; z:-399.798004
		"\189\077\180\062\181\253\054\254\180\255\070\183\051\241\108\186\101\047\240\196\205\139\238\193\036\230\199\195" ..
		-- tex:"bd4db43eb5fd36feb4ff46b733f16cba"; x:-1921.481201; y:-29.818264; z:-399.798004
		"\227\027\161\247\093\013\016\166\068\088\207\255\234\201\039\044\101\047\208\196\161\139\056\068\036\230\199\195" ..
		-- tex:"e31ba1f75d0d10a64458cfffeac9272c"; x:-1665.481201; y:738.181736; z:-399.798004
		"\025\068\011\124\054\062\007\030\097\032\085\120\039\076\095\025\101\047\176\196\205\139\238\193\036\230\199\195" ..
		-- tex:"19440b7c363e071e61205578274c5f19"; x:-1409.481201; y:-29.818264; z:-399.798004
		"\192\196\053\017\245\064\145\012\137\090\213\195\221\106\125\174\178\023\008\197\134\046\098\067\036\230\199\195" ..
		-- tex:"c0c43511f540910c895ad5c3dd6a7dae"; x:-2177.481201; y:226.181736; z:-399.798004
		"\072\036\110\087\077\045\209\127\056\148\175\025\212\138\005\065\101\047\176\196\134\046\098\067\036\230\199\195" ..
		-- tex:"48246e574d2dd17f3894af19d48a0541"; x:-1409.481201; y:226.181736; z:-399.798004
		"\047\154\145\003\220\081\235\142\169\000\210\007\175\195\082\214\101\047\208\196\161\139\120\068\036\230\199\195" ..
		-- tex:"2f9a9103dc51eb8ea900d207afc352d6"; x:-1665.481201; y:994.181736; z:-399.798004
		"\181\227\117\244\190\018\191\159\165\152\150\085\088\038\017\249\178\023\008\197\205\139\238\193\036\230\199\195" ..
		-- tex:"b5e375f4be12bf9fa5989655582611f9"; x:-2177.481201; y:-29.818264; z:-399.798004
		"\252\204\175\245\065\149\135\070\155\126\014\020\009\176\108\244\195\161\038\197\114\080\074\068\017\198\122\195" ..
		-- tex:"fcccaff5419587469b7e0e1409b06cf4"; x:-2666.110352; y:809.257019; z:-250.773712
		"\086\198\097\113\013\013\050\240\003\059\165\036\212\066\064\170\195\161\038\197\057\040\133\068\017\198\122\195" ..
		-- tex:"56c661710d0d32f0033ba524d44240aa"; x:-2666.110352; y:1065.257019; z:-250.773712
		"\052\004\078\173\060\060\090\066\092\255\187\128\070\032\033\065\195\161\038\197\114\080\010\068\017\198\122\195" ..
		-- tex:"34044ead3c3c5a425cffbb8046202141"; x:-2666.110352; y:553.257019; z:-250.773712
		"\081\174\064\057\244\238\007\139\013\153\172\209\057\054\253\184\195\161\022\197\114\080\074\068\017\198\122\195" ..
		-- tex:"51ae4039f4ee078b0d99acd13936fdb8"; x:-2410.110352; y:809.257019; z:-250.773712
		"\019\030\251\134\244\143\002\064\191\146\052\132\245\189\065\215\195\161\022\197\114\080\010\068\017\198\122\195" ..
		-- tex:"131efb86f48f0240bf923484f5bd41d7"; x:-2410.110352; y:553.257019; z:-250.773712
		"\139\134\026\005\035\238\033\032\199\003\125\005\189\023\118\192\207\105\021\197\103\068\020\068\232\147\121\195" ..
		-- tex:"8b861a0523ee2120c7037d05bd1776c0"; x:-2390.613281; y:593.068817; z:-249.577774
		"\211\133\070\027\200\216\177\224\083\136\178\072\084\209\207\087\159\211\234\196\206\136\168\067\232\147\121\195" ..
		-- tex:"d385461bc8d8b1e05388b24854d1cf57"; x:-1878.613281; y:337.068817; z:-249.577774
		"\208\233\052\231\083\089\108\178\024\214\216\096\080\158\101\139\207\105\005\197\103\068\020\068\232\147\121\195" ..
		-- tex:"d0e934e753596cb218d6d860509e658b"; x:-2134.613281; y:593.068817; z:-249.577774
		"\195\014\055\070\072\157\079\041\019\136\033\116\100\004\151\104\207\105\005\197\206\136\168\067\232\147\121\195" ..
		-- tex:"c30e3746489d4f291388217464049768"; x:-2134.613281; y:337.068817; z:-249.577774
		"\245\070\172\038\131\019\108\223\190\144\156\134\113\108\089\057\207\105\021\197\206\136\168\067\232\147\121\195" ..
		-- tex:"f546ac2683136cdfbe909c86716c5939"; x:-2390.613281; y:337.068817; z:-249.577774
		"\142\216\020\018\134\101\000\027\110\026\140\184\133\102\247\209\122\060\157\196\079\127\156\067\229\223\112\195" ..
		-- tex:"8ed814128665001b6e1a8cb88566f7d1"; x:-1257.890015; y:312.994629; z:-240.874603
		"\247\207\171\005\131\126\003\035\213\030\231\068\159\052\238\118\148\241\249\196\215\071\226\067\090\231\104\195" ..
		-- tex:"f7cfab05837e0323d51ee7449f34ee76"; x:-1999.549438; y:452.561279; z:-232.903732
		"\164\131\131\090\176\078\231\007\110\105\197\012\149\014\067\147\148\241\217\196\215\071\226\067\090\231\104\195" ..
		-- tex:"a483835ab04ee7076e69c50c950e4393"; x:-1743.549438; y:452.561279; z:-232.903732
		"\216\014\112\140\000\087\059\111\075\244\038\231\120\183\254\195\148\241\249\196\235\035\049\068\090\231\104\195" ..
		-- tex:"d80e708c00573b6f4bf426e778b7fec3"; x:-1999.549438; y:708.561279; z:-232.903732
		"\045\242\052\119\231\023\185\053\204\117\020\008\179\207\254\103\148\241\217\196\235\035\049\068\090\231\104\195" ..
		-- tex:"2df23477e717b935cc751408b3cffe67"; x:-1743.549438; y:708.561279; z:-232.903732
		"\221\005\166\048\082\250\165\124\098\095\180\044\029\039\106\108\245\006\012\197\238\015\096\068\255\015\100\195" ..
		-- tex:"dd05a63052faa57c625fb42c1d276a6c"; x:-2240.435059; y:896.248962; z:-228.062500
		"\086\075\164\227\182\021\057\110\036\102\224\224\192\079\149\062\212\129\043\196\134\216\117\195\101\205\076\195" ..
		-- tex:"564ba4e3b615396e2466e0e0c04f953e"; x:-686.028625; y:-245.845810; z:-204.802338
		"\029\020\150\224\233\185\198\116\163\225\237\233\140\017\224\152\212\129\107\196\143\119\034\065\101\205\076\195" ..
		-- tex:"1d1496e0e9b9c674a3e1ede98c11e098"; x:-942.028625; y:10.154190; z:-204.802338
		"\077\149\082\099\112\088\195\025\006\080\111\112\203\222\218\073\212\129\107\196\134\216\117\195\101\205\076\195" ..
		-- tex:"4d9552637058c31906506f70cbdeda49"; x:-942.028625; y:-245.845810; z:-204.802338
		"\110\146\126\075\039\219\033\140\249\177\005\004\073\159\228\170\165\213\041\197\133\151\088\068\159\103\061\195" ..
		-- tex:"6e927e4b27db218cf9b10504499fe4aa"; x:-2717.353027; y:866.367554; z:-189.404785
		"\062\235\100\131\228\093\150\233\050\065\038\066\111\193\110\009\165\213\041\197\133\151\024\068\159\103\061\195" ..
		-- tex:"3eeb6483e45d96e9324126426fc16e09"; x:-2717.353027; y:610.367554; z:-189.404785
		"\229\118\134\146\104\021\030\131\208\119\122\102\025\050\177\133\165\213\057\197\133\151\088\068\159\103\061\195" ..
		-- tex:"e576869268151e83d0777a661932b185"; x:-2973.353027; y:866.367554; z:-189.404785
		"\145\173\131\138\193\025\166\221\254\153\077\219\242\148\094\026\165\213\057\197\133\151\024\068\159\103\061\195" ..
		-- tex:"91ad838ac119a6ddfe994ddbf2945e1a"; x:-2973.353027; y:610.367554; z:-189.404785
		"\120\196\105\148\211\028\078\048\210\067\215\088\020\008\108\071\194\180\050\197\084\000\177\068\069\130\057\195" ..
		-- tex:"78c46994d31c4e30d243d75814086c47"; x:-2859.297607; y:1416.010376; z:-185.508881
		"\175\173\187\157\192\003\013\003\241\139\078\088\248\111\148\140\194\180\050\197\084\000\209\068\069\130\057\195" ..
		-- tex:"afadbb9dc0030d03f18b4e58f86f948c"; x:-2859.297607; y:1672.010376; z:-185.508881
		"\108\047\141\194\203\107\042\089\082\137\051\208\176\047\025\182\242\221\048\197\156\089\139\068\165\089\056\195" ..
		-- tex:"6c2f8dc2cb6b2a59528933d0b02f19b6"; x:-2829.871826; y:1114.800415; z:-184.350189
		"\058\098\199\254\198\164\135\069\233\031\024\213\006\199\024\138\242\221\048\197\156\089\171\068\165\089\056\195" ..
		-- tex:"3a62c7fec6a48745e91f18d506c7188a"; x:-2829.871826; y:1370.800415; z:-184.350189
		"\010\130\147\055\238\250\243\055\055\021\232\025\025\066\138\157\104\087\036\197\066\005\025\068\017\042\056\195" ..
		-- tex:"0a829337eefaf3373715e81919428a9d"; x:-2629.463135; y:612.082214; z:-184.164337
		"\128\048\008\080\157\252\029\099\179\234\035\198\249\189\085\080\159\224\037\197\040\121\011\068\038\140\044\195" ..
		-- tex:"803008509dfc1d63b3ea23c6f9bd5550"; x:-2654.039063; y:557.893127; z:-172.547470
		"\236\025\247\022\028\048\201\161\163\067\013\059\141\247\203\179\159\224\021\197\081\242\150\067\038\140\044\195" ..
		-- tex:"ec19f7161c30c9a1a3430d3b8df7cbb3"; x:-2398.039063; y:301.893127; z:-172.547470
		"\034\042\186\231\080\205\030\246\169\049\119\092\081\252\080\163\159\224\037\197\081\242\150\067\038\140\044\195" ..
		-- tex:"222abae750cd1ef6a931775c51fc50a3"; x:-2654.039063; y:301.893127; z:-172.547470
		"\034\052\078\244\014\028\210\185\118\102\107\219\140\018\251\122\081\203\166\196\216\152\216\067\013\143\043\195" ..
		-- tex:"22344ef40e1cd2b976666bdb8c12fb7a"; x:-1334.353760; y:433.194122; z:-171.558807
		"\254\176\249\239\054\253\170\098\080\160\118\196\145\139\048\100\081\203\134\196\216\152\216\067\013\143\043\195" ..
		-- tex:"feb0f9ef36fdaa6250a076c4918b3064"; x:-1078.353760; y:433.194122; z:-171.558807
		"\226\004\197\247\077\037\009\055\219\098\154\022\129\087\052\060\104\031\010\197\133\058\093\067\201\109\043\195" ..
		-- tex:"e204c5f74d250937db629a168157343c"; x:-2209.963135; y:221.228607; z:-171.428864
		"\222\130\143\109\189\182\048\179\052\218\185\228\185\049\123\155\104\031\026\197\133\058\093\067\201\109\043\195" ..
		-- tex:"de828f6dbdb630b334dab9e4b9317b9b"; x:-2465.963135; y:221.228607; z:-171.428864
		"\167\159\009\127\201\226\116\212\127\054\185\164\109\181\160\242\104\031\026\197\066\157\238\067\201\109\043\195" ..
		-- tex:"a79f097fc9e274d47f36b9a46db5a0f2"; x:-2465.963135; y:477.228607; z:-171.428864
		"\106\126\061\084\222\171\227\124\000\167\011\054\058\076\091\251\132\243\254\196\154\131\029\068\117\136\040\195" ..
		-- tex:"6a7e3d54deabe37c00a70b363a4c5bfb"; x:-2039.609985; y:630.056335; z:-168.533051
		"\187\082\194\230\084\002\091\171\082\024\011\176\040\126\248\159\132\243\254\196\154\131\093\068\117\136\040\195" ..
		-- tex:"bb52c2e654025bab52180bb0287ef89f"; x:-2039.609985; y:886.056335; z:-168.533051
		"\170\139\205\157\159\074\104\151\070\214\171\172\101\081\227\128\132\243\222\196\154\131\029\068\117\136\040\195" ..
		-- tex:"aa8bcd9d9f4a689746d6abac6551e380"; x:-1783.609985; y:630.056335; z:-168.533051
		"\056\055\091\061\057\183\191\113\083\184\078\006\211\134\185\036\098\067\034\196\246\001\140\067\074\158\039\195" ..
		-- tex:"38375b3d39b7bf7153b84e06d386b924"; x:-649.052917; y:280.015350; z:-167.618332
		"\198\238\041\107\103\174\240\054\169\225\177\010\221\206\110\123\098\067\098\196\246\001\140\067\074\158\039\195" ..
		-- tex:"c6ee296b67aef036a9e1b10addce6e7b"; x:-905.052917; y:280.015350; z:-167.618332
		"\210\010\178\166\048\014\091\059\117\142\066\185\250\167\239\071\074\206\168\196\083\053\091\067\012\028\033\195" ..
		-- tex:"d20ab2a6300e5b3b758e42b9faa7ef47"; x:-1350.446655; y:219.208313; z:-161.109573
		"\173\107\234\117\142\093\126\224\136\239\055\166\047\234\038\054\184\226\022\196\044\058\156\066\001\117\030\195" ..
		-- tex:"ad6bea758e5d7ee088ef37a62fea2636"; x:-603.542542; y:78.113625; z:-158.457062
		"\183\254\201\012\010\088\212\083\254\144\080\127\144\103\024\119\184\226\022\196\139\014\167\067\001\117\030\195" ..
		-- tex:"b7fec90c0a58d453fe90507f90671877"; x:-603.542542; y:334.113625; z:-158.457062
		"\089\020\077\210\107\096\142\194\108\106\009\086\224\233\242\069\184\226\086\196\044\058\156\066\001\117\030\195" ..
		-- tex:"59144dd26b608ec26c6a0956e0e9f245"; x:-859.542542; y:78.113625; z:-158.457062
		"\135\104\024\255\183\254\117\091\154\184\213\082\026\038\029\181\023\167\032\197\103\153\017\068\126\126\028\195" ..
		-- tex:"876818ffb7fe755b9ab8d5521a261db5"; x:-2570.443359; y:582.396973; z:-156.494125
		"\104\057\242\146\207\006\078\065\197\218\007\174\105\193\039\057\132\197\207\196\250\033\205\067\113\138\021\195" ..
		-- tex:"6839f292cf064e41c5da07ae69c12739"; x:-1662.172485; y:410.265472; z:-149.540802
		"\223\044\149\023\009\064\106\143\005\100\086\122\090\088\163\064\132\197\239\196\250\033\205\067\113\138\021\195" ..
		-- tex:"df2c951709406a8f0564567a5a58a340"; x:-1918.172485; y:410.265472; z:-149.540802
		"\092\089\204\133\051\218\071\125\232\171\208\132\061\146\249\005\132\197\239\196\253\144\038\068\113\138\021\195" ..
		-- tex:"5c59cc8533da477de8abd0843d92f905"; x:-1918.172485; y:666.265472; z:-149.540802
		"\041\080\254\117\033\049\165\094\065\117\059\099\232\083\157\071\186\116\146\196\019\250\156\194\015\096\021\195" ..
		-- tex:"2950fe752131a55e41753b63e8539d47"; x:-1171.647827; y:-78.488434; z:-149.375244
		"\160\173\205\118\040\187\065\185\108\235\165\057\186\125\044\229\186\116\146\196\245\130\049\067\015\096\021\195" ..
		-- tex:"a0adcd7628bb41b96ceba539ba7d2ce5"; x:-1171.647827; y:177.511566; z:-149.375244
		"\005\052\152\132\162\159\049\059\152\022\254\106\041\065\100\087\117\233\100\196\019\250\156\194\015\096\021\195" ..
		-- tex:"05349884a29f313b9816fe6a29416457"; x:-915.647827; y:-78.488434; z:-149.375244
		"\104\231\133\197\228\059\046\195\053\197\175\233\024\164\100\003\117\233\100\196\245\130\049\067\015\096\021\195" ..
		-- tex:"68e785c5e43b2ec335c5afe918a46403"; x:-915.647827; y:177.511566; z:-149.375244
		"\163\011\202\010\131\200\207\056\108\229\090\065\208\146\023\107\029\121\158\196\255\147\148\193\127\078\021\195" ..
		-- tex:"a30bca0a83c8cf386ce55a41d092176b"; x:-1267.784912; y:-18.572266; z:-149.306641
		"\238\019\148\013\105\078\213\215\045\219\007\089\205\136\017\098\029\121\158\196\063\073\137\195\127\078\021\195" ..
		-- tex:"ee13940d694ed5d72ddb0759cd881162"; x:-1267.784912; y:-274.572266; z:-149.306641
		"\167\149\201\167\089\040\086\080\171\081\050\069\248\226\165\231\029\121\190\196\063\073\137\195\127\078\021\195" ..
		-- tex:"a795c9a759285650ab513245f8e2a5e7"; x:-1523.784912; y:-274.572266; z:-149.306641
		"\162\204\062\140\182\234\157\200\227\093\175\054\222\064\072\254\029\121\190\196\255\147\148\193\127\078\021\195" ..
		-- tex:"a2cc3e8cb6ea9dc8e35daf36de4048fe"; x:-1523.784912; y:-18.572266; z:-149.306641
		"\137\217\184\173\249\064\046\024\011\193\025\104\113\190\007\016\029\121\190\196\159\164\004\196\127\078\021\195" ..
		-- tex:"89d9b8adf9402e180bc1196871be0710"; x:-1523.784912; y:-530.572266; z:-149.306641
		"\155\063\162\194\105\141\150\105\234\101\013\117\140\180\166\239\235\068\213\196\192\137\152\067\242\206\019\195" ..
		-- tex:"9b3fa2c2698d9669ea650d758cb4a6ef"; x:-1706.153809; y:305.076202; z:-147.808395
		"\082\186\024\027\099\001\009\004\221\057\137\203\205\111\163\038\240\132\031\196\088\143\054\067\009\123\014\195" ..
		-- tex:"52ba181b63010904dd3989cbcd6fa326"; x:-638.077209; y:182.559952; z:-142.480621
		"\128\255\173\239\189\054\068\246\176\016\139\077\189\024\177\237\240\132\095\196\088\143\054\067\009\123\014\195" ..
		-- tex:"80ffadefbd3644f6b0108b4dbd18b1ed"; x:-894.077209; y:182.559952; z:-142.480621
		"\102\091\052\170\198\063\242\197\116\060\203\203\206\232\126\126\036\133\206\196\025\243\001\195\117\230\011\195" ..
		-- tex:"665b34aac63ff2c5743ccbcbcee87e7e"; x:-1652.160767; y:-129.949615; z:-139.900238
		"\192\247\073\194\251\187\118\159\040\220\185\123\089\022\183\231\124\163\138\196\178\096\164\067\200\007\000\195" ..
		-- tex:"c0f749c2fbbb769f28dcb97b5916b7e7"; x:-1109.109009; y:328.755463; z:-128.030411
		"\070\120\185\117\006\174\194\251\141\169\232\202\105\124\086\240\077\132\242\196\061\234\199\067\006\067\247\194" ..
		-- tex:"4678b97506aec2fb8da9e8ca697c56f0"; x:-1940.134521; y:399.830017; z:-123.630913
		"\244\134\197\209\097\200\166\127\228\090\222\108\133\213\167\192\252\189\159\196\000\092\132\066\163\089\240\194" ..
		-- tex:"f486c5d161c8a67fe45ade6c85d5a7c0"; x:-1277.937134; y:66.179695; z:-120.175079
		"\118\176\109\097\173\100\149\185\106\153\160\250\178\222\020\129\216\074\185\196\245\181\254\194\163\089\240\194" ..
		-- tex:"76b06d61ad6495b96a99a0fab2de1481"; x:-1482.338989; y:-127.355392; z:-120.175079
		"\000\206\088\035\039\129\063\250\101\120\250\128\127\179\234\178\172\095\160\196\211\068\231\067\115\074\237\194" ..
		-- tex:"00ce582327813ffa6578fa807fb3eab2"; x:-1282.989868; y:462.537720; z:-118.645416
		"\216\119\230\184\063\017\204\051\065\164\114\218\150\051\040\121\027\176\172\196\223\126\234\067\213\178\235\194" ..
		-- tex:"d877e6b83f11cc3341a472da96332879"; x:-1381.503418; y:468.991196; z:-117.849289
		"\042\092\243\035\128\178\179\101\220\085\142\169\218\170\043\054\027\176\172\196\190\253\084\067\213\178\235\194" ..
		-- tex:"2a5cf32380b2b365dc558ea9daaa2b36"; x:-1381.503418; y:212.991196; z:-117.849289
		"\087\102\035\010\168\025\120\135\016\128\146\100\011\132\079\069\027\176\140\196\190\253\084\067\213\178\235\194" ..
		-- tex:"5766230aa8197887108092640b844f45"; x:-1125.503418; y:212.991196; z:-117.849289
		"\167\179\107\240\079\058\056\146\042\243\053\176\077\203\086\226\027\176\140\196\223\126\234\067\213\178\235\194" ..
		-- tex:"a7b36bf04f3a38922af335b04dcb56e2"; x:-1125.503418; y:468.991196; z:-117.849289
		"\102\118\222\009\175\056\144\048\200\061\180\043\177\115\192\188\003\015\214\196\191\091\113\067\085\154\216\194" ..
		-- tex:"6676de09af389030c83db42bb173c0bc"; x:-1712.469238; y:241.358398; z:-108.301437
		"\067\095\096\121\193\116\171\061\072\035\043\024\119\045\055\066\171\115\217\196\057\050\181\194\070\018\215\194" ..
		-- tex:"435f6079c174ab3d48232b18772d3742"; x:-1739.614746; y:-90.598099; z:-107.535698
		"\180\239\076\048\022\088\011\097\217\059\141\186\239\075\012\130\197\211\205\196\156\175\160\066\070\018\215\194" ..
		-- tex:"b4ef4c3016580b61d93b8dbaef4b0c82"; x:-1646.617920; y:80.342995; z:-107.535698
		"\172\193\154\157\131\036\243\039\121\036\162\075\070\020\085\069\061\152\147\196\179\237\080\067\252\052\214\194" ..
		-- tex:"acc19a9d8324f3277924a24b46145545"; x:-1180.757568; y:208.928528; z:-107.103493
		"\016\249\106\180\136\173\236\134\048\032\035\106\089\108\101\044\025\137\215\196\147\133\022\068\052\196\202\194" ..
		-- tex:"10f96ab488adec863020236a596c652c"; x:-1724.284424; y:602.087158; z:-101.383217
		"\138\253\239\242\184\144\113\126\222\050\193\063\226\077\122\219\122\098\208\196\222\014\036\068\100\108\202\194" ..
		-- tex:"8afdeff2b890717ede32c13fe24d7adb"; x:-1667.077515; y:656.232361; z:-101.211708
		"\186\184\108\253\169\120\244\017\000\192\130\113\076\205\100\078\125\129\225\196\088\069\036\068\217\241\199\194" ..
		-- tex:"bab86cfda978f41100c082714ccd644e"; x:-1804.046631; y:657.083557; z:-99.972366
		"\230\225\029\180\130\206\114\043\159\169\191\193\007\239\084\005\203\138\233\196\242\127\096\067\031\054\199\194" ..
		-- tex:"e6e11db482ce722b9fa9bfc107ef5405"; x:-1868.337402; y:224.499802; z:-99.605713
		"\109\185\247\178\022\128\174\003\228\148\042\239\051\047\147\126\081\142\232\196\162\095\128\067\182\039\199\194" ..
		-- tex:"6db9f7b21680ae03e4942aef332f937e"; x:-1860.447510; y:256.747162; z:-99.577568
		"\003\045\118\066\000\205\069\214\154\220\249\048\152\134\001\216\155\055\212\196\244\033\223\067\014\216\197\194" ..
		-- tex:"032d764200cd45d69adcf930988601d8"; x:-1697.737793; y:446.265289; z:-98.921989
		"\123\114\030\052\243\123\153\240\241\128\069\061\182\206\016\218\227\094\207\196\240\099\240\067\127\164\197\194" ..
		-- tex:"7b721e34f37b99f0f180453db6ce10da"; x:-1658.965332; y:480.780792; z:-98.821289
		"\077\032\135\089\066\160\011\076\159\189\217\113\016\008\067\136\044\085\173\196\225\219\105\067\207\011\185\194" ..
		-- tex:"4d20875942a00b4c9fbdd97110084388"; x:-1386.661743; y:233.858917; z:-92.523071
		"\030\124\139\177\002\097\027\225\032\228\177\026\243\115\242\188\034\180\192\196\238\188\014\064\206\011\185\194" ..
		-- tex:"1e7c8bb102611be120e4b11af373f2bc"; x:-1541.629272; y:2.230282; z:-92.523064
		"\061\230\022\191\121\255\140\178\075\248\208\178\175\236\188\040\160\117\129\196\240\158\231\067\138\070\176\194" ..
		-- tex:"3de616bf79ff8cb24bf8d0b2afecbc28"; x:-1035.675903; y:463.241730; z:-88.137779
		"\207\044\221\254\047\162\021\154\069\146\102\176\082\174\101\018\160\117\161\196\240\158\231\067\138\070\176\194" ..
		-- tex:"cf2cddfe2fa2159a459266b052ae6512"; x:-1291.675903; y:463.241730; z:-88.137779
		"\092\127\254\041\224\239\126\201\111\141\050\150\175\025\199\121\115\131\218\196\000\106\222\067\175\048\175\194" ..
		-- tex:"5c7ffe29e0ef7ec96f8d3296af19c779"; x:-1748.107910; y:444.828156; z:-87.595093
		"\204\178\047\122\149\202\060\238\061\218\026\138\085\034\033\035\137\009\205\196\224\086\206\067\121\096\173\194",
		-- tex:"ccb22f7a95ca3cee3dda1a8a55222123"; x:-1640.298096; y:412.678741; z:-86.688431
	["Blackrock Spire"] = 
		"\117\001\115\035\204\215\001\141\059\231\003\237\146\130\235\051\253\002\061\067\095\022\133\064\027\151\065\195" ..
		-- tex:"75017323ccd7018d3be703ed9282eb33"; x:189.011688; y:4.158981; z:-193.590271
		"\042\224\019\210\247\103\138\010\213\098\238\020\013\254\074\088\003\250\133\194\076\215\123\195\027\151\065\195" ..
		-- tex:"2ae013d2f7678a0ad562ee140dfe4a58"; x:-66.988312; y:-251.841019; z:-193.590271
		"\004\139\252\002\170\089\180\237\160\195\003\077\148\168\064\044\128\126\161\195\076\215\123\195\027\151\065\195" ..
		-- tex:"048bfc02aa59b4eda0c3034d94a8402c"; x:-322.988312; y:-251.841019; z:-193.590271
		"\178\243\172\124\014\089\013\158\045\166\091\090\130\091\043\207\128\126\161\195\095\022\133\064\027\151\065\195" ..
		-- tex:"b2f3ac7c0e590d9e2da65b5a825b2bcf"; x:-322.988312; y:4.158981; z:-193.590271
		"\157\144\154\172\086\076\130\193\140\014\133\127\046\169\025\231\003\250\133\194\095\022\133\064\027\151\065\195" ..
		-- tex:"9d909aac564c82c18c0e857f2ea919e7"; x:-66.988312; y:4.158981; z:-193.590271
		"\251\055\177\048\034\129\179\230\020\046\235\224\023\045\067\232\243\204\166\195\091\057\018\067\239\051\065\195" ..
		-- tex:"fb37b1302281b3e6142eebe0172d43e8"; x:-333.601196; y:146.224060; z:-193.202881
		"\021\087\050\018\147\225\039\134\008\078\012\218\099\221\144\185\023\102\050\067\091\057\018\067\239\051\065\195" ..
		-- tex:"1557321293e12786084e0cda63dd90b9"; x:178.398804; y:146.224060; z:-193.202881
		"\113\133\182\238\164\246\080\224\193\244\099\181\053\182\106\216\243\204\166\195\173\028\201\067\239\051\065\195" ..
		-- tex:"7185b6eea4f650e0c1f463b535b66ad8"; x:-333.601196; y:402.224060; z:-193.202881
		"\231\168\210\212\075\120\229\210\089\214\072\133\100\157\038\186\207\051\155\194\091\057\018\067\239\051\065\195" ..
		-- tex:"e7a8d2d44b78e5d259d64885649d26ba"; x:-77.601196; y:146.224060; z:-193.202881
		"\226\136\085\044\138\171\153\228\021\127\020\214\165\094\142\057\207\051\155\194\173\028\201\067\239\051\065\195" ..
		-- tex:"e288552c8aab99e4157f14d6a55e8e39"; x:-77.601196; y:402.224060; z:-193.202881
		"\117\026\116\208\157\221\153\204\066\107\224\245\009\034\126\191\191\078\108\195\137\133\029\068\015\230\148\194" ..
		-- tex:"751a74d09ddd99cc426be0f509227ebf"; x:-236.307617; y:630.086548; z:-74.449341
		"\248\011\010\117\025\127\009\217\090\113\033\005\171\046\076\015\255\137\157\065\137\133\029\068\015\230\148\194" ..
		-- tex:"f80b0a75197f09d95a712105ab2e4c0f"; x:19.692383; y:630.086548; z:-74.449341
		"\165\230\123\186\132\193\205\200\005\241\198\062\040\051\212\165\191\078\108\195\137\133\093\068\015\230\148\194" ..
		-- tex:"a5e67bba84c1cdc805f1c63e2833d4a5"; x:-236.307617; y:886.086548; z:-74.449341
		"\204\194\088\077\117\216\233\201\123\086\064\108\153\177\015\237\255\137\157\065\137\133\093\068\015\230\148\194" ..
		-- tex:"ccc2584d75d8e9c97b56406c99b10fed"; x:19.692383; y:886.086548; z:-74.449341
		"\231\116\068\023\104\042\113\217\063\243\083\144\030\238\037\207\159\216\137\067\137\133\029\068\015\230\148\194" ..
		-- tex:"e7744417682a71d93ff353901eee25cf"; x:275.692383; y:630.086548; z:-74.449341
		"\069\167\004\174\140\132\026\052\022\095\203\160\132\220\061\220\025\096\067\067\213\083\110\068\063\054\031\194" ..
		-- tex:"45a704ae8c841a34165fcba084dc3ddc"; x:195.375397; y:953.309937; z:-39.802979
		"\233\172\116\020\092\111\027\004\058\161\167\231\209\197\222\143\120\035\099\193\086\249\105\068\035\064\028\194" ..
		-- tex:"e9ac74145c6f1b043aa1a7e7d1c5de8f"; x:-14.196160; y:935.895935; z:-39.062637
		"\004\071\070\015\066\139\214\001\252\031\229\043\185\222\135\151\018\248\075\195\031\214\117\068\091\007\026\194" ..
		-- tex:"0447460f428bd601fc1fe52bb9de8797"; x:-203.969040; y:983.345703; z:-38.507187
		"\132\108\124\188\059\098\067\050\148\139\007\168\198\039\161\107\179\031\080\066\031\214\117\068\091\007\026\194" ..
		-- tex:"846c7cbc3b624332948b07a8c627a16b"; x:52.030960; y:983.345703; z:-38.507187
		"\076\018\054\164\039\171\170\128\190\018\141\025\122\170\131\098\227\121\087\065\219\123\093\068\135\006\024\194" ..
		-- tex:"4c1236a427abaa80be128d197aaa8362"; x:13.467258; y:885.935303; z:-38.006378
		"\014\189\126\128\001\088\142\000\194\251\105\095\161\212\252\215\077\246\048\193\163\020\141\068\115\028\023\194" ..
		-- tex:"0ebd7e8001588e00c2fb695fa1d4fcd7"; x:-11.060133; y:1128.645020; z:-37.777786
		"\213\096\177\025\006\252\134\254\248\171\162\138\202\048\059\087\228\085\213\066\102\154\093\068\092\096\021\194" ..
		-- tex:"d560b11906fc86fef8aba28aca303b57"; x:106.667763; y:886.412537; z:-37.344105
		"\119\233\013\231\066\074\222\191\208\172\246\048\157\097\033\172\016\058\115\066\012\129\093\068\090\096\021\194" ..
		-- tex:"77e90de7424adebfd0acf6309d6121ac"; x:60.806705; y:886.016418; z:-37.344097
		"\067\179\087\060\140\047\165\028\008\035\047\137\046\047\079\146\202\032\123\067\244\058\090\068\204\134\132\065" ..
		-- tex:"43b3573c8c2fa51c08232f892e2f4f92"; x:251.128098; y:872.921204; z:16.565821
		"\043\189\076\245\171\154\217\061\007\027\034\072\062\120\044\167\182\024\219\194\110\088\009\068\059\016\153\065" ..
		-- tex:"2bbd4cf5ab9ad93d071b22483e782ca7"; x:-109.548271; y:549.381775; z:19.132927
		"\206\205\102\060\164\142\029\078\024\051\089\183\219\239\145\091\012\035\129\065\229\203\093\068\211\036\255\065" ..
		-- tex:"cecd663ca48e1d4e183359b7dbef915b"; x:16.142115; y:887.185913; z:31.892982
		"\228\167\123\043\196\008\125\212\166\201\223\082\181\215\218\241\013\113\245\066\163\153\109\068\057\204\001\066" ..
		-- tex:"e4a77b2bc4087dd4a6c9df52b5d7daf1"; x:122.720810; y:950.400635; z:32.449440
		"\141\123\037\123\091\184\178\154\205\196\060\239\163\100\048\003\163\109\192\194\138\078\015\068\143\023\046\066" ..
		-- tex:"8d7b257b5bb8b29acdc43cefa3643003"; x:-96.214142; y:573.227234; z:43.523010
		"\187\009\229\091\017\058\131\055\172\184\173\238\176\235\100\119\222\234\040\067\019\122\105\068\101\200\064\066" ..
		-- tex:"bb09e55b113a8337acb8adeeb0eb6477"; x:168.917465; y:933.907471; z:48.195702
		"\146\199\021\164\215\235\007\005\233\141\123\026\202\011\012\144\114\003\113\066\127\152\093\068\073\133\105\066" ..
		-- tex:"92c715a4d7eb0705e98d7b1aca0b0c90"; x:60.253368; y:886.382813; z:58.380165
		"\082\132\205\199\065\233\244\154\108\006\199\224\197\201\118\080\118\232\143\065\184\141\018\068\143\042\116\066" ..
		-- tex:"5284cdc741e9f49a6c06c7e0c5c97650"; x:17.988508; y:586.214417; z:61.041565
		"\161\221\204\177\080\029\002\084\132\059\242\007\063\059\110\143\094\179\038\066\054\048\052\068\070\022\124\066" ..
		-- tex:"a1ddccb1501d0254843bf2073f3b6e8f"; x:41.675167; y:720.753357; z:63.021755
		"\113\193\245\212\041\066\241\234\184\034\214\082\097\225\036\018\159\219\228\194\021\195\248\067\104\213\157\066" ..
		-- tex:"71c1f5d42942f1eab822d65261e12412"; x:-114.428955; y:497.524109; z:78.916817
		"\005\086\112\083\194\076\137\131\035\001\191\146\038\101\143\153\056\150\095\194\099\045\000\068\122\178\168\066" ..
		-- tex:"05567053c24c89832301bf9226658f99"; x:-55.896702; y:512.709229; z:84.348595
		"\066\187\137\030\186\127\227\194\117\224\194\080\011\085\098\022\077\006\078\194\195\146\236\067\071\252\168\066" ..
		-- tex:"42bb891eba7fe3c275e0c2500b556216"; x:-51.506157; y:473.146606; z:84.492737
		"\151\002\058\079\154\218\157\114\141\198\254\224\082\208\158\125\086\031\039\195\096\218\203\067\088\121\176\066" ..
		-- tex:"97023a4f9ada9d728dc6fee052d09e7d"; x:-167.122421; y:407.706085; z:88.237007
		"\179\083\210\168\216\225\066\209\051\181\055\057\128\204\238\165\011\111\095\194\105\244\041\068\052\174\192\066" ..
		-- tex:"b353d2a8d8e142d133b5373980cceea5"; x:-55.858444; y:679.818970; z:96.340248
		"\137\183\102\094\065\208\119\105\052\041\134\077\008\232\095\101\203\236\177\194\110\218\042\068\230\127\194\066" ..
		-- tex:"89b7665e41d077693429864d08e85f65"; x:-88.962494; y:683.413025; z:97.249809
		"\013\033\203\238\031\077\120\144\050\255\240\015\023\117\205\122\007\106\046\195\197\230\222\067\089\104\198\066" ..
		-- tex:"0d21cbee1f4d789032fff00f1775cd7a"; x:-174.414185; y:445.802917; z:99.203812
		"\016\097\069\255\093\016\131\246\005\224\195\114\215\107\020\040\056\202\255\194\221\200\022\068\250\224\214\066" ..
		-- tex:"106145ff5d1083f605e0c372d76b1428"; x:-127.894966; y:603.138550; z:107.439415
		"\083\036\027\072\111\126\029\044\090\119\206\013\190\076\179\093\095\120\095\195\037\164\022\068\250\224\214\066" ..
		-- tex:"53241b486f7e1d2c5a77ce0dbe4cb35d"; x:-223.470215; y:602.564819; z:107.439415
		"\004\014\175\242\015\235\174\149\074\209\192\123\009\138\120\181\095\120\095\195\100\217\031\068\215\116\215\066" ..
		-- tex:"040eaff20febae954ad1c07b098a78b5"; x:-223.470215; y:639.396790; z:107.728210
		"\005\051\071\134\038\116\164\061\047\190\135\098\033\210\010\182\056\202\255\194\198\217\031\068\186\138\215\066" ..
		-- tex:"053347862674a43d2fbe876221d20ab6"; x:-127.894966; y:639.402771; z:107.770958
		"\250\142\169\064\141\054\126\103\208\050\201\226\139\227\217\001\197\028\090\195\072\064\254\067\244\145\215\066" ..
		-- tex:"fa8ea9408d367e67d032c9e28be3d901"; x:-218.112396; y:508.502228; z:107.785072
		"\205\226\059\102\114\222\219\011\233\162\044\184\139\176\121\023\217\081\068\067\068\199\027\068\179\218\225\066" ..
		-- tex:"cde23b6672dedb0be9a22cb88bb07917"; x:196.319733; y:623.113586; z:112.927155
		"\221\215\245\056\009\208\065\134\185\170\189\209\232\028\049\186\135\079\134\067\072\241\053\068\077\183\231\066" ..
		-- tex:"ddd7f53809d04186b9aabdd1e81c31ba"; x:268.621338; y:727.770081; z:115.858017
		"\201\058\192\061\112\130\205\163\035\058\170\190\206\105\046\021\039\182\073\195\069\059\042\068\251\244\240\066" ..
		-- tex:"c93ac03d7082cda3233aaabece692e15"; x:-201.711548; y:680.926147; z:120.478485
		"\010\215\135\050\060\162\079\195\179\016\171\208\070\197\223\017\096\204\176\067\065\165\018\068\059\013\255\066" ..
		-- tex:"0ad787323ca24fc3b310abd046c5df11"; x:353.596710; y:586.582153; z:127.525848
		"\094\128\038\228\114\135\011\084\105\159\236\221\016\236\161\061\105\063\158\067\193\167\028\068\090\122\000\067" ..
		-- tex:"5e8026e472870b54699fecdd10eca13d"; x:316.495422; y:626.621216; z:128.477951
		"\159\126\059\187\090\099\053\133\158\079\144\254\118\108\018\227\105\063\158\067\193\167\092\068\090\122\000\067" ..
		-- tex:"9f7e3bbb5a6335859e4f90fe766c12e3"; x:316.495422; y:882.621216; z:128.477951
		"\217\003\232\223\028\148\127\119\182\044\154\227\165\002\217\103\114\057\135\067\208\049\041\068\080\195\000\067" ..
		-- tex:"d903e8df1c947f77b62c9ae3a502d967"; x:270.448822; y:676.778381; z:128.762955
		"\068\110\028\061\120\043\216\037\033\089\029\060\078\135\063\085\010\009\119\195\056\227\027\068\043\222\002\067" ..
		-- tex:"446e1c3d782bd82521591d3c4e873f55"; x:-247.035324; y:623.550354; z:130.867859
		"\178\164\200\219\239\141\173\099\167\046\232\190\037\147\039\103\111\140\167\066\249\169\013\068\016\022\005\067" ..
		-- tex:"b2a4c8dbef8dad63a72ee8be25932767"; x:83.774292; y:566.655884; z:133.086197
		"\174\245\108\096\140\151\149\040\201\133\169\146\192\185\030\142\247\233\093\195\151\064\248\067\089\159\013\067" ..
		-- tex:"aef56c608c979528c985a992c0b91e8e"; x:-221.913940; y:496.504639; z:141.622467
		"\248\228\028\235\163\125\200\243\004\133\036\189\167\224\004\150\251\244\238\195\151\064\248\067\089\159\013\067" ..
		-- tex:"f8e41ceba37dc8f3048524bda7e00496"; x:-477.913940; y:496.504639; z:141.622467
		"\021\200\077\030\138\010\002\134\224\154\143\012\235\056\154\195\007\144\189\066\152\165\045\068\240\165\013\067" ..
		-- tex:"15c84d1e8a0a0286e09a8f0ceb389ac3"; x:94.781311; y:694.587463; z:141.648209
		"\143\234\133\065\218\242\190\141\247\157\084\101\233\252\144\240\246\134\233\195\018\204\004\068\209\184\025\067" ..
		-- tex:"8fea8541daf2be8df79d5465e9fc90f0"; x:-467.054413; y:531.188660; z:153.721954
		"\132\115\041\176\161\192\092\221\121\231\075\028\147\138\210\189\077\168\031\193\000\067\091\068\244\018\027\067" ..
		-- tex:"847329b0a1c05cdd79e74b1c938ad2bd"; x:-9.978590; y:877.046936; z:155.074051
		"\060\236\113\010\011\003\009\243\099\105\069\141\154\243\066\204\043\083\215\195\231\105\251\067\086\031\036\067" ..
		-- tex:"3cec710a0b0309f36369458d9af342cc"; x:-430.649780; y:502.827393; z:164.122421
		"\222\210\196\126\129\090\068\048\212\137\018\005\038\223\165\175\212\166\230\195\090\205\253\067\086\031\036\067" ..
		-- tex:"ded2c47e815a4430d489120526dfa5af"; x:-461.303375; y:507.604340; z:164.122421
		"\049\183\228\085\234\189\044\072\188\203\012\207\130\157\131\049\233\015\180\067\206\067\094\068\146\185\046\067" ..
		-- tex:"31b7e455eabd2c48bccb0ccf829d8331"; x:360.124329; y:889.059509; z:174.724899
		"\247\188\243\069\142\067\011\214\168\131\150\174\020\017\160\193\122\015\097\195\238\162\231\067\212\055\049\067" ..
		-- tex:"f7bcf3458e430bd6a88396ae1411a0c1"; x:-225.060471; y:463.272919; z:177.218094
		"\170\023\038\214\178\139\152\218\180\054\166\076\081\152\208\101\076\021\176\194\040\164\024\068\149\123\053\067" ..
		-- tex:"aa1726d6b28b98dab436a64c5198d065"; x:-88.041603; y:610.565002; z:181.482758
		"\020\133\211\098\155\211\248\128\241\039\142\048\247\093\034\010\194\116\176\195\078\079\228\067\059\082\054\067" ..
		-- tex:"1485d3629bd3f880f1278e30f75d220a"; x:-352.912201; y:456.619598; z:182.321228
		"\197\076\119\188\100\124\011\164\031\004\105\044\179\158\173\125\077\196\130\195\046\115\252\067\199\208\084\067" ..
		-- tex:"c54c77bc647c0ba41f04692cb39ead7d"; x:-261.533630; y:504.899872; z:212.815552
		"\103\143\203\154\072\136\240\153\181\138\249\208\049\023\061\034\000\180\130\195\111\141\024\068\199\208\084\067" ..
		-- tex:"678fcb9a4888f099b58af9d031173d22"; x:-261.406281; y:610.209961; z:212.815552
		"\060\249\249\015\176\040\252\004\114\210\239\240\073\217\140\235\028\199\172\195\222\002\239\067\248\079\085\067" ..
		-- tex:"3cf9f90fb028fc0472d2eff049d98ceb"; x:-345.555573; y:478.022430; z:213.312393
		"\119\040\188\006\022\007\020\250\025\040\150\078\110\189\192\054\015\058\149\195\088\040\122\068\158\163\085\067" ..
		-- tex:"7728bc06160714fa1928964e6ebdc036"; x:-298.453613; y:1000.630432; z:213.639145
		"\250\254\012\214\246\145\247\068\239\109\187\026\096\120\251\195\127\208\041\194\088\040\122\068\158\163\085\067" ..
		-- tex:"fafe0cd6f691f744ef6dbb1a6078fbc3"; x:-42.453613; y:1000.630432; z:213.639145
		"\234\010\153\149\233\109\202\041\137\139\165\157\133\008\025\194\191\128\089\195\170\091\074\068\255\186\091\067" ..
		-- tex:"ea0a9995e96dca29898ba59d850819c2"; x:-217.502930; y:809.432312; z:219.730469
		"\207\235\144\203\014\147\149\086\016\217\165\226\016\045\165\008\157\085\225\195\050\209\051\068\148\227\092\067" ..
		-- tex:"cfeb90cb0e93955610d9a5e2102da508"; x:-450.668884; y:719.268738; z:220.888992
		"\146\109\228\198\022\197\190\026\035\196\193\069\119\105\116\112\006\203\169\194\104\234\049\068\028\051\093\067" ..
		-- tex:"926de4c616c5be1a23c4c14577697470"; x:-84.896538; y:711.662659; z:221.199661
		"\205\115\062\225\003\166\105\104\017\107\231\118\072\134\001\157\234\163\026\195\197\163\106\068\019\185\093\067" ..
		-- tex:"cd733ee103a66968116be7764886019d"; x:-154.640305; y:938.558960; z:221.722961
		"\210\152\167\071\070\132\104\109\007\053\179\064\124\151\066\042\093\111\068\195\249\246\089\068\019\185\093\067" ..
		-- tex:"d298a7474684686d0735b3407c97422a"; x:-196.435028; y:871.859009; z:221.722961
		"\007\156\028\053\079\058\173\188\196\012\184\091\080\239\084\126\064\108\068\195\055\207\062\068\019\185\093\067" ..
		-- tex:"079c1c354f3aadbcc40cb85b50ef547e"; x:-196.422867; y:763.237793; z:221.722961
		"\007\052\191\005\235\009\026\220\013\178\252\005\142\121\061\010\063\228\216\194\175\183\091\068\080\199\093\067" ..
		-- tex:"0734bf05eb091adc0db2fc058e793d0a"; x:-108.445801; y:878.870117; z:221.778580
		"\194\071\043\204\202\082\116\147\031\155\169\154\234\169\161\010\233\156\177\194\133\223\022\068\058\205\093\067" ..
		-- tex:"c2472bccca5274931f9ba99aeaa9a10a"; x:-88.806473; y:603.492554; z:221.801682
		"\196\188\038\107\235\212\035\064\058\003\087\236\209\108\081\087\035\186\177\194\000\117\247\067\182\212\093\067" ..
		-- tex:"c4bc266bebd423403a0357ecd16c5157"; x:-88.863556; y:494.914093; z:221.830917
		"\033\242\012\192\064\202\035\194\252\225\255\125\211\100\120\062\178\194\219\195\079\091\105\068\061\006\104\067" ..
		-- tex:"21f20cc040ca23c2fce1ff7dd364783e"; x:-439.521088; y:933.426758; z:232.024384
		"\249\046\039\143\192\012\220\149\189\048\220\063\062\055\159\213\160\192\194\195\177\007\052\068\227\112\104\067" ..
		-- tex:"f92e278fc00cdc95bd30dc3f3e379fd5"; x:-389.504913; y:720.120239; z:232.440979
		"\163\049\106\136\211\166\081\091\164\207\100\070\004\179\056\239\093\165\026\195\178\249\051\068\227\112\104\067" ..
		-- tex:"a3316a88d3a6515ba4cf644604b338ef"; x:-154.645966; y:719.901550; z:232.440979
		"\218\231\151\106\043\249\099\161\209\087\199\230\090\212\213\026\021\017\089\195\110\131\101\068\230\112\104\067" ..
		-- tex:"dae7976a2bf963a1d157c7e65ad4d51a"; x:-217.066742; y:918.053650; z:232.441025
		"\244\131\110\147\104\183\073\076\196\218\245\131\216\147\057\149\149\018\089\195\099\152\047\068\234\109\105\067" ..
		-- tex:"f4836e9368b7494cc4daf583d8933995"; x:-217.072601; y:702.381104; z:233.429367
		"\203\150\038\003\041\119\202\150\249\231\080\089\218\057\054\174\013\077\123\195\230\093\052\068\127\141\105\067" ..
		-- tex:"cb9626032977ca96f9e75059da3936ae"; x:-251.300995; y:721.467224; z:233.552734
		"\199\088\161\130\178\195\008\232\162\231\204\171\023\194\039\136\141\075\123\195\067\169\106\068\022\161\105\067" ..
		-- tex:"c758a182b2c308e8a2e7ccab17c22788"; x:-251.295135; y:938.644775; z:233.629257
		"\009\074\071\212\023\100\031\236\220\038\049\167\056\151\061\241\234\050\039\196\070\245\080\068\198\183\120\067",
		-- tex:"094a47d417641fecdc2631a738973df1"; x:-668.795593; y:835.832458; z:248.717880
	["Blackwing Lair"] = 
		"\234\068\174\004\069\183\171\070\072\180\093\229\090\122\137\201\208\171\193\195\050\209\051\068\148\227\092\067" ..
		-- tex:"ea44ae0445b7ab4648b45de55a7a89c9"; x:-387.342316; y:719.268738; z:220.888992
		"\112\163\252\154\008\155\232\198\165\186\062\048\224\027\039\113\234\163\026\195\197\163\106\068\019\185\093\067" ..
		-- tex:"70a3fc9a089be8c6a5ba3e30e01b2771"; x:-154.640305; y:938.558960; z:221.722961
		"\065\249\138\253\028\206\001\241\104\018\049\047\213\065\138\006\063\228\216\194\175\183\091\068\080\199\093\067" ..
		-- tex:"41f98afd1cce01f16812312fd5418a06"; x:-108.445801; y:878.870117; z:221.778580
		"\016\016\146\171\215\214\242\220\196\086\002\204\075\231\219\106\099\205\040\196\230\120\149\068\079\104\104\067" ..
		-- tex:"101092abd7d6f2dcc45602cc4be7db6a"; x:-675.209229; y:1195.778198; z:232.407471
		"\118\199\107\029\179\200\174\065\068\247\132\210\156\079\087\081\199\154\209\195\230\120\149\068\079\104\104\067" ..
		-- tex:"76c76b1db3c8ae4144f784d29c4f5751"; x:-419.209229; y:1195.778198; z:232.407471
		"\255\106\085\192\065\095\242\048\140\097\010\069\059\242\182\180\021\017\089\195\110\131\101\068\230\112\104\067" ..
		-- tex:"ff6a55c0415ff2308c610a453bf2b6b4"; x:-217.066742; y:918.053650; z:232.441025
		"\174\171\223\109\127\174\008\130\214\251\020\000\227\193\054\023\178\194\219\195\165\215\105\068\244\143\105\067" ..
		-- tex:"aeabdf6d7fae0882d6fb1400e3c13617"; x:-439.521088; y:935.369507; z:233.562332
		"\054\063\034\144\042\026\036\109\145\121\150\147\118\125\073\205\141\075\123\195\067\169\106\068\022\161\105\067" ..
		-- tex:"363f22902a1a246d91799693767d49cd"; x:-251.295135; y:938.644775; z:233.629257
		"\171\092\162\139\099\099\183\013\141\174\237\174\238\217\247\246\234\050\039\196\070\245\080\068\139\171\126\067" ..
		-- tex:"ab5ca28b6363b70d8daeedaeeed9f7f6"; x:-668.795593; y:835.832458; z:254.670105
		"\048\169\059\207\015\057\229\137\050\012\172\029\167\031\235\044\101\041\044\196\005\255\106\068\106\167\128\067" ..
		-- tex:"30a93bcf0f39e589320cac1da71feb2c"; x:-688.646851; y:939.984741; z:257.307953
		"\206\106\248\105\144\038\182\076\016\143\009\102\050\092\006\246\218\114\087\196\242\157\098\068\217\177\128\067" ..
		-- tex:"ce6af8699026b64c108f0966325c06f6"; x:-861.794617; y:906.467957; z:257.389465
		"\134\253\125\226\240\001\049\040\048\201\176\201\224\100\228\078\190\165\090\196\255\179\045\068\209\171\139\067" ..
		-- tex:"86fd7de2f001312830c9b0c9e064e44e"; x:-874.589783; y:694.812500; z:279.342346
		"\107\148\022\143\056\130\183\173\153\216\073\029\117\214\225\065\213\156\056\196\190\027\034\068\065\139\148\067" ..
		-- tex:"6b94168f3882b7ad99d8491d75d6e141"; x:-738.450562; y:648.433533; z:297.087952
		"\022\208\103\092\020\032\029\128\027\153\089\031\138\244\203\001\086\074\038\196\182\110\089\068\208\173\159\067" ..
		-- tex:"16d0675c14201d801b99591f8af4cb01"; x:-665.161560; y:869.729919; z:319.357941
		"\077\026\237\162\196\075\083\085\216\182\042\227\249\190\076\023\105\178\038\196\067\228\044\068\040\037\160\067" ..
		-- tex:"4d1aeda2c44b5355d8b62ae3f9be4c17"; x:-666.787720; y:691.566650; z:320.290314
		"\023\015\218\240\116\086\185\175\036\012\130\038\238\003\149\056\211\100\205\195\067\228\108\068\040\037\160\067" ..
		-- tex:"170fdaf07456b9af240c8226ee039538"; x:-410.787720; y:947.566650; z:320.290314
		"\229\104\148\071\190\211\022\125\085\020\114\046\138\193\223\027\211\100\205\195\067\228\044\068\040\037\160\067" ..
		-- tex:"e5689447bed3167d5514722e8ac1df1b"; x:-410.787720; y:691.566650; z:320.290314
		"\118\209\162\000\121\065\004\109\031\234\058\145\251\062\240\208\105\178\038\196\067\228\108\068\040\037\160\067" ..
		-- tex:"76d1a2007941046d1fea3a91fb3ef0d0"; x:-666.787720; y:947.566650; z:320.290314
		"\127\231\213\039\111\202\001\225\072\028\231\234\072\082\082\132\224\227\091\196\094\171\091\068\093\237\163\067" ..
		-- tex:"7fe7d5276fca01e1481ce7ea48525284"; x:-879.560608; y:878.677673; z:327.854431
		"\217\195\011\057\142\142\192\105\245\177\034\172\197\112\240\024\143\042\098\196\082\163\072\068\205\103\169\067" ..
		-- tex:"d9c30b398e8ec069f5b122acc570f018"; x:-904.665039; y:802.551941; z:338.810974
		"\049\154\211\195\204\115\186\189\041\060\185\247\214\011\237\071\152\017\130\196\152\229\063\068\187\010\185\067" ..
		-- tex:"319ad3c3cc73babd293cb9f7d60bed47"; x:-1040.549927; y:767.587463; z:370.083862
		"\049\165\152\204\092\170\160\179\032\079\118\049\041\252\102\015\152\017\130\196\152\229\127\068\187\010\185\067" ..
		-- tex:"31a598cc5caaa0b3204f763129fc660f"; x:-1040.549927; y:1023.587463; z:370.083862
		"\133\108\012\013\100\184\146\127\023\209\003\225\224\083\174\093\095\221\135\196\085\181\129\068\100\031\185\067" ..
		-- tex:"856c0c0d64b8927f17d103e1e053ae5d"; x:-1086.917969; y:1037.666748; z:370.245270
		"\222\090\033\128\074\000\113\129\225\088\125\126\159\247\173\017\191\186\079\196\085\181\129\068\100\031\185\067" ..
		-- tex:"de5a21804a007181e1587d7e9ff7ad11"; x:-830.917969; y:1037.666748; z:370.245270
		"\075\193\043\124\150\188\042\034\236\027\191\150\153\229\185\143\097\035\018\196\114\100\141\068\130\236\188\067" ..
		-- tex:"4bc12b7c96bc2a22ec1bbf9699e5b98f"; x:-584.552856; y:1131.139038; z:377.847748
		"\135\167\215\235\016\206\145\063\019\255\022\097\031\149\148\216\012\136\199\195\114\100\141\068\131\236\188\067" ..
		-- tex:"87a7d7eb10ce913f13ff16611f9594d8"; x:-399.062897; y:1131.139038; z:377.847778
		"\002\067\166\239\215\111\046\241\111\205\010\016\174\153\226\077\050\170\077\196\022\134\112\068\200\169\196\067" ..
		-- tex:"0243a6efd76f2ef16fcd0a10ae99e24d"; x:-822.659363; y:962.095154; z:393.326447
		"\189\087\099\218\024\177\024\111\089\186\141\037\030\077\131\068\063\191\057\196\133\137\149\068\158\178\196\067" ..
		-- tex:"bd5763da18b1186f59ba8d251e4d8344"; x:-742.988281; y:1196.297607; z:393.395477
		"\023\115\001\168\156\232\070\174\021\082\090\018\006\038\170\183\197\051\039\196\143\076\152\068\159\178\196\067",
		-- tex:"177301a89ce846ae15525a120626aab7"; x:-668.808960; y:1218.392578; z:393.395508
	["Cathedral"] = 
		"\103\093\080\128\113\160\232\013\181\030\218\231\047\197\040\190\137\193\131\196\255\170\235\195\203\015\141\191" ..
		-- tex:"675d508071a0e80db51edae72fc528be"; x:-1054.048096; y:-471.335938; z:-1.102045
		"\033\156\062\233\212\038\248\113\153\133\039\036\019\228\187\113\137\193\131\196\255\085\087\195\203\015\141\191" ..
		-- tex:"219c3ee9d426f8719985272413e4bb71"; x:-1054.048096; y:-215.335938; z:-1.102045
		"\231\039\037\213\036\008\046\027\013\066\081\244\073\189\142\162\019\131\071\196\255\170\235\195\203\015\141\191" ..
		-- tex:"e72725d524082e1b0d4251f449bd8ea2"; x:-798.048096; y:-471.335938; z:-1.102045
		"\039\032\044\240\127\170\209\029\184\184\217\211\020\209\072\249\019\131\071\196\255\085\087\195\203\015\141\191" ..
		-- tex:"27202cf07faad11db8b8d9d314d148f9"; x:-798.048096; y:-215.335938; z:-1.102045
		"\089\039\187\101\084\019\034\169\082\060\206\130\010\219\246\128\019\131\007\196\255\170\235\195\203\015\141\191" ..
		-- tex:"5927bb65541322a9523cce820adbf680"; x:-542.048096; y:-471.335938; z:-1.102045
		"\067\115\128\001\224\012\061\219\158\099\202\093\223\254\046\062\019\131\007\196\255\085\087\195\203\015\141\191" ..
		-- tex:"43738001e00c3ddb9e63ca5ddffe2e3e"; x:-542.048096; y:-215.335938; z:-1.102045
		"\151\168\089\040\039\050\054\030\118\093\177\158\162\034\172\172\155\246\154\195\195\097\060\195\033\220\026\065" ..
		-- tex:"97a859282732361e765db19ea222acac"; x:-309.926636; y:-188.381897; z:9.678743
		"\234\118\216\198\206\077\028\212\067\093\185\172\131\030\214\232\077\123\013\196\225\048\222\195\033\220\026\065" ..
		-- tex:"ea76d8c6ce4d1cd4435db9ac831ed6e8"; x:-565.926636; y:-444.381897; z:9.678743
		"\138\017\154\082\039\205\013\150\158\159\128\079\139\225\238\198\077\123\013\196\195\097\060\195\033\220\026\065" ..
		-- tex:"8a119a5227cd0d969e9f804f8be1eec6"; x:-565.926636; y:-188.381897; z:9.678743
		"\003\224\236\255\191\017\083\033\090\237\050\201\215\190\085\072\155\246\154\195\225\048\222\195\033\220\026\065" ..
		-- tex:"03e0ecffbf1153215aed32c9d7be5548"; x:-309.926636; y:-444.381897; z:9.678743
		"\250\240\108\183\159\088\118\043\195\002\136\149\082\046\247\083\164\095\157\195\167\229\102\194\167\110\207\065" ..
		-- tex:"faf06cb79f58762bc3028895522ef753"; x:-314.747223; y:-57.724274; z:25.929031
		"\100\234\091\094\148\187\058\060\019\201\110\174\042\099\115\152\019\159\174\195\177\129\140\194\119\133\015\066" ..
		-- tex:"64ea5b5e94bb3a3c13c96eae2a637398"; x:-349.242798; y:-70.253311; z:35.880341
		"\057\041\198\239\249\194\193\243\006\047\220\189\010\134\073\027\159\179\174\195\153\055\034\195\119\133\015\066" ..
		-- tex:"3929c6eff9c2c1f3062fdcbd0a86491b"; x:-349.403320; y:-162.217194; z:35.880341
		"\115\205\158\210\141\163\067\096\011\154\053\249\111\144\008\159\099\159\174\195\126\073\003\195\119\133\015\066" ..
		-- tex:"73cd9ed28da343600b9a35f96f90089f"; x:-349.245239; y:-131.287094; z:35.880341
		"\001\107\082\052\044\233\130\237\234\018\051\146\074\110\051\247\099\159\174\195\061\230\201\194\119\133\015\066" ..
		-- tex:"016b52342ce982edea1233924a6e33f7"; x:-349.245239; y:-100.949692; z:35.880341
		"\178\129\000\222\175\206\227\193\134\034\252\015\146\012\133\092\088\113\173\195\204\128\210\065\099\136\015\066" ..
		-- tex:"b28100deafcee3c18622fc0f920c855c"; x:-346.885529; y:26.312891; z:35.883194
		"\055\152\119\203\214\086\005\124\042\169\228\047\081\248\223\026\137\238\179\195\045\152\109\195\158\172\015\066" ..
		-- tex:"379877cbd656057c2aa9e42f51f8df1a"; x:-359.863586; y:-237.594452; z:35.918575
		"\216\198\241\178\112\083\239\118\226\126\226\132\135\165\147\218\159\179\174\195\155\213\062\195\098\211\015\066" ..
		-- tex:"d8c6f1b27053ef76e27ee28487a593da"; x:-349.403320; y:-190.834412; z:35.956432
		"\035\212\100\215\191\239\149\057\211\143\036\223\106\239\152\109\019\218\146\195\007\163\167\194\142\173\019\066" ..
		-- tex:"23d464d7bfef9539d38f24df6aef986d"; x:-293.703735; y:-83.818420; z:36.919491
		"\147\090\138\156\241\106\119\255\239\038\032\175\199\185\248\241\018\004\147\195\096\243\090\066\015\111\020\066" ..
		-- tex:"935a8a9cf16a77ffef2620afc7b9f8f1"; x:-294.031830; y:54.737675; z:37.108459
		"\077\159\198\118\215\216\189\184\225\083\152\047\111\177\070\142\166\095\157\195\209\115\156\065\203\037\021\066" ..
		-- tex:"4d9fc676d7d8bdb8e153982f6fb1468e"; x:-314.747284; y:19.556553; z:37.286911
		"\214\179\189\066\123\212\196\147\050\064\241\048\087\205\179\201\059\137\140\195\097\228\077\194\029\049\021\066" ..
		-- tex:"d6b3bd427bd4c4933240f13057cdb3c9"; x:-281.072144; y:-51.473030; z:37.297966
		"\122\183\254\176\044\232\216\234\081\212\129\208\062\072\032\048\150\233\010\195\114\225\010\194\017\050\021\066" ..
		-- tex:"7ab7feb02ce8d8ea51d481d03e482030"; x:-138.912460; y:-34.720165; z:37.298897
		"\185\184\249\177\177\139\250\237\124\185\239\083\112\090\195\188\163\233\010\195\201\122\072\065\017\050\021\066" ..
		-- tex:"b9b8f9b1b18bfaed7cb9ef53705ac3bc"; x:-138.912659; y:12.529978; z:37.298897
		"\246\218\065\007\217\220\113\079\133\228\129\087\177\204\094\219\000\112\128\196\177\164\109\195\222\130\101\066" ..
		-- tex:"f6da4107d9dc714f85e48157b1cc5edb"; x:-1027.500122; y:-237.643341; z:57.377804
		"\204\184\164\079\048\055\141\213\251\033\140\020\151\142\031\046\130\033\106\196\219\140\168\194\089\248\113\066" ..
		-- tex:"ccb8a44f30378dd5fb218c14978e1f2e"; x:-936.523621; y:-84.275116; z:60.492531
		"\171\107\076\243\094\041\210\250\172\040\147\254\100\098\024\010\130\033\106\196\054\035\170\195\089\248\113\066" ..
		-- tex:"ab6b4cf35e29d2faac2893fe6462180a"; x:-936.523621; y:-340.275116; z:60.492531
		"\013\149\229\254\058\071\152\021\154\006\137\119\061\122\235\227\193\199\104\196\019\032\166\195\102\055\114\066" ..
		-- tex:"0d95e5fe3a4798159a0689773d7aebe3"; x:-931.121216; y:-332.250610; z:60.554104
		"\199\042\082\180\230\073\131\026\012\045\162\175\120\017\255\026\047\200\104\196\126\225\147\195\102\055\114\066" ..
		-- tex:"c72a52b4e649831a0c2da2af7811ff1a"; x:-931.127930; y:-295.761688; z:60.554104
		"\096\079\193\066\035\251\186\186\252\170\139\044\079\143\085\105\193\199\104\196\006\157\255\194\006\057\114\066" ..
		-- tex:"604fc14223fbbabafcaa8b2c4f8f5569"; x:-931.121216; y:-127.806694; z:60.555691
		"\026\234\038\004\156\253\227\188\159\044\156\227\217\112\021\161\193\199\104\196\172\244\202\194\013\057\114\066" ..
		-- tex:"1aea26049cfde3bc9f2c9ce3d97015a1"; x:-931.121216; y:-101.477882; z:60.555717
		"\081\102\068\132\155\037\123\152\020\062\036\088\185\059\179\165\114\113\108\196\109\048\088\195\095\142\127\066" ..
		-- tex:"516644849b257b98143e2458b93bb3a5"; x:-945.772644; y:-216.189178; z:63.889038
		"\163\231\232\218\154\176\025\086\215\234\043\012\149\215\245\147\180\228\129\196\225\189\121\195\013\206\173\066",
		-- tex:"a3e7e8da9ab01956d7ea2b0c95d7f593"; x:-1039.147095; y:-249.741730; z:86.902451
	["Dire Maul"] = 
		"\145\155\167\046\002\087\254\180\110\063\196\209\139\218\207\019\093\149\130\067\099\203\153\196\170\250\111\195" ..
		-- tex:"919ba72e0257feb46e3fc4d18bdacf13"; x:261.166931; y:-1230.355957; z:-239.979172
		"\017\052\001\005\089\092\140\020\229\104\194\242\167\038\017\079\174\074\001\068\199\150\051\196\170\250\111\195" ..
		-- tex:"11340105595c8c14e568c2f2a726114f"; x:517.166931; y:-718.355957; z:-239.979172
		"\098\200\064\048\213\134\039\021\027\196\203\107\165\156\202\150\174\074\065\068\199\150\115\196\170\250\111\195" ..
		-- tex:"62c84030d58627151bc4cb6ba59cca96"; x:773.166931; y:-974.355957; z:-239.979172
		"\061\245\235\160\073\140\036\197\162\250\215\163\144\185\137\068\174\074\001\068\199\150\115\196\170\250\111\195" ..
		-- tex:"3df5eba0498c24c5a2fad7a390b98944"; x:517.166931; y:-974.355957; z:-239.979172
		"\067\097\252\011\245\037\250\041\097\206\211\232\032\023\251\061\093\149\130\067\199\150\115\196\170\250\111\195" ..
		-- tex:"4361fc0bf525fa2961ced3e82017fb3d"; x:261.166931; y:-974.355957; z:-239.979172
		"\159\177\149\158\156\014\000\161\086\011\026\138\166\162\061\132\093\149\130\067\199\150\051\196\170\250\111\195" ..
		-- tex:"9fb1959e9c0e00a1560b1a8aa6a23d84"; x:261.166931; y:-718.355957; z:-239.979172
		"\069\156\133\066\180\222\127\138\048\100\038\114\160\121\255\204\174\074\001\068\099\203\153\196\170\250\111\195" ..
		-- tex:"459c8542b4de7f8a30642672a079ffcc"; x:517.166931; y:-1230.355957; z:-239.979172
		"\215\031\229\157\040\075\083\197\026\002\172\020\023\087\058\020\236\017\245\067\235\058\066\196\124\113\106\195" ..
		-- tex:"d71fe59d284b53c51a02ac1417573a14"; x:490.140045; y:-776.920654; z:-234.443314
		"\127\087\086\197\238\112\009\059\252\072\169\216\136\022\066\100\141\236\004\068\081\028\049\196\093\128\078\195" ..
		-- tex:"7f5756c5ee70093bfc48a9d888164264"; x:531.696167; y:-708.442505; z:-206.501434
		"\040\127\152\164\186\237\200\006\131\214\063\207\200\173\138\032\056\215\239\067\105\212\026\196\191\187\042\195" ..
		-- tex:"287f98a4baedc80683d63fcfc8ad8a20"; x:479.681427; y:-619.318970; z:-170.733398
		"\155\060\122\233\178\163\240\162\171\000\188\182\078\034\001\188\012\020\120\195\015\095\109\196\165\146\244\194" ..
		-- tex:"9b3c7ae9b2a3f0a2ab00bcb64e2201bc"; x:-248.078323; y:-949.485352; z:-122.286423
		"\238\247\033\136\209\159\238\215\001\099\216\167\052\101\208\160\095\126\253\064\015\095\109\196\165\146\244\194" ..
		-- tex:"eef72188d19feed70163d8a73465d0a0"; x:7.921677; y:-949.485352; z:-122.286423
		"\058\151\227\198\011\100\064\014\158\239\035\169\018\246\111\042\187\006\130\194\205\195\058\196\001\161\237\194" ..
		-- tex:"3a97e3c60b64400e9eef23a912f66f2a"; x:-65.013153; y:-747.059448; z:-118.814468
		"\210\148\160\110\158\014\153\189\103\194\255\113\154\246\102\106\187\006\130\194\155\135\245\195\001\161\237\194" ..
		-- tex:"d294a06e9e0e99bd67c2ff719af6666a"; x:-65.013153; y:-491.059448; z:-118.814468
		"\120\014\213\120\116\169\027\062\066\103\227\242\056\149\030\165\161\252\062\067\205\195\058\196\001\161\237\194" ..
		-- tex:"780ed57874a91b3e4267e3f238951ea5"; x:190.986847; y:-747.059448; z:-118.814468
		"\015\075\152\247\253\137\237\206\235\084\112\132\226\158\006\068\161\252\062\067\155\135\245\195\001\161\237\194" ..
		-- tex:"0f4b98f7fd89edceeb547084e29e0644"; x:190.986847; y:-491.059448; z:-118.814468
		"\251\130\219\062\211\073\175\152\240\153\135\152\230\186\012\045\174\129\160\195\205\195\058\196\001\161\237\194" ..
		-- tex:"fb82db3ed349af98f0998798e6ba0c2d"; x:-321.013153; y:-747.059448; z:-118.814468
		"\132\240\145\024\094\008\019\070\008\137\129\191\093\133\146\040\174\129\160\195\155\135\245\195\001\161\237\194" ..
		-- tex:"84f091185e081346088981bf5d859228"; x:-321.013153; y:-491.059448; z:-118.814468
		"\179\083\150\089\052\175\027\004\112\172\107\096\069\093\086\090\050\134\160\195\151\108\129\196\209\071\234\194" ..
		-- tex:"b353965934af1b0470ac6b60455d565a"; x:-321.048431; y:-1035.393555; z:-117.140274
		"\098\179\024\001\042\188\008\119\184\112\249\109\247\251\145\250\104\130\151\195\130\239\077\196\197\105\230\194" ..
		-- tex:"62b318012abc0877b870f96df7fb91fa"; x:-303.018829; y:-823.742371; z:-115.206589
		"\194\066\145\205\212\248\191\222\155\169\240\210\236\175\117\076\080\161\083\066\058\161\120\196\234\139\228\194" ..
		-- tex:"c24291cdd4f8bfde9ba9f0d2ecaf754c"; x:52.907536; y:-994.519226; z:-114.273277
		"\173\243\066\176\132\011\102\091\045\052\121\075\047\139\200\183\167\142\132\195\000\141\075\196\076\056\228\194" ..
		-- tex:"adf342b0840b665b2d34794b2f8bc8b7"; x:-265.114502; y:-814.203186; z:-114.109962
		"\234\093\060\036\181\199\170\151\186\043\040\098\073\255\118\213\062\242\147\195\213\004\062\196\047\045\228\194" ..
		-- tex:"ea5d3c24b5c7aa97ba2b286249ff76d5"; x:-295.892548; y:-760.075562; z:-114.088257
		"\047\086\025\020\078\199\218\082\037\242\048\243\039\142\003\032\097\022\234\067\036\133\025\196\083\128\226\194" ..
		-- tex:"2f5619144ec7da5225f230f3278e0320"; x:468.174866; y:-614.080383; z:-113.250641
		"\054\010\161\034\047\064\232\035\078\200\192\038\202\209\211\062\080\061\183\067\106\026\014\196\083\128\226\194" ..
		-- tex:"360aa1222f40e8234ec8c026cad1d33e"; x:366.479034; y:-568.412781; z:-113.250641
		"\242\156\247\242\127\104\068\117\196\005\174\028\092\034\092\039\040\241\130\067\219\025\014\196\254\099\226\194" ..
		-- tex:"f29cf7f27f684475c405ae1c5c225c27"; x:261.884064; y:-568.404053; z:-113.195305
		"\046\025\077\214\178\116\088\174\152\030\188\197\069\127\142\224\167\111\000\068\252\072\036\196\245\086\226\194" ..
		-- tex:"2e194dd6b27458ae981ebcc5457f8ee0"; x:513.744629; y:-657.140442; z:-113.169846
		"\186\126\140\163\244\105\056\028\055\112\145\060\038\053\227\156\091\025\194\067\019\011\007\196\070\245\201\194" ..
		-- tex:"ba7e8ca3f469381c3770913c2635e39c"; x:388.198120; y:-540.173096; z:-100.979057
		"\111\187\133\150\074\245\170\066\114\111\028\047\014\085\117\005\041\107\082\067\227\084\140\068\024\000\194\194" ..
		-- tex:"6fbb85964af5aa42726f1c2f0e557505"; x:210.418610; y:1122.652771; z:-97.000191
		"\075\075\243\064\060\249\246\020\254\193\154\116\175\075\224\006\041\107\082\067\198\169\088\068\024\000\194\194" ..
		-- tex:"4b4bf3403cf9f614fec19a74af4be006"; x:210.418610; y:866.652771; z:-97.000191
		"\160\252\238\024\001\237\212\070\125\103\173\023\091\186\205\026\004\035\163\067\211\131\078\068\211\012\191\194" ..
		-- tex:"a0fcee1801edd4467d67ad175bbacd1a"; x:326.273590; y:826.059814; z:-95.525055
		"\029\224\058\010\069\177\073\075\024\129\121\020\253\203\187\253\224\153\252\067\014\034\055\068\207\012\191\194" ..
		-- tex:"1de03a0a45b1494b18817914fdcbbbfd"; x:505.202179; y:732.532166; z:-95.525024
		"\035\027\029\090\083\086\145\242\091\008\008\183\241\139\105\192\220\082\173\067\019\228\083\068\080\241\187\194" ..
		-- tex:"231b1d5a535691f25b0808b7f18b69c0"; x:346.647369; y:847.563721; z:-93.971321
		"\072\186\049\088\035\224\203\130\022\044\239\105\154\035\026\212\211\053\013\068\139\002\224\195\166\135\186\194" ..
		-- tex:"48ba315823e0cb82162cef699a231ad4"; x:564.841034; y:-448.019897; z:-93.264946
		"\009\186\184\164\177\159\024\179\105\236\169\018\108\229\245\171\166\107\154\067\069\001\048\196\166\135\186\194" ..
		-- tex:"09bab8a4b19f18b369eca9126ce5f5ab"; x:308.841034; y:-704.019897; z:-93.264946
		"\048\209\126\253\158\144\071\200\026\132\042\187\215\229\215\071\211\053\013\068\069\001\048\196\166\135\186\194" ..
		-- tex:"30d17efd9e9047c81a842abbd7e5d747"; x:564.841034; y:-704.019897; z:-93.264946
		"\108\160\159\078\239\101\118\137\149\214\069\162\016\076\169\171\211\053\013\068\069\001\112\196\166\135\186\194" ..
		-- tex:"6ca09f4eef65768995d645a2104ca9ab"; x:564.841034; y:-960.019897; z:-93.264946
		"\185\143\194\170\103\030\209\138\035\175\241\112\000\164\137\001\211\053\077\068\069\001\112\196\166\135\186\194" ..
		-- tex:"b98fc2aa671ed18a23aff17000a48901"; x:820.841034; y:-960.019897; z:-93.264946
		"\138\217\097\053\033\248\001\159\144\105\201\101\201\008\046\203\166\107\154\067\162\000\184\196\166\135\186\194" ..
		-- tex:"8ad9613521f8019f9069c965c9082ecb"; x:308.841034; y:-1472.019897; z:-93.264946
		"\040\218\088\026\064\129\070\255\074\140\060\128\061\175\006\102\088\148\229\195\139\002\224\195\166\135\186\194" ..
		-- tex:"28da581a408146ff4a8c3c803daf0666"; x:-459.158966; y:-448.019897; z:-93.264946
		"\101\075\105\102\129\245\111\183\140\193\238\123\072\166\084\022\088\148\229\195\069\001\112\196\166\135\186\194" ..
		-- tex:"654b696681f56fb78cc1ee7b48a65416"; x:-459.158966; y:-960.019897; z:-93.264946
		"\115\171\100\151\144\017\176\044\070\059\017\202\095\014\007\194\177\040\075\195\069\001\112\196\166\135\186\194" ..
		-- tex:"73ab64979011b02c463b11ca5f0e07c2"; x:-203.158966; y:-960.019897; z:-93.264946
		"\086\026\139\173\194\066\224\166\132\209\049\194\068\159\041\082\041\175\022\068\029\032\017\068\037\125\171\194" ..
		-- tex:"561a8badc242e0a684d131c2449f2952"; x:602.736938; y:580.501831; z:-85.744431
		"\175\239\190\209\113\122\042\185\024\002\041\190\136\003\124\231\035\227\239\194\201\253\066\196\232\221\164\194" ..
		-- tex:"afefbed1717a2ab9180229be88037ce7"; x:-119.943634; y:-779.965454; z:-82.433418
		"\251\135\090\145\032\101\222\174\100\175\122\026\206\195\040\231\200\248\187\195\201\253\066\196\232\221\164\194" ..
		-- tex:"fb875a912065deae64af7a1acec328e7"; x:-375.943634; y:-779.965454; z:-82.433418
		"\010\154\083\188\178\103\075\025\133\059\163\238\192\131\213\246\200\248\187\195\201\253\002\196\232\221\164\194" ..
		-- tex:"0a9a53bcb2674b19853ba3eec083d5f6"; x:-375.943634; y:-523.965454; z:-82.433418
		"\200\230\047\247\209\137\205\069\196\009\138\035\100\125\066\076\109\014\008\067\201\253\002\196\232\221\164\194" ..
		-- tex:"c8e62ff7d189cd45c4098a23647d424c"; x:136.056366; y:-523.965454; z:-82.433418
		"\204\063\105\169\052\042\142\102\240\011\117\077\023\227\060\130\109\014\008\067\201\253\066\196\232\221\164\194" ..
		-- tex:"cc3f69a9342a8e66f00b754d17e33c82"; x:136.056366; y:-779.965454; z:-82.433418
		"\066\091\035\122\141\170\213\153\103\156\021\108\089\133\114\250\035\227\239\194\201\253\002\196\232\221\164\194" ..
		-- tex:"425b237a8daad599679c156c598572fa"; x:-119.943634; y:-523.965454; z:-82.433418
		"\235\203\235\224\004\229\185\211\025\082\021\253\025\203\027\117\207\115\022\068\180\007\217\067\002\213\151\194" ..
		-- tex:"ebcbebe004e5b9d3195215fd19cb1b75"; x:601.809570; y:434.060211; z:-75.916039
		"\000\118\161\181\220\215\104\047\134\180\020\197\235\123\181\083\009\198\214\193\149\174\070\067\048\099\146\194" ..
		-- tex:"0076a1b5dcd7682f86b414c5eb7bb553"; x:-26.846699; y:198.681976; z:-73.193733
		"\142\114\240\122\166\155\016\201\212\166\089\040\065\233\005\250\165\198\214\193\107\023\005\067\168\098\146\194" ..
		-- tex:"8e72f07aa69b10c9d4a6592841e905fa"; x:-26.846996; y:133.091492; z:-73.192696
		"\234\219\017\010\175\064\127\234\089\254\143\176\030\130\076\084\207\246\114\066\081\030\038\067\167\098\146\194" ..
		-- tex:"eadb110aaf407fea59fe8fb01e824c54"; x:60.741028; y:166.118439; z:-73.192688
		"\089\228\053\220\100\060\229\156\191\005\138\182\164\210\155\051\066\196\031\068\121\119\152\067\030\242\145\194" ..
		-- tex:"59e435dc643ce59cbf058ab6a4d29b33"; x:639.066589; y:304.933411; z:-72.972893
		"\052\055\180\092\042\202\175\144\051\222\106\148\147\005\068\143\162\148\060\193\150\149\120\196\102\193\145\194" ..
		-- tex:"3437b45c2acaaf9033de6a949305448f"; x:-11.786288; y:-994.337341; z:-72.877739
		"\077\166\188\242\210\123\230\242\087\145\076\198\255\094\011\085\085\144\158\192\083\184\010\067\100\077\145\194" ..
		-- tex:"4da6bcf2d27be6f257914cc6ff5e0b55"; x:-4.955119; y:138.720032; z:-72.651161
		"\034\226\217\005\225\200\184\046\044\115\035\089\252\081\156\055\222\228\112\194\077\116\117\067\247\072\145\194" ..
		-- tex:"22e2d905e1c8b82e2c732359fc519c37"; x:-60.223507; y:245.454315; z:-72.642517
		"\239\160\106\095\126\097\067\204\081\221\018\113\151\199\055\042\001\057\119\194\069\148\133\067\247\072\145\194" ..
		-- tex:"efa06a5f7e6143cc51dd127197c7372a"; x:-61.805672; y:267.158386; z:-72.642517
		"\105\104\014\017\027\087\235\031\123\009\206\222\081\014\092\189\245\145\168\065\124\001\221\066\055\070\145\194" ..
		-- tex:"69680e111b57eb1f7b09cede510e5cbd"; x:21.071270; y:110.502907; z:-72.637146
		"\132\247\231\141\020\142\192\243\025\112\140\124\229\253\091\070\164\053\167\065\143\070\088\066\055\070\145\194" ..
		-- tex:"84f7e78d148ec0f319708c7ce5fd5b46"; x:20.901194; y:54.068909; z:-72.637146
		"\049\114\227\134\102\174\235\086\159\026\012\060\100\021\009\090\058\222\070\068\073\090\110\067\243\082\143\194" ..
		-- tex:"3172e38666aeeb569f1a0c3c6415095a"; x:795.472351; y:238.352692; z:-71.662018
		"\224\235\025\124\028\015\149\219\215\156\144\065\146\155\231\063\058\222\006\068\073\090\110\067\243\082\143\194" ..
		-- tex:"e0eb197c1c0f95dbd79c9041929be73f"; x:539.472351; y:238.352692; z:-71.662018
		"\233\225\247\179\202\254\025\196\030\154\031\142\030\011\242\159\058\222\070\068\175\045\141\193\243\082\143\194" ..
		-- tex:"e9e1f7b3cafe19c41e9a1f8e1e0bf29f"; x:795.472351; y:-17.647308; z:-71.662018
		"\185\066\172\048\059\183\004\016\109\253\071\191\176\057\022\027\058\222\070\068\218\210\136\195\243\082\143\194" ..
		-- tex:"b942ac303bb704106dfd47bfb039161b"; x:795.472351; y:-273.647308; z:-71.662018
		"\187\176\098\076\218\135\172\205\003\212\114\185\048\031\063\170\058\222\006\068\175\045\141\193\243\082\143\194" ..
		-- tex:"bbb0624cda87accd03d472b9301f3faa"; x:539.472351; y:-17.647308; z:-71.662018
		"\117\045\213\231\027\018\041\207\051\163\215\209\151\240\066\037\102\020\045\068\102\127\044\067\243\082\143\194" ..
		-- tex:"752dd5e71b1229cf33a3d7d197f04225"; x:692.318787; y:172.497665; z:-71.662018
		"\244\038\137\015\128\018\042\081\217\214\052\240\091\223\236\155\058\222\006\068\218\210\136\195\243\082\143\194" ..
		-- tex:"f426890f80122a51d9d634f05bdfec9b"; x:539.472351; y:-273.647308; z:-71.662018
		"\231\065\030\075\159\231\090\142\156\089\022\038\035\169\063\159\104\230\203\194\100\168\150\067\086\040\138\194" ..
		-- tex:"e7411e4b9fe75a8e9c59162623a93f9f"; x:-101.950020; y:301.315582; z:-69.078789
		"\064\097\161\129\017\252\244\020\061\197\217\102\042\185\188\018\123\029\191\066\038\218\213\068\184\091\132\194" ..
		-- tex:"4061a18111fcf4143dc5d9662ab9bc12"; x:95.557587; y:1710.817261; z:-66.179146
		"\227\085\174\227\228\077\143\177\018\180\151\107\228\089\183\145\160\056\208\195\038\218\213\068\184\091\132\194" ..
		-- tex:"e355aee3e44d8fb112b4976be459b791"; x:-416.442413; y:1710.817261; z:-66.179146
		"\247\046\229\144\024\169\249\062\197\183\156\241\176\207\104\011\065\113\032\195\038\218\149\068\184\091\132\194" ..
		-- tex:"f72ee59018a9f93ec5b79cf1b0cf680b"; x:-160.442413; y:1198.817261; z:-66.179146
		"\058\127\218\234\213\252\044\004\108\028\036\195\000\178\103\116\160\056\208\195\038\218\181\068\184\091\132\194" ..
		-- tex:"3a7fdaead5fc2c046c1c24c300b26774"; x:-416.442413; y:1454.817261; z:-66.179146
		"\062\110\235\197\041\009\171\079\249\248\086\171\074\043\023\251\123\029\191\066\038\218\181\068\184\091\132\194" ..
		-- tex:"3e6eebc52909ab4ff9f856ab4a2b17fb"; x:95.557587; y:1454.817261; z:-66.179146
		"\136\012\107\250\126\098\238\082\214\040\203\001\042\203\038\180\160\056\208\195\038\218\149\068\184\091\132\194" ..
		-- tex:"880c6bfa7e62ee52d628cb012acb26b4"; x:-416.442413; y:1198.817261; z:-66.179146
		"\167\080\108\203\164\043\236\113\076\224\021\175\209\075\076\227\065\113\032\195\038\218\213\068\184\091\132\194" ..
		-- tex:"a7506ccba42bec714ce015afd14b4ce3"; x:-160.442413; y:1710.817261; z:-66.179146
		"\211\067\052\063\013\182\149\022\229\042\109\119\204\060\011\085\123\029\191\066\038\218\149\068\184\091\132\194" ..
		-- tex:"d343343f0db69516e52a6d77cc3c0b55"; x:95.557587; y:1198.817261; z:-66.179146
		"\232\187\158\150\199\074\068\138\117\003\231\032\106\080\097\193\065\113\032\195\038\218\181\068\184\091\132\194" ..
		-- tex:"e8bb9e96c74a448a7503e7206a5061c1"; x:-160.442413; y:1454.817261; z:-66.179146
		"\026\249\209\211\141\105\059\090\033\194\171\146\076\152\041\107\136\090\084\194\009\203\216\196\095\077\132\194" ..
		-- tex:"1af9d1d38d693b5a21c2ab924c98296b"; x:-53.088413; y:-1734.344971; z:-66.151123
		"\231\057\155\062\032\225\017\247\254\033\135\034\114\211\200\189\206\126\057\194\017\214\217\196\080\077\132\194" ..
		-- tex:"e7399b3e20e111f7fe21872272d3c8bd"; x:-46.373837; y:-1742.689697; z:-66.151009
		"\043\207\113\191\089\067\056\022\064\140\239\225\137\195\143\211\012\060\105\065\141\009\210\196\125\072\132\194" ..
		-- tex:"2bcf71bf59433816408cefe189c38fd3"; x:14.577161; y:-1680.298584; z:-66.141586
		"\072\080\139\193\224\107\103\058\000\252\238\145\062\136\225\211\240\188\138\194\076\077\027\194\103\151\126\194" ..
		-- tex:"48508bc1e06b673a00fcee913e88e1d3"; x:-69.369026; y:-38.825489; z:-63.647858
		"\251\139\026\055\018\061\120\047\073\077\128\136\028\245\045\058\202\078\042\066\180\147\210\196\074\209\119\194" ..
		-- tex:"fb8b1a37123d782f494d80881cf52d3a"; x:42.576946; y:-1684.615845; z:-61.954388
		"\136\188\064\089\245\154\091\076\098\179\011\139\043\202\090\192\230\024\156\067\221\051\250\195\141\077\094\194" ..
		-- tex:"88bc4059f59a5b4c62b30b8b2bca5ac0"; x:312.194550; y:-500.405212; z:-55.575737
		"\194\080\010\099\120\077\072\033\025\131\196\065\047\233\187\164\001\128\038\195\180\253\163\067\184\080\088\194" ..
		-- tex:"c2500a63784d48211983c4412fe9bba4"; x:-166.500031; y:327.982086; z:-54.078831
		"\250\047\057\197\051\244\251\144\194\066\190\096\192\137\070\062\212\029\188\066\212\003\204\196\004\124\086\194" ..
		-- tex:"fa2f39c533f4fb90c242be60c089463e"; x:94.058266; y:-1632.119751; z:-53.621113
		"\116\193\255\008\214\011\139\171\113\231\017\024\077\163\016\162\198\110\245\066\020\138\154\068\067\094\082\194" ..
		-- tex:"74c1ff08d60b8bab71e711184da310a2"; x:122.716362; y:1236.315063; z:-52.592056
		"\045\201\176\248\046\032\219\248\153\127\079\192\072\152\213\206\112\108\021\067\021\196\213\195\232\127\079\194" ..
		-- tex:"2dc9b0f82e20dbf8997f4fc04898d5ce"; x:149.423599; y:-427.531921; z:-51.874912
		"\028\159\115\014\133\160\004\245\160\052\137\124\123\065\215\133\106\253\147\068\141\181\129\068\184\127\075\194" ..
		-- tex:"1c9f730e85a004f5a034897c7b41d785"; x:1183.919312; y:1037.673584; z:-50.874729
		"\234\215\088\044\246\201\195\249\235\030\180\018\120\024\082\029\213\250\103\068\141\181\129\068\184\127\075\194" ..
		-- tex:"ead7582cf6c9c3f9eb1eb4127818521d"; x:927.919312; y:1037.673584; z:-50.874729
		"\199\151\030\175\067\064\047\025\149\039\002\079\221\211\254\228\155\209\232\192\244\022\199\196\069\141\074\194" ..
		-- tex:"c7971eaf43402f199527024fddd3fee4"; x:-7.275587; y:-1592.717407; z:-50.637962
		"\137\137\135\000\062\087\022\244\023\061\212\214\046\113\008\177\155\209\232\192\244\022\167\196\069\141\074\194" ..
		-- tex:"898987003e5716f4173dd4d62e7108b1"; x:-7.275587; y:-1336.717407; z:-50.637962
		"\211\041\143\195\079\158\115\067\098\248\131\110\081\229\091\205\016\050\057\068\065\125\113\068\025\109\063\194" ..
		-- tex:"d3298fc34f9e734362f8836e51e55bcd"; x:740.782288; y:965.957153; z:-47.856544
		"\065\207\063\127\155\053\219\204\118\225\196\196\026\164\216\234\158\067\099\068\126\193\134\068\025\109\063\194" ..
		-- tex:"41cf3f7f9b35dbcc76e1c4c41aa4d8ea"; x:909.056580; y:1078.046753; z:-47.856544
		"\177\007\129\029\207\148\180\134\205\144\158\149\076\037\026\225\100\150\188\066\101\125\146\196\210\208\060\194" ..
		-- tex:"b107811dcf94b486cd909e954c251ae1"; x:94.293739; y:-1171.918701; z:-47.203930
		"\121\170\241\210\254\200\211\185\148\176\247\004\030\099\037\064\055\074\157\065\169\216\120\068\031\219\058\194" ..
		-- tex:"79aaf1d2fec8d3b994b0f7041e632540"; x:19.661240; y:995.385376; z:-46.713989
		"\098\151\175\209\121\051\104\006\066\002\138\167\201\120\010\020\055\074\157\065\169\216\056\068\031\219\058\194" ..
		-- tex:"6297afd17933680642028aa7c9780a14"; x:19.661240; y:739.385376; z:-46.713989
		"\121\103\028\119\042\118\103\107\074\232\157\159\118\065\001\051\184\086\108\195\169\216\120\068\031\219\058\194" ..
		-- tex:"79671c772a76676b4ae89d9f76410133"; x:-236.338760; y:995.385376; z:-46.713989
		"\127\004\095\115\200\116\232\063\143\032\157\162\248\032\018\064\163\212\137\067\169\216\056\068\031\219\058\194" ..
		-- tex:"7f045f73c874e83f8f209da2f8201240"; x:275.661240; y:739.385376; z:-46.713989
		"\223\023\117\087\070\195\164\205\218\247\223\019\115\223\242\054\163\212\137\067\169\216\120\068\031\219\058\194" ..
		-- tex:"df17755746c3a4cddaf7df1373dff236"; x:275.661240; y:995.385376; z:-46.713989
		"\187\008\074\126\155\114\196\107\090\160\041\040\253\160\031\107\184\086\108\195\169\216\056\068\031\219\058\194" ..
		-- tex:"bb084a7e9b72c46b5aa02928fda01f6b"; x:-236.338760; y:739.385376; z:-46.713989
		"\084\114\013\021\061\171\006\177\142\151\213\191\019\006\177\086\220\248\046\066\211\038\131\068\021\171\058\194" ..
		-- tex:"54720d153dab06b18e97d5bf1306b156"; x:43.743031; y:1049.213379; z:-46.667076
		"\132\019\147\209\096\166\208\238\052\250\064\236\151\095\010\075\012\165\199\194\031\029\136\068\024\170\058\194" ..
		-- tex:"841393d160a6d0ee34fa40ec975f0a4b"; x:-99.822365; y:1088.910156; z:-46.666111
		"\243\222\212\029\009\034\230\007\040\047\134\050\039\188\216\003\046\136\174\066\222\004\121\068\023\170\058\194" ..
		-- tex:"f3ded41d0922e607282f863227bcd803"; x:87.265984; y:996.076111; z:-46.666107
		"\057\126\165\084\235\147\157\093\226\162\139\211\009\057\203\130\037\165\199\194\165\199\146\068\000\170\058\194" ..
		-- tex:"397ea554eb939d5de2a28bd30939cb82"; x:-99.822556; y:1174.239014; z:-46.666019
		"\047\034\096\152\207\236\174\233\121\103\038\146\232\218\238\158\190\094\058\195\118\068\138\067\193\080\028\194" ..
		-- tex:"2f226098cfecaee979672692e8daee9e"; x:-186.370102; y:276.534882; z:-39.078865
		"\117\219\227\219\113\181\015\006\045\029\232\067\152\212\052\238\234\243\179\066\155\144\141\196\130\137\027\194" ..
		-- tex:"75dbe3db71b50f062d1de84398d434ee"; x:89.976402; y:-1132.519043; z:-38.884289
		"\154\238\099\023\155\159\144\055\249\226\024\061\125\098\100\156\072\109\029\067\242\001\137\196\138\104\244\193" ..
		-- tex:"9aee63179b9f9037f9e2183d7d62649c"; x:157.426895; y:-1096.060913; z:-30.551046
		"\231\018\075\157\185\085\186\215\171\097\021\122\171\114\096\079\157\166\057\067\024\140\137\196\179\189\177\193" ..
		-- tex:"e7124b9db955bad7ab61157aab72604f"; x:185.650848; y:-1100.378052; z:-22.217628
		"\062\170\012\035\064\254\176\035\009\073\063\153\066\183\202\077\213\152\085\067\058\161\132\196\179\189\177\193" ..
		-- tex:"3eaa0c2340feb02309493f9942b7ca4d"; x:213.597015; y:-1061.038452; z:-22.217628
		"\003\008\178\199\163\108\238\020\248\068\050\047\004\123\236\118\064\067\134\067\119\149\174\067\146\193\147\193" ..
		-- tex:"0308b2c7a36cee14f844322f047bec76"; x:268.525421; y:349.167725; z:-18.469519
		"\187\029\178\252\056\080\164\078\032\004\120\107\087\137\120\180\125\121\115\195\119\149\174\067\146\193\147\193" ..
		-- tex:"bb1db2fc3850a44e2004786b578978b4"; x:-243.474579; y:349.167725; z:-18.469519
		"\013\167\159\234\238\002\191\085\194\079\145\227\083\077\245\157\064\067\134\067\187\074\023\068\146\193\147\193" ..
		-- tex:"0da79feaee02bf55c24f91e3534df59d"; x:268.525421; y:605.167725; z:-18.469519
		"\220\153\039\123\020\222\232\036\195\080\076\177\058\088\101\061\031\104\072\065\119\149\174\067\146\193\147\193" ..
		-- tex:"dc99277b14dee824c3504cb13a58653d"; x:12.525421; y:349.167725; z:-18.469519
		"\013\086\109\150\123\097\098\203\173\206\232\013\211\048\000\152\031\104\072\065\187\074\023\068\146\193\147\193" ..
		-- tex:"0d566d967b6162cbadcee80dd3300098"; x:12.525421; y:605.167725; z:-18.469519
		"\141\102\087\094\077\032\210\181\209\043\164\246\242\163\186\056\125\121\115\195\187\074\023\068\146\193\147\193" ..
		-- tex:"8d66575e4d20d2b5d12ba4f6f2a3ba38"; x:-243.474579; y:605.167725; z:-18.469519
		"\114\066\143\174\060\019\008\248\202\142\179\235\237\142\118\051\138\230\054\068\127\020\060\068\093\082\104\193" ..
		-- tex:"72428fae3c1308f8ca8eb3ebed8e7633"; x:731.602234; y:752.320313; z:-14.520109
		"\173\124\215\149\185\142\161\094\095\157\064\004\101\131\192\068\165\179\075\067\255\181\110\196\242\147\026\193" ..
		-- tex:"ad7cd795b98ea15e5f9d40046583c044"; x:203.701752; y:-954.843750; z:-9.661120
		"\008\100\167\087\166\066\081\097\071\100\138\020\148\118\110\179\029\236\107\067\224\009\079\068\076\206\013\193" ..
		-- tex:"0864a757a642516147648a1494766eb3"; x:235.922329; y:828.154358; z:-8.862866
		"\093\010\239\169\122\171\073\139\103\019\250\036\227\253\066\206\029\236\107\067\240\132\135\068\076\206\013\193" ..
		-- tex:"5d0aefa97aab498b6713fa24e3fd42ce"; x:235.922329; y:1084.154358; z:-8.862866
		"\191\109\149\037\117\224\183\234\044\208\183\161\015\043\155\079\017\159\160\193\224\009\079\068\076\206\013\193" ..
		-- tex:"bf6d952575e0b7ea2cd0b7a10f2b9b4f"; x:-20.077671; y:828.154358; z:-8.862866
		"\036\151\231\096\131\052\065\195\003\033\239\156\230\062\141\161\017\159\160\193\240\132\135\068\076\206\013\193" ..
		-- tex:"2497e760833441c30321ef9ce63e8da1"; x:-20.077671; y:1084.154358; z:-8.862866
		"\248\005\040\174\193\027\185\045\010\008\092\016\103\180\237\158\090\063\109\195\019\230\144\068\074\206\013\193" ..
		-- tex:"f80528aec11bb92d0a085c1067b4ed9e"; x:-237.247482; y:1159.189880; z:-8.862864
		"\047\191\097\135\061\119\045\084\166\241\075\132\212\163\022\187\090\063\109\195\038\204\097\068\074\206\013\193" ..
		-- tex:"2fbf61873d772d54a6f14b84d4a316bb"; x:-237.247482; y:903.189880; z:-8.862864
		"\199\156\207\141\182\241\082\142\048\181\217\195\042\247\119\173\179\075\112\195\061\025\111\196\186\146\009\193" ..
		-- tex:"c79ccf8db6f1528e30b5d9c32af777ad"; x:-240.295715; y:-956.394409; z:-8.598323
		"\033\248\136\242\081\039\109\098\042\078\016\213\139\052\093\230\191\068\123\065\061\025\111\196\186\146\009\193" ..
		-- tex:"21f888f251276d622a4e10d58b345de6"; x:15.704285; y:-956.394409; z:-8.598323
		"\218\147\089\175\162\111\182\166\070\170\024\140\083\243\016\061\180\078\177\194\212\001\149\067\169\079\224\192" ..
		-- tex:"da9359afa26fb6a646aa188c53f3103d"; x:-88.653725; y:298.014313; z:-7.009725
		"\241\229\158\119\235\206\230\126\244\013\230\167\094\243\244\213\119\216\038\195\111\088\151\067\096\055\224\192" ..
		-- tex:"f1e59e77ebcee67ef40de6a75ef3f4d5"; x:-166.845581; y:302.690918; z:-7.006760
		"\114\132\060\127\013\201\158\046\210\203\167\074\202\071\157\046\138\185\098\066\193\242\150\067\096\055\224\192" ..
		-- tex:"72843c7f0dc99e2ed2cba74aca479d2e"; x:56.681194; y:301.896545; z:-7.006760
		"\111\110\181\044\072\152\085\201\249\062\165\188\022\134\249\064\204\110\210\065\142\139\155\067\072\240\223\192" ..
		-- tex:"6f6eb52c489855c9f93ea5bc1686f940"; x:26.304102; y:311.090302; z:-6.998082
		"\108\143\083\089\102\209\175\162\001\091\010\181\063\066\127\064\207\015\238\194\168\241\155\067\184\132\223\192" ..
		-- tex:"6c8f535966d1afa2015b0ab53f427f40"; x:-119.030884; y:311.887970; z:-6.984951
		"\070\003\139\214\114\117\105\038\180\144\242\076\125\194\135\056\113\007\024\195\115\126\165\195\032\239\214\192" ..
		-- tex:"46038bd672756926b490f24c7dc28738"; x:-152.029083; y:-330.987915; z:-6.716691
		"\192\208\237\024\116\234\074\220\043\127\247\092\155\082\234\105\254\198\217\195\212\086\132\065\092\049\177\192" ..
		-- tex:"c0d0ed1874ea4adc2b7ff75c9b52ea69"; x:-435.554657; y:16.542398; z:-5.537276
		"\000\221\141\086\255\000\190\215\133\137\135\066\095\025\029\106\106\022\208\195\053\118\044\196\158\066\176\192" ..
		-- tex:"00dd8d56ff00bed7858987425f191d6a"; x:-416.175140; y:-689.847046; z:-5.508132
		"\228\208\054\141\071\241\170\049\183\179\091\086\095\238\136\239\255\035\221\195\113\089\032\196\155\066\176\192" ..
		-- tex:"e4d0368d47f1aa31b7b35b565fee88ef"; x:-442.281250; y:-641.397583; z:-5.508131
		"\099\136\199\246\143\089\036\200\036\234\152\081\198\223\110\141\071\247\048\067\255\040\099\196\015\025\176\192" ..
		-- tex:"6388c7f68f5924c824ea9851c6df6e8d"; x:176.965942; y:-908.640625; z:-5.503059
		"\106\101\025\026\073\209\166\145\025\206\017\020\171\201\063\251\215\047\167\066\060\166\175\195\215\127\175\192" ..
		-- tex:"6a65191a49d1a69119ce1114abc93ffb"; x:83.593445; y:-351.298737; z:-5.484356
		"\080\153\101\030\069\062\074\143\038\073\150\143\096\188\064\000\191\151\208\065\152\028\159\195\164\127\175\192" ..
		-- tex:"5099651e453e4a8f2649968f60bc4000"; x:26.074097; y:-318.223419; z:-5.484332
		"\218\107\209\193\008\179\128\052\143\193\047\207\147\069\065\071\049\127\244\067\014\148\124\065\115\128\174\192" ..
		-- tex:"da6bd1c108b380348fc12fcf93454147"; x:488.993713; y:15.786147; z:-5.453180
		"\222\099\250\062\014\163\223\028\236\044\192\100\034\253\211\154\065\109\251\067\191\009\213\193\101\128\174\192" ..
		-- tex:"de63fa3e0ea3df1cec2cc06422fdd39a"; x:502.853577; y:-26.629761; z:-5.453174
		"\146\132\093\081\178\213\216\139\008\080\179\153\045\130\011\208\133\011\251\067\212\186\002\067\083\128\174\192" ..
		-- tex:"92845d51b2d5d88b0850b3992d820bd0"; x:502.090027; y:130.729813; z:-5.453165
		"\249\184\240\083\122\142\175\255\057\072\096\049\127\032\058\021\160\024\211\195\143\004\003\067\034\128\174\192" ..
		-- tex:"f9b8f0537a8eafff394860317f203a15"; x:-422.192413; y:131.017822; z:-5.453142
		"\066\059\211\144\183\181\158\223\125\056\128\242\179\208\186\004\247\132\211\195\014\088\221\193\220\127\174\192" ..
		-- tex:"423bd390b7b59edf7d3880f2b3d0ba04"; x:-423.038818; y:-27.667997; z:-5.453108
		"\032\251\242\224\146\094\073\189\130\051\178\164\097\150\110\164\078\188\026\068\078\077\137\067\226\058\167\192" ..
		-- tex:"20fbf2e0925e49bd8233b2a461966ea4"; x:618.942322; y:274.603973; z:-5.225938
		"\136\004\245\035\116\150\164\249\037\109\020\027\153\255\148\234\250\066\086\068\039\077\137\067\203\058\167\192" ..
		-- tex:"8804f5237496a4f9256d141b99ff94ea"; x:857.046570; y:274.602783; z:-5.225927
		"\205\244\033\144\042\138\010\249\148\083\240\129\020\208\188\131\136\190\056\068\088\077\137\067\198\058\167\192" ..
		-- tex:"cdf421902a8a0af99453f08114d0bc83"; x:738.977112; y:274.604279; z:-5.225925
		"\193\088\115\192\024\184\125\057\009\085\026\255\193\026\031\073\158\172\246\067\181\217\143\194\159\151\165\192" ..
		-- tex:"c15873c018b87d3909551affc11a1f49"; x:493.348602; y:-71.925217; z:-5.174759
		"\142\031\078\018\037\095\244\222\185\007\126\118\245\141\112\044\156\172\246\067\023\139\038\067\135\151\165\192" ..
		-- tex:"8e1f4e12255ff4deb9077e76f58d702c"; x:493.348541; y:166.543335; z:-5.174747
		"\040\016\228\217\063\151\156\146\026\118\244\067\076\192\147\228\191\199\004\068\092\066\152\067\069\045\090\192" ..
		-- tex:"2810e4d93f979c921a76f4434cc093e4"; x:531.121094; y:304.518463; z:-3.409013
		"\240\041\240\254\069\026\050\217\115\161\096\027\012\032\227\058\191\199\068\068\092\066\152\067\069\045\090\192" ..
		-- tex:"f029f0fe451a32d973a1601b0c20e33a"; x:787.121094; y:304.518463; z:-3.409013
		"\050\209\145\220\180\185\068\031\131\242\211\048\175\036\075\214\191\199\068\068\046\033\012\068\069\045\090\192" ..
		-- tex:"32d191dcb4b9441f83f2d330af244bd6"; x:787.121094; y:560.518463; z:-3.409013
		"\077\064\116\044\206\157\088\085\033\171\107\060\222\105\145\225\191\199\004\068\046\033\012\068\069\045\090\192" ..
		-- tex:"4d40742cce9d585521ab6b3cde6991e1"; x:531.121094; y:560.518463; z:-3.409013
		"\201\025\084\212\197\097\173\000\075\083\037\047\041\221\099\146\101\136\187\068\020\048\126\068\196\066\089\066" ..
		-- tex:"c91954d4c561ad004b53252f29dd6392"; x:1500.262451; y:1016.751282; z:54.315205
		"\161\019\025\219\228\171\164\183\035\121\249\107\003\116\124\228\101\136\155\068\020\048\126\068\196\066\089\066" ..
		-- tex:"a11319dbe4aba4b72379f96b03747ce4"; x:1244.262451; y:1016.751282; z:54.315205
		"\124\005\118\108\099\198\226\215\143\232\058\022\239\160\113\233\101\136\155\068\020\048\062\068\196\066\089\066" ..
		-- tex:"7c05766c63c6e2d78fe83a16efa071e9"; x:1244.262451; y:760.751282; z:54.315205
		"\002\202\172\121\101\180\149\065\242\023\094\091\164\252\145\058\101\136\219\068\020\048\062\068\196\066\089\066" ..
		-- tex:"02caac7965b49541f2175e5ba4fc913a"; x:1756.262451; y:760.751282; z:54.315205
		"\118\120\133\050\064\107\038\233\096\136\177\197\213\197\087\147\101\136\187\068\020\048\062\068\196\066\089\066" ..
		-- tex:"76788532406b26e96088b1c5d5c55793"; x:1500.262451; y:760.751282; z:54.315205
		"\137\140\000\246\187\005\172\098\224\218\118\203\065\196\061\156\101\136\219\068\020\048\126\068\196\066\089\066" ..
		-- tex:"898c00f6bb05ac62e0da76cb41c43d9c"; x:1756.262451; y:1016.751282; z:54.315205
		"\159\207\245\055\128\070\253\184\209\174\102\081\211\119\008\141\250\025\063\067\112\117\057\068\164\153\100\066" ..
		-- tex:"9fcff5378046fdb8d1ae6651d377088d"; x:191.101486; y:741.835022; z:57.150043
		"\140\075\176\248\095\103\215\243\168\198\106\062\175\213\022\125\004\058\077\195\173\116\057\068\018\155\100\066" ..
		-- tex:"8c4bb0f85f67d7f3a8c66a3eafd5167d"; x:-205.226639; y:741.823120; z:57.151440
		"\017\200\229\160\152\112\164\200\126\154\120\151\038\018\171\200\122\175\114\068\161\011\110\068\091\122\107\066" ..
		-- tex:"11c8e5a09870a4c87e9a78972612abc8"; x:970.741882; y:952.181763; z:58.869492
		"\166\186\253\251\028\226\137\134\180\013\245\232\087\101\104\155\202\004\131\068\081\054\103\068\096\122\107\066" ..
		-- tex:"a6bafdfb1ce28986b40df5e85765689b"; x:1048.149780; y:924.848755; z:58.869511
		"\125\239\204\134\084\187\158\087\150\173\216\187\030\050\137\031\187\221\065\196\200\088\030\068\153\212\162\066" ..
		-- tex:"7defcc8654bb9e5796add8bb1e32891f"; x:-775.464600; y:633.387238; z:81.415237
		"\117\092\171\005\053\173\224\088\093\134\196\223\255\033\234\229\187\221\065\196\200\088\094\068\153\212\162\066" ..
		-- tex:"755cab0535ade0585d86c4dfff21eae5"; x:-775.464600; y:889.387238; z:81.415237
		"\183\165\219\021\016\077\015\154\134\138\183\039\065\188\254\228\187\221\065\196\100\044\143\068\153\212\162\066" ..
		-- tex:"b7a5db15104d0f9a868ab72741bcfee4"; x:-775.464600; y:1145.387238; z:81.415237
		"\088\230\224\238\182\011\011\073\081\100\206\006\150\181\128\037\187\221\065\196\144\177\188\067\153\212\162\066" ..
		-- tex:"58e6e0eeb60b0b495164ce0696b58025"; x:-775.464600; y:377.387238; z:81.415237
		"\028\030\248\025\101\252\047\253\038\215\081\054\035\058\177\173\187\221\001\196\200\088\030\068\153\212\162\066" ..
		-- tex:"1c1ef81965fc2ffd26d75136233ab1ad"; x:-519.464600; y:633.387238; z:81.415237
		"\119\005\132\115\251\019\254\092\088\110\024\149\005\049\102\089\187\221\001\196\200\088\094\068\153\212\162\066" ..
		-- tex:"77058473fb13fe5c586e189505316659"; x:-519.464600; y:889.387238; z:81.415237
		"\234\093\174\089\017\114\120\091\207\166\046\087\154\027\243\080\015\137\120\067\144\177\188\067\153\212\162\066" ..
		-- tex:"ea5dae591172785bcfa62e579a1bf350"; x:248.535400; y:377.387238; z:81.415237
		"\041\110\078\177\097\232\190\217\147\144\245\070\086\119\146\232\135\068\252\067\200\088\094\068\153\212\162\066" ..
		-- tex:"296e4eb161e8bed99390f546567792e8"; x:504.535400; y:889.387238; z:81.415237
		"\134\055\067\212\077\004\003\115\100\174\003\243\114\097\061\097\015\137\120\067\100\044\143\068\153\212\162\066" ..
		-- tex:"863743d44d04037364ae03f372613d61"; x:248.535400; y:1145.387238; z:81.415237
		"\034\026\181\192\180\028\208\068\106\208\139\067\228\068\081\034\135\068\252\067\200\088\030\068\153\212\162\066" ..
		-- tex:"221ab5c0b41cd0446ad08b43e4445122"; x:504.535400; y:633.387238; z:81.415237
		"\123\133\024\070\069\228\023\061\231\202\037\247\166\125\094\205\015\137\120\067\200\088\094\068\153\212\162\066" ..
		-- tex:"7b85184645e4173de7ca25f7a67d5ecd"; x:248.535400; y:889.387238; z:81.415237
		"\191\015\189\107\134\093\131\189\010\132\026\085\000\009\202\132\015\137\120\067\200\088\030\068\153\212\162\066" ..
		-- tex:"bf0fbd6b865d83bd0a841a550009ca84"; x:248.535400; y:633.387238; z:81.415237
		"\031\063\152\086\130\000\246\050\088\251\125\070\031\133\186\055\076\086\187\068\046\003\209\067\127\113\182\066" ..
		-- tex:"1f3f98568200f63258fb7d461f85ba37"; x:1498.696808; y:418.024872; z:91.221680
		"\062\109\149\204\054\231\131\032\098\049\159\012\118\117\237\125\076\086\187\068\151\129\040\068\127\113\182\066" ..
		-- tex:"3e6d95cc36e7832062319f0c7675ed7d"; x:1498.696808; y:674.024872; z:91.221680
		"\040\050\113\057\171\066\132\244\151\040\176\185\186\249\024\069\152\172\118\068\093\006\034\067\127\113\182\066" ..
		-- tex:"28327139ab4284f49728b0b9baf91845"; x:986.696808; y:162.024872; z:91.221680
		"\254\223\086\188\066\145\076\135\099\029\218\163\093\227\025\138\076\086\187\068\203\064\148\068\127\113\182\066" ..
		-- tex:"fedf56bc42914c87631ddaa35de3198a"; x:1498.696808; y:1186.024872; z:91.221680
		"\177\034\031\039\106\130\234\033\074\025\193\217\050\055\063\244\152\172\054\068\208\252\174\195\127\113\182\066" ..
		-- tex:"b1221f276a82ea214a19c1d932373ff4"; x:730.696808; y:-349.975128; z:91.221680
		"\079\252\135\216\119\213\249\010\063\098\195\031\001\153\104\153\152\172\054\068\151\129\040\068\127\113\182\066" ..
		-- tex:"4ffc87d877d5f90a3f62c31f01996899"; x:730.696808; y:674.024872; z:91.221680
		"\240\067\228\139\068\148\085\166\090\193\037\194\148\222\209\105\048\089\237\067\093\006\034\067\127\113\182\066" ..
		-- tex:"f043e48b449455a65ac125c294ded169"; x:474.696808; y:162.024872; z:91.221680
		"\167\022\175\089\161\247\177\054\152\064\178\117\231\214\123\186\076\086\219\068\151\129\104\068\127\113\182\066",
		-- tex:"a716af59a1f7b1369840b275e7d67bba"; x:1754.696808; y:930.024872; z:91.221680
	["Gnomeregan"] = 
		"\078\059\080\002\203\178\030\163\065\003\040\196\004\180\048\183\211\000\154\068\089\101\181\196\083\234\037\196" ..
		-- tex:"4e3b5002cbb21ea3410328c404b430b7"; x:1232.025879; y:-1451.167236; z:-663.661377
		"\087\168\073\206\023\252\013\188\101\132\013\009\174\060\040\221\144\117\179\068\115\107\170\196\191\103\037\196" ..
		-- tex:"57a849ce17fc0dbc65840d09ae3c28dd"; x:1435.673950; y:-1363.357910; z:-661.621094
		"\233\173\233\135\223\100\084\165\185\043\084\211\112\024\055\036\182\118\170\068\206\124\182\196\191\103\037\196" ..
		-- tex:"e9ade987df6454a5b92b54d370183724"; x:1363.709839; y:-1459.900269; z:-661.621094
		"\125\132\001\006\034\224\063\028\012\119\112\049\114\191\054\198\064\157\142\068\075\010\157\196\114\175\035\196" ..
		-- tex:"7d84010622e03f1c0c77703172bf36c6"; x:1140.914124; y:-1256.321777; z:-654.741394
		"\238\008\083\136\059\238\102\011\075\015\188\041\117\161\087\065\064\157\142\068\075\010\189\196\114\175\035\196" ..
		-- tex:"ee0853883bee660b4b0fbc2975a15741"; x:1140.914124; y:-1512.321777; z:-654.741394
		"\201\053\055\160\093\089\027\218\083\114\056\084\137\230\216\163\128\058\093\068\075\010\157\196\114\175\035\196" ..
		-- tex:"c93537a05d591bda5372385489e6d8a3"; x:884.914124; y:-1256.321777; z:-654.741394
		"\187\055\031\246\024\233\009\205\074\135\076\212\196\229\207\017\128\058\093\068\075\010\189\196\114\175\035\196" ..
		-- tex:"bb371ff618e909cd4a874cd4c4e5cf11"; x:884.914124; y:-1512.321777; z:-654.741394
		"\255\158\027\074\062\232\164\074\155\246\116\232\038\012\129\067\100\061\181\068\089\098\163\196\192\231\032\196" ..
		-- tex:"ff9e1b4a3ee8a44a9bf674e8260c8143"; x:1449.918579; y:-1307.073486; z:-643.621155
		"\139\203\122\073\220\132\057\199\171\019\163\071\189\058\010\172\158\188\180\068\242\094\165\196\192\231\032\196" ..
		-- tex:"8bcb7a49dc8439c7ab13a347bd3a0aac"; x:1445.894409; y:-1322.967163; z:-643.621155
		"\166\069\250\224\225\201\068\235\222\145\045\254\084\084\089\245\181\166\192\068\034\121\081\196\242\170\032\196" ..
		-- tex:"a645fae0e1c944ebde912dfe545459f5"; x:1541.209717; y:-837.892761; z:-642.671082
		"\033\183\217\101\165\100\213\146\020\209\177\086\112\202\011\249\053\005\215\068\242\164\083\196\105\061\030\196" ..
		-- tex:"21b7d965a564d59214d1b15670ca0bf9"; x:1720.162842; y:-846.577332; z:-632.959595
		"\134\198\130\057\002\201\205\190\235\044\203\249\083\107\024\060\043\177\204\068\215\045\099\196\103\061\030\196" ..
		-- tex:"86c6823902c9cdbeeb2ccbf9536b183c"; x:1637.536621; y:-908.716309; z:-632.959473
		"\023\193\046\061\227\242\212\139\057\030\101\113\092\100\105\068\143\132\182\068\157\085\158\196\191\103\028\196" ..
		-- tex:"17c12e3de3f2d48b391e65715c646944"; x:1460.142578; y:-1266.675537; z:-625.621094
		"\085\160\167\067\169\130\096\218\176\253\135\049\019\093\088\068\086\005\183\068\037\089\156\196\191\103\028\196" ..
		-- tex:"55a0a743a98260dab0fd8731135d5844"; x:1464.166870; y:-1250.785889; z:-625.621094
		"\163\061\036\018\199\186\129\086\150\244\107\085\115\176\109\017\189\017\202\068\117\082\130\196\221\016\026\196" ..
		-- tex:"a33d2412c7ba815696f46b5573b06d11"; x:1616.554443; y:-1042.576904; z:-616.263550
		"\078\132\232\237\253\078\178\148\099\159\025\124\005\068\151\180\176\244\191\068\181\174\140\196\133\251\023\196" ..
		-- tex:"4e84e8edfd4eb294639f197c054497b4"; x:1535.646606; y:-1125.459717; z:-607.930054
		"\197\197\189\146\043\225\189\040\209\000\165\119\012\054\182\130\030\083\180\068\134\076\151\196\193\231\023\196" ..
		-- tex:"c5c5bd922be1bd28d100a5770c36b682"; x:1442.597534; y:-1210.391479; z:-607.621216
		"\132\183\080\208\034\019\077\208\057\193\208\119\155\077\238\203\073\070\175\068\231\067\142\196\193\231\023\196" ..
		-- tex:"84b750d022134dd039c1d0779b4deecb"; x:1402.196533; y:-1138.122070; z:-607.621216
		"\178\164\044\109\109\135\121\000\085\008\095\145\063\221\129\222\192\073\173\068\198\252\140\196\190\103\019\196" ..
		-- tex:"b2a42c6d6d87790055085f913fdd81de"; x:1386.304810; y:-1127.899292; z:-589.621033
		"\002\216\100\173\098\093\241\149\021\198\212\250\001\093\244\017\096\061\168\068\072\124\140\196\190\103\019\196" ..
		-- tex:"02d864ad625df19515c6d4fa015df411"; x:1345.918091; y:-1123.883911; z:-589.621033
		"\045\052\200\175\044\005\188\024\122\125\197\042\187\170\097\248\118\074\166\068\138\052\139\196\191\231\014\196" ..
		-- tex:"2d34c8af2c05bc187a7dc52abbaa61f8"; x:1330.327026; y:-1113.641968; z:-571.621094
		"\086\240\060\169\010\067\214\148\223\196\227\089\069\075\046\177\014\045\107\068\112\002\146\196\189\231\014\196" ..
		-- tex:"56f03ca90a43d694dfc4e359454b2eb1"; x:940.704041; y:-1168.076294; z:-571.620972
		"\047\002\166\011\117\087\253\073\167\063\106\193\027\126\086\097\135\150\149\068\112\002\146\196\189\231\014\196" ..
		-- tex:"2f02a60b7557fd49a73f6ac11b7e5661"; x:1196.704041; y:-1168.076294; z:-571.620972
		"\044\139\057\175\119\253\124\157\178\102\198\192\227\226\175\238\014\045\107\068\225\004\100\196\189\231\014\196" ..
		-- tex:"2c8b39af77fd7c9db266c6c0e3e2afee"; x:940.704041; y:-912.076294; z:-571.620972
		"\027\033\165\087\172\006\240\117\249\032\077\004\229\030\112\187\135\150\149\068\225\004\100\196\189\231\014\196" ..
		-- tex:"1b21a557ac06f075f9204d04e51e70bb"; x:1196.704041; y:-912.076294; z:-571.620972
		"\131\002\173\173\220\039\072\034\047\132\047\154\102\216\056\074\214\059\200\068\232\160\193\195\137\113\009\196" ..
		-- tex:"8302adaddc2748222f842f9a66d8384a"; x:1601.869995; y:-387.257111; z:-549.774048
		"\067\228\232\096\204\187\107\158\175\134\232\045\207\236\136\232\117\061\180\068\172\159\000\196\125\088\009\196" ..
		-- tex:"43e4e860ccbb6b9eaf86e82dcfec88e8"; x:1441.920654; y:-514.494934; z:-549.382690
		"\095\073\155\166\209\125\179\001\252\162\127\007\063\210\232\178\186\248\181\068\154\041\110\196\050\086\009\196" ..
		-- tex:"5f499ba6d17db301fca27f073fd2e8b2"; x:1455.772827; y:-952.650085; z:-549.346863
		"\165\046\122\074\150\082\100\020\074\180\081\128\213\219\146\039\186\248\149\068\154\041\110\196\050\086\009\196" ..
		-- tex:"a52e7a4a965264144ab45180d5db9227"; x:1199.772827; y:-952.650085; z:-549.346863
		"\002\064\190\160\204\210\229\255\038\241\024\223\227\111\003\005\241\193\180\068\098\165\093\196\167\167\008\196" ..
		-- tex:"0240bea0ccd2e5ff26f118dfe36f0305"; x:1446.060791; y:-886.584167; z:-546.619629
		"\067\205\115\012\059\172\020\050\159\255\044\193\214\184\127\093\158\242\210\068\224\123\090\196\178\160\008\196" ..
		-- tex:"43cd730c3bac14329fff2cc1d6b87f5d"; x:1687.581909; y:-873.935608; z:-546.510925
		"\225\247\236\033\170\225\054\074\152\221\209\021\213\083\000\139\169\066\188\068\061\217\068\196\167\147\008\196" ..
		-- tex:"e1f7ec21aae1364a98ddd115d553008b"; x:1506.083252; y:-787.394409; z:-546.307129
		"\024\121\246\076\222\069\207\065\248\221\135\100\191\149\056\122\173\113\190\068\088\205\035\196\053\147\008\196" ..
		-- tex:"1879f64cde45cf41f8dd8764bf95387a"; x:1523.552490; y:-655.208557; z:-546.300171
		"\171\019\077\004\166\068\239\146\060\141\120\004\072\119\149\106\166\141\186\068\161\214\012\196\209\141\008\196" ..
		-- tex:"ab134d04a644ef923c8d78044877956a"; x:1492.426636; y:-563.353638; z:-546.215942
		"\254\094\014\147\034\043\068\230\182\055\058\131\100\218\065\020\197\081\157\068\035\070\066\196\107\139\008\196" ..
		-- tex:"fe5e0e93222b44e6b6373a8364da4114"; x:1258.555420; y:-777.095947; z:-546.178467
		"\117\098\033\219\182\004\035\086\182\105\255\214\046\197\219\017\036\170\187\068\113\143\091\196\076\125\008\196" ..
		-- tex:"756221dbb6042356b669ffd62ec5db11"; x:1501.317017; y:-878.241333; z:-545.957825
		"\098\086\254\120\189\018\220\191\228\114\008\235\253\202\102\251\036\170\187\068\113\143\027\196\076\125\008\196" ..
		-- tex:"6256fe78bd12dcbfe47208ebfdca66fb"; x:1501.317017; y:-622.241333; z:-545.957825
		"\068\189\165\169\180\206\053\197\132\052\232\174\051\083\007\027\036\170\219\068\113\143\091\196\076\125\008\196" ..
		-- tex:"44bda5a9b4ce35c58434e8ae3353071b"; x:1757.317017; y:-878.241333; z:-545.957825
		"\060\015\052\071\058\134\161\116\190\227\079\087\093\015\002\116\032\105\187\068\033\230\085\196\055\118\008\196" ..
		-- tex:"3c0f34473a86a174bee34f575d0f0274"; x:1499.285278; y:-855.595825; z:-545.847168
		"\085\198\036\201\071\098\136\206\203\196\239\144\136\140\142\114\062\042\224\068\195\228\044\196\054\118\008\196" ..
		-- tex:"55c624c9476288cecbc4ef90888c8e72"; x:1793.320190; y:-691.574463; z:-545.847107
		"\111\158\162\093\042\186\128\202\087\011\159\255\116\079\203\039\186\127\217\068\226\220\090\196\225\079\008\196" ..
		-- tex:"6f9ea25d2aba80ca570b9fff744fcb27"; x:1739.991577; y:-875.451355; z:-545.248169
		"\028\019\159\148\061\140\001\179\008\099\044\169\044\032\082\117\014\140\215\068\195\202\031\196\224\079\008\196" ..
		-- tex:"1c139f943d8c01b308632ca92c205275"; x:1724.376831; y:-639.168213; z:-545.248108
		"\026\170\107\027\101\234\166\047\093\233\205\233\210\217\107\138\192\241\198\068\101\076\018\196\223\079\008\196" ..
		-- tex:"1aaa6b1b65eaa62f5de9cde9d2d96b8a"; x:1591.554810; y:-585.193726; z:-545.248047
		"\171\255\126\255\129\067\052\235\227\015\095\197\238\062\107\002\213\176\195\068\227\022\102\195\022\100\004\196" ..
		-- tex:"abff7eff814334ebe30f5fc5ee3e6b02"; x:1565.526123; y:-230.089417; z:-529.563904
		"\005\106\099\159\063\240\037\022\244\215\233\233\202\166\186\243\025\127\188\068\012\062\079\195\230\181\002\196" ..
		-- tex:"056a639f3ff02516f4d7e9e9caa6baf3"; x:1507.971924; y:-207.242386; z:-522.842224
		"\134\083\118\239\122\111\141\105\052\213\234\063\064\240\091\141\010\025\187\068\090\035\021\195\002\076\002\196" ..
		-- tex:"865376ef7a6f8d6934d5ea3f40f05b8d"; x:1496.782593; y:-149.138107; z:-521.187683
		"\091\143\227\249\191\204\182\092\195\145\031\049\247\205\147\086\062\175\154\068\221\053\058\196\130\157\255\195" ..
		-- tex:"5b8fe3f9bfccb65cc3911f31f7cd9356"; x:1237.476440; y:-744.841675; z:-511.230560
		"\084\131\095\212\022\076\053\168\063\069\071\178\016\057\069\018\234\252\181\068\215\180\038\194\004\067\252\195" ..
		-- tex:"54835fd4164c35a83f4547b210394512"; x:1455.903687; y:-41.676605; z:-504.523590
		"\192\059\022\247\204\152\062\071\137\221\080\197\123\058\249\232\141\143\164\068\045\166\211\193\226\018\248\195" ..
		-- tex:"c03b16f7cc983e4789dd50c57b3af9e8"; x:1316.486084; y:-26.456142; z:-496.147552
		"\213\038\140\086\001\117\205\043\222\110\236\187\015\044\089\186\104\170\151\068\105\181\078\196\109\081\247\195" ..
		-- tex:"d5268c560175cd2bde6eecbb0f2c59ba"; x:1213.325317; y:-826.834595; z:-494.636169
		"\143\244\074\078\135\095\127\183\204\086\047\225\152\186\160\171\168\216\091\068\215\235\115\196\088\017\233\195" ..
		-- tex:"8ff44a4e875f7fb7cc562fe198baa0ab"; x:879.385315; y:-975.685059; z:-466.135529
		"\217\041\018\226\059\013\227\207\016\020\062\000\115\237\240\068\168\216\091\068\235\245\153\196\088\017\233\195" ..
		-- tex:"d92912e23b0de3cf10143e0073edf044"; x:879.385315; y:-1231.685059; z:-466.135529
		"\160\003\242\018\067\205\131\206\043\016\242\187\130\223\000\113\084\236\141\068\235\245\153\196\088\017\233\195" ..
		-- tex:"a003f21243cd83ce2b10f2bb82df0071"; x:1135.385315; y:-1231.685059; z:-466.135529
		"\203\032\191\191\019\191\212\055\113\250\158\028\226\014\064\144\084\236\141\068\215\235\115\196\088\017\233\195" ..
		-- tex:"cb20bfbf13bfd43771fa9e1ce20e4090"; x:1135.385315; y:-975.685059; z:-466.135529
		"\080\122\138\255\239\000\008\055\051\095\041\190\141\142\016\069\185\236\128\068\082\081\069\196\102\187\231\195" ..
		-- tex:"507a8affef000837335f29be8d8e1045"; x:1031.397705; y:-789.270691; z:-463.464081
		"\103\159\079\098\249\065\065\004\121\041\121\165\170\144\072\161\197\018\132\068\028\069\048\196\107\070\231\195" ..
		-- tex:"679f4f62f9414104792979a5aa9048a1"; x:1056.586670; y:-705.079895; z:-462.550171
		"\078\214\116\220\048\001\154\163\169\238\109\085\128\138\234\063\074\152\158\068\071\247\090\196\047\168\230\195" ..
		-- tex:"4ed674dc30019aa3a9ee6d55808aea3f"; x:1268.759155; y:-875.863770; z:-461.313965
		"\221\197\221\062\072\026\241\019\109\204\197\232\041\208\114\041\118\206\048\068\087\130\196\195\196\109\217\195" ..
		-- tex:"ddc5dd3e481af1136dccc5e829d07229"; x:707.226013; y:-393.018311; z:-434.857574
		"\237\233\074\207\164\169\169\042\223\192\006\051\090\220\184\154\118\206\112\068\175\004\009\195\196\109\217\195" ..
		-- tex:"ede94acfa4a9a92adfc006335adcb89a"; x:963.226013; y:-137.018311; z:-434.857574
		"\011\076\141\069\230\245\000\085\106\247\236\186\106\235\074\137\118\206\112\068\087\130\196\195\196\109\217\195" ..
		-- tex:"0b4c8d45e6f500556af7ecba6aeb4a89"; x:963.226013; y:-393.018311; z:-434.857574
		"\169\172\035\116\163\214\089\038\040\112\236\147\128\213\215\217\118\206\048\068\175\004\009\195\196\109\217\195" ..
		-- tex:"a9ac2374a3d659262870ec9380d5d7d9"; x:707.226013; y:-137.018311; z:-434.857574
		"\083\070\175\165\235\250\205\171\196\218\117\216\182\002\009\090\196\205\130\068\151\018\026\196\052\007\217\195" ..
		-- tex:"5346afa5ebfacdabc4da75d8b602095a"; x:1046.430298; y:-616.290527; z:-434.056305
		"\115\148\241\029\175\081\240\087\007\002\109\131\208\013\216\021\049\061\106\068\203\201\019\196\096\181\211\195" ..
		-- tex:"7394f11daf51f05707026d83d00dd815"; x:936.956177; y:-591.153076; z:-423.417023
		"\245\105\005\077\017\086\196\152\123\170\127\210\222\006\008\217\062\111\086\068\135\201\019\196\180\149\211\195" ..
		-- tex:"f569054d1156c4987baa7fd2de0608d9"; x:857.738220; y:-591.148926; z:-423.169586
		"\249\218\188\053\104\113\174\019\037\052\215\185\013\140\116\038\008\033\128\068\060\066\021\196\177\149\211\195" ..
		-- tex:"f9dabc356871ae132534d7b90d8c7426"; x:1025.032349; y:-597.034973; z:-423.169495
		"\113\204\090\129\065\185\220\001\180\100\236\017\103\067\129\220\223\179\078\068\066\210\010\196\176\149\211\195" ..
		-- tex:"71cc5a8141b9dc01b464ec11674381dc"; x:826.810547; y:-555.285339; z:-423.169464
		"\168\124\011\166\074\008\198\117\200\093\058\208\170\251\033\081\223\179\078\068\134\208\236\195\176\149\211\195" ..
		-- tex:"a87c0ba64a08c675c85d3ad0aafb2151"; x:826.810547; y:-473.629120; z:-423.169464
		"\220\011\173\075\097\120\184\090\001\189\222\200\231\063\144\009\205\007\131\068\235\250\163\195\029\233\204\195" ..
		-- tex:"dc0bad4b6178b85a01bddec8e73f9009"; x:1048.243896; y:-327.960327; z:-409.821228
		"\150\183\143\249\117\145\126\220\205\170\132\035\051\149\212\120\205\007\131\068\175\235\143\194\029\233\204\195" ..
		-- tex:"96b78ff975917edccdaa84233395d478"; x:1048.243896; y:-71.960327; z:-409.821228
		"\084\037\165\075\069\198\064\027\016\225\229\254\156\171\145\108\038\145\135\068\168\219\166\195\073\200\203\195" ..
		-- tex:"5425a54b45c6401b10e1e5fe9cab916c"; x:1084.536011; y:-333.716095; z:-407.564758
		"\065\254\023\043\170\040\051\175\063\165\163\110\081\245\160\037\212\007\140\068\206\211\245\194\188\189\200\195" ..
		-- tex:"41fe172baa2833af3fa5a36e51f5a025"; x:1120.244751; y:-122.913689; z:-401.482330
		"\214\216\112\180\228\102\125\061\186\016\081\024\141\226\241\155\076\194\132\068\204\211\245\194\063\132\200\195" ..
		-- tex:"d6d870b4e4667d3dba1051188de2f19b"; x:1062.071899; y:-122.913673; z:-401.033203
		"\201\185\148\100\230\210\164\020\146\176\082\169\094\014\198\064\209\186\148\068\135\229\167\195\199\176\199\195" ..
		-- tex:"c9b99464e6d2a41492b052a95e0ec640"; x:1189.838135; y:-335.793213; z:-399.381104
		"\049\037\094\064\040\006\113\251\209\074\047\231\084\131\008\158\209\186\148\068\200\172\122\195\251\174\199\195" ..
		-- tex:"31255e40280671fbd14a2fe75483089e"; x:1189.838135; y:-250.674942; z:-399.367065
		"\123\203\205\150\050\162\056\185\206\253\227\015\061\203\087\097\209\186\148\068\120\188\040\195\250\174\199\195" ..
		-- tex:"7bcbcd9632a238b9cefde30f3dcb5761"; x:1189.838135; y:-168.736221; z:-399.367035
		"\186\201\135\225\185\143\180\186\186\111\200\226\124\214\102\056\099\001\112\068\153\195\240\195\096\228\194\195" ..
		-- tex:"bac987e1b98fb4baba6fc8e27cd66638"; x:960.021729; y:-481.528137; z:-389.784210
		"\234\001\249\227\244\089\192\174\152\144\234\213\098\066\249\224\247\202\141\068\064\025\233\195\060\184\184\195" ..
		-- tex:"ea01f9e3f459c0ae9890ead56242f9e0"; x:1134.342773; y:-466.197296; z:-369.439362
		"\063\017\124\137\148\242\178\108\071\047\077\125\002\055\042\180\123\030\153\068\177\050\156\195\024\243\183\195" ..
		-- tex:"3f117c8994f2b26c472f4d7d02372ab4"; x:1224.952637; y:-312.396057; z:-367.899200
		"\018\066\210\173\183\044\027\198\006\177\150\044\202\040\211\125\124\030\153\068\111\232\071\195\244\077\183\195" ..
		-- tex:"1242d2adb72c1bc606b1962cca28d37d"; x:1224.952759; y:-199.907959; z:-366.609039
		"\119\191\233\063\057\090\183\135\043\148\124\017\030\011\115\058\250\155\134\068\143\138\159\194\071\197\179\195" ..
		-- tex:"77bfe93f395ab7872b947c111e0b733a"; x:1076.874390; y:-79.770630; z:-359.541260
		"\105\209\060\182\141\218\148\034\188\070\114\021\208\038\241\056\142\240\143\068\142\138\159\194\202\182\179\195" ..
		-- tex:"69d13cb68dda9422bc467215d026f138"; x:1151.517456; y:-79.770622; z:-359.428070
		"\020\079\094\000\007\165\130\148\232\004\220\207\062\246\145\018\214\085\050\068\019\026\250\194\141\157\175\195" ..
		-- tex:"144f5e0007a58294e804dccf3ef69112"; x:713.341248; y:-125.050934; z:-351.230896
		"\124\077\083\210\003\225\133\208\041\089\250\174\076\190\001\022\214\085\114\068\132\134\190\195\141\157\175\195" ..
		-- tex:"7c4d53d203e185d02959faae4cbe0116"; x:969.341248; y:-381.050934; z:-351.230896
		"\115\251\007\191\004\115\164\192\147\153\216\221\210\151\051\000\214\085\050\068\132\134\190\195\141\157\175\195" ..
		-- tex:"73fb07bf0473a4c09399d8ddd2973300"; x:713.341248; y:-381.050934; z:-351.230896
		"\023\001\119\221\226\056\095\024\061\085\059\020\086\012\083\011\214\085\114\068\019\026\250\194\141\157\175\195" ..
		-- tex:"170177dde2385f183d553b14560c530b"; x:969.341248; y:-125.050934; z:-351.230896
		"\134\203\123\072\250\123\119\074\063\128\110\018\110\035\216\074\078\139\033\068\031\128\248\194\050\134\162\195" ..
		-- tex:"86cb7b48fa7b774a3f806e126e23d84a"; x:646.176697; y:-124.250244; z:-325.048431
		"\167\128\039\096\159\224\051\097\181\002\206\061\142\118\182\139\119\152\133\068\171\174\243\195\203\116\159\195" ..
		-- tex:"a78027609fe03361b502ce3d8e76b68b"; x:1068.764648; y:-487.364624; z:-318.912476
		"\056\178\015\241\112\066\254\066\249\144\149\230\023\114\052\075\108\092\106\068\154\194\190\066\112\016\159\195" ..
		-- tex:"38b20ff17042fe42f99095e61772344b"; x:937.444153; y:95.380089; z:-318.128448
		"\132\127\111\196\130\069\235\075\178\121\139\233\128\018\222\175\105\227\200\067\191\080\246\193\145\199\158\195" ..
		-- tex:"847f6fc48245eb4bb2798be98012deaf"; x:401.776672; y:-30.789429; z:-317.559143
		"\148\061\040\064\028\150\171\247\145\250\053\121\091\059\151\012\105\227\200\067\011\101\143\195\145\199\158\195" ..
		-- tex:"943d28401c96abf791fa35795b3b970c"; x:401.776672; y:-286.789429; z:-317.559143
		"\007\247\127\241\252\134\151\094\018\190\101\143\034\158\150\110\141\183\128\068\019\064\143\194\022\140\157\195" ..
		-- tex:"07f77ff1fc86975e12be658f229e966e"; x:1029.736084; y:-71.625153; z:-315.094452
		"\208\165\244\117\220\113\214\044\001\048\193\129\250\132\255\122\152\242\113\068\085\191\005\195\070\085\157\195" ..
		-- tex:"d0a5f475dc71d62c0130c181fa84ff7a"; x:967.790588; y:-133.747406; z:-314.666229
		"\153\208\075\080\147\013\244\024\137\245\110\242\063\202\032\043\108\023\117\068\081\165\199\195\157\067\155\195",
		-- tex:"99d04b50930df41889f56ef23fca202b"; x:980.366028; y:-399.291565; z:-310.528259
	["Graveyard"] = 
		"\055\182\024\019\232\127\137\212\255\203\039\158\210\172\008\177\142\197\005\196\221\000\080\196\033\237\164\193" ..
		-- tex:"37b61813e87f89d4ffcb279ed2ac08b1"; x:-535.086853; y:-832.013550; z:-20.615788
		"\154\194\246\211\028\115\225\170\216\152\220\248\059\015\228\075\212\055\241\195\119\006\072\196\002\101\135\193" ..
		-- tex:"9ac2f6d31c73e1aad898dcf83b0fe44b"; x:-482.436188; y:-800.101074; z:-16.924322
		"\095\042\027\244\229\162\147\090\173\212\097\016\245\165\225\005\032\058\232\195\244\253\067\196\056\162\096\192" ..
		-- tex:"5f2a1bf4e5a2935aadd46110f5a5e105"; x:-464.454132; y:-783.968079; z:-3.509901
		"\017\055\066\060\173\010\043\148\071\072\146\199\026\143\122\068\230\011\244\195\218\160\083\196\013\162\096\192" ..
		-- tex:"1137423cad0a2b94474892c71a8f7a44"; x:-488.092987; y:-846.513367; z:-3.509891
		"\080\109\247\060\100\212\076\215\171\095\000\049\181\041\150\235\201\120\215\195\035\112\134\195\002\241\085\192" ..
		-- tex:"506df73c64d44cd7ab5f0031b52996eb"; x:-430.943665; y:-268.876099; z:-3.342835
		"\211\051\031\242\122\120\016\241\125\236\043\063\030\024\241\059\100\188\107\196\017\056\067\196\002\241\085\192" ..
		-- tex:"d3331ff27a7810f17dec2b3f1e18f13b"; x:-942.943665; y:-780.876099; z:-3.342835
		"\117\035\215\244\084\103\153\050\164\056\177\198\143\232\102\002\100\188\107\196\008\156\129\196\002\241\085\192" ..
		-- tex:"7523d7f454679932a438b1c68fe86602"; x:-942.943665; y:-1036.876099; z:-3.342835
		"\181\051\091\232\035\016\033\060\230\097\231\034\104\210\047\021\100\188\107\196\017\056\003\196\002\241\085\192" ..
		-- tex:"b5335be82310213ce661e72268d22f15"; x:-942.943665; y:-524.876099; z:-3.342835
		"\090\129\231\086\169\107\223\013\216\120\059\103\127\235\134\233\201\120\215\195\017\056\003\196\002\241\085\192" ..
		-- tex:"5a81e756a96bdf0dd8783b677feb86e9"; x:-430.943665; y:-524.876099; z:-3.342835
		"\135\011\215\146\207\032\196\019\115\143\003\094\170\099\014\058\100\188\043\196\008\156\129\196\002\241\085\192" ..
		-- tex:"870bd792cf20c413738f035eaa630e3a"; x:-686.943665; y:-1036.876099; z:-3.342835
		"\065\136\141\013\251\027\098\029\139\144\230\095\038\119\125\198\100\188\043\196\017\056\003\196\002\241\085\192" ..
		-- tex:"41888d0dfb1b621d8b90e65f26777dc6"; x:-686.943665; y:-524.876099; z:-3.342835
		"\119\141\042\143\127\093\062\188\180\136\202\052\244\177\139\108\100\188\043\196\017\056\067\196\002\241\085\192" ..
		-- tex:"778d2a8f7f5d3ebcb488ca34f4b18b6c"; x:-686.943665; y:-780.876099; z:-3.342835
		"\221\199\055\002\013\037\061\236\252\024\022\219\234\050\117\182\201\120\215\195\008\156\129\196\002\241\085\192" ..
		-- tex:"ddc737020d253decfc1816dbea3275b6"; x:-430.943665; y:-1036.876099; z:-3.342835
		"\183\228\160\031\232\055\053\252\036\093\244\247\204\017\125\149\100\188\043\196\035\112\134\195\002\241\085\192" ..
		-- tex:"b7e4a01fe83735fc245df4f7cc117d95"; x:-686.943665; y:-268.876099; z:-3.342835
		"\149\252\002\156\043\052\093\097\241\020\128\019\031\211\117\180\201\120\215\195\017\056\067\196\002\241\085\192" ..
		-- tex:"95fc029c2b345d61f11480131fd375b4"; x:-430.943665; y:-780.876099; z:-3.342835
		"\077\127\251\066\023\041\194\185\003\065\014\110\201\029\242\080\127\037\230\195\041\177\073\196\141\033\096\191" ..
		-- tex:"4d7ffb421729c2b903410e6ec91df250"; x:-460.292969; y:-806.768188; z:-0.875512
		"\215\013\178\143\235\195\197\255\022\223\054\142\004\100\157\173\039\171\003\196\135\093\082\196\210\064\045\191" ..
		-- tex:"d70db28febc3c5ff16df368e04649dad"; x:-526.674316; y:-841.461426; z:-0.676770
		"\170\059\189\083\212\006\231\190\022\002\209\198\114\203\106\076\181\152\214\195\131\127\050\195\008\034\088\065" ..
		-- tex:"aa3bbd53d406e7be1602d1c672cb6a4c"; x:-429.193054; y:-178.498108; z:13.508309
		"\162\223\212\154\235\004\201\172\070\175\236\238\046\110\069\069\018\166\183\195\144\037\044\195\008\034\088\065" ..
		-- tex:"a2dfd49aeb04c9ac46afecee2e6e4545"; x:-367.297455; y:-172.146744; z:13.508309
		"\224\227\233\023\176\053\130\233\067\187\155\130\003\198\220\104\173\073\153\195\243\037\044\195\008\034\088\065" ..
		-- tex:"e0e3e917b03582e943bb9b8203c6dc68"; x:-306.575623; y:-172.148254; z:13.508309
		"\217\060\162\108\230\035\134\061\012\243\003\010\159\215\204\224\190\055\195\195\143\037\044\195\008\034\088\065" ..
		-- tex:"d93ca26ce623863d0cf3030a9fd7cce0"; x:-390.435516; y:-172.146729; z:13.508309
		"\053\107\123\190\190\133\210\147\185\008\164\015\060\137\207\185\164\222\231\195\223\213\155\195\088\037\088\065" ..
		-- tex:"356b7bbebe85d293b908a40f3c89cfb9"; x:-463.739410; y:-311.670898; z:13.509118
		"\142\047\158\213\170\118\195\173\009\118\062\177\115\222\143\040\216\113\253\195\038\222\155\195\088\037\088\065" ..
		-- tex:"8e2f9ed5aa76c3ad09763eb173de8f28"; x:-506.889435; y:-311.735565; z:13.509118
		"\169\138\107\230\149\154\093\181\056\199\185\043\045\036\066\038\184\178\148\195\141\002\012\195\024\120\105\065" ..
		-- tex:"a98a6be6959a5db538c7b92b2d244226"; x:-297.396271; y:-140.009979; z:14.591821
		"\228\054\132\194\019\112\236\021\144\142\010\118\198\074\226\249\207\082\243\195\199\166\191\195\102\123\105\065" ..
		-- tex:"e43684c21370ec15908e0a76c64ae2f9"; x:-486.646973; y:-383.302979; z:14.592628
		"\197\230\088\226\223\008\243\248\215\194\064\214\203\013\098\215\118\015\239\195\072\163\136\195\009\125\109\065" ..
		-- tex:"c5e658e2df08f3f8d7c240d6cb0d62d7"; x:-478.120819; y:-273.275665; z:14.843027
		"\033\233\220\149\172\145\093\097\201\131\120\056\052\193\123\035\221\084\250\195\192\100\072\196\218\111\135\065" ..
		-- tex:"21e9dc95ac915d61c983783834c17b23"; x:-500.663025; y:-801.574280; z:16.929617
		"\031\129\019\238\043\136\221\124\050\068\129\064\098\078\208\227\054\137\140\195\145\095\127\194\200\058\218\065" ..
		-- tex:"1f8113ee2b88dd7c32448140624ed0e3"; x:-281.071991; y:-63.843330; z:27.278704
		"\116\087\106\139\163\161\209\161\171\099\161\106\217\180\168\217\019\218\146\195\008\163\167\194\200\058\218\065" ..
		-- tex:"74576a8ba3a1d1a1ab63a16ad9b4a8d9"; x:-293.703735; y:-83.818428; z:27.278704
		"\030\250\027\205\038\248\245\252\254\014\253\188\144\227\047\255\013\175\164\195\004\136\033\194\118\133\015\066" ..
		-- tex:"1efa1bcd26f8f5fcfe0efdbc90e32fff"; x:-329.367615; y:-40.382832; z:35.880337
		"\147\090\138\156\241\106\119\255\239\038\032\175\199\185\248\241\018\004\147\195\096\243\090\066\015\111\020\066" ..
		-- tex:"935a8a9cf16a77ffef2620afc7b9f8f1"; x:-294.031830; y:54.737675; z:37.108459
		"\197\067\105\047\203\095\120\140\249\236\240\137\088\101\154\139\047\097\157\195\209\115\156\065\203\037\021\066" ..
		-- tex:"c543692fcb5f788cf9ecf08958659a8b"; x:-314.759277; y:19.556553; z:37.286911
		"\185\184\249\177\177\139\250\237\124\185\239\083\112\090\195\188\150\233\010\195\201\122\072\065\017\050\021\066" ..
		-- tex:"b9b8f9b1b18bfaed7cb9ef53705ac3bc"; x:-138.912460; y:12.529978; z:37.298897
		"\122\183\254\176\044\232\216\234\081\212\129\208\062\072\032\048\150\233\010\195\114\225\010\194\017\050\021\066",
		-- tex:"7ab7feb02ce8d8ea51d481d03e482030"; x:-138.912460; y:-34.720165; z:37.298897
	["Gruul's Lair"] = 
		"\006\117\100\091\025\040\133\221\110\243\133\220\094\135\131\104\230\133\191\195\186\140\002\196\205\020\246\193" ..
		-- tex:"0675645b192885dd6ef385dc5e878368"; x:-383.046112; y:-522.198914; z:-30.760159
		"\215\045\007\208\077\097\026\155\059\047\205\231\253\040\185\068\155\023\254\194\117\025\133\195\205\020\246\193" ..
		-- tex:"d72d07d04d611a9b3b2fcde7fd28b944"; x:-127.046112; y:-266.198914; z:-30.760159
		"\214\042\161\236\034\194\248\205\175\112\092\021\005\012\136\111\155\023\254\194\186\140\002\196\205\020\246\193" ..
		-- tex:"d62aa1ec22c2f8cdaf705c15050c886f"; x:-127.046112; y:-522.198914; z:-30.760159
		"\176\032\118\149\160\067\189\190\163\097\208\014\071\141\111\186\230\133\191\195\117\025\133\195\205\020\246\193" ..
		-- tex:"b0207695a043bdbea361d00e478d6fba"; x:-383.046112; y:-266.198914; z:-30.760159
		"\252\109\137\054\138\221\142\186\190\052\072\160\083\230\124\138\248\066\021\196\034\217\091\196\199\082\181\193" ..
		-- tex:"fc6d89368add8ebabe3448a053e67c8a"; x:-597.046448; y:-879.392761; z:-22.665421
		"\014\159\168\025\025\107\146\224\185\099\121\065\118\198\149\104\248\066\021\196\034\217\027\196\199\082\181\193" ..
		-- tex:"0e9fa819196b92e0b963794176c69568"; x:-597.046448; y:-623.392761; z:-22.665421
		"\250\123\170\072\018\144\035\038\076\173\213\250\036\252\000\133\241\133\170\195\034\217\091\196\199\082\181\193" ..
		-- tex:"fa7baa48129023264cadd5fa24fc0085"; x:-341.046448; y:-879.392761; z:-22.665421
		"\047\252\242\073\208\135\151\130\239\146\229\199\093\056\250\075\086\068\068\195\183\004\135\065\139\029\155\193" ..
		-- tex:"2ffcf249d0879782ef92e5c75d38fa4b"; x:-196.266953; y:16.877304; z:-19.389427
		"\085\184\072\130\247\212\013\128\137\074\018\059\031\165\192\217\086\068\068\195\104\031\111\195\139\029\155\193" ..
		-- tex:"55b84882f7d40d80894a123b1fa5c0d9"; x:-196.266953; y:-239.122696; z:-19.389427
		"\096\134\069\217\242\213\234\010\027\223\166\191\158\104\214\029\177\132\156\195\043\218\066\196\136\031\211\192" ..
		-- tex:"608645d9f2d5ea0a1bdfa6bf9e68d61d"; x:-313.036682; y:-779.408936; z:-6.597600
		"\236\034\178\147\048\024\162\183\069\202\221\089\078\220\245\183\177\132\156\195\043\218\002\196\136\031\211\192",
		-- tex:"ec22b2933018a2b745cadd594edcf5b7"; x:-313.036682; y:-523.408936; z:-6.597600
	["Hellfire Ramparts"] = 
		"\052\244\063\080\147\139\071\129\221\201\011\142\118\253\035\038\255\255\223\069\255\255\007\198\000\000\000\000" ..
		-- tex:"34f43f50938b4781ddc90b8e76fd2326"; x:7168.000000; y:-8704.000000
		"\145\105\174\077\244\244\055\055\114\050\066\163\152\024\116\254\255\255\231\069\255\255\007\198\000\000\000\000",
		-- tex:"9169ae4df4f43737723242a3981874fe"; x:7424.000000; y:-8704.000000
	["Hyjal Summit"] = 
		"\205\061\108\194\124\069\084\007\253\208\061\245\043\070\043\051\255\255\007\070\255\255\159\197\000\000\000\000" ..
		-- tex:"cd3d6cc27c455407fdd03df52b462b33"; x:8704.000000; y:-5120.000000
		"\135\156\106\198\253\157\181\225\197\043\051\150\049\080\179\066\255\255\007\070\255\255\167\197\000\000\000\000" ..
		-- tex:"879c6ac6fd9db5e1c52b33963150b342"; x:8704.000000; y:-5376.000000
		"\142\248\031\176\128\224\104\119\097\209\106\091\003\118\237\145\255\255\007\070\255\255\175\197\000\000\000\000" ..
		-- tex:"8ef81fb080e0687761d16a5b0376ed91"; x:8704.000000; y:-5632.000000
		"\248\016\101\147\033\074\242\057\239\173\046\247\250\057\064\196\255\255\007\070\255\255\183\197\000\000\000\000" ..
		-- tex:"f8106593214af239efad2ef7fa3940c4"; x:8704.000000; y:-5888.000000
		"\037\100\024\050\063\167\093\228\077\235\178\235\254\182\124\149\255\255\007\070\255\255\191\197\000\000\000\000" ..
		-- tex:"256418323fa75de44debb2ebfeb67c95"; x:8704.000000; y:-6144.000000
		"\139\005\073\127\059\252\048\110\092\007\203\113\111\048\126\112\255\255\011\070\255\255\159\197\000\000\000\000" ..
		-- tex:"8b05497f3bfc306e5c07cb716f307e70"; x:8960.000000; y:-5120.000000
		"\169\252\042\250\199\130\121\087\128\114\191\143\226\167\097\126\255\255\011\070\255\255\167\197\000\000\000\000" ..
		-- tex:"a9fc2afac78279578072bf8fe2a7617e"; x:8960.000000; y:-5376.000000
		"\072\167\213\070\103\080\121\146\189\076\248\084\005\178\156\079\255\255\011\070\255\255\175\197\000\000\000\000" ..
		-- tex:"48a7d54667507992bd4cf85405b29c4f"; x:8960.000000; y:-5632.000000
		"\041\082\015\106\125\075\123\050\130\215\052\246\007\221\171\104\255\255\011\070\255\255\183\197\000\000\000\000" ..
		-- tex:"29520f6a7d4b7b3282d734f607ddab68"; x:8960.000000; y:-5888.000000
		"\139\244\099\214\177\180\159\244\041\232\062\189\106\162\051\104\255\255\011\070\255\255\191\197\000\000\000\000" ..
		-- tex:"8bf463d6b1b49ff429e83ebd6aa23368"; x:8960.000000; y:-6144.000000
		"\056\196\208\204\048\250\118\248\147\183\111\180\232\066\077\136\255\255\015\070\255\255\159\197\000\000\000\000" ..
		-- tex:"38c4d0cc30fa76f893b76fb4e8424d88"; x:9216.000000; y:-5120.000000
		"\248\060\169\176\100\199\145\084\059\040\163\026\254\051\210\071\255\255\015\070\255\255\167\197\000\000\000\000" ..
		-- tex:"f83ca9b064c791543b28a31afe33d247"; x:9216.000000; y:-5376.000000
		"\070\091\212\133\223\070\176\226\014\173\179\146\254\241\063\078\255\255\015\070\255\255\175\197\000\000\000\000" ..
		-- tex:"465bd485df46b0e20eadb392fef13f4e"; x:9216.000000; y:-5632.000000
		"\053\042\224\158\119\015\108\056\032\011\129\192\141\249\208\052\255\255\015\070\255\255\183\197\000\000\000\000" ..
		-- tex:"352ae09e770f6c38200b81c08df9d034"; x:9216.000000; y:-5888.000000
		"\151\227\094\172\097\042\173\010\237\053\107\202\244\087\147\118\255\255\015\070\255\255\191\197\000\000\000\000" ..
		-- tex:"97e35eac612aad0aed356bcaf4579376"; x:9216.000000; y:-6144.000000
		"\232\061\192\163\236\031\194\136\185\233\076\194\199\240\190\169\255\255\019\070\255\255\159\197\000\000\000\000" ..
		-- tex:"e83dc0a3ec1fc288b9e94cc2c7f0bea9"; x:9472.000000; y:-5120.000000
		"\074\130\107\204\189\101\187\222\229\165\164\174\023\004\146\107\255\255\019\070\255\255\167\197\000\000\000\000" ..
		-- tex:"4a826bccbd65bbdee5a5a4ae1704926b"; x:9472.000000; y:-5376.000000
		"\074\104\127\199\196\117\127\130\119\003\075\040\211\241\084\010\255\255\019\070\255\255\175\197\000\000\000\000" ..
		-- tex:"4a687fc7c4757f8277034b28d3f1540a"; x:9472.000000; y:-5632.000000
		"\006\097\079\164\015\234\239\249\151\087\079\029\135\110\215\079\255\255\019\070\255\255\183\197\000\000\000\000" ..
		-- tex:"06614fa40feaeff997574f1d876ed74f"; x:9472.000000; y:-5888.000000
		"\118\063\027\113\046\209\246\255\051\020\052\026\016\246\248\056\255\255\019\070\255\255\191\197\000\000\000\000" ..
		-- tex:"763f1b712ed1f6ff3314341a10f6f838"; x:9472.000000; y:-6144.000000
		"\151\012\074\140\070\144\113\210\229\079\162\107\117\219\082\202\255\255\023\070\255\255\159\197\000\000\000\000" ..
		-- tex:"970c4a8c469071d2e54fa26b75db52ca"; x:9728.000000; y:-5120.000000
		"\173\083\203\175\207\036\221\066\207\167\056\209\210\106\170\044\255\255\023\070\255\255\167\197\000\000\000\000" ..
		-- tex:"ad53cbafcf24dd42cfa738d1d26aaa2c"; x:9728.000000; y:-5376.000000
		"\136\254\210\064\089\148\141\161\149\042\062\148\009\236\235\246\255\255\023\070\255\255\175\197\000\000\000\000" ..
		-- tex:"88fed24059948da1952a3e9409ecebf6"; x:9728.000000; y:-5632.000000
		"\099\223\159\238\254\101\123\243\010\135\092\163\225\254\007\040\255\255\023\070\255\255\183\197\000\000\000\000" ..
		-- tex:"63df9feefe657bf30a875ca3e1fe0728"; x:9728.000000; y:-5888.000000
		"\158\224\060\158\088\104\097\096\121\066\102\130\077\237\083\243\255\255\023\070\255\255\191\197\000\000\000\000" ..
		-- tex:"9ee03c9e58686160794266824ded53f3"; x:9728.000000; y:-6144.000000
		"\252\222\022\157\021\060\025\026\028\106\092\245\123\184\239\054\255\255\027\070\255\255\159\197\000\000\000\000" ..
		-- tex:"fcde169d153c191a1c6a5cf57bb8ef36"; x:9984.000000; y:-5120.000000
		"\180\071\185\048\226\207\121\162\104\138\118\050\054\205\155\117\255\255\027\070\255\255\167\197\000\000\000\000" ..
		-- tex:"b447b930e2cf79a2688a763236cd9b75"; x:9984.000000; y:-5376.000000
		"\078\174\196\141\135\199\128\058\027\191\044\220\228\022\079\183\255\255\027\070\255\255\175\197\000\000\000\000" ..
		-- tex:"4eaec48d87c7803a1bbf2cdce4164fb7"; x:9984.000000; y:-5632.000000
		"\104\244\095\106\101\220\028\072\223\098\091\112\045\136\230\061\255\255\027\070\255\255\183\197\000\000\000\000" ..
		-- tex:"68f45f6a65dc1c48df625b702d88e63d"; x:9984.000000; y:-5888.000000
		"\082\018\248\050\146\066\161\054\083\149\167\011\020\245\044\096\255\255\027\070\255\255\191\197\000\000\000\000",
		-- tex:"5212f8329242a1365395a70b14f52c60"; x:9984.000000; y:-6144.000000
	["Karazhan"] = 
		"\184\009\049\021\146\044\158\125\152\055\023\237\089\007\105\016\149\137\212\195\122\233\144\195\008\166\214\192" ..
		-- tex:"b8093115922c9e7d983717ed59076910"; x:-425.074890; y:-289.824066; z:-6.707768
		"\019\078\186\087\153\108\234\050\164\028\037\231\189\173\029\036\043\019\041\195\122\233\144\195\008\166\214\192" ..
		-- tex:"134eba57996cea32a41c25e7bdad1d24"; x:-169.074890; y:-289.824066; z:-6.707768
		"\165\052\135\029\224\155\081\180\113\052\106\254\162\041\124\110\043\019\041\195\215\075\007\194\008\166\214\192" ..
		-- tex:"a534871de09b51b471346afea2297c6e"; x:-169.074890; y:-33.824066; z:-6.707768
		"\200\028\232\071\161\252\036\001\203\120\101\084\134\144\165\241\017\190\084\066\136\060\099\194\250\201\247\191" ..
		-- tex:"c81ce847a1fc2401cb7865548690a5f1"; x:53.185616; y:-56.809116; z:-1.935851
		"\087\075\081\205\017\180\044\235\044\193\066\095\083\099\126\145\250\103\006\195\200\054\220\195\218\124\189\063" ..
		-- tex:"574b51cd11b42ceb2cc1425f53637e91"; x:-134.406174; y:-440.428009; z:1.480373
		"\065\011\043\145\060\134\161\172\114\110\171\017\240\174\164\064\114\181\030\194\005\033\050\194\198\249\235\063" ..
		-- tex:"410b2b913c86a1ac726eab11f0aea440"; x:-39.677197; y:-44.532249; z:1.843560
		"\231\069\040\120\106\253\130\034\136\015\066\017\020\128\127\000\074\219\163\193\185\227\153\066\205\133\022\064" ..
		-- tex:"e74528786afd8222880f421114807f00"; x:-20.482077; y:76.944778; z:2.351917
		"\188\043\253\181\047\185\157\024\027\079\118\065\143\047\101\251\048\021\192\194\145\015\205\194\072\108\032\065" ..
		-- tex:"bc2bfdb52fb99d181b4f76418f2f65fb"; x:-96.041389; y:-102.530411; z:10.026437
		"\132\255\187\001\046\236\190\144\197\120\195\069\248\130\190\067\045\109\156\195\157\144\138\195\224\076\017\066" ..
		-- tex:"84ffbb012eecbe90c578c345f882be43"; x:-312.852966; y:-277.129822; z:36.325077
		"\166\137\215\041\006\202\104\164\001\132\010\172\098\212\001\004\045\109\156\195\223\009\169\193\224\076\017\066" ..
		-- tex:"a689d72906ca68a401840aac62d40104"; x:-312.852966; y:-21.129822; z:36.325077
		"\069\014\253\235\203\021\056\079\028\031\232\227\156\085\141\033\111\105\099\194\157\144\138\195\224\076\017\066" ..
		-- tex:"450efdebcb15384f1c1fe8e39c558d21"; x:-56.852966; y:-277.129822; z:36.325077
		"\015\202\203\069\035\155\044\024\006\179\052\164\138\163\225\134\168\098\227\193\046\107\000\065\234\153\080\066" ..
		-- tex:"0fcacb45239b2c1806b334a48aa3e186"; x:-28.423174; y:8.026168; z:52.150311
		"\166\231\185\181\045\129\233\150\130\083\150\222\165\048\050\065\138\208\247\194\136\062\230\194\205\248\092\066" ..
		-- tex:"a6e7b9b52d81e996825396dea5303241"; x:-123.907310; y:-115.122139; z:55.242973
		"\182\066\229\205\024\158\197\153\093\048\219\145\093\223\208\253\235\129\120\066\034\115\167\195\027\190\100\066" ..
		-- tex:"b642e5cd189ec5995d30db915ddfd0fd"; x:62.126877; y:-334.899506; z:57.185654
		"\155\230\082\113\099\063\244\184\013\117\070\052\229\138\044\205\132\223\065\195\034\115\167\195\027\190\100\066" ..
		-- tex:"9be65271633ff4b80d754634e58a2ccd"; x:-193.873123; y:-334.899506; z:57.185654
		"\210\015\145\203\019\065\086\107\036\025\160\206\183\108\049\061\016\112\012\067\082\045\019\196\020\190\109\066" ..
		-- tex:"d20f91cb1341566b2419a0ceb76c313d"; x:140.437752; y:-588.708191; z:59.435627
		"\179\140\167\176\141\178\091\165\044\036\150\205\074\204\131\022\222\031\231\194\165\090\166\195\020\190\109\066" ..
		-- tex:"b38ca7b08db25ba52c2496cd4acc8316"; x:-115.562248; y:-332.708191; z:59.435627
		"\070\218\233\252\220\192\200\095\052\047\032\055\248\101\084\193\222\031\231\194\082\045\019\196\020\190\109\066" ..
		-- tex:"46dae9fcdcc0c85f342f2037f86554c1"; x:-115.562248; y:-588.708191; z:59.435627
		"\202\196\043\109\060\152\253\081\149\121\127\170\076\093\192\191\228\228\235\066\003\153\010\196\022\190\109\066" ..
		-- tex:"cac42b6d3c98fd5195797faa4c5dc0bf"; x:117.947060; y:-554.390869; z:59.435635
		"\082\227\131\031\244\051\126\021\031\207\195\243\111\011\032\151\005\253\081\195\227\199\202\195\036\197\110\066" ..
		-- tex:"52e3831ff4337e151fcfc3f36f0b2097"; x:-209.988373; y:-405.561646; z:59.692524
		"\033\032\199\105\042\079\148\232\066\253\162\076\205\214\124\124\087\203\054\065\047\011\041\196\011\032\163\066" ..
		-- tex:"2120c7692a4f94e842fda24ccdd67c7c"; x:11.424644; y:-676.174805; z:81.562592
		"\165\067\084\240\139\182\220\231\113\142\118\071\106\110\038\167\170\138\207\066\034\110\028\196\098\042\167\066" ..
		-- tex:"a54354f08bb6dce7718e76476a6e26a7"; x:103.770836; y:-625.720886; z:83.582787
		"\178\073\098\170\006\230\065\122\194\071\242\203\095\006\230\076\088\137\219\066\015\039\240\195\120\052\167\066" ..
		-- tex:"b24962aa06e6417ac247f2cb5f06e64c"; x:109.768257; y:-480.305176; z:83.602486
		"\185\223\047\005\210\139\091\251\230\100\064\019\054\005\011\146\125\209\247\195\054\122\069\195\034\072\167\066" ..
		-- tex:"b9df2f05d28b5bfbe664401336050b92"; x:-495.636658; y:-197.477402; z:83.640892
		"\151\161\017\121\066\134\107\149\047\140\110\103\253\210\070\096\085\197\205\195\008\099\153\195\154\255\168\066" ..
		-- tex:"97a1117942866b952f8c6e67fdd24660"; x:-411.541687; y:-306.773712; z:84.499229
		"\213\234\206\058\095\240\242\101\029\190\187\101\180\139\064\249\192\245\062\192\191\037\166\192\009\012\171\066" ..
		-- tex:"d5eace3a5ff0f2651dbebb65b48b40f9"; x:-2.983750; y:-5.192108; z:85.523514
		"\082\186\165\141\046\169\236\063\115\099\165\077\089\169\046\157\225\236\161\066\079\138\030\194\166\016\171\066" ..
		-- tex:"52baa58d2ea9ec3f7363a54d59a92e9d"; x:80.962662; y:-39.635071; z:85.532524
		"\071\209\055\071\016\249\236\193\108\122\173\001\182\208\135\141\027\193\070\066\056\220\054\194\206\044\171\066" ..
		-- tex:"47d1374710f9ecc16c7aad01b6d0878d"; x:49.688583; y:-45.715061; z:85.587517
		"\017\046\059\214\050\234\063\067\082\191\049\063\241\047\070\177\113\187\238\194\185\097\179\195\156\224\173\066" ..
		-- tex:"112e3bd632ea3f4352bf313ff12f46b1"; x:-119.366104; y:-358.763489; z:86.938698
		"\229\138\060\173\025\113\116\217\212\245\155\248\024\022\093\051\222\038\185\195\194\010\203\195\255\239\173\066" ..
		-- tex:"e58a3cad197174d9d4f59bf818165d33"; x:-370.303680; y:-406.084076; z:86.968750
		"\091\196\183\108\010\151\115\204\005\004\106\070\010\177\244\176\097\141\182\195\050\249\165\195\190\244\173\066" ..
		-- tex:"5bc4b76c0a9773cc05046a460ab1f4b0"; x:-365.104553; y:-331.946869; z:86.978020
		"\255\166\064\219\214\002\208\128\211\223\098\214\194\005\101\092\102\065\223\195\155\095\210\194\162\249\173\066" ..
		-- tex:"ffa640dbd602d080d3df62d6c205655c"; x:-446.510956; y:-105.186737; z:86.987572
		"\119\002\038\044\242\060\137\125\181\085\006\068\037\075\213\240\178\010\089\195\213\046\143\195\116\252\173\066" ..
		-- tex:"7702262cf23c897db5550644254bd5f0"; x:-217.041794; y:-286.365906; z:86.993080
		"\102\249\021\053\011\092\163\001\244\036\230\087\022\125\104\244\240\018\087\194\198\070\144\194\239\126\178\066" ..
		-- tex:"66f915350b5ca301f424e657167d68f4"; x:-53.768497; y:-72.138237; z:89.247925
		"\196\038\238\221\186\087\072\253\162\131\116\124\119\082\224\156\117\025\244\194\056\040\014\194\248\134\178\066" ..
		-- tex:"c426eeddba5748fda283747c7752e09c"; x:-122.049728; y:-35.539280; z:89.263618
		"\109\211\114\025\019\095\144\053\242\255\139\194\204\180\162\155\046\156\210\194\174\087\246\194\081\096\232\066" ..
		-- tex:"6dd37219135f9035f2ff8bc2ccb4a29b"; x:-105.305046; y:-123.171257; z:116.188126
		"\197\173\175\142\239\152\186\046\181\128\251\085\050\098\020\247\252\059\159\194\046\200\091\195\065\039\002\067" ..
		-- tex:"c5adaf8eef98ba2eb580fb55326214f7"; x:-79.617165; y:-219.781967; z:130.153351
		"\169\241\027\145\086\075\242\113\071\148\254\145\057\144\227\041\119\075\213\193\156\152\150\195\163\196\023\067" ..
		-- tex:"a9f11b91564bf2714794fe913990e329"; x:-26.661850; y:-301.192291; z:151.768127
		"\054\032\135\048\081\043\241\243\072\161\038\208\233\223\082\222\222\051\140\194\072\106\145\194\209\199\023\067" ..
		-- tex:"36208730512bf1f348a126d0e9df52de"; x:-70.101311; y:-72.707588; z:151.780548
		"\134\037\216\089\060\165\253\173\141\144\187\026\071\221\123\196\034\046\148\067\151\161\022\067\099\205\045\067" ..
		-- tex:"8625d8593ca5fdad8d90bb1a47dd7bc4"; x:296.360443; y:150.631226; z:173.802307
		"\135\233\169\247\068\187\054\233\179\142\206\100\062\050\243\230\034\046\148\067\203\080\203\067\099\205\045\067" ..
		-- tex:"87e9a9f744bb36e9b38ece643e32f3e6"; x:296.360443; y:406.631226; z:173.802307
		"\154\102\094\028\212\109\181\089\234\008\151\099\109\186\117\013\017\023\074\068\203\080\203\067\099\205\045\067" ..
		-- tex:"9a665e1cd46db559ea0897636dba750d"; x:808.360443; y:406.631226; z:173.802307
		"\240\090\114\184\040\075\066\166\008\116\154\015\072\150\239\004\023\113\033\066\203\080\203\067\099\205\045\067" ..
		-- tex:"f05a72b8284b42a608749a0f4896ef04"; x:40.360443; y:406.631226; z:173.802307
		"\005\135\170\234\123\102\113\061\212\108\000\020\025\101\028\118\034\046\148\067\207\188\210\194\099\205\045\067" ..
		-- tex:"0587aaea7b66713dd46c001419651c76"; x:296.360443; y:-105.368774; z:173.802307
		"\100\170\189\205\108\119\137\014\125\154\053\185\120\249\019\115\023\113\033\066\151\161\022\067\099\205\045\067" ..
		-- tex:"64aabdcd6c77890e7d9a35b978f91373"; x:40.360443; y:150.631226; z:173.802307
		"\213\025\150\186\239\036\136\130\234\034\173\126\211\160\006\071\017\023\010\068\051\175\180\195\099\205\045\067" ..
		-- tex:"d51996baef248882ea22ad7ed3a00647"; x:552.360443; y:-361.368774; z:173.802307
		"\106\110\114\231\001\237\237\149\165\182\030\071\202\201\220\114\017\023\010\068\207\188\210\194\099\205\045\067" ..
		-- tex:"6a6e72e701eded95a5b61e47cac9dc72"; x:552.360443; y:-105.368774; z:173.802307
		"\146\233\105\211\166\186\248\016\143\108\065\059\034\230\057\032\023\113\033\066\207\188\210\194\099\205\045\067" ..
		-- tex:"92e969d3a6baf8108f6c413b22e63920"; x:40.360443; y:-105.368774; z:173.802307
		"\080\160\021\238\104\004\156\131\018\025\027\129\112\127\156\114\017\023\074\068\151\161\022\067\099\205\045\067" ..
		-- tex:"50a015ee68049c8312191b81707f9c72"; x:808.360443; y:150.631226; z:173.802307
		"\188\003\140\185\166\201\249\041\157\187\068\111\162\063\040\179\017\023\010\068\151\161\022\067\099\205\045\067" ..
		-- tex:"bc038cb9a6c9f9299dbb446fa23f28b3"; x:552.360443; y:150.631226; z:173.802307
		"\023\133\116\158\078\198\043\192\169\122\152\242\215\029\091\169\017\023\074\068\207\188\210\194\099\205\045\067" ..
		-- tex:"1785749e4ec62bc0a97a98f2d71d5ba9"; x:808.360443; y:-105.368774; z:173.802307
		"\109\156\073\178\081\071\028\184\138\210\144\103\034\197\245\054\017\023\010\068\203\080\203\067\099\205\045\067" ..
		-- tex:"6d9c49b251471cb88ad2906722c5f536"; x:552.360443; y:406.631226; z:173.802307
		"\149\104\012\001\177\033\169\059\235\085\021\173\165\038\166\232\017\023\074\068\051\175\180\195\099\205\045\067" ..
		-- tex:"95680c01b121a93beb5515ada526a6e8"; x:808.360443; y:-361.368774; z:173.802307
		"\073\221\184\038\061\145\191\072\186\085\116\171\226\086\098\164\023\113\033\066\051\175\180\195\099\205\045\067" ..
		-- tex:"49ddb8263d91bf48ba5574abe25662a4"; x:40.360443; y:-361.368774; z:173.802307
		"\105\043\255\023\178\204\203\116\080\045\091\010\201\207\217\197\034\046\148\067\051\175\180\195\099\205\045\067" ..
		-- tex:"692bff17b2cccb74502d5b0ac9cfd9c5"; x:296.360443; y:-361.368774; z:173.802307
		"\039\138\213\047\023\227\218\228\027\195\255\213\184\075\137\204\086\242\034\067\150\109\184\193\172\200\086\067" ..
		-- tex:"278ad52f17e3dae41bc3ffd5b84b89cc"; x:162.946640; y:-23.053511; z:214.783890
		"\210\151\012\228\010\225\068\092\129\032\074\249\138\223\117\091\246\111\009\194\034\171\000\195\246\081\096\067" ..
		-- tex:"d2970ce40ae1445c81204af98adf755b"; x:-34.359341; y:-128.668503; z:224.320175
		"\032\050\173\000\051\191\080\034\117\197\005\147\226\055\144\046\210\063\186\193\017\175\134\195\099\089\097\067" ..
		-- tex:"2032ad0033bf502275c50593e237902e"; x:-23.281164; y:-269.367737; z:225.349182
		"\187\108\017\042\146\149\171\169\205\029\017\167\221\086\196\200\111\173\003\067\204\098\114\195\043\034\103\067" ..
		-- tex:"bb6c112a9295aba9cd1d11a7dd56c4c8"; x:131.677490; y:-242.385941; z:231.133484
		"\133\249\176\195\007\104\150\164\120\220\188\056\008\072\094\132\170\130\017\068\175\037\009\195\194\143\130\067" ..
		-- tex:"85f9b0c3076896a478dcbc3808485e84"; x:582.041687; y:-137.147217; z:261.123138
		"\171\227\138\113\132\232\242\201\040\028\252\098\165\232\190\177\225\037\226\067\007\204\052\195\016\152\130\067" ..
		-- tex:"abe38a7184e8f2c9281cfc62a5e8beb1"; x:452.295959; y:-180.796997; z:261.188019
		"\040\072\199\231\049\192\179\189\027\121\156\186\213\243\228\181\243\051\199\067\064\150\047\195\128\121\152\067" ..
		-- tex:"2848c7e731c0b3bd1b799cbad5f3e4b5"; x:398.405884; y:-175.586929; z:304.949249
		"\216\202\129\163\169\223\049\122\205\238\102\181\095\126\163\127\099\220\016\068\122\121\244\194\059\052\162\067" ..
		-- tex:"d8ca81a3a9df317acdee66b55f7ea37f"; x:579.443604; y:-122.237267; z:324.408081
		"\043\214\223\079\076\071\173\166\053\061\143\207\004\025\241\100\232\077\096\066\175\243\042\195\233\253\171\067" ..
		-- tex:"2bd6df4f4c47ada6353d8fcf0419f164"; x:56.076084; y:-170.951904; z:343.983704
		"\114\175\087\197\171\210\249\031\154\179\172\185\144\072\002\170\193\037\189\067\054\054\057\066\011\062\175\067" ..
		-- tex:"72af57c5abd2f91f9ab3acb9904802aa"; x:378.294983; y:46.302944; z:350.484741
		"\146\202\216\090\247\027\138\041\210\158\128\111\032\159\251\232\062\117\032\194\008\102\065\194\235\182\181\067" ..
		-- tex:"92cad85af71b8a29d29e806f209ffbe8"; x:-40.114498; y:-48.349644; z:363.429077
		"\174\035\189\022\119\102\048\234\239\202\250\123\180\255\183\042\064\204\016\067\247\189\138\065\110\070\183\067" ..
		-- tex:"ae23bd16776630eaefcafa7bb4ffb72a"; x:144.797867; y:17.342758; z:366.550262
		"\163\076\194\237\101\166\056\004\181\252\252\208\186\034\231\202\241\038\008\193\154\096\083\195\236\148\183\067" ..
		-- tex:"a34cc2ed65a63804b5fcfcd0ba22e7ca"; x:-8.509508; y:-211.377365; z:367.163483
		"\115\097\125\040\006\174\237\191\127\071\097\235\203\082\211\244\052\211\019\194\045\132\009\195\236\148\183\067" ..
		-- tex:"73617d2806aeedbf7f4761ebcb52d3f4"; x:-36.956257; y:-137.516327; z:367.163483
		"\109\238\120\188\218\167\191\207\040\207\022\009\117\005\152\162\056\213\015\068\021\234\017\195\015\067\192\067" ..
		-- tex:"6dee78bcdaa7bfcf28cf1609750598a2"; x:575.331604; y:-145.914398; z:384.523926
		"\176\120\216\042\026\107\125\079\060\167\104\055\046\032\140\113\187\147\152\066\067\063\105\195\071\053\196\067" ..
		-- tex:"b078d82a1a6b7d4f3ca768372e208c71"; x:76.288544; y:-233.247131; z:392.416260
		"\015\019\035\123\214\198\085\050\143\175\005\127\086\059\187\247\091\040\142\066\042\122\030\195\072\053\196\067" ..
		-- tex:"0f13237bd6c655328faf057f563bbbf7"; x:71.078827; y:-158.477219; z:392.416290
		"\104\124\082\153\252\200\184\055\006\173\243\003\070\245\253\119\110\090\105\194\146\002\053\195\203\119\198\067" ..
		-- tex:"687c5299fcc8b83706adf30346f5fd77"; x:-58.338314; y:-181.010056; z:396.935913
		"\121\032\254\150\060\148\042\085\171\065\121\080\161\128\237\130\104\087\076\194\234\134\129\194\011\132\199\067" ..
		-- tex:"7920fe963c942a55ab417950a180ed82"; x:-51.085361; y:-64.763512; z:399.031616
		"\069\011\109\023\101\172\175\228\075\243\227\111\167\036\078\033\166\158\124\193\088\158\126\194\198\005\216\067" ..
		-- tex:"450b6d1765acafe44bf3e36fa7244e21"; x:-15.788733; y:-63.654636; z:432.045135
		"\239\150\016\244\099\127\092\159\007\177\071\006\087\221\188\065\033\212\237\193\025\196\150\194\129\009\224\067" ..
		-- tex:"ef9610f4637f5c9f07b1470657ddbc41"; x:-29.728580; y:-75.383011; z:448.074280
		"\175\114\012\135\169\060\026\015\109\229\241\199\159\205\226\075\012\142\075\194\169\213\191\194\167\059\226\067" ..
		-- tex:"af720c87a93c1a0f6de5f1c79fcde24b"; x:-50.888721; y:-95.917313; z:452.466064
		"\237\228\152\011\098\231\221\255\189\217\180\183\177\159\246\131\204\158\104\194\235\038\187\194\167\059\226\067" ..
		-- tex:"ede4980b62e7ddffbdd9b4b7b19ff683"; x:-58.155079; y:-93.576019; z:452.466064
		"\090\241\140\109\071\061\250\192\011\240\050\078\044\152\126\105\058\145\125\193\214\237\158\194\167\059\226\067" ..
		-- tex:"5af18c6d473dfac00bf0324e2c987e69"; x:-15.847957; y:-79.464531; z:452.466064
		"\225\033\134\152\251\179\118\164\230\025\046\153\184\189\004\008\088\070\024\194\070\094\197\194\168\059\226\067" ..
		-- tex:"e1218698fbb376a4e6192e99b8bd0408"; x:-38.068699; y:-98.684135; z:452.466095
		"\226\106\045\005\217\119\012\174\000\054\017\182\133\079\218\212\055\126\138\194\108\090\176\194\168\059\226\067" ..
		-- tex:"e26a2d05d9770cae003611b6854fdad4"; x:-69.246521; y:-88.176613; z:452.466095
		"\015\115\131\173\238\037\080\114\007\013\171\038\238\185\075\010\168\020\190\193\088\201\187\194\168\059\226\067" ..
		-- tex:"0f7383adee255072070dab26eeb94b0a"; x:-23.760088; y:-93.893257; z:452.466095
		"\247\098\236\159\053\131\071\011\156\172\210\083\029\129\061\089\105\237\146\193\201\058\173\194\168\059\226\067" ..
		-- tex:"f762ec9f3583470b9cacd2531d813d59"; x:-18.365925; y:-86.614822; z:452.466095
		"\008\177\146\230\079\083\158\237\081\100\240\065\138\009\144\130\232\222\057\068\233\130\001\196\160\176\227\067" ..
		-- tex:"08b192e64f539eed5164f0418a099082"; x:743.482971; y:-518.045532; z:455.379913
		"\018\106\062\185\057\019\116\131\229\030\182\052\236\219\186\122\209\189\243\067\211\005\131\195\160\176\227\067" ..
		-- tex:"126a3eb939137483e51eb634ecdbba7a"; x:487.482971; y:-262.045532; z:455.379913
		"\144\083\045\159\090\037\147\096\108\011\235\019\247\138\094\243\209\189\243\067\233\130\001\196\160\176\227\067" ..
		-- tex:"90532d9f5a2593606c0beb13f78a5ef3"; x:487.482971; y:-518.045532; z:455.379913
		"\203\200\253\047\067\175\220\214\052\048\183\228\233\215\235\059\232\222\057\068\211\005\131\195\160\176\227\067" ..
		-- tex:"cbc8fd2f43afdcd63430b7e4e9d7eb3b"; x:743.482971; y:-262.045532; z:455.379913
		"\185\043\216\020\082\126\022\097\213\187\217\071\092\091\066\238\101\082\026\068\053\220\064\195\035\144\229\067",
		-- tex:"b92bd814527e1661d5bbd9475c5b42ee"; x:617.287476; y:-192.860199; z:459.126099
	["Library"] = 
		"\080\085\073\197\033\069\137\032\208\150\046\119\087\140\029\020\093\175\164\195\221\026\139\194\096\211\015\066" ..
		-- tex:"505549c521458920d0962e77578c1d14"; x:-329.370056; y:-69.552475; z:35.956425
		"\034\139\200\037\069\209\231\103\207\193\162\232\121\210\207\072\013\175\164\195\023\085\028\194\096\211\015\066" ..
		-- tex:"228bc82545d1e767cfc1a2e879d2cf48"; x:-329.367615; y:-39.083099; z:35.956425
		"\155\054\089\142\127\200\024\156\027\030\225\007\076\223\235\022\208\031\188\194\122\145\231\067\076\169\019\066" ..
		-- tex:"9b36598e7fc8189c1b1ee1074cdfeb16"; x:-94.062141; y:463.136566; z:36.915333
		"\245\164\128\196\050\057\174\077\145\049\059\097\252\027\000\087\019\218\146\195\007\163\167\194\142\173\019\066" ..
		-- tex:"f5a480c43239ae4d91313b61fc1b0057"; x:-293.703735; y:-83.818420; z:36.919491
		"\008\216\140\097\065\251\038\141\126\121\077\220\182\007\209\153\157\231\154\195\114\080\140\067\192\235\019\066" ..
		-- tex:"08d88c6141fb268d7e794ddcb607d199"; x:-309.809509; y:280.628510; z:36.980228
		"\142\093\031\072\136\209\172\243\083\045\161\151\075\029\189\043\157\231\154\195\112\098\240\067\192\235\019\066" ..
		-- tex:"8e5d1f4888d1acf3532da1974b1dbd2b"; x:-309.809509; y:480.769073; z:36.980228
		"\159\122\090\080\009\127\250\146\159\064\138\118\077\156\104\185\236\255\229\194\083\151\110\067\013\003\020\066" ..
		-- tex:"9f7a5a50097ffa929f408a764d9c68b9"; x:-114.999855; y:238.591125; z:37.002983
		"\052\088\190\127\104\174\199\041\076\032\082\210\205\011\078\148\029\120\017\195\187\052\121\067\013\003\020\066" ..
		-- tex:"3458be7f68aec7294c2052d2cd0b4e94"; x:-145.469208; y:249.205994; z:37.002983
		"\058\172\147\233\168\134\151\000\233\056\174\231\216\219\186\018\063\214\093\195\118\217\114\067\016\003\020\066" ..
		-- tex:"3aac93e9a8869700e938aee7d8dbba12"; x:-221.836914; y:242.849472; z:37.002995
		"\052\138\139\243\124\014\003\005\068\092\003\197\219\080\047\071\179\240\047\195\187\052\121\067\017\003\020\066" ..
		-- tex:"348a8bf37c0e0305445c03c5db502f47"; x:-175.940247; y:249.205994; z:37.002998
		"\223\226\236\188\159\075\135\229\233\028\114\178\252\233\043\150\092\031\036\195\154\199\236\067\064\005\020\066" ..
		-- tex:"dfe2ecbc9f4b87e5e91c72b2fce92b96"; x:-164.122513; y:473.559418; z:37.005131
		"\166\213\174\239\137\142\252\134\174\020\034\167\229\007\043\221\196\033\158\195\038\195\170\066\255\005\020\066" ..
		-- tex:"a6d5aeef898efc86ae1422a7e5072bdd"; x:-316.263824; y:85.381157; z:37.005859
		"\175\177\045\200\117\089\195\131\046\129\011\111\155\102\249\005\046\237\137\195\001\119\183\066\000\006\020\066" ..
		-- tex:"afb12dc87559c3832e810b6f9b66f905"; x:-275.852997; y:91.732437; z:37.005863
		"\000\114\152\022\183\179\112\144\127\247\231\128\156\199\215\052\117\113\100\195\058\118\183\066\002\006\020\066" ..
		-- tex:"00729816b7b370907ff7e7809cc7d734"; x:-228.443207; y:91.730919; z:37.005871
		"\090\016\034\149\201\018\153\134\204\230\175\070\241\099\057\186\211\061\125\195\175\140\187\066\004\006\020\066" ..
		-- tex:"5a102295c9129986cce6af46f16339ba"; x:-253.241516; y:93.774780; z:37.005878
		"\017\027\164\115\080\015\047\106\042\163\052\203\102\088\076\238\197\245\033\195\017\189\247\066\099\038\020\066" ..
		-- tex:"111ba473500f2f6a2aa334cb66584cee"; x:-161.960052; y:123.869278; z:37.037491
		"\088\223\180\076\211\185\164\181\175\005\245\156\157\145\009\219\042\136\061\194\062\236\021\067\102\038\020\066" ..
		-- tex:"58dfb44cd3b9a4b5af05f59c9d9109db"; x:-47.382977; y:149.922836; z:37.037502
		"\141\064\072\236\092\090\198\110\111\159\058\087\147\025\066\248\200\066\018\194\107\211\006\067\102\038\020\066" ..
		-- tex:"8d4048ec5c5ac66e6f9f3a57931942f8"; x:-36.565220; y:134.825867; z:37.037502
		"\197\067\105\047\203\095\120\140\249\236\240\137\088\101\154\139\047\097\157\195\209\115\156\065\203\037\021\066" ..
		-- tex:"c543692fcb5f788cf9ecf08958659a8b"; x:-314.759277; y:19.556553; z:37.286911
		"\200\104\097\062\141\203\193\146\128\135\190\208\065\222\004\210\054\137\140\195\097\228\077\194\029\049\021\066" ..
		-- tex:"c868613e8dcbc1928087bed041de04d2"; x:-281.071991; y:-51.473030; z:37.297966
		"\035\052\113\220\234\096\251\038\174\189\010\199\218\080\165\004\019\004\147\195\096\243\090\066\072\050\021\066" ..
		-- tex:"233471dcea60fb26aebd0ac7da50a504"; x:-294.031860; y:54.737675; z:37.299107
		"\060\228\031\108\131\079\018\040\076\156\109\211\216\115\134\005\205\176\075\195\127\126\092\067\160\095\025\066" ..
		-- tex:"3ce41f6c834f12284c9c6dd3d8738605"; x:-203.690643; y:220.494141; z:38.343388
		"\138\208\202\159\077\136\154\124\212\111\187\222\162\110\102\249\095\251\157\195\074\009\205\067\176\096\032\066" ..
		-- tex:"8ad0ca9f4d889a7cd46fbbdea26e66f9"; x:-315.963867; y:410.072601; z:40.094425
		"\180\012\073\076\159\033\094\028\106\181\185\054\237\104\045\158\095\251\157\195\074\059\169\067\176\096\032\066" ..
		-- tex:"b40c494c9f215e1c6ab5b936ed682d9e"; x:-315.963867; y:338.463226; z:40.094425
		"\139\187\019\225\136\137\010\170\180\180\175\126\154\239\046\227\096\050\146\195\104\250\124\067\074\102\032\066" ..
		-- tex:"8bbb13e188890aaab4b4af7e9aef2ee3"; x:-292.393585; y:252.978165; z:40.099895
		"\201\205\024\219\221\174\248\120\198\216\194\128\127\048\184\079\086\060\120\195\104\250\124\067\074\102\032\066",
		-- tex:"c9cd18dbddaef878c6d8c2807f30b84f"; x:-248.235703; y:252.978165; z:40.099895
	["Magisters' Terrace"] = 
		"\030\036\135\017\196\177\025\081\114\106\030\204\214\119\111\212\005\066\214\195\121\011\242\066\183\124\051\194" ..
		-- tex:"1e248711c4b11951726a1eccd6776fd4"; x:-428.515808; y:121.022415; z:-44.871796
		"\059\023\170\224\147\225\099\092\075\014\182\129\227\192\181\035\005\066\214\195\066\250\006\195\183\124\051\194" ..
		-- tex:"3b17aae093e1635c4b0eb681e3c0b523"; x:-428.515808; y:-134.977585; z:-44.871796
		"\130\135\013\206\194\255\121\114\118\035\082\246\152\023\132\197\011\132\044\195\121\011\242\066\183\124\051\194" ..
		-- tex:"82870dcec2ff7972762352f6981784c5"; x:-172.515808; y:121.022415; z:-44.871796
		"\068\159\002\053\190\043\101\062\207\151\006\092\229\254\230\111\011\132\044\195\066\250\006\195\183\124\051\194" ..
		-- tex:"449f0235be2b653ecf97065ce5fee66f"; x:-172.515808; y:-134.977585; z:-44.871796
		"\003\058\151\105\074\120\086\037\034\178\052\239\071\121\072\161\145\087\139\195\085\231\041\195\214\167\050\194" ..
		-- tex:"033a97694a78562522b234ef477948a1"; x:-278.684143; y:-169.903656; z:-44.663906
		"\015\210\144\141\227\032\101\198\212\044\063\006\189\142\103\000\051\055\156\195\211\095\120\195\210\167\050\194" ..
		-- tex:"0fd2908de32065c6d42c3f06bd8e6700"; x:-312.431274; y:-248.374329; z:-44.663891
		"\211\139\116\248\046\219\216\000\190\135\026\098\136\107\143\228\037\085\178\195\169\197\023\067\168\068\046\194" ..
		-- tex:"d38b74f82edbd800be871a62886b8fe4"; x:-356.665222; y:151.772125; z:-43.567051
		"\123\155\167\131\034\181\104\237\222\150\122\147\196\162\094\004\238\073\212\195\168\027\195\067\053\136\044\194" ..
		-- tex:"7b9ba78322b568edde967a93c4a25e04"; x:-424.577606; y:390.216095; z:-43.133018
		"\006\026\129\159\086\074\097\090\025\142\079\097\135\187\074\147\231\253\140\195\028\210\169\067\221\204\043\194" ..
		-- tex:"061a819f564a615a198e4f6187bb4a93"; x:-281.983643; y:339.641510; z:-42.950066
		"\092\219\125\175\106\066\151\222\236\193\035\245\254\161\086\108\222\006\141\195\015\194\233\066\000\193\043\194" ..
		-- tex:"5cdb7daf6a4297deecc123f5fea1566c"; x:-282.053680; y:116.879028; z:-42.938480
		"\120\101\225\131\190\023\165\117\083\067\223\119\115\123\133\097\057\250\178\195\253\225\212\195\184\108\006\194" ..
		-- tex:"7865e183be17a5755343df77737b8561"; x:-357.954895; y:-425.765564; z:-33.606174
		"\237\206\215\013\202\136\190\121\159\022\096\227\028\142\161\040\032\037\211\195\096\143\232\067\205\130\155\193" ..
		-- tex:"edced70dca88be799f1660e31c8ea128"; x:-422.290070; y:465.120148; z:-19.438869
		"\090\239\245\171\038\061\196\246\191\027\032\002\233\174\065\012\233\160\253\195\106\029\219\067\240\052\155\193" ..
		-- tex:"5aeff5ab263dc4f6bf1b2002e9ae410c"; x:-507.257141; y:438.229813; z:-19.400850
		"\022\086\251\179\245\059\003\008\014\002\041\006\185\004\041\178\233\160\253\195\212\058\054\067\240\052\155\193" ..
		-- tex:"1656fbb3f53b03080e022906b90429b2"; x:-507.257141; y:182.229813; z:-19.400850
		"\077\089\055\251\223\252\228\179\016\176\213\034\172\006\093\232\066\036\244\195\252\092\236\067\121\166\081\193" ..
		-- tex:"4d5937fbdffce4b310b0d522ac065de8"; x:-488.283295; y:472.726471; z:-13.103144
		"\026\166\190\203\178\205\110\228\075\042\088\008\233\196\033\226\127\098\002\196\127\057\110\066\226\045\068\193" ..
		-- tex:"1aa6becbb2cd6ee44b2a5808e9c421e2"; x:-521.539063; y:59.556152; z:-12.261203
		"\064\142\210\217\056\093\147\000\101\112\092\229\131\219\209\088\054\126\255\194\215\108\048\194\068\007\238\192" ..
		-- tex:"408ed2d9385d930065705ce583dbd158"; x:-127.746513; y:-44.106293; z:-7.438387
		"\132\073\120\207\246\176\195\063\019\254\029\086\219\140\234\155\000\175\012\196\003\232\114\194\212\087\201\192" ..
		-- tex:"844978cff6b0c33f13fe1d56db8cea9b"; x:-562.734436; y:-60.726578; z:-6.291972
		"\201\046\089\167\185\069\011\210\237\099\048\231\235\033\037\008\251\062\215\195\067\232\050\194\083\017\194\192" ..
		-- tex:"c92e59a7b9450bd2ed6330e7eb212508"; x:-430.492065; y:-44.726822; z:-6.064615
		"\016\117\089\032\240\002\146\118\037\238\078\137\062\185\091\138\007\219\204\195\056\232\050\194\235\016\194\192" ..
		-- tex:"10755920f002927625ee4e893eb95b8a"; x:-409.711182; y:-44.726780; z:-6.064566
		"\116\235\150\107\123\203\200\038\206\084\149\198\140\094\181\021\036\060\165\195\246\134\045\067\215\091\158\066",
		-- tex:"74eb966b7bcbc826ce5495c68c5eb515"; x:-330.469879; y:173.527206; z:79.179382
	["Magtheridon's Lair"] = 
		"\026\019\195\230\022\081\021\247\120\086\082\253\192\141\146\093\108\018\012\067\131\192\055\195\022\147\145\191" ..
		-- tex:"1a13c3e6165115f7785652fdc08d925d"; x:140.071968; y:-183.752014; z:-1.137301
		"\205\180\042\092\236\171\106\172\070\072\163\034\016\179\111\076\038\219\231\194\247\126\144\066\022\147\145\191" ..
		-- tex:"cdb42a5cecab6aac4648a32210b36f4c"; x:-115.928032; y:72.247986; z:-1.137301
		"\055\233\229\102\061\149\232\206\229\180\066\229\132\066\139\102\038\219\231\194\131\192\055\195\022\147\145\191" ..
		-- tex:"37e9e5663d95e8cee5b442e584428b66"; x:-115.928032; y:-183.752014; z:-1.137301
		"\215\239\149\169\163\191\097\050\208\020\090\069\204\099\013\197\111\048\011\066\200\001\030\195\218\171\097\191" ..
		-- tex:"d7ef95a9a3bf6132d0145a45cc630dc5"; x:34.797302; y:-158.006973; z:-0.881529
		"\130\183\085\017\044\115\078\061\200\194\037\191\129\116\026\201\171\158\004\067\095\042\097\194\142\171\097\191" ..
		-- tex:"82b755112c734e3dc8c225bf81741ac9"; x:132.619812; y:-56.291382; z:-0.881524
		"\109\056\072\130\248\042\194\038\079\177\023\128\123\106\207\074\109\048\011\066\044\118\029\066\232\163\097\191" ..
		-- tex:"6d384882f82ac2264fb117807b6acf4a"; x:34.797295; y:39.365406; z:-0.881407
		"\090\095\134\012\057\255\085\156\176\177\083\003\054\063\006\076\064\111\133\195\252\252\049\194\082\028\180\066" ..
		-- tex:"5a5f860c39ff559cb0b15303363f064c"; x:-266.869171; y:-44.497059; z:90.055321
		"\188\071\115\019\062\043\194\079\086\001\182\207\154\176\059\154\079\208\236\195\170\067\106\195\194\229\006\067" ..
		-- tex:"bc4773133e2bc24f5601b6cf9ab03b9a"; x:-473.627441; y:-234.264328; z:134.897507
		"\175\186\056\005\124\210\152\050\244\050\151\015\125\193\170\117\079\208\236\195\167\226\173\065\194\229\006\067" ..
		-- tex:"afba38057cd29832f432970f7dc1aa75"; x:-473.627441; y:21.735672; z:134.897507
		"\157\068\144\022\188\197\076\011\004\117\037\188\244\100\084\222\146\152\006\195\145\122\154\066\166\144\015\067" ..
		-- tex:"9d449016bcc54c0b047525bcf46454de"; x:-134.595993; y:77.239395; z:143.565048
		"\050\129\017\085\166\008\240\237\148\176\108\052\254\056\110\239\146\152\006\195\182\194\050\195\166\144\015\067" ..
		-- tex:"32811155a608f0ed94b06c34fe386eef"; x:-134.595993; y:-178.760605; z:143.565048
		"\070\068\034\056\030\191\178\241\097\064\031\166\254\218\068\166\217\206\242\066\182\194\050\195\166\144\015\067",
		-- tex:"464422381ebfb2f161401fa6feda44a6"; x:121.404007; y:-178.760605; z:143.565048
	["Mana-Tombs"] = 
		"\236\022\170\023\150\142\172\113\004\118\125\040\137\164\053\021\140\173\038\068\202\085\199\067\096\251\152\193" ..
		-- tex:"ec16aa17968eac7104767d2889a43515"; x:666.711731; y:398.670258; z:-19.122744
		"\109\157\156\065\167\072\028\006\219\231\058\019\184\070\006\184\124\226\169\194\103\111\170\067\095\251\152\193" ..
		-- tex:"6d9d9c41a7481c06dbe73a13b84606b8"; x:-84.942360; y:340.870361; z:-19.122742
		"\214\016\192\240\232\030\050\087\241\251\051\030\188\152\105\092\068\181\030\068\080\014\152\066\095\251\152\193" ..
		-- tex:"d610c0f0e81e3257f1fb331ebc98695c"; x:634.832336; y:76.027962; z:-19.122742
		"\192\173\159\172\166\090\123\220\137\112\169\031\164\220\115\221\062\181\030\068\134\164\128\067\095\251\152\193" ..
		-- tex:"c0ad9faca65a7bdc8970a91fa4dc73dd"; x:634.831970; y:257.285370; z:-19.122742
		"\142\197\128\072\070\255\081\159\106\120\137\155\066\040\158\117\193\014\043\067\103\111\170\067\095\251\152\193" ..
		-- tex:"8ec5804846ff519f6a78899b42289e75"; x:171.057640; y:340.870361; z:-19.122742
		"\046\106\096\055\056\236\121\226\214\237\085\098\219\041\130\137\088\140\178\067\160\202\143\067\105\052\029\193" ..
		-- tex:"2e6a603738ec79e2d6ed5562db298289"; x:357.096466; y:287.583038; z:-9.825296
		"\137\231\090\226\097\015\170\155\063\025\096\124\220\189\042\210\088\140\178\067\080\229\007\068\105\052\029\193" ..
		-- tex:"89e75ae2610faa9b3f19607cdcbd2ad2"; x:357.096466; y:543.583038; z:-9.825296
		"\028\073\017\008\079\040\179\140\036\189\229\131\234\098\245\166\044\070\025\068\160\202\143\067\105\052\029\193" ..
		-- tex:"1c4911084f28b38c24bde583ea62f5a6"; x:613.096466; y:287.583038; z:-9.825296
		"\095\177\157\090\154\073\016\193\088\255\161\253\084\002\107\131\044\070\025\068\080\229\007\068\105\052\029\193" ..
		-- tex:"5fb19d5a9a4910c158ffa1fd54026b83"; x:613.096466; y:543.583038; z:-9.825296
		"\191\212\144\014\005\090\044\020\018\205\115\152\210\224\159\163\236\050\120\065\157\068\081\066\014\092\171\192" ..
		-- tex:"bfd4900e055a2c1412cd7398d2e09fa3"; x:15.512433; y:52.317009; z:-5.354988
		"\150\159\189\090\112\249\009\052\140\183\164\110\057\132\197\220\067\036\032\195\022\078\207\194\081\054\112\192" ..
		-- tex:"969fbd5a70f909348cb7a46e3984c5dc"; x:-160.141663; y:-103.652519; z:-3.753315
		"\135\040\066\243\246\007\052\047\179\084\087\035\064\178\076\199\119\183\191\066\022\078\207\194\081\054\112\192" ..
		-- tex:"872842f3f607342fb354572340b24cc7"; x:95.858337; y:-103.652519; z:-3.753315
		"\040\158\008\191\098\163\083\052\039\185\198\062\105\230\204\014\043\241\224\066\135\123\146\067\246\179\255\191" ..
		-- tex:"289e08bf62a3533427b9c63e69e6cc0e"; x:112.471039; y:292.965088; z:-1.997680
		"\174\040\065\203\122\021\056\085\029\116\149\114\013\043\125\122\035\244\039\068\066\016\036\194\147\182\252\191" ..
		-- tex:"ae2841cb7a1538551d7495720d2b7d7a"; x:671.814697; y:-41.015881; z:-1.974322
		"\172\086\024\168\242\063\143\177\227\216\153\083\093\080\023\188\209\211\052\068\180\105\089\067\063\146\252\191" ..
		-- tex:"ac5618a8f23f8fb1e3d899535d5017bc"; x:723.309692; y:217.412918; z:-1.973213
		"\137\095\244\111\039\169\077\097\163\140\110\082\038\102\164\218\116\069\156\067\208\245\211\067\042\165\251\191" ..
		-- tex:"895ff46f27a94d61a38c6e522666a4da"; x:312.542633; y:423.920441; z:-1.965978
		"\209\250\247\024\152\154\081\190\252\226\005\056\115\088\190\143\076\053\015\068\246\005\240\194\253\224\229\065" ..
		-- tex:"d1faf718989a51befce205387358be8f"; x:572.832794; y:-120.011650; z:28.734859
		"\250\159\061\055\032\201\054\137\156\130\142\213\073\235\090\105\152\106\158\067\246\005\240\194\253\224\229\065" ..
		-- tex:"fa9f3d3720c936899c828ed549eb5a69"; x:316.832794; y:-120.011650; z:28.734859
		"\230\059\022\038\146\248\206\239\004\237\187\113\174\244\008\052\061\163\047\067\066\031\036\194\232\018\006\066",
		-- tex:"e63b162692f8ceef04edbb71aef40834"; x:175.637665; y:-41.030529; z:33.518467
	["Maraudon"] = 
		"\131\200\201\218\001\153\235\103\241\217\032\191\100\052\108\085\226\185\150\195\141\193\159\195\171\244\208\195" ..
		-- tex:"83c8c9da0199eb67f1d920bf64346c55"; x:-301.452240; y:-319.512146; z:-417.911499
		"\120\187\208\065\147\006\062\120\189\060\207\112\139\073\121\038\226\185\150\195\111\012\126\194\171\244\208\195" ..
		-- tex:"78bbd04193063e78bd3ccf708b497926"; x:-301.452240; y:-63.512146; z:-417.911499
		"\184\200\194\185\234\057\191\147\177\089\113\065\052\146\224\055\023\207\053\194\227\124\064\067\171\244\208\195" ..
		-- tex:"b8c8c2b9ea39bf93b15971413492e037"; x:-45.452240; y:192.487854; z:-417.911499
		"\138\188\234\087\064\026\129\213\229\216\038\229\190\163\090\171\023\207\053\194\113\062\224\067\171\244\208\195" ..
		-- tex:"8abcea57401a81d5e5d826e5bea35aab"; x:-45.452240; y:448.487854; z:-417.911499
		"\014\155\095\068\028\134\047\129\217\044\093\065\058\052\250\064\023\207\053\194\141\193\159\195\171\244\208\195" ..
		-- tex:"0e9b5f441c862f81d92c5d413a34fa40"; x:-45.452240; y:-319.512146; z:-417.911499
		"\213\049\203\138\229\113\062\253\164\106\062\095\071\087\115\092\226\185\150\195\227\124\064\067\171\244\208\195" ..
		-- tex:"d531cb8ae5713efda46a3e5f4757735c"; x:-301.452240; y:192.487854; z:-417.911499
		"\029\094\015\119\005\207\058\236\094\168\050\162\251\224\154\128\226\185\150\195\113\062\224\067\171\244\208\195" ..
		-- tex:"1d5e0f7705cf3aec5ea832a2fbe09a80"; x:-301.452240; y:448.487854; z:-417.911499
		"\204\212\131\110\247\013\213\167\204\188\230\077\001\170\048\020\023\207\053\194\056\031\048\068\171\244\208\195" ..
		-- tex:"ccd4836ef70dd5a7ccbce64d01aa3014"; x:-45.452240; y:704.487854; z:-417.911499
		"\022\056\056\218\020\072\250\163\178\254\077\092\041\127\186\153\023\207\053\194\111\012\126\194\171\244\208\195" ..
		-- tex:"163838da1448faa3b2fe4d5c297fba99"; x:-45.452240; y:-63.512146; z:-417.911499
		"\134\190\040\112\237\181\166\057\084\042\088\177\002\113\205\201\215\128\007\194\154\203\093\068\246\040\208\195" ..
		-- tex:"86be2870edb5a639542a58b10271cdc9"; x:-33.875824; y:887.181335; z:-416.320038
		"\253\147\206\217\173\086\063\023\161\056\106\088\179\157\165\055\201\031\094\067\154\203\029\068\246\040\208\195" ..
		-- tex:"fd93ced9ad563f17a1386a58b39da537"; x:222.124176; y:631.181335; z:-416.320038
		"\228\032\087\252\129\055\081\255\016\074\163\042\001\016\178\134\215\128\007\194\154\203\029\068\246\040\208\195" ..
		-- tex:"e42057fc813751ff104aa32a0110b286"; x:-33.875824; y:631.181335; z:-416.320038
		"\245\120\138\168\012\061\046\139\100\124\137\079\164\082\129\041\173\067\225\195\094\163\021\068\102\132\175\195" ..
		-- tex:"f5788aa80c3d2e8b647c894fa4528129"; x:-450.528748; y:598.552673; z:-351.034393
		"\145\074\172\108\252\032\013\036\157\138\092\113\046\150\080\027\214\161\048\196\094\163\021\068\102\132\175\195" ..
		-- tex:"914aac6cfc200d249d8a5c712e96501b"; x:-706.528748; y:598.552673; z:-351.034393
		"\128\045\221\103\240\225\133\118\071\079\209\018\126\065\007\099\144\079\197\195\243\247\016\068\049\161\174\195" ..
		-- tex:"802ddd67f0e18576474fd1127e410763"; x:-394.621613; y:579.874268; z:-349.259338
		"\248\100\251\157\090\188\103\142\183\223\108\012\213\179\255\105\205\203\179\195\156\255\168\067\136\063\172\195" ..
		-- tex:"f864fb9d5abc678eb7df6c0cd5b3ff69"; x:-359.592224; y:337.996979; z:-344.496368
		"\255\050\050\031\224\229\147\179\011\059\060\140\252\083\049\072\144\079\197\195\025\161\216\067\176\228\171\195" ..
		-- tex:"ff32321fe0e593b30b3b3c8cfc533148"; x:-394.621613; y:433.258606; z:-343.786652
		"\186\051\020\077\067\241\237\054\075\195\040\129\053\011\150\078\043\055\005\067\248\025\233\067\078\115\170\195" ..
		-- tex:"ba33144d43f1ed364bc32881350b964e"; x:133.215515; y:466.202911; z:-340.900848
		"\230\085\056\146\253\038\045\195\227\213\014\117\225\094\002\081\224\153\137\195\248\055\151\067\147\224\169\195" ..
		-- tex:"e6553892fd262dc3e3d50e75e15e0251"; x:-275.202179; y:302.437286; z:-339.754517
		"\142\057\062\087\018\124\239\162\117\088\088\069\174\087\244\011\121\050\072\196\031\199\121\195\114\024\150\195" ..
		-- tex:"8e393e57127cefa275585845ae57f40b"; x:-800.788696; y:-249.777832; z:-300.191010
		"\168\045\150\233\131\186\240\154\051\044\230\006\249\062\055\215\060\025\132\196\255\027\199\064\114\024\150\195" ..
		-- tex:"a82d96e983baf09a332ce606f93e37d7"; x:-1056.788696; y:6.222168; z:-300.191010
		"\186\088\113\173\209\188\102\120\241\046\189\246\109\014\245\003\060\025\132\196\031\199\121\195\114\024\150\195" ..
		-- tex:"ba5871add1bc6678f12ebdf66d0ef503"; x:-1056.788696; y:-249.777832; z:-300.191010
		"\174\249\116\145\210\242\028\061\181\042\028\088\224\096\219\145\121\050\008\196\031\199\121\195\114\024\150\195" ..
		-- tex:"aef97491d2f21c3db52a1c58e060db91"; x:-544.788696; y:-249.777832; z:-300.191010
		"\151\088\077\134\200\026\038\068\050\151\243\087\160\098\183\091\121\050\008\196\255\027\199\064\114\024\150\195" ..
		-- tex:"97584d86c81a26443297f357a062b75b"; x:-544.788696; y:6.222168; z:-300.191010
		"\201\016\145\233\102\137\223\129\060\159\097\198\117\153\218\017\121\050\072\196\255\027\199\064\114\024\150\195" ..
		-- tex:"c91091e96689df813c9f61c67599da11"; x:-800.788696; y:6.222168; z:-300.191010
		"\118\110\240\124\230\195\046\138\057\072\105\145\181\000\209\248\073\155\079\196\012\174\018\196\067\202\131\195" ..
		-- tex:"766ef07ce6c32e8a39486991b500d1f8"; x:-830.426392; y:-586.719543; z:-263.580200
		"\194\130\200\235\062\072\062\224\047\118\059\085\195\136\080\244\073\155\079\196\025\092\165\195\067\202\131\195" ..
		-- tex:"c282c8eb3e483ee02f763b55c38850f4"; x:-830.426392; y:-330.719543; z:-263.580200
		"\208\017\063\248\190\236\187\020\077\242\139\251\244\043\035\018\004\063\050\196\192\230\175\195\067\202\131\195" ..
		-- tex:"d0113ff8beecbb144df28bfbf42b2312"; x:-712.984680; y:-351.802765; z:-263.580200
		"\058\226\207\095\006\163\242\006\234\139\020\102\051\241\044\032\164\205\135\196\025\092\165\195\067\202\131\195" ..
		-- tex:"3ae2cf5f06a3f206ea8b146633f12c20"; x:-1086.426392; y:-330.719543; z:-263.580200
		"\118\171\157\034\172\075\089\178\209\015\228\221\182\209\017\061\164\205\135\196\012\174\018\196\067\202\131\195" ..
		-- tex:"76ab9d22ac4b59b2d10fe4ddb6d1113d"; x:-1086.426392; y:-586.719543; z:-263.580200
		"\163\042\054\137\254\039\188\211\041\255\146\097\206\000\140\020\189\104\037\196\118\182\121\195\067\202\131\195" ..
		-- tex:"a32a3689fe27bcd329ff9261ce008c14"; x:-661.636597; y:-249.712753; z:-263.580200
		"\006\045\057\187\221\235\099\239\063\148\125\090\162\144\183\071\051\136\244\195\067\097\218\067\231\194\131\195" ..
		-- tex:"062d39bbddeb63ef3f947d5aa290b747"; x:-489.064087; y:436.759872; z:-263.522705
		"\013\075\017\035\143\160\173\181\161\000\101\161\033\185\084\099\025\068\058\196\067\097\218\067\231\194\131\195" ..
		-- tex:"0d4b11238fa0adb5a10065a121b95463"; x:-745.064087; y:436.759872; z:-263.522705
		"\071\249\116\247\184\137\094\185\185\024\047\079\052\123\011\101\025\068\058\196\134\194\052\067\231\194\131\195" ..
		-- tex:"47f974f7b8895eb9b9182f4f347b0b65"; x:-745.064087; y:180.759872; z:-263.522705
		"\174\104\139\152\115\029\027\237\060\177\193\053\223\125\114\143\051\136\244\195\134\194\052\067\231\194\131\195" ..
		-- tex:"ae688b98731d1bed3cb1c135df7d728f"; x:-489.064087; y:180.759872; z:-263.522705
		"\117\186\018\007\149\217\017\187\125\207\185\000\080\252\197\213\141\048\240\195\199\162\001\067\055\166\129\195" ..
		-- tex:"75ba120795d911bb7dcfb90050fcc5d5"; x:-480.379333; y:129.635864; z:-259.298584
		"\179\008\130\111\032\152\043\172\104\201\139\021\094\202\006\186\022\044\008\196\075\127\031\067\054\166\129\195" ..
		-- tex:"b308826f20982bac68c98b155eca06ba"; x:-544.688904; y:159.497253; z:-259.298553
		"\132\140\035\004\081\235\021\194\161\244\090\226\190\203\058\048\079\136\051\196\049\221\246\067\005\046\112\195" ..
		-- tex:"848c230451eb15c2a1f45ae2becb3a30"; x:-718.129883; y:493.728088; z:-240.179779
		"\143\101\043\072\255\164\229\108\155\017\239\002\092\243\203\038\002\044\175\195\176\171\203\067\209\194\089\195" ..
		-- tex:"8f652b48ffa4e56c9b11ef025cf3cb26"; x:-350.343842; y:407.341339; z:-217.761017
		"\176\216\070\166\057\139\115\185\144\204\143\242\030\223\178\210\195\036\133\196\222\093\147\195\102\174\064\195" ..
		-- tex:"b0d846a6398b73b990cc8ff21edfb2d2"; x:-1065.148926; y:-294.733368; z:-192.681259
		"\048\225\050\201\021\007\060\096\053\203\133\125\138\055\153\093\195\036\165\196\247\238\026\194\102\174\064\195" ..
		-- tex:"30e132c915073c6035cb857d8a37995d"; x:-1321.148926; y:-38.733368; z:-192.681259
		"\141\126\038\112\025\195\140\216\207\141\013\013\192\153\172\230\195\036\165\196\222\093\147\195\102\174\064\195" ..
		-- tex:"8d7e267019c38cd8cf8d0d0dc099ace6"; x:-1321.148926; y:-294.733368; z:-192.681259
		"\043\220\085\249\215\112\150\013\011\132\011\031\095\255\019\079\195\036\133\196\247\238\026\194\102\174\064\195" ..
		-- tex:"2bdc55f9d770960d0b840b1f5fff134f"; x:-1065.148926; y:-38.733368; z:-192.681259
		"\008\120\250\186\085\043\007\195\109\233\103\159\227\217\106\026\111\066\133\196\152\166\156\195\235\128\060\195" ..
		-- tex:"0878faba552b07c36de9679fe3d96a1a"; x:-1066.076172; y:-313.301544; z:-188.503601
		"\132\044\094\161\194\046\156\051\077\140\077\253\162\000\163\194\111\066\133\196\060\196\205\195\118\039\060\195" ..
		-- tex:"842c5ea1c22e9c334d8c4dfda200a3c2"; x:-1066.076172; y:-411.533112; z:-188.154160
		"\058\110\039\080\188\145\163\038\057\161\081\233\085\203\203\168\205\146\214\196\223\148\018\193\024\093\050\195" ..
		-- tex:"3a6e2750bc91a32639a151e955cbcba8"; x:-1716.587646; y:-9.161346; z:-178.363663
		"\109\243\184\239\176\151\226\012\034\198\089\223\037\047\062\095\205\146\214\196\166\148\132\195\024\093\050\195" ..
		-- tex:"6df3b8efb097e20c22c659df252f3e5f"; x:-1716.587646; y:-265.161346; z:-178.363663
		"\143\105\010\255\082\247\078\073\119\062\206\238\201\014\111\087\205\146\182\196\166\148\132\195\024\093\050\195" ..
		-- tex:"8f690aff52f74e49773eceeec90e6f57"; x:-1460.587646; y:-265.161346; z:-178.363663
		"\025\212\052\216\172\196\197\220\202\112\007\117\032\096\094\196\100\168\234\196\099\188\004\064\166\207\049\195" ..
		-- tex:"19d434d8acc4c5dcca70077520605ec4"; x:-1877.262329; y:2.073998; z:-177.811142
		"\012\152\222\155\134\187\113\116\115\141\126\120\004\044\039\245\100\168\234\196\120\009\129\067\166\207\049\195" ..
		-- tex:"0c98de9b86bb7174738d7e78042c27f5"; x:-1877.262329; y:258.073998; z:-177.811142
		"\122\226\167\093\160\091\184\035\111\140\040\035\095\102\060\197\100\168\234\196\188\132\000\068\166\207\049\195" ..
		-- tex:"7ae2a75da05bb8236f8c28235f663cc5"; x:-1877.262329; y:514.073998; z:-177.811142
		"\048\088\250\039\050\006\115\124\121\022\201\123\022\118\095\128\100\168\202\196\099\188\004\064\166\207\049\195" ..
		-- tex:"3058fa273206737c7916c97b16765f80"; x:-1621.262329; y:2.073998; z:-177.811142
		"\042\091\216\104\180\014\031\173\131\154\228\021\157\204\107\122\100\168\202\196\188\132\000\068\166\207\049\195" ..
		-- tex:"2a5bd868b40e1fad839ae4159dcc6b7a"; x:-1621.262329; y:514.073998; z:-177.811142
		"\124\071\127\174\198\083\005\016\150\093\142\155\087\049\080\242\100\168\202\196\120\009\129\067\166\207\049\195" ..
		-- tex:"7c477faec6530510965d8e9b573150f2"; x:-1621.262329; y:258.073998; z:-177.811142
		"\171\090\196\032\146\011\074\151\140\092\170\159\120\111\006\133\220\027\018\197\177\076\169\067\140\227\032\195" ..
		-- tex:"ab5ac420920b4a978c5caa9f786f0685"; x:-2337.741455; y:338.599182; z:-160.888870
		"\146\250\254\135\057\099\252\154\008\091\201\103\211\180\044\115\220\027\002\197\177\076\169\067\140\227\032\195" ..
		-- tex:"92fafe873963fc9a085bc967d3b42c73"; x:-2081.741455; y:338.599182; z:-160.888870
		"\028\223\243\018\122\155\200\051\224\230\029\065\063\076\231\220\220\027\018\197\088\166\020\068\140\227\032\195" ..
		-- tex:"1cdff3127a9bc833e0e61d413f4ce7dc"; x:-2337.741455; y:594.599182; z:-160.888870
		"\159\228\132\118\019\105\007\029\206\017\081\000\107\252\233\158\066\200\006\197\033\174\012\068\082\133\018\195" ..
		-- tex:"9fe484761369071dce1151006bfce99e"; x:-2156.516357; y:562.720825; z:-146.520798
		"\233\031\193\074\071\034\033\194\055\251\179\006\223\123\074\230\043\003\255\196\250\254\021\068\116\136\016\195" ..
		-- tex:"e91fc14a472221c237fbb306df7b4ae6"; x:-2040.099121; y:599.984070; z:-144.533035
		"\146\227\043\217\251\236\124\042\112\036\119\086\097\102\186\031\038\061\245\196\192\212\037\067\158\085\008\195" ..
		-- tex:"92e32bd9fbec7c2a702477566166ba1f"; x:-1961.911011; y:165.831070; z:-136.334457
		"\255\051\147\171\007\023\054\203\002\111\092\242\060\207\025\106\240\116\156\196\080\249\133\067\009\034\002\195" ..
		-- tex:"ff3393ab071736cb026f5cf23ccf196a"; x:-1251.654419; y:267.947784; z:-130.132965
		"\127\053\046\198\207\249\050\251\233\022\088\152\171\162\211\173\240\116\188\196\080\249\133\067\009\034\002\195" ..
		-- tex:"7f352ec6cff932fbe9165898aba2d3ad"; x:-1507.654419; y:267.947784; z:-130.132965
		"\151\218\226\211\201\169\252\100\144\205\025\079\043\228\113\149\240\116\188\196\168\252\002\068\009\034\002\195" ..
		-- tex:"97dae2d3c9a9fc6490cd194f2be47195"; x:-1507.654419; y:523.947784; z:-130.132965
		"\050\158\002\194\012\142\114\222\225\003\239\150\238\244\035\110\240\116\156\196\168\252\002\068\009\034\002\195" ..
		-- tex:"329e02c20c8e72dee103ef96eef4236e"; x:-1251.654419; y:523.947784; z:-130.132965
		"\124\123\065\087\010\051\136\066\041\086\191\208\112\112\210\072\036\014\225\196\155\165\092\068\177\231\000\195" ..
		-- tex:"7c7b41570a3388422956bfd07070d248"; x:-1800.442017; y:882.587646; z:-128.905060
		"\101\074\254\126\251\113\218\023\224\164\064\159\214\043\223\222\036\014\225\196\155\165\028\068\177\231\000\195" ..
		-- tex:"654afe7efb71da17e0a4409fd62bdfde"; x:-1800.442017; y:626.587646; z:-128.905060
		"\077\084\038\245\056\126\220\145\169\181\127\226\189\044\032\013\036\014\193\196\155\165\028\068\177\231\000\195" ..
		-- tex:"4d5426f5387edc91a9b57fe2bd2c200d"; x:-1544.442017; y:626.587646; z:-128.905060
		"\112\007\243\190\068\215\043\156\103\105\082\053\063\071\067\132\234\115\219\196\186\065\152\193\254\140\253\194" ..
		-- tex:"7007f3be44d72b9c676952353f474384"; x:-1755.622437; y:-19.032095; z:-126.775383
		"\078\206\157\217\157\029\090\060\084\239\007\204\151\082\202\069\234\115\251\196\186\065\152\193\254\140\253\194" ..
		-- tex:"4ece9dd99d1d5a3c54ef07cc9752ca45"; x:-2011.622437; y:-19.032095; z:-126.775383
		"\181\198\047\045\115\026\234\107\010\055\216\056\088\001\035\137\123\118\175\196\120\232\019\067\156\229\230\194" ..
		-- tex:"b5c62f2d731aea6b0a37d83858012389"; x:-1403.702637; y:147.908096; z:-115.448463
		"\073\098\073\077\053\080\156\138\108\230\120\047\254\000\083\101\145\036\217\196\149\143\081\068\186\025\226\194" ..
		-- tex:"4962494d35509c8a6ce6782ffe005365"; x:-1737.142822; y:838.243530; z:-113.050255
		"\025\123\241\172\236\171\023\203\203\103\047\125\228\093\094\255\076\235\219\196\016\216\188\068\096\141\225\194" ..
		-- tex:"197bf1acecab17cbcb672f7de45d5eff"; x:-1759.353149; y:1510.752075; z:-112.776131
		"\103\238\111\066\241\056\183\030\040\032\160\179\037\081\053\128\076\235\219\196\016\216\156\068\096\141\225\194" ..
		-- tex:"67ee6f42f138b71e2820a0b325513580"; x:-1759.353149; y:1254.752075; z:-112.776131
		"\029\244\170\176\255\058\014\196\006\030\149\006\061\194\007\234\076\235\187\196\016\216\188\068\096\141\225\194" ..
		-- tex:"1df4aab0ff3a0ec4061e95063dc207ea"; x:-1503.353149; y:1510.752075; z:-112.776131
		"\120\086\043\193\128\026\109\075\129\170\001\037\137\120\153\178\076\235\187\196\016\216\156\068\096\141\225\194" ..
		-- tex:"78562bc1801a6d4b81aa0125897899b2"; x:-1503.353149; y:1254.752075; z:-112.776131
		"\016\246\080\000\062\124\208\124\026\019\019\112\084\147\029\021\020\187\206\196\086\016\078\068\186\126\222\194" ..
		-- tex:"10f650003e7cd07c1a13137054931d15"; x:-1653.846313; y:824.255310; z:-111.247520
		"\057\111\254\219\013\155\129\041\197\217\157\012\098\242\076\038\020\187\206\196\043\008\135\068\186\126\222\194" ..
		-- tex:"396ffedb0d9b8129c5d99d0c62f24c26"; x:-1653.846313; y:1080.255310; z:-111.247520
		"\238\058\021\029\144\119\215\246\134\137\231\099\007\223\144\159\020\187\174\196\086\016\078\068\186\126\222\194" ..
		-- tex:"ee3a151d9077d7f68689e76307df909f"; x:-1397.846313; y:824.255310; z:-111.247520
		"\112\169\170\203\201\070\208\033\207\040\083\079\122\004\194\071\196\194\221\196\097\192\203\067\183\057\218\194" ..
		-- tex:"70a9aacbc946d021cf28534f7a04c247"; x:-1774.086548; y:407.502991; z:-109.112732
		"\096\009\193\016\253\220\232\038\060\024\229\039\214\237\162\226\196\194\253\196\097\192\203\067\183\057\218\194" ..
		-- tex:"6009c110fddce8263c18e527d6eda2e2"; x:-2030.086548; y:407.502991; z:-109.112732
		"\150\225\250\210\022\237\033\156\072\214\175\196\235\180\224\185\196\194\253\196\048\224\037\068\183\057\218\194" ..
		-- tex:"96e1fad216ed219c48d6afc4ebb4e0b9"; x:-2030.086548; y:663.502991; z:-109.112732
		"\098\206\233\153\202\216\203\029\203\050\189\205\155\198\190\137\189\168\226\196\231\018\069\068\062\143\213\194" ..
		-- tex:"62cee999cad8cb1dcb32bdcd9bc6be89"; x:-1813.273193; y:788.295410; z:-106.779778
		"\074\112\085\077\173\190\091\096\228\228\106\247\132\186\116\008\212\153\152\196\067\221\018\068\112\252\211\194" ..
		-- tex:"4a70554dadbe5b60e4e46af784ba7408"; x:-1220.807251; y:587.457275; z:-105.993050
		"\018\062\217\119\171\064\006\218\035\227\031\138\070\213\090\120\212\153\184\196\067\221\018\068\112\252\211\194" ..
		-- tex:"123ed977ab4006da23e31f8a46d55a78"; x:-1476.807251; y:587.457275; z:-105.993050
		"\053\026\012\143\204\014\145\201\140\202\173\083\058\135\090\238\054\024\252\196\192\047\085\068\174\068\205\194" ..
		-- tex:"351a0c8fcc0e91c98ccaad533a875aee"; x:-2016.756714; y:852.746155; z:-102.634148
		"\015\151\208\003\045\072\092\154\085\225\065\090\170\077\178\173\096\004\009\197\175\031\080\068\252\184\175\194" ..
		-- tex:"0f97d0032d485c9a55e1415aaa4db2ad"; x:-2192.273682; y:832.495117; z:-87.861305
		"\129\175\039\065\003\011\235\168\229\110\018\111\157\220\196\053\183\096\000\197\127\126\039\068\195\246\173\194" ..
		-- tex:"81af2741030beba8e56e126f9ddcc435"; x:-2054.044922; y:669.976563; z:-86.981964
		"\060\026\150\219\209\058\148\152\050\078\062\150\082\097\226\216\176\191\004\197\048\071\027\068\158\192\164\194" ..
		-- tex:"3c1a96dbd13a9498324e3e965261e2d8"; x:-2123.980713; y:621.112366; z:-82.376213
		"\232\078\093\253\129\172\075\030\104\148\050\200\188\237\217\071\200\209\008\197\014\204\050\068\111\087\150\194" ..
		-- tex:"e84e5dfd81ac4b1e689432c8bcedd947"; x:-2189.111572; y:715.188416; z:-75.170776
		"\042\193\187\047\092\110\080\035\152\194\204\176\160\207\036\091\163\198\205\196\034\227\145\068\049\032\133\194" ..
		-- tex:"2ac1bb2f5c6e502398c2ccb0a0cf245b"; x:-1646.207520; y:1167.098022; z:-66.562881
		"\232\215\226\014\120\248\195\209\080\188\058\085\147\230\252\158\163\198\205\196\173\030\137\068\056\252\132\194",
		-- tex:"e8d7e20e78f8c3d150bc3a5593e6fc9e"; x:-1646.207520; y:1096.958740; z:-66.492622
	["Molten Core"] = 
		"\078\198\243\116\253\182\138\108\148\158\246\236\226\132\021\246\212\169\204\196\166\014\200\068\176\133\233\195" ..
		-- tex:"4ec6f374fdb68a6c949ef6ece28415f6"; x:-1637.307251; y:1600.457886; z:-467.044464
		"\166\127\087\193\076\108\014\001\248\161\210\064\106\205\145\093\212\169\236\196\166\014\232\068\176\133\233\195" ..
		-- tex:"a67f57c14c6c0e01f8a1d2406acd915d"; x:-1893.307251; y:1856.457886; z:-467.044464
		"\020\032\063\174\087\051\215\237\078\239\017\098\085\063\021\232\212\169\236\196\166\014\168\068\176\133\233\195" ..
		-- tex:"14203fae5733d7ed4eef1162553f15e8"; x:-1893.307251; y:1344.457886; z:-467.044464
		"\177\169\105\103\157\002\064\057\129\088\112\125\017\091\018\030\212\169\204\196\166\014\168\068\176\133\233\195" ..
		-- tex:"b1a969679d0240398158707d115b121e"; x:-1637.307251; y:1344.457886; z:-467.044464
		"\184\096\010\039\120\176\207\203\075\102\251\246\021\000\150\019\212\169\236\196\166\014\200\068\176\133\233\195" ..
		-- tex:"b8600a2778b0cfcb4b66fbf615009613"; x:-1893.307251; y:1600.457886; z:-467.044464
		"\074\013\138\137\105\047\147\125\145\205\121\241\138\149\150\056\212\169\204\196\166\014\232\068\176\133\233\195" ..
		-- tex:"4a0d8a89692f937d91cd79f18a959638"; x:-1637.307251; y:1856.457886; z:-467.044464
		"\217\076\206\196\057\094\240\231\115\068\249\148\115\018\050\236\127\069\245\196\002\151\153\068\000\228\230\195" ..
		-- tex:"d94ccec4395ef0e77344f994731232ec"; x:-1962.171875; y:1228.719116; z:-461.781281
		"\166\050\207\118\029\068\195\065\120\223\206\214\049\154\239\057\127\069\245\196\005\046\115\068\000\228\230\195" ..
		-- tex:"a632cf761d44c34178dfced6319aef39"; x:-1962.171875; y:972.719116; z:-461.781281
		"\224\082\082\128\032\031\171\115\179\182\187\065\136\127\126\120\127\069\213\196\002\151\153\068\000\228\230\195" ..
		-- tex:"e0525280201fab73b3b6bb41887f7e78"; x:-1706.171875; y:1228.719116; z:-461.781281
		"\162\028\253\046\056\067\049\028\194\164\043\196\036\242\013\003\127\069\245\196\002\151\185\068\000\228\230\195" ..
		-- tex:"a21cfd2e3843311cc2a42bc424f20d03"; x:-1962.171875; y:1484.719116; z:-461.781281
		"\159\101\173\197\008\009\063\116\080\187\226\025\182\191\184\233\127\069\213\196\005\046\115\068\000\228\230\195" ..
		-- tex:"9f65adc508093f7450bbe219b6bfb8e9"; x:-1706.171875; y:972.719116; z:-461.781281
		"\017\047\172\227\057\102\013\025\067\245\156\099\047\039\053\044\191\162\010\197\002\151\185\068\000\228\230\195" ..
		-- tex:"112face339660d1943f59c632f27352c"; x:-2218.171875; y:1484.719116; z:-461.781281
		"\215\169\195\032\013\056\160\176\196\017\255\093\079\180\079\087\191\162\026\197\002\151\185\068\000\228\230\195" ..
		-- tex:"d7a9c3200d38a0b0c411ff5d4fb44f57"; x:-2474.171875; y:1484.719116; z:-461.781281
		"\093\044\092\114\196\122\229\186\197\120\203\236\159\031\223\136\191\162\010\197\005\046\115\068\000\228\230\195" ..
		-- tex:"5d2c5c72c47ae5bac578cbec9f1fdf88"; x:-2218.171875; y:972.719116; z:-461.781281
		"\109\169\108\036\004\229\151\192\186\239\027\119\224\234\110\073\191\162\010\197\002\151\153\068\000\228\230\195" ..
		-- tex:"6da96c2404e597c0baef1b77e0ea6e49"; x:-2218.171875; y:1228.719116; z:-461.781281
		"\015\067\146\023\019\244\067\179\253\136\247\161\029\042\196\078\191\162\026\197\002\151\153\068\000\228\230\195" ..
		-- tex:"0f43921713f443b3fd88f7a11d2ac44e"; x:-2474.171875; y:1228.719116; z:-461.781281
		"\125\188\171\061\108\076\236\164\144\063\175\178\212\222\235\254\191\162\026\197\005\046\115\068\000\228\230\195" ..
		-- tex:"7dbcab3d6c4ceca4903fafb2d4deebfe"; x:-2474.171875; y:972.719116; z:-461.781281
		"\069\187\142\172\226\163\102\017\160\236\253\230\189\049\095\166\003\045\230\196\071\005\016\069\109\088\225\195" ..
		-- tex:"45bb8eace2a36611a0ecfde6bd315fa6"; x:-1841.406738; y:2304.329956; z:-450.690857
		"\127\071\001\115\145\021\083\158\056\229\167\213\142\065\076\173\003\045\198\196\142\010\224\068\109\088\225\195" ..
		-- tex:"7f4701739115539e38e5a7d58e414cad"; x:-1585.406738; y:1792.329956; z:-450.690857
		"\149\070\186\030\049\123\065\165\137\017\189\237\072\124\045\065\003\045\230\196\142\010\224\068\109\088\225\195" ..
		-- tex:"9546ba1e317b41a58911bded487c2d41"; x:-1841.406738; y:1792.329956; z:-450.690857
		"\078\087\034\245\119\217\127\198\181\115\020\202\255\063\065\072\003\045\198\196\071\005\000\069\109\088\225\195" ..
		-- tex:"4e5722f577d97fc6b57314caff3f4148"; x:-1585.406738; y:2048.329956; z:-450.690857
		"\023\177\173\199\072\208\078\177\146\179\210\033\044\195\000\147\003\045\166\196\142\010\224\068\109\088\225\195" ..
		-- tex:"17b1adc748d04eb192b3d2212cc30093"; x:-1329.406738; y:1792.329956; z:-450.690857
		"\079\110\035\231\181\205\184\250\072\231\042\053\058\117\104\068\003\045\198\196\071\005\016\069\109\088\225\195" ..
		-- tex:"4f6e23e7b5cdb8fa48e72a353a756844"; x:-1585.406738; y:2304.329956; z:-450.690857
		"\124\124\127\009\206\201\125\145\034\186\121\225\197\216\197\115\003\045\134\196\071\005\000\069\109\088\225\195" ..
		-- tex:"7c7c7f09cec97d9122ba79e1c5d8c573"; x:-1073.406738; y:2048.329956; z:-450.690857
		"\009\006\089\051\020\098\003\111\040\085\155\054\181\043\026\041\003\045\230\196\071\005\000\069\109\088\225\195" ..
		-- tex:"090659331462036f28559b36b52b1a29"; x:-1841.406738; y:2048.329956; z:-450.690857
		"\007\128\237\058\084\232\209\239\200\247\146\219\173\101\212\008\003\045\166\196\071\005\016\069\109\088\225\195" ..
		-- tex:"0780ed3a54e8d1efc8f792dbad65d408"; x:-1329.406738; y:2304.329956; z:-450.690857
		"\125\154\078\199\074\211\008\237\065\041\190\239\080\206\085\098\003\045\166\196\071\005\000\069\109\088\225\195" ..
		-- tex:"7d9a4ec74ad308ed4129beef50ce5562"; x:-1329.406738; y:2048.329956; z:-450.690857
		"\228\022\177\075\083\051\087\231\060\171\071\017\138\176\069\225\224\019\185\196\006\191\214\068\244\044\219\195" ..
		-- tex:"e416b14b533357e73cab47118ab045e1"; x:-1480.621216; y:1717.969604; z:-438.351227
		"\227\032\134\165\028\221\094\217\011\135\088\007\248\171\081\076\224\019\185\196\006\191\150\068\244\044\219\195" ..
		-- tex:"e32086a51cdd5ed90b875807f8ab514c"; x:-1480.621216; y:1205.969604; z:-438.351227
		"\076\246\118\125\055\070\138\207\244\245\123\170\169\123\027\027\224\019\153\196\006\191\150\068\244\044\219\195" ..
		-- tex:"4cf6767d37468acff4f57baaa97b1b1b"; x:-1224.621216; y:1205.969604; z:-438.351227
		"\051\119\192\178\025\176\137\163\196\025\235\060\065\229\189\176\224\019\153\196\006\191\214\068\244\044\219\195" ..
		-- tex:"3377c0b219b089a3c419eb3c41e5bdb0"; x:-1224.621216; y:1717.969604; z:-438.351227
		"\149\244\245\080\012\123\122\011\132\071\245\143\107\051\057\190\224\019\153\196\006\191\182\068\244\044\219\195" ..
		-- tex:"95f4f5500c7b7a0b8447f58f6b3339be"; x:-1224.621216; y:1461.969604; z:-438.351227
		"\077\131\025\190\008\011\166\058\080\244\141\035\204\208\202\003\224\019\185\196\006\191\182\068\244\044\219\195" ..
		-- tex:"4d8319be080ba63a50f48d23ccd0ca03"; x:-1480.621216; y:1461.969604; z:-438.351227
		"\243\085\176\016\144\132\007\215\016\024\183\255\073\176\035\127\079\009\170\196\120\026\100\068\090\041\218\195" ..
		-- tex:"f355b010908407d71018b7ff49b0237f"; x:-1360.291016; y:912.413635; z:-436.323090
		"\255\098\083\186\068\205\082\195\099\096\104\048\211\011\101\125\079\009\202\196\060\013\146\068\090\041\218\195" ..
		-- tex:"ff6253ba44cd52c363606830d30b657d"; x:-1616.291016; y:1168.413635; z:-436.323090
		"\101\139\012\147\058\215\086\216\107\111\028\094\062\024\138\062\079\009\202\196\120\026\100\068\090\041\218\195" ..
		-- tex:"658b0c933ad756d86b6f1c5e3e188a3e"; x:-1616.291016; y:912.413635; z:-436.323090
		"\001\194\004\219\180\176\194\111\131\050\165\173\144\176\115\128\098\040\181\196\033\114\149\068\123\028\210\195" ..
		-- tex:"01c204dbb4b0c26f8332a5ad90b07380"; x:-1449.262085; y:1195.566650; z:-420.222534
		"\035\104\014\140\231\202\042\111\213\088\163\253\187\239\183\044\000\149\017\197\044\204\000\069\059\121\192\195" ..
		-- tex:"23680e8ce7ca2a6fd558a3fdbbefb72c"; x:-2329.312744; y:2060.760864; z:-384.947144
		"\233\176\096\154\027\090\024\113\068\127\208\088\100\224\123\148\000\149\017\197\088\152\225\068\059\121\192\195" ..
		-- tex:"e9b0609a1b5a1871447fd05864e07b94"; x:-2329.312744; y:1804.760864; z:-384.947144
		"\079\097\161\197\213\057\155\238\117\061\016\211\096\188\216\174\001\042\227\196\088\152\225\068\059\121\192\195" ..
		-- tex:"4f61a1c5d5399bee753d10d360bcd8ae"; x:-1817.312744; y:1804.760864; z:-384.947144
		"\144\139\048\123\010\012\193\247\199\027\092\223\184\096\240\208\000\149\001\197\088\152\225\068\059\121\192\195" ..
		-- tex:"908b307b0a0cc1f7c71b5cdfb860f0d0"; x:-2073.312744; y:1804.760864; z:-384.947144
		"\002\190\087\018\067\153\099\188\190\239\021\036\236\118\204\126\176\253\006\197\245\198\217\068\163\043\179\195" ..
		-- tex:"02be5712439963bcbeef1524ec76cc7e"; x:-2159.855713; y:1742.217529; z:-358.340942
		"\237\006\120\046\210\112\123\102\249\249\022\189\067\056\137\247\097\251\237\196\245\198\217\068\163\043\179\195" ..
		-- tex:"ed06782ed2707b66f9f916bd433889f7"; x:-1903.855713; y:1742.217529; z:-358.340942
		"\138\216\173\113\048\046\074\075\079\168\122\233\085\004\057\050\090\167\005\197\157\246\208\068\009\045\167\195" ..
		-- tex:"8ad8ad71302e4a4b4fa87ae955043932"; x:-2138.459717; y:1671.706787; z:-334.351868
		"\176\248\097\207\144\215\122\034\201\001\012\176\048\129\030\238\195\161\038\197\068\213\131\068\017\198\122\195" ..
		-- tex:"b0f861cf90d77a22c9010cb030811eee"; x:-2666.110352; y:1054.664612; z:-250.773712
		"\091\059\084\202\162\019\014\067\023\132\111\079\143\002\026\180\195\161\038\197\136\170\071\068\017\198\122\195" ..
		-- tex:"5b3b54caa2130e4317846f4f8f021ab4"; x:-2666.110352; y:798.664612; z:-250.773712
		"\238\239\074\180\229\064\210\202\166\135\023\216\029\030\190\130\195\161\022\197\136\170\007\068\017\198\122\195" ..
		-- tex:"eeef4ab4e540d2caa68717d81d1ebe82"; x:-2410.110352; y:542.664612; z:-250.773712
		"\202\215\112\207\255\028\002\242\161\024\102\233\158\003\228\008\195\161\022\197\136\170\071\068\017\198\122\195" ..
		-- tex:"cad770cfff1c02f2a11866e99e03e408"; x:-2410.110352; y:798.664612; z:-250.773712
		"\180\180\022\087\111\125\159\223\050\221\193\017\020\121\090\135\195\161\038\197\136\170\007\068\017\198\122\195" ..
		-- tex:"b4b416576f7d9fdf32ddc11114795a87"; x:-2666.110352; y:542.664612; z:-250.773712
		"\082\206\121\224\163\119\018\143\104\000\191\212\075\233\140\203\245\006\012\197\066\059\098\068\190\149\089\195" ..
		-- tex:"52ce79e0a377128f6800bfd44be98ccb"; x:-2240.435059; y:904.925964; z:-217.584946
		"\057\084\143\020\125\030\027\193\171\110\225\016\098\245\086\092\024\167\032\197\188\003\017\068\126\126\028\195",
		-- tex:"39548f147d1e1bc1ab6ee11062f5565c"; x:-2570.443604; y:580.058411; z:-156.494125
	["Naxxramas"] = 
		"\120\077\130\037\080\134\022\172\203\041\080\092\163\051\175\251\001\148\086\196\159\171\070\068\241\112\125\195" ..
		-- tex:"784d8225508616accb29505ca333affb"; x:-858.312622; y:794.681641; z:-253.441193
		"\140\006\186\203\064\105\063\040\119\052\247\054\103\052\077\189\000\074\139\196\159\171\070\068\241\112\125\195" ..
		-- tex:"8c06bacb40693f287734f73667344dbd"; x:-1114.312622; y:794.681641; z:-253.441193
		"\198\114\115\025\116\165\100\112\167\191\253\009\237\022\040\084\164\162\124\068\176\163\060\196\015\041\255\194" ..
		-- tex:"c672731974a56470a7bffd09ed162854"; x:1010.541321; y:-754.557678; z:-127.580200
		"\110\146\199\173\051\101\096\203\142\132\217\208\130\011\056\098\164\162\060\068\097\071\249\195\015\041\255\194" ..
		-- tex:"6e92c7ad336560cb8e84d9d0820b3862"; x:754.541321; y:-498.557678; z:-127.580200
		"\007\191\227\252\174\037\016\146\181\251\180\017\098\244\106\046\164\162\060\068\176\163\060\196\015\041\255\194" ..
		-- tex:"07bfe3fcae251092b5fbb41162f46a2e"; x:754.541321; y:-754.557678; z:-127.580200
		"\123\130\003\066\197\201\222\135\247\238\058\048\099\241\022\218\006\039\032\068\160\025\089\196\014\041\255\194" ..
		-- tex:"7b820342c5c9de87f7ee3a3063f116da"; x:640.609802; y:-868.400452; z:-127.580193
		"\066\208\243\093\251\220\138\055\061\161\200\214\209\042\101\166\028\102\058\068\120\245\127\196\014\041\255\194" ..
		-- tex:"42d0f35dfbdc8a373da1c8d6d12a65a6"; x:745.595490; y:-1023.835510; z:-127.580193
		"\145\234\175\224\154\099\027\021\210\244\105\098\133\193\249\213\056\204\244\067\120\245\127\196\014\041\255\194" ..
		-- tex:"91eaafe09a631b15d2f4696285c1f9d5"; x:489.595490; y:-1023.835510; z:-127.580193
		"\222\159\161\124\085\188\194\110\179\004\030\215\251\123\107\131\056\204\244\067\120\245\063\196\014\041\255\194" ..
		-- tex:"de9fa17c55bcc26eb3041ed7fb7b6b83"; x:489.595490; y:-767.835510; z:-127.580193
		"\163\209\095\208\172\239\254\035\181\175\018\229\142\226\005\220\199\062\074\068\073\041\244\195\010\041\255\194" ..
		-- tex:"a3d15fd0aceffe23b5af12e58ee205dc"; x:808.980957; y:-488.322571; z:-127.580162
		"\230\227\106\037\233\230\076\135\180\219\133\212\051\061\097\121\056\053\157\067\033\179\118\196\010\041\255\194" ..
		-- tex:"e6e36a25e9e64c87b4db85d4333d6179"; x:314.415802; y:-986.798950; z:-127.580162
		"\003\224\229\153\084\058\221\182\014\238\248\101\061\183\115\021\129\182\040\067\196\174\035\067\209\250\250\194" ..
		-- tex:"03e0e599543addb60eeef8653db77315"; x:168.712921; y:163.682693; z:-125.489883
		"\198\059\119\035\108\046\144\253\185\117\238\078\087\069\189\153\064\091\212\067\196\174\035\067\209\250\250\194" ..
		-- tex:"c63b77236c2e90fdb975ee4e5745bd99"; x:424.712921; y:163.682693; z:-125.489883
		"\022\207\112\027\019\217\051\118\207\054\247\095\152\205\003\039\160\045\042\068\196\174\035\067\209\250\250\194" ..
		-- tex:"16cf701b13d93376cf36f75f98cd0327"; x:680.712921; y:163.682693; z:-125.489883
		"\068\104\063\212\026\214\000\181\204\021\122\115\123\253\182\065\129\182\040\067\098\215\209\067\209\250\250\194" ..
		-- tex:"44683fd41ad600b5cc157a737bfdb641"; x:168.712921; y:419.682693; z:-125.489883
		"\162\208\022\062\180\222\085\123\164\200\190\053\016\255\076\027\154\161\125\068\039\077\091\196\006\061\241\194" ..
		-- tex:"a2d0163eb4de557ba4c8be3510ff4c1b"; x:1014.525085; y:-877.205566; z:-120.619194
		"\086\020\156\150\160\149\035\201\099\232\084\082\117\249\224\117\154\161\061\068\147\166\141\196\006\061\241\194" ..
		-- tex:"56149c96a09523c963e8545275f9e075"; x:758.525085; y:-1133.205566; z:-120.619194
		"\008\186\095\246\182\098\191\203\056\157\089\034\038\078\038\087\154\161\125\068\147\166\141\196\006\061\241\194" ..
		-- tex:"08ba5ff6b662bfcb389d5922264e2657"; x:1014.525085; y:-1133.205566; z:-120.619194
		"\246\094\254\031\152\203\114\103\180\043\162\206\168\156\060\010\154\161\061\068\039\077\091\196\006\061\241\194" ..
		-- tex:"f65efe1f98cb7267b42ba2cea89c3c0a"; x:758.525085; y:-877.205566; z:-120.619194
		"\092\174\028\188\172\206\138\069\176\185\178\009\079\012\240\146\164\135\184\063\226\190\102\196\188\179\221\194" ..
		-- tex:"5cae1cbcacce8a45b0b9b2094f0cf092"; x:1.441640; y:-922.982605; z:-110.851051
		"\041\164\067\249\166\195\045\217\064\180\035\198\227\162\104\056\070\236\213\194\226\190\102\196\188\179\221\194" ..
		-- tex:"29a443f9a6c32dd940b423c6e3a26838"; x:-106.961479; y:-922.982605; z:-110.851051
		"\255\180\176\251\023\212\007\125\125\167\136\252\113\174\231\105\163\050\090\068\218\061\226\189\186\179\221\194" ..
		-- tex:"ffb4b0fb17d4077d7da788fc71aee769"; x:872.791260; y:-0.110470; z:-110.851036
		"\104\087\035\158\060\192\146\130\059\055\192\192\098\217\086\162\163\050\090\068\249\006\217\194\186\179\221\194" ..
		-- tex:"6857239e3cc092823b37c0c062d956a2"; x:872.791260; y:-108.513626; z:-110.851036
		"\185\188\034\013\000\181\172\191\074\199\157\191\080\123\232\057\136\091\102\196\095\124\099\189\185\179\221\194" ..
		-- tex:"b9bc220d00b5acbf4ac79dbf507be839"; x:-921.430237; y:-0.055539; z:-110.851028
		"\066\101\163\248\007\117\065\123\072\109\026\100\234\235\068\146\218\178\213\194\078\207\089\068\184\179\221\194" ..
		-- tex:"4265a3f80775417b486d1a64eaeb4492"; x:-106.849327; y:871.239197; z:-110.851021
		"\225\098\041\227\185\033\226\006\114\057\021\237\199\134\210\067\034\138\191\063\078\207\089\068\184\179\221\194" ..
		-- tex:"e16229e3b921e206723915edc786d243"; x:1.496403; y:871.239197; z:-110.851021
		"\060\198\225\098\086\194\004\112\087\062\114\165\076\034\181\167\136\091\102\196\120\205\216\194\182\179\221\194" ..
		-- tex:"3cc6e16256c20470573e72a54c22b5a7"; x:-921.430237; y:-108.401314; z:-110.851006
		"\091\193\072\053\054\191\054\175\167\021\000\144\107\013\178\242\203\242\004\196\035\095\155\067\213\194\167\194" ..
		-- tex:"5bc1483536bf36afa71500906b0db2f2"; x:-531.793701; y:310.743286; z:-83.880539
		"\062\117\034\244\199\107\031\078\228\111\157\062\033\178\150\062\203\242\004\196\145\175\013\068\213\194\167\194" ..
		-- tex:"3e7522f4c76b1f4ee46f9d3e21b2963e"; x:-531.793701; y:566.743286; z:-83.880539
		"\017\079\069\001\078\040\000\136\130\068\195\146\105\209\186\000\203\242\068\196\035\095\155\067\213\194\167\194" ..
		-- tex:"114f45014e2800888244c39269d1ba00"; x:-787.793701; y:310.743286; z:-83.880539
		"\114\251\116\145\131\101\021\242\111\148\255\084\015\039\005\073\151\229\137\195\145\175\013\068\213\194\167\194" ..
		-- tex:"72fb7491836515f26f94ff540f270549"; x:-275.793701; y:566.743286; z:-83.880539
		"\094\103\152\192\176\118\034\208\020\096\240\147\141\106\024\247\203\242\068\196\145\175\013\068\213\194\167\194" ..
		-- tex:"5e6798c0b07622d01460f0938d6a18f7"; x:-787.793701; y:566.743286; z:-83.880539
		"\136\110\119\103\054\219\244\147\164\241\144\087\253\230\154\202\103\250\001\068\108\151\152\065\222\070\159\194" ..
		-- tex:"886e776736dbf493a4f19057fde69aca"; x:519.912598; y:19.073938; z:-79.638420
		"\148\156\103\157\145\130\201\023\133\154\144\008\133\226\203\193\090\193\165\067\251\210\151\066\176\125\155\194" ..
		-- tex:"949c679d9182c917859a900885e2cbc1"; x:331.510590; y:75.912079; z:-77.745491
		"\217\199\085\217\066\155\191\001\121\203\139\005\119\184\065\048\219\214\155\195\233\001\128\196\070\089\147\194" ..
		-- tex:"d9c755d9429bbf0179cb8b0577b84130"; x:-311.678589; y:-1024.059814; z:-73.674370
		"\203\043\064\254\169\041\192\057\085\244\018\214\165\043\151\230\134\149\127\196\135\142\156\195\057\089\147\194" ..
		-- tex:"cb2b40fea929c03955f412d6a52b97e6"; x:-1022.336365; y:-313.113525; z:-73.674271
		"\101\132\004\187\046\238\133\139\194\035\222\048\247\226\071\157\159\088\065\068\073\146\156\195\051\089\147\194" ..
		-- tex:"658404bb2eee858bc223de30f7e2479d"; x:773.384766; y:-313.142883; z:-73.674225
		"\185\022\214\002\183\225\047\237\034\093\084\179\103\042\052\045\229\119\139\066\218\242\127\196\051\089\147\194" ..
		-- tex:"b916d602b7e12fed225d54b3672a342d"; x:69.734177; y:-1023.794617; z:-73.674225
		"\195\153\059\096\196\112\049\166\253\220\221\244\233\069\021\188\086\177\139\066\179\197\063\068\049\089\147\194" ..
		-- tex:"c3993b60c47031a6fddcddf4e94515bc"; x:69.846367; y:767.089111; z:-73.674210
		"\051\058\254\046\231\084\082\148\214\199\099\099\032\119\118\065\134\020\128\068\058\093\136\066\049\089\147\194" ..
		-- tex:"333afe2ee7545294d6c7636320777641"; x:1024.641418; y:68.182091; z:-73.674210
		"\231\063\228\050\176\007\051\119\095\215\038\226\121\250\129\030\012\041\064\068\058\093\136\066\049\089\147\194" ..
		-- tex:"e73fe432b00733775fd726e279fa811e"; x:768.641418; y:68.182091; z:-73.674210
		"\010\213\112\132\102\045\036\110\227\152\079\167\090\132\000\021\086\177\139\066\179\197\127\068\049\089\147\194" ..
		-- tex:"0ad57084662d246ee3984fa75a840015"; x:69.846367; y:1023.089111; z:-73.674210
		"\046\022\051\154\164\013\046\200\065\178\215\102\160\000\111\130\100\146\127\196\188\150\136\066\047\089\147\194" ..
		-- tex:"2e16339aa40d2ec841b2d766a0006f82"; x:-1022.287415; y:68.294411; z:-73.674194
		"\218\120\047\159\181\075\211\038\126\203\104\045\097\222\002\080\065\189\155\195\179\197\127\068\047\089\147\194" ..
		-- tex:"da782f9fb54bd3267ecb682d61de0250"; x:-311.478577; y:1023.089111; z:-73.674194
		"\228\119\193\075\055\132\252\041\188\045\177\037\062\031\020\107\065\189\155\195\179\197\063\068\047\089\147\194" ..
		-- tex:"e477c14b3784fc29bc2db1253e1f146b"; x:-311.478577; y:767.089111; z:-73.674194
		"\172\109\152\145\254\250\036\172\068\157\239\008\216\182\085\194\041\099\243\195\116\199\118\196\194\227\146\194" ..
		-- tex:"ac6d9891fefa24ac449def08d8b655c2"; x:-486.774719; y:-987.116516; z:-73.444847
		"\205\157\190\074\093\013\163\107\050\037\064\145\045\069\053\104\172\067\157\067\118\219\073\068\185\227\146\194" ..
		-- tex:"cd9dbe4a5d0da36b322540912d453568"; x:314.528717; y:807.429138; z:-73.444778
		"\242\115\084\207\246\145\203\110\057\195\164\203\147\152\167\234\148\062\074\068\141\110\156\067\185\227\146\194" ..
		-- tex:"f27354cff691cb6e39c3a4cb9398a7ea"; x:808.977844; y:312.863708; z:-73.444778
		"\174\190\182\072\197\052\090\183\118\143\120\049\178\112\020\040\070\084\243\195\064\219\073\068\183\227\146\194" ..
		-- tex:"aebeb648c5345ab7768f7831b2701428"; x:-486.658417; y:807.425842; z:-73.444763
		"\225\213\099\249\039\075\175\018\027\039\196\248\049\177\182\212\004\080\118\196\005\125\156\067\183\227\146\194" ..
		-- tex:"e1d563f9274baf121b27c4f831b1b6d4"; x:-985.250305; y:312.976746; z:-73.444763
		"\222\038\233\078\036\090\017\021\038\140\015\227\100\102\043\063\207\079\118\196\214\026\244\195\182\227\146\194" ..
		-- tex:"de26e94e245a1115268c0fe364662b3f"; x:-985.247070; y:-488.209686; z:-73.444756
		"\138\176\023\100\107\128\240\160\146\127\195\093\002\046\005\196\053\097\220\195\113\246\181\195\109\005\135\194" ..
		-- tex:"8ab017646b80f0a0927fc35d022e05c4"; x:-440.759460; y:-363.925354; z:-67.510605
		"\140\020\136\071\050\215\118\169\137\011\030\082\172\095\005\201\154\048\046\196\199\217\215\194\109\005\135\194" ..
		-- tex:"8c14884732d776a9890b1e52ac5f05c9"; x:-696.759460; y:-107.925354; z:-67.510605
		"\240\002\209\141\049\127\164\024\243\015\087\205\175\211\127\071\154\048\046\196\113\246\181\195\109\005\135\194" ..
		-- tex:"f002d18d317fa418f30f57cdafd37f47"; x:-696.759460; y:-363.925354; z:-67.510605
		"\076\253\184\087\197\131\190\074\243\107\071\055\001\083\088\242\053\097\220\195\199\217\215\194\109\005\135\194" ..
		-- tex:"4cfdb857c583be4af36b4737015358f2"; x:-440.759460; y:-107.925354; z:-67.510605
		"\155\071\193\132\039\062\054\008\027\225\146\162\164\144\091\085\192\199\035\068\072\137\052\196\145\233\133\194" ..
		-- tex:"9b47c184273e36081be192a2a4905b55"; x:655.121155; y:-722.145081; z:-66.956192
		"\057\143\099\100\048\159\076\091\135\113\160\127\088\034\172\151\129\143\199\067\145\018\233\195\145\233\133\194" ..
		-- tex:"398f6364309f4c5b8771a07f5822ac97"; x:399.121155; y:-466.145081; z:-66.956192
		"\105\047\094\233\158\211\147\007\252\091\176\212\187\212\185\163\192\199\035\068\145\018\233\195\145\233\133\194" ..
		-- tex:"692f5ee99ed39307fc5bb0d4bbd4b9a3"; x:655.121155; y:-466.145081; z:-66.956192
		"\138\146\222\026\245\245\247\105\157\206\128\104\253\197\165\134\129\143\199\067\072\137\052\196\145\233\133\194" ..
		-- tex:"8a92de1af5f5f7699dce8068fdc5a586"; x:399.121155; y:-722.145081; z:-66.956192
		"\094\089\222\253\103\061\212\068\245\100\247\168\187\154\090\182\154\210\240\067\151\039\031\194\164\094\133\194" ..
		-- tex:"5e59defd673dd444f564f7a8bb9a5ab6"; x:481.645355; y:-39.788666; z:-66.684853
		"\253\183\103\254\229\225\118\170\077\036\023\125\175\187\010\155\154\210\240\067\242\228\147\195\164\094\133\194" ..
		-- tex:"fdb767fee5e176aa4d24177dafbb0a9b"; x:481.645355; y:-295.788666; z:-66.684853
		"\128\158\238\219\190\231\006\252\182\211\249\167\171\191\247\040\077\105\056\068\151\039\031\194\164\094\133\194" ..
		-- tex:"809eeedbbee706fcb6d3f9a7abbff728"; x:737.645355; y:-39.788666; z:-66.684853
		"\114\246\012\230\028\130\133\075\108\238\118\040\092\112\025\104\077\105\056\068\242\228\147\195\164\094\133\194" ..
		-- tex:"72f60ce61c82854b6cee76285c701968"; x:737.645355; y:-295.788666; z:-66.684853
		"\219\058\133\053\067\160\230\092\110\023\193\033\204\095\167\129\213\164\200\067\232\022\141\195\052\067\133\194" ..
		-- tex:"db3a853543a0e65c6e17c121cc5fa781"; x:401.287781; y:-282.178986; z:-66.631264
		"\110\149\115\205\214\141\187\072\228\070\134\000\007\191\011\130\165\040\174\067\094\020\062\196\051\067\133\194" ..
		-- tex:"6e9573cdd68dbb48e446860007bf0b82"; x:348.317558; y:-760.318298; z:-66.631256
		"\249\230\033\070\027\120\067\158\124\250\225\087\252\161\027\026\165\040\174\067\189\040\252\195\051\067\133\194" ..
		-- tex:"f9e621461b78439e7cfae157fca11b1a"; x:348.317558; y:-504.318298; z:-66.631256
		"\184\226\132\161\099\045\060\174\193\054\030\221\133\000\205\250\150\162\184\066\094\020\062\196\051\067\133\194" ..
		-- tex:"b8e284a1632d3caec1361edd8500cdfa"; x:92.317558; y:-760.318298; z:-66.631256
		"\180\135\064\234\056\204\153\041\090\211\180\224\247\089\223\019\150\162\184\066\189\040\252\195\051\067\133\194" ..
		-- tex:"b48740ea38cc99295ad3b4e0f759df13"; x:92.317558; y:-504.318298; z:-66.631256
		"\213\180\025\200\106\205\095\014\123\022\200\000\119\155\037\185\073\134\025\067\197\005\025\068\176\024\129\194" ..
		-- tex:"d5b419c86acd5f0e7b16c800779b25b9"; x:153.524567; y:612.090210; z:-64.548225
		"\191\242\251\124\076\192\058\241\175\077\217\177\133\133\185\017\036\195\204\067\197\005\025\068\176\024\129\194" ..
		-- tex:"bff2fb7c4cc03af1af4dd9b18585b911"; x:409.524567; y:612.090210; z:-64.548225
		"\118\153\053\026\088\082\135\184\106\046\172\196\187\111\192\133\207\202\104\195\091\176\035\068\193\189\115\194" ..
		-- tex:"7699351a585287b86a2eacc4bb6fc085"; x:-232.792236; y:654.755615; z:-60.935310
		"\116\104\143\217\188\144\180\062\023\124\182\001\206\183\059\115\090\049\154\067\031\095\128\068\248\191\113\194" ..
		-- tex:"74688fd9bc90b43e177cb601ceb73b73"; x:308.385590; y:1026.972656; z:-60.437473
		"\228\018\182\242\028\173\205\212\251\169\127\074\015\192\207\085\215\138\081\066\031\095\128\068\248\191\113\194" ..
		-- tex:"e412b6f21cadcdd4fba97f4a0fc0cf55"; x:52.385590; y:1026.972656; z:-60.437473
		"\090\226\091\117\207\011\213\118\131\144\041\070\013\195\205\135\252\209\179\067\168\192\202\067\181\012\095\194" ..
		-- tex:"5ae25b75cf0bd576839029460dc3cd87"; x:359.640533; y:405.505157; z:-55.762413
		"\116\083\186\208\220\033\063\247\182\163\161\042\023\213\255\084\084\246\201\195\017\095\013\195\123\228\063\194" ..
		-- tex:"7453bad0dc213ff7b6a3a12a17d5ff54"; x:-403.924469; y:-141.371368; z:-47.973129
		"\235\245\022\059\193\247\003\071\078\010\243\144\072\073\198\200\169\236\019\195\136\175\198\195\123\228\063\194" ..
		-- tex:"ebf5163bc1f703474e0af3904849c6c8"; x:-147.924469; y:-397.371368; z:-47.973129
		"\003\161\034\026\159\007\093\206\227\173\155\204\237\240\242\223\084\246\201\195\136\175\198\195\123\228\063\194" ..
		-- tex:"03a1221a9f075dcee3ad9bccedf0f2df"; x:-403.924469; y:-397.371368; z:-47.973129
		"\088\129\107\164\158\176\236\175\089\163\109\130\018\184\140\169\200\152\226\195\031\226\114\067\247\120\042\194" ..
		-- tex:"58816ba49eb0ecaf59a36d8212b88ca9"; x:-453.193634; y:242.883301; z:-42.618134
		"\224\073\212\172\213\088\053\185\240\187\223\001\191\010\039\205\044\168\033\195\242\000\033\195\169\040\041\194" ..
		-- tex:"e049d4acd55835b9f0bbdf01bf0a27cd"; x:-161.656937; y:-161.003708; z:-42.289711
		"\056\171\022\062\015\237\023\025\049\238\027\228\167\079\199\200\165\175\188\066\242\000\033\195\169\040\041\194" ..
		-- tex:"38ab163e0fed171931ee1be4a74fc7c8"; x:94.343063; y:-161.003708; z:-42.289711
		"\058\126\107\117\129\090\033\126\067\131\001\156\219\074\045\168\044\168\033\195\025\254\189\066\169\040\041\194" ..
		-- tex:"3a7e6b75815a217e4383019cdb4a2da8"; x:-161.656937; y:94.996292; z:-42.289711
		"\118\164\010\009\174\138\089\234\115\096\255\137\168\098\093\110\086\208\045\196\145\140\045\196\072\132\030\194" ..
		-- tex:"76a40a09ae8a59ea7360ff89a8625d6e"; x:-695.255310; y:-694.196411; z:-39.629185
		"\033\013\172\081\196\139\042\027\031\174\200\132\159\038\043\079\094\168\163\195\207\162\169\066\091\075\015\194" ..
		-- tex:"210dac51c48b2a1b1faec8849f262b4f"; x:-327.315399; y:84.817993; z:-35.823593
		"\082\033\252\193\186\040\160\207\104\105\026\193\148\157\241\137\111\252\040\196\184\159\062\194\135\104\006\194" ..
		-- tex:"5221fcc1ba28a0cf68691ac1949df189"; x:-675.944336; y:-47.655979; z:-33.602081
		"\176\045\025\249\196\121\090\125\147\147\065\026\195\202\081\171\111\252\040\196\017\088\080\067\135\104\006\194" ..
		-- tex:"b02d19f9c4795a7d9393411ac3ca51ab"; x:-675.944336; y:208.344021; z:-33.602081
		"\226\052\112\126\070\093\005\157\151\208\150\125\087\234\036\009\223\248\209\195\184\159\062\194\135\104\006\194" ..
		-- tex:"e234707e465d059d97d0967d57ea2409"; x:-419.944336; y:-47.655979; z:-33.602081
		"\142\104\067\053\093\175\059\145\219\052\147\047\230\036\058\101\179\109\067\195\181\133\065\195\249\090\005\194" ..
		-- tex:"8e6843355daf3b91db34932fe6243a65"; x:-195.428528; y:-193.522308; z:-33.338844
		"\104\171\241\060\147\092\105\199\186\234\162\187\015\153\131\153\057\082\198\195\016\210\030\066\248\136\234\193" ..
		-- tex:"68abf13c935c69c7baeaa2bb0f998399"; x:-396.642395; y:39.705143; z:-29.316881
		"\127\187\229\055\161\120\008\137\132\007\014\125\203\046\196\115\249\047\087\196\059\175\139\196\127\126\229\193" ..
		-- tex:"7fbbe537a178088984070e7dcb2ec473"; x:-860.749634; y:-1117.476074; z:-28.686768
		"\025\092\020\085\016\101\115\171\005\179\190\068\091\249\241\090\249\047\087\196\119\094\087\196\127\126\229\193" ..
		-- tex:"195c1455106573ab05b3be445bf9f15a"; x:-860.749634; y:-861.476074; z:-28.686768
		"\178\170\125\023\118\070\209\127\167\130\100\015\166\168\116\037\252\151\139\196\119\094\087\196\127\126\229\193" ..
		-- tex:"b2aa7d177646d17fa782640fa6a87425"; x:-1116.749634; y:-861.476074; z:-28.686768
		"\238\173\067\248\254\111\172\064\043\046\158\109\119\247\004\202\252\151\139\196\059\175\139\196\127\126\229\193" ..
		-- tex:"eead43f8fe6fac402b2e9e6d77f704ca"; x:-1116.749634; y:-1117.476074; z:-28.686768
		"\200\080\105\156\243\229\253\066\225\196\102\218\170\032\110\081\107\156\026\195\045\103\111\066\131\184\222\193" ..
		-- tex:"c850699cf3e5fd42e1c466daaa206e51"; x:-154.611023; y:59.850761; z:-27.840096
		"\113\191\183\147\108\105\106\032\146\062\186\191\001\186\181\144\134\050\173\195\131\137\006\196\187\158\165\193" ..
		-- tex:"71bfb7936c696a20923ebabf01bab590"; x:-346.394745; y:-538.148682; z:-20.702507
		"\147\099\175\088\252\238\247\082\133\133\135\020\226\243\213\213\109\009\089\196\082\202\031\068\123\124\154\193" ..
		-- tex:"9363af58fceef75285858714e2f3d5d5"; x:-868.147339; y:639.161316; z:-19.310783
		"\047\078\209\116\114\240\103\051\075\023\142\101\169\082\073\240\149\054\246\195\148\197\125\196\221\121\154\193" ..
		-- tex:"2f4ed17472f067334b178e65a95249f0"; x:-492.426453; y:-1015.087219; z:-19.309505
		"\106\237\239\028\193\135\068\252\177\119\051\015\000\084\006\050\074\027\059\196\148\197\125\196\221\121\154\193" ..
		-- tex:"6aedef1cc18744fcb177330f00540632"; x:-748.426453; y:-1015.087219; z:-19.309505
		"\213\007\027\131\015\162\224\019\214\004\170\164\059\247\031\168\074\027\059\196\148\197\061\196\221\121\154\193" ..
		-- tex:"d5071b830fa2e013d604aaa43bf71fa8"; x:-748.426453; y:-759.087219; z:-19.309505
		"\144\040\180\019\197\090\220\100\183\218\160\149\130\154\183\137\161\145\063\196\219\028\090\196\200\121\154\193" ..
		-- tex:"9028b413c55adc64b7daa095829ab789"; x:-766.275513; y:-872.450928; z:-19.309465
		"\229\080\242\150\187\034\156\086\058\147\234\039\056\240\078\105\161\145\127\196\219\028\026\196\200\121\154\193" ..
		-- tex:"e550f296bb229c563a93ea2738f04e69"; x:-1022.275513; y:-616.450928; z:-19.309465
		"\254\183\219\039\004\011\181\071\061\255\235\167\193\054\230\109\161\145\063\196\219\028\026\196\200\121\154\193" ..
		-- tex:"feb7db27040bb5473dffeba7c136e66d"; x:-766.275513; y:-616.450928; z:-19.309465
		"\000\058\034\128\041\090\011\001\053\111\026\057\204\146\098\144\161\145\127\196\219\028\090\196\200\121\154\193" ..
		-- tex:"003a2280295a0b01356f1a39cc926290"; x:-1022.275513; y:-872.450928; z:-19.309465
		"\199\194\100\072\124\203\023\136\131\226\106\155\004\122\227\238\151\163\060\068\156\005\244\067\182\121\154\193" ..
		-- tex:"c7c264487ccb178883e26a9b047ae3ee"; x:754.556152; y:488.043854; z:-19.309431
		"\030\060\019\197\086\089\189\139\227\049\014\046\185\132\042\114\163\218\244\067\086\063\060\068\182\121\154\193" ..
		-- tex:"1e3c13c55659bd8be3310e2eb9842a72"; x:489.708130; y:752.989685; z:-19.309431
		"\062\254\218\194\073\086\125\170\025\036\247\018\170\202\182\100\151\163\060\068\206\002\058\068\182\121\154\193" ..
		-- tex:"3efedac249567daa1924f712aacab664"; x:754.556152; y:744.043854; z:-19.309431
		"\148\155\194\117\194\008\130\031\060\091\014\020\245\027\176\107\081\109\058\068\086\063\060\068\182\121\154\193" ..
		-- tex:"949bc275c208821f3c5b0e14f51bb06b"; x:745.708130; y:752.989685; z:-19.309431
		"\227\100\014\061\191\160\178\105\121\155\219\015\181\086\065\070\163\218\244\067\086\063\124\068\182\121\154\193" ..
		-- tex:"e3640e3dbfa0b269799bdb0fb5564146"; x:489.708130; y:1008.989685; z:-19.309431
		"\242\105\134\081\252\117\178\025\020\182\231\036\174\117\174\128\151\163\124\068\156\005\244\067\182\121\154\193" ..
		-- tex:"f2698651fc75b21914b6e724ae75ae80"; x:1010.556152; y:488.043854; z:-19.309431
		"\218\061\066\101\062\055\208\116\230\104\195\161\171\211\108\206\166\045\032\068\183\195\031\068\177\121\154\193" ..
		-- tex:"da3d42653e37d074e668c3a1abd36cce"; x:640.713318; y:639.058105; z:-19.309422
		"\043\222\175\096\201\018\174\197\243\158\067\126\144\053\119\174\020\146\127\196\252\019\244\067\175\121\154\193" ..
		-- tex:"2bdeaf60c912aec5f39e437e903577ae"; x:-1022.282532; y:488.156158; z:-19.309418
		"\180\088\204\001\146\038\040\122\254\149\059\005\164\164\124\131\020\146\127\196\254\009\058\068\175\121\154\193" ..
		-- tex:"b458cc019226287afe953b05a4a47c83"; x:-1022.282532; y:744.156158; z:-19.309418
		"\198\093\159\184\049\202\252\151\039\205\074\125\043\031\034\164\020\146\063\196\252\019\244\067\175\121\154\193" ..
		-- tex:"c65d9fb831cafc9727cd4a7d2b1f22a4"; x:-766.282532; y:488.156158; z:-19.309418
		"\060\181\036\144\196\245\017\007\073\015\079\189\184\227\063\235\188\057\060\196\067\064\124\068\172\121\154\193" ..
		-- tex:"3cb52490c4f51107490f4fbdb8e33feb"; x:-752.902161; y:1009.004150; z:-19.309412
		"\229\154\007\190\152\151\204\254\077\014\181\040\205\063\228\048\121\115\248\195\067\064\060\068\172\121\154\193" ..
		-- tex:"e59a07be9897ccfe4d0eb528cd3fe430"; x:-496.902161; y:753.004150; z:-19.309412
		"\173\251\192\066\005\255\117\042\114\035\226\030\011\086\130\050\188\057\060\196\067\064\060\068\172\121\154\193" ..
		-- tex:"adfbc04205ff752a7223e21e0b568232"; x:-752.902161; y:753.004150; z:-19.309412
		"\151\082\044\218\031\038\036\131\214\231\068\204\234\197\040\062\135\164\027\195\115\213\254\195\023\071\131\193" ..
		-- tex:"97522cda1f262483d6e744cceac5283e"; x:-155.642700; y:-509.667603; z:-16.409714
		"\241\036\086\006\109\142\088\181\089\090\016\161\188\247\231\190\135\164\027\195\185\106\063\196\023\071\131\193" ..
		-- tex:"f12456066d8e58b5595a10a1bcf7e7be"; x:-155.642700; y:-765.667603; z:-16.409714
		"\065\155\062\241\165\050\105\035\196\102\235\045\013\192\155\115\033\233\038\196\185\106\063\196\023\071\131\193" ..
		-- tex:"419b3ef1a5326923c466eb2d0dc09b73"; x:-667.642700; y:-765.667603; z:-16.409714
		"\119\192\139\234\168\245\108\149\236\192\203\009\006\000\091\216\067\210\205\195\185\106\063\196\023\071\131\193" ..
		-- tex:"77c08beaa8f56c95ecc0cb0906005bd8"; x:-411.642700; y:-765.667603; z:-16.409714
		"\045\036\008\124\151\085\228\175\042\042\135\150\110\030\183\178\067\210\205\195\115\213\254\195\023\071\131\193" ..
		-- tex:"2d24087c9755e4af2a2a87966e1eb7b2"; x:-411.642700; y:-509.667603; z:-16.409714
		"\163\211\240\089\036\221\202\109\209\208\134\092\155\154\221\198\033\233\038\196\115\213\254\195\023\071\131\193" ..
		-- tex:"a3d3f05924ddca6dd1d0865c9b9addc6"; x:-667.642700; y:-509.667603; z:-16.409714
		"\172\229\113\036\122\107\053\035\226\085\073\166\071\201\245\168\191\212\145\066\105\154\091\066\235\029\127\193" ..
		-- tex:"ace571247a6b3523e25549a647c9f5a8"; x:72.915527; y:54.900795; z:-15.944805
		"\238\128\190\213\214\103\197\211\135\092\075\006\040\192\105\044\047\117\164\067\105\154\091\066\235\029\127\193" ..
		-- tex:"ee80bed5d667c5d3875c4b0628c0692c"; x:328.915527; y:54.900795; z:-15.944805
		"\196\110\059\142\117\117\084\060\203\251\003\086\204\053\018\027\061\165\113\066\033\175\001\195\057\041\188\192" ..
		-- tex:"c46e3b8e7575543ccbfb0356cc35121b"; x:60.411369; y:-129.684113; z:-5.880033
		"\133\130\175\086\210\177\178\149\080\072\217\169\183\142\040\142\167\052\158\067\144\215\192\195\057\041\188\192" ..
		-- tex:"8582af56d2b1b2955048d9a9b78e288e"; x:316.411369; y:-385.684113; z:-5.880033
		"\005\052\213\012\245\067\099\056\061\178\251\164\149\251\057\192\061\165\113\066\144\215\192\195\057\041\188\192",
		-- tex:"0534d50cf54363383db2fba495fb39c0"; x:60.411369; y:-385.684113; z:-5.880033
	["Old Hillsbrad Foothills"] = 
		"\096\146\171\052\042\027\224\185\059\252\080\143\003\025\068\021\255\255\215\069\255\255\199\197\000\000\000\000" ..
		-- tex:"6092ab342a1be0b93bfc508f03194415"; x:6912.000000; y:-6400.000000
		"\082\050\011\185\099\130\158\184\168\097\187\034\127\119\163\191\255\255\215\069\255\255\207\197\000\000\000\000" ..
		-- tex:"52320bb963829eb8a861bb227f77a3bf"; x:6912.000000; y:-6656.000000
		"\060\159\201\098\196\158\200\033\017\034\077\134\201\023\076\047\255\255\215\069\255\255\215\197\000\000\000\000" ..
		-- tex:"3c9fc962c49ec82111224d86c9174c2f"; x:6912.000000; y:-6912.000000
		"\166\170\140\240\245\172\095\070\113\165\250\179\166\214\109\019\255\255\215\069\255\255\223\197\000\000\000\000" ..
		-- tex:"a6aa8cf0f5ac5f4671a5fab3a6d66d13"; x:6912.000000; y:-7168.000000
		"\017\063\176\104\084\140\002\238\052\011\234\122\048\005\075\137\255\255\215\069\255\255\231\197\000\000\000\000" ..
		-- tex:"113fb068548c02ee340bea7a30054b89"; x:6912.000000; y:-7424.000000
		"\016\146\223\162\132\206\091\161\132\182\171\009\050\248\253\122\255\255\215\069\255\255\239\197\000\000\000\000" ..
		-- tex:"1092dfa284ce5ba184b6ab0932f8fd7a"; x:6912.000000; y:-7680.000000
		"\089\220\092\066\168\179\107\009\035\168\158\126\141\228\027\225\255\255\223\069\255\255\199\197\000\000\000\000" ..
		-- tex:"59dc5c42a8b36b0923a89e7e8de41be1"; x:7168.000000; y:-6400.000000
		"\044\198\061\071\087\040\210\094\223\148\160\096\115\200\191\153\255\255\223\069\255\255\207\197\000\000\000\000" ..
		-- tex:"2cc63d475728d25edf94a06073c8bf99"; x:7168.000000; y:-6656.000000
		"\074\146\250\140\066\125\212\029\126\167\192\183\241\074\199\117\255\255\223\069\255\255\215\197\000\000\000\000" ..
		-- tex:"4a92fa8c427dd41d7ea7c0b7f14ac775"; x:7168.000000; y:-6912.000000
		"\208\046\219\076\133\062\235\042\080\002\194\059\232\216\118\135\255\255\223\069\255\255\223\197\000\000\000\000" ..
		-- tex:"d02edb4c853eeb2a5002c23be8d87687"; x:7168.000000; y:-7168.000000
		"\129\161\019\105\110\021\195\201\177\200\167\172\196\167\104\054\255\255\223\069\255\255\231\197\000\000\000\000" ..
		-- tex:"81a113696e15c3c9b1c8a7acc4a76836"; x:7168.000000; y:-7424.000000
		"\019\091\122\044\153\140\127\237\073\114\045\091\033\158\171\139\255\255\223\069\255\255\239\197\000\000\000\000" ..
		-- tex:"135b7a2c998c7fed49722d5b219eab8b"; x:7168.000000; y:-7680.000000
		"\144\007\038\246\049\167\243\187\032\067\251\046\255\038\063\026\255\255\231\069\255\255\199\197\000\000\000\000" ..
		-- tex:"900726f631a7f3bb2043fb2eff263f1a"; x:7424.000000; y:-6400.000000
		"\120\012\136\072\049\079\132\233\110\077\069\047\019\237\161\166\255\255\231\069\255\255\207\197\000\000\000\000" ..
		-- tex:"780c8848314f84e96e4d452f13eda1a6"; x:7424.000000; y:-6656.000000
		"\081\080\206\009\150\160\157\196\155\116\243\206\200\201\201\179\255\255\231\069\255\255\215\197\000\000\000\000" ..
		-- tex:"5150ce0996a09dc49b74f3cec8c9c9b3"; x:7424.000000; y:-6912.000000
		"\093\035\171\024\156\200\013\144\102\125\230\026\225\108\131\100\255\255\231\069\255\255\223\197\000\000\000\000" ..
		-- tex:"5d23ab189cc80d90667de61ae16c8364"; x:7424.000000; y:-7168.000000
		"\254\055\243\003\093\108\228\137\246\123\156\228\086\091\222\097\255\255\231\069\255\255\231\197\000\000\000\000" ..
		-- tex:"fe37f3035d6ce489f67b9ce4565bde61"; x:7424.000000; y:-7424.000000
		"\117\052\166\093\158\075\209\153\106\089\070\004\008\235\058\013\255\255\231\069\255\255\239\197\000\000\000\000" ..
		-- tex:"7534a65d9e4bd1996a59460408eb3a0d"; x:7424.000000; y:-7680.000000
		"\006\223\151\093\240\075\061\147\126\010\073\081\211\007\082\233\255\255\239\069\255\255\199\197\000\000\000\000" ..
		-- tex:"06df975df04b3d937e0a4951d30752e9"; x:7680.000000; y:-6400.000000
		"\119\204\194\220\035\077\198\014\000\098\195\220\028\200\209\133\255\255\239\069\255\255\207\197\000\000\000\000" ..
		-- tex:"77ccc2dc234dc60e0062c3dc1cc8d185"; x:7680.000000; y:-6656.000000
		"\163\018\202\011\222\185\185\110\252\100\180\138\072\074\041\084\255\255\239\069\255\255\215\197\000\000\000\000" ..
		-- tex:"a312ca0bdeb9b96efc64b48a484a2954"; x:7680.000000; y:-6912.000000
		"\014\130\130\239\050\005\002\140\105\155\128\237\005\239\151\238\255\255\239\069\255\255\223\197\000\000\000\000" ..
		-- tex:"0e8282ef3205028c699b80ed05ef97ee"; x:7680.000000; y:-7168.000000
		"\208\093\056\241\192\048\078\051\203\002\179\225\110\252\081\049\255\255\239\069\255\255\231\197\000\000\000\000" ..
		-- tex:"d05d38f1c0304e33cb02b3e16efc5131"; x:7680.000000; y:-7424.000000
		"\070\209\244\218\162\167\025\195\226\194\048\003\126\037\217\145\255\255\239\069\255\255\239\197\000\000\000\000" ..
		-- tex:"46d1f4daa2a719c3e2c230037e25d991"; x:7680.000000; y:-7680.000000
		"\131\049\141\174\018\241\246\123\160\129\155\028\237\206\098\060\255\255\247\069\255\255\199\197\000\000\000\000" ..
		-- tex:"83318dae12f1f67ba0819b1cedce623c"; x:7936.000000; y:-6400.000000
		"\247\066\216\209\004\066\068\042\145\058\170\186\141\227\095\117\255\255\247\069\255\255\207\197\000\000\000\000" ..
		-- tex:"f742d8d10442442a913aaaba8de35f75"; x:7936.000000; y:-6656.000000
		"\154\190\213\137\032\238\000\141\069\121\242\016\145\071\241\087\255\255\247\069\255\255\215\197\000\000\000\000" ..
		-- tex:"9abed58920ee008d4579f2109147f157"; x:7936.000000; y:-6912.000000
		"\085\200\131\237\088\065\109\039\090\005\003\056\098\113\241\023\255\255\247\069\255\255\223\197\000\000\000\000" ..
		-- tex:"55c883ed58416d275a0503386271f117"; x:7936.000000; y:-7168.000000
		"\158\002\102\201\017\085\108\050\110\229\061\143\170\190\214\081\255\255\247\069\255\255\231\197\000\000\000\000" ..
		-- tex:"9e0266c911556c326ee53d8faabed651"; x:7936.000000; y:-7424.000000
		"\060\220\129\240\252\044\045\188\134\066\067\164\094\049\117\244\255\255\247\069\255\255\239\197\000\000\000\000" ..
		-- tex:"3cdc81f0fc2c2dbc864243a45e3175f4"; x:7936.000000; y:-7680.000000
		"\119\105\141\121\030\014\091\194\021\050\213\105\182\068\173\003\000\000\000\070\255\255\199\197\000\000\000\000" ..
		-- tex:"77698d791e0e5bc21532d569b644ad03"; x:8192.000000; y:-6400.000000
		"\180\113\210\113\134\218\200\238\172\051\122\053\148\198\126\224\000\000\000\070\255\255\207\197\000\000\000\000" ..
		-- tex:"b471d27186dac8eeac337a3594c67ee0"; x:8192.000000; y:-6656.000000
		"\135\208\195\092\019\051\206\012\235\162\068\179\222\137\127\172\000\000\000\070\255\255\215\197\000\000\000\000" ..
		-- tex:"87d0c35c1333ce0ceba244b3de897fac"; x:8192.000000; y:-6912.000000
		"\222\180\254\221\019\157\241\214\012\164\026\228\073\242\090\168\000\000\000\070\255\255\223\197\000\000\000\000" ..
		-- tex:"deb4fedd139df1d60ca41ae449f25aa8"; x:8192.000000; y:-7168.000000
		"\052\013\050\170\107\173\033\039\090\143\160\071\006\007\044\170\000\000\000\070\255\255\231\197\000\000\000\000" ..
		-- tex:"340d32aa6bad21275a8fa04706072caa"; x:8192.000000; y:-7424.000000
		"\078\039\026\091\099\166\114\167\036\089\003\145\205\079\127\081\000\000\000\070\255\255\239\197\000\000\000\000",
		-- tex:"4e271a5b63a672a724590391cd4f7f51"; x:8192.000000; y:-7680.000000
	["Onyxia's Lair"] = 
		"\054\092\072\002\104\252\037\073\192\210\163\074\142\221\051\051\078\183\009\067\203\044\007\068\072\243\064\195" ..
		-- tex:"365c480268fc2549c0d2a34a8edd3333"; x:137.716049; y:540.699951; z:-192.950333
		"\187\120\049\143\121\236\207\053\101\040\089\006\040\138\185\164\097\145\236\194\151\089\142\067\072\243\064\195" ..
		-- tex:"bb78318f79eccf3565285906288ab9a4"; x:-118.283951; y:284.699951; z:-192.950333
		"\103\246\153\066\096\060\059\098\041\222\233\007\080\032\021\115\097\145\236\194\203\044\007\068\072\243\064\195" ..
		-- tex:"67f69942603c3b6229dee90750201573"; x:-118.283951; y:540.699951; z:-192.950333
		"\080\190\005\078\044\225\204\193\113\205\164\191\039\175\150\156\078\183\009\067\151\089\142\067\072\243\064\195" ..
		-- tex:"50be054e2ce1ccc171cda4bf27af969c"; x:137.716049; y:284.699951; z:-192.950333
		"\241\023\042\046\082\021\212\141\195\235\002\184\179\207\219\179\152\052\125\067\198\013\110\067\170\169\013\195" ..
		-- tex:"f1172a2e5215d48dc3eb02b8b3cfdbb3"; x:253.205460; y:238.053818; z:-141.662766
		"\224\127\009\025\246\075\144\241\178\011\252\122\086\207\237\196\152\052\125\067\227\006\247\067\170\169\013\195" ..
		-- tex:"e07f0919f64b90f1b20bfc7a56cfedc4"; x:253.205460; y:494.053818; z:-141.662766
		"\056\153\098\013\019\162\134\119\006\253\231\071\240\091\015\176\027\147\032\067\157\130\050\067\177\023\253\194" ..
		-- tex:"3899620d13a2867706fde747f05b0fb0"; x:160.574646; y:178.510223; z:-126.546280
		"\118\007\136\080\069\136\016\253\107\008\253\064\081\221\002\007\132\111\066\066\166\209\026\067\211\027\162\194" ..
		-- tex:"76078850458810fd6b08fd4051dd0207"; x:48.608906; y:154.818954; z:-81.054352
		"\144\034\171\066\180\148\247\134\037\024\189\027\248\166\152\242\079\194\095\064\235\109\042\067\186\084\133\194" ..
		-- tex:"9022ab42b494f7862518bd1bf8a698f2"; x:3.496235; y:170.429382; z:-66.665489
		"\135\210\105\081\234\038\158\234\205\089\066\209\084\072\102\171\216\251\252\194\169\112\197\066\071\208\103\194" ..
		-- tex:"87d26951ea269eeacd5942d1544866ab"; x:-126.491890; y:98.720047; z:-57.953400
		"\252\224\061\087\254\159\251\149\025\200\134\140\039\009\206\168\221\124\180\194\095\111\203\065\164\141\024\193",
		-- tex:"fce03d57fe9ffb9519c8868c2709cea8"; x:-90.243881; y:25.429382; z:-9.534581
	["Ragefire Chasm"] = 
		"\187\169\168\222\125\035\097\000\056\082\230\165\134\022\014\007\230\160\001\068\253\173\196\194\003\098\004\195" ..
		-- tex:"bba9a8de7d2361003852e6a586160e07"; x:518.514069; y:-98.339828; z:-132.382874
		"\110\034\033\238\186\213\069\218\205\043\244\190\129\208\009\063\204\065\131\067\000\169\029\067\003\098\004\195" ..
		-- tex:"6e2221eebad545dacd2bf4be81d0093f"; x:262.514069; y:157.660172; z:-132.382874
		"\210\117\194\200\156\247\124\106\002\155\111\099\052\112\105\083\204\065\131\067\253\173\196\194\003\098\004\195" ..
		-- tex:"d275c2c89cf77c6a029b6f6334706953"; x:262.514069; y:-98.339828; z:-132.382874
		"\071\057\145\235\250\217\090\015\098\152\104\070\255\219\208\246\230\160\001\068\000\169\029\067\003\098\004\195" ..
		-- tex:"473991ebfad95a0f62986846ffdbd0f6"; x:518.514069; y:157.660172; z:-132.382874
		"\232\254\131\069\073\189\103\091\185\131\185\198\133\138\105\101\107\049\005\067\018\029\022\065\023\226\175\194" ..
		-- tex:"e8fe834549bd675bb983b9c6858a6965"; x:133.193054; y:9.382098; z:-87.941589
		"\203\186\118\174\082\159\249\131\090\006\129\225\072\171\090\211\241\180\016\068\045\016\138\195\012\071\159\194" ..
		-- tex:"cbba76ae529ff9835a0681e148ab5ad3"; x:578.827240; y:-276.126404; z:-79.638771
		"\141\196\104\111\243\208\065\163\247\166\121\224\217\158\211\159\241\180\016\068\022\008\005\196\012\071\159\194" ..
		-- tex:"8dc4686ff3d041a3f7a679e0d99ed39f"; x:578.827240; y:-532.126404; z:-79.638771
		"\233\119\178\123\009\157\011\066\073\145\174\164\048\015\242\192\226\105\161\067\022\008\005\196\012\071\159\194" ..
		-- tex:"e977b27b099d0b424991aea4300ff2c0"; x:322.827240; y:-532.126404; z:-79.638771
		"\206\251\088\052\128\011\091\024\087\207\011\077\055\050\013\025\226\105\161\067\045\016\138\195\012\071\159\194" ..
		-- tex:"cefb5834800b5b1857cf0b4d37320d19"; x:322.827240; y:-276.126404; z:-79.638771
		"\102\252\039\084\091\051\036\197\166\216\002\153\231\215\196\118\042\182\005\194\173\089\124\193\052\166\071\194" ..
		-- tex:"66fc27545b3324c5a6d80299e7d7c476"; x:-33.427898; y:-15.771894; z:-49.912312
		"\132\066\156\099\143\019\206\094\211\010\079\146\092\185\114\069\114\142\253\066\051\182\085\195\250\236\066\194" ..
		-- tex:"84429c638f13ce5ed30a4f925cb97245"; x:126.778221; y:-213.711731; z:-48.731426
		"\074\102\140\052\002\093\059\027\106\007\015\116\079\201\067\099\030\161\028\068\009\097\147\195\012\138\053\194" ..
		-- tex:"4a668c34025d3b1b6a070f744fc94363"; x:626.517517; y:-294.758118; z:-45.384815
		"\010\223\101\050\090\052\179\058\253\220\230\130\198\159\255\250\030\161\028\068\132\176\009\196\012\138\053\194" ..
		-- tex:"0adf65325a34b33afddce682c69ffffa"; x:626.517517; y:-550.758118; z:-45.384815
		"\116\254\125\042\189\052\185\206\230\143\189\013\019\084\030\235\077\134\049\195\015\120\251\194\155\187\205\193" ..
		-- tex:"74fe7d2abd34b9cee68fbd0d13541eeb"; x:-177.524628; y:-125.734497; z:-25.716606
		"\155\126\112\247\158\165\155\054\217\045\153\119\111\173\145\012\076\233\077\195\227\094\039\195\021\198\172\193" ..
		-- tex:"9b7e70f79ea59b36d92d99776fad910c"; x:-205.911331; y:-167.370667; z:-21.596722
		"\119\108\033\037\029\127\189\147\166\116\092\087\164\032\129\178\199\166\070\195\213\053\105\195\235\213\123\193" ..
		-- tex:"776c21251d7fbd93a6745c57a42081b2"; x:-198.651489; y:-233.210297; z:-15.739727
		"\234\050\194\177\026\115\035\236\135\036\179\221\180\168\013\175\125\236\066\195\017\193\159\195\152\239\204\064" ..
		-- tex:"ea32c2b11a7323ec8724b3ddb4a80daf"; x:-194.923798; y:-319.508362; z:6.404248
		"\037\125\044\099\069\178\198\123\220\215\034\047\090\203\013\198\053\251\080\194\033\065\186\195\046\255\045\066" ..
		-- tex:"257d2c6345b2c67bdcd7222f5acb0dc6"; x:-52.245323; y:-372.508850; z:43.499203
		"\072\192\167\035\221\177\216\159\085\237\198\100\179\085\167\159\230\038\252\194\168\063\188\195\022\188\084\066",
		-- tex:"48c0a723ddb1d89f55edc664b355a79f"; x:-126.075981; y:-376.497345; z:53.183681
	["Razorfen Downs"] = 
		"\200\223\057\170\031\126\085\012\153\115\046\033\179\252\181\230\038\128\131\195\253\188\009\067\107\222\162\194" ..
		-- tex:"c8df39aa1f7e550c99732e21b3fcb5e6"; x:-263.001190; y:137.738251; z:-81.434418
		"\147\007\005\180\146\179\138\149\231\018\046\091\065\214\088\222\191\009\224\192\253\188\009\067\107\222\162\194" ..
		-- tex:"930705b492b38a95e7122e5b41d658de"; x:-7.001190; y:137.738251; z:-81.434418
		"\204\106\179\189\201\151\196\201\084\097\248\240\137\217\168\018\038\128\131\195\063\111\034\068\107\222\162\194" ..
		-- tex:"cc6ab3bdc997c4c95461f8f089d9a812"; x:-263.001190; y:649.738251; z:-81.434418
		"\095\120\082\231\016\033\085\182\056\110\114\075\251\108\119\136\038\128\131\195\126\222\196\067\107\222\162\194" ..
		-- tex:"5f7852e7102155b6386e724bfb6c7788"; x:-263.001190; y:393.738251; z:-81.434418
		"\027\124\011\255\209\076\114\090\181\030\238\036\140\038\037\109\191\009\224\192\126\222\196\067\107\222\162\194" ..
		-- tex:"1b7c0bffd14c725ab51eee248c26256d"; x:-7.001190; y:393.738251; z:-81.434418
		"\048\096\128\102\017\174\136\186\208\252\044\005\232\235\106\228\191\009\224\192\063\111\034\068\107\222\162\194" ..
		-- tex:"3060806611ae88bad0fc2c05e8eb6ae4"; x:-7.001190; y:649.738251; z:-81.434418
		"\026\024\045\095\074\135\122\196\246\010\045\060\248\029\130\083\168\140\141\195\135\090\022\068\218\097\155\194" ..
		-- tex:"1a182d5f4a877ac4f60a2d3cf81d8253"; x:-283.098907; y:601.414551; z:-77.691124
		"\101\092\090\022\051\071\036\206\133\041\135\142\234\195\207\206\168\140\141\195\015\181\172\067\218\097\155\194" ..
		-- tex:"655c5a16334724ce8529878eeac3cfce"; x:-283.098907; y:345.414551; z:-77.691124
		"\251\181\179\236\185\223\236\234\146\192\086\078\208\227\039\043\143\202\216\193\135\090\022\068\218\097\155\194" ..
		-- tex:"fbb5b3ecb9dfecea92c0564ed0e3272b"; x:-27.098907; y:601.414551; z:-77.691124
		"\176\179\017\105\058\007\112\111\147\002\017\166\112\133\181\094\242\028\073\066\252\084\251\067\114\046\150\194" ..
		-- tex:"b0b311693a07706f930211a67085b55e"; x:50.278271; y:502.663956; z:-75.090721
		"\095\188\225\066\087\209\119\252\103\220\206\224\106\131\075\239\242\028\073\066\248\169\118\067\114\046\150\194" ..
		-- tex:"5fbce14257d177fc67dccee06a834bef"; x:50.278271; y:246.663956; z:-75.090721
		"\096\231\103\176\083\202\225\024\222\229\042\171\164\061\240\038\155\142\038\195\144\223\028\068\033\199\133\194" ..
		-- tex:"60e767b053cae118dee52aaba43df026"; x:-166.557068; y:627.493225; z:-66.888931
		"\076\193\002\051\070\021\128\081\230\024\217\074\085\140\073\078\155\142\038\195\144\223\092\068\033\199\133\194" ..
		-- tex:"4cc1023346158051e618d94a558c494e"; x:-166.557068; y:883.493225; z:-66.888931
		"\130\062\241\205\184\179\252\106\255\163\052\094\035\149\194\245\131\219\222\194\011\252\067\068\062\188\079\194" ..
		-- tex:"823ef1cdb8b3fc6affa3345e2395c2f5"; x:-111.428741; y:783.938232; z:-51.933834
		"\049\041\213\225\168\130\201\046\073\199\119\059\097\159\245\156\224\182\183\195\011\252\067\068\062\188\079\194" ..
		-- tex:"3129d5e1a882c92e49c7773b619ff59c"; x:-367.428741; y:783.938232; z:-51.933834
		"\156\123\142\176\025\173\230\064\052\122\107\023\217\189\041\059\126\093\165\195\230\180\077\068\205\137\024\194" ..
		-- tex:"9c7b8eb019ade640347a6b17d9bd293b"; x:-330.730438; y:822.826599; z:-38.134575
		"\170\226\176\154\007\126\084\094\235\096\154\068\119\143\226\082\126\093\165\195\230\180\013\068\205\137\024\194" ..
		-- tex:"aae2b09a077e545eeb609a44778fe252"; x:-330.730438; y:566.826599; z:-38.134575
		"\121\143\146\229\101\007\131\040\129\164\002\187\198\246\167\178\135\142\215\195\245\051\130\067\138\190\251\193" ..
		-- tex:"798f92e56507832881a402bbc6f6a7b2"; x:-431.113525; y:260.405945; z:-31.468039
		"\195\119\142\034\126\251\180\181\124\142\217\107\250\085\116\087\045\207\124\195\051\151\109\068\059\101\243\193" ..
		-- tex:"c3778e227efbb4b57c8ed96bfa557457"; x:-252.809296; y:950.362549; z:-30.424431
		"\192\177\143\000\002\172\051\105\221\203\024\063\031\191\209\225\127\052\076\064\051\151\109\068\059\101\243\193" ..
		-- tex:"c0b18f0002ac3369ddcb183f1fbfd1e1"; x:3.190704; y:950.362549; z:-30.424431
		"\211\217\117\175\188\028\229\062\230\146\171\011\217\242\025\045\071\227\212\195\219\173\217\067\006\243\241\193" ..
		-- tex:"d3d975afbc1ce53ee692ab0bd9f2192d"; x:-425.775635; y:435.358276; z:-30.243666
		"\045\186\161\133\212\167\253\083\168\197\104\231\055\063\215\174\064\101\227\195\009\103\084\068\131\215\241\193" ..
		-- tex:"2dbaa185d4a7fd53a8c568e7373fd7ae"; x:-454.791046; y:849.609985; z:-30.230232
		"\255\007\021\113\148\255\132\152\109\036\217\112\214\172\213\069\002\088\218\195\139\048\058\067\106\213\232\193",
		-- tex:"ff07157194ff84986d24d970d6acd545"; x:-436.687592; y:186.189636; z:-29.104208
	["Razorfen Kraul"] = 
		"\093\229\136\052\055\072\000\139\014\101\243\247\149\255\060\210\082\090\223\067\128\141\028\194\076\214\164\194" ..
		-- tex:"5de588343748008b0e65f3f795ff3cd2"; x:446.705658; y:-39.138187; z:-82.418556
		"\219\074\067\106\188\138\090\107\232\109\082\054\105\169\132\082\041\173\047\068\128\141\028\194\076\214\164\194" ..
		-- tex:"db4a436abc8a5a6be86d523669a98452"; x:702.705658; y:-39.138187; z:-82.418556
		"\232\218\090\154\068\104\026\141\070\161\076\110\118\186\153\192\041\173\047\068\159\220\088\067\076\214\164\194" ..
		-- tex:"e8da5a9a44681a8d46a14c6e76ba99c0"; x:702.705658; y:216.861813; z:-82.418556
		"\067\006\085\030\044\022\015\101\226\174\017\188\233\237\074\162\082\090\223\067\159\220\088\067\076\214\164\194" ..
		-- tex:"4306551e2c160f65e2ae11bce9ed4aa2"; x:446.705658; y:216.861813; z:-82.418556
		"\219\007\130\246\109\075\058\035\013\086\128\145\230\152\061\133\141\210\178\067\127\107\229\066\190\160\154\194" ..
		-- tex:"db0782f66d4b3a230d568091e6983d85"; x:357.644958; y:114.709961; z:-77.313957
		"\217\065\007\122\230\119\134\250\161\116\038\073\108\001\013\107\141\210\178\067\063\074\013\195\190\160\154\194" ..
		-- tex:"d941077ae67786faa17426496c010d6b"; x:357.644958; y:-141.290039; z:-77.313957
		"\217\127\066\017\051\026\201\164\066\130\112\247\181\064\162\187\059\235\219\067\143\034\248\066\104\100\144\194" ..
		-- tex:"d97f4211331ac9a4428270f7b540a2bb"; x:439.837769; y:124.067505; z:-72.196114
		"\060\175\104\071\197\153\101\100\246\174\079\089\132\173\247\251\145\066\153\067\133\217\082\195\022\107\142\194" ..
		-- tex:"3caf6847c5996564f6ae4f5984adf7fb"; x:306.520081; y:-210.849701; z:-71.209160
		"\194\021\097\090\161\175\006\093\040\237\097\065\016\143\137\166\133\048\022\068\044\081\158\194\206\184\139\194" ..
		-- tex:"c215615aa1af065d28ed6141108f89a6"; x:600.758179; y:-79.158546; z:-69.860954
		"\034\044\110\123\080\109\053\136\017\033\175\181\112\245\048\102\182\136\050\068\052\066\224\066\197\131\127\194" ..
		-- tex:"222c6e7b506d35881121afb570f53066"; x:714.136169; y:112.129311; z:-63.878685
		"\223\236\214\090\073\178\153\211\119\242\034\255\061\202\170\178\061\071\118\067\218\238\121\194\167\012\125\194" ..
		-- tex:"dfecd65a49b299d377f222ff3dcaaab2"; x:246.278290; y:-62.483257; z:-63.262360
		"\084\192\005\160\184\025\239\021\086\142\110\162\083\028\014\027\219\157\167\067\016\126\095\195\007\200\121\194" ..
		-- tex:"54c005a0b819ef15568e6ea2531c0e1b"; x:335.233261; y:-223.492447; z:-62.445343
		"\005\191\238\068\058\249\160\051\253\239\146\200\255\001\003\003\109\119\158\066\016\126\095\195\007\200\121\194" ..
		-- tex:"05bfee443af9a033fdef92c8ff010303"; x:79.233261; y:-223.492447; z:-62.445343
		"\176\097\115\252\219\153\235\045\223\069\065\047\207\110\226\095\118\051\022\068\055\116\074\067\083\048\116\194" ..
		-- tex:"b06173fcdb99eb2ddf45412fcf6ee25f"; x:600.804138; y:202.453979; z:-61.047195
		"\071\194\242\006\068\199\198\083\182\161\054\226\033\120\189\182\227\099\049\068\177\141\092\067\208\252\111\194" ..
		-- tex:"47c2f20644c7c653b6a136e22178bdb6"; x:709.560791; y:220.553497; z:-59.996891
		"\109\161\232\144\136\204\079\155\170\170\205\054\171\132\202\011\077\058\023\068\255\114\216\067\146\081\097\194" ..
		-- tex:"6da1e89088cc4f9baaaacd36ab84ca0b"; x:604.911011; y:432.898438; z:-56.329662
		"\228\139\179\071\138\080\118\177\152\074\150\044\019\223\196\099\134\251\013\068\149\103\248\194\155\092\089\194" ..
		-- tex:"e48bb3478a5076b1984a962c13dfc463"; x:567.930115; y:-124.202316; z:-54.340439
		"\100\069\102\194\156\069\075\006\042\192\247\090\049\096\220\023\252\153\181\194\015\010\159\195\088\089\072\194" ..
		-- tex:"644566c29c454b062ac0f75a3160dc17"; x:-90.800758; y:-318.078613; z:-50.087254
		"\149\115\242\039\235\002\123\199\129\044\076\058\133\093\043\090\252\153\181\194\007\133\015\196\088\089\072\194" ..
		-- tex:"9573f227eb027bc7812c4c3a855d2b5a"; x:-90.800758; y:-574.078613; z:-50.087254
		"\248\045\221\089\046\050\213\023\049\128\060\117\224\109\130\198\063\172\141\194\186\137\111\195\017\190\063\194" ..
		-- tex:"f82ddd592e32d51731803c75e06d82c6"; x:-70.836426; y:-239.538010; z:-47.935616
		"\200\101\242\097\214\204\042\214\094\204\086\217\200\147\050\068\072\080\010\066\085\186\014\196\076\000\045\194" ..
		-- tex:"c865f261d6cc2ad65ecc56d9c8933244"; x:34.578403; y:-570.911499; z:-43.250294
		"\060\055\162\223\041\113\001\005\097\113\201\183\217\066\117\026\050\003\003\067\071\167\003\196\231\035\041\194" ..
		-- tex:"3c37a2df297101056171c9b7d942751a"; x:131.012497; y:-526.613770; z:-42.285065
		"\019\163\084\170\250\216\173\216\047\024\031\248\117\177\086\024\023\110\035\068\196\120\020\067\020\018\012\194" ..
		-- tex:"13a354aafad8add82f181ff875b15618"; x:653.720215; y:148.471756; z:-35.017658
		"\031\100\050\247\186\030\074\012\199\208\006\195\017\047\082\084\013\206\152\067\103\106\202\195\185\164\205\193" ..
		-- tex:"1f6432f7ba1e4a0cc7d006c3112f5254"; x:305.609802; y:-404.831299; z:-25.705433
		"\078\237\018\008\061\252\234\051\009\103\159\055\131\176\215\134\173\247\114\067\182\001\137\195\031\115\188\193" ..
		-- tex:"4eed12083dfcea3309679f3783b0d786"; x:242.967499; y:-274.013397; z:-23.556213
		"\239\209\252\117\011\050\120\148\054\206\032\059\044\234\198\030\024\089\182\066\079\011\164\195\222\121\177\193" ..
		-- tex:"efd1fc750b32789436ce203b2ceac61e"; x:91.174019; y:-328.088379; z:-22.184507
		"\155\006\212\002\003\156\051\244\066\166\058\131\245\142\170\113\025\239\047\067\185\111\158\195\153\031\148\193" ..
		-- tex:"9b06d402039c33f442a63a83f58eaa71"; x:175.933990; y:-316.872864; z:-18.515430
		"\049\044\198\145\023\251\211\000\003\169\191\172\053\061\217\184\023\217\079\194\095\235\249\194\246\007\144\193" ..
		-- tex:"312cc69117fbd30003a9bfac353dd9b8"; x:-51.962006; y:-124.959717; z:-18.003889
		"\091\036\146\041\129\026\188\218\104\102\035\199\068\129\098\100\172\088\009\067\063\198\081\194\047\006\141\193" ..
		-- tex:"5b249229811abcda686623c744816264"; x:137.346390; y:-52.443604; z:-17.628021
		"\236\028\017\203\162\246\167\124\141\089\071\143\067\232\184\056\085\173\179\194\204\224\122\194\104\160\071\193",
		-- tex:"ec1c11cba2f6a77c8d59478f43e8b838"; x:-89.838547; y:-62.719532; z:-12.476663
	["Ruins of Ahn'Qiraj"] = 
		"\052\089\231\066\186\082\009\200\228\242\174\183\044\128\069\205\255\255\215\069\255\255\059\198\000\000\000\000" ..
		-- tex:"3459e742ba5209c8e4f2aeb72c8045cd"; x:6912.000000; y:-12032.000000
		"\253\229\219\107\114\076\128\096\198\104\142\201\199\255\214\141\255\255\215\069\255\255\063\198\000\000\000\000" ..
		-- tex:"fde5db6b724c8060c6688ec9c7ffd68d"; x:6912.000000; y:-12288.000000
		"\111\179\176\123\106\205\007\035\012\125\204\092\208\060\056\125\255\255\215\069\255\255\067\198\000\000\000\000" ..
		-- tex:"6fb3b07b6acd07230c7dcc5cd03c387d"; x:6912.000000; y:-12544.000000
		"\071\198\049\191\113\032\094\018\252\187\238\168\132\104\050\206\255\255\215\069\255\255\071\198\000\000\000\000" ..
		-- tex:"47c631bf71205e12fcbbeea8846832ce"; x:6912.000000; y:-12800.000000
		"\241\129\058\044\158\088\118\246\142\037\075\109\251\100\076\039\255\255\223\069\255\255\059\198\000\000\000\000" ..
		-- tex:"f1813a2c9e5876f68e254b6dfb644c27"; x:7168.000000; y:-12032.000000
		"\161\069\131\065\118\221\120\112\039\034\207\114\198\043\102\083\255\255\223\069\255\255\063\198\000\000\000\000" ..
		-- tex:"a145834176dd78702722cf72c62b6653"; x:7168.000000; y:-12288.000000
		"\007\172\223\022\168\192\033\214\241\225\094\246\157\057\213\113\255\255\223\069\255\255\067\198\000\000\000\000" ..
		-- tex:"07acdf16a8c021d6f1e15ef69d39d571"; x:7168.000000; y:-12544.000000
		"\250\085\114\065\135\184\185\001\213\253\166\118\240\030\105\218\255\255\223\069\255\255\071\198\000\000\000\000" ..
		-- tex:"fa55724187b8b901d5fda676f01e69da"; x:7168.000000; y:-12800.000000
		"\077\232\042\158\043\233\072\176\247\212\190\196\010\045\228\216\255\255\231\069\255\255\059\198\000\000\000\000" ..
		-- tex:"4de82a9e2be948b0f7d4bec40a2de4d8"; x:7424.000000; y:-12032.000000
		"\248\164\210\252\004\214\203\126\141\251\220\124\116\028\209\162\255\255\231\069\255\255\063\198\000\000\000\000" ..
		-- tex:"f8a4d2fc04d6cb7e8dfbdc7c741cd1a2"; x:7424.000000; y:-12288.000000
		"\189\223\003\107\140\205\140\145\242\196\039\178\108\114\219\203\255\255\231\069\255\255\067\198\000\000\000\000" ..
		-- tex:"bddf036b8ccd8c91f2c427b26c72dbcb"; x:7424.000000; y:-12544.000000
		"\247\115\244\102\162\123\199\106\034\104\062\167\215\032\199\220\255\255\231\069\255\255\071\198\000\000\000\000",
		-- tex:"f773f466a27bc76a22683ea7d720c7dc"; x:7424.000000; y:-12800.000000
	["Scholomance"] = 
		"\108\077\234\030\236\095\191\249\169\193\167\247\116\239\066\037\026\113\210\194\068\143\125\067\054\165\026\195" ..
		-- tex:"6c4dea1eec5fbff9a9c1a7f774ef4225"; x:-105.220909; y:253.559647; z:-154.645370
		"\085\024\241\128\116\017\100\102\134\231\255\064\239\099\085\063\068\210\129\195\048\229\054\067\177\038\023\195" ..
		-- tex:"5518f1807411646686e7ff40ef63553f"; x:-259.642731; y:182.895279; z:-151.151154
		"\119\175\255\125\161\169\034\246\053\222\189\196\103\108\095\125\084\250\009\194\122\086\034\067\056\177\022\195" ..
		-- tex:"77afff7da1a922f635debdc4676c5f7d"; x:-34.494465; y:162.337814; z:-150.692276
		"\007\095\180\109\022\004\027\076\106\092\223\099\108\243\020\014\117\049\008\195\181\040\023\067\252\059\017\195" ..
		-- tex:"075fb46d16041b4c6a5cdf636cf3140e"; x:-136.193207; y:151.159027; z:-145.234329
		"\118\137\185\052\080\007\053\025\094\081\207\138\050\102\194\103\158\085\206\066\133\173\188\194\033\079\001\195" ..
		-- tex:"7689b934500735195e51cf8a3266c267"; x:103.167229; y:-94.338913; z:-129.309113
		"\196\068\059\054\039\213\204\157\058\166\246\105\035\033\116\014\099\247\037\067\129\095\254\194\058\060\001\195" ..
		-- tex:"c4443b3627d5cc9d3aa6f6692321740e"; x:165.966370; y:-127.186539; z:-129.235275
		"\208\197\211\030\089\147\189\006\203\131\093\200\220\127\137\248\022\208\137\195\011\109\043\067\026\195\253\194" ..
		-- tex:"d0c5d31e5993bd06cb835dc8dc7f89f8"; x:-275.625702; y:171.425964; z:-126.881065
		"\207\234\049\212\043\207\195\236\239\213\218\073\072\228\101\212\017\070\233\194\077\115\134\067\021\195\253\194" ..
		-- tex:"cfea31d42bcfc3ecefd5da4948e465d4"; x:-116.636856; y:268.900818; z:-126.881027
		"\041\135\226\200\071\233\205\227\126\080\237\158\059\019\125\246\067\156\147\193\171\001\057\067\006\163\253\194" ..
		-- tex:"2987e2c847e9cde37e50ed9e3b137df6"; x:-18.451302; y:185.006531; z:-126.818413
		"\244\191\137\198\254\175\252\241\172\184\189\252\014\130\053\025\169\027\179\194\016\208\189\066\209\153\237\194" ..
		-- tex:"f4bf89c6feaffcf1acb8bdfc0e823519"; x:-89.554031; y:94.906380; z:-118.800430
		"\254\192\054\031\204\112\200\033\131\204\184\058\012\018\051\125\069\222\071\194\044\004\070\195\252\168\224\194" ..
		-- tex:"fec0361fcc70c82183ccb83a0c12337d"; x:-49.967064; y:-198.016312; z:-112.330055
		"\166\006\245\022\184\206\255\027\005\242\173\066\115\206\180\221\199\153\091\195\049\181\066\195\078\066\209\194" ..
		-- tex:"a606f516b8ceff1b05f2ad4273ceb4dd"; x:-219.600708; y:-194.707794; z:-104.629509
		"\241\203\065\106\034\156\244\209\230\144\172\120\086\014\249\177\051\173\145\195\117\226\021\195\032\024\209\194" ..
		-- tex:"f1cb416a229cf4d1e690ac78560ef9b1"; x:-291.353149; y:-149.884613; z:-104.547127
		"\192\100\103\191\181\188\102\024\219\246\098\117\181\219\205\058\167\045\123\194\228\011\018\194\094\187\203\194" ..
		-- tex:"c06467bfb5bc6618dbf66275b5dbcd3a"; x:-62.794586; y:-36.511616; z:-101.865959
		"\207\249\047\019\237\199\192\045\247\123\005\001\229\034\024\231\148\155\179\195\142\070\042\065\221\076\186\194" ..
		-- tex:"cff92f13edc7c02df77b0501e52218e7"; x:-359.215485; y:10.642226; z:-93.150131
		"\025\005\166\168\160\069\238\084\045\199\221\126\217\114\027\006\207\191\053\195\221\093\018\195\220\104\175\194" ..
		-- tex:"1905a6a8a045ee542dc7dd7ed9721b06"; x:-181.749268; y:-146.366669; z:-87.704811
		"\005\191\158\151\081\195\227\080\241\033\078\103\025\035\057\189\043\119\147\195\192\063\119\194\061\140\154\194" ..
		-- tex:"05bf9e9751c3e350f1214e67192339bd"; x:-294.931030; y:-61.812260; z:-77.273911
		"\104\043\157\192\192\164\139\251\016\007\220\033\111\253\002\029\157\180\140\195\088\122\252\194\011\211\153\194" ..
		-- tex:"682b9dc0c0a48bfb1007dc216ffd021d"; x:-281.411072; y:-126.238960; z:-76.912201
		"\156\075\082\144\244\228\018\141\233\185\027\235\104\220\013\210\055\226\082\195\221\021\171\066\097\134\132\194" ..
		-- tex:"9c4b5290f4e4128de9b91beb68dc0dd2"; x:-210.883667; y:85.542709; z:-66.262466
		"\044\059\131\124\185\001\185\140\105\077\219\085\018\088\128\207\159\214\251\194\192\115\069\194\229\175\032\194" ..
		-- tex:"2c3b837cb901b98c694ddb55125880cf"; x:-125.919189; y:-49.363041; z:-40.171776
		"\111\139\063\087\175\253\076\119\198\242\100\125\173\049\103\252\038\021\135\194\174\069\081\194\202\035\120\192",
		-- tex:"6f8b3f57affd4c77c6f2647dad3167fc"; x:-67.541313; y:-52.318050; z:-3.877185
	["Serpentshrine Cavern"] = 
		"\010\191\121\129\242\192\205\087\008\066\042\218\033\246\026\166\089\136\020\196\080\236\003\068\230\220\141\195" ..
		-- tex:"0abf7981f2c0cd5708422ada21f61aa6"; x:-594.130493; y:527.692387; z:-283.725800
		"\114\237\139\172\030\208\197\218\215\075\002\152\038\064\242\059\207\066\164\194\003\020\123\065\230\220\141\195" ..
		-- tex:"72ed8bac1ed0c5dad74b02982640f23b"; x:-82.130493; y:15.692387; z:-283.725800
		"\203\014\166\177\141\080\228\139\079\225\160\234\180\210\108\126\179\016\169\195\040\246\193\068\230\220\141\195" ..
		-- tex:"cb0ea6b18d50e48b4fe1a0eab4d26c7e"; x:-338.130493; y:1551.692387; z:-283.725800
		"\099\208\151\191\144\087\206\162\070\099\203\219\250\029\179\213\179\016\169\195\040\246\161\068\230\220\141\195" ..
		-- tex:"63d097bf9057cea24663cbdbfa1db3d5"; x:-338.130493; y:1295.692387; z:-283.725800
		"\146\062\019\000\162\083\089\237\227\214\029\226\108\143\230\050\207\066\164\194\160\216\135\067\230\220\141\195" ..
		-- tex:"923e1300a25359ede3d61de26c8fe632"; x:-82.130493; y:271.692387; z:-283.725800
		"\099\141\209\160\042\218\240\117\075\136\129\018\147\063\095\178\207\066\164\194\080\236\067\068\230\220\141\195" ..
		-- tex:"638dd1a02adaf0754b888112933f5fb2"; x:-82.130493; y:783.692387; z:-283.725800
		"\213\137\013\100\005\210\067\000\243\114\189\034\124\073\064\116\207\066\164\194\080\236\003\068\230\220\141\195" ..
		-- tex:"d5890d6405d24300f372bd227c494074"; x:-82.130493; y:527.692387; z:-283.725800
		"\112\249\223\213\114\050\117\035\131\246\184\201\105\037\222\005\207\066\164\194\040\246\129\068\230\220\141\195" ..
		-- tex:"70f9dfd57232752383f6b8c96925de05"; x:-82.130493; y:1039.692387; z:-283.725800
		"\207\033\035\141\057\160\208\195\155\192\003\182\208\057\110\160\179\016\169\195\040\246\129\068\230\220\141\195" ..
		-- tex:"cf21238d39a0d0c39bc003b6d0396ea0"; x:-338.130493; y:1039.692387; z:-283.725800
		"\003\071\074\254\004\106\190\067\022\147\025\120\009\203\114\236\179\016\169\195\080\236\003\068\230\220\141\195" ..
		-- tex:"03474afe046abe431693197809cb72ec"; x:-338.130493; y:527.692387; z:-283.725800
		"\033\075\235\170\011\086\020\166\108\233\009\251\031\203\021\087\089\136\020\196\040\246\129\068\230\220\141\195" ..
		-- tex:"214bebaa0b5614a66ce909fb1fcb1557"; x:-594.130493; y:1039.692387; z:-283.725800
		"\241\183\254\038\063\003\163\122\131\065\092\065\142\231\252\248\089\136\020\196\080\236\067\068\230\220\141\195" ..
		-- tex:"f1b7fe263f03a37a83415c418ee7fcf8"; x:-594.130493; y:783.692387; z:-283.725800
		"\236\023\147\198\158\120\072\214\028\171\079\038\035\208\004\126\179\016\169\195\080\236\067\068\230\220\141\195" ..
		-- tex:"ec1793c69e7848d61cab4f2623d0047e"; x:-338.130493; y:783.692387; z:-283.725800
		"\015\094\039\088\112\094\052\146\028\203\173\031\134\016\234\153\089\136\020\196\040\246\161\068\230\220\141\195" ..
		-- tex:"0f5e2758705e34921ccbad1f8610ea99"; x:-594.130493; y:1295.692387; z:-283.725800
		"\225\134\215\061\112\090\213\133\052\171\090\068\181\246\109\085\179\016\169\195\160\216\135\067\230\220\141\195" ..
		-- tex:"e186d73d705ad58534ab5a44b5f66d55"; x:-338.130493; y:271.692387; z:-283.725800
		"\146\079\046\235\147\215\238\119\055\236\204\038\090\109\229\133\179\016\169\195\003\020\123\065\230\220\141\195" ..
		-- tex:"924f2eeb93d7ee7737eccc265a6de585"; x:-338.130493; y:15.692387; z:-283.725800
		"\176\127\183\239\056\071\197\079\228\175\110\251\063\046\107\088\089\136\020\196\160\216\135\067\230\220\141\195" ..
		-- tex:"b07fb7ef3847c54fe4af6efb3f2e6b58"; x:-594.130493; y:271.692387; z:-283.725800
		"\167\102\215\225\057\236\187\244\005\122\124\148\188\157\063\033\207\066\164\194\040\246\161\068\230\220\141\195" ..
		-- tex:"a766d7e139ecbbf4057a7c94bc9d3f21"; x:-82.130493; y:1295.692387; z:-283.725800
		"\004\216\201\000\104\007\172\210\059\145\067\235\127\003\109\207\151\222\045\067\003\020\123\065\230\220\141\195" ..
		-- tex:"04d8c9006807acd23b9143eb7f036dcf"; x:173.869507; y:15.692387; z:-283.725800
		"\213\167\232\020\099\010\179\013\216\122\154\211\046\011\252\144\075\239\214\067\040\246\129\068\230\220\141\195" ..
		-- tex:"d5a7e814630ab30dd87a9ad32e0bfc90"; x:429.869507; y:1039.692387; z:-283.725800
		"\079\055\102\167\024\210\217\213\185\065\142\080\029\235\228\245\075\239\214\067\080\236\067\068\230\220\141\195" ..
		-- tex:"4f3766a718d2d9d5b9418e501debe4f5"; x:429.869507; y:783.692387; z:-283.725800
		"\003\014\201\002\037\045\188\252\132\030\235\248\158\083\231\079\075\239\214\067\080\236\003\068\230\220\141\195" ..
		-- tex:"030ec902252dbcfc841eebf89e53e74f"; x:429.869507; y:527.692387; z:-283.725800
		"\203\003\244\243\215\169\143\121\216\036\067\091\107\085\021\108\075\239\214\067\040\246\161\068\230\220\141\195" ..
		-- tex:"cb03f4f3d7a98f79d824435b6b55156c"; x:429.869507; y:1295.692387; z:-283.725800
		"\023\020\149\147\108\214\082\240\113\199\147\228\170\198\035\069\165\119\043\068\080\236\067\068\230\220\141\195" ..
		-- tex:"171495936cd652f071c793e4aac62345"; x:685.869507; y:783.692387; z:-283.725800
		"\250\076\085\170\145\023\157\101\120\184\005\164\190\167\216\013\165\119\043\068\080\236\003\068\230\220\141\195" ..
		-- tex:"fa4c55aa91179d6578b805a4bea7d80d"; x:685.869507; y:527.692387; z:-283.725800
		"\130\093\170\115\218\192\088\017\116\053\178\019\176\189\173\198\207\066\164\194\040\246\193\068\230\220\141\195" ..
		-- tex:"825daa73dac058117435b213b0bdadc6"; x:-82.130493; y:1551.692387; z:-283.725800
		"\125\160\243\096\078\162\200\166\112\200\077\051\211\113\019\135\075\239\214\067\160\216\135\067\230\220\141\195" ..
		-- tex:"7da0f3604ea2c8a670c84d33d3711387"; x:429.869507; y:271.692387; z:-283.725800
		"\137\226\034\077\255\149\094\172\064\002\126\054\184\078\117\036\151\222\045\067\040\246\193\068\230\220\141\195" ..
		-- tex:"89e2224dff955eac40027e36b84e7524"; x:173.869507; y:1551.692387; z:-283.725800
		"\063\188\239\012\102\161\171\234\032\217\059\019\214\137\027\187\151\222\045\067\080\236\003\068\230\220\141\195" ..
		-- tex:"3fbcef0c66a1abea20d93b13d6891bbb"; x:173.869507; y:527.692387; z:-283.725800
		"\073\229\177\123\250\120\232\079\198\027\246\132\014\211\012\254\151\222\045\067\160\216\135\067\230\220\141\195" ..
		-- tex:"49e5b17bfa78e84fc61bf6840ed30cfe"; x:173.869507; y:271.692387; z:-283.725800
		"\108\240\054\100\013\207\084\124\174\144\217\008\142\039\154\078\075\239\214\067\003\020\123\065\230\220\141\195" ..
		-- tex:"6cf036640dcf547cae90d9088e279a4e"; x:429.869507; y:15.692387; z:-283.725800
		"\188\009\106\000\178\136\245\195\095\026\169\001\137\137\114\199\151\222\045\067\080\236\067\068\230\220\141\195" ..
		-- tex:"bc096a00b288f5c35f1aa901898972c7"; x:173.869507; y:783.692387; z:-283.725800
		"\011\116\050\012\145\190\058\200\029\062\055\221\064\021\115\214\151\222\045\067\040\246\161\068\230\220\141\195" ..
		-- tex:"0b74320c91be3ac81d3e37dd401573d6"; x:173.869507; y:1295.692387; z:-283.725800
		"\237\068\001\155\209\165\233\174\188\147\089\227\018\151\001\145\151\222\045\067\040\246\129\068\230\220\141\195" ..
		-- tex:"ed44019bd1a5e9aebc9359e312970191"; x:173.869507; y:1039.692387; z:-283.725800
		"\033\136\220\123\066\155\074\238\111\231\190\153\096\097\215\249\165\119\043\068\040\246\129\068\230\220\141\195" ..
		-- tex:"2188dc7b429b4aee6fe7be996061d7f9"; x:685.869507; y:1039.692387; z:-283.725800
		"\226\105\063\161\201\179\115\197\138\120\243\182\177\161\144\026\067\025\036\195\141\048\056\194\035\079\014\195" ..
		-- tex:"e2693fa1c9b373c58a78f3b6b1a1901a"; x:-164.098694; y:-46.047417; z:-142.309143
		"\050\204\074\125\023\126\146\113\064\228\143\000\076\113\087\219\209\062\010\195\249\213\002\069\056\101\251\194" ..
		-- tex:"32cc4a7d177e927140e48f004c7157db"; x:-138.245392; y:2093.373413; z:-125.697701
		"\005\165\248\196\018\014\205\167\014\068\232\038\071\187\048\094\209\062\010\195\242\171\229\068\056\101\251\194" ..
		-- tex:"05a5f8c4120ecda70e44e82647bb305e"; x:-138.245392; y:1837.373413; z:-125.697701
		"\061\239\205\242\044\169\126\098\151\119\172\068\158\010\145\064\091\130\235\066\242\171\197\068\056\101\251\194" ..
		-- tex:"3defcdf22ca97e629777ac449e0a9140"; x:117.754608; y:1581.373413; z:-125.697701
		"\039\017\171\153\088\032\159\079\115\062\167\190\254\230\214\224\091\130\235\066\242\171\229\068\056\101\251\194" ..
		-- tex:"2711ab9958209f4f733ea7befee6d6e0"; x:117.754608; y:1837.373413; z:-125.697701
		"\234\112\169\213\052\203\113\150\170\110\033\165\078\181\218\128\209\062\010\195\242\171\197\068\056\101\251\194" ..
		-- tex:"ea70a9d534cb7196aa6e21a54eb5da80"; x:-138.245392; y:1581.373413; z:-125.697701
		"\120\058\182\061\158\167\190\162\240\124\206\007\055\102\095\066\104\031\197\195\242\171\229\068\056\101\251\194" ..
		-- tex:"783ab63d9ea7bea2f07cce0737665f42"; x:-394.245392; y:1837.373413; z:-125.697701
		"\126\186\109\024\097\006\112\220\062\029\202\156\189\198\150\194\104\031\197\195\249\213\002\069\056\101\251\194" ..
		-- tex:"7eba6d18610670dc3e1dca9cbdc696c2"; x:-394.245392; y:2093.373413; z:-125.697701
		"\203\019\100\242\057\100\145\120\019\060\136\147\122\229\241\201\104\031\197\195\242\171\197\068\056\101\251\194" ..
		-- tex:"cb1364f239649178133c88937ae5f1c9"; x:-394.245392; y:1581.373413; z:-125.697701
		"\205\077\071\216\224\061\009\021\099\034\156\070\235\203\096\146\091\130\235\066\249\213\002\069\056\101\251\194" ..
		-- tex:"cd4d47d8e03d091563229c46ebcb6092"; x:117.754608; y:2093.373413; z:-125.697701
		"\011\043\171\040\052\169\052\218\066\201\252\149\030\057\170\173\216\151\039\196\061\028\165\068\026\176\224\193" ..
		-- tex:"0b2bab2834a934da42c9fc951e39aaad"; x:-670.372620; y:1320.882568; z:-28.085989
		"\006\182\237\016\110\149\073\050\046\132\211\122\028\228\078\199\216\151\103\196\061\028\165\068\026\176\224\193" ..
		-- tex:"06b6ed106e9549322e84d37a1ce44ec7"; x:-926.372620; y:1320.882568; z:-28.085989
		"\044\182\074\223\067\234\176\158\100\005\204\121\073\112\141\008\218\073\128\196\198\242\065\068\074\091\223\193" ..
		-- tex:"2cb64adf43eab09e6405cc7949708d08"; x:-1026.307983; y:775.793396; z:-27.919577
		"\169\026\022\129\224\110\054\142\039\007\027\217\192\142\137\192\066\038\024\196\133\174\160\068\051\088\211\193" ..
		-- tex:"a91a1681e06e368e27071bd9c08e89c0"; x:-608.597839; y:1285.453857; z:-26.418068
		"\040\234\149\208\026\089\220\093\197\152\064\010\114\194\012\191\039\092\094\196\099\007\135\068\004\250\210\193" ..
		-- tex:"28ea95d01a59dc5dc598400a72c20cbf"; x:-889.439941; y:1080.230896; z:-26.372080
		"\099\122\090\074\177\029\022\234\238\252\169\102\150\184\145\053\039\092\094\196\198\014\078\068\004\250\210\193" ..
		-- tex:"637a5a4ab11d16eaeefca96696b89135"; x:-889.439941; y:824.230896; z:-26.372080
		"\052\102\026\031\051\185\073\084\074\192\211\136\186\042\108\073\019\046\143\196\099\007\135\068\004\250\210\193" ..
		-- tex:"34661a1f33b949544ac0d388ba2a6c49"; x:-1145.439941; y:1080.230896; z:-26.372080
		"\171\009\137\062\016\098\234\230\207\190\244\177\048\084\202\236\019\046\143\196\198\014\078\068\004\250\210\193" ..
		-- tex:"ab09893e1062eae6cfbef4b13054caec"; x:-1145.439941; y:824.230896; z:-26.372080
		"\162\069\139\028\115\165\147\012\110\152\083\085\040\024\106\057\242\120\143\196\178\145\150\068\168\129\101\193" ..
		-- tex:"a2458b1c73a5930c6e98535528186a39"; x:-1147.779663; y:1204.553101; z:-14.344155
		"\106\231\098\147\038\007\131\185\150\094\016\040\157\034\124\067\242\120\143\196\178\145\182\068\168\129\101\193" ..
		-- tex:"6ae76293260783b9965e10289d227c43"; x:-1147.779663; y:1460.553101; z:-14.344155
		"\109\066\046\047\126\093\139\036\105\177\022\093\100\171\206\211\212\022\057\196\087\137\235\067\165\113\204\189" ..
		-- tex:"6d422e2f7e5d8b2469b1165d64abced3"; x:-740.356750; y:471.072998; z:-0.099826
		"\104\224\100\007\223\075\039\059\039\057\183\083\058\121\244\115\206\138\096\196\040\069\082\068\159\019\133\065" ..
		-- tex:"68e06407df4b273b2739b7533a79f473"; x:-898.168884; y:841.080627; z:16.634583
		"\009\088\015\250\151\205\011\140\227\037\214\035\015\150\151\121\187\070\017\196\170\116\136\068\155\133\012\066" ..
		-- tex:"09580ffa97cd0b8ce325d6230f969779"; x:-581.105225; y:1091.645874; z:35.130478
		"\146\121\143\198\205\154\197\087\118\001\254\034\184\200\020\030\187\070\017\196\085\233\080\068\155\133\012\066" ..
		-- tex:"92798fc6cd9ac5577601fe22b8c8141e"; x:-581.105225; y:835.645874; z:35.130478
		"\200\151\000\040\108\187\212\073\047\167\200\105\098\113\237\108\187\070\081\196\085\233\016\068\155\133\012\066" ..
		-- tex:"c89700286cbbd4492fa7c8696271ed6c"; x:-837.105225; y:579.645874; z:35.130478
		"\010\171\200\127\240\067\205\011\141\204\133\092\207\173\136\088\187\070\081\196\170\116\136\068\155\133\012\066" ..
		-- tex:"0aabc87ff043cd0b8dcc855ccfad8858"; x:-837.105225; y:1091.645874; z:35.130478
		"\092\186\038\167\138\185\201\037\194\003\154\002\035\072\162\119\187\070\081\196\085\233\080\068\155\133\012\066" ..
		-- tex:"5cba26a78ab9c925c2039a022348a277"; x:-837.105225; y:835.645874; z:35.130478
		"\213\179\228\109\130\076\079\135\160\033\198\198\179\224\121\033\187\070\017\196\085\233\016\068\155\133\012\066" ..
		-- tex:"d5b3e46d824c4f87a021c6c6b3e07921"; x:-581.105225; y:579.645874; z:35.130478
		"\065\167\194\193\213\177\043\089\036\082\104\134\013\072\130\237\233\036\075\195\061\167\102\195\038\086\197\068" ..
		-- tex:"41a7c2c1d5b12b59245268860d4882ed"; x:-203.144196; y:-230.653290; z:1578.692261
		"\045\117\105\143\067\073\056\106\154\043\234\019\161\247\027\219\087\108\083\066\015\198\202\065\038\086\197\068" ..
		-- tex:"2d75698f4349386a9a2bea13a1f71bdb"; x:52.855804; y:25.346710; z:1578.692261
		"\204\045\127\250\139\067\130\203\087\177\086\089\176\150\165\057\138\109\154\067\015\198\202\065\038\086\197\068" ..
		-- tex:"cc2d7ffa8b4382cb57b15659b096a539"; x:308.855804; y:25.346710; z:1578.692261
		"\153\224\094\060\165\061\041\013\004\015\088\243\091\222\252\034\087\108\083\066\061\167\102\195\038\086\197\068" ..
		-- tex:"99e05e3ca53d290d040f58f35bdefc22"; x:52.855804; y:-230.653290; z:1578.692261
		"\189\078\059\195\240\253\207\044\045\173\063\122\210\144\184\186\138\109\154\067\061\167\102\195\038\086\197\068" ..
		-- tex:"bd4e3bc3f0fdcf2c2dad3f7ad290b8ba"; x:308.855804; y:-230.653290; z:1578.692261
		"\037\211\162\042\007\244\236\214\212\074\125\222\248\045\035\110\233\036\075\195\015\198\202\065\038\086\197\068",
		-- tex:"25d3a22a07f4ecd6d44a7ddef82d236e"; x:-203.144196; y:25.346710; z:1578.692261
	["Sethekk Halls"] = 
		"\255\235\068\080\214\253\154\082\061\194\199\028\251\003\242\223\167\157\142\194\114\246\195\195\235\213\212\192" ..
		-- tex:"ffeb4450d6fd9a523dc2c71cfb03f2df"; x:-71.307922; y:-391.925385; z:-6.651114
		"\251\103\062\023\002\090\097\146\002\033\027\052\002\153\181\234\105\167\163\195\114\246\195\195\235\213\212\192" ..
		-- tex:"fb673e17025a619202211b340299b5ea"; x:-327.307922; y:-391.925385; z:-6.651114
		"\002\157\157\124\251\035\224\219\163\155\203\110\004\161\048\090\167\157\142\194\229\236\007\195\235\213\212\192" ..
		-- tex:"029d9d7cfb23e0dba39bcb6e04a1305a"; x:-71.307922; y:-135.925385; z:-6.651114
		"\231\155\192\211\030\102\001\053\064\228\060\089\074\124\145\224\105\167\163\195\229\236\007\195\235\213\212\192" ..
		-- tex:"e79bc0d31e66013540e43c594a7c91e0"; x:-327.307922; y:-135.925385; z:-6.651114
		"\031\103\137\104\007\017\238\025\141\065\010\126\035\235\027\238\000\196\202\067\039\147\217\195\252\193\098\192" ..
		-- tex:"1f6789680711ee198d410a7e23eb1bee"; x:405.531281; y:-435.149658; z:-3.543090
		"\182\240\014\072\111\201\239\247\136\162\004\220\209\237\186\017\202\143\141\066\223\002\136\195\166\191\054\192" ..
		-- tex:"b6f00e486fc9eff788a204dcd1edba11"; x:70.780846; y:-272.022461; z:-2.855448
		"\131\181\158\063\123\009\013\144\176\116\047\037\000\229\139\069\029\140\135\065\147\253\183\193\051\052\234\191" ..
		-- tex:"83b59e3f7b090d90b0742f2500e58b45"; x:16.943417; y:-22.998817; z:-1.829718
		"\021\240\239\065\205\245\055\134\237\014\165\037\171\133\077\078\008\092\089\067\246\051\229\195\117\110\231\191" ..
		-- tex:"15f0ef41cdf53786ed0ea525ab854d4e"; x:217.359512; y:-458.405975; z:-1.808059
		"\130\199\099\222\223\153\244\048\036\205\145\063\104\231\127\163\075\221\219\194\117\063\248\194\064\223\066\189" ..
		-- tex:"82c763dedf99f43024cd913f68e77fa3"; x:-109.932220; y:-124.123947; z:-0.047576
		"\006\023\149\153\129\250\135\236\043\069\097\127\068\043\069\031\002\070\237\066\212\246\184\195\211\230\048\189" ..
		-- tex:"0617959981fa87ec2b45617f442b451f"; x:118.636742; y:-369.928375; z:-0.043189
		"\124\002\102\171\083\017\253\050\053\184\094\249\148\238\045\141\179\016\070\065\081\056\096\195\009\178\040\189" ..
		-- tex:"7c0266ab5311fd3235b85ef994ee2d8d"; x:12.379078; y:-224.220001; z:-0.041185
		"\202\094\212\030\155\228\123\168\103\224\067\108\019\233\098\069\218\053\225\194\051\092\164\195\217\152\038\189" ..
		-- tex:"ca5ed41e9be47ba867e0436c13e96245"; x:-112.605186; y:-328.720337; z:-0.040673
		"\167\086\145\049\162\175\006\220\104\136\026\193\229\098\231\101\078\095\179\067\210\247\184\195\239\116\011\189" ..
		-- tex:"a7569131a2af06dc68881ac1e562e765"; x:358.744598; y:-369.936127; z:-0.034047
		"\004\175\250\161\159\109\123\135\189\104\123\200\004\093\111\020\218\053\225\194\090\009\199\195\109\243\161\061" ..
		-- tex:"04affaa19f6d7b87bd687bc8045d6f14"; x:-112.605186; y:-398.073090; z:0.079078
		"\188\058\071\078\220\016\168\159\210\179\101\165\051\241\200\148\146\140\128\194\169\234\250\195\127\094\056\066" ..
		-- tex:"bc3a474edc10a89fd2b365a533f1c894"; x:-64.274559; y:-501.833313; z:46.092285
		"\165\205\016\248\217\186\009\020\060\232\051\166\003\078\040\112\182\185\063\067\084\117\061\196\127\094\056\066" ..
		-- tex:"a5cd10f8d9ba09143ce833a6034e2870"; x:191.725441; y:-757.833313; z:46.092285
		"\022\195\155\091\059\070\122\134\198\230\106\172\049\005\083\212\146\140\128\194\084\117\061\196\127\094\056\066" ..
		-- tex:"16c39b5b3b467a86c6e66aac310553d4"; x:-64.274559; y:-757.833313; z:46.092285
		"\017\038\009\221\208\094\244\223\130\168\043\086\046\218\079\078\182\185\063\067\169\234\250\195\127\094\056\066" ..
		-- tex:"112609ddd05ef4df82a82b562eda4f4e"; x:191.725441; y:-501.833313; z:46.092285
		"\097\138\190\070\027\235\108\230\236\244\012\037\094\254\039\087\138\207\156\067\179\155\054\196\134\174\058\066" ..
		-- tex:"618abe461beb6ce6ecf40c255efe2757"; x:313.621429; y:-730.432861; z:46.670437
		"\216\018\211\224\109\128\055\148\226\044\062\064\160\084\113\072\182\036\057\195\091\066\039\196\015\224\071\066" ..
		-- tex:"d812d3e06d803794e22c3e40a0547148"; x:-185.143417; y:-669.036865; z:49.968811
		"\040\226\029\170\100\233\071\036\126\093\079\090\071\075\197\083\074\054\225\194\077\039\231\195\210\128\085\066" ..
		-- tex:"28e21daa64e947247e5d4f5a474bc553"; x:-112.606041; y:-462.307068; z:53.375805
		"\194\251\029\119\042\222\171\194\090\108\034\091\040\237\116\153\170\210\230\067\097\178\002\196\187\143\085\066" ..
		-- tex:"c2fb1d772adeabc25a6c225b28ed7499"; x:461.645844; y:-522.787231; z:53.390366
		"\003\084\102\245\074\156\044\112\138\070\253\236\234\130\074\116\119\044\136\067\227\039\021\196\022\159\085\066" ..
		-- tex:"035466f54a9c2c708a46fdecea824a74"; x:272.347412; y:-596.623291; z:53.405361
		"\006\107\133\202\161\026\208\187\132\086\174\211\200\176\232\218\088\239\168\065\051\039\021\196\025\159\085\066",
		-- tex:"066b85caa11ad0bb8456aed3c8b0e8da"; x:21.116869; y:-596.612549; z:53.405373
	["Shadow Labyrinth"] = 
		"\000\187\150\074\205\229\071\121\184\202\224\029\216\078\105\057\043\168\157\064\142\119\035\067\232\234\135\193" ..
		-- tex:"00bb964acde54779b8cae01dd84e6939"; x:4.926779; y:163.467026; z:-16.989702
		"\057\200\180\199\048\062\153\112\084\159\070\156\238\011\135\163\043\168\157\064\225\016\185\194\232\234\135\193" ..
		-- tex:"39c8b4c7303e9970549f469cee0b87a3"; x:4.926779; y:-92.532974; z:-16.989702
		"\063\247\050\250\139\214\158\139\051\131\046\005\138\003\018\094\100\237\033\195\222\128\202\194\125\055\131\192" ..
		-- tex:"3ff732fa8bd69e8b33832e058a03125e"; x:-161.927322; y:-101.251701; z:-4.100524
		"\048\115\002\201\129\061\188\243\068\083\130\191\017\012\096\088\026\168\203\066\019\042\079\067\021\249\019\192" ..
		-- tex:"307302c9813dbcf3445382bf110c6058"; x:101.828331; y:207.164368; z:-2.312078
		"\219\106\030\052\214\253\135\204\099\038\243\156\067\019\205\012\044\216\226\066\037\093\020\195\079\221\186\062" ..
		-- tex:"db6a1e34d6fd87cc6326f39c4313cd0c"; x:113.422218; y:-148.363861; z:0.364970
		"\114\006\155\111\066\181\244\177\242\101\085\092\126\139\029\229\173\092\111\067\024\042\079\067\016\218\218\064" ..
		-- tex:"72069b6f42b5f4b1f265555c7e8b1de5"; x:239.362030; y:207.164444; z:6.839119
		"\202\175\048\125\244\095\215\046\043\071\116\213\032\125\064\056\101\110\070\067\090\161\121\067\019\218\218\064" ..
		-- tex:"caaf307df45fd72e2b4774d5207d4038"; x:198.431244; y:249.630295; z:6.839121
		"\121\041\191\096\202\155\233\091\162\116\082\085\177\039\036\235\068\116\111\067\049\093\020\195\211\222\218\064" ..
		-- tex:"7929bf60ca9be95ba2745255b12724eb"; x:239.454178; y:-148.364044; z:6.839701
		"\220\229\037\129\142\227\143\150\018\010\057\183\124\254\062\101\252\133\070\067\061\151\028\195\213\222\218\064" ..
		-- tex:"dce525818ee38f96120a39b77cfe3e65"; x:198.523392; y:-156.590790; z:6.839702
		"\223\212\183\115\255\217\110\008\024\081\099\028\210\201\199\226\216\172\103\067\026\135\071\067\230\199\224\064" ..
		-- tex:"dfd4b773ffd96e081851631cd2c9c7e2"; x:231.675186; y:199.527744; z:7.024402
		"\102\190\090\032\115\147\113\158\169\250\204\209\099\231\215\180\216\172\103\067\150\227\097\194\230\199\224\064" ..
		-- tex:"66be5a207393719ea9faccd163e7d7b4"; x:231.675186; y:-56.472256; z:7.024402
		"\138\120\216\248\213\016\015\031\183\178\073\105\150\169\055\162\105\205\041\068\095\136\229\066\232\199\224\064" ..
		-- tex:"8a78d8f8d5100f1fb7b2496996a937a2"; x:679.209595; y:114.766357; z:7.024403
		"\067\233\066\008\048\119\057\189\014\238\208\223\205\080\024\015\105\205\041\068\207\059\013\195\232\199\224\064" ..
		-- tex:"43e94208307739bd0eeed0dfcd50180f"; x:679.209595; y:-141.233643; z:7.024403
		"\244\209\166\088\113\114\112\035\165\084\200\205\187\175\255\214\211\154\211\067\207\059\013\195\232\199\224\064" ..
		-- tex:"f4d1a65871727023a554c8cdbbafffd6"; x:423.209595; y:-141.233643; z:7.024403
		"\017\160\211\207\061\217\128\046\210\061\174\132\006\090\038\171\211\154\211\067\095\136\229\066\232\199\224\064" ..
		-- tex:"11a0d3cf3dd9802ed23dae84065a26ab"; x:423.209595; y:114.766357; z:7.024403
		"\120\158\147\097\078\172\011\179\068\102\241\014\194\185\196\053\203\045\198\067\034\077\092\066\091\180\128\065" ..
		-- tex:"789e93614eac0bb34466f10ec2b9c435"; x:396.357788; y:55.075329; z:16.088066
		"\105\143\018\017\105\059\103\188\088\056\005\029\107\009\048\151\176\175\035\068\153\114\004\067\152\019\144\065" ..
		-- tex:"698f1211693b67bc5838051d6b093097"; x:654.745178; y:132.447662; z:18.009569
		"\135\192\099\005\108\039\027\183\232\129\245\126\157\097\064\200\176\175\099\068\076\057\194\067\152\019\144\065" ..
		-- tex:"87c063056c271bb7e881f57e9d6140c8"; x:910.745178; y:388.447662; z:18.009569
		"\176\251\064\196\174\100\050\174\120\131\060\240\053\059\035\005\176\175\099\068\153\114\004\067\152\019\144\065" ..
		-- tex:"b0fb40c4ae6432ae78833cf0353b2305"; x:910.745178; y:132.447662; z:18.009569
		"\089\012\002\075\092\232\133\132\177\248\086\223\074\050\089\212\176\175\035\068\076\057\194\067\152\019\144\065" ..
		-- tex:"590c024b5ce88584b1f856df4a3259d4"; x:654.745178; y:388.447662; z:18.009569
		"\099\241\167\225\220\210\075\188\107\120\098\071\234\207\143\095\189\164\044\068\155\096\217\067\081\053\181\065" ..
		-- tex:"63f1a7e1dcd24bbc6b786247eacf8f5f"; x:690.574097; y:434.754761; z:22.651035
		"\239\252\134\023\115\143\237\090\007\031\032\209\035\182\144\148\123\073\217\067\155\096\217\067\081\053\181\065" ..
		-- tex:"effc8617738fed5a071f20d123b69094"; x:434.574097; y:434.754761; z:22.651035
		"\230\239\246\114\018\225\235\007\147\166\234\245\058\023\238\243\115\070\062\068\241\072\092\066\095\133\202\065" ..
		-- tex:"e6eff67212e1eb0793a6eaf53a17eef3"; x:761.100830; y:55.071236; z:25.315125
		"\212\060\053\207\115\171\253\132\010\046\005\058\205\250\093\073\117\070\062\068\081\151\201\067\120\133\202\065" ..
		-- tex:"d43c35cf73abfd840a2e053acdfa5d49"; x:761.100952; y:403.182190; z:25.315172
		"\074\233\097\121\165\184\169\031\218\180\017\176\218\044\077\221\043\175\074\067\193\053\093\068\067\016\252\065" ..
		-- tex:"4ae96179a5b8a91fdab411b0da2c4ddd"; x:202.684265; y:884.839966; z:31.507942
		"\069\098\076\070\254\082\033\205\168\008\125\168\142\038\245\088\043\175\074\067\193\053\029\068\067\016\252\065" ..
		-- tex:"45624c46fe5221cda8087da88e26f558"; x:202.684265; y:628.839966; z:31.507942
		"\211\041\251\045\054\070\156\129\226\097\153\181\157\071\155\066\144\012\145\067\231\045\252\067\183\112\008\066",
		-- tex:"d329fb2d36469c81e26199b59d479b42"; x:290.098175; y:504.358643; z:34.110077
	["Shadowfang Keep"] = 
		"\171\073\092\143\221\004\163\072\003\080\072\058\021\167\043\058\069\104\187\195\072\228\103\195\249\154\154\192" ..
		-- tex:"ab495c8fdd04a3480350483a15a72b3a"; x:-374.814636; y:-231.891739; z:-4.831418
		"\108\186\030\167\178\038\212\087\105\162\204\162\188\016\219\078\045\115\180\195\049\188\202\194\195\115\151\192" ..
		-- tex:"6cba1ea7b226d45769a2cca2bc10db4e"; x:-360.899841; y:-101.367569; z:-4.732882
		"\207\057\225\090\231\204\173\210\117\180\137\198\145\093\223\028\154\123\159\195\012\150\163\193\194\203\028\192" ..
		-- tex:"cf39e15ae7ccadd275b489c6915ddf1c"; x:-318.965668; y:-20.448267; z:-2.449937
		"\115\252\029\112\205\089\039\173\026\090\071\104\005\070\053\144\249\034\022\195\142\011\143\194\205\055\134\191" ..
		-- tex:"73fc1d70cd5927ad1a5a476805463590"; x:-150.136627; y:-71.522575; z:-1.048578
		"\148\050\132\146\056\189\057\006\223\001\090\030\088\060\162\185\135\034\082\194\006\236\215\065\028\181\122\191" ..
		-- tex:"9432849238bd3906df015a1e583ca2b9"; x:-52.533722; y:26.990248; z:-0.979326
		"\227\236\087\169\155\231\181\184\113\246\024\218\140\109\123\026\245\122\034\194\025\011\141\065\056\039\116\191" ..
		-- tex:"e3ec57a99be7b5b871f618da8c6d7b1a"; x:-40.620079; y:17.630421; z:-0.953723
		"\031\231\015\252\127\118\127\078\145\218\140\253\123\103\096\254\077\190\175\195\206\127\164\194\013\037\171\062" ..
		-- tex:"1fe70ffc7f767f4e91da8cfd7b6760fe"; x:-351.486755; y:-82.249626; z:0.334267
		"\008\208\085\102\071\199\178\037\181\187\131\087\229\160\158\007\025\035\152\195\065\068\243\194\152\013\152\064" ..
		-- tex:"08d0556647c7b225b5bb8357e5a09e07"; x:-304.274231; y:-121.633316; z:4.751660
		"\252\224\165\021\199\135\181\130\118\127\129\038\078\236\019\066\060\253\248\194\157\200\254\064\017\105\234\064" ..
		-- tex:"fce0a515c787b582767f81264eec1342"; x:-124.494606; y:7.961989; z:7.325326
		"\049\135\010\162\047\234\141\084\176\118\092\061\040\216\131\177\090\080\169\194\008\181\139\194\199\118\240\064" ..
		-- tex:"31870aa22fea8d54b0765c3d28d883b1"; x:-84.656944; y:-69.853584; z:7.514500
		"\058\031\156\253\253\205\167\004\001\220\023\091\008\117\183\107\066\207\184\195\080\013\128\195\109\142\255\064" ..
		-- tex:"3a1f9cfdfdcda70401dc175b0875b76b"; x:-369.619232; y:-256.104034; z:7.986136
		"\113\155\028\108\181\114\069\186\029\024\229\075\133\214\226\211\194\001\227\194\069\060\130\194\212\062\154\065" ..
		-- tex:"719b1c6cb57245ba1d18e54b85d6e2d3"; x:-113.503441; y:-65.117722; z:19.280680
		"\227\247\106\048\109\067\210\011\064\048\130\094\071\187\111\103\133\034\082\194\095\046\210\065\022\027\163\065" ..
		-- tex:"e3f76a306d43d20b4030825e47bb6f67"; x:-52.533714; y:26.272644; z:20.388227
		"\112\107\062\183\063\023\209\104\150\116\149\095\134\062\077\134\059\013\000\195\025\014\128\194\106\047\197\065" ..
		-- tex:"706b3eb73f17d1689674955f863e4d86"; x:-128.051697; y:-64.027542; z:24.648153
		"\160\157\009\091\253\214\160\036\129\056\089\114\217\112\015\220\164\099\179\195\190\252\138\195\218\225\211\065" ..
		-- tex:"a09d095bfdd6a02481385972d9700fdc"; x:-358.778473; y:-277.974579; z:26.485281
		"\191\208\052\092\115\096\234\136\061\033\068\077\064\204\013\144\186\116\168\195\185\252\138\195\077\237\211\065" ..
		-- tex:"bfd0345c7360ea883d21444d40cc0d90"; x:-336.911957; y:-277.974426; z:26.490871
		"\064\160\037\208\093\048\029\223\098\139\167\250\041\164\031\202\097\068\192\195\185\252\138\195\085\237\211\065" ..
		-- tex:"40a025d05d301ddf628ba7fa29a41fca"; x:-384.534241; y:-277.974426; z:26.490887
		"\143\150\104\237\097\079\230\234\188\109\166\000\129\022\245\151\191\001\227\194\037\188\181\193\030\010\212\065" ..
		-- tex:"8f9668ed614fe6eabc6da6008116f597"; x:-113.503418; y:-22.716869; z:26.504942
		"\123\087\006\253\019\053\212\112\072\084\182\140\066\130\159\048\191\001\227\194\157\005\000\194\178\033\212\065" ..
		-- tex:"7b5706fd1335d4704854b68c42829f30"; x:-113.503418; y:-32.005486; z:26.516455
		"\027\096\133\190\023\057\207\167\090\203\030\246\056\211\194\233\193\099\179\195\209\084\125\194\090\104\212\065" ..
		-- tex:"1b6085be1739cfa75acb1ef638d3c2e9"; x:-358.779358; y:-63.332832; z:26.550955
		"\002\102\223\212\083\219\207\094\017\037\068\039\175\033\018\181\123\068\192\195\062\081\125\194\149\114\212\065" ..
		-- tex:"0266dfd453dbcf5e11254427af2112b5"; x:-384.535034; y:-63.329342; z:26.555950
		"\059\010\161\040\043\111\120\056\100\195\003\153\043\200\147\016\241\201\133\195\129\240\220\194\047\090\001\066" ..
		-- tex:"3b0aa1282b6f783864c303992bc89310"; x:-267.577698; y:-110.469742; z:32.338074
		"\035\147\140\144\146\168\220\216\219\218\192\173\219\090\183\228\001\139\127\195\248\169\239\194\052\100\001\066" ..
		-- tex:"23938c9092a8dcd8dbdac0addb5ab7e4"; x:-255.542999; y:-119.831978; z:32.347858
		"\079\022\015\124\216\150\202\159\242\043\204\150\222\137\239\027\184\088\125\195\062\088\199\194\165\102\001\066" ..
		-- tex:"4f160f7cd896ca9ff22bcc96de89ef1b"; x:-253.346573; y:-99.672356; z:32.350243
		"\008\041\191\121\030\103\220\205\080\027\251\052\142\124\234\074\241\070\125\195\054\093\121\066\137\101\005\066" ..
		-- tex:"0829bf791e67dccd501bfb348e7cea4a"; x:-253.277130; y:62.341030; z:33.349159
		"\161\019\073\253\177\190\159\107\138\107\186\235\052\162\105\024\224\207\070\195\193\219\076\066\022\104\005\066" ..
		-- tex:"a11349fdb1be9f6b8a6bbaeb34a26918"; x:-198.812027; y:51.214607; z:33.351650
		"\122\023\190\144\093\092\219\047\075\071\116\132\227\145\191\052\034\188\087\195\198\125\052\066\137\049\008\066" ..
		-- tex:"7a17be905d5cdb2f4b477484e391bf34"; x:-215.734909; y:45.122829; z:34.048378
		"\081\170\173\226\009\012\072\236\014\124\115\251\083\016\226\186\233\027\218\195\219\172\040\195\105\124\010\066" ..
		-- tex:"51aaade2090c48ec0e7c73fb5310e2ba"; x:-436.218079; y:-168.675232; z:34.621498
		"\246\034\097\140\188\070\084\219\205\088\191\132\046\174\130\069\022\134\149\194\052\241\212\194\174\165\019\066" ..
		-- tex:"f622618cbc4654dbcd58bf842eae8245"; x:-74.761894; y:-106.471107; z:36.911800
		"\135\204\002\094\123\100\188\188\091\139\233\017\166\147\237\117\056\197\209\195\234\060\106\195\129\229\019\066" ..
		-- tex:"87cc025e7b64bcbc5b8be911a693ed75"; x:-419.540802; y:-234.237961; z:36.974129
		"\072\143\254\064\122\210\159\213\239\087\169\211\246\074\218\025\244\133\157\195\085\061\106\195\104\001\020\066" ..
		-- tex:"488ffe407ad29fd5ef57a9d3f64ada19"; x:-315.046539; y:-234.239594; z:37.001377
		"\087\200\109\249\122\183\039\160\100\084\074\118\149\171\205\179\246\133\157\195\119\095\084\195\104\001\020\066" ..
		-- tex:"57c86df97ab727a064544a7695abcdb3"; x:-315.046600; y:-212.372925; z:37.001377
		"\111\215\129\022\044\219\239\103\200\028\057\150\235\238\171\206\201\133\157\195\248\252\138\195\104\001\020\066" ..
		-- tex:"6fd781162cdbef67c81c3996ebeeabce"; x:-315.045227; y:-277.976349; z:37.001377
		"\230\212\235\063\121\129\129\151\239\120\104\048\111\221\077\182\040\051\203\195\097\013\128\195\104\001\020\066" ..
		-- tex:"e6d4eb3f79818197ef7868306fdd4db6"; x:-406.399689; y:-256.104553; z:37.001377
		"\016\155\182\190\047\103\034\249\053\088\216\221\202\199\253\117\244\133\157\195\151\013\128\195\104\001\020\066" ..
		-- tex:"109bb6be2f6722f93558d8ddcac7fd75"; x:-315.046539; y:-256.106201; z:37.001377
		"\241\146\124\243\241\152\219\069\094\185\221\188\249\093\101\168\050\051\203\195\195\252\138\195\104\001\020\066" ..
		-- tex:"f1927cf3f198db455eb9ddbcf95d65a8"; x:-406.399994; y:-277.974731; z:37.001377
		"\183\202\166\121\100\057\137\142\160\226\186\187\114\221\184\067\059\134\157\195\157\129\062\195\112\001\020\066" ..
		-- tex:"b7caa6796439898ea0e2babb72ddb843"; x:-315.048706; y:-190.506317; z:37.001408
		"\157\201\011\035\040\255\209\133\134\188\013\179\191\188\179\121\094\051\203\195\049\099\170\194\010\068\020\066" ..
		-- tex:"9dc90b2328ffd18586bc0db3bfbcb379"; x:-406.401337; y:-85.193741; z:37.066448
		"\120\189\189\020\068\139\136\041\126\010\251\195\034\094\115\101\093\051\203\195\248\078\125\194\010\068\020\066" ..
		-- tex:"78bdbd14448b88297e0afbc3225e7365"; x:-406.401306; y:-63.327122; z:37.066448
		"\249\233\218\074\168\226\137\166\119\030\035\045\146\133\023\195\094\051\203\195\232\030\214\194\011\068\020\066" ..
		-- tex:"f9e9da4aa8e289a6771e232d928517c3"; x:-406.401337; y:-107.060371; z:37.066452
		"\013\185\184\049\251\096\102\155\022\195\139\212\018\215\026\058\137\115\138\194\086\229\193\194\236\040\023\066" ..
		-- tex:"0db9b831fb60669b16c38bd412d71a3a"; x:-69.225662; y:-96.947929; z:37.789967
		"\038\088\026\088\025\017\045\164\064\135\221\219\049\103\052\078\034\188\087\195\123\153\225\065\136\049\024\066" ..
		-- tex:"26581a5819112da44087dddb3167344e"; x:-215.734909; y:28.199944; z:38.048374
		"\253\220\041\253\239\116\192\020\069\193\102\152\239\254\162\215\015\114\126\195\140\125\008\195\176\158\028\066" ..
		-- tex:"fddc29fdef74c01445c16698effea2d7"; x:-254.445557; y:-136.490433; z:39.154972
		"\147\151\230\005\135\251\116\073\013\183\173\252\190\157\198\236\146\058\070\195\123\153\225\065\134\049\032\066" ..
		-- tex:"9397e60587fb74490db7adfcbe9dc6ec"; x:-198.228806; y:28.199944; z:40.048367
		"\007\141\049\120\163\093\248\129\037\254\005\027\107\031\154\122\077\135\241\193\243\239\154\194\224\077\053\066" ..
		-- tex:"078d3178a35df88125fe051b6b1f9a7a"; x:-30.191067; y:-77.468658; z:45.326054
		"\189\064\042\079\063\062\210\084\054\197\069\127\132\044\242\234\245\013\201\194\097\062\158\194\237\077\053\066" ..
		-- tex:"bd402a4f3f3ed25436c5457f842cf2ea"; x:-100.527267; y:-79.121841; z:45.326103
		"\217\153\021\185\024\029\065\127\124\214\056\239\116\160\234\155\099\035\191\193\211\194\031\194\159\081\053\066" ..
		-- tex:"d99915b9181d417f7cd638ef74a0ea9b"; x:-23.892281; y:-39.940262; z:45.329712
		"\243\062\063\196\117\088\116\201\040\036\069\145\091\191\095\238\186\202\157\195\229\216\029\195\070\186\059\066" ..
		-- tex:"f33e3fc4755874c9282445915bbf5fee"; x:-315.583832; y:-157.847260; z:46.931911
		"\094\071\069\204\073\040\048\054\161\222\066\036\176\141\225\173\153\204\147\195\005\249\054\195\002\001\060\066" ..
		-- tex:"5e4745cc49283036a1de4224b08de1ad"; x:-295.598450; y:-182.972748; z:47.000988
		"\124\015\012\184\066\230\231\093\228\011\217\155\126\149\121\227\252\140\154\195\089\163\040\195\226\046\060\066" ..
		-- tex:"7c0f0cb842e6e75de40bd99b7e9579e3"; x:-309.101471; y:-168.638092; z:47.045788
		"\052\250\248\246\194\109\016\050\238\024\002\187\135\204\245\011\232\200\167\195\230\184\004\195\157\050\060\066" ..
		-- tex:"34faf8f6c26d1032ee1802bb87ccf50b"; x:-335.569611; y:-132.722275; z:47.049431
		"\220\203\231\119\233\227\049\095\057\122\176\143\105\200\207\242\255\205\129\195\106\161\012\195\100\063\060\066" ..
		-- tex:"dccbe777e9e3315f397ab08f69c8cff2"; x:-259.609375; y:-140.630539; z:47.061909
		"\076\061\123\226\191\031\142\010\250\213\204\071\119\035\112\006\070\148\097\195\200\146\034\066\008\030\127\066" ..
		-- tex:"4c3d7be2bf1f8e0afad5cc4777237006"; x:-225.579208; y:40.643345; z:63.779331
		"\128\222\139\052\242\090\160\233\063\069\068\111\061\150\056\097\113\018\099\195\202\121\141\065\004\143\137\066" ..
		-- tex:"80de8b34f25aa0e93f45446f3d963861"; x:-227.072052; y:17.684469; z:68.779335
		"\139\154\210\119\086\217\039\242\054\198\226\012\008\191\085\189\029\159\085\195\102\136\129\065\004\143\147\066" ..
		-- tex:"8b9ad27756d927f236c6e20c08bf55bd"; x:-213.621552; y:16.191603; z:73.779335
		"\090\008\084\094\049\167\072\072\112\036\096\028\222\197\210\049\115\018\099\195\165\218\012\066\004\143\162\066" ..
		-- tex:"5a08545e31a748487024601cdec5d231"; x:-227.072083; y:35.213524; z:81.279335
		"\006\016\005\252\235\069\111\048\247\072\203\088\253\065\047\178\115\018\099\195\098\136\129\065\090\228\180\066" ..
		-- tex:"061005fceb456f30f748cb58fd412fb2"; x:-227.072083; y:16.191595; z:90.446007
		"\235\063\083\168\078\153\116\196\195\008\174\235\023\123\148\076\202\195\088\195\015\035\237\065\004\143\197\066" ..
		-- tex:"eb3f53a84e9974c4c308aeeb177b944c"; x:-216.764816; y:29.642120; z:98.779335
		"\195\153\036\198\123\243\161\052\066\200\127\091\128\168\120\122\131\249\120\195\235\225\119\066\079\089\202\066" ..
		-- tex:"c39924c67bf3a13442c87f5b80a8787a"; x:-248.974670; y:61.970627; z:101.174438
		"\174\183\069\212\220\050\218\127\061\225\068\130\144\139\212\115\069\084\118\195\124\155\016\067\194\079\206\066" ..
		-- tex:"aeb745d4dc32da7f3de14482908bd473"; x:-246.329193; y:144.607376; z:103.155785
		"\137\002\058\184\190\122\050\057\138\125\005\032\070\208\223\186\232\093\136\195\111\004\251\066\066\029\214\066" ..
		-- tex:"89023ab8be7a32398a7d052046d0dfba"; x:-272.733673; y:125.508667; z:107.057152
		"\248\173\101\175\027\142\245\040\227\230\041\029\197\133\161\207\214\168\139\195\156\254\173\066\189\234\221\066" ..
		-- tex:"f8ad65af1b8ef528e3e6291dc585a1cf"; x:-279.319061; y:86.997292; z:110.958481
		"\119\044\057\041\065\227\249\146\200\163\191\194\174\067\203\148\081\046\138\195\042\038\099\066\154\171\231\066" ..
		-- tex:"772c392941e3f992c8a3bfc2ae43cb94"; x:-276.361877; y:56.787273; z:115.835167
		"\022\143\030\150\134\213\046\179\011\236\197\150\210\068\005\103\189\105\126\195\003\254\052\066\022\121\239\066" ..
		-- tex:"168f1e9686d52eb30becc596d2440567"; x:-254.413055; y:45.248062; z:119.736504
		"\003\226\164\237\069\010\189\076\063\090\187\089\101\212\153\238\069\084\118\195\124\155\016\067\029\083\245\066" ..
		-- tex:"03e2a4ed450abd4c3f5abb5965d499ee"; x:-246.329193; y:144.607376; z:122.662338
		"\026\180\000\056\083\016\228\231\044\075\244\021\110\130\157\167\232\093\136\195\109\004\251\066\052\235\254\066" ..
		-- tex:"1ab400385310e4e72c4bf4156e829da7"; x:-272.733673; y:125.508652; z:127.459389
		"\032\023\124\040\083\060\185\184\156\015\207\144\188\210\067\178\213\168\139\195\157\254\173\066\003\007\005\067" ..
		-- tex:"20177c28533cb9b89c0fcf90bcd243b2"; x:-279.319031; y:86.997299; z:133.027405
		"\107\119\101\225\153\225\141\116\015\242\029\203\088\226\161\049\077\075\117\195\092\130\041\067\252\027\007\067" ..
		-- tex:"6b7765e199e18d740ff21dcb58e2a131"; x:-245.294159; y:169.509232; z:135.109329
		"\213\026\205\166\054\168\245\178\155\101\132\102\144\076\040\037\081\046\138\195\042\038\099\066\052\019\012\067" ..
		-- tex:"d51acda636a8f5b29b658466904c2825"; x:-276.361877; y:56.787273; z:140.075027
		"\206\207\039\100\065\091\042\201\237\066\016\124\155\011\248\162\188\105\126\195\008\254\052\066\045\206\017\067" ..
		-- tex:"cecf2764415b2ac9ed42107c9b0bf8a2"; x:-254.413040; y:45.248081; z:145.805389
		"\222\033\206\116\224\129\000\087\083\116\172\027\225\133\177\154\189\095\116\195\237\225\119\066\121\020\021\067",
		-- tex:"de21ce74e08100575374ac1be185b19a"; x:-244.373993; y:61.970634; z:149.079987
	["Stratholme"] = 
		"\039\164\007\238\243\075\179\241\181\243\217\053\081\226\044\026\234\069\137\196\147\108\187\067\206\210\052\195" ..
		-- tex:"27a407eef34bb3f1b5f3d93551e22c1a"; x:-1098.184937; y:374.848267; z:-180.823471
		"\239\023\145\039\054\217\167\221\203\046\195\187\076\174\144\143\234\069\169\196\093\170\220\067\206\210\052\195" ..
		-- tex:"ef17912736d9a7ddcb2ec3bb4cae908f"; x:-1354.184937; y:441.330994; z:-180.823471
		"\086\102\213\171\104\088\145\031\048\085\038\189\118\238\238\216\234\069\169\196\073\182\029\068\206\210\052\195" ..
		-- tex:"5666d5ab6858911f305526bd76eeeed8"; x:-1354.184937; y:630.848267; z:-180.823471
		"\021\240\248\171\071\092\100\091\018\202\234\182\054\158\041\217\234\069\169\196\093\170\220\067\206\210\052\195" ..
		-- tex:"15f0f8ab475c645b12caeab6369e29d9"; x:-1354.184937; y:441.330994; z:-180.823471
		"\206\104\242\120\252\036\123\145\107\218\137\105\003\028\037\021\234\069\169\196\147\108\187\067\206\210\052\195" ..
		-- tex:"ce68f278fc247b916bda8969031c2515"; x:-1354.184937; y:374.848267; z:-180.823471
		"\150\175\186\094\231\072\001\150\055\065\003\076\041\171\165\106\187\159\085\196\181\240\166\067\140\182\035\195" ..
		-- tex:"96afba5ee74801963741034c29aba56a"; x:-854.495850; y:333.880554; z:-163.713089
		"\198\117\084\237\115\148\077\171\156\130\044\103\090\173\113\012\221\207\138\196\215\194\155\066\140\182\035\195" ..
		-- tex:"c67554ed73944dab9c822c675aad710c"; x:-1110.495850; y:77.880554; z:-163.713089
		"\017\133\034\151\178\197\052\252\145\188\080\158\170\096\182\195\221\207\138\196\181\240\166\067\140\182\035\195" ..
		-- tex:"11852297b2c534fc91bc509eaa60b6c3"; x:-1110.495850; y:333.880554; z:-163.713089
		"\225\189\017\220\149\144\042\164\138\011\201\084\045\006\105\198\028\087\123\196\221\090\199\066\140\182\035\195" ..
		-- tex:"e1bd11dc95902aa48a0bc9542d0669c6"; x:-1005.361145; y:99.677475; z:-163.713089
		"\092\018\099\020\016\176\208\132\018\114\090\048\136\088\134\130\081\248\101\196\221\090\199\066\140\182\035\195" ..
		-- tex:"5c12631410b0d08412725a3088588682"; x:-919.880005; y:99.677475; z:-163.713089
		"\144\175\119\223\151\096\127\143\232\222\065\254\243\011\246\102\187\159\085\196\215\194\155\066\140\182\035\195" ..
		-- tex:"90af77df97607f8fe8de41fef30bf666"; x:-854.495850; y:77.880554; z:-163.713089
		"\001\145\035\172\021\123\213\206\230\056\142\228\123\191\172\160\059\195\105\196\049\075\022\068\071\243\027\195" ..
		-- tex:"019123ac157bd5cee6388ee47bbfaca0"; x:-935.050537; y:601.174927; z:-155.950317
		"\149\252\027\029\158\056\234\203\036\009\222\055\115\084\069\035\059\195\105\196\049\075\022\068\071\243\027\195" ..
		-- tex:"95fc1b1d9e38eacb2409de3773544523"; x:-935.050537; y:601.174927; z:-155.950317
		"\043\224\152\009\215\161\230\142\035\166\249\128\242\223\145\251\065\127\138\196\229\045\217\067\071\243\027\195" ..
		-- tex:"2be09809d7a1e68e23a6f980f2df91fb"; x:-1107.976807; y:434.358582; z:-155.950317
		"\166\240\188\107\181\108\141\254\015\143\234\154\181\058\047\251\131\254\084\196\229\045\217\067\071\243\027\195" ..
		-- tex:"a6f0bc6bb56c8dfe0f8fea9ab53a2ffb"; x:-851.976807; y:434.358582; z:-155.950317
		"\111\229\162\127\200\233\072\070\176\195\092\253\124\111\161\048\131\254\084\196\242\150\044\068\071\243\027\195" ..
		-- tex:"6fe5a27fc8e94846b0c35cfd7c6fa130"; x:-851.976807; y:690.358582; z:-155.950317
		"\119\204\171\181\040\060\167\194\238\042\214\223\029\035\149\152\065\127\138\196\242\150\044\068\071\243\027\195" ..
		-- tex:"77ccabb5283ca7c2ee2ad6df1d239598"; x:-1107.976807; y:690.358582; z:-155.950317
		"\081\007\131\180\224\038\162\186\149\144\046\180\197\170\177\234\052\223\143\196\109\107\083\195\005\161\027\195" ..
		-- tex:"510783b4e026a2ba95902eb4c5aab1ea"; x:-1150.975220; y:-211.419647; z:-155.628998
		"\138\067\076\076\034\137\122\130\143\019\053\237\165\010\097\187\105\190\095\196\182\181\233\195\005\161\027\195" ..
		-- tex:"8a434c4c22897a828f1335eda50a61bb"; x:-894.975220; y:-467.419647; z:-155.628998
		"\028\120\064\226\047\190\194\015\046\005\098\187\131\120\050\083\105\190\031\196\182\181\233\195\005\161\027\195" ..
		-- tex:"1c7840e22fbec20f2e0562bb83783253"; x:-638.975220; y:-467.419647; z:-155.628998
		"\025\058\052\041\134\100\181\131\089\045\175\143\147\183\161\095\052\223\143\196\182\181\233\195\005\161\027\195" ..
		-- tex:"193a34298664b583592daf8f93b7a15f"; x:-1150.975220; y:-467.419647; z:-155.628998
		"\061\071\201\193\203\167\108\228\067\018\220\248\154\043\143\027\105\190\095\196\109\107\083\195\005\161\027\195" ..
		-- tex:"3d47c9c1cba76ce44312dcf89a2b8f1b"; x:-894.975220; y:-211.419647; z:-155.628998
		"\055\229\041\109\061\162\198\230\105\131\114\101\045\141\239\221\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"37e5296d3da2c6e6698372652d8defdd"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\161\173\192\012\221\183\209\235\223\224\096\022\153\019\102\181\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"a1adc00cddb7d1ebdfe06016991366b5"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\152\178\041\059\110\081\136\231\061\075\076\176\168\175\236\142\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"98b2293b6e5188e73d4b4cb0a8afec8e"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\084\209\238\158\107\051\223\097\243\010\107\069\076\110\196\050\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"54d1ee9e6b33df61f30a6b454c6ec432"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\000\069\043\199\247\007\205\024\034\145\046\186\169\080\141\031\041\195\139\196\158\029\221\194\151\067\242\194" ..
		-- tex:"00452bc7f707cd1822912ebaa9508d1f"; x:-1118.098877; y:-110.557854; z:-121.132019
		"\191\148\213\151\140\224\251\087\102\239\006\210\249\229\236\239\041\195\171\196\158\029\221\194\151\067\242\194" ..
		-- tex:"bf94d5978ce0fb5766ef06d2f9e5ecef"; x:-1374.098877; y:-110.557854; z:-121.132019
		"\051\002\154\167\095\106\145\008\034\017\182\156\050\160\229\233\105\190\095\196\223\194\155\194\201\147\222\194" ..
		-- tex:"33029aa75f6a91082211b69c32a0e5e9"; x:-894.975220; y:-77.880615; z:-111.288651
		"\137\006\160\252\212\026\127\224\085\138\071\099\023\185\093\105\052\223\143\196\060\007\141\194\201\147\222\194" ..
		-- tex:"8906a0fcd41a7fe0558a476317b95d69"; x:-1150.975220; y:-70.514137; z:-111.288651
		"\194\196\234\124\187\046\022\117\007\156\194\031\033\246\179\044\052\223\143\196\186\047\124\194\201\147\222\194" ..
		-- tex:"c2c4ea7cbb2e1675079cc21f21f6b32c"; x:-1150.975220; y:-63.046612; z:-111.288651
		"\212\248\004\044\094\045\022\164\167\182\028\077\184\002\178\026\052\223\143\196\223\194\155\194\201\147\222\194" ..
		-- tex:"d4f8042c5e2d16a4a7b61c4db802b21a"; x:-1150.975220; y:-77.880615; z:-111.288651
		"\040\022\036\074\242\197\117\174\156\236\040\043\120\047\150\092\052\223\143\196\181\156\252\194\201\147\222\194" ..
		-- tex:"2816244af2c575ae9cec282b782f965c"; x:-1150.975220; y:-126.306076; z:-111.288651
		"\072\016\248\002\031\109\052\096\204\249\225\238\024\031\032\097\105\190\095\196\181\156\252\194\201\147\222\194" ..
		-- tex:"4810f8021f6d3460ccf9e1ee181f2061"; x:-894.975220; y:-126.306076; z:-111.288651
		"\209\009\064\169\229\084\150\052\120\209\214\037\102\164\250\041\052\223\143\196\193\087\095\194\201\147\222\194" ..
		-- tex:"d10940a9e554963478d1d62566a4fa29"; x:-1150.975220; y:-55.835701; z:-111.288651
		"\197\107\167\041\102\111\208\223\147\133\070\215\083\090\115\195\216\033\143\196\036\143\082\195\017\100\212\194" ..
		-- tex:"c56ba729666fd0df938546d7535a73c3"; x:-1145.057739; y:-210.559158; z:-106.195450
		"\083\157\102\120\148\180\238\202\113\175\161\249\017\028\214\235\216\033\175\196\036\143\082\195\017\100\212\194" ..
		-- tex:"539d667894b4eeca71afa1f9111cd6eb"; x:-1401.057739; y:-210.559158; z:-106.195450
		"\015\225\162\150\226\198\146\168\030\031\068\111\179\159\153\151\216\033\175\196\107\195\053\066\017\100\212\194" ..
		-- tex:"0fe1a296e2c692a81e1f446fb39f9997"; x:-1401.057739; y:45.440842; z:-106.195450
		"\018\249\193\231\194\177\140\123\156\031\137\116\113\159\247\114\216\033\143\196\107\195\053\066\017\100\212\194" ..
		-- tex:"12f9c1e7c2b18c7b9c1f8974719ff772"; x:-1145.057739; y:45.440842; z:-106.195450
		"\131\245\126\160\095\008\094\196\236\066\191\146\094\211\051\218\071\115\017\195\233\204\156\194\248\134\205\194" ..
		-- tex:"83f57ea05f085ec4ec42bf925ed333da"; x:-145.450317; y:-78.400223; z:-102.763618
		"\079\069\253\016\201\173\158\190\010\069\079\206\001\024\129\049\111\025\221\066\233\204\156\194\248\134\205\194" ..
		-- tex:"4f45fd10c9ad9ebe0a454fce01188131"; x:110.549683; y:-78.400223; z:-102.763618
		"\096\101\055\111\039\022\085\247\012\089\227\011\152\113\001\008\253\025\166\196\037\232\077\067\233\050\177\194" ..
		-- tex:"6065376f271655f70c59e30b98710108"; x:-1328.812256; y:205.906830; z:-88.599442
		"\165\029\244\153\159\242\094\168\245\146\066\155\080\216\106\224\069\136\159\196\091\091\088\067\233\050\177\194" ..
		-- tex:"a51df4999ff25ea8f592429b50d86ae0"; x:-1276.258545; y:216.356873; z:-88.599442
		"\050\186\175\122\015\081\178\006\157\177\177\083\138\140\048\176\069\136\159\196\068\052\071\067\233\050\177\194" ..
		-- tex:"32baaf7a0f51b2069db1b1538a8c30b0"; x:-1276.258545; y:199.204178; z:-88.599442
		"\091\020\186\017\149\189\115\160\047\160\027\156\140\032\200\068\139\016\127\196\091\091\088\067\233\050\177\194" ..
		-- tex:"5b14ba1195bd73a02fa01b9c8c20c844"; x:-1020.258545; y:216.356873; z:-88.599442
		"\139\142\029\228\195\164\235\203\251\062\255\143\042\173\115\219\131\198\019\196\222\152\029\196\211\069\176\194" ..
		-- tex:"8b8e1de4c3a4ebcbfb3eff8f2aad73db"; x:-591.101807; y:-630.388611; z:-88.136383
		"\108\001\246\158\164\017\090\184\033\222\050\175\122\173\205\003\191\193\164\195\153\177\129\195\211\069\176\194" ..
		-- tex:"6c01f69ea4115ab821de32af7aadcd03"; x:-329.513672; y:-259.387512; z:-88.136383
		"\130\117\238\216\214\062\031\060\223\186\001\210\122\097\131\218\078\039\019\196\121\229\144\195\211\069\176\194" ..
		-- tex:"8275eed8d63e1f3cdfba01d27a6183da"; x:-588.614197; y:-289.792786; z:-88.136383
		"\098\221\201\015\157\036\029\233\001\159\122\046\251\114\008\102\078\039\019\196\188\114\008\196\211\069\176\194" ..
		-- tex:"62ddc90f9d241de9019f7a2efb720866"; x:-588.614197; y:-545.792786; z:-88.136383
		"\161\042\044\153\073\176\235\251\191\093\154\099\191\031\177\198\223\096\018\196\153\177\129\195\211\069\176\194" ..
		-- tex:"a12a2c9949b0ebfbbf5d9a63bf1fb1c6"; x:-585.513672; y:-259.387512; z:-88.136383
		"\227\216\115\072\223\169\112\107\090\248\031\159\123\011\209\117\131\198\019\196\189\049\187\195\211\069\176\194" ..
		-- tex:"e3d87348dfa9706b5af81f9f7b0bd175"; x:-591.101807; y:-374.388611; z:-88.136383
		"\232\038\033\169\043\125\028\250\167\021\086\213\163\170\101\116\007\141\167\195\222\152\029\196\211\069\176\194" ..
		-- tex:"e82621a92b7d1cfaa71556d5a3aa6574"; x:-335.101807; y:-630.388611; z:-88.136383
		"\067\033\204\099\240\192\206\077\138\049\120\031\057\163\104\169\171\239\197\195\059\108\165\195\211\069\176\194" ..
		-- tex:"4321cc63f0c0ce4d8a31781f39a368a9"; x:-395.872437; y:-330.845581; z:-88.136383
		"\106\154\176\196\112\017\113\186\070\100\228\045\231\155\117\189\213\247\034\196\059\108\165\195\211\069\176\194" ..
		-- tex:"6a9ab0c4701171ba4664e42de79b75bd"; x:-651.872437; y:-330.845581; z:-88.136383
		"\027\051\015\029\113\062\157\227\128\054\086\196\183\216\185\134\007\141\167\195\189\049\187\195\211\069\176\194" ..
		-- tex:"1b330f1d713e9de3803656c4b7d8b986"; x:-335.101807; y:-374.388611; z:-88.136383
		"\123\117\155\121\248\047\078\242\146\054\201\039\215\161\047\246\157\033\155\195\191\162\168\192\137\221\174\194" ..
		-- tex:"7b759b79f82f4ef29236c927d7a12ff6"; x:-310.262634; y:-5.269867; z:-87.432693
		"\092\012\019\160\077\236\009\243\143\000\244\034\068\164\090\023\157\033\155\195\162\094\036\195\137\221\174\194" ..
		-- tex:"5c0c13a04dec09f38f00f42244a45a17"; x:-310.262634; y:-164.369675; z:-87.432693
		"\037\077\031\023\239\153\031\101\108\146\025\014\089\050\103\159\206\144\013\196\162\094\036\195\137\221\174\194" ..
		-- tex:"254d1f17ef991f656c92190e5932679f"; x:-566.262634; y:-164.369675; z:-87.432693
		"\137\210\231\120\248\127\156\176\081\237\069\245\138\241\031\081\138\038\253\195\065\065\135\195\137\221\174\194" ..
		-- tex:"89d2e778f87f9cb051ed45f58af11f51"; x:-506.301117; y:-270.509827; z:-87.432693
		"\016\244\163\073\223\060\020\058\079\005\196\060\067\098\214\064\206\144\013\196\162\094\036\195\137\221\174\194" ..
		-- tex:"10f4a349df3c143a4f05c43c4362d640"; x:-566.262634; y:-164.369675; z:-87.432693
		"\150\120\176\225\079\176\065\008\141\123\044\254\094\125\000\040\206\144\013\196\138\162\130\195\137\221\174\194" ..
		-- tex:"9678b0e14fb041088d7b2cfe5e7d0028"; x:-566.262634; y:-261.269867; z:-87.432693
		"\195\143\027\032\174\033\116\245\120\136\135\078\154\068\206\203\157\033\155\195\138\162\130\195\137\221\174\194" ..
		-- tex:"c38f1b20ae2174f57888874e9a44cecb"; x:-310.262634; y:-261.269867; z:-87.432693
		"\113\183\177\123\120\171\138\027\023\025\252\169\073\005\185\053\119\252\052\194\138\162\130\195\075\181\171\194" ..
		-- tex:"71b7b17b78ab8a1b1719fca94905b935"; x:-45.246552; y:-261.269867; z:-85.854095
		"\171\131\092\165\138\204\026\005\244\191\174\003\062\112\179\158\142\159\150\195\138\162\130\195\075\181\171\194" ..
		-- tex:"ab835ca58acc1a05f4bfae033e70b39e"; x:-301.246552; y:-261.269867; z:-85.854095
		"\246\181\245\040\085\016\157\153\243\027\192\074\152\057\155\022\119\252\052\194\191\162\168\192\075\181\171\194" ..
		-- tex:"f6b5f52855109d99f31bc04a98399b16"; x:-45.246552; y:-5.269867; z:-85.854095
		"\054\015\167\063\081\132\050\170\123\175\010\062\053\110\181\003\142\159\150\195\191\162\168\192\075\181\171\194" ..
		-- tex:"360fa73f518432aa7baf0a3e356eb503"; x:-301.246552; y:-5.269867; z:-85.854095
		"\187\222\032\129\017\232\214\001\246\171\025\246\238\024\087\040\194\147\236\195\190\023\006\196\071\145\170\194" ..
		-- tex:"bbde208111e8d601f6ab19f6ee185728"; x:-473.154388; y:-536.371033; z:-85.283752
		"\073\170\057\232\118\075\235\213\128\133\124\118\034\067\242\135\026\155\001\196\082\141\248\195\071\145\170\194" ..
		-- tex:"49aa39e8764bebd580857c762243f287"; x:-518.423523; y:-497.104095; z:-85.283752
		"\210\109\181\044\228\247\022\145\191\145\156\212\078\121\008\191\100\038\030\196\101\204\003\195\132\065\162\194" ..
		-- tex:"d26db52ce4f71691bf919cd44e7908bf"; x:-632.599915; y:-131.798431; z:-81.127968
		"\159\036\194\066\071\096\159\206\129\167\145\006\058\228\231\201\245\097\183\195\055\039\150\066\132\065\162\194" ..
		-- tex:"9f24c24247609fce81a791063ae4e7c9"; x:-366.765320; y:75.076599; z:-81.127968
		"\008\071\121\218\091\020\174\144\138\048\238\002\022\006\087\096\201\076\188\195\101\204\003\195\132\065\162\194" ..
		-- tex:"084779da5b14ae908a30ee0216065760"; x:-376.599915; y:-131.798431; z:-81.127968
		"\066\065\199\113\103\226\196\060\238\152\082\087\097\084\136\125\021\048\030\196\171\246\081\066\132\065\162\194" ..
		-- tex:"4241c77167e2c43cee9852576154887d"; x:-632.751343; y:52.490891; z:-81.127968
		"\088\169\016\193\250\048\033\057\246\087\132\215\138\216\022\106\007\252\035\196\222\170\085\066\132\065\162\194" ..
		-- tex:"58a910c1fa302139f65784d78ad8166a"; x:-655.937988; y:53.416866; z:-81.127968
		"\033\226\095\236\052\040\081\004\233\233\218\039\174\200\096\046\250\176\027\196\205\137\165\067\132\065\162\194" ..
		-- tex:"21e25fec34285104e9e9da27aec8602e"; x:-622.765320; y:331.076599; z:-81.127968
		"\195\108\220\202\089\186\215\239\255\136\230\186\044\067\022\179\250\176\027\196\055\039\150\066\132\065\162\194" ..
		-- tex:"c36cdcca59bad7efff88e6ba2c4316b3"; x:-622.765320; y:75.076599; z:-81.127968
		"\026\082\213\254\134\088\027\086\218\022\140\244\033\084\048\116\245\097\183\195\205\137\165\067\132\065\162\194" ..
		-- tex:"1a52d5fe86581b56da168cf421543074"; x:-366.765320; y:331.076599; z:-81.127968
		"\157\082\166\134\079\169\213\178\040\226\127\192\000\216\033\087\021\048\030\196\032\041\130\066\132\065\162\194" ..
		-- tex:"9d52a6864fa9d5b228e27fc000d82157"; x:-632.751343; y:65.080330; z:-81.127968
		"\241\140\047\036\243\006\198\232\092\021\120\086\113\232\112\214\100\038\030\196\051\103\248\066\132\065\162\194" ..
		-- tex:"f18c2f24f306c6e85c15785671e870d6"; x:-632.599915; y:124.201569; z:-81.127968
		"\019\091\153\039\201\043\208\227\163\156\118\153\018\188\193\114\221\207\138\196\116\076\029\067\025\088\153\194" ..
		-- tex:"135b9927c92bd0e3a39c769912bcc172"; x:-1110.495850; y:157.298660; z:-76.672073
		"\008\218\130\123\036\084\034\105\181\118\106\116\219\247\183\213\221\207\138\196\080\061\135\067\025\088\153\194" ..
		-- tex:"08da827b24542269b5766a74dbf7b7d5"; x:-1110.495850; y:270.479034; z:-76.672073
		"\041\216\049\124\054\184\204\133\066\021\055\193\172\120\237\228\248\030\147\196\173\074\141\067\025\088\153\194" ..
		-- tex:"29d8317c36b8cc85421537c1ac78ede4"; x:-1176.967896; y:282.583435; z:-76.672073
		"\088\157\059\033\233\139\235\079\215\202\123\011\102\079\035\223\241\061\102\196\173\074\141\067\025\088\153\194" ..
		-- tex:"589d3b21e98beb4fd7ca7b0b664f23df"; x:-920.967896; y:282.583435; z:-76.672073
		"\055\128\089\152\030\142\129\080\176\051\124\184\189\189\250\103\071\115\017\195\233\204\156\194\062\112\149\194" ..
		-- tex:"378059981e8e8150b0337cb8bdbdfa67"; x:-145.450317; y:-78.400223; z:-74.719231
		"\197\089\159\006\225\207\247\121\234\102\135\059\212\011\219\163\131\254\020\196\083\232\138\067\108\127\135\194" ..
		-- tex:"c5599f06e1cff779ea66873bd40bdba3"; x:-595.976807; y:277.815063; z:-67.748878
		"\014\004\114\176\024\028\225\113\057\235\139\236\071\162\052\171\065\127\138\196\015\228\220\067\108\127\135\194" ..
		-- tex:"0e0472b0181ce17139eb8bec47a234ab"; x:-1107.976807; y:441.781738; z:-67.748878
		"\005\250\144\004\071\151\237\169\133\131\087\135\018\080\014\099\131\254\084\196\041\116\005\068\108\127\135\194" ..
		-- tex:"05fa90044797eda98583578712500e63"; x:-851.976807; y:533.815063; z:-67.748878
		"\206\179\124\144\041\097\224\110\060\218\072\102\063\252\084\032\065\127\138\196\083\232\138\067\108\127\135\194" ..
		-- tex:"ceb37c902961e06e3cda48663ffc5420"; x:-1107.976807; y:277.815063; z:-67.748878
		"\201\036\243\124\046\026\165\116\004\014\220\044\063\111\105\093\131\254\084\196\083\232\138\067\108\127\135\194" ..
		-- tex:"c924f37c2e1aa574040edc2c3f6f695d"; x:-851.976807; y:277.815063; z:-67.748878
		"\005\001\242\081\050\184\068\206\219\207\213\170\246\198\152\219\065\127\138\196\028\007\194\067\108\127\135\194" ..
		-- tex:"0501f25132b844cedbcfd5aaf6c698db"; x:-1107.976807; y:388.055573; z:-67.748878
		"\064\115\170\117\051\231\011\046\231\193\139\013\041\104\185\042\163\170\234\195\029\005\178\066\104\152\131\194" ..
		-- tex:"4073aa7533e70b2ee7c18b0d2968b92a"; x:-469.333130; y:89.009995; z:-65.797676
		"\166\231\044\116\246\251\186\096\170\163\109\088\132\084\182\086\071\085\085\195\029\005\178\066\104\152\131\194" ..
		-- tex:"a6e72c74f6fbba60aaa36d588454b656"; x:-213.333130; y:89.009995; z:-65.797676
		"\238\092\221\091\213\178\186\244\139\246\057\179\066\099\100\007\071\085\085\195\224\188\182\066\104\152\131\194" ..
		-- tex:"ee5cdd5bd5b2baf48bf639b342636407"; x:-213.333130; y:91.368904; z:-65.797676
		"\179\004\244\219\055\097\150\188\020\227\011\102\029\102\232\003\163\170\234\195\224\188\182\066\104\152\131\194" ..
		-- tex:"b304f4db376196bc14e30b661d66e803"; x:-469.333130; y:91.368904; z:-65.797676
		"\089\027\130\016\020\088\099\073\206\170\002\027\014\132\164\056\205\236\255\195\215\206\177\067\003\101\093\194" ..
		-- tex:"591b821014586349ceaa021b0e84a438"; x:-511.850037; y:355.615967; z:-55.348648
		"\243\082\029\140\156\052\061\232\133\079\176\087\209\045\087\075\163\045\186\195\252\206\018\068\003\101\093\194" ..
		-- tex:"f3521d8c9c343de8854fb057d12d574b"; x:-372.356567; y:587.234192; z:-55.348648
		"\149\198\165\152\047\195\082\118\180\236\037\014\105\158\164\098\205\236\255\195\251\001\077\067\003\101\093\194" ..
		-- tex:"95c6a5982fc35276b4ec250e699ea462"; x:-511.850037; y:205.007751; z:-55.348648
		"\073\195\235\186\077\177\101\044\152\147\217\159\052\177\114\207\209\022\029\196\249\157\165\067\003\101\093\194" ..
		-- tex:"49c3ebba4db1652c9893d99f34b172cf"; x:-628.356567; y:331.234192; z:-55.348648
		"\039\220\076\102\053\160\079\149\114\072\240\025\191\248\139\182\209\022\029\196\252\206\018\068\003\101\093\194" ..
		-- tex:"27dc4c6635a04f957248f019bff88bb6"; x:-628.356567; y:587.234192; z:-55.348648
		"\006\185\250\121\123\062\102\241\025\206\021\092\019\087\064\176\163\045\186\195\249\157\165\067\003\101\093\194" ..
		-- tex:"06b9fa797b3e66f119ce155c135740b0"; x:-372.356567; y:331.234192; z:-55.348648
		"\014\044\022\138\218\071\116\056\171\025\248\101\045\093\126\006\017\227\177\195\029\005\178\066\119\013\090\194" ..
		-- tex:"0e2c168ada477438ab19f8652d5d7e06"; x:-355.773987; y:89.009995; z:-54.513153
		"\160\038\129\146\141\096\076\135\191\085\065\013\168\221\225\081\071\140\199\194\029\005\178\066\119\013\090\194" ..
		-- tex:"a02681928d604c87bf55410da8dde151"; x:-99.773987; y:89.009995; z:-54.513153
		"\035\050\130\137\093\224\094\159\139\026\012\223\231\075\025\169\017\227\177\195\029\005\178\066\119\013\090\194" ..
		-- tex:"233282895de05e9f8b1a0cdfe74b19a9"; x:-355.773987; y:89.009995; z:-54.513153
		"\123\032\104\087\055\110\025\123\016\047\149\084\110\075\223\085\219\064\128\196\183\225\076\065\111\184\069\194" ..
		-- tex:"7b206857376e197b102f95546e4bdf55"; x:-1026.026855; y:12.805107; z:-49.430115
		"\158\184\163\188\019\178\050\022\007\011\007\065\224\222\022\077\253\252\115\196\136\221\118\065\128\179\069\194" ..
		-- tex:"9eb8a3bc13b23216070b0741e0de164d"; x:-975.953003; y:15.429086; z:-49.425297
		"\244\220\244\038\213\039\090\196\085\183\042\230\062\161\132\215\213\026\233\195\120\108\225\067\088\159\064\194" ..
		-- tex:"f4dcf426d5275ac455b72ae63ea184d7"; x:-466.209656; y:450.847443; z:-48.155613
		"\157\220\156\045\172\147\069\236\206\237\187\188\131\124\124\224\213\026\233\195\120\108\225\067\088\159\064\194" ..
		-- tex:"9ddc9c2dac9345ecceedbbbc837c7ce0"; x:-466.209656; y:450.847443; z:-48.155613
		"\133\142\124\117\121\136\045\133\075\221\065\170\232\139\237\167\213\026\233\195\120\108\225\067\088\159\064\194" ..
		-- tex:"858e7c7579882d854bdd41aae88beda7"; x:-466.209656; y:450.847443; z:-48.155613
		"\043\106\109\066\175\242\063\074\095\149\224\110\189\082\231\252\022\070\096\196\196\010\028\067\113\074\064\194" ..
		-- tex:"2b6a6d42aff23f4a5f95e06ebd52e7fc"; x:-897.095154; y:156.042068; z:-48.072701
		"\224\187\039\002\047\056\012\001\122\097\034\087\083\055\048\146\034\054\015\196\084\084\198\067\199\087\056\194" ..
		-- tex:"e0bb27022f380c017a61225753373092"; x:-572.845886; y:396.658844; z:-46.085724
		"\145\203\225\211\010\249\152\048\241\028\021\220\038\142\085\099\173\234\164\195\060\008\198\195\211\039\047\194" ..
		-- tex:"91cbe1d30af99830f11c15dc268e5563"; x:-329.833435; y:-396.064362; z:-43.788895
		"\175\173\051\109\236\219\175\248\242\088\086\222\207\017\111\076\033\215\046\196\144\122\031\193\112\127\046\194" ..
		-- tex:"afad336decdbaff8f25856decf116f4c"; x:-699.361450; y:-9.967423; z:-43.624454
		"\149\107\029\232\194\102\197\118\022\038\085\122\052\079\171\187\230\233\144\195\136\181\097\196\093\009\036\194" ..
		-- tex:"956b1de8c266c5761626557a344fabbb"; x:-289.827362; y:-902.836487; z:-41.009148
		"\028\249\096\079\007\105\188\248\198\183\022\172\070\216\219\153\021\190\083\196\170\207\182\067\126\142\033\194" ..
		-- tex:"1cf9604f0769bcf8c6b716ac46d8db99"; x:-846.970093; y:365.622406; z:-40.389156
		"\221\093\198\043\220\174\009\077\084\254\105\225\166\121\068\020\092\055\109\195\073\176\047\196\247\160\028\194" ..
		-- tex:"dd5dc62bdcae094d54fe69e1a6794414"; x:-237.216263; y:-702.754517; z:-39.157196
		"\179\044\166\004\219\219\176\005\181\099\152\084\074\244\252\156\174\076\065\196\249\139\202\067\246\087\013\194" ..
		-- tex:"b32ca604dbdbb005b56398544af4fc9c"; x:-773.198181; y:405.093567; z:-35.335903
		"\171\239\009\118\049\110\004\041\082\010\065\236\023\022\019\063\174\076\065\196\183\239\129\067\246\087\013\194" ..
		-- tex:"abef0976316e0429520a41ec1716133f"; x:-773.198181; y:259.872803; z:-35.335903
		"\199\132\210\078\055\185\127\170\237\075\047\001\125\016\231\179\174\076\065\196\030\228\195\067\246\087\013\194" ..
		-- tex:"c784d24e37b97faaed4b2f017d10e7b3"; x:-773.198181; y:391.782196; z:-35.335903
		"\217\240\089\082\083\052\203\078\048\001\064\070\115\029\038\083\030\186\137\196\048\152\252\067\081\136\215\193" ..
		-- tex:"d9f059525334cb4e30014046731d2653"; x:-1101.816284; y:505.188995; z:-26.941563
		"\136\089\019\135\118\016\252\195\163\174\032\019\029\111\139\223\155\067\207\195\213\131\029\196\106\089\165\193" ..
		-- tex:"885913877610fcc3a3ae20131d6f8bdf"; x:-414.528198; y:-630.059937; z:-20.668661
		"\231\096\224\172\031\125\041\131\122\003\168\100\090\248\117\164\206\016\204\195\061\220\013\196\106\089\165\193" ..
		-- tex:"e760e0ac1f7d29837a03a8645af875a4"; x:-408.131317; y:-567.441284; z:-20.668661
		"\160\127\144\006\009\166\218\199\214\056\045\215\191\204\227\109\147\184\217\195\086\023\018\196\106\089\165\193" ..
		-- tex:"a07f900609a6dac7d6382dd7bfcce36d"; x:-435.442017; y:-584.364685; z:-20.668661
		"\219\059\218\029\017\115\073\149\022\036\193\148\065\252\090\134\040\026\136\195\080\239\038\196\054\066\151\193" ..
		-- tex:"db3bda1d117349951624c19441fc5a86"; x:-272.204376; y:-667.739319; z:-18.907331
		"\157\056\175\155\117\127\016\054\044\105\050\202\177\025\008\147\119\058\087\195\016\233\030\196\054\066\151\193" ..
		-- tex:"9d38af9b757f10362c6932cab1190893"; x:-215.228394; y:-635.641663; z:-18.907331
		"\148\016\206\149\163\247\191\016\092\191\095\209\154\024\241\125\003\057\112\195\032\219\033\196\054\066\151\193" ..
		-- tex:"9410ce95a3f7bf105cbf5fd19a18f17d"; x:-240.222717; y:-647.423889; z:-18.907331
		"\217\036\155\254\152\048\223\198\213\139\103\235\221\047\239\245\101\082\006\195\191\151\031\196\053\066\151\193" ..
		-- tex:"d9249bfe9830dfc6d58b67ebdd2feff5"; x:-134.321869; y:-638.371094; z:-18.907330
		"\110\132\166\003\126\219\214\252\192\133\086\161\106\012\180\139\059\070\031\195\055\246\035\196\053\066\151\193" ..
		-- tex:"6e84a6037edbd6fcc08556a16a0cb48b"; x:-159.274353; y:-655.847168; z:-18.907330
		"\020\078\219\149\193\187\224\195\161\021\185\231\102\192\137\059\192\001\064\195\215\041\041\196\053\066\151\193" ..
		-- tex:"144edb95c1bbe0c3a115b9e766c0893b"; x:-192.006851; y:-676.653809; z:-18.907330
		"\069\021\035\097\158\122\022\018\117\073\038\190\050\250\223\172\025\185\218\194\049\057\027\196\053\066\151\193" ..
		-- tex:"451523619e7a1612754926be32fadfac"; x:-109.361526; y:-620.893677; z:-18.907330
		"\148\083\013\165\212\049\059\030\218\097\101\228\120\085\106\214\054\063\186\194\048\234\038\196\245\212\150\193" ..
		-- tex:"94530da5d4313b1eda6165e478556ad6"; x:-93.123466; y:-667.659241; z:-18.853985
		"\222\196\148\099\003\083\243\036\227\147\188\145\223\013\240\161\104\190\159\195\069\138\033\196\079\002\140\193" ..
		-- tex:"dec494630353f324e393bc91df0df0a1"; x:-319.487579; y:-646.160522; z:-17.501129
		"\093\009\051\070\096\222\152\068\158\179\150\248\198\236\210\102\149\238\176\195\049\101\004\196\028\247\139\193" ..
		-- tex:"5d09334660de98449eb396f8c6ecd266"; x:-353.863953; y:-529.581177; z:-17.495661
		"\198\152\058\046\156\191\107\220\012\254\184\208\254\146\179\205\184\235\247\194\241\163\018\196\056\237\139\193" ..
		-- tex:"c6983a2e9cbf6bdc0cfeb8d0fe92b3cd"; x:-123.960396; y:-586.561646; z:-17.490831
		"\178\192\160\111\246\190\141\069\142\070\029\047\197\108\151\240\104\139\154\064\206\118\045\196\132\069\125\193" ..
		-- tex:"b2c0a06ff6be8d458e461d2fc56c97f0"; x:4.829518; y:-693.856384; z:-15.829473
		"\196\060\161\074\115\208\144\236\204\028\073\146\118\046\022\176\038\067\137\194\138\032\020\196\196\191\123\193" ..
		-- tex:"c43ca14a73d090eccc1c4992762e16b0"; x:-68.631157; y:-592.508484; z:-15.734319
		"\081\062\016\003\157\179\189\137\253\088\173\068\248\216\222\251\034\214\001\194\141\203\013\196\193\191\123\193" ..
		-- tex:"513e10039db3bd89fd58ad44f8d8defb"; x:-32.459118; y:-567.180542; z:-15.734316
		"\027\131\177\127\067\200\238\237\060\135\173\009\046\210\084\018\088\091\156\195\119\127\005\068\056\228\067\193" ..
		-- tex:"1b83b17f43c8eeed3c87ad092ed25412"; x:-312.713654; y:533.991699; z:-12.243218
		"\123\072\084\054\051\103\174\222\190\135\126\028\107\135\185\062\148\117\095\196\069\214\051\068\046\253\009\193" ..
		-- tex:"7b4854363367aedebe877e1c6b87b93e"; x:-893.837219; y:719.348022; z:-8.624312
		"\173\030\147\239\238\194\168\213\114\137\086\242\039\020\092\054\003\045\154\196\046\058\011\068\031\126\152\065",
		-- tex:"ad1e93efeec2a8d5728956f227145c36"; x:-1233.406738; y:556.909119; z:19.061584
	["The Arcatraz"] = 
		"\212\135\170\241\000\206\082\209\073\244\096\203\179\048\022\177\107\250\033\196\060\098\006\195\150\143\233\196" ..
		-- tex:"d487aaf100ce52d149f460cbb33016b1"; x:-647.912842; y:-134.383743; z:-1868.487183
		"\165\018\009\131\182\216\143\195\152\013\203\167\012\208\226\254\006\106\035\196\156\234\012\195\105\217\211\195" ..
		-- tex:"a5120983b6d88fc3980dcba70cd0e2fe"; x:-653.656677; y:-140.916458; z:-423.698547
		"\170\107\122\119\087\200\088\241\131\196\101\037\121\106\141\160\007\106\035\196\156\234\012\195\138\224\044\195" ..
		-- tex:"aa6b7a7757c858f183c46525796a8da0"; x:-653.656738; y:-140.916458; z:-172.877121
		"\040\126\089\174\114\089\251\139\050\189\086\254\239\188\070\164\103\200\225\195\017\085\075\195\243\045\237\194" ..
		-- tex:"287e59ae7259fb8b32bd56feefbc46a4"; x:-451.565674; y:-203.332306; z:-118.589752
		"\201\125\144\163\082\061\121\109\063\080\083\013\102\193\074\041\222\166\042\196\250\124\007\067\189\052\028\194" ..
		-- tex:"c97d90a3523d796d3f50530d66c14a29"; x:-682.607361; y:135.488205; z:-39.051506
		"\111\134\221\100\013\166\035\245\207\002\070\189\196\228\097\095\189\077\213\195\250\124\007\067\189\052\028\194" ..
		-- tex:"6f86dd640da623f5cf0246bdc4e4615f"; x:-426.607361; y:135.488205; z:-39.051506
		"\072\211\016\150\174\066\228\007\148\125\229\121\113\018\133\091\222\166\042\196\125\190\195\067\189\052\028\194" ..
		-- tex:"48d31096ae42e407947de5797112855b"; x:-682.607361; y:391.488205; z:-39.051506
		"\185\014\106\171\067\195\156\034\239\184\023\081\223\201\211\106\189\077\213\195\125\190\195\067\189\052\028\194" ..
		-- tex:"b90e6aab43c39c22efb81751dfc9d36a"; x:-426.607361; y:391.488205; z:-39.051506
		"\088\123\242\031\177\106\079\248\047\038\108\194\230\172\134\206\212\248\244\195\218\142\161\194\050\238\014\194" ..
		-- tex:"587bf21fb16a4ff82f266cc2e6ac86ce"; x:-489.944000; y:-80.779015; z:-35.732616
		"\042\109\206\027\121\216\141\104\197\051\137\195\206\183\222\101\123\087\213\195\075\047\019\067\170\246\207\193" ..
		-- tex:"2a6dce1b79d88d68c53389c3ceb7de65"; x:-426.683472; y:147.184753; z:-25.995443
		"\202\138\040\059\122\027\162\157\006\126\026\028\078\252\043\173\203\200\158\195\045\236\161\193\131\246\207\193" ..
		-- tex:"ca8a283b7a1ba29d067e1a1c4efc2bad"; x:-317.568726; y:-20.240322; z:-25.995369
		"\012\200\086\151\139\166\156\130\029\165\002\077\070\160\083\171\079\161\240\195\013\101\062\195\216\008\199\193" ..
		-- tex:"0cc856978ba69c821da5024d46a053ab"; x:-481.260254; y:-190.394745; z:-24.879320
		"\216\171\033\141\030\240\006\072\238\020\036\111\110\177\243\204\079\161\240\195\227\053\131\066\216\008\199\193" ..
		-- tex:"d8ab218d1ef00648ee14246f6eb1f3cc"; x:-481.260254; y:65.605255; z:-24.879320
		"\034\178\209\093\049\072\067\251\199\013\049\010\059\094\085\056\167\080\056\196\227\053\131\066\216\008\199\193" ..
		-- tex:"22b2d15d314843fbc70d310a3b5e5538"; x:-737.260254; y:65.605255; z:-24.879320
		"\210\233\157\102\197\207\025\188\112\019\161\022\030\130\009\190\167\080\056\196\013\101\062\195\216\008\199\193" ..
		-- tex:"d2e99d66c5cf19bc7013a1161e8209be"; x:-737.260254; y:-190.394745; z:-24.879320
		"\032\238\208\034\023\170\000\185\041\140\114\088\073\235\171\050\255\177\078\194\232\101\018\195\219\165\178\193" ..
		-- tex:"20eed02217aa00b9298c725849ebab32"; x:-51.673828; y:-146.398087; z:-22.330986
		"\032\080\134\002\043\028\137\120\192\211\106\052\217\244\034\217\063\214\153\195\232\101\018\195\219\165\178\193" ..
		-- tex:"205086022b1c8978c0d36a34d9f422d9"; x:-307.673828; y:-146.398087; z:-22.330986
		"\149\075\038\150\009\226\057\072\229\134\238\121\103\083\176\252\063\214\153\195\045\052\219\066\219\165\178\193" ..
		-- tex:"954b269609e23948e586ee796753b0fc"; x:-307.673828; y:109.601913; z:-22.330986
		"\029\126\061\202\150\234\014\034\027\111\227\208\042\159\228\166\232\020\129\194\062\016\170\194\136\118\198\192" ..
		-- tex:"1d7e3dca96ea0e221b6fe3d02a9fe4a6"; x:-64.540840; y:-85.031731; z:-6.201970
		"\071\081\245\048\064\119\160\127\089\024\230\011\115\217\096\094\012\030\043\196\105\192\188\195\013\094\231\065" ..
		-- tex:"4751f5304077a07f5918e60b73d9605e"; x:-684.469543; y:-377.503235; z:28.920925
		"\165\060\134\137\096\245\090\008\037\061\183\030\157\093\190\175\010\015\011\196\204\246\135\066\207\203\027\066" ..
		-- tex:"a53c868960f55a08253db71e9d5dbeaf"; x:-556.235046; y:67.982033; z:38.949036
		"\232\148\176\046\246\013\079\020\072\068\240\201\062\064\006\218\031\130\235\195\197\228\098\195\045\147\031\066" ..
		-- tex:"e894b02ef60d4f144844f0c93e4006da"; x:-471.016602; y:-226.893646; z:39.893730
		"\100\171\074\166\156\176\194\227\245\213\116\014\049\081\157\009\063\004\087\195\098\114\241\195\045\147\031\066" ..
		-- tex:"64ab4aa69cb0c2e3f5d5740e31519d09"; x:-215.016602; y:-482.893646; z:39.893730
		"\135\107\050\064\105\218\123\244\032\246\163\206\158\002\009\048\063\004\087\195\197\228\098\195\045\147\031\066" ..
		-- tex:"876b324069da7bf420f6a3ce9e020930"; x:-215.016602; y:-226.893646; z:39.893730
		"\046\196\063\067\203\022\238\086\073\129\090\152\121\166\080\121\031\130\235\195\098\114\241\195\045\147\031\066" ..
		-- tex:"2ec43f43cb16ee5649815a9879a65079"; x:-471.016602; y:-482.893646; z:39.893730
		"\235\183\113\095\172\063\250\075\102\194\106\017\030\168\121\246\048\067\027\196\173\032\077\195\033\147\049\066" ..
		-- tex:"ebb7715fac3ffa4b66c26a111ea879f6"; x:-621.049866; y:-205.127655; z:44.393684
		"\079\072\183\005\083\179\110\045\040\104\082\062\066\156\045\175\104\150\246\195\022\216\155\195\128\249\049\066" ..
		-- tex:"4f48b70553b36e2d2868523e429c2daf"; x:-493.175079; y:-311.688202; z:44.493656
		"\093\051\124\085\112\176\206\222\057\020\016\224\118\094\050\063\233\084\208\195\234\072\109\195\168\249\049\066" ..
		-- tex:"5d337c5570b0cede391410e0765e323f"; x:-416.663391; y:-237.284836; z:44.493809
		"\160\119\172\092\239\063\156\020\153\057\089\179\136\079\012\183\014\194\135\196\193\155\202\066\167\184\144\066" ..
		-- tex:"a077ac5cef3f9c14993959b3884f0cb7"; x:-1086.064331; y:101.304214; z:72.360657
		"\004\250\176\253\168\221\188\065\102\198\068\173\111\090\108\087\014\194\135\196\240\166\178\067\167\184\144\066" ..
		-- tex:"04fab0fda8ddbc4166c644ad6f5a6c57"; x:-1086.064331; y:357.304214; z:72.360657
		"\108\084\239\114\169\206\174\070\113\063\250\255\178\072\188\033\029\132\079\196\240\166\178\067\167\184\144\066" ..
		-- tex:"6c54ef72a9ceae46713ffaffb248bc21"; x:-830.064331; y:357.304214; z:72.360657
		"\086\219\241\218\106\111\146\154\217\164\114\198\091\010\177\073\029\132\079\196\193\155\202\066\167\184\144\066" ..
		-- tex:"56dbf1da6a6f929ad9a472c65b0ab149"; x:-830.064331; y:101.304214; z:72.360657
		"\202\202\208\119\147\203\019\104\219\232\184\176\190\121\160\206\170\225\115\196\126\081\249\194\078\203\161\066" ..
		-- tex:"cacad07793cb1368dbe8b8b0be79a0ce"; x:-975.526062; y:-124.659172; z:80.897087
		"\190\160\138\044\123\047\245\132\213\001\177\030\180\061\030\109\159\201\072\196\204\108\127\194\023\181\177\066" ..
		-- tex:"bea08a2c7b2ff584d501b11eb43d1e6d"; x:-803.150391; y:-63.856251; z:88.853699
		"\235\088\134\128\029\194\213\075\235\241\136\063\193\205\211\206\212\182\223\195\060\036\173\194\071\189\192\066",
		-- tex:"eb5886801dc2d54bebf1883fc1cdd3ce"; x:-447.428375; y:-86.570778; z:96.369690
	["The Black Morass"] = 
		"\065\054\206\162\013\139\205\225\250\086\085\155\216\105\020\023\255\255\135\069\255\255\007\198\000\000\000\000" ..
		-- tex:"4136cea20d8bcde1fa56559bd8691417"; x:4352.000000; y:-8704.000000
		"\085\169\214\105\164\225\042\117\034\109\038\094\112\016\063\248\255\255\135\069\255\255\011\198\000\000\000\000" ..
		-- tex:"55a9d669a4e12a75226d265e70103ff8"; x:4352.000000; y:-8960.000000
		"\052\102\163\016\027\033\084\177\161\008\227\105\132\120\010\082\255\255\135\069\255\255\015\198\000\000\000\000" ..
		-- tex:"3466a3101b2154b1a108e36984780a52"; x:4352.000000; y:-9216.000000
		"\200\077\088\223\124\052\030\158\146\077\092\077\147\018\218\151\255\255\143\069\255\255\007\198\000\000\000\000" ..
		-- tex:"c84d58df7c341e9e924d5c4d9312da97"; x:4608.000000; y:-8704.000000
		"\042\206\156\007\050\027\221\204\048\168\071\179\088\239\209\035\255\255\143\069\255\255\011\198\000\000\000\000" ..
		-- tex:"2ace9c07321bddcc30a847b358efd123"; x:4608.000000; y:-8960.000000
		"\180\203\209\223\238\159\207\224\157\017\085\029\015\043\238\012\255\255\143\069\255\255\015\198\000\000\000\000" ..
		-- tex:"b4cbd1dfee9fcfe09d11551d0f2bee0c"; x:4608.000000; y:-9216.000000
		"\151\227\127\215\062\245\082\003\007\199\151\006\136\001\040\171\255\255\151\069\255\255\007\198\000\000\000\000" ..
		-- tex:"97e37fd73ef5520307c79706880128ab"; x:4864.000000; y:-8704.000000
		"\012\226\088\219\033\205\216\010\023\129\071\005\017\116\084\029\255\255\151\069\255\255\011\198\000\000\000\000" ..
		-- tex:"0ce258db21cdd80a178147051174541d"; x:4864.000000; y:-8960.000000
		"\203\147\104\007\088\115\214\080\096\016\013\104\100\012\034\254\255\255\151\069\255\255\015\198\000\000\000\000",
		-- tex:"cb9368075873d65060100d68640c22fe"; x:4864.000000; y:-9216.000000
	["The Blood Furnace"] = 
		"\203\086\229\051\174\167\130\235\236\101\078\079\247\105\151\081\143\073\000\196\138\023\194\066\096\027\141\195" ..
		-- tex:"cb56e533aea782ebec654e4ff7699751"; x:-513.149414; y:97.045982; z:-282.213898
		"\213\130\162\222\054\247\018\253\015\231\206\133\007\012\061\101\206\138\028\196\100\031\039\067\012\056\139\195" ..
		-- tex:"d582a2de36f712fd0fe7ce85070c3d65"; x:-626.168884; y:167.122627; z:-278.437897
		"\131\195\056\162\094\138\009\220\243\095\086\031\164\173\206\170\206\138\092\196\100\031\039\067\012\056\139\195" ..
		-- tex:"83c338a25e8a09dcf35f561fa4adceaa"; x:-882.168884; y:167.122627; z:-278.437897
		"\158\239\246\203\010\185\085\077\046\017\101\123\211\055\210\024\206\138\028\196\054\193\177\194\012\056\139\195" ..
		-- tex:"9eeff6cb0ab9554d2e11657bd337d218"; x:-626.168884; y:-88.877373; z:-278.437897
		"\159\066\059\046\017\154\011\206\161\011\038\095\089\080\247\154\206\138\092\196\054\193\177\194\012\056\139\195" ..
		-- tex:"9f423b2e119a0bcea10b265f5950f79a"; x:-882.168884; y:-88.877373; z:-278.437897
		"\014\100\146\135\118\067\077\178\222\235\214\129\218\197\070\221\206\138\092\196\178\143\211\067\012\056\139\195" ..
		-- tex:"0e64928776434db2deebd681dac546dd"; x:-882.168884; y:423.122627; z:-278.437897
		"\013\062\242\002\045\093\003\007\015\036\079\187\253\101\087\142\176\072\138\196\088\029\229\066\069\011\015\195" ..
		-- tex:"0d3ef2022d5d03070f244fbbfd65578e"; x:-1106.271606; y:114.557320; z:-143.044037
		"\203\019\240\141\008\076\092\073\175\180\063\190\176\152\047\096\050\090\239\195\172\217\096\067\056\026\236\194" ..
		-- tex:"cb13f08d084c5c49afb43fbeb0982f60"; x:-478.704681; y:224.850296; z:-118.051216
		"\090\247\163\219\084\227\216\224\246\097\191\213\049\190\183\034\101\180\094\195\172\217\096\067\056\026\236\194" ..
		-- tex:"5af7a3db54e3d8e0f661bfd531beb722"; x:-222.704681; y:224.850296; z:-118.051216
		"\140\064\015\249\163\065\220\185\164\128\147\213\246\076\092\099\250\111\191\195\207\113\067\194\118\134\179\194" ..
		-- tex:"8c400ff9a341dcb9a48093d5f64c5c63"; x:-382.874847; y:-48.861145; z:-89.762627
		"\176\240\050\077\036\001\053\122\066\190\083\117\039\245\184\080\250\111\191\195\139\035\079\067\118\134\179\194" ..
		-- tex:"b0f0324d2401357a42be537527f5b850"; x:-382.874847; y:207.138855; z:-89.762627
		"\093\068\019\001\033\170\115\243\252\046\152\172\244\040\017\177\235\191\253\194\207\113\067\194\118\134\179\194" ..
		-- tex:"5d44130121aa73f3fc2e98acf42811b1"; x:-126.874847; y:-48.861145; z:-89.762627
		"\064\102\172\025\052\047\056\093\040\054\030\133\001\048\148\207\235\191\253\194\139\035\079\067\118\134\179\194" ..
		-- tex:"4066ac19342f385d28361e85013094cf"; x:-126.874847; y:207.138855; z:-89.762627
		"\112\146\027\082\136\218\130\215\167\255\072\178\226\192\089\098\168\067\098\196\027\023\163\194\054\134\132\194" ..
		-- tex:"70921b5288da82d7a7ff48b2e2c05962"; x:-905.057190; y:-81.545135; z:-66.262138
		"\092\154\178\235\005\012\116\223\095\025\020\099\244\022\232\016\081\135\196\195\027\023\163\194\054\134\132\194" ..
		-- tex:"5c9ab2eb050c74df5f191463f416e810"; x:-393.057190; y:-81.545135; z:-66.262138
		"\104\034\076\017\179\243\023\117\129\101\207\008\139\175\056\243\081\135\196\195\113\116\046\067\054\134\132\194" ..
		-- tex:"68224c11b3f317758165cf088baf38f3"; x:-393.057190; y:174.454865; z:-66.262138
		"\097\109\019\184\000\016\133\116\005\132\105\190\089\221\191\034\168\067\098\196\113\116\046\067\054\134\132\194" ..
		-- tex:"616d13b800108574058469be59ddbf22"; x:-905.057190; y:174.454865; z:-66.262138
		"\049\173\095\147\099\033\166\025\210\110\140\146\030\245\109\150\168\067\034\196\027\023\163\194\054\134\132\194" ..
		-- tex:"31ad5f936321a619d26e8c921ef56d96"; x:-649.057190; y:-81.545135; z:-66.262138
		"\013\141\063\184\190\041\008\156\095\027\086\029\098\091\175\174\168\067\034\196\113\116\046\067\054\134\132\194" ..
		-- tex:"0d8d3fb8be29089c5f1b561d625bafae"; x:-649.057190; y:174.454865; z:-66.262138
		"\172\038\208\067\068\068\012\182\010\243\010\245\209\207\103\148\029\246\127\196\169\227\150\195\108\180\227\064" ..
		-- tex:"ac26d04344440cb60af30af5d1cf6794"; x:-1023.845581; y:-301.778625; z:7.115775
		"\097\246\215\000\114\197\099\070\184\051\083\022\137\144\186\199\173\153\063\196\054\120\162\195\087\181\227\064" ..
		-- tex:"61f6d70072c56346b83353168990bac7"; x:-766.401245; y:-324.939178; z:7.115887
		"\172\016\174\009\150\191\000\145\037\115\114\110\205\020\078\114\036\020\130\196\093\082\062\067\211\170\145\065" ..
		-- tex:"ac10ae0996bf00912573726ecd144e72"; x:-1040.629517; y:190.321739; z:18.208412
		"\165\204\152\066\015\140\122\023\005\107\249\128\127\055\045\089\036\020\130\196\068\091\131\194\211\170\145\065" ..
		-- tex:"a5cc98420f8c7a17056bf9807f372d59"; x:-1040.629517; y:-65.678261; z:18.208412
		"\242\130\150\184\063\128\215\092\212\015\155\203\188\108\024\254\097\082\057\196\055\092\213\195\202\179\151\065" ..
		-- tex:"f28296b83f80d75cd40f9bcbbc6c18fe"; x:-741.287231; y:-426.720459; z:18.962790
		"\079\012\242\063\099\102\203\046\184\226\247\233\174\115\156\177\097\082\121\196\055\092\213\195\202\179\151\065",
		-- tex:"4f0cf23f6366cb2eb8e2f7e9ae739cb1"; x:-997.287231; y:-426.720459; z:18.962790
	["The Botanica"] = 
		"\224\073\067\150\055\085\128\010\230\046\232\069\086\134\136\008\235\061\228\066\103\211\067\196\054\205\022\196" ..
		-- tex:"e04943963755800ae62ee84556868808"; x:114.120941; y:-783.303223; z:-603.206482
		"\151\233\205\127\045\210\096\022\114\040\235\026\069\018\174\138\235\061\228\066\179\233\129\196\054\205\022\196" ..
		-- tex:"97e9cd7f2dd260167228eb1a4512ae8a"; x:114.120941; y:-1039.303223; z:-603.206482
		"\150\249\133\100\149\255\034\141\021\240\125\220\233\192\170\225\132\240\198\195\179\233\129\196\054\205\022\196" ..
		-- tex:"96f9856495ff228d15f07ddce9c0aae1"; x:-397.879059; y:-1039.303223; z:-603.206482
		"\046\088\121\010\250\135\040\178\078\060\034\033\137\248\011\031\132\240\198\195\103\211\067\196\054\205\022\196" ..
		-- tex:"2e58790afa8728b24e3c222189f80b1f"; x:-397.879059; y:-783.303223; z:-603.206482
		"\160\210\112\098\236\213\150\238\235\092\147\090\003\037\032\094\009\225\013\195\179\233\129\196\054\205\022\196" ..
		-- tex:"a0d27062ecd596eeeb5c935a0325205e"; x:-141.879059; y:-1039.303223; z:-603.206482
		"\147\138\211\026\067\193\186\026\072\160\002\246\211\145\178\050\009\225\013\195\103\211\067\196\054\205\022\196" ..
		-- tex:"938ad31a43c1ba1a48a002f6d391b232"; x:-141.879059; y:-783.303223; z:-603.206482
		"\022\208\233\028\082\249\025\210\141\064\165\245\138\161\171\113\069\193\206\194\215\081\222\195\009\102\066\195" ..
		-- tex:"16d0e91c52f919d28d40a5f58aa1ab71"; x:-103.377487; y:-444.639404; z:-194.398590
		"\122\243\163\047\253\204\123\189\043\198\199\024\209\048\202\103\069\193\206\194\235\040\047\196\009\102\066\195" ..
		-- tex:"7af3a32ffdcc7bbd2bc6c718d130ca67"; x:-103.377487; y:-700.639404; z:-194.398590
		"\058\081\051\004\119\117\176\042\238\197\126\012\196\081\248\095\092\159\024\067\235\040\047\196\009\102\066\195" ..
		-- tex:"3a5133047775b02aeec57e0cc451f85f"; x:152.622513; y:-700.639404; z:-194.398590
		"\192\122\153\025\143\071\055\215\140\223\174\119\174\091\217\109\027\168\013\195\185\166\019\067\246\208\078\194" ..
		-- tex:"c07a99198f4737d78cdfae77ae5bd96d"; x:-141.656677; y:147.651276; z:-51.704067
		"\033\133\110\070\113\061\043\182\177\213\010\112\014\066\140\218\027\168\013\195\139\178\216\194\246\208\078\194" ..
		-- tex:"21856e46713d2bb6b1d50a700e428cda"; x:-141.656677; y:-108.348724; z:-51.704067
		"\146\142\158\243\050\156\084\241\247\063\137\202\124\199\155\229\027\168\013\195\162\044\182\195\246\208\078\194" ..
		-- tex:"928e9ef3329c54f1f73f89ca7cc79be5"; x:-141.656677; y:-364.348724; z:-51.704067
		"\000\083\172\151\212\059\013\013\011\000\106\095\059\252\166\127\199\175\228\066\139\178\216\194\246\208\078\194" ..
		-- tex:"0053ac97d43b0d0d0b006a5f3bfca67f"; x:114.343323; y:-108.348724; z:-51.704067
		"\074\247\234\117\100\093\086\151\193\246\007\033\217\017\189\231\126\188\160\067\037\010\159\196\136\177\073\194" ..
		-- tex:"4af7ea75645d5697c1f60721d911bde7"; x:321.472626; y:-1272.317139; z:-50.423374
		"\095\046\005\244\000\212\019\170\006\019\041\190\118\133\128\189\126\188\160\067\075\020\062\196\136\177\073\194" ..
		-- tex:"5f2e05f400d413aa061329be768580bd"; x:321.472626; y:-760.317139; z:-50.423374
		"\087\140\005\157\167\042\212\033\050\065\189\168\080\160\143\038\126\188\160\067\075\020\126\196\136\177\073\194" ..
		-- tex:"578c059da72ad4213241bda850a08f26"; x:321.472626; y:-1016.317139; z:-50.423374
		"\227\036\180\113\042\245\001\240\010\046\183\095\172\220\023\053\251\241\130\066\075\020\126\196\136\177\073\194" ..
		-- tex:"e324b4712af501f00a2eb75facdc1735"; x:65.472626; y:-1016.317139; z:-50.423374
		"\190\196\116\213\038\111\071\092\093\138\183\076\198\145\213\130\251\241\130\066\075\020\062\196\136\177\073\194" ..
		-- tex:"bec474d5266f475c5d8ab74cc691d582"; x:65.472626; y:-760.317139; z:-50.423374
		"\100\236\002\208\082\165\179\065\145\153\209\178\072\228\177\203\001\135\062\195\075\020\126\196\136\177\073\194" ..
		-- tex:"64ec02d052a5b3419199d1b248e4b1cb"; x:-190.527374; y:-1016.317139; z:-50.423374
		"\251\192\043\251\008\099\165\037\144\071\201\081\140\137\090\005\251\241\130\066\037\010\159\196\136\177\073\194" ..
		-- tex:"fbc02bfb0863a5259047c9518c895a05"; x:65.472626; y:-1272.317139; z:-50.423374
		"\028\036\234\227\013\094\024\078\085\197\227\083\097\100\079\124\001\135\062\195\037\010\159\196\136\177\073\194" ..
		-- tex:"1c24eae30d5e184e55c5e35361644f7c"; x:-190.527374; y:-1272.317139; z:-50.423374
		"\130\029\215\098\016\008\227\112\134\237\059\114\101\216\109\041\197\208\071\195\228\235\133\196\217\243\043\194" ..
		-- tex:"821dd7621008e37086ed3b7265d86d29"; x:-199.815521; y:-1071.371704; z:-42.988136
		"\184\119\217\143\190\112\165\158\185\060\132\158\040\074\193\139\098\232\227\195\228\235\133\196\217\243\043\194" ..
		-- tex:"b877d98fbe70a59eb93c849e284ac18b"; x:-455.815521; y:-1071.371704; z:-42.988136
		"\078\126\214\054\236\180\204\192\250\086\193\067\001\082\231\214\098\232\227\195\201\215\075\196\217\243\043\194" ..
		-- tex:"4e7ed636ecb4ccc0fa56c1430152e7d6"; x:-455.815521; y:-815.371704; z:-42.988136
		"\024\058\072\240\116\123\107\247\004\224\149\161\124\115\109\078\197\208\071\195\002\109\014\196\192\243\043\194" ..
		-- tex:"183a48f0747b6bf704e095a17c736d4e"; x:-199.815521; y:-569.703308; z:-42.988041
		"\245\214\163\241\189\046\080\121\020\136\243\007\223\076\184\225\098\232\227\195\002\109\014\196\192\243\043\194" ..
		-- tex:"f5d6a3f1bd2e50791488f307df4cb8e1"; x:-455.815521; y:-569.703308; z:-42.988041
		"\234\012\247\162\108\253\192\159\144\124\000\156\055\156\025\059\197\208\071\195\002\109\078\196\192\243\043\194" ..
		-- tex:"ea0cf7a26cfdc09f907c009c379c193b"; x:-199.815521; y:-825.703308; z:-42.988041
		"\105\083\019\077\149\035\244\228\181\072\251\000\131\180\053\030\098\232\227\195\002\109\078\196\192\243\043\194",
		-- tex:"6953134d9523f4e4b548fb0083b4351e"; x:-455.815521; y:-825.703308; z:-42.988041
	["The Deadmines"] = 
		"\068\006\251\018\004\116\159\237\007\098\062\219\250\103\073\213\143\118\022\194\179\224\003\195\182\242\059\194" ..
		-- tex:"4406fb1204749fed07623edbfa6749d5"; x:-37.615784; y:-131.877747; z:-46.987026
		"\128\188\036\211\236\220\235\069\136\099\139\224\074\078\108\018\040\195\056\065\059\081\171\194\136\091\015\194" ..
		-- tex:"80bc24d3ecdceb4588638be04a4e6c12"; x:11.547647; y:-85.658661; z:-35.839390
		"\153\071\004\202\045\090\157\037\118\106\107\103\139\130\065\035\024\239\082\066\186\109\238\194\153\186\012\194" ..
		-- tex:"994704ca2d5a9d25766a6b678b824123"; x:52.733494; y:-119.214317; z:-35.182228
		"\206\047\209\102\003\088\251\038\061\079\003\163\053\028\248\117\207\160\218\066\085\250\130\194\203\176\214\193" ..
		-- tex:"ce2fd1660358fb263d4f03a3351cf875"; x:109.314087; y:-65.488937; z:-26.836327
		"\182\023\193\205\088\120\015\174\168\228\051\163\074\072\041\127\045\066\135\066\072\015\184\065\154\189\169\193" ..
		-- tex:"b617c1cd58780faea8e433a34a48297f"; x:67.629257; y:23.007463; z:-21.217581
		"\026\100\228\066\105\251\144\036\232\065\087\231\238\083\032\116\252\142\173\195\066\138\037\195\116\025\146\065" ..
		-- tex:"1a64e44269fb9024e84157e7ee532074"; x:-347.117096; y:-165.540085; z:18.262430
		"\069\245\239\013\096\145\016\082\227\157\042\151\213\128\040\007\134\127\126\066\189\063\120\067\086\199\002\066" ..
		-- tex:"45f5ef0d60911052e39d2a97d5802807"; x:63.624538; y:248.248993; z:32.694668
		"\184\139\020\193\110\248\054\095\061\211\206\245\232\020\129\221\197\144\152\067\191\061\243\066\231\086\007\066" ..
		-- tex:"b88b14c16ef8365f3dd3cef5e81481dd"; x:305.131042; y:121.620605; z:33.834869
		"\157\016\152\043\226\187\066\231\212\140\255\109\028\097\024\218\095\245\252\066\177\144\114\067\125\176\007\066" ..
		-- tex:"9d10982be2bb42e7d48cff6d1c6118da"; x:126.479248; y:242.565216; z:33.922356
		"\057\190\082\069\008\240\191\061\005\029\168\185\073\250\024\120\123\238\092\067\058\230\090\067\127\216\014\066" ..
		-- tex:"39be524508f0bf3d051da8b949fa1878"; x:220.931580; y:218.899338; z:35.711426
		"\094\224\189\055\051\212\227\090\083\199\233\050\089\128\136\182\207\129\124\067\035\151\201\066\017\244\014\066" ..
		-- tex:"5ee0bd3733d4e35a53c7e932598088b6"; x:252.507080; y:100.795197; z:35.738350
		"\167\139\119\040\228\146\065\130\037\108\129\098\204\134\215\141\058\206\088\067\127\006\204\193\126\055\022\066" ..
		-- tex:"a78b7728e4924182256c8162cc86d78d"; x:216.805588; y:-25.503174; z:37.554195
		"\168\200\075\167\043\159\054\030\132\151\037\107\162\086\103\057\095\013\181\066\083\237\043\067\120\093\028\066" ..
		-- tex:"a8c84ba72b9f361e8497256ba2566739"; x:90.526123; y:171.927063; z:39.091282
		"\209\161\130\040\215\113\072\221\115\113\222\051\206\028\001\121\020\037\197\067\075\196\225\194\002\213\034\066" ..
		-- tex:"d1a18228d77148dd7371de33ce1c0179"; x:394.289703; y:-112.883392; z:40.708019
		"\018\135\147\084\098\115\047\042\197\167\115\187\173\015\067\191\086\094\135\067\081\132\044\066\080\055\045\066" ..
		-- tex:"1287935462732f2ac5a773bbad0f43bf"; x:270.737030; y:43.129219; z:43.304020
		"\009\096\211\214\050\158\107\148\127\167\044\051\238\094\115\012\165\145\176\067\209\038\019\066\129\103\046\066" ..
		-- tex:"0960d3d6329e6b947fa72c33ee5e730c"; x:353.137878; y:36.787910; z:43.601082
		"\128\084\003\163\051\059\169\222\192\038\237\174\228\177\192\151\020\108\135\067\138\253\003\193\191\128\051\066" ..
		-- tex:"805403a3333ba9dec026edaee4b1c097"; x:270.844391; y:-8.249400; z:44.875732
		"\233\023\254\158\172\209\201\068\198\148\250\077\173\044\153\158\008\250\238\067\186\149\099\195\020\120\056\066" ..
		-- tex:"e917fe9eacd1c944c694fa4dad2c999e"; x:477.953400; y:-227.584885; z:46.117268
		"\039\190\252\117\018\135\216\053\094\101\107\165\039\021\021\170\173\204\016\068\173\039\063\195\186\151\062\066" ..
		-- tex:"27befc751287d8355e656ba5271515aa"; x:579.198120; y:-191.154999; z:47.648174
		"\122\239\020\163\110\119\056\085\184\043\207\054\134\031\160\084\122\072\229\067\077\081\167\065\208\133\067\066" ..
		-- tex:"7aef14a36e773855b82bcf36861fa054"; x:458.566254; y:20.914700; z:48.880680
		"\058\234\199\245\123\021\013\026\025\033\210\215\238\228\182\072\018\047\000\068\169\048\147\195\152\084\073\066" ..
		-- tex:"3aeac7f57b150d1a1921d2d7eee4b648"; x:512.735535; y:-294.380188; z:50.332615
		"\112\174\137\105\040\186\246\223\094\152\038\196\033\163\223\173\163\047\241\067\111\021\113\193\217\077\081\066" ..
		-- tex:"70ae896928baf6df5e9826c421a3dfad"; x:482.372192; y:-15.067734; z:52.326027
		"\112\225\078\210\132\206\125\127\195\013\152\129\247\049\141\045\103\047\237\067\060\185\015\195\156\215\082\066" ..
		-- tex:"70e14ed284ce7d7fc30d9881f7318d2d"; x:474.370361; y:-143.723587; z:52.710560
		"\136\051\234\063\187\014\138\111\159\223\147\201\187\244\185\078\136\045\196\067\009\075\172\195\105\231\130\066" ..
		-- tex:"8833ea3fbb0e8a6f9fdf93c9bbf4b94e"; x:392.355743; y:-344.586243; z:65.451981
		"\149\161\087\244\221\029\092\116\131\246\075\094\133\041\209\045\113\246\200\067\012\238\148\195\105\231\130\066" ..
		-- tex:"95a157f4dd1d5c7483f64b5e8529d12d"; x:401.925354; y:-297.859772; z:65.451981
		"\201\051\206\086\097\073\045\244\175\190\160\210\131\133\069\241\213\035\004\068\161\175\075\195\251\049\144\066" ..
		-- tex:"c933ce5661492df4afbea0d2838545f1"; x:528.559937; y:-203.686066; z:72.097626
		"\113\082\133\154\185\209\062\204\063\069\126\130\016\017\187\135\064\091\170\067\015\005\131\195\149\034\165\066" ..
		-- tex:"7152859ab9d13ecc3f457e821011bb87"; x:340.712921; y:-262.039551; z:82.567551
		"\173\038\213\074\067\216\164\066\004\233\089\093\000\184\207\224\186\190\151\067\021\164\082\195\098\063\167\066",
		-- tex:"ad26d54a43d8a44204e9595d00b8cfe0"; x:303.490082; y:-210.640961; z:83.623802
	["The Eye"] = 
		"\117\168\166\042\245\121\045\051\075\022\199\206\020\204\028\069\118\135\035\196\047\002\112\065\022\080\049\195" ..
		-- tex:"75a8a62af5792d334b16c7ce14cc1c45"; x:-654.116638; y:15.000534; z:-177.312851
		"\159\040\199\157\021\134\018\041\093\126\161\255\238\165\251\255\118\135\035\196\220\255\112\195\022\080\049\195" ..
		-- tex:"9f28c79d158612295d7ea1ffeea5fbff"; x:-654.116638; y:-240.999466; z:-177.312851
		"\214\025\231\251\127\019\200\004\199\052\033\040\008\146\208\066\118\135\099\196\047\002\112\065\022\080\049\195" ..
		-- tex:"d619e7fb7f13c804c73421280892d042"; x:-910.116638; y:15.000534; z:-177.312851
		"\027\018\022\213\047\234\157\170\068\156\241\125\209\119\192\046\118\135\099\196\220\255\112\195\022\080\049\195" ..
		-- tex:"1b1216d52fea9daa449cf17dd177c02e"; x:-910.116638; y:-240.999466; z:-177.312851
		"\199\248\241\120\051\232\067\013\147\179\051\066\215\048\014\229\013\240\001\196\181\142\165\194\170\022\079\193" ..
		-- tex:"c7f8f17833e8430d93b33342d7300ee5"; x:-519.750854; y:-82.778732; z:-12.943034
		"\216\013\212\208\048\141\118\197\249\207\129\189\066\098\019\025\027\224\131\195\181\142\165\194\170\022\079\193" ..
		-- tex:"d80dd4d0308d76c5f9cf81bd42621319"; x:-263.750854; y:-82.778732; z:-12.943034
		"\042\183\168\191\067\145\196\232\110\187\116\180\096\211\248\234\255\006\248\192\181\142\165\194\170\022\079\193" ..
		-- tex:"2ab7a8bf4391c4e86ebb74b460d3f8ea"; x:-7.750854; y:-82.778732; z:-12.943034
		"\042\136\014\027\182\193\235\033\095\005\067\163\096\164\113\166\016\082\139\196\079\109\060\068\047\071\231\065" ..
		-- tex:"2a880e1bb6c1eb215f0543a360a471a6"; x:-1114.564575; y:753.707977; z:28.909760
		"\111\234\162\092\020\089\206\055\236\106\009\046\066\081\215\214\033\164\086\196\158\218\248\067\047\071\231\065" ..
		-- tex:"6feaa25c1459ce37ec6a092e4251d7d6"; x:-858.564575; y:497.707977; z:28.909760
		"\109\128\137\178\221\077\064\255\143\095\227\195\014\037\093\083\033\164\086\196\079\109\060\068\047\071\231\065" ..
		-- tex:"6d8089b2dd4d40ff8f5fe3c30e255d53"; x:-858.564575; y:753.707977; z:28.909760
		"\235\183\231\007\186\211\039\137\088\157\227\069\139\017\156\046\016\082\139\196\158\218\248\067\047\071\231\065" ..
		-- tex:"ebb7e707bad32789589de3458b119c2e"; x:-1114.564575; y:497.707977; z:28.909760
		"\028\135\110\096\089\063\121\031\250\223\222\151\119\227\247\145\045\055\140\196\010\187\055\196\165\077\232\065" ..
		-- tex:"1c876e60593f791ffadfde9777e3f791"; x:-1121.724365; y:-734.922546; z:29.037914
		"\227\132\224\121\189\013\030\208\215\188\215\186\240\029\033\162\045\055\140\196\010\187\119\196\165\077\232\065" ..
		-- tex:"e384e079bd0d1ed0d7bcd7baf01d21a2"; x:-1121.724365; y:-990.922546; z:29.037914
		"\019\153\108\034\135\235\012\012\066\255\242\084\203\230\040\110\091\110\088\196\010\187\119\196\165\077\232\065" ..
		-- tex:"13996c2287eb0c0c42fff254cbe6286e"; x:-865.724365; y:-990.922546; z:29.037914
		"\113\105\104\194\069\048\006\147\110\129\180\163\153\116\138\016\091\110\088\196\010\187\055\196\165\077\232\065" ..
		-- tex:"716968c2453006936e81b4a399748a10"; x:-865.724365; y:-734.922546; z:29.037914
		"\084\243\115\219\128\145\211\084\247\180\198\126\020\242\222\120\052\239\137\196\069\173\174\067\162\166\000\066" ..
		-- tex:"54f373db8091d354f7b4c67e14f2de78"; x:-1103.475220; y:349.353699; z:32.162731
		"\167\013\050\059\143\226\071\206\152\189\219\034\092\199\176\160\105\222\083\196\023\181\186\066\162\166\000\066" ..
		-- tex:"a70d323b8fe247ce98bddb225cc7b0a0"; x:-847.475220; y:93.353699; z:32.162731
		"\155\147\071\252\148\236\207\145\199\205\038\183\253\100\050\102\052\239\137\196\023\181\186\066\162\166\000\066" ..
		-- tex:"9b9347fc94eccf91c7cd26b7fd643266"; x:-1103.475220; y:93.353699; z:32.162731
		"\208\024\032\047\004\090\155\128\228\064\037\197\059\081\108\015\049\239\137\196\181\241\155\195\173\166\000\066" ..
		-- tex:"d018202f045a9b80e44025c53b516c0f"; x:-1103.474854; y:-311.888367; z:32.162773
		"\132\101\028\161\098\107\246\214\205\006\083\254\111\189\046\157\049\239\137\196\218\248\013\196\173\166\000\066" ..
		-- tex:"84651ca1626bf6d6cd0653fe6fbd2e9d"; x:-1103.474854; y:-567.888367; z:32.162773
		"\081\158\103\038\092\099\165\202\233\077\190\000\015\153\035\224\099\222\083\196\181\241\155\195\173\166\000\066" ..
		-- tex:"519e67265c63a5cae94dbe000f9923e0"; x:-847.474854; y:-311.888367; z:32.162773
		"\098\201\097\013\003\010\111\080\218\173\076\204\118\024\169\246\164\110\170\196\154\036\169\066\166\227\085\066" ..
		-- tex:"62c9610d030a6f50daad4ccc7618a9f6"; x:-1363.457642; y:84.571495; z:53.472317
		"\216\224\068\154\247\012\071\079\083\008\139\050\011\018\253\084\164\110\138\196\154\036\169\066\166\227\085\066" ..
		-- tex:"d8e0449af70c474f53088b320b12fd54"; x:-1107.457642; y:84.571495; z:53.472317
		"\031\043\231\133\005\115\009\131\162\066\225\115\203\061\045\032\161\110\170\196\059\031\156\195\176\227\085\066" ..
		-- tex:"1f2be78505730983a242e173cb3d2d20"; x:-1363.457275; y:-312.244019; z:53.472355
		"\168\204\233\125\085\148\023\214\209\010\008\144\144\100\143\249\161\110\138\196\059\031\156\195\176\227\085\066" ..
		-- tex:"a8cce97d559417d6d10a089090648ff9"; x:-1107.457275; y:-312.244019; z:53.472355
		"\053\236\142\213\047\132\053\081\048\168\244\016\094\083\111\180\109\190\187\196\046\105\036\195\017\134\182\066" ..
		-- tex:"35ec8ed52f84355130a8f4105e536fb4"; x:-1501.950928; y:-164.410873; z:91.261856
		"\144\146\207\241\037\052\242\027\052\226\029\145\065\221\131\014\109\190\187\196\161\045\183\066\017\134\182\066" ..
		-- tex:"9092cff12534f21b34e21d9141dd830e"; x:-1501.950928; y:91.589127; z:91.261856
		"\196\024\154\144\189\095\237\078\152\157\170\187\067\240\041\195\109\190\219\196\046\105\036\195\017\134\182\066" ..
		-- tex:"c4189a90bd5fed4e989daabb43f029c3"; x:-1757.950928; y:-164.410873; z:91.261856
		"\121\115\198\170\017\108\039\253\108\188\136\141\101\073\140\233\109\190\219\196\161\045\183\066\017\134\182\066" ..
		-- tex:"7973c6aa116c27fd6cbc888d65498ce9"; x:-1757.950928; y:91.589127; z:91.261856
		"\084\022\134\160\074\197\085\057\114\206\069\209\200\245\205\127\109\190\155\196\046\105\036\195\017\134\182\066",
		-- tex:"541686a04ac5553972ce45d1c8f5cd7f"; x:-1245.950928; y:-164.410873; z:91.261856
	["The Mechanar"] = 
		"\173\044\079\137\202\191\049\167\205\158\029\021\188\220\110\219\189\123\011\196\247\043\083\195\018\019\066\194" ..
		-- tex:"ad2c4f89cabf31a7cd9e1d15bcdc6edb"; x:-557.933472; y:-211.171753; z:-48.518627
		"\158\137\112\075\116\024\074\118\255\030\047\062\098\124\074\171\123\247\150\195\247\043\083\195\018\019\066\194" ..
		-- tex:"9e89704b74184a76ff1e2f3e627c4aab"; x:-301.933472; y:-211.171753; z:-48.518627
		"\082\173\133\222\035\147\016\052\047\036\045\089\117\048\147\130\189\123\011\196\003\106\150\067\018\019\066\194" ..
		-- tex:"52ad85de239310342f242d5975309382"; x:-557.933472; y:300.828247; z:-48.518627
		"\181\148\112\170\103\242\138\019\071\007\215\006\214\114\041\084\189\123\011\196\031\080\051\066\018\019\066\194" ..
		-- tex:"b59470aa67f28a134707d706d6722954"; x:-557.933472; y:44.828247; z:-48.518627
		"\182\246\010\120\024\057\179\008\068\045\214\094\252\037\074\146\123\247\150\195\031\080\051\066\018\019\066\194" ..
		-- tex:"b6f60a781839b308442dd65efc254a92"; x:-301.933472; y:44.828247; z:-48.518627
		"\171\173\017\182\064\005\203\183\160\026\020\059\044\203\212\074\123\247\150\195\003\106\150\067\018\019\066\194" ..
		-- tex:"abad11b64005cbb7a01a143b2ccbd44a"; x:-301.933472; y:300.828247; z:-48.518627
		"\012\093\214\062\091\018\089\191\095\120\100\175\169\227\173\233\151\081\194\195\144\154\205\195\190\244\059\194" ..
		-- tex:"0c5dd63e5b1259bf5f7864afa9e3ade9"; x:-388.637451; y:-411.207550; z:-46.989010
		"\050\147\216\240\100\098\250\101\080\029\177\178\165\048\233\187\052\223\134\066\060\189\136\194\019\000\048\193" ..
		-- tex:"3293d8f06462fa65501db1b2a530e9bb"; x:67.435951; y:-68.369606; z:-11.000019
		"\123\113\061\066\222\077\024\188\049\007\203\234\183\145\248\135\246\092\224\194\173\039\179\194\082\098\015\193" ..
		-- tex:"7b713d42de4d18bc3107cbeab791f887"; x:-112.181572; y:-89.577499; z:-8.961505
		"\081\128\176\090\164\152\175\014\044\252\000\174\207\029\115\033\136\205\004\196\005\064\239\194\198\107\112\192" ..
		-- tex:"5180b05aa498af0e2cfc00aecf1d7321"; x:-531.211487; y:-119.625046; z:-3.756578
		"\239\150\022\122\190\001\151\075\070\018\012\026\050\166\065\069\174\234\158\194\059\074\012\195\084\149\099\189" ..
		-- tex:"ef96167abe01974b46120c1a32a64145"; x:-79.458366; y:-140.289978; z:-0.055562
		"\244\216\156\103\250\162\124\174\220\102\042\208\131\253\099\158\163\234\158\194\202\085\163\066\198\145\099\189" ..
		-- tex:"f4d89c67faa27caedc662ad083fd639e"; x:-79.458282; y:81.667564; z:-0.055559
		"\130\015\239\161\252\193\253\227\254\142\053\229\147\044\175\003\046\253\195\194\254\215\000\195\255\135\138\062" ..
		-- tex:"820fefa1fcc1fde3fe8e35e5932caf03"; x:-97.994499; y:-128.843735; z:0.270569
		"\050\061\234\107\023\142\255\061\168\132\072\085\149\154\108\040\109\253\195\194\001\095\206\066\011\136\138\062" ..
		-- tex:"323dea6b178eff3da8844855959a6c28"; x:-97.994980; y:103.185562; z:0.270569
		"\005\254\062\016\219\082\246\077\061\228\083\100\144\248\020\220\058\254\046\196\255\219\131\066\158\045\066\065" ..
		-- tex:"05fe3e10db52f64d3de4536490f814dc"; x:-699.972351; y:65.929688; z:12.136138
		"\010\078\112\184\040\220\202\232\152\188\043\013\008\083\170\204\058\254\046\196\255\017\062\195\158\045\066\065" ..
		-- tex:"0a4e70b828dccae898bc2b0d0853aacc"; x:-699.972351; y:-190.070313; z:12.136138
		"\115\025\106\252\014\203\048\025\217\039\204\073\045\080\191\075\141\123\028\195\037\196\183\195\043\037\047\066" ..
		-- tex:"73196afc0ecb3019d927cc492d50bf4b"; x:-156.482635; y:-367.532410; z:43.786301
		"\072\125\167\126\079\208\039\170\141\156\000\016\047\171\019\073\038\175\005\196\134\122\206\065\165\103\082\066" ..
		-- tex:"487da77e4fd027aa8d9c00102fab1349"; x:-534.736755; y:25.809828; z:52.601219
		"\028\185\065\004\063\159\052\231\217\142\039\083\180\216\173\202\095\251\147\195\179\044\102\195\154\195\082\066" ..
		-- tex:"1cb941043f9f34e7d98e2753b4d8adca"; x:-295.963867; y:-230.174622; z:52.691021
		"\009\024\072\065\026\195\173\113\041\108\018\063\254\160\060\015\092\194\008\196\135\165\070\195\045\251\059\067" ..
		-- tex:"091848411ac3ad71296c123ffea03c0f"; x:-547.036926; y:-198.646606; z:187.981171
		"\182\120\201\007\214\137\007\131\208\210\168\054\113\069\168\177\185\132\145\195\059\173\156\067\045\251\059\067" ..
		-- tex:"b678c907d6890783d0d2a8367145a8b1"; x:-291.036926; y:313.353394; z:187.981171
		"\057\165\056\184\034\251\079\115\018\019\159\187\217\171\001\022\185\132\145\195\135\165\070\195\045\251\059\067" ..
		-- tex:"39a538b822fb4f7312139fbbd9ab0116"; x:-291.036926; y:-198.646606; z:187.981171
		"\177\018\050\208\109\141\129\022\115\232\076\069\079\004\060\124\092\194\008\196\059\173\156\067\045\251\059\067" ..
		-- tex:"b11232d06d8d811673e84c454f043c7c"; x:-547.036926; y:313.353394; z:187.981171
		"\216\145\078\140\170\212\189\010\027\034\247\189\015\182\230\047\092\194\008\196\223\105\101\066\045\251\059\067" ..
		-- tex:"d8914e8caad4bd0a1b22f7bd0fb6e62f"; x:-547.036926; y:57.353394; z:187.981171
		"\100\111\004\142\099\101\006\063\040\189\135\142\218\210\197\047\185\132\145\195\223\105\101\066\045\251\059\067",
		-- tex:"646f048e6365063f28bd878edad2c52f"; x:-291.036926; y:57.353394; z:187.981171
	["The Shattered Halls"] = 
		"\057\225\232\084\157\080\251\129\254\180\148\227\122\055\052\049\047\142\229\195\235\038\228\195\214\161\197\194" ..
		-- tex:"39e1e8549d50fb81feb494e37a373431"; x:-459.110840; y:-456.304077; z:-98.816093
		"\162\138\165\234\233\039\045\224\142\026\160\039\246\173\027\144\096\147\139\195\189\171\009\196\198\002\189\194" ..
		-- tex:"a28aa5eae9272de08e1aa027f6ad1b90"; x:-279.151398; y:-550.683472; z:-94.505424
		"\113\153\147\117\089\151\210\155\076\102\050\105\238\225\000\139\033\015\218\195\115\141\027\196\019\229\048\194" ..
		-- tex:"719993755997d29b4c663269eee1008b"; x:-436.118225; y:-622.210205; z:-44.223709
		"\000\037\057\100\241\024\063\224\172\035\128\022\151\121\089\156\151\200\164\195\108\100\244\065\178\128\004\194" ..
		-- tex:"00253964f1183fe0ac2380169779599c"; x:-329.567139; y:30.549036; z:-33.125683
		"\181\167\183\169\062\069\081\104\072\168\189\210\245\218\060\254\075\100\018\196\108\100\244\065\178\128\004\194" ..
		-- tex:"b5a7b7a93e45516848a8bdd2f5da3cfe"; x:-585.567139; y:30.549036; z:-33.125683
		"\130\244\050\052\242\127\231\146\085\086\212\025\149\238\140\118\075\100\018\196\070\070\143\067\178\128\004\194" ..
		-- tex:"82f43234f27fe7925556d41995ee8c76"; x:-585.567139; y:286.549036; z:-33.125683
		"\240\222\122\031\072\245\232\064\124\034\042\044\219\250\127\052\053\016\089\195\139\009\168\195\255\097\247\193" ..
		-- tex:"f0de7a1f48f5e8407c222a2cdbfa7f34"; x:-217.063324; y:-336.074585; z:-30.922852
		"\247\073\077\190\108\094\026\077\248\183\136\005\082\054\180\203\053\016\089\195\197\004\020\196\255\097\247\193" ..
		-- tex:"f7494dbe6c5e1a4df8b788055236b4cb"; x:-217.063324; y:-592.074585; z:-30.922852
		"\021\206\043\068\081\229\221\060\138\019\209\061\199\216\008\093\162\105\058\066\239\145\132\063\205\218\225\193" ..
		-- tex:"15ce2b4451e5dd3c8a13d13dc7d8085d"; x:46.603161; y:1.035704; z:-28.231838
		"\094\019\067\144\223\004\107\089\222\203\208\000\055\021\218\010\218\220\046\195\099\169\161\194\034\013\212\193" ..
		-- tex:"5e134390df046b59decbd0003715da0a"; x:-174.862717; y:-80.830841; z:-26.506414
		"\137\241\189\039\096\063\204\128\227\113\162\122\072\029\066\048\148\105\018\196\195\018\039\196\066\008\212\193" ..
		-- tex:"89f1bd27603fcc80e371a27a481d4230"; x:-585.649719; y:-668.293213; z:-26.504034
		"\230\197\191\014\209\124\216\109\017\164\063\165\254\200\222\185\099\181\096\196\203\116\149\195\154\240\186\193" ..
		-- tex:"e6c5bf0ed17cd86d11a43fa5fec8deb9"; x:-898.834229; y:-298.912476; z:-23.367483
		"\200\140\206\240\140\056\004\151\070\059\076\198\123\172\232\096\177\090\144\196\101\186\010\196\154\240\186\193" ..
		-- tex:"c88ccef08c380497463b4cc67bace860"; x:-1154.834229; y:-554.912476; z:-23.367483
		"\157\030\208\077\112\218\016\127\220\111\255\012\238\050\220\247\177\090\144\196\203\116\149\195\154\240\186\193" ..
		-- tex:"9d1ed04d70da107fdc6fff0cee32dcf7"; x:-1154.834229; y:-298.912476; z:-23.367483
		"\124\139\138\076\051\079\009\190\072\128\201\253\244\052\226\168\064\161\090\196\024\124\125\195\006\190\129\193" ..
		-- tex:"7c8b8a4c334f09be4880c9fdf434e2a8"; x:-874.519592; y:-253.484756; z:-16.217787
		"\211\138\134\136\073\043\051\101\231\223\045\189\052\076\202\110\064\161\090\196\191\249\032\064\006\190\129\193" ..
		-- tex:"d38a8688492b3365e7df2dbd344cca6e"; x:-874.519592; y:2.515244; z:-16.217787
		"\215\076\087\142\186\238\150\172\120\154\192\217\217\008\156\081\064\161\026\196\024\124\125\195\006\190\129\193" ..
		-- tex:"d74c578ebaee96ac789ac0d9d9089c51"; x:-618.519592; y:-253.484756; z:-16.217787
		"\251\067\082\174\074\020\051\165\252\180\015\038\243\154\178\103\064\161\026\196\191\249\032\064\006\190\129\193" ..
		-- tex:"fb4352ae4a1433a5fcb40f26f39ab267"; x:-618.519592; y:2.515244; z:-16.217787
		"\028\065\060\155\042\071\167\162\008\031\058\197\058\245\029\076\053\057\082\196\117\224\047\196\100\149\036\191" ..
		-- tex:"1c413c9b2a47a7a2081f3ac53af51d4c"; x:-840.893921; y:-703.507202; z:-0.642905
		"\238\195\001\217\008\189\049\244\177\012\096\211\099\110\186\043\154\028\137\196\117\224\047\196\100\149\036\191",
		-- tex:"eec301d908bd31f4b10c60d3636eba2b"; x:-1096.893921; y:-703.507202; z:-0.642905
	["The Slave Pens"] = 
		"\051\231\023\144\160\170\230\042\013\017\173\200\250\001\211\110\197\025\232\067\001\002\108\068\193\036\246\194" ..
		-- tex:"33e71790a0aae62a0d11adc8fa01d36e"; x:464.201355; y:944.031372; z:-123.071793
		"\164\252\254\224\200\060\071\037\206\005\065\011\029\093\244\163\207\049\063\194\001\002\108\068\193\036\246\194" ..
		-- tex:"a4fcfee0c83c4725ce05410b1d5df4a3"; x:-47.798645; y:944.031372; z:-123.071793
		"\188\018\070\084\140\188\082\172\059\187\082\059\247\112\180\179\207\049\063\194\000\001\150\068\193\036\246\194" ..
		-- tex:"bc1246548cbc52ac3bbb523bf770b4b3"; x:-47.798645; y:1200.031372; z:-123.071793
		"\240\026\236\112\254\201\161\254\086\163\082\120\239\187\249\254\207\049\063\194\001\002\044\068\193\036\246\194" ..
		-- tex:"f01aec70fec9a1fe56a35278efbbf9fe"; x:-47.798645; y:688.031372; z:-123.071793
		"\158\013\156\212\039\003\253\062\117\136\142\184\154\010\067\009\207\049\063\194\003\004\216\067\193\036\246\194" ..
		-- tex:"9e0d9cd42703fd3e75888eb89a0a4309"; x:-47.798645; y:432.031372; z:-123.071793
		"\041\200\051\117\103\231\203\018\017\129\181\166\153\065\208\106\207\049\063\194\007\008\048\067\193\036\246\194" ..
		-- tex:"29c8337567e7cb121181b5a69941d06a"; x:-47.798645; y:176.031372; z:-123.071793
		"\049\075\067\045\101\009\137\111\002\203\034\071\004\112\207\252\139\051\080\067\007\008\048\067\193\036\246\194" ..
		-- tex:"314b432d6509896f02cb22470470cffc"; x:208.201355; y:176.031372; z:-123.071793
		"\137\181\040\115\238\155\010\005\061\176\102\168\044\223\103\193\139\051\080\067\001\002\044\068\193\036\246\194" ..
		-- tex:"89b52873ee9b0a053db066a82cdf67c1"; x:208.201355; y:688.031372; z:-123.071793
		"\078\206\223\178\112\146\022\130\006\222\230\052\054\034\020\067\197\025\232\067\003\004\216\067\193\036\246\194" ..
		-- tex:"4ecedfb27092168206dee63436221443"; x:464.201355; y:432.031372; z:-123.071793
		"\171\064\129\000\011\161\242\059\138\219\193\160\154\055\225\185\139\051\080\067\003\004\216\067\193\036\246\194" ..
		-- tex:"ab4081000ba1f23b8adbc1a09a37e1b9"; x:208.201355; y:432.031372; z:-123.071793
		"\036\073\018\158\018\149\116\107\056\231\100\118\050\059\123\202\139\051\080\067\000\001\150\068\193\036\246\194" ..
		-- tex:"2449129e1295746b38e76476323b7bca"; x:208.201355; y:1200.031372; z:-123.071793
		"\105\039\007\006\173\253\095\019\058\169\181\234\178\159\005\205\139\051\080\067\001\002\108\068\193\036\246\194" ..
		-- tex:"69270706adfd5f133aa9b5eab29f05cd"; x:208.201355; y:944.031372; z:-123.071793
		"\115\224\088\215\168\129\052\080\238\215\198\191\131\082\226\055\197\025\232\067\001\002\044\068\193\036\246\194" ..
		-- tex:"73e058d7a8813450eed7c6bf8352e237"; x:464.201355; y:688.031372; z:-123.071793
		"\009\210\093\029\203\196\190\200\088\007\006\149\247\212\018\205\057\230\151\195\001\002\108\068\193\036\246\194" ..
		-- tex:"09d25d1dcbc4bec858070695f7d412cd"; x:-303.798645; y:944.031372; z:-123.071793
		"\010\140\191\229\229\173\125\034\093\116\193\125\176\119\064\076\057\230\151\195\003\004\216\067\193\036\246\194" ..
		-- tex:"0a8cbfe5e5ad7d225d74c17db077404c"; x:-303.798645; y:432.031372; z:-123.071793
		"\190\045\074\171\205\060\123\218\158\027\200\079\210\053\045\139\057\230\151\195\007\008\048\067\193\036\246\194" ..
		-- tex:"be2d4aabcd3c7bda9e1bc84fd2352d8b"; x:-303.798645; y:176.031372; z:-123.071793
		"\138\191\021\032\252\234\250\038\002\066\132\239\093\240\131\117\057\230\151\195\001\002\044\068\193\036\246\194" ..
		-- tex:"8abf1520fceafa26024284ef5df08375"; x:-303.798645; y:688.031372; z:-123.071793
		"\189\254\072\129\218\039\172\019\042\003\084\190\220\166\165\093\092\093\032\067\139\236\130\193\251\029\160\193" ..
		-- tex:"bdfe4881da27ac132a0354bedca6a55d"; x:160.364700; y:-16.365501; z:-20.014641
		"\143\249\203\060\077\171\015\152\138\053\064\254\013\136\200\220\007\167\088\194\190\033\050\067\187\237\130\193" ..
		-- tex:"8ff9cb3c4dab0f988a3540fe0d88c8dc"; x:-54.163116; y:178.131813; z:-16.366081
		"\151\004\045\200\255\032\064\000\212\082\220\073\221\171\030\098\224\020\155\195\190\033\050\067\187\237\130\193" ..
		-- tex:"97042dc8ff204000d452dc49ddab1e62"; x:-310.163116; y:178.131813; z:-16.366081
		"\060\131\129\242\237\151\218\208\244\204\085\212\053\161\184\003\007\167\088\194\130\188\155\194\187\237\130\193" ..
		-- tex:"3c8381f2ed97dad0f4cc55d435a1b803"; x:-54.163116; y:-77.868187; z:-16.366081
		"\207\217\140\112\103\095\167\153\250\230\186\252\245\012\060\096\224\020\155\195\130\188\155\194\187\237\130\193" ..
		-- tex:"cfd98c70675fa799fae6bafcf50c3c60"; x:-310.163116; y:-77.868187; z:-16.366081
		"\223\067\129\133\186\167\230\222\002\006\008\215\023\144\075\242\189\162\249\067\158\243\154\068\022\231\131\065" ..
		-- tex:"df438185baa7e6de020608d717904bf2"; x:499.271408; y:1239.613159; z:16.487837
		"\047\091\061\099\209\206\065\060\229\116\096\037\178\061\020\241\122\069\115\067\158\243\186\068\022\231\131\065" ..
		-- tex:"2f5b3d63d1ce413ce5746025b23d14f1"; x:243.271408; y:1495.613159; z:16.487837
		"\093\010\166\080\178\208\036\108\242\114\033\206\167\048\204\062\122\069\115\067\158\243\154\068\022\231\131\065" ..
		-- tex:"5d0aa650b2d0246cf27221cea730cc3e"; x:243.271408; y:1239.613159; z:16.487837
		"\071\211\077\150\074\078\044\122\239\146\194\251\166\149\241\065\251\015\254\066\006\009\166\068\038\252\081\066",
		-- tex:"47d34d964a4e2c7aef92c2fba695f141"; x:127.031219; y:1328.282104; z:52.496243
	["The Steamvault"] = 
		"\122\056\058\228\088\110\027\250\131\138\238\093\187\198\138\087\017\145\128\195\238\137\113\194\169\203\058\195" ..
		-- tex:"7a383ae4586e1bfa838aee5dbbc68a57"; x:-257.133362; y:-60.384701; z:-186.795563
		"\199\240\178\039\105\220\195\053\166\061\032\151\238\230\212\092\255\017\145\191\194\206\225\067\169\203\058\195" ..
		-- tex:"c7f0b22769dcc335a63d2097eee6d45c"; x:-1.133362; y:451.615299; z:-186.795563
		"\094\035\155\220\181\044\161\082\106\198\051\202\127\007\069\165\255\017\145\191\097\231\048\068\169\203\058\195" ..
		-- tex:"5e239bdcb52ca1526ac633ca7f0745a5"; x:-1.133362; y:707.615299; z:-186.795563
		"\031\033\089\221\203\157\092\085\177\029\199\152\200\212\134\176\219\221\126\067\194\206\225\067\169\203\058\195" ..
		-- tex:"1f2159ddcb9d5c55b11dc798c8d486b0"; x:254.866638; y:451.615299; z:-186.795563
		"\155\066\226\176\003\228\089\096\005\114\127\254\228\089\168\235\255\017\145\191\132\157\067\067\169\203\058\195" ..
		-- tex:"9b42e2b003e4596005727ffee459a8eb"; x:-1.133362; y:195.615299; z:-186.795563
		"\054\234\014\074\150\040\038\029\251\251\116\119\017\185\099\241\219\221\126\067\097\231\048\068\169\203\058\195" ..
		-- tex:"36ea0e4a9628261dfbfb747711b963f1"; x:254.866638; y:707.615299; z:-186.795563
		"\080\236\122\114\133\020\252\143\045\021\210\056\066\224\163\250\017\145\128\195\097\231\048\068\169\203\058\195" ..
		-- tex:"50ec7a728514fc8f2d15d23842e0a3fa"; x:-257.133362; y:707.615299; z:-186.795563
		"\215\183\017\130\068\073\081\062\036\115\157\050\021\113\052\039\017\145\128\195\132\157\067\067\169\203\058\195" ..
		-- tex:"d7b711824449513e24739d3215713427"; x:-257.133362; y:195.615299; z:-186.795563
		"\068\075\174\002\217\051\070\070\207\169\028\158\168\207\247\192\255\017\145\191\238\137\113\194\169\203\058\195" ..
		-- tex:"444bae02d9334646cfa91c9ea8cff7c0"; x:-1.133362; y:-60.384701; z:-186.795563
		"\063\062\135\092\057\059\063\224\034\017\201\164\202\072\255\236\017\145\128\195\194\206\225\067\169\203\058\195" ..
		-- tex:"3f3e875c393b3fe02211c9a4ca48ffec"; x:-257.133362; y:451.615299; z:-186.795563
		"\080\076\089\199\231\175\254\057\056\117\037\151\110\148\036\214\078\153\184\067\053\011\004\067\114\086\007\195" ..
		-- tex:"504c59c7e7affe39387525976e9424d6"; x:369.197723; y:132.043793; z:-135.337692
		"\031\099\172\243\102\109\128\217\005\038\044\056\225\117\226\031\078\153\184\067\154\005\194\067\114\086\007\195" ..
		-- tex:"1f63acf3666d80d905262c38e175e21f"; x:369.197723; y:388.043793; z:-135.337692
		"\036\176\127\001\120\193\020\219\171\194\129\217\119\036\253\217\167\076\028\068\053\011\004\067\114\086\007\195" ..
		-- tex:"24b07f0178c114dbabc281d97724fdd9"; x:625.197723; y:132.043793; z:-135.337692
		"\034\237\015\108\099\224\128\035\245\253\112\212\186\183\115\183\182\137\196\067\028\231\019\068\114\086\007\195" ..
		-- tex:"22ed0f6c63e08023f5fd70d4bab773b7"; x:393.075897; y:591.611145; z:-135.337692
		"\194\171\127\052\020\226\164\045\231\009\144\195\222\134\016\134\167\076\028\068\154\005\194\067\114\086\007\195" ..
		-- tex:"c2ab7f3414e2a42de70990c3de861086"; x:625.197723; y:388.043793; z:-135.337692
		"\040\154\180\107\049\230\188\113\161\158\090\077\242\043\245\202\004\039\127\067\102\247\094\068\014\025\044\194" ..
		-- tex:"289ab46b31e6bc71a19e5a4df22bf5ca"; x:255.152419; y:891.865662; z:-43.024471
		"\146\113\067\238\253\129\203\015\158\237\004\112\234\223\058\155\004\039\127\067\179\123\143\068\014\025\044\194" ..
		-- tex:"927143eefd81cb0f9eed0470eadf3a9b"; x:255.152419; y:1147.865662; z:-43.024471
		"\024\236\229\033\078\038\121\161\001\099\134\164\065\061\091\107\024\251\088\191\102\247\094\068\014\025\044\194" ..
		-- tex:"18ece5214e2679a1016386a4413d5b6b"; x:-0.847581; y:891.865662; z:-43.024471
		"\115\022\219\082\237\117\060\055\145\029\048\145\085\088\119\175\024\251\088\191\179\123\143\068\014\025\044\194" ..
		-- tex:"7316db52ed753c37911d3091555877af"; x:-0.847581; y:1147.865662; z:-43.024471
		"\184\240\160\036\248\073\048\124\072\164\154\034\226\017\124\224\067\234\139\067\152\159\220\067\235\196\125\193",
		-- tex:"b8f0a024f849307c48a49a22e2117ce0"; x:279.830200; y:441.246857; z:-15.860577
	["The Stockade"] = 
		"\106\032\103\218\204\162\218\072\229\156\014\072\086\148\118\253\074\015\123\195\229\110\238\194\070\183\142\194" ..
		-- tex:"6a2067dacca2da48e59c0e48569476fd"; x:-251.059738; y:-119.216599; z:-71.357964
		"\179\186\080\252\008\123\059\130\205\225\128\022\181\117\219\222\179\008\165\195\089\076\209\194\070\183\142\194" ..
		-- tex:"b3ba50fc087b3b82cde18016b575dbde"; x:-330.067993; y:-104.649124; z:-71.357964
		"\185\022\143\105\037\168\007\089\077\187\249\223\188\154\151\094\137\053\139\195\149\255\044\195\070\183\142\194" ..
		-- tex:"b9168f6925a807594dbbf9dfbc9a975e"; x:-278.418274; y:-172.998383; z:-71.357964
		"\042\195\205\055\094\224\147\012\014\140\140\164\052\237\143\161\129\045\118\195\049\021\110\066\070\183\142\194" ..
		-- tex:"2ac3cd375ee0930c0e8c8ca434ed8fa1"; x:-246.177765; y:59.520699; z:-71.357964
		"\064\123\109\144\081\144\080\084\118\115\071\019\175\095\037\246\022\044\159\195\228\145\234\066\070\183\142\194" ..
		-- tex:"407b6d905190505476734713af5f25f6"; x:-318.344452; y:117.284950; z:-71.357964
		"\239\001\060\105\083\124\181\164\144\169\089\217\231\123\021\053\177\023\163\195\054\200\142\066\070\183\142\194" ..
		-- tex:"ef013c69537cb5a490a959d9e77b1535"; x:-326.185120; y:71.391045; z:-71.357964
		"\196\042\022\152\026\146\024\206\109\134\153\189\111\179\227\138\005\003\112\195\057\224\198\066\069\183\142\194" ..
		-- tex:"c42a16981a9218ce6d8699bd6fb3e38a"; x:-240.011810; y:99.437943; z:-71.357956
		"\170\121\079\148\036\176\031\172\124\052\018\165\116\182\045\177\175\093\169\195\031\153\017\195\069\183\142\194" ..
		-- tex:"aa794f9424b01fac7c3412a574b62db1"; x:-338.731934; y:-145.598145; z:-71.357956
		"\014\192\052\006\228\072\067\228\190\007\114\127\137\123\060\245\104\164\117\195\226\215\048\067\143\222\140\194" ..
		-- tex:"0ec03406e44843e4be07727f897b3cf5"; x:-245.642227; y:176.843307; z:-70.434692
		"\107\150\227\088\222\137\234\104\070\218\161\048\129\101\073\083\199\211\170\195\013\179\122\195\143\222\140\194" ..
		-- tex:"6b96e358de89ea6846daa13081654953"; x:-341.654541; y:-250.699432; z:-70.434692
		"\047\192\108\110\118\137\223\208\225\169\098\082\102\128\162\092\071\148\149\195\094\040\061\195\058\137\139\194" ..
		-- tex:"2fc06c6e7689dfd0e1a962526680a25c"; x:-299.158447; y:-189.157700; z:-69.768028
		"\241\120\173\214\226\128\243\179\064\062\164\230\159\004\225\147\110\176\134\195\002\151\043\066\058\137\139\194" ..
		-- tex:"f178add6e280f3b3403ea4e69f04e193"; x:-269.378387; y:42.897472; z:-69.768028
		"\145\188\193\218\122\138\057\063\164\082\074\107\206\059\143\069\203\201\141\195\076\104\136\195\155\012\139\194" ..
		-- tex:"91bcc1da7a8a393fa4524a6bce3b8f45"; x:-283.576538; y:-272.814850; z:-69.524628
		"\149\153\198\021\223\208\007\168\047\225\224\077\169\156\192\019\141\226\181\195\057\210\151\195\155\012\139\194" ..
		-- tex:"9599c615dfd007a82fe1e04da99cc013"; x:-363.769958; y:-303.642395; z:-69.524628
		"\111\212\223\188\125\124\219\248\138\075\010\121\242\206\168\111\231\074\149\195\061\194\085\067\155\012\139\194" ..
		-- tex:"6fd4dfbc7d7cdbf88a4b0a79f2cea86f"; x:-298.585205; y:213.758759; z:-69.524628
		"\127\035\236\063\069\203\073\120\235\228\087\160\113\225\241\021\012\186\080\195\218\235\106\067\155\012\139\194" ..
		-- tex:"7f23ec3f45cb4978ebe457a071e1f115"; x:-208.726761; y:234.921310; z:-69.524628
		"\125\102\200\102\240\180\054\222\128\112\106\132\109\028\224\227\122\076\197\195\177\200\085\195\155\012\139\194" ..
		-- tex:"7d66c866f0b436de80706a846d1ce0e3"; x:-394.597504; y:-213.783966; z:-69.524628
		"\159\058\161\148\095\193\089\002\009\197\078\096\053\243\042\105\113\144\059\195\085\186\026\067\155\012\139\194" ..
		-- tex:"9f3aa1945fc1590209c54e6035f32a69"; x:-187.564240; y:154.727875; z:-69.524628
		"\137\230\228\245\154\037\115\182\090\151\156\167\037\005\008\087\222\236\145\195\035\247\055\194\247\122\110\194" ..
		-- tex:"89e6e4f59a2573b65a979ca725050857"; x:-291.850555; y:-45.991348; z:-59.620087
		"\234\198\022\201\057\025\113\065\060\020\219\049\140\047\174\064\025\160\058\195\111\079\029\065\226\195\090\194" ..
		-- tex:"eac616c9391971413c14db318c2fae40"; x:-186.625397; y:9.831894; z:-54.691296
		"\084\245\001\000\171\120\011\008\134\205\150\039\091\012\049\150\128\013\103\195\049\061\140\194\225\195\090\194" ..
		-- tex:"54f50100ab780b0886cd96275b0c3196"; x:-231.052750; y:-70.119522; z:-54.691292
		"\151\111\240\053\082\250\202\118\032\116\073\244\210\070\251\203\128\013\103\195\111\079\029\065\225\195\090\194" ..
		-- tex:"976ff03552faca76207449f4d246fbcb"; x:-231.052750; y:9.831894; z:-54.691292
		"\108\159\254\040\199\116\019\017\034\123\163\250\126\245\098\030\025\160\058\195\049\061\140\194\224\195\090\194" ..
		-- tex:"6c9ffe28c7741311227ba3fa7ef5621e"; x:-186.625397; y:-70.119522; z:-54.691288
		"\009\127\080\182\042\251\082\052\159\019\184\154\021\048\097\219\195\153\063\195\084\254\096\193\202\103\084\194" ..
		-- tex:"097f50b62afb52349f13b89a153061db"; x:-191.600647; y:-14.062093; z:-53.101360
		"\013\206\011\096\011\033\096\037\015\199\203\168\122\030\147\253\168\088\174\195\134\161\150\193\182\085\077\194" ..
		-- tex:"0dce0b600b2160250fc7cba87a1e93fd"; x:-348.692657; y:-18.828871; z:-51.333706
		"\180\251\032\021\001\024\060\160\012\214\046\224\233\200\043\091\225\011\240\194\178\105\139\194\105\012\051\194",
		-- tex:"b4fb201501183ca00cd62ee0e9c82b5b"; x:-120.023209; y:-69.706444; z:-44.762123
	["The Temple of Atal'Hakkar"] = 
		"\230\114\096\182\178\194\223\250\215\027\051\250\029\180\177\068\126\227\131\068\190\158\167\195\235\193\189\195" ..
		-- tex:"e67260b6b2c2dffad71b33fa1db4b144"; x:1055.109192; y:-335.240204; z:-379.515015
		"\031\180\183\005\173\121\121\161\239\096\015\014\057\073\220\098\252\198\071\068\190\158\167\195\235\193\189\195" ..
		-- tex:"1fb4b705ad7979a1ef600f0e3949dc62"; x:799.109192; y:-335.240204; z:-379.515015
		"\202\221\227\027\077\198\245\126\234\230\143\076\072\056\079\160\252\198\071\068\251\122\158\194\235\193\189\195" ..
		-- tex:"cadde31b4dc6f57eeae68f4c48384fa0"; x:799.109192; y:-79.240204; z:-379.515015
		"\139\236\212\116\161\212\203\098\154\004\249\171\181\096\214\173\184\175\041\068\107\125\091\195\007\046\173\195" ..
		-- tex:"8becd474a1d4cb629a04f9abb560d6ad"; x:678.745667; y:-219.489929; z:-346.359619
		"\143\224\079\236\062\038\097\122\162\085\097\074\075\184\179\100\059\235\010\068\208\132\136\195\223\007\173\195" ..
		-- tex:"8fe04fec3e26617aa255614a4bb8b364"; x:555.675537; y:-273.037628; z:-346.061523
		"\152\244\213\000\211\151\218\248\065\169\070\194\121\219\175\153\211\049\027\068\095\040\079\195\141\005\173\195" ..
		-- tex:"98f4d500d397daf841a946c279dbaf99"; x:620.778564; y:-207.157715; z:-346.043396
		"\089\022\048\077\133\012\076\062\104\075\078\029\053\197\165\100\103\146\014\068\057\096\166\195\043\254\172\195" ..
		-- tex:"5916304d850c4c3e684b4e1d35c5a564"; x:570.287598; y:-332.751770; z:-345.985718
		"\255\081\048\147\076\069\217\176\055\094\227\244\226\028\054\236\233\237\021\068\162\124\169\195\059\065\169\195" ..
		-- tex:"ff5130934c45d9b0375ee3f4e21c36ec"; x:599.717407; y:-338.973724; z:-338.509644
		"\021\004\146\249\097\152\223\069\048\208\216\004\099\047\053\104\251\213\014\068\153\177\163\195\047\199\161\195" ..
		-- tex:"150492f96198df4530d0d804632f3568"; x:571.343506; y:-327.387512; z:-323.556152
		"\136\152\056\064\244\016\230\084\076\176\084\213\190\039\227\035\075\227\059\068\093\127\187\195\249\080\149\195" ..
		-- tex:"88983840f410e6544cb054d5be27e323"; x:751.551514; y:-374.995056; z:-298.632629
		"\028\188\222\113\099\147\129\096\231\150\016\078\124\045\098\044\186\216\040\068\183\118\152\195\014\247\148\195" ..
		-- tex:"1cbcde7163938160e796104e7c2d622c"; x:675.386414; y:-304.927490; z:-297.930145
		"\121\001\201\028\209\068\220\085\083\063\126\237\060\095\188\027\095\037\051\068\048\150\149\195\224\234\148\195" ..
		-- tex:"7901c91cd144dc55533f7eed3c5fbc1b"; x:716.583984; y:-299.173370; z:-297.834991
		"\063\104\245\003\178\173\209\078\061\209\006\253\049\055\188\000\183\209\079\068\070\135\202\195\210\232\148\195" ..
		-- tex:"3f68f503b2add14e3dd106fd3137bc00"; x:831.276855; y:-405.056854; z:-297.818939
		"\042\148\237\135\040\246\100\243\058\091\093\187\246\084\106\054\059\203\059\068\028\158\205\194\204\228\148\195" ..
		-- tex:"2a94ed8728f664f33a5b5dbbf6546a36"; x:751.175537; y:-102.808815; z:-297.787506
		"\141\084\000\061\017\159\148\088\176\144\125\042\196\066\165\178\218\215\135\068\088\155\192\195\232\224\148\195" ..
		-- tex:"8d54003d119f9458b0907d2ac442a5b2"; x:1086.745483; y:-385.213654; z:-297.757111
		"\158\088\195\204\134\238\004\225\087\129\159\015\119\216\156\102\114\182\064\068\111\149\037\195\191\222\148\195" ..
		-- tex:"9e58c3cc86ee04e157819f0f77d89c66"; x:770.850769; y:-165.583740; z:-297.740234
		"\123\196\081\061\057\134\157\008\212\204\193\040\068\227\214\215\055\008\063\068\115\130\057\195\191\222\148\195" ..
		-- tex:"7bc4513d39869d08d4ccc12844e3d6d7"; x:764.128418; y:-185.509583; z:-297.740234
		"\111\137\249\214\254\060\230\043\091\105\140\103\103\218\228\230\137\076\050\068\247\248\109\194\150\222\148\195" ..
		-- tex:"6f89f9d6fe3ce62b5b698c6767dae4e6"; x:713.195923; y:-59.493134; z:-297.738983
		"\150\201\039\170\099\039\173\008\138\063\024\021\170\083\230\149\099\068\127\068\194\057\212\194\171\213\148\195" ..
		-- tex:"96c927aa6327ad088a3f1815aa53e695"; x:1021.068604; y:-106.112816; z:-297.669312
		"\120\223\233\034\052\070\154\048\160\124\015\045\083\043\040\020\244\033\136\068\115\130\147\195\043\213\148\195" ..
		-- tex:"78dfe92234469a30a07c0f2d532b2814"; x:1089.061157; y:-295.019165; z:-297.665405
		"\011\113\145\049\166\127\153\119\020\253\135\230\063\131\117\255\189\123\135\068\245\158\105\195\043\213\148\195" ..
		-- tex:"0b719131a67f997714fd87e63f8375ff"; x:1083.866943; y:-233.620941; z:-297.665405
		"\148\097\031\149\120\054\005\220\231\210\094\227\043\090\057\113\043\175\131\068\033\196\126\195\040\213\148\195" ..
		-- tex:"94611f95783605dce7d25ee32b5a3971"; x:1053.474121; y:-254.766144; z:-297.665314
		"\152\057\178\058\240\205\114\020\193\058\102\113\251\020\136\041\240\151\072\068\016\132\155\195\186\212\148\195" ..
		-- tex:"9839b23af0cd7214c13a6671fb148829"; x:802.374084; y:-311.031769; z:-297.661957
		"\220\212\132\166\016\084\145\207\107\088\189\042\248\177\108\125\023\186\075\068\146\013\168\195\184\212\148\195" ..
		-- tex:"dcd484a6105491cf6b58bd2af8b16c7d"; x:814.907715; y:-336.106049; z:-297.661896
		"\129\114\082\097\193\152\172\215\126\036\170\037\101\192\151\177\108\177\106\068\246\242\202\195\161\212\148\195" ..
		-- tex:"81725261c198acd77e24aa2565c097b1"; x:938.772278; y:-405.898163; z:-297.661194
		"\093\216\242\087\221\178\027\153\154\022\059\050\160\122\108\250\108\014\110\068\087\193\179\195\131\212\148\195" ..
		-- tex:"5dd8f257ddb21b999a163b32a07a6cfa"; x:952.225403; y:-359.510498; z:-297.660278
		"\156\135\052\088\225\190\084\184\069\116\081\040\224\144\093\059\040\181\115\068\162\146\176\195\129\212\148\195" ..
		-- tex:"9c873458e1be54b845745128e0905d3b"; x:974.830627; y:-353.145599; z:-297.660217
		"\148\180\081\107\189\201\222\244\254\153\127\044\027\176\221\159\017\006\127\068\031\075\163\194\128\212\148\195" ..
		-- tex:"94b4516bbdc9def4fe997f2c1bb0dd9f"; x:1020.094849; y:-81.646729; z:-297.660187
		"\124\128\012\056\212\192\218\013\158\083\040\001\093\130\084\063\003\253\104\068\130\041\010\194\127\212\148\195" ..
		-- tex:"7c800c38d4c0da0d9e5328015d82543f"; x:931.953369; y:-34.540539; z:-297.660156
		"\080\216\167\222\224\212\053\191\099\129\186\239\108\174\150\041\051\200\141\068\089\248\014\195\127\212\148\195" ..
		-- tex:"50d8a7dee0d435bf6381baef6cae9629"; x:1134.256348; y:-142.970123; z:-297.660156
		"\095\201\067\126\226\014\208\182\123\030\022\061\248\149\160\244\019\217\127\068\010\067\197\194\127\212\148\195" ..
		-- tex:"5fc9437ee20ed0b67b1e163df895a0f4"; x:1023.391846; y:-98.630943; z:-297.660156
		"\021\059\085\120\250\043\064\091\115\241\251\194\192\243\135\038\067\105\136\068\054\151\060\195\127\212\148\195" ..
		-- tex:"153b5578fa2b405b73f1fbc2c0f38726"; x:1091.289551; y:-188.590683; z:-297.660156
		"\102\249\121\241\206\021\221\211\188\181\239\230\238\010\234\017\215\197\078\068\064\250\016\194\126\212\148\195" ..
		-- tex:"66f979f1ce15ddd3bcb5efe6ee0aea11"; x:827.091309; y:-36.244389; z:-297.660126
		"\201\012\249\122\089\020\053\151\164\150\098\092\131\072\203\087\214\216\051\068\253\068\066\195\125\212\148\195" ..
		-- tex:"c90cf97a59143597a496625c8348cb57"; x:719.388123; y:-194.269501; z:-297.660095
		"\029\226\112\221\007\122\179\058\131\013\030\166\251\228\134\210\147\114\128\068\112\085\187\195\125\212\148\195" ..
		-- tex:"1de270dd077ab33a830d1ea6fbe486d2"; x:1027.580566; y:-374.667511; z:-297.660095
		"\195\250\049\047\027\199\104\133\186\116\243\151\007\139\048\104\030\017\094\068\166\210\142\194\191\197\148\195" ..
		-- tex:"c3fa312f1bc76885ba74f397078b3068"; x:888.267517; y:-71.411430; z:-297.544922
		"\096\039\096\027\068\124\073\019\015\120\140\002\108\246\030\096\172\202\048\068\168\145\164\195\221\194\148\195" ..
		-- tex:"6027601b447c49130f788c026cf61e60"; x:707.166809; y:-329.137970; z:-297.522400
		"\171\072\118\254\093\221\216\205\138\224\154\208\077\165\059\015\123\132\139\068\079\082\166\195\186\172\148\195" ..
		-- tex:"ab4876fe5dddd8cd8ae09ad04da53b0f"; x:1116.140137; y:-332.643066; z:-297.349457
		"\108\252\148\117\238\060\254\104\136\125\147\098\240\112\037\044\169\054\051\068\042\233\232\194\101\170\148\195" ..
		-- tex:"6cfc9475ee3cfe68887d9362f070252c"; x:716.854126; y:-116.455406; z:-297.331238
		"\091\238\088\045\198\232\183\182\058\251\079\016\083\015\205\077\061\017\086\068\182\006\083\194\153\160\148\195" ..
		-- tex:"5bee582dc6e8b7b63afb4f10530fcd4d"; x:856.269409; y:-52.756557; z:-297.254700
		"\135\056\223\059\129\109\052\080\031\109\045\077\195\039\126\089\186\252\136\068\157\025\189\194\077\160\148\195" ..
		-- tex:"8738df3b816d34501f6d2d4dc3277e59"; x:1095.897827; y:-94.550034; z:-297.252380
		"\166\212\152\138\135\067\179\031\176\089\236\098\001\235\228\233\237\024\020\068\235\131\169\195\010\022\143\195" ..
		-- tex:"a6d4988a8743b31fb059ec6201ebe4e9"; x:592.389526; y:-339.030640; z:-286.172211
		"\078\144\171\045\079\219\202\242\150\185\065\061\081\126\159\028\136\042\245\067\020\126\083\195\192\178\132\195" ..
		-- tex:"4e90ab2d4fdbcaf296b9413d517e9f1c"; x:490.332306; y:-211.492508; z:-265.396515
		"\247\241\029\077\203\196\120\156\127\001\073\154\151\139\096\097\164\074\060\068\114\111\182\195\056\053\132\195" ..
		-- tex:"f7f11d4dcbc4789c7f01499a978b6061"; x:753.166321; y:-364.870697; z:-264.415802
		"\202\132\049\008\164\168\182\223\174\042\157\231\043\205\054\075\150\209\061\068\170\132\159\195\051\231\131\195" ..
		-- tex:"ca843108a4a8b6dfae2a9de72bcd364b"; x:759.274841; y:-319.036469; z:-263.806274
		"\248\143\131\063\073\047\137\005\209\081\078\050\049\182\118\128\254\171\033\068\069\058\020\195\226\229\131\195" ..
		-- tex:"f88f833f492f8905d1514e3231b67680"; x:646.687439; y:-148.227631; z:-263.795990
		"\026\166\156\216\162\166\101\053\216\177\038\146\130\196\187\076\025\105\052\068\135\107\066\195\154\229\131\195" ..
		-- tex:"1aa69cd8a2a66535d8b1269282c4bb4c"; x:721.642212; y:-194.420044; z:-263.793793
		"\124\145\080\053\174\049\218\071\231\092\037\009\072\227\052\194\216\104\045\068\172\178\018\195\154\229\131\195" ..
		-- tex:"7c915035ae31da47e75c250948e334c2"; x:693.638245; y:-146.697952; z:-263.793793
		"\105\242\155\028\098\112\020\196\048\164\075\093\101\014\017\206\006\224\050\068\175\077\143\195\008\227\131\195" ..
		-- tex:"69f29b1c627014c430a44b5d650e11ce"; x:715.500427; y:-286.606934; z:-263.773712
		"\203\018\205\174\102\107\188\120\187\192\160\189\073\140\173\061\083\026\028\068\161\046\143\195\235\226\131\195" ..
		-- tex:"cb12cdae666bbc78bbc0a0bd498cad3d"; x:624.411377; y:-286.364319; z:-263.772827
		"\024\020\012\118\191\200\177\166\171\079\139\134\206\237\003\055\192\031\024\068\192\199\177\194\124\169\130\195" ..
		-- tex:"18140c76bfc8b1a6ab4f8b86ceed0337"; x:608.496155; y:-88.890144; z:-261.324127
		"\191\046\242\210\176\113\197\077\116\003\123\034\210\084\107\207\129\170\045\068\224\088\179\195\190\239\128\195" ..
		-- tex:"bf2ef2d2b071c54d74037b22d2546bcf"; x:694.664185; y:-358.694366; z:-257.873016
		"\033\235\034\008\203\075\149\029\218\228\188\195\214\082\231\068\146\122\143\068\124\160\164\195\154\217\128\195" ..
		-- tex:"21eb2208cb4b951ddae4bcc3d652e744"; x:1147.830444; y:-329.253815; z:-257.700043
		"\031\033\219\102\224\079\120\125\172\084\242\203\089\163\164\078\231\058\139\068\129\017\135\195\154\217\128\195" ..
		-- tex:"1f21db66e04f787dac54f2cb59a3a44e"; x:1113.840820; y:-270.136780; z:-257.700043
		"\173\236\090\157\177\248\145\205\210\122\255\123\071\146\198\032\121\064\043\068\147\065\242\194\070\215\128\195" ..
		-- tex:"adec5a9db1f891cdd27aff7b4792c620"; x:685.007446; y:-121.128082; z:-257.681854
		"\118\200\047\252\201\251\098\209\146\175\174\008\128\253\166\203\172\131\138\068\046\151\129\194\042\205\128\195" ..
		-- tex:"76c82ffcc9fb62d192afae0880fda6cb"; x:1108.114868; y:-64.795280; z:-257.602875
		"\138\116\235\000\158\076\250\255\087\091\069\150\114\126\195\145\204\096\134\068\238\212\145\194\042\205\128\195" ..
		-- tex:"8a74eb009e4cfaff575b4596727ec391"; x:1075.025024; y:-72.915886; z:-257.602875
		"\096\219\227\055\248\078\092\152\209\056\176\026\208\224\106\101\229\089\015\068\252\001\242\194\172\254\120\195" ..
		-- tex:"60dbe337f84e5c98d138b01ad0e06a65"; x:573.404663; y:-121.003883; z:-248.994827
		"\043\153\119\252\156\014\199\153\190\201\130\089\127\143\001\184\202\189\017\068\183\069\019\195\083\010\106\195" ..
		-- tex:"2b9977fc9c0ec799bec982597f8f01b8"; x:582.965515; y:-147.272339; z:-234.040344
		"\115\191\181\099\183\045\192\160\132\121\086\012\183\231\105\141\176\237\030\068\073\241\004\195\038\022\091\195" ..
		-- tex:"73bfb563b72dc0a08479560cb7e7698d"; x:635.713928; y:-132.942535; z:-219.086533
		"\212\130\224\076\094\013\157\218\178\061\058\208\066\243\041\177\210\019\040\068\063\238\169\195\236\053\090\195" ..
		-- tex:"d482e04c5e0d9ddab23d3ad042f329b1"; x:672.309753; y:-339.861328; z:-218.210648
		"\187\171\037\185\051\240\240\154\224\203\246\021\229\187\190\149\107\122\048\068\144\129\164\195\224\046\090\195" ..
		-- tex:"bbab25b933f0f09ae0cbf615e5bbbe95"; x:705.912842; y:-329.012238; z:-218.183121
		"\191\168\090\144\130\077\206\148\060\085\105\163\150\016\109\020\015\101\140\068\112\117\180\195\162\009\090\195" ..
		-- tex:"bfa85a90824dce943c5569a396106d14"; x:1123.158203; y:-360.917511; z:-218.037643
		"\209\029\226\060\015\128\105\232\009\026\002\133\212\244\251\246\038\175\042\068\037\020\106\194\249\004\090\195" ..
		-- tex:"d11de23c0f8069e8091a0285d4f4fbf6"; x:682.736755; y:-58.519676; z:-218.019440
		"\132\155\223\146\034\213\127\076\161\062\160\060\225\071\146\109\122\147\139\068\238\208\166\195\150\002\090\195" ..
		-- tex:"849bdf9222d57f4ca13ea03ce147926d"; x:1116.608765; y:-333.632294; z:-218.010117
		"\090\058\230\131\089\164\177\237\228\237\141\210\146\165\246\233\252\051\051\068\001\000\232\194\236\253\089\195" ..
		-- tex:"5a3ae68359a4b1ede4ed8dd292a5f6e9"; x:716.812317; y:-116.000015; z:-217.991898
		"\188\090\039\080\153\002\032\043\007\244\184\137\078\195\145\245\218\058\144\068\249\231\197\194\198\240\089\195" ..
		-- tex:"bc5a27509902202b07f4b8894ec391f5"; x:1153.839233; y:-98.953079; z:-217.940536
		"\214\110\129\189\218\121\239\102\158\129\084\173\222\102\073\099\093\010\137\068\062\228\191\194\194\233\089\195" ..
		-- tex:"d66e81bdda79ef669e8154adde664963"; x:1096.323975; y:-95.945793; z:-217.913132
		"\144\143\048\099\165\107\206\217\241\242\106\252\124\242\189\244\119\105\014\068\033\237\233\194\150\130\073\195" ..
		-- tex:"908f3063a56bced9f1f26afc7cf2bdf4"; x:569.647949; y:-116.963150; z:-201.510117
		"\109\055\097\071\015\236\228\093\139\244\176\241\108\100\005\143\129\114\061\068\059\101\212\194\240\113\071\195" ..
		-- tex:"6d3761470fece45d8bf4b0f16c64058f"; x:757.789185; y:-106.197723; z:-199.445084
		"\032\053\015\125\146\034\035\059\221\224\086\153\143\098\237\087\129\114\061\068\078\025\181\195\240\113\071\195" ..
		-- tex:"20350f7d9222233bdde056998f62ed57"; x:757.789185; y:-362.197723; z:-199.445084
		"\038\248\064\065\149\158\095\202\023\181\149\134\241\017\162\004\129\114\125\068\078\025\181\195\240\113\071\195" ..
		-- tex:"26f84041959e5fca17b59586f111a204"; x:1013.789185; y:-362.197723; z:-199.445084
		"\251\210\193\155\012\040\148\159\052\206\163\081\093\050\231\207\129\114\125\068\059\101\212\194\240\113\071\195" ..
		-- tex:"fbd2c19b0c28949f34cea3515d32e7cf"; x:1013.789185; y:-106.197723; z:-199.445084
		"\067\201\198\172\150\007\112\075\118\210\001\151\127\229\100\235\084\153\057\068\015\150\144\194\029\065\060\195" ..
		-- tex:"43c9c6ac9607704b76d201977fe564eb"; x:742.395813; y:-72.293091; z:-188.254364
		"\107\163\119\097\185\156\087\153\118\174\085\020\128\142\057\094\132\149\010\068\018\137\078\195\210\071\055\195" ..
		-- tex:"6ba37761b99c579976ae5514808e395e"; x:554.336243; y:-206.535446; z:-183.280563
		"\097\105\087\091\215\004\033\048\010\136\153\084\085\171\139\149\084\042\026\068\143\231\088\195\062\000\055\195" ..
		-- tex:"6169575bd70421300a88995455ab8b95"; x:616.661438; y:-216.904541; z:-183.000961
		"\075\210\156\099\221\171\127\230\115\248\228\222\002\188\193\185\067\033\153\068\214\121\147\194\213\135\054\195" ..
		-- tex:"4bd29c63ddab7fe673f8e4de02bcc1b9"; x:1225.039551; y:-73.737968; z:-182.530609
		"\053\052\204\160\177\164\112\245\216\179\236\053\249\130\135\115\024\246\075\068\080\012\034\196\243\131\054\195" ..
		-- tex:"3534cca0b1a470f5d8b3ec35f9828773"; x:815.845276; y:-648.192444; z:-182.515442
		"\133\157\053\109\157\225\239\204\083\108\191\161\066\250\054\098\189\144\080\068\229\112\150\066\233\131\054\195" ..
		-- tex:"859d356d9de1efcc536cbfa142fa3662"; x:834.261597; y:75.220505; z:-182.515289
		"\187\210\080\068\221\202\187\202\187\156\213\050\195\205\056\017\026\182\116\068\139\182\242\195\155\225\053\195" ..
		-- tex:"bbd25044ddcabbcabb9cd532c3cd3811"; x:978.845398; y:-485.426147; z:-181.881287
		"\133\219\106\140\038\020\086\155\024\037\062\055\142\192\195\203\095\191\136\068\252\051\105\195\220\215\053\195" ..
		-- tex:"85db6a8c2614569b18253e378ec0c3cb"; x:1093.980469; y:-233.203079; z:-181.843216
		"\183\069\240\079\204\170\039\157\216\033\123\177\215\061\121\125\168\015\057\068\102\190\242\195\165\215\053\195" ..
		-- tex:"b745f04fccaa279dd8217bb1d73d797d"; x:740.244690; y:-485.487518; z:-181.842377
		"\011\017\184\190\248\245\240\243\189\004\157\027\084\164\183\208\101\171\116\068\110\139\143\194\251\210\053\195" ..
		-- tex:"0b11b8bef8f5f0f3bd049d1b54a4b7d0"; x:978.678101; y:-71.772331; z:-181.824158
		"\167\216\180\102\229\159\034\047\137\134\008\251\039\201\200\238\210\130\131\068\002\070\132\066\089\210\053\195" ..
		-- tex:"a7d8b466e59f222f898608fb27c9c8ee"; x:1052.088257; y:66.136742; z:-181.821686
		"\095\013\105\092\091\234\069\109\041\016\190\247\245\025\010\165\213\000\051\068\128\020\024\196\085\210\053\195" ..
		-- tex:"5f0d695c5bea456d2910bef7f5190aa5"; x:716.013062; y:-608.320374; z:-181.821625
		"\191\231\045\001\223\194\020\192\191\066\131\195\249\005\007\199\127\135\131\068\128\020\024\196\084\210\053\195" ..
		-- tex:"bfe72d01dfc214c0bf4283c3f90507c7"; x:1052.234375; y:-608.320374; z:-181.821609
		"\100\038\070\249\130\066\211\111\059\165\242\057\210\017\069\127\078\120\156\068\052\103\152\195\084\210\053\195" ..
		-- tex:"642646f98242d36f3ba5f239d211457f"; x:1251.759644; y:-304.806305; z:-181.821609
		"\190\155\063\018\070\248\237\130\117\209\002\024\036\175\030\135\134\073\060\068\173\113\181\195\076\138\050\195" ..
		-- tex:"be9b3f1246f8ed8275d1021824af1e87"; x:753.148865; y:-362.888123; z:-178.540237
		"\123\194\036\085\191\007\190\037\051\086\006\152\235\037\096\103\203\188\045\068\184\094\179\195\076\138\050\195" ..
		-- tex:"7bc22455bf07be2533560698eb256067"; x:694.949951; y:-358.740021; z:-178.540237
		"\064\113\025\026\043\235\179\168\155\230\074\101\144\096\179\249\085\118\143\068\188\110\164\195\005\094\050\195" ..
		-- tex:"4071191a2bebb3a89be64a659060b3f9"; x:1147.697998; y:-328.865143; z:-178.367279
		"\000\086\048\111\177\246\035\145\143\229\078\027\146\155\145\072\229\060\139\068\008\076\135\195\004\094\050\195" ..
		-- tex:"0056306fb1f623918fe54e1b929b9148"; x:1113.903076; y:-270.594025; z:-178.367264
		"\004\104\113\191\002\254\021\069\149\048\070\146\248\034\207\115\129\073\043\068\008\063\242\194\090\089\050\195" ..
		-- tex:"046871bf02fe154595304692f822cf73"; x:685.148560; y:-121.123116; z:-178.349045
		"\248\055\088\226\019\081\251\087\153\201\038\097\063\069\130\234\250\104\045\068\125\170\019\195\090\089\050\195" ..
		-- tex:"f83758e21351fb5799c926613f4582ea"; x:693.640320; y:-147.665985; z:-178.349045
		"\084\098\092\115\242\031\183\140\231\018\189\201\254\015\143\059\220\137\138\068\251\210\128\194\040\069\050\195" ..
		-- tex:"54625c73f21fb78ce712bdc9fe0f8f3b"; x:1108.308228; y:-64.412079; z:-178.270157
		"\061\132\081\156\235\019\035\224\237\209\103\205\179\106\104\106\108\110\134\068\062\048\146\194\031\069\050\195" ..
		-- tex:"3d84519ceb1323e0edd167cdb36a686a"; x:1075.450806; y:-73.094231; z:-178.270020
		"\125\076\079\247\138\053\167\252\018\220\187\084\064\128\067\180\102\028\040\068\037\044\135\195\111\190\012\195" ..
		-- tex:"7d4c4ff78a35a7fc12dcbb54408043b4"; x:672.443787; y:-270.344910; z:-140.743896
		"\202\123\048\164\114\120\054\210\048\106\117\074\228\233\037\101\072\054\133\068\038\221\192\195\039\146\012\195" ..
		-- tex:"ca7b30a4727836d2306a754ae4e92565"; x:1065.696411; y:-385.727753; z:-140.570923
		"\182\218\074\003\052\179\126\119\094\170\234\207\135\101\038\112\008\060\057\068\216\124\244\193\133\141\012\195" ..
		-- tex:"b6da4a0334b37e775eaaeacf87652670"; x:740.938049; y:-30.560961; z:-140.552826
		"\101\231\194\201\202\121\225\154\155\054\248\014\229\137\111\006\021\166\143\068\162\185\036\195\075\121\012\195" ..
		-- tex:"65e7c2c9ca79e19a9b36f80ee5896f06"; x:1149.190186; y:-164.725143; z:-140.473816
		"\003\105\146\130\193\008\151\070\146\011\027\091\099\218\211\104\189\042\045\068\099\021\153\195\004\008\011\195" ..
		-- tex:"03699282c1089746920b1b5b63dad368"; x:692.667847; y:-306.167114; z:-139.031326
		"\211\037\130\171\037\249\085\072\188\195\213\104\192\178\099\023\027\087\032\068\022\236\172\195\004\008\011\195" ..
		-- tex:"d32582ab25f95548bcc3d568c0b26317"; x:641.361084; y:-345.844452; z:-139.031326
		"\128\056\035\049\011\021\202\033\069\047\133\130\048\231\238\138\088\112\049\068\208\157\137\195\002\008\011\195" ..
		-- tex:"803823310b15ca21452f858230e7ee8a"; x:709.755432; y:-275.232941; z:-139.031296
		"\105\075\157\095\243\011\166\044\154\002\255\042\104\234\039\071\111\035\140\068\119\214\201\195\189\219\010\195" ..
		-- tex:"694b9d5ff30ba62c9a02ff2a68ea2747"; x:1121.107422; y:-403.675537; z:-138.858368
		"\191\090\152\051\127\061\135\206\076\097\200\230\111\208\215\052\048\108\131\068\166\028\175\195\186\219\010\195" ..
		-- tex:"bf5a98337f3d87ce4c61c8e66fd0d734"; x:1051.380981; y:-350.223846; z:-138.858322
		"\040\229\147\149\047\190\109\213\224\197\191\220\198\076\250\003\129\045\137\068\032\109\176\195\186\219\010\195" ..
		-- tex:"28e593952fbe6dd5e0c5bfdcc64cfa03"; x:1097.422119; y:-352.852570; z:-138.858322
		"\147\042\018\253\022\012\107\135\075\081\046\188\112\053\028\243\246\150\038\068\017\052\104\194\021\215\010\195" ..
		-- tex:"932a12fd160c6b874b512ebc70351cf3"; x:666.358826; y:-58.050850; z:-138.840179
		"\065\174\060\108\045\008\118\232\062\180\025\218\244\183\051\103\136\055\051\068\185\093\157\194\021\215\010\195" ..
		-- tex:"41ae3c6c2d0876e83eb419daf4b73367"; x:716.867737; y:-78.683060; z:-138.840179
		"\191\103\222\242\075\186\107\161\124\145\085\160\106\016\052\177\180\245\059\068\118\039\183\194\018\215\010\195" ..
		-- tex:"bf67def24bba6ba17c9155a06a1034b1"; x:751.839172; y:-91.577080; z:-138.840134
		"\004\172\024\119\252\133\109\129\133\172\100\225\159\065\060\182\241\227\145\068\227\147\252\194\224\194\010\195" ..
		-- tex:"04ac1877fc856d8185ac64e19f413cb6"; x:1167.123291; y:-126.288849; z:-138.761246
		"\234\014\056\176\164\118\207\124\105\150\251\007\203\211\237\208\253\041\140\068\061\111\220\194\223\194\010\195" ..
		-- tex:"ea0e38b0a476cf7c6996fb07cbd3edd0"; x:1121.312256; y:-110.217270; z:-138.761230
		"\139\084\004\048\122\103\070\239\172\130\000\045\080\239\224\096\215\225\134\068\032\026\017\195\221\194\010\195" ..
		-- tex:"8b5404307a6746efac82002d50efe060"; x:1079.057617; y:-145.102066; z:-138.761200
		"\251\080\240\161\142\166\152\162\199\009\052\136\079\205\200\252\221\060\059\068\228\223\186\195\118\087\004\195" ..
		-- tex:"fb50f0a18ea698a2c70934884fcdc8fc"; x:748.951050; y:-373.749176; z:-132.341660
		"\158\096\231\169\078\136\130\052\000\230\229\235\216\094\209\142\159\199\113\068\039\101\125\194\211\084\004\195" ..
		-- tex:"9e60e7a94e88823400e6e5ebd85ed18e"; x:967.119141; y:-63.348785; z:-132.331360
		"\190\063\248\046\192\198\000\010\090\239\052\249\041\008\045\024\212\023\095\068\064\252\178\195\133\193\002\195" ..
		-- tex:"be3ff82ec0c6000a5aef34f929082d18"; x:892.372375; y:-357.970734; z:-130.755951
		"\154\169\141\237\039\066\124\017\038\013\028\235\140\066\003\100\245\072\110\068\113\047\027\194\223\190\002\195" ..
		-- tex:"9aa98ded27427c11260d1ceb8c420364"; x:953.140015; y:-38.796333; z:-130.745605
		"\168\028\044\138\242\014\019\247\175\195\252\026\181\185\098\069\175\072\127\068\116\014\187\195\050\126\216\194" ..
		-- tex:"a81c2c8af20e13f7afc3fc1ab5b96245"; x:1021.135742; y:-374.112946; z:-108.246483
		"\164\078\141\209\206\064\086\048\103\231\188\048\082\255\057\068\030\211\049\068\123\010\147\195\135\091\216\194" ..
		-- tex:"a44e8dd1ce40563067e7bc3052ff3944"; x:711.298767; y:-294.081909; z:-108.178772
		"\129\045\222\010\040\062\176\188\134\013\172\135\130\005\141\204\168\193\124\068\139\097\133\194\168\043\216\194" ..
		-- tex:"812dde0a283eb0bc860dac8782058dcc"; x:1011.025940; y:-66.690521; z:-108.085274
		"\134\052\105\233\116\002\078\225\054\024\250\094\048\238\026\137\199\081\059\068\182\104\195\194\068\034\216\194" ..
		-- tex:"863469e974024ee13618fa5e30ee1a89"; x:749.277832; y:-97.704521; z:-108.066933
		"\165\002\017\022\094\209\034\004\045\206\178\088\228\240\251\016\234\044\136\068\155\086\065\195\135\229\215\194" ..
		-- tex:"a50211165ed122042dceb258e4f0fb10"; x:1089.403687; y:-193.338318; z:-107.948303
		"\211\041\212\247\167\177\249\147\050\075\193\055\094\173\065\110\186\034\128\068\194\203\203\194\135\229\215\194" ..
		-- tex:"d329d4f7a7b1f993324bc1375ead416e"; x:1025.085327; y:-101.897972; z:-107.948303
		"\170\217\043\039\242\183\117\114\021\124\026\059\244\041\204\206\197\050\078\068\188\011\203\195\128\229\215\194" ..
		-- tex:"aad92b27f2b77572157c1a3bf429ccce"; x:824.793335; y:-406.091705; z:-107.948250
		"\195\254\083\145\236\183\018\133\223\090\144\227\077\221\220\071\159\030\136\068\170\025\149\195\127\229\215\194" ..
		-- tex:"c3fe5391ecb71285df5a90e34ddddc47"; x:1088.957031; y:-298.200531; z:-107.948242
		"\015\203\184\021\089\138\161\227\087\022\098\192\082\027\078\027\078\059\079\068\096\050\006\194\127\229\215\194" ..
		-- tex:"0fcbb815598aa1e3571662c0521b4e1b"; x:828.926697; y:-33.549198; z:-107.948242
		"\135\220\214\197\006\011\247\234\062\189\225\047\105\195\219\024\078\107\104\068\074\001\202\195\127\229\215\194" ..
		-- tex:"87dcd6c5060bf7ea3ebde12f69c3db18"; x:929.676697; y:-404.010101; z:-107.948242
		"\011\160\237\087\197\201\033\000\177\187\121\108\083\077\051\132\177\038\106\068\124\249\007\194\126\229\215\194" ..
		-- tex:"0ba0ed57c5c92100b1bb796c534d3384"; x:936.604614; y:-33.993641; z:-107.948235
		"\113\225\182\168\109\111\003\032\233\169\240\170\009\254\072\061\139\183\051\068\248\132\058\195\126\229\215\194",
		-- tex:"71e1b6a86d6f0320e9a9f0aa09fe483d"; x:718.867920; y:-186.519424; z:-107.948235
	["The Underbog"] = 
		"\113\035\066\145\006\217\016\157\182\019\223\090\167\242\168\101\006\222\083\196\183\015\012\067\178\097\171\194" ..
		-- tex:"7123429106d9109db613df5aa7f2a865"; x:-847.469177; y:140.061401; z:-85.690819
		"\107\172\091\049\207\009\199\238\097\113\093\001\146\076\080\039\055\240\158\194\143\224\231\194\178\097\171\194" ..
		-- tex:"6bac5b31cf09c7ee61715d01924c5027"; x:-79.469177; y:-115.938599; z:-85.690819
		"\147\101\110\036\239\041\109\069\235\183\181\135\147\021\096\221\055\240\158\194\183\015\012\067\178\097\171\194" ..
		-- tex:"93656e24ef296d45ebb7b587931560dd"; x:-79.469177; y:140.061401; z:-85.690819
		"\251\119\157\026\211\246\193\070\022\184\031\035\073\022\094\142\055\240\158\194\035\248\185\195\178\097\171\194" ..
		-- tex:"fb779d1ad3f6c14616b81f2349165e8e"; x:-79.469177; y:-371.938599; z:-85.690819
		"\252\125\018\138\186\064\035\025\139\106\039\077\171\142\216\164\013\188\167\195\237\003\035\068\178\097\171\194" ..
		-- tex:"fc7d128aba4023198b6a274dab8ed8a4"; x:-335.469177; y:652.061401; z:-85.690819
		"\168\165\168\219\132\179\139\226\046\189\229\027\217\133\049\198\013\188\167\195\237\003\099\068\178\097\171\194" ..
		-- tex:"a8a5a8db84b38be22ebde51bd98531c6"; x:-335.469177; y:908.061401; z:-85.690819
		"\009\057\043\045\149\223\043\147\146\172\058\027\249\041\225\245\013\188\167\195\219\007\198\067\178\097\171\194" ..
		-- tex:"09392b2d95df2b9392ac3a1bf929e1f5"; x:-335.469177; y:396.061401; z:-85.690819
		"\116\088\213\073\245\029\038\067\159\230\209\019\244\221\019\061\055\240\158\194\219\007\198\067\178\097\171\194" ..
		-- tex:"7458d549f51d26439fe6d113f4dd133d"; x:-79.469177; y:396.061401; z:-85.690819
		"\105\226\103\218\248\181\215\030\019\004\053\098\024\000\224\017\055\240\158\194\237\003\099\068\178\097\171\194" ..
		-- tex:"69e267daf8b5d71e130435621800e011"; x:-79.469177; y:908.061401; z:-85.690819
		"\137\181\125\121\163\054\185\004\005\146\021\083\204\202\155\052\227\135\048\067\183\015\012\067\178\097\171\194" ..
		-- tex:"89b57d79a336b90405921553ccca9b34"; x:176.530823; y:140.061401; z:-85.690819
		"\212\176\133\167\186\254\213\176\168\180\005\203\237\023\213\024\055\240\158\194\237\003\035\068\178\097\171\194" ..
		-- tex:"d4b085a7bafed5b0a8b405cbed17d518"; x:-79.469177; y:652.061401; z:-85.690819
		"\233\127\172\211\021\138\086\017\211\024\217\041\112\109\072\099\227\135\048\067\143\224\231\194\178\097\171\194" ..
		-- tex:"e97facd3158a5611d318d929706d4863"; x:176.530823; y:-115.938599; z:-85.690819
		"\137\139\076\198\119\081\230\224\089\216\073\049\010\005\090\074\227\135\048\067\035\248\185\195\178\097\171\194" ..
		-- tex:"898b4cc67751e6e059d849310a055a4a"; x:176.530823; y:-371.938599; z:-85.690819
		"\123\070\148\189\174\164\004\026\064\147\057\108\186\053\047\101\227\135\048\067\219\007\198\067\178\097\171\194" ..
		-- tex:"7b4694bdaea4041a4093396cba352f65"; x:176.530823; y:396.061401; z:-85.690819
		"\211\105\185\186\149\049\143\239\251\083\237\144\109\143\152\082\013\188\167\195\183\015\012\067\178\097\171\194" ..
		-- tex:"d369b9ba95318feffb53ed906d8f9852"; x:-335.469177; y:140.061401; z:-85.690819
		"\002\045\058\240\252\050\156\070\083\088\073\093\125\222\105\191\013\188\167\195\035\248\185\195\178\097\171\194" ..
		-- tex:"022d3af0fc329c465358495d7dde69bf"; x:-335.469177; y:-371.938599; z:-85.690819
		"\027\210\059\226\229\100\210\141\016\229\149\043\100\202\195\219\006\222\083\196\246\129\145\068\178\097\171\194" ..
		-- tex:"1bd23be2e564d28d10e5952b64cac3db"; x:-847.469177; y:1164.061401; z:-85.690819
		"\024\067\222\220\003\231\015\039\013\092\067\136\143\116\241\078\006\222\019\196\035\248\185\195\178\097\171\194" ..
		-- tex:"1843dedc03e70f270d5c43888f74f14e"; x:-591.469177; y:-371.938599; z:-85.690819
		"\076\219\095\176\203\009\043\177\128\099\199\246\080\238\041\226\006\222\083\196\237\003\099\068\178\097\171\194" ..
		-- tex:"4cdb5fb0cb092bb18063c7f650ee29e2"; x:-847.469177; y:908.061401; z:-85.690819
		"\001\057\223\201\126\119\148\023\028\169\247\110\003\066\026\240\006\222\083\196\219\007\198\067\178\097\171\194" ..
		-- tex:"0139dfc97e7794171ca9f76e03421af0"; x:-847.469177; y:396.061401; z:-85.690819
		"\043\138\174\223\008\041\199\025\175\240\143\151\192\204\066\049\006\222\083\196\237\003\035\068\178\097\171\194" ..
		-- tex:"2b8aaedf0829c719aff08f97c0cc4231"; x:-847.469177; y:652.061401; z:-85.690819
		"\079\035\015\143\164\064\139\013\002\162\224\141\028\064\095\078\013\188\167\195\143\224\231\194\178\097\171\194" ..
		-- tex:"4f230f8fa4408b0d02a2e08d1c405f4e"; x:-335.469177; y:-115.938599; z:-85.690819
		"\128\153\101\098\224\165\088\173\251\189\210\003\035\184\194\200\006\222\019\196\143\224\231\194\178\097\171\194" ..
		-- tex:"80996562e0a558adfbbdd20323b8c2c8"; x:-591.469177; y:-115.938599; z:-85.690819
		"\195\053\098\238\232\078\131\115\234\085\022\072\237\093\143\187\006\222\019\196\219\007\198\067\178\097\171\194" ..
		-- tex:"c33562eee84e8373ea551648ed5d8fbb"; x:-591.469177; y:396.061401; z:-85.690819
		"\174\208\030\173\101\242\044\178\143\023\028\014\146\002\227\056\006\222\019\196\246\129\145\068\178\097\171\194" ..
		-- tex:"aed01ead65f22cb28f171c0e9202e338"; x:-591.469177; y:1164.061401; z:-85.690819
		"\176\190\021\103\183\011\025\129\131\062\131\143\065\085\045\054\006\222\019\196\183\015\012\067\178\097\171\194" ..
		-- tex:"b0be1567b70b1981833e838f41552d36"; x:-591.469177; y:140.061401; z:-85.690819
		"\233\183\110\002\001\168\041\058\024\059\125\085\251\039\024\135\006\222\019\196\237\003\099\068\178\097\171\194" ..
		-- tex:"e9b76e0201a8293a183b7d55fb271887"; x:-591.469177; y:908.061401; z:-85.690819
		"\013\205\059\063\090\076\041\246\003\181\219\075\171\217\219\162\006\222\019\196\237\003\035\068\178\097\171\194" ..
		-- tex:"0dcd3b3f5a4c29f603b5db4babd9dba2"; x:-591.469177; y:652.061401; z:-85.690819
		"\203\073\064\001\029\005\216\222\068\071\188\008\124\137\034\031\227\135\048\067\237\003\035\068\178\097\171\194",
		-- tex:"cb4940011d05d8de4447bc087c89221f"; x:176.530823; y:652.061401; z:-85.690819
	["Uldaman"] = 
		"\219\152\011\124\113\120\124\010\128\141\231\090\203\018\026\049\127\239\029\068\003\105\155\195\147\106\225\194" ..
		-- tex:"db980b7c71787c0a808de75acb121a31"; x:631.742188; y:-310.820435; z:-112.708160
		"\239\172\026\037\152\052\116\225\143\133\223\168\090\016\062\123\072\173\105\195\072\209\229\195\021\010\220\194" ..
		-- tex:"efac1a25983474e18f85dfa85a103e7b"; x:-233.676895; y:-459.635040; z:-110.019699
		"\225\132\084\198\144\127\234\084\035\202\201\171\087\038\162\072\123\228\156\067\112\018\039\196\068\250\217\194" ..
		-- tex:"e18454c6907fea5423cac9ab5726a248"; x:313.785034; y:-668.288147; z:-108.988808
		"\122\072\015\006\223\252\021\132\235\234\089\110\078\146\169\050\207\003\105\067\234\183\022\196\143\235\217\194" ..
		-- tex:"7a480f06dffc1584ebea596e4e92a932"; x:233.014893; y:-602.873718; z:-108.960083
		"\067\152\017\012\125\110\021\085\080\149\058\239\229\239\171\071\009\162\021\195\187\116\008\196\049\062\217\194" ..
		-- tex:"4398110c7d6e155550953aefe5efab47"; x:-149.632965; y:-545.823975; z:-108.621475
		"\197\115\051\076\083\114\246\160\038\013\015\225\103\043\120\010\082\070\085\067\109\084\248\195\062\058\210\194" ..
		-- tex:"c573334c5372f6a0260d0fe1672b780a"; x:213.274704; y:-496.659607; z:-105.113762
		"\225\027\106\233\169\177\068\069\183\170\205\084\149\243\223\091\157\024\176\195\064\021\032\196\162\016\209\194" ..
		-- tex:"e11b6ae9a9b14445b7aacd5495f3df5b"; x:-352.192322; y:-640.332092; z:-104.532494
		"\207\231\185\151\028\240\079\131\031\217\032\208\033\255\007\253\050\211\141\195\001\001\027\196\250\237\208\194" ..
		-- tex:"cfe7b9971cf04f831fd920d021ff07fd"; x:-283.649994; y:-620.015747; z:-104.464806
		"\004\112\129\253\096\000\211\045\168\048\171\106\083\224\069\015\068\071\183\067\166\015\169\194\254\007\208\194" ..
		-- tex:"047081fd6000d32da830ab6a53e0450f"; x:366.556793; y:-84.530571; z:-104.015617
		"\083\112\071\036\207\162\061\224\084\140\237\188\242\095\177\033\085\103\150\066\251\079\067\196\014\203\207\194" ..
		-- tex:"53704724cfa23de0548cedbcf25fb121"; x:75.201828; y:-781.249756; z:-103.896599
		"\034\046\155\092\245\144\186\238\223\209\208\139\057\230\234\095\254\210\019\067\066\168\043\196\235\119\205\194" ..
		-- tex:"222e9b5cf590baeedfd1d08b39e6ea5f"; x:147.824203; y:-686.629089; z:-102.734222
		"\101\078\185\245\055\205\150\250\139\001\051\017\116\019\073\079\057\196\187\067\013\099\021\196\173\194\204\194" ..
		-- tex:"654eb9f537cd96fa8b0133117413494f"; x:375.533020; y:-597.547729; z:-102.380234
		"\009\103\196\062\114\153\102\143\090\100\066\218\224\159\178\035\251\111\121\066\157\217\246\195\103\224\203\194" ..
		-- tex:"0967c43e7299668f5a6442dae09fb223"; x:62.359360; y:-493.700134; z:-101.938293
		"\227\208\061\253\248\091\125\112\061\074\024\069\067\101\217\215\150\217\109\067\215\143\044\196\240\075\203\194" ..
		-- tex:"e3d03dfdf85b7d703d4a18454365d9d7"; x:237.849960; y:-690.247559; z:-101.648323
		"\088\212\247\045\030\224\080\230\215\046\234\134\051\024\070\176\075\185\140\067\070\016\231\195\144\123\202\194" ..
		-- tex:"58d4f72d1ee050e6d72eea86331846b0"; x:281.447632; y:-462.127167; z:-101.241341
		"\190\035\005\162\194\204\130\061\100\119\201\121\018\141\214\064\159\136\067\066\042\204\013\196\091\230\201\194" ..
		-- tex:"be2305a2c2cc823d6477c979128dd640"; x:48.883423; y:-567.190125; z:-100.949921
		"\150\081\102\026\220\219\035\229\235\025\066\224\092\196\109\199\148\024\083\192\222\185\017\196\119\151\200\194" ..
		-- tex:"9651661adcdb23e5eb1942e05cc46dc7"; x:-3.298375; y:-582.904236; z:-100.295837
		"\142\004\239\207\251\166\129\250\017\031\067\169\047\252\192\219\140\203\201\067\043\180\148\195\239\074\200\194" ..
		-- tex:"8e04efcffba681fa111f43a92ffcc0db"; x:403.590240; y:-297.407593; z:-100.146362
		"\242\097\138\190\153\000\015\178\170\020\143\145\093\249\130\119\010\047\151\067\127\238\075\195\245\004\200\194" ..
		-- tex:"f2618abe99000fb2aa148f915df98277"; x:302.367523; y:-203.931641; z:-100.009689
		"\182\067\246\002\010\164\027\161\190\205\113\110\185\022\109\221\250\076\013\067\191\031\021\196\147\247\198\194" ..
		-- tex:"b643f6020aa41ba1becd716eb9166ddd"; x:141.300705; y:-596.496094; z:-99.483551
		"\055\008\008\135\176\115\099\049\178\189\136\102\210\205\194\052\087\164\165\067\239\046\178\195\195\245\196\194" ..
		-- tex:"37080887b0736331b2bd8866d2cdc234"; x:331.283936; y:-356.366699; z:-98.480011
		"\078\047\180\205\072\177\219\245\039\142\234\163\027\096\136\109\122\167\253\067\020\121\072\195\118\095\195\194" ..
		-- tex:"4e2fb4cd48b1dbf5278eeaa31b60886d"; x:507.308441; y:-200.472977; z:-97.686455
		"\241\133\125\203\246\202\096\225\189\136\126\252\105\135\238\107\152\087\069\067\206\203\055\196\118\084\195\194" ..
		-- tex:"f1857dcbf6ca60e1bd887efc6987ee6b"; x:197.342178; y:-735.184509; z:-97.664970
		"\231\003\043\042\211\045\006\054\164\126\228\017\037\041\066\113\115\185\019\068\163\173\137\195\109\170\194\194" ..
		-- tex:"e7032b2ad32d0636a47ee41125294271"; x:590.897705; y:-275.356567; z:-97.332870
		"\161\088\148\129\118\122\070\083\171\061\096\047\132\163\204\110\074\197\133\193\248\237\052\196\183\028\193\194" ..
		-- tex:"a1589481767a4653ab3d602f84a3cc6e"; x:-16.721334; y:-723.718323; z:-96.556091
		"\041\222\116\045\216\200\170\024\150\218\107\142\172\158\151\105\204\129\115\194\054\179\085\196\034\244\192\194" ..
		-- tex:"29de742dd8c8aa1896da6b8eac9e9769"; x:-60.876759; y:-854.800232; z:-96.476830
		"\202\176\146\019\132\047\018\103\171\032\240\153\147\250\254\143\075\055\202\067\008\174\028\195\123\134\192\194" ..
		-- tex:"cab09213842f1267ab20f09993fafe8f"; x:404.432007; y:-156.679825; z:-96.262665
		"\036\071\217\189\058\115\104\177\138\036\133\014\171\254\080\049\122\167\253\067\048\047\178\195\054\047\191\194" ..
		-- tex:"2447d9bd3a7368b18a24850eabfe5031"; x:507.308441; y:-356.368683; z:-95.592216
		"\024\201\152\060\162\243\078\060\030\017\018\082\005\183\059\054\030\094\214\067\126\058\038\196\090\128\190\194" ..
		-- tex:"18c9983ca2f34e3c1e11125205b73b36"; x:428.735321; y:-664.914001; z:-95.250694
		"\130\115\036\097\154\129\052\158\074\065\171\114\026\184\145\129\087\179\093\065\004\099\030\196\184\009\190\194" ..
		-- tex:"827324619a81349e4a41ab721ab89181"; x:13.856285; y:-633.547180; z:-95.018990
		"\129\048\149\195\127\206\022\186\208\162\167\151\202\111\239\047\075\055\202\067\062\042\187\195\033\248\186\194" ..
		-- tex:"813095c37fce16bad0a2a797ca6fef2f"; x:404.432007; y:-374.330048; z:-93.484634
		"\169\169\162\098\189\108\143\216\018\091\164\212\006\071\132\021\116\216\000\068\189\033\053\066\251\197\182\194" ..
		-- tex:"a9a9a262bd6c8fd8125ba4d406478415"; x:515.382141; y:45.282951; z:-91.386688
		"\075\105\100\129\221\213\091\078\227\031\122\047\026\253\090\142\043\112\243\193\147\138\063\196\091\224\176\194" ..
		-- tex:"4b696481ddd55b4ee31f7a2f1afd5a8e"; x:-30.429771; y:-766.165283; z:-88.438202
		"\009\216\002\013\224\122\233\101\254\133\160\161\161\188\146\116\083\004\031\195\010\063\071\196\030\116\175\194" ..
		-- tex:"09d8020de07ae965fe85a0a1a1bc9274"; x:-159.016907; y:-796.985046; z:-87.726799
		"\064\207\061\069\225\172\056\073\040\007\110\114\117\037\170\067\076\130\249\194\133\024\042\196\001\125\174\194" ..
		-- tex:"40cf3d45e1ac384928076e727525aa43"; x:-124.754494; y:-680.383179; z:-87.244156
		"\049\122\244\184\068\059\003\104\133\120\190\014\247\046\143\011\104\229\122\067\140\023\077\196\026\006\171\194" ..
		-- tex:"317af4b8443b03688578be0ef72e8f0b"; x:250.896133; y:-820.367981; z:-85.511925
		"\173\251\137\054\068\045\136\122\074\242\172\254\075\169\062\191\178\046\140\195\246\156\236\195\183\021\170\194" ..
		-- tex:"adfb8936442d887a4af2acfe4ba93ebf"; x:-280.364838; y:-473.226288; z:-85.042419
		"\062\065\004\132\063\063\141\038\047\131\136\001\025\132\240\084\104\078\184\195\034\089\008\196\032\019\170\194" ..
		-- tex:"3e4104843f3f8d262f8388011984f054"; x:-368.612579; y:-545.392761; z:-85.037361
		"\117\099\130\229\250\011\028\037\031\104\042\003\182\112\221\092\011\099\042\195\182\042\105\196\227\244\168\194" ..
		-- tex:"756382e5fa0b1c251f682a03b670dd5c"; x:-170.386902; y:-932.667419; z:-84.478302
		"\163\094\211\174\029\172\145\228\076\083\132\189\251\083\148\123\008\030\206\067\082\250\058\196\058\088\163\194" ..
		-- tex:"a35ed3ae1dac91e44c5384bdfb53947b"; x:412.234650; y:-747.911316; z:-81.672325
		"\113\150\003\185\088\072\223\190\147\235\017\120\129\249\057\043\030\012\129\194\098\141\022\196\031\199\162\194" ..
		-- tex:"719603b95848dfbe93eb117881f9392b"; x:-64.523674; y:-602.209167; z:-81.388916
		"\035\252\070\158\028\099\235\047\017\175\062\241\252\071\181\150\227\231\184\067\175\183\077\196\178\161\162\194" ..
		-- tex:"23fc469e1c63eb2f11af3ef1fc47b596"; x:369.811646; y:-822.870117; z:-81.315819
		"\094\065\245\135\108\123\004\190\075\126\022\146\045\212\033\167\201\051\074\195\005\107\081\196\229\127\161\194" ..
		-- tex:"5e41f5876c7b04be4b7e16922dd421a7"; x:-202.202301; y:-837.672241; z:-80.749802
		"\247\083\009\060\058\096\144\219\155\140\247\104\026\004\082\180\250\139\228\067\196\203\063\196\096\030\159\194" ..
		-- tex:"f753093c3a6090db9b8cf7681a0452b4"; x:457.093597; y:-767.183899; z:-79.559334
		"\166\209\248\107\070\101\227\094\091\006\253\085\063\066\091\106\096\093\249\067\071\220\072\196\162\114\150\194" ..
		-- tex:"a6d1f86b4665e35e5b06fd553f425b6a"; x:498.729523; y:-803.441895; z:-75.223900
		"\168\156\066\175\078\042\131\024\242\243\175\118\051\146\139\156\026\157\240\194\216\123\005\196\228\039\145\194" ..
		-- tex:"a89c42af4e2a8318f2f3af7633928b9c"; x:-120.306847; y:-533.935120; z:-72.577919
		"\190\190\055\008\086\016\201\245\083\065\254\164\180\219\052\019\144\025\179\067\110\232\104\065\056\006\145\194" ..
		-- tex:"bebe37085610c9f55341fea4b4db3413"; x:358.199738; y:14.556746; z:-72.512154
		"\140\145\076\199\249\090\073\159\180\075\059\195\165\085\148\133\108\166\166\195\045\229\029\196\179\141\101\194" ..
		-- tex:"8c914cc7f95a499fb44b3bc3a5559485"; x:-333.300201; y:-631.580933; z:-57.388382
		"\066\106\251\218\072\005\231\080\161\151\228\098\074\040\011\105\104\167\021\195\006\075\005\196\064\237\084\194" ..
		-- tex:"426afbda4805e750a197e4624a280b69"; x:-149.653946; y:-533.172302; z:-53.231693
		"\022\057\110\242\247\015\034\133\203\005\139\047\120\079\164\030\224\213\141\195\248\032\026\196\063\237\084\194",
		-- tex:"16396ef2f70f2285cb058b2f784fa41e"; x:-283.670929; y:-616.515198; z:-53.231689
	["Wailing Caverns"] = 
		"\228\068\051\075\029\205\090\196\040\169\045\050\153\043\161\121\036\073\029\068\069\111\139\066\237\233\194\195" ..
		-- tex:"e444334b1dcd5ac428a92d32992ba179"; x:629.142853; y:69.717331; z:-389.827576
		"\042\236\203\048\125\035\003\076\142\003\049\148\121\025\234\242\196\170\012\068\007\049\092\066\237\233\194\195" ..
		-- tex:"2aeccb307d23034c8e0331947919eaf2"; x:562.668266; y:55.047882; z:-389.827576
		"\235\074\202\107\093\081\080\068\121\214\079\158\138\137\135\091\196\170\012\068\189\243\072\195\237\233\194\195" ..
		-- tex:"eb4aca6b5d51504479d64f9e8a89875b"; x:562.668266; y:-200.952118; z:-389.827576
		"\090\117\173\214\130\003\156\006\137\187\071\093\041\145\091\101\137\085\153\067\007\049\092\066\237\233\194\195" ..
		-- tex:"5a75add682039c0689bb475d29915b65"; x:306.668266; y:55.047882; z:-389.827576
		"\012\126\150\078\214\088\066\167\050\091\253\100\165\135\223\214\137\085\153\067\189\243\072\195\237\233\194\195" ..
		-- tex:"0c7e964ed65842a7325bfd64a587dfd6"; x:306.668266; y:-200.952118; z:-389.827576
		"\025\167\022\176\049\013\026\018\119\186\158\221\078\096\048\224\072\146\186\067\150\213\039\196\237\233\194\195" ..
		-- tex:"19a716b0310d1a1277ba9edd4e6030e0"; x:373.142853; y:-671.337341; z:-389.827576
		"\095\216\029\144\123\119\130\184\183\230\248\164\208\181\093\024\036\073\029\068\092\072\058\195\237\233\194\195" ..
		-- tex:"5fd81d907b7782b8b7e6f8a4d0b55d18"; x:629.142853; y:-186.282669; z:-389.827576
		"\231\045\067\129\204\241\010\144\183\228\108\055\012\027\182\251\036\073\029\068\209\219\162\067\237\233\194\195" ..
		-- tex:"e72d4381ccf10a90b7e46c370c1bb6fb"; x:629.142853; y:325.717331; z:-389.827576
		"\114\013\215\043\102\110\095\040\032\067\068\190\013\199\086\032\072\146\186\067\209\219\162\067\237\233\194\195" ..
		-- tex:"720dd72b666e5f28204344be0dc75620"; x:373.142853; y:325.717331; z:-389.827576
		"\168\171\114\199\108\003\007\014\253\096\201\175\037\040\125\021\072\146\186\067\069\111\139\066\237\233\194\195" ..
		-- tex:"a8ab72c76c03070efd60c9af25287d15"; x:373.142853; y:69.717331; z:-389.827576
		"\008\171\077\199\243\240\114\077\137\253\194\018\039\125\188\238\077\172\074\066\007\049\092\066\237\233\194\195" ..
		-- tex:"08ab4dc7f3f0724d89fdc212277dbcee"; x:50.668266; y:55.047882; z:-389.827576
		"\143\184\125\103\060\033\108\116\056\070\057\184\033\192\188\138\072\146\186\067\045\171\207\195\237\233\194\195" ..
		-- tex:"8fb87d673c216c74384639b821c0bc8a"; x:373.142853; y:-415.337341; z:-389.827576
		"\207\075\005\111\168\054\254\161\227\232\112\022\134\050\048\233\077\172\074\066\189\243\072\195\237\233\194\195" ..
		-- tex:"cf4b056fa836fea1e3e87016863230e9"; x:50.668266; y:-200.952118; z:-389.827576
		"\189\234\011\003\189\017\141\038\089\151\090\170\229\008\010\172\229\149\147\067\249\073\209\195\237\233\194\195" ..
		-- tex:"bdea0b03bd118d2659975aaae5080aac"; x:295.171082; y:-418.577942; z:-389.827576
		"\159\186\243\133\235\245\063\043\164\215\173\143\030\133\044\002\229\149\147\067\252\164\040\196\237\233\194\195" ..
		-- tex:"9fbaf385ebf53f2ba4d7ad8f1e852c02"; x:295.171082; y:-674.577942; z:-389.827576
		"\228\048\045\041\120\119\253\072\253\253\135\179\205\088\253\136\072\146\186\067\092\072\058\195\237\233\194\195" ..
		-- tex:"e4302d297877fd48fdfd87b3cd58fd88"; x:373.142853; y:-186.282669; z:-389.827576
		"\120\145\058\192\048\247\241\211\048\199\189\048\255\018\143\142\036\073\029\068\150\213\039\196\237\233\194\195" ..
		-- tex:"78913ac030f7f1d330c7bd30ff128f8e"; x:629.142853; y:-671.337341; z:-389.827576
		"\239\254\250\046\176\082\104\140\100\008\213\022\094\105\112\111\036\073\029\068\045\171\207\195\237\233\194\195" ..
		-- tex:"effefa2eb052688c6408d5165e69706f"; x:629.142853; y:-415.337341; z:-389.827576
		"\119\039\077\105\131\128\034\045\221\019\226\134\255\231\167\131\135\202\205\194\223\099\119\194\104\096\110\195" ..
		-- tex:"77274d698380222ddd13e286ffe7a783"; x:-102.895569; y:-61.847534; z:-238.376602
		"\157\138\133\082\013\132\073\179\079\173\005\145\034\246\233\056\135\202\205\194\123\236\158\195\104\096\110\195" ..
		-- tex:"9d8a85520d8449b34fad059122f6e938"; x:-102.895569; y:-317.847534; z:-238.376602
		"\036\250\074\192\171\172\072\009\022\218\199\183\007\026\143\216\187\026\025\067\123\236\158\195\104\096\110\195" ..
		-- tex:"24fa4ac0abac480916dac7b7071a8fd8"; x:153.104431; y:-317.847534; z:-238.376602
		"\157\105\073\022\033\014\024\243\171\103\072\126\105\239\086\128\058\201\014\195\002\178\037\196\068\025\090\195" ..
		-- tex:"9d694916210e18f3ab67487e69ef5680"; x:-142.786057; y:-662.781433; z:-218.098709
		"\187\213\181\129\096\190\149\247\160\249\057\183\242\023\115\174\000\129\187\195\237\039\177\195\068\025\090\195" ..
		-- tex:"bbd5b58160be95f7a0f939b7f21773ae"; x:-375.007843; y:-354.311951; z:-218.098709
		"\249\083\164\157\206\161\019\047\253\002\193\017\101\034\156\069\000\129\187\195\246\147\024\196\068\025\090\195" ..
		-- tex:"f953a49dcea1132ffd02c11165229c45"; x:-375.007843; y:-610.311951; z:-218.098709
		"\123\250\249\223\120\097\000\048\006\022\157\133\022\005\073\206\137\109\226\066\002\178\037\196\068\025\090\195" ..
		-- tex:"7bfaf9df7861003006169d85160549ce"; x:113.213943; y:-662.781433; z:-218.098709
		"\011\014\104\222\049\181\146\024\174\019\197\240\145\004\096\129\013\002\033\195\059\046\085\196\237\008\088\195" ..
		-- tex:"0b0e68de31b59218ae13c5f091046081"; x:-161.008026; y:-852.722412; z:-216.034882
		"\228\172\200\210\022\135\085\235\205\079\137\158\001\157\067\062\227\251\189\066\059\046\085\196\237\008\088\195" ..
		-- tex:"e4acc8d2168755ebcd4f899e019d433e"; x:94.991974; y:-852.722412; z:-216.034882
		"\228\248\000\153\161\118\213\018\236\148\088\125\209\042\137\242\013\002\033\195\029\151\138\196\237\008\088\195" ..
		-- tex:"e4f80099a176d512ec94587dd12a89f2"; x:-161.008026; y:-1108.722412; z:-216.034882
		"\239\111\216\062\016\094\234\105\150\254\010\132\088\196\145\011\227\251\189\066\029\151\138\196\237\008\088\195" ..
		-- tex:"ef6fd83e105eea6996fe0a8458c4910b"; x:94.991974; y:-1108.722412; z:-216.034882
		"\245\128\031\218\215\045\096\110\041\028\231\127\152\201\064\156\179\253\222\066\039\136\056\196\043\238\085\195" ..
		-- tex:"f5801fdad72d606e291ce77f98c9409c"; x:111.495514; y:-738.127441; z:-213.930359
		"\185\253\069\051\038\094\249\225\105\197\023\143\241\214\084\222\219\142\065\067\187\113\042\195\028\107\085\195" ..
		-- tex:"b9fd4533265ef9e169c5178ff1d654de"; x:193.558044; y:-170.444275; z:-213.418411
		"\061\202\088\052\034\243\008\074\231\117\136\045\211\113\166\120\057\111\249\066\130\011\237\195\052\195\084\195" ..
		-- tex:"3dca583422f3084ae775882dd371a678"; x:124.717239; y:-474.089935; z:-212.762527
		"\119\070\193\143\013\090\117\151\156\082\096\042\060\230\038\115\098\072\003\195\130\011\237\195\052\195\084\195" ..
		-- tex:"7746c18f0d5a75979c52602a3ce62673"; x:-131.282761; y:-474.089935; z:-212.762527
		"\210\075\083\004\128\162\154\211\178\050\024\216\221\138\123\025\171\247\235\066\222\144\002\196\136\202\063\195" ..
		-- tex:"d24b530480a29ad3b23218d8dd8a7b19"; x:117.983734; y:-522.263611; z:-191.791153
		"\081\146\106\144\088\091\039\069\103\155\165\038\113\115\168\121\099\127\067\067\131\194\156\195\068\077\052\195" ..
		-- tex:"51926a90585b2745679ba5267173a879"; x:195.497620; y:-313.519653; z:-180.301834
		"\123\252\240\075\081\230\218\096\120\126\242\232\068\151\047\233\042\218\020\067\042\103\126\067\119\191\047\195" ..
		-- tex:"7bfcf04b51e6da60787ef2e844972fe9"; x:148.852211; y:254.403000; z:-175.747925
		"\081\225\132\235\173\025\184\148\200\031\241\209\192\166\197\200\170\075\214\194\042\103\126\067\119\191\047\195" ..
		-- tex:"51e184ebad19b894c81ff1d1c0a6c5c8"; x:-107.147789; y:254.403000; z:-175.747925
		"\159\094\239\229\005\048\084\024\031\240\036\092\168\006\057\222\170\075\214\194\149\051\255\067\119\191\047\195" ..
		-- tex:"9f5eefe5053054181ff0245ca80639de"; x:-107.147789; y:510.403000; z:-175.747925
		"\102\236\026\166\067\202\031\205\115\188\204\058\102\094\060\042\101\028\039\195\032\068\077\067\034\020\033\195" ..
		-- tex:"66ec1aa643ca1fcd73bccc3a665e3c2a"; x:-167.110931; y:205.266129; z:-161.078659
		"\058\007\065\134\237\139\062\252\003\220\193\066\087\237\191\247\051\199\177\066\032\068\077\067\034\020\033\195" ..
		-- tex:"3a074186ed8b3efc03dcc14257edbff7"; x:88.889069; y:205.266129; z:-161.078659
		"\123\016\077\170\103\195\007\188\108\236\225\150\041\207\203\117\077\196\173\067\243\101\178\067\232\234\031\195" ..
		-- tex:"7b104daa67c307bc6cece19629cfcb75"; x:347.533630; y:356.796501; z:-159.917618
		"\217\246\127\106\248\194\126\239\212\250\184\118\086\206\117\113\055\017\183\066\206\151\201\066\232\234\031\195" ..
		-- tex:"d9f67f6af8c27eefd4fab87656ce7571"; x:91.533630; y:100.796501; z:-159.917618
		"\149\008\168\017\099\060\245\168\137\185\017\225\166\123\077\181\055\017\183\066\243\101\178\067\232\234\031\195" ..
		-- tex:"9508a811633cf5a889b911e1a67b4db5"; x:91.533630; y:356.796501; z:-159.917618
		"\127\074\047\143\231\238\115\055\231\104\105\003\199\080\118\023\077\196\173\067\206\151\201\066\232\234\031\195" ..
		-- tex:"7f4a2f8fe7ee7337e7686903c7507617"; x:347.533630; y:100.796501; z:-159.917618
		"\178\179\201\171\120\222\123\242\198\141\237\135\172\184\122\115\056\107\140\067\137\180\170\067\205\241\018\195" ..
		-- tex:"b2b3c9ab78de7bf2c68ded87acb87a73"; x:280.837677; y:341.410461; z:-146.944550
		"\077\208\060\229\200\099\061\085\041\029\153\139\153\110\238\108\235\083\044\067\131\098\236\067\232\198\016\195" ..
		-- tex:"4dd03ce5c8633d55291d998b996eee6c"; x:172.327820; y:472.769653; z:-144.776993
		"\223\035\091\197\187\168\018\018\136\246\006\150\011\174\222\172\235\083\044\067\065\049\054\068\232\198\016\195" ..
		-- tex:"df235bc5bba8121288f606960baedeac"; x:172.327820; y:728.769653; z:-144.776993
		"\196\071\194\149\187\191\038\205\037\201\130\123\028\115\079\042\245\041\214\067\131\098\236\067\232\198\016\195" ..
		-- tex:"c447c295bbbf26cd25c9827b1c734f2a"; x:428.327820; y:472.769653; z:-144.776993
		"\114\056\082\114\084\041\234\240\025\165\027\102\120\121\017\241\043\021\182\067\224\005\228\067\035\042\016\195" ..
		-- tex:"723852725429eaf019a51b66787911f1"; x:364.165405; y:456.045929; z:-144.164612
		"\029\095\028\193\120\009\205\036\047\025\222\065\174\207\016\110\184\219\192\193\241\174\233\065\205\042\015\195" ..
		-- tex:"1d5f1cc17809cd242f19de41aecf106e"; x:-24.107286; y:29.210423; z:-143.167206
		"\190\029\039\165\067\179\087\052\132\245\045\242\045\007\175\077\203\162\086\067\096\060\205\067\034\228\013\195" ..
		-- tex:"be1d27a543b3573484f52df22d07af4d"; x:214.635925; y:410.471710; z:-141.891159
		"\022\128\037\074\220\153\130\069\112\135\115\140\159\001\177\192\000\098\152\065\153\196\176\067\017\024\011\195" ..
		-- tex:"1680254adc9982457087738c9f01b1c0"; x:19.047853; y:353.535950; z:-139.094025
		"\176\145\040\232\070\061\237\015\092\020\242\244\207\151\031\056\039\143\221\067\150\218\138\067\055\218\002\195" ..
		-- tex:"b09128e8463ded0f5c14f2f4cf971f38"; x:443.118408; y:277.707733; z:-130.852417
		"\007\025\130\068\063\198\126\209\160\183\095\140\124\150\190\148\039\143\221\067\075\109\005\068\055\218\002\195",
		-- tex:"071982443fc67ed1a0b75f8c7c96be94"; x:443.118408; y:533.707733; z:-130.852417
	["Zul'Aman"] = 
		"\002\176\006\217\248\054\242\127\142\123\057\156\017\085\117\087\255\255\231\069\255\255\247\197\000\000\000\000" ..
		-- tex:"02b006d9f836f27f8e7b399c11557557"; x:7424.000000; y:-7936.000000
		"\219\220\218\033\238\051\049\048\222\188\178\002\138\186\135\126\255\255\231\069\000\000\000\198\000\000\000\000" ..
		-- tex:"dbdcda21ee333130debcb2028aba877e"; x:7424.000000; y:-8192.000000
		"\015\216\091\060\197\194\090\222\135\045\034\216\242\150\027\239\255\255\239\069\255\255\247\197\000\000\000\000" ..
		-- tex:"0fd85b3cc5c25ade872d22d8f2961bef"; x:7680.000000; y:-7936.000000
		"\085\044\223\175\202\003\027\136\171\214\153\243\128\147\215\148\255\255\239\069\000\000\000\198\000\000\000\000",
		-- tex:"552cdfafca031b88abd699f38093d794"; x:7680.000000; y:-8192.000000
	["Zul'Farrak"] = 
		"\068\081\024\165\160\024\170\084\153\101\014\181\051\097\176\040\255\255\231\069\255\255\223\197\000\000\000\000" ..
		-- tex:"445118a5a018aa5499650eb53361b028"; x:7424.000000; y:-7168.000000
		"\223\068\162\211\077\136\230\094\175\058\017\230\120\096\036\014\255\255\231\069\255\255\231\197\000\000\000\000" ..
		-- tex:"df44a2d34d88e65eaf3a11e67860240e"; x:7424.000000; y:-7424.000000
		"\155\113\015\136\062\001\136\002\214\155\099\143\058\047\061\182\255\255\239\069\255\255\223\197\000\000\000\000" ..
		-- tex:"9b710f883e018802d69b638f3a2f3db6"; x:7680.000000; y:-7168.000000
		"\082\011\042\022\245\250\107\150\252\149\249\235\155\180\133\001\255\255\239\069\255\255\231\197\000\000\000\000",
		-- tex:"520b2a16f5fa6b96fc95f9eb9bb48501"; x:7680.000000; y:-7424.000000
	["Zul'Gurub"] = 
		"\223\048\207\070\194\201\097\009\145\034\158\217\079\136\214\244\255\255\007\070\255\255\083\198\000\000\000\000" ..
		-- tex:"df30cf46c2c9610991229ed94f88d6f4"; x:8704.000000; y:-13568.000000
		"\024\087\116\015\117\252\250\081\209\009\164\071\159\019\085\241\255\255\007\070\255\255\087\198\000\000\000\000" ..
		-- tex:"1857740f75fcfa51d109a4479f1355f1"; x:8704.000000; y:-13824.000000
		"\084\244\247\070\143\105\201\001\167\129\037\249\124\053\058\051\255\255\007\070\255\255\091\198\000\000\000\000" ..
		-- tex:"54f4f7468f69c901a78125f97c353a33"; x:8704.000000; y:-14080.000000
		"\002\250\036\134\121\014\228\208\072\078\084\118\227\150\154\178\255\255\011\070\255\255\083\198\000\000\000\000" ..
		-- tex:"02fa2486790ee4d0484e5476e3969ab2"; x:8960.000000; y:-13568.000000
		"\002\034\230\072\030\221\089\151\154\224\204\123\148\110\075\040\255\255\011\070\255\255\087\198\000\000\000\000" ..
		-- tex:"0222e6481edd59979ae0cc7b946e4b28"; x:8960.000000; y:-13824.000000
		"\030\211\125\049\084\177\072\206\153\254\007\025\149\069\023\098\255\255\011\070\255\255\091\198\000\000\000\000",
		-- tex:"1ed37d3154b148ce99fe071995451762"; x:8960.000000; y:-14080.000000
}
