local default = {
	bStatus = true, bPvP = true, bPvE = true, bLocked = true, bTimer = true, 
	bScale = 1.0, bAlpha = 0.8, bShowafflict = true, bCDown = true, bNumBars = 15, 
	bStatus = true, bPvP = true, bPvE = true, bLocked = true, bTimer = true, bScale = 1.0, 
	bAlpha = 0.8, bShowafflict = true, bCDown = true, bNumBars = 15, bParseC = true, 
	bGains = true, bFlipB = false, bSmallTSize = true, bFlashit = true, bGlobalFrag = true, 
	bBCaster = false, bSoloD = true, bSpace = 15, bDRTimer = true, bMageC = false, 
	bMiniMap = true, bMiniMapPos = 356, bMiniMapRadius = 80, bClassDR = true, bShowIcon = true, 
	bSDoTs = true, bGlobalPvP = false, bnecbCBLBias = 20, bPvEWarn = true, bGainsOnly = false, 
	bTempFPSBar = false, bFPSBarLocked = false, bTempLatencyBar = false, 
	bLatencyBarLocked = false, bSpellBreaks = false, bMouseBar = true, bDisBorder = true, 
	bBarTexture = 0, bHostileOnly = false, bBossDebuff = true, bSeparateBars = false, 
	bNumBarsSep = 4, tFramePoints = { }, bBarFont = 0, bTimerInside = true, bFocusPvP = true, 
	bFocusDebuffs = true, bFillupGains = true, bFillupDebuffs = true, bFillupDoTs = true, 
	bPvPSoundWarn = true, bTargetIcon = true, bAllowParser = false, bKSoundPvP = true, 
	bKSoundPvE = false, bKSoundPvE_grouped = true, bHideRank = false, bFocusPvPOnly = false, 
	bFocusDebuffsOnly = false, bHealFilter = false, bFragOnly = false, bHealCastOnly = false, 
	bturnDoTs = true, bScreamWarn = false};
function CEnemyCastBar_DefaultVars() -- this needs to be moved to the options for each module
	if (not CEnemyCastBar) then CEnemyCastBar = {}; end
	for k,v in pairs(default) do CEnemyCastBar[k] = v; end
	CEnemyCastBar_SetBarColors()
end
-- initialize DB tables:
CEnemyCastBar_Spells = { } -- Stored in load on demand PvP module!
CEnemyCastBar_Raids = { } -- Stored in load on demand PvE module!
CEnemyCastBar_Afflictions = { } -- Stored in load on demand Debuffs module!

function NECB_create_patterns()
	-- Event Patterns	
	CEnemyCastBar_MOB_DIES					= "^"..NECB_ConvertPattern(UNITDIESOTHER);				--UNITDIESOTHER = "%s stirbt.";
	CEnemyCastBar_MOB_KILLED				= "^"..NECB_ConvertPattern(SELFKILLOTHER);				--SELFKILLOTHER = "Ihr habt %s getötet!";
	CEnemyCastBar_SPELL_GAINS 				= "^"..NECB_ConvertPattern(AURAADDEDOTHERHELPFUL);			--AURAADDEDOTHERHELPFUL = "%1$s bekommt '%2$s'."; -- Combat log text for aura events
		NECB_SPELL_GAINS_turnit 				= NECB_Check4turn(AURAADDEDOTHERHELPFUL);
	CEnemyCastBar_SPELL_CAST 				= "^"..NECB_ConvertPattern(SPELLCASTOTHERSTART);			--SPELLCASTOTHERSTART = "%1$s beginnt %2$s zu wirken.";
		NECB_SPELL_CAST_turnit 					= NECB_Check4turn(SPELLCASTOTHERSTART);
	CEnemyCastBar_SPELL_PERFORM				= "^"..NECB_ConvertPattern(SPELLPERFORMOTHERSTART);			--SPELLPERFORMOTHERSTART = "%1$s beginnt %2$s auszuführen.";
		NECB_SPELL_PERFORM_turnit 				= NECB_Check4turn(SPELLPERFORMOTHERSTART);
	CEnemyCastBar_SPELL_CASTS				= "^"..NECB_ConvertPattern(SPELLTERSE_OTHER);			--SPELLTERSE_OTHER = "%1$s wirkt %2$s.";
		NECB_SPELL_CASTS_turnit 				= NECB_Check4turn(SPELLTERSE_OTHER);
	CEnemyCastBar_SPELL_AFFLICTED				= "^"..NECB_ConvertPattern(AURAADDEDOTHERHARMFUL);			--AURAADDEDOTHERHARMFUL = "%1$s ist von %2$s betroffen."; -- Combat log text for aura events
		NECB_SPELL_AFFLICTED_turnit 				= NECB_Check4turn(AURAADDEDOTHERHARMFUL);
	CEnemyCastBar_SPELL_AFFLICTED2				= "^"..NECB_ConvertPattern(AURAADDEDSELFHARMFUL);			--AURAADDEDSELFHARMFUL = "Ihr seid von %s betroffen."; -- Combat log text for aura events
	CEnemyCastBar_SPELL_HITS 				= "^"..NECB_ConvertPattern(SPELLLOGOTHEROTHER);			--SPELLLOGOTHEROTHER = "%1$ss %2$s trifft %3$s für %4$d Schaden.";
		NECB_SPELL_HITS_turnit 				= NECB_Check4turn(SPELLLOGOTHEROTHER);
	CEnemyCastBar_SPELL_FADE 				= "^"..NECB_ConvertPattern(AURAREMOVEDOTHER);			--AURAREMOVEDOTHER = "%1$s schwindet von %2$s.";
		NECB_SPELL_FADE_turnit 					= NECB_Check4turn(AURAREMOVEDOTHER);
	CEnemyCastBar_SPELL_REMOVED 				= "^"..NECB_ConvertPattern(AURADISPELOTHER);				--AURADISPELOTHER = "'%2$s' von %1$s wurde entfernt.";
		NECB_SPELL_REMOVED_turnit 				= NECB_Check4turn(AURADISPELOTHER);
	CEnemyCastBar_SPELL_INTERRUPTED				= "^"..NECB_ConvertPattern(SPELLINTERRUPTSELFOTHER);			--SPELLINTERRUPTSELFOTHER = "Ihr unterbrecht %2$s von %1$s.";
		NECB_SPELL_INTERRUPTED_turnit 				= NECB_Check4turn(SPELLINTERRUPTSELFOTHER);
	CEnemyCastBar_SPELL_INTERRUPTED_OTHER			= "^"..NECB_ConvertPattern(SPELLINTERRUPTOTHEROTHER);		--SPELLINTERRUPTOTHEROTHER = "%1$s unterbricht %3$s von %2$s.";
		NECB_SPELL_INTERRUPTED_OTHER_turnit 			= NECB_Check4turn(SPELLINTERRUPTOTHEROTHER);
	CECB_SELF1	= YOU; -- globalstrings variable
	CECB_SELF2	= string.match(AURAREMOVEDSELF, " (.+)."); -- globalstrings variable
	if (string.match(AURAAPPLICATIONADDEDOTHERHARMFUL, " %(%%d%)") ) then
		NECB_Stack_Catcher = " "; NECB_Stack_Catcher2 = " (%(.+%))"; -- prevent concats since it produces garbage
	else
		NECB_Stack_Catcher = ""; NECB_Stack_Catcher2 = "(%(.+%))";
	end
end

necb_fauxtimer = {};
function NECB_set_fauxtimer(a,b,c,d,e,f,g,h)

	if (not a) then
		for i=1, 8 do
			necb_fauxtimer[i] = nil;
		end
	else
		necb_fauxtimer[1] = a;	necb_fauxtimer[2] = b;	necb_fauxtimer[3] = c;	necb_fauxtimer[4] = d;
		necb_fauxtimer[5] = e;	necb_fauxtimer[6] = f;	necb_fauxtimer[7] = g;	necb_fauxtimer[8] = h;
	end
end

necb_block_debuffs = {};
function NECB_set_block_debuff(a,b,c)

	if (not a) then
		for i=1, 3 do
			necb_block_debuffs[i] = nil;
		end
	else
		necb_block_debuffs[1] = a;	necb_block_debuffs[2] = b;	necb_block_debuffs[3] = c;
	end
end

LastGotBCPacket, LastSentBCPacket = {}, {};
function NECB_set_LastGotBCPacket(a,b,c,d) LastGotBCPacket[1] = a; LastGotBCPacket[2] = b; LastGotBCPacket[3] = c; LastGotBCPacket[4] = d; end
function NECB_set_LastSentBCPacket(a,b,c,d) LastSentBCPacket[1] = a; LastSentBCPacket[2] = b; LastSentBCPacket[3] = c; LastSentBCPacket[4] = d; end

function CEnemyCastBar_SetBarColors(msg)

		--initialize colors
		cecbcolors = {"Hostile", "Friendly", "Cooldown", "GainsFoe", "GainsFriend", "Grey", "Afflict", "Stuns", "DoTs", "oClass", "oPlayer", "PvEDebuff", "pvpunknown", "IconStack"};

		if (msg == "SetColors") then
			local i = 1;
			while (CEnemyCastBar.tColor[i]) do
				getglobal("CECBPickColorOptions_"..cecbcolors[i].."NormalTexture"):SetVertexColor(CEnemyCastBar.tColor[i][1], CEnemyCastBar.tColor[i][2], CEnemyCastBar.tColor[i][3]);

				for j=1, 3 do
					getglobal("CECBPickColorOptions_"..cecbcolors[i])[j] = CEnemyCastBar.tColor[i][j];
				end
			i = i + 1;
			end

		else
			--default colors
			CEnemyCastBar.tColor = {
				{ 1, 0, 0 },		--Hostile
				{ 0, 1, 0 },		--Friendly
				{ 0, 0, 1 },		--Cooldown
	 			{ 1, 0, 1 },		--GainsFoe
	 			{ 0.5, 0, 0.65 },	--GainsFriend
				{ 0.8, 0.8, 0.8 },	--Grey
				{ 0.8, 0.8, 0 },   	--Afflict						
				{ 0.5, 0.2, 0.1 },	--Stuns, also in 'Variables Loaded'!
				{ 0, 0.8, 0.8 },	--DoTs
				{ 0.5, 1, 0.5 },	--own class debuff
                                { 1,0,0 },		--player name in label
                                { 0,0,1 },		--PvE Debuff
                                { 0, 0.3, 0 },		--Unknown PvP Spell
				{ 1, 1, 1 }		--Stack counter of Icons
			};       


		end
end

-- define event cluster:
local events_sc = {	"UNIT_SPELLCAST_START", "UNIT_SPELLCAST_DELAYED", "UNIT_SPELLCAST_STOP",
			"UNIT_SPELLCAST_CHANNEL_START", "UNIT_SPELLCAST_CHANNEL_UPDATE", "UNIT_SPELLCAST_CHANNEL_STOP",
			"CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE", "CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE", "CHAT_MSG_SPELL_PARTY_DAMAGE",
			"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE",
			"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", "CHAT_MSG_SPELL_HOSTILEPLAYER_BUFF", "CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF",
			"CHAT_MSG_SPELL_PARTY_BUFF" }; -- does not fire atm, but calls HOSTILEPLAYER_BUFF
			-- change this in CECB_PvPModule.lua, too! There is an if clause...


local events_pve = {	"CHAT_MSG_MONSTER_YELL", "CHAT_MSG_MONSTER_EMOTE", "PLAYER_REGEN_DISABLED" };

local events_chat = {	"CHAT_MSG_RAID", "CHAT_MSG_PARTY", "CHAT_MSG_RAID_LEADER", "CHAT_MSG_BATTLEGROUND", "CHAT_MSG_BATTLEGROUND_LEADER" };

local events_gains = {	"CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS",
			"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS", "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS" };

local events_afflicted = {
			"CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
			"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",	"CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE",
			"CHAT_MSG_SPELL_SELF_DAMAGE", "PLAYER_COMBO_POINTS", "UNIT_AURA" };
			--*p2.1.0:

local eventpacket = {	"CHAT_MSG_SPELL_BREAK_AURA", "CHAT_MSG_SPELL_AURA_GONE_OTHER", "CHAT_MSG_SPELL_AURA_GONE_SELF", "CHAT_MSG_SPELL_AURA_GONE_PARTY",
			"CHAT_MSG_ADDON", "CHAT_MSG_COMBAT_HOSTILE_DEATH", "CHAT_MSG_COMBAT_FRIENDLY_DEATH", "CHAT_MSG_COMBAT_XP_GAIN",
			"PLAYER_TARGET_CHANGED",  "UNIT_SPELLCAST_SENT", "UNIT_SPELLCAST_SUCCEEDED" };

			--^ "CHAT_MSG_" ones are registered to "NECB_OnEvent_Global_ChatMsgs" all others to good old "_OnEvent" function!

		--	"CHAT_MSG_SPELL_SELF_BUFF", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", "CHAT_MSG_COMBAT_SELF_HITS" -- for testing self buffs etc.
		--	"CHAT_MSG_SPELL_FAILED_LOCALPLAYER"
			--CarniEnemyCastBarFrame:RegisterEvent("CHAT_MSG_CHANNEL"); -- (register for debugging)
			--NECBEvents4:RegisterEvent("CHAT_MSG_CHANNEL");
			--NECBEvents1: 1-4

function CEnemyCastBar_RegisterEvents(command)

	NECB_perform_estima = 0; -- set performance estimation to base value

	for k,v in pairs (eventpacket) do

		if (string.match(v, "CHAT_MSG_") ) then

			if (not (string.match(v, "CHAT_MSG_SPELL") and not (CEnemyCastBar.bShowafflict or (CEnemyCastBar.bGains and CEnemyCastBar.bPvP)) )
				-- only register "fades" for these conditions^^; dont care about PvE gains, they do not fade anyway
				and not (string.match(v, "CHAT_MSG_COMBAT") and not (CEnemyCastBar.bShowafflict or CEnemyCastBar.bPvP or CEnemyCastBar.bPvE or CEnemyCastBar.bKSoundPvP or CEnemyCastBar.bKSoundPvE))
				-- disable die message if all modules disabled (and no killing sound)
				and command ~= "unreg_main"
			) then

				NECBEvents4:RegisterEvent(v);
				if (string.match(v, "CHAT_MSG_SPELL")) then NECB_perform_estima = NECB_perform_estima + 0.25; end
				NECB_perform_estima = NECB_perform_estima + 0.25;
					--DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00"..v);
			else
				NECBEvents4:UnregisterEvent(v);
					--DEFAULT_CHAT_FRAME:AddMessage("|cffff0000"..v);
			end

		else
			if (not (string.match(v, "UNIT_SPELLCAST") and not CEnemyCastBar.bShowafflict)
				and command ~= "unreg_main"
			) then
				-- disable these if no Debuffs enabled (why handle them then?^^)

				CarniEnemyCastBarFrame:RegisterEvent(v);
				if (string.match(v, "UNIT_SPELLCAST")) then NECB_perform_estima = NECB_perform_estima + 0.25; end
					--DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00"..v);

			else
				CarniEnemyCastBarFrame:UnregisterEvent(v);
					--DEFAULT_CHAT_FRAME:AddMessage("|cffff0000"..v);
			end
		end
	end


	-- NECB_PvE_Gains, NECB_PvE_Casts, NECB_PvE_Debuffs will be initialized for the second run after instance check is fired (5 secs)
	-- NECB_PvE_Debuffed_Players_timer_only does not force Debuffs of beeing registered if Module disabled

	local pvploadfailed; --prevents that a lod failure of pvp is printed to screen twice
	for k,v in pairs (events_sc) do
		if (CEnemyCastBar.bStatus and (
			(CEnemyCastBar.bPvP and not CEnemyCastBar.bGainsOnly)
			or (NECB_PvE_Casts and CEnemyCastBar.bPvE and IsInInstance() and not (GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena() ))
						) and command ~= "unreg_main"
		) then
			-- load pvp module
			if (not NECB_PvP_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_PvPModule");
				if (loaded) then
					CEnemyCastBar_LoadDisabledSpells("mute");
					--collectgarbage("collect");
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_PvPModule' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvP = false;
					pvploadfailed = true;
					break;
				end
			end

			if (NECB_PvP_Module_loaded and (NECB_PvE_Casts or not (string.sub(v, 1, 1) == "C" and not (CEnemyCastBar.bGlobalPvP or CEnemyCastBar.bCDown) ) ) ) then

				if (	not ( not (string.match(v, "CREATURE_VS_CREATURE") or (string.sub(v, 1, 1) == "U") ) -- only register CREATURE or UNIT Events if CDown and GlobalPvP disabled for Instances if needed
						and not (CEnemyCastBar.bGlobalPvP or CEnemyCastBar.bCDown) )

					and not ( CEnemyCastBar.bGainsOnly and not string.match(v, "CREATURE_VS_CREATURE") ) -- only register CREATUR Events if GainsOnly is enabled
				) then
					-- magic register routine above (caused headache!)

					NECBEvents1:RegisterEvent(v);
						--DEFAULT_CHAT_FRAME:AddMessage(v);
					if (string.sub(v, 1, 1) == "C") then
						NECB_perform_estima = NECB_perform_estima + 2;
					else
						NECB_perform_estima = NECB_perform_estima + 0.2;
					end

				end

			else
				NECBEvents1:UnregisterEvent(v);
			end
		else
			NECBEvents1:UnregisterEvent(v);
		end
	end

	for k,v in pairs (events_chat) do
		if (CEnemyCastBar.bStatus and CEnemyCastBar.bParseC and command ~= "unreg_main") then
			CarniEnemyCastBarFrame:RegisterEvent(v);
		else
			CarniEnemyCastBarFrame:UnregisterEvent(v);
		end
	end

	for k,v in pairs (events_gains) do
		if (CEnemyCastBar.bStatus and
			(	(CEnemyCastBar.bPvP and CEnemyCastBar.bGains)
				or (NECB_PvE_Gains and CEnemyCastBar.bPvE and IsInInstance() and not (GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena()) )
				 )
			 and command ~= "unreg_main"
		) then

			-- load pvp module
			if (not NECB_PvP_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_PvPModule");
				if (loaded) then
					CEnemyCastBar_LoadDisabledSpells("mute");
					--collectgarbage("collect");
				elseif (not pvploadfailed) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_PvPModule' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvP = false;
					break;
				end
			end
			if (NECB_PvP_Module_loaded) then
				NECBEvents2:RegisterEvent(v);
				NECB_perform_estima = NECB_perform_estima + 1.5;
			end
		else
			NECBEvents2:UnregisterEvent(v);
		end
	end

	for k,v in pairs (events_afflicted) do
		if (CEnemyCastBar.bStatus and
			(CEnemyCastBar.bShowafflict
			or (NECB_PvE_Debuffs and not NECB_PvE_Debuffed_Players_timer_only and CEnemyCastBar.bPvE and IsInInstance() and not (GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena()) )
				)
				and command ~= "unreg_main"
			) then

			-- load Debuff module
			if (not NECB_Debuffs_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_Debuffs");
				if (loaded) then
					CEnemyCastBar_LoadDisabledSpells("mute");
					--collectgarbage("collect");
					NECB_Debuff_grabber = 0; -- prepare to run
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_Debuffs' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvE = false;
					CEnemyCastBar.bShowafflict = false;
					break;
				end
			end

			local _, playersclass = UnitClass("player");
			if (		not (v == "PLAYER_COMBO_POINTS" and (not CEnemyCastBar.bShowafflict or not (playersclass == "DRUID" or playersclass == "ROGUE") ) )
				and	not (v == "UNIT_AURA" and not CEnemyCastBar.bShowafflict)
			) then

				if (NECB_Debuffs_Module_loaded) then
					NECBEvents3:RegisterEvent(v);
					--DEFAULT_CHAT_FRAME:AddMessage(v);
					NECB_perform_estima = NECB_perform_estima + 2;
				end
			else
				NECBEvents3:UnregisterEvent(v);
			end
		else
			NECBEvents3:UnregisterEvent(v);
		end
	end

	local PvE_DBInit_Done;
	-- this needs to be loaded after afflictions module, because there are Boss debuffs set inside the Module since 6.6.x
	for k,v in pairs (events_pve) do
		if (CEnemyCastBar.bStatus and 
				(CEnemyCastBar.bPvE or (CEnemyCastBar.bShowafflict and CEnemyCastBar.bBossDebuff))
				 and IsInInstance() and not (GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena() )
			and command ~= "unreg_main"
		) then

			-- load pve module
			if (not NECB_PvE_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_PvEModule");
				if (loaded) then
					--CEnemyCastBar_LoadDisabledSpells("mute"); --do it later on DBInit()
					--collectgarbage("collect");
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_PvEModule' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvE = false;
					CEnemyCastBar.bBossDebuff = false;
					break;
				end
			end
			if (NECB_PvE_Module_loaded and NECB_PvE_YellEmoteCombat) then
				CarniEnemyCastBarFrame:RegisterEvent(v);
			end

			--load database
			if (NECB_PvE_Module_loaded and not PvE_DBInit_Done) then
				if (command == "reg_main") then --entered world and NOT called by options
					NECB_set_fauxtimer( GetTime(), nil, nil, nil, 10, "pass_instance" );
					CECBFauxFrameButton:Show(); -- wait some seconds
					--CEnemyCastBar_Show("NECB", "Getting Instance Name", 10, "cooldown", nil, "", nil, nil, nil, true);
				else
					if (CEnemyCastBar.bShowafflict and CEnemyCastBar.bBossDebuff) then
						NECB_PvE_DBInit(); -- load all spells for this instance PvE/Debuffs
					end
					NECB_PvE_DBInit(not CEnemyCastBar.bPvE, command ~= "recheck"); -- if not PvE then delete all but Debuff spells
					NECB_PvE_CodeInit(not CEnemyCastBar.bPvE); --^ , true -> forcereg!
					CEnemyCastBar_LoadDisabledSpells("mute");
				end
				PvE_DBInit_Done = true;
			end
		else
			CarniEnemyCastBarFrame:UnregisterEvent(v);
			CarniEnemyCastBarFrame:UnregisterEvent("UNIT_TARGET"); -- theoretically can be enabled but not been cleared
			if (NECB_PvE_Module_loaded and command ~= "unreg_main" and not PvE_DBInit_Done ) then

				if UnitIsGhost("player") then
					CarniEnemyCastBarFrame:RegisterEvent("PLAYER_UNGHOST"); -- prepare for event (unghost)
					-- chheck to only clear database if really left instance, not as ghost
						--CEnemyCastBar_Show("NECB", "UNGHOST", 10, "cooldown", nil, "", nil, nil, nil, true);

					if (not CEnemyCastBar.bPvE) then
						NECB_PvE_DBInit(true, true); --clear database
						NECB_PvE_CodeInit(true);
					end
				else
					NECB_PvE_DBInit(true, true); --clear database
					NECB_PvE_CodeInit(true);
				end
				PvE_DBInit_Done = true;
			end
		end
	end

	-- remove previously loaded boss debuffs on leaving world
	if (NECB_BossDB_loaded and ((command ~= "unreg_main" and not UnitIsDeadOrGhost("player") and not IsInInstance() ) or not CEnemyCastBar.bBossDebuff) ) then
		for k, v in pairs (CEnemyCastBar_Afflictions) do
			if (CEnemyCastBar_Afflictions[k].global and CEnemyCastBar_Afflictions[k].t > 0) then
			--clear any boss removal (0.1), but not global removals (0.0)
				CEnemyCastBar_Afflictions[k] = nil;
			end
		end
		NECB_BossDB_loaded = false;
		if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
			CECB_ReloadOptionsUI(); -- update tooltip
		end
	end

	--CarniEnemyCastBarFrame:RegisterAllEvents(); --for debug purposes

	if (NECBDebugMode) then
		if (command == "unreg_main") then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Debug, |cffff0000Events UNRegistered!");
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Debug, |cff00ff00Events Registered!");
		end
	end

	if (CECBOptionsFrame) then
		NECB_calc_performa(); -- do perfomance calculation
	end

end

function CEnemyCastBar_OnLoad()

	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_LEAVING_WORLD");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");

	SLASH_CARNIVALENEMYCASTBAR1 = "/necb";  
	SlashCmdList["CARNIVALENEMYCASTBAR"] = function(msg)
		CEnemyCastBar_Handler(msg);
	end

end

function CEnemyCastBar_FauxUpdater(clear) --fauxupdater

	if (clear) then
		CECBFauxFrameButton:Hide();
		NECB_set_fauxtimer(false);
		--DEFAULT_CHAT_FRAME:AddMessage("|cff990000Cleared Fauxtimer!"..GetTime())--
	elseif (necb_fauxtimer[1] and GetTime() - necb_fauxtimer[1] > necb_fauxtimer[5] ) then
		--DEFAULT_CHAT_FRAME:AddMessage(necb_fauxtimer[1] .. " - "..necb_fauxtimer[2]);
		--this is only called for Afflictions! (no need to check if exists)
		--control even checks if this is still running and disables it :D
		CECBFauxFrameButton:Hide();

		-- check for delayed DB_Init, because the AreaName is passed so slowly
		if (necb_fauxtimer[6] == "pass_instance") then

			if (IsActiveBattlefieldArena()) then -- reset cooldowns for arena fights
				--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa ARENA DETECTED!");
				if (#NECB_CD_DB > 0) then
					NECB_CD_DB = { };
					NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r Arena detected -> Cooldown database cleared!", 0, 1, 0, 1, UIERRORS_HOLD_TIME);
				end

			elseif (NECB_PvE_Module_loaded and CEnemyCastBar.bStatus and (CEnemyCastBar.bPvE or (CEnemyCastBar.bShowafflict and CEnemyCastBar.bBossDebuff)) ) then


				if (CEnemyCastBar.bShowafflict and CEnemyCastBar.bBossDebuff) then
					NECB_PvE_DBInit(); -- load all spells for this instance PvE/Debuffs
				end
				NECB_PvE_DBInit(not CEnemyCastBar.bPvE);
				NECB_PvE_CodeInit(not CEnemyCastBar.bPvE);
				CEnemyCastBar_RegisterEvents("recheck"); --clears Boss Debuffs AND rechecks right event registration! (with NECB_PvE_Gains etc.!)
				CEnemyCastBar_LoadDisabledSpells("mute");

				-- reapply obsolete cooldowns (modified to duration = 0); needed to add this if you enter/leave an instance (spell db reset/reloaded!)
				for k,v in pairs (NECBtchangeSourcePerm) do
					if (CEnemyCastBar_Raids[v]) then
						CEnemyCastBar_Raids[ CEnemyCastBar_Raids[v].tchange[1] ].t = CEnemyCastBar_Raids[ v ].tchange[3];
					end
				end

				local NECB_RaidsDB;
				for k,v in pairs (CEnemyCastBar_Raids) do
					NECB_RaidsDB = true;
					break;
				end
				if (not NECB_RaidsDB and not NECB_BossDB_loaded) then
					--NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r No PvE Spells for this instance found -> Sub functions cleared!", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);
				else
					NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r PvE and/or Debuff Spells for |cff6666ff"..GetRealZoneText().."|r loaded! See tooltip(s) for details.", 0, 1, 0, 1, UIERRORS_HOLD_TIME);
				end
			end

		elseif (necb_fauxtimer[6] == "VictoryRush") then

			if (IsUsableSpell(NECB_Victory_Rush)
				and CEnemyCastBar_UniqueCheck(NECB_Victory_Rush, CEnemyCastBar_Spells[NECB_Victory_Rush].t, UnitName("player"), nil, nil, nil, "allgains") == 0
			) then
				CEnemyCastBar_Show(UnitName("player"), NECB_Victory_Rush, CEnemyCastBar_Spells[NECB_Victory_Rush].t - 0.75, "gainsfriend", nil, CEnemyCastBar_Spells[NECB_Victory_Rush].icontex);
			end

		elseif (necb_fauxtimer[6] == "getbuff") then

				local i, t, tleft = 1;
				while ( UnitBuff("player",i) ) do
					if (UnitBuff("player",i) == necb_fauxtimer[2]) then
						_,_,_,_,t,tleft = UnitBuff("player",i);

					end
					i=i+1;
				end

				if (tleft) then
					if (CEnemyCastBar_UniqueCheck(necb_fauxtimer[2], tleft, UnitName("player"),"trueupdate",nil, nil,"allgains") == 0) then
						CEnemyCastBar_Show(UnitName("player"), necb_fauxtimer[2], tleft, "gainsfriend", nil, CEnemyCastBar_Spells[necb_fauxtimer[2]].icontex);
					end
				end

		elseif (necb_fauxtimer[6] == "printversions") then

			CEnemyCastBar_InternalHandler("printversions"); -- throttle down creation of output
		else

			if (not (CEnemyCastBar_Afflictions[necb_fauxtimer[2]].spellbreaker and not necb_fauxtimer[6]) ) then
			--necb_fauxtimer[6] will be set by 'spellbreakers' in interrupt function

				if (CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell) then

					-- 7.2.x, new support of callspell even for spells with own bars
					if (CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[2] and CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].t) then -- only used by scorch and checks talent points
						local _,currRank = GetTalentInfo(CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[2], CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[3]);
						if (currRank == CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[4]) then -- no class check needed, because this spellname can only be triggered by the proper one

							local i, stack = 1;
							while ( UnitDebuff(necb_fauxtimer[8],i) ) do
		
								if ( UnitDebuff(necb_fauxtimer[8],i) == CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[1] ) then
									--use string.match because of removed spell brackets
									_,_,_,stack = UnitDebuff(necb_fauxtimer[8],i);

									if (CEnemyCastBar_Afflictions[CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[1] ].periodicdmg) then
					
										CEnemyCastBar_Control(necb_fauxtimer[3], CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[1], "periodicdmg", nil, event, nil);
									else
										CEnemyCastBar_Control(necb_fauxtimer[3], CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[1], "afflicted", nil, event, nil); -- last nil = rank
									end

									if (stack > 1) then
										CEnemyCastBar_UniqueCheck(CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[1], "renew", necb_fauxtimer[3], "trueupdate", "("..stack..")", nil, nil);
									end
									break;
								end
								i=i+1;
							end
						end
					end

					if (not CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].t) then
						necb_fauxtimer[2] = CEnemyCastBar_Afflictions[necb_fauxtimer[2] ].callspell[1]; --old line (without if clause)
						necb_fauxtimer[7] = nil;
					end

				end
				--* removed for p2.1.0, callspell not needed anymore + remove ALL spells' flag or spells only used with callspell

				-- rebuild spell's brackets, removed with 8 3 0

				local spell = necb_fauxtimer[2];
				local rank, stack;
				if (necb_fauxtimer[4]) then
					if (tonumber( necb_fauxtimer[4] ) ) then
						if (necb_fauxtimer[4] > 1) then
							stack = "("..necb_fauxtimer[4]..")";
						end
					else
						rank = string.match(necb_fauxtimer[4], " (%d+)");
						if (rank) then tonumber( rank ); end
						--DEFAULT_CHAT_FRAME:AddMessage(necb_fauxtimer[4]);
					end
				end

				if (CEnemyCastBar_Afflictions[necb_fauxtimer[2]].periodicdmg) then

					CEnemyCastBar_Control(necb_fauxtimer[3], spell, "periodicdmg", nil, event, rank, stack);
				else
					CEnemyCastBar_Control(necb_fauxtimer[3], spell, "afflicted", nil, event, rank, stack); --even broadcasts CC's
				end
				-- removed many checks with 8 3 0
			end
		end
		NECB_set_fauxtimer(false);
	end

end

function NECB_ConvertPattern(pattern) --convert patterns

	pattern = string.gsub(pattern, "%%%d", ""); --remove "%n"

	  pattern = string.gsub(pattern, "%$s", "(.+)"); --change $s to (.+)
	  pattern = string.gsub(pattern, "%$d", "(.+)"); --change $d to (.+)

	 pattern = string.gsub(pattern, "%%s", "(.+)"); --change %s to (.+)
	 pattern = string.gsub(pattern, "%%d", "(.+)"); --change %d to (.+)

	--DEFAULT_CHAT_FRAME:AddMessage(pattern);--

	return pattern;
end

function NECB_Check4turn(pattern) -- check if mob <-> spell has to be turned around into spell <-> mob :D

	local lastnumfound, retval;
	for num in string.gmatch(pattern, "%%(%d?)%$?[sd]") do

		if (lastnumfound and tonumber(num) < lastnumfound ) then
			retval = true;
			break;
		end
		lastnumfound = tonumber(num);
	end
			-- debug help
			if (NECBDebugMode) then
				if retval then
					DEFAULT_CHAT_FRAME:AddMessage("|cffff0000TURN IT: |r"..pattern);
				else
					DEFAULT_CHAT_FRAME:AddMessage(pattern);
				end
			end
	return retval;
end


function NECB_SpellStart(arg1, update) --SpellCastStart outsourced

	if (((arg1 == "target" and not CEnemyCastBar.bFocusPvPOnly) or (arg1 == "focus" and CEnemyCastBar.bFocusPvP)) and not UnitIsUnit(arg1, "player")) then
		local UCI_spell, UCI_rank, UCI_icon, UCI_startTime, UCI_endTime, channeling;
		UCI_spell, UCI_rank, _, UCI_icon, UCI_startTime, UCI_endTime = UnitCastingInfo(arg1);
		if (not UCI_spell) then -- try again with channeling (since on target swap we can't catch start event :/)
			UCI_spell, UCI_rank, _, UCI_icon, UCI_startTime, UCI_endTime = UnitChannelInfo(arg1);
			channeling = true;
		end
		if (not UCI_spell or (CEnemyCastBar_PvECheck((UnitName(arg1)), UCI_spell, bcasted, event) and CEnemyCastBar_Raids[UCI_spell].c ~= "hostile") ) then
			return;	-- do not overwrite PvE cooldowns with same same; they will be called globally anyway!
		end
		local TargetName = UnitName(arg1);

		if (CEnemyCastBar.bSpellBreaks) then -- remove brackets to detect interrupts by stuns through combatlog (if enabled)
			UCI_spell = string.gsub(UCI_spell, NECB_Stack_Catcher2, "");
			-- don't care about shadow color for these spells (shouldn't be any left)
		end

		if (UnitIsPlayer(arg1) and not CEnemyCastBar.bHideRank) then
			UCI_rank = string.match(UCI_rank, "(%d+)");
		else
			UCI_rank = nil;
		end

		if (CEnemyCastBar_Spells[UCI_spell]
			and not (CEnemyCastBar.bHealCastOnly and not CEnemyCastBar_Spells[UCI_spell].heal)
		) then

			-- disable this gains bar permanently, because it will be catched as channeled cast since 6.6.x (bad for global pvp :/)
			if (channeling) then
				CEnemyCastBar_Spells[UCI_spell].channeled = true; -- do not clear CD if interrupted! *oh well, so many points to consider*
				if (CEnemyCastBar.bGains and not CEnemyCastBar.bGlobalPvP and CEnemyCastBar_Spells[UCI_spell].t) then
					CEnemyCastBar_Spells[UCI_spell].tdis = CEnemyCastBar_Spells[UCI_spell].t; -- reset with gloabl pvp
					CEnemyCastBar_Spells[UCI_spell].t = 0;
				end
			end

			local castime = (UCI_endTime - UCI_startTime)/1000;
			local alreadyshowing = CEnemyCastBar_UniqueCheck(UCI_spell, castime, TargetName, "trueupdate", nil, channeling,"casts");
			if (alreadyshowing == 0) then
				if (channeling) then
					--calls control, because of cooldown database!
					CEnemyCastBar_Control(TargetName, UCI_spell, "casts", castime, "UNIT_SPELLCAST_CHANNEL_START", UCI_rank);
				else
					CEnemyCastBar_Control(TargetName, UCI_spell, "casts", castime, "UNIT_SPELLCAST_START", UCI_rank);
				end

			end
			--DEFAULT_CHAT_FRAME:AddMessage("Duration: "..castime.." - Mob: "..TargetName);

		elseif (not CEnemyCastBar_Raids[UCI_spell]) then -- reinserted check, because of spell channel detection with 6.6.x
			UCI_icon = string.sub(UCI_icon, 17, string.len(UCI_icon) );

			-- replace smiling face with "?" icon:
			if (UCI_icon == "Temp") then
				UCI_icon = "";
			end

			local castime = (UCI_endTime - UCI_startTime)/1000;
			local alreadyshowing = CEnemyCastBar_UniqueCheck(UCI_spell, castime, TargetName, "trueupdate", nil, channeling, "casts");
			if (alreadyshowing == 0) then
				local ctype;
				if (UnitIsEnemy("player", arg1) ) then
					ctype = "hostile";
				else
					ctype = "friendly";
				end
				if ( not CEnemyCastBar.bHealCastOnly or (CEnemyCastBar_Spells[spell] and CEnemyCastBar_Spells[spell].heal) ) then -- heal cast filter if set
					CEnemyCastBar_Show(TargetName, UCI_spell, castime, ctype, turnlabel_, UCI_icon, "unkown spell", UCI_rank, nil, channeling) -- "unkown spell" colors the text green to know about it
				end
			end
			--DEFAULT_CHAT_FRAME:AddMessage("Duration: "..castime.." - Mob: "..TargetName.." - Icon: "..UCI_icon);
		end

		if (update) then
			-- copied from spelldelay event:
			CEnemyCastBar_UniqueCheck(UCI_spell, UCI_startTime/1000, (UnitName(arg1)), "trueupdate", "delay", UCI_endTime/1000,"casts");
		end
	end
end

function CEnemyCastBar_OnEvent(event) --onevent

	-- for debug purposes
	if (NECBDebugMode) then
		if (not arg1) then arg1 = "/"; end
		if (arg4 and event == "CHAT_MSG_ADDON") then	arg1 = arg1 .. " |rSender: |cffff0000" .. arg4 .. "|r Msg: |cffffcc00" .. arg2; end

		--if (event == "CHAT_MSG_SPELL_SELF_DAMAGE") then
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Debug: (arg1: |cff00ff00"..arg1.."|r) (event: |cffffff00"..event.."|r)");
		--end
	end

	if (event == "UNIT_SPELLCAST_SENT") then
		necbsc_sent_target = arg4;
		--DEFAULT_CHAT_FRAME:AddMessage(arg1 .. " - "..arg2.." - " .. arg3 .. " - ".. necbsc_sent_target);

	elseif (event == "UNIT_SPELLCAST_SUCCEEDED") then
		--DEFAULT_CHAT_FRAME:AddMessage(arg1 .. " - "..arg2.." - " .. arg3);
		--"player", spell, rank (deDE: "Rang n")

		-- specials, PvP Module (Gains)
		if (CEnemyCastBar_Spells[arg2] and CEnemyCastBar_Spells[arg2].special ) then

			if (not CEnemyCastBar_Spells[arg2].disabled) then
				--and CEnemyCastBar.bPvP
				local name = UnitName("player");
				if (CEnemyCastBar_Spells[arg2].special ~= true and CEnemyCastBar_Spells[arg2].special ~= "getbuff" and UnitExists(CEnemyCastBar_Spells[arg2].special)) then
					name = UnitName(CEnemyCastBar_Spells[arg2].special);
				end

				if (CEnemyCastBar_Spells[arg2].special == "getbuff") then
					NECB_set_fauxtimer(GetTime(), arg2, nil, nil, 1, "getbuff");
					CECBFauxFrameButton:Show(); -- wait for spell 'failed' events

				elseif (CEnemyCastBar_UniqueCheck(arg2,CEnemyCastBar_Spells[arg2].t,name,"trueupdate",nil, nil,"allgains") == 0) then
					--CEnemyCastBar_DelBar(NECB_Rampage.." %- "..name);
					CEnemyCastBar_Show(name, arg2, CEnemyCastBar_Spells[arg2].t, "gainsfriend", nil, CEnemyCastBar_Spells[arg2].icontex);
				end
			end

		-- common
		elseif ((necbsc_sent_target and necbsc_sent_target ~= "") or UnitName("target")) then

			-- new with NECB 6.9.x, to update focus bars
			local necb_unit = "target";
			if (UnitName("focus") == necbsc_sent_target) then
				necb_unit = "focus";
			end

			local mob = UnitName(necb_unit);
			if (necbsc_sent_target and necbsc_sent_target ~= "") then
				mob = necbsc_sent_target;
			end

 			-- check if spell has brackets, remove and store separately
			local namestack = string.match(arg1, "(%(.+%))");
			if ( namestack ) then -- check for something in brackets, delete whole part in brackets
				arg2 = string.gsub(arg2, NECB_Stack_Catcher2, "");
			end

			--> Debuffs
			if (CEnemyCastBar_Afflictions[arg2]
				--and (CEnemyCastBar_Afflictions[arg2].notdetected)
				and not (CEnemyCastBar_Afflictions[arg2].multi) --will show/renew the bar anyway, melee range < combatlog range :D
				and not (CEnemyCastBar_Afflictions[arg2].stun or CEnemyCastBar_Afflictions[arg2].stuntype)
				and not (CEnemyCastBar_Afflictions[arg2].disabled)
				and not (CEnemyCastBar_Afflictions[arg2].magecold and not CEnemyCastBar.bMageC) -- currently only frostbolt
				--* removed for p2.1.0
				and not (CEnemyCastBar_Afflictions[arg2].periodicdmg) --* added for p2.1.0, get them through debuff catcher
			) then

				local dilate = 0.25;
				if (CEnemyCastBar_Afflictions[arg2].flying) then
					if (not CheckInteractDistance(necb_unit, 4)) then
						dilate = 1.45;
					elseif (CheckInteractDistance(necb_unit, 1)) then
						dilate = 0.5;
					else
						dilate = 1.2;
					end
				end
				--* removed for p2.1.0
					--DEFAULT_CHAT_FRAME:AddMessage(dilate); --
				if (	(--CEnemyCastBar_Afflictions[arg2].periodicdmg --* removed periodicdmg for p2.1.0
					--or
					CEnemyCastBar_Afflictions[arg2].notdetected) -- trigger bar if not detected by combatlog spells
					and UnitExists(necb_unit)
					and (not UnitIsFriend("player", necb_unit) or UnitReaction("player", necb_unit) < 5)
					-- UnitisFriend does not work 'right' in duells!

				) then

					if (CEnemyCastBar_Afflictions[arg2].notdetected and CEnemyCastBar_Afflictions[arg2].spellbreaker) then
						dilate = 0.4; -- 'Counterspell' needs from 5 to 350ms; will be instantly triggered anyway if red bar found
						--DEFAULT_CHAT_FRAME:AddMessage("|cff009900Fauxtimer Set!"..GetTime())--
					end
					if (not necb_fauxtimer[1]) then -- protect instance entered timer
						local rankmod;
						if (CEnemyCastBar_Afflictions[arg2].rankmod) then
							rankmod = arg3;
						end
						NECB_set_fauxtimer(GetTime(), arg2, mob, rankmod, dilate, nil, nil, necb_unit);
						CECBFauxFrameButton:Show(); -- wait for spell 'failed' events
					end

				--
				elseif ( mob == UnitName(necb_unit)
					and not(CEnemyCastBar_Afflictions[arg2].fragile and UnitIsPlayer(necb_unit)) -- block PvP CC's
					and not CEnemyCastBar_Afflictions[arg2].norenew -- fix for german clients Freezing Trap (without 'effect' :/ )
				) then

					local oldarg2 = arg2;
					if (CEnemyCastBar_Afflictions[arg2].callspell and not CEnemyCastBar_Afflictions[arg2].t) then
						if (CEnemyCastBar_Afflictions[arg2].callspell[2]) then -- only used by scorch and checks talent points
							local _,_,_,_,currRank = GetTalentInfo(CEnemyCastBar_Afflictions[arg2].callspell[2], CEnemyCastBar_Afflictions[arg2].callspell[3]);
							if (currRank ~= CEnemyCastBar_Afflictions[arg2].callspell[4]) then -- no class check needed, because this spellname can only be triggered by the proper one
								return;
							end
						end
						arg2 = CEnemyCastBar_Afflictions[arg2].callspell[1];
					end
					local i, stack, limeLeft = 1;
					while ( UnitDebuff(necb_unit,i) ) do

						if ((string.match(UnitDebuff(necb_unit,i), "%(") and string.match(UnitDebuff(necb_unit,i), arg2))
							or UnitDebuff(necb_unit,i) == arg2
						) then
							--use string.match because of removed spell brackets, p2.1.0: improved check above
							_,_,_,stack,_,_, timeLeft = UnitDebuff(necb_unit,i);
							if (not necb_fauxtimer[1] and not (timeLeft and stack > 0)) then
							-- protect^ instance entered timer; ^do not update active stacking debuffs (they will be updated through getdebuffs without flickering bars!)
								if (CEnemyCastBar_Afflictions[arg2].rankmod) then
									stack = "";
									NECB_set_block_debuff(oldarg2, GetTime() + dilate + 0.25, tonumber( string.match(arg3, " (%d+)") )  ); -- once really blocked debuffs, but now only modifies duration of all upcoming same named debuffs
								end
								NECB_set_fauxtimer(GetTime(), oldarg2, mob, stack, dilate, nil, namestack, necb_unit);
								CECBFauxFrameButton:Show(); -- wait for spell 'failed' events
							end
							i = nil;
							break;
						end
						i=i+1;
					end
					--if (i and CEnemyCastBar_Afflictions[arg2].periodicdmg) then --dot not found on mob
					--	CEnemyCastBar_Handler("deletebar "..arg2);
					--* removed with p2.1.0, won't get here anyway and considered useless at all
					if (i and CEnemyCastBar_Afflictions[arg2].rankmod) then --'rankspell' modifier + block combat log!
						NECB_set_block_debuff(oldarg2, GetTime() + dilate + 0.75, tonumber( string.match(arg3, " (%d+)") )  );
					end
				--* removed for p2.1.0 + remove callspell, norenew from databases!
				end

			--> PvP/Hots/Gains
			elseif (CEnemyCastBar_Spells[arg2]) then

				 -- specials
				if (arg2 == NECB_Victory_Rush) then
					CEnemyCastBar_DelBar(NECB_Victory_Rush);
				end

				-- initially Healing Wave -> Healing Way
				if (CEnemyCastBar_Spells[arg2].callspell) then
					if (CEnemyCastBar_Spells[arg2].callspell[2]) then
						local _,_,_,_,currRank = GetTalentInfo(CEnemyCastBar_Spells[arg2].callspell[2], CEnemyCastBar_Spells[arg2].callspell[3]);
						if (currRank ~= CEnemyCastBar_Spells[arg2].callspell[4]) then -- no class check needed, because this spellname can only be triggered by the proper one
							return;
						end
					end
					arg2 = CEnemyCastBar_Spells[arg2].callspell[1];
				end

				if (CEnemyCastBar_Spells[arg2].HoT or CEnemyCastBar_Spells[arg2].cgain) then

					--* own Buff tracer, all this work to solve the problem with the very first bar :O p2.1.0
					if ((CEnemyCastBar_Spells[arg2].HoT or CEnemyCastBar_Spells[arg2].nofade)
						and (necbsc_sent_target == UnitName("target") or necbsc_sent_target == UnitName("focus"))
						and (CEnemyCastBar_UniqueCheck(arg2, 0, mob, "true", nil, nil, "allgains") == 0)
							-- otherwise the function below will do its job
					) then -- check buff timeLeft after some milliseconds
						NECB_Buff_timer = GetTime(); -- only got here if spells exist = pvp module loaded -> all ready
						NECB_BuffFauxTimer:Show();
					end

					local i, stack, pseudostack, DRText = 1, 0, 0;
					-- get stack counter for non HoT gains (remote gains); Livebloom +possibly others in the future
					-- and count HoTs (since 6.8.x)
					if ( mob == UnitName(necb_unit) ) then

						while ( UnitBuff(necb_unit,i) ) do
							if (UnitBuff(necb_unit,i) == arg2) then
								_,_,_,stack = UnitBuff(necb_unit,i);
								if (stack > 0 or CEnemyCastBar_Spells[arg2].cgain) then
									DRText = "("..stack..")";
									break; -- no more than one stackable spell (or cgain) possible; but lifebloom screws it ^^
								else
									pseudostack = pseudostack + 1;
								end
							end
							i=i+1;
						end

						if (pseudostack > 1) then
							DRText = "("..pseudostack..")";
						end
					end
					if (CEnemyCastBar_UniqueCheck(arg2, "renew", mob, "trueupdate", DRText, nil, "allgains") == 0) then
						if (DRText or pseudostack > 0) then
							CEnemyCastBar_Control(mob, arg2, "gains", nil, "friendlyEvent", nil, DRText); -- trigger new bar
							-- removed uni call 8 3 0
						end
					end

					--* to update any other than the first HoT bar, p2.1.0
					if (not NECB_BuffFauxTimer:IsVisible() and (CEnemyCastBar_Spells[arg2].HoT or CEnemyCastBar_Spells[arg2].nofade) ) then -- nofade = only Lifebloom currently
						local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
						if (CEnemyCastBar.bSeparateBars) then
							minbar, maxbar = 3 * CEnemyCastBar.bNumBarsSep + 1, 4 * CEnemyCastBar.bNumBarsSep; -- friendly gains
						end

						for i=minbar, maxbar do
							local bar = getglobal("Carni_ECB_"..i);

							if (bar.spell == arg2 and bar.mob == mob) then
								-- read out t and g before, now simple mechanics:
								bar.activeHoTEnd = bar.endTime;
								bar.activeHoTStart = bar.startTime; -- not needed to clear in hide func, not queried
								getglobal("Carni_ECB_"..i.."_StatusBar_SparkHoT"):Show();
							end
						end
					end
				end
			end
		end

	elseif (event == "CHAT_MSG_MONSTER_YELL" and NECB_PvE_Module_loaded) then
	
		NECB_PvE_Yell(arg1, arg2);

	elseif (event == "CHAT_MSG_MONSTER_EMOTE" and NECB_PvE_Module_loaded) then
	
		NECB_PvE_Emote(arg1, arg2);

	elseif (event == "PLAYER_LEAVING_WORLD" and CEnemyCastBar.bStatus) then

		CEnemyCastBar_RegisterEvents("unreg_main");

		if (not CEnemyCastBar.bStatus) then
			CEnemyCastBar_Raids = { }; -- in case bStatus has been disabled while in instance (then the init function won't be called)
		end

		-- if player leaves world or does a reloadUI while movable bars, set points
		CEnemyCastBar.bLocked = false;
		CEnemyCastBar_LockPos();

	elseif (event == "PLAYER_ENTERING_WORLD") then
		if (not necbalreadywarned) then
			NECB_create_patterns();
			if (not CEnemyCastBar.tFramePoints) then
				CEnemyCastBar.tFramePoints = { };

				-- bars have been created in vars loaded and { } initialized
				CEnemyCastBar_FPSBar_DragStop(); -- catches points and delete them: fpsbar

				CEnemyCastBar.bLocked = false;
				CEnemyCastBar_LockPos(); -- also catches points and deletes them: button
			else
				NECBCreateBars(); -- CREATE castbar buttons here, AFTER their points were cleared, because they were not found (points got from database now)

				-- set their points
				if (CEnemyCastBar.tFramePoints) then -- only set points if already catched them; otherwise they will be generated in Enter_World
					for k,v in pairs (CEnemyCastBar.tFramePoints) do
						if (getglobal(k)) then
							local point = "TOPLEFT";
							if (CEnemyCastBar.tFramePoints[k][3]) then
								point = CEnemyCastBar.tFramePoints[k][3];
							end
							getglobal(k):ClearAllPoints();
							getglobal(k):SetPoint(point, "UIParent", point, CEnemyCastBar.tFramePoints[k][1], CEnemyCastBar.tFramePoints[k][2] );
						end
					end
				end
			end

			-- for rogues, do poison suffix check for spells; add more classes if needed later
			local _, playersclass = UnitClass("player");
			if (playersclass == "ROGUE") then
				NECB_psuffix = {" VII", " VI", " V", " IV", " III", " II"} --poison suffixes
			else
				NECB_psuffix = {" II"}; -- crippling poison is visible to all classes and has 2 levels.
			end

			--collectgarbage("collect"); -- clear any garbage
		end

		-- now register events AFTER all Bars have been created
		if (CEnemyCastBar.bStatus) then
			CEnemyCastBar_RegisterEvents("reg_main"); -- do not forget this loads the modules, too ;-)
			CEnemyCastBar_Player_Target_Changed(); -- clear CD bars

			if (CEnemyCastBar.bPvP and CEnemyCastBar.bCDown and IsInInstance() ) then
				NECB_set_fauxtimer(GetTime(), nil, nil, nil, 5, "pass_instance"); -- do arena check after 5 secs.
				CECBFauxFrameButton:Show(); -- wait some seconds
			end

		end

		-- initialize disabled spells AFTER Spell Database has been loaded through RegisterEvents
		if (not necbalreadywarned) then
			if ( CEnemyCastBar.tDisabledSpells and #CEnemyCastBar.tDisabledSpells > 0 ) then
				NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r Manually disabled Spells detected!\n|cffffffffSee ChatWindow for more info.", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);
				CEnemyCastBar_LoadDisabledSpells("mute");
				CEnemyCastBar_Handler("disabled");
			end
		end

		necbalreadywarned = true;

	elseif ((event == "PLAYER_REGEN_DISABLED" or (event == "UNIT_TARGET" and (arg1 == "target" or arg1 == "focus"))) and NECB_PvE_Module_loaded) then

		CEnemyCastBar_Player_Enter_Combat(arg1);

	elseif (event == "PLAYER_TARGET_CHANGED") then

		CEnemyCastBar_Player_Target_Changed();

	elseif (event == "CHAT_MSG_RAID" or event == "CHAT_MSG_RAID_LEADER" or event == "CHAT_MSG_BATTLEGROUND" or event == "CHAT_MSG_BATTLEGROUND_LEADER") then

		CEnemyCastBar_Parse_RaidChat(arg1, arg2, "Raid");

	elseif (event == "CHAT_MSG_PARTY") then

		CEnemyCastBar_Parse_RaidChat(arg1, arg2, "Party");

	elseif (event == "PLAYER_UNGHOST") then

		CarniEnemyCastBarFrame:UnregisterEvent("PLAYER_UNGHOST");
		NECB_set_fauxtimer(GetTime(), nil, nil, nil, 15, "pass_instance");
		CECBFauxFrameButton:Show(); -- clear database if after 15 secs won't be overridden by above fauxtimer and if out of instance then
			--CEnemyCastBar_Show("NECB", "Getting Instance Name", 15, "cooldown", nil, "", nil, nil, nil, true);

	elseif ( event == "VARIABLES_LOADED" ) then

		if (not CEnemyCastBarHelp) then -- only show it the first time (profiles call this event since 7.2.x)
			DEFAULT_CHAT_FRAME:AddMessage("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffffffff AddOn loaded. Use |cff00ff00/necb|cffffffff to configure.");
		end
		NECBVersionDB = { };
		NECBVersionNames = { };
		NECBParserCollect = { };
		NECBtchangeSource = { };
		NECBtchangeSourcePerm = { };
		NECB_CD_DB = { };
		NECB_DR_DB = { }; --DR

		-- needed for disabled colors set with Entering_world event
		CEnemyCastBar_Colors = {
		["Bartype friendly"] = { };
		["Bartype hostile"] = { };
		["Bartype gainsfoe"] = { };
		["Bartype gainsfriend"] = { };
		["Bartype afflict"] = { };
		["Bartype stuns"] = { };
		["Bartype dots"] = { };
		["Bartype cooldown"] = { };
		["Bartype grey"] = { };
		}

		if ( not CEnemyCastBar ) then
			CEnemyCastBar_DefaultVars();
		end

		-- my addons support, used for helpframe, too!

			CEnemyCastBarHelp = {}; 
			CEnemyCastBarHelp[1] = "|cff00ff00/necb |cffffffff- Toggles the options window.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000chat |cffffff99Text |cffffffff- Sends '|cffffff99Text|cffffffff' to other NECB's in your group. Happy Chatting...";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000bhill, western, xfiles, mkill, lol, jaws |cffffffff- Plays 'Jingles' for the Raid's joy. (Assist/Leader)"
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000cpu|cffffffff - Enables/disables CPU profiling for all your Addons with info in NECB's Minimap Tooltip. Toggling it resets statistics."
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000gettimer |cffffffff- requests all PvE CDs/ Respawn Timers from your Group- or RaidMembers.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000versions |cffffffffor |cff00ff00gversions |cffffffff- Show Group/GuildMembers NECB versions.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000gcinfo |cffffffff- Display memory usage of all addons";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000parser |cffffffff- Opens the NECB - AddOn Channel parser.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000cooldowns |cffffffff- Displays all Cooldowns currently in Database.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000setrange |cffffffff- Toggles between normal and maximum combatlog range.\n\n";

			--CEnemyCastBarHelp[2] = "|cff00ff00/necb deletebar |cffffff99Label |cffffffff- Deletes ALL CastBars which inherit '|cffffff99Label|cffffffff' |cffccccccand|cffffffff match your targets name!";
			--CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cff00ff00/necb showbar |cffffff99Spell |cfffffffftriggers a bar for your current target. It |cffccccccincludes a check|cffffffff: HoTs are only triggered on friendly targets, DoTs only on hostile targets!";
			CEnemyCastBarHelp[2] = "|cff00ff00/necb |cffff0000countsec|cffffff99 sss Label |cffffffff- Starts a countdown of |cffffff99sss|cffffffff seconds. |cffffff99Label|cffffffff is optional.";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cff00ff00/necb countmin |cffffff99mmm Label |cffffffff- Starts a countdown of |cffffff99mmm|cffffffff minutes";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cff00ff00/necb repeat |cffffff99sss Label |cffffffff- Repeated countdown of |cffffff99sss|cffffffff seconds";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cff00ff00/necb stopcount |cffffff99Label |cffffffff- Stops all grey CastBars which inherit '|cffffff99Label|cffffffff'\n";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."|cffff0000* |cffffffffNECB supports these |cffffff99placeholders|cffffffff: |cffffff99%t|cffffffff = TargetName, |cffffff99%f|cffffffff = FocusName, |cffffff99%tt|cffffffff = ToTName, |cffffff99%c|cffffffff = TClassName, |cffffff99%g|cffffffff = TRaidGroupNumber";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."Example|cffffffff: |cff00ff00/necb countmin |cffffff995 ReBuff %t in Group%g";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cffff0000* |cffffffffYou may also try |cffff0000.|cff00ff00countsec|cffffffff, |cff00ff00.countmin|cffffffff, |cff00ff00.stopcount|cffffffff. (A point at first!)";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cffffff99Example: |cffffffffType |cff00ff00.countsec |cffffff9910 Ten Seconds|cffffffff into the raid-channel. Everyone in your Raid with NECB and enabled Channel-Parsing will see the bar!\n\n";

			CEnemyCastBarHelp[3] = "|cffff0000Simple LeftClick |cffffffffcopies the bar label and time left into the chat editbox.";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cffff0000Simple RightClick |cffffffffprotects CD-Bars from beeing cleared on target change.";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cffff0000SHIFT + LeftClick |cffffffffdeletes the bar, |cffff0000ALT + LeftClick |cffffffffdeletes all bars\n\n";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."|cffff0000SHIFT + RightClick |cffffffffdisables the Spell! |cffff0000ALT + RightClick |cffffffffdisables the Color!";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb disabled |cfffffffflists disabled spells.";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb restore |cffffffffrestores ALL disabled spells!";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb enable |cffffff99spell |cffffffffor |cffffff99No. |cffffffffremoves the spell from the list of disabled spells!";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb disable |cffffff99spell |cffffffffadds the spell to the list of disabled spells!\n\n";

			CEnemyCastBarHelp[4] = "|cff00ff00/necb |cffff0000forcebc|cffffff99 Raidmember |cffffffffwill force '|cffffff99Raidmember|cffffffff' to broadcast CastBars by changing his/her settings! (Assist/Leader)";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb stopbc |cffffff99Raidmember |cffffffffstops broadcasting Bars! (Assist/Leader)\n|cffffff99Hint:|cffffffff Instead of using '|cffffff99Raidmember|cffffffff' you may simply target the player.\n\n";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."|cffffff99LeftClick|cffffffff on the 'movable bar' Button fastly to increase the bars duration up to 5 Minutes. |cffffff99RightClick|cffffffff on it to clear all bars.";

		if (myAddOnsFrame_Register) then

			CEnemyCastBarDetails = { 
				name = "CEnemyCastBar", 
				version = CECB_status_version_txt, 
				releaseDate = "2007", 
				author = "Naturfreund", 
				email = "Use my forum or curse-gaming.com", 
				website = "http://www.digital-joker.de/forum", 
				category = MYADDONS_CATEGORY_COMBAT
				};

			myAddOnsFrame_Register(CEnemyCastBarDetails, CEnemyCastBarHelp); 
		end 
                
		-- new variables for new versions
		if (CEnemyCastBar.bParseC == nil) then CEnemyCastBar.bParseC = true; end
		if (CEnemyCastBar.bGains == nil) then CEnemyCastBar.bGains = true; end
		if (CEnemyCastBar.bFlashit == nil) then CEnemyCastBar.bFlashit = true; end
		if (CEnemyCastBar.bGlobalFrag == nil) then CEnemyCastBar.bGlobalFrag = true; end
		if (CEnemyCastBar.bSpace == nil) then CEnemyCastBar.bSpace = 15; end
		if (CEnemyCastBar.bMiniMap == nil or (CEnemyCastBar.bMiniMap ~= false and CEnemyCastBar.bMiniMap ~= 0) ) then
			CEnemyCastBar.bMiniMap = true;
		else 	CEnemyCastBar.bMiniMap = false;
		end
		if (not CEnemyCastBar.bMiniMapPos) then CEnemyCastBar.bMiniMapPos = 356; end
		if (not CEnemyCastBar.bMiniMapRadius) then CEnemyCastBar.bMiniMapRadius = 80; end
		if (CEnemyCastBar.bShowIcon == nil) then CEnemyCastBar.bShowIcon = true; end
		if (CEnemyCastBar.bnecbCBLBias == nil) then CEnemyCastBar.bnecbCBLBias = 20; end
		if (CEnemyCastBar.bCDown == nil) then CEnemyCastBar.bCDown = true; end
		if (CEnemyCastBar.bSmallTSize == nil) then CEnemyCastBar.bSmallTSize = true; end
		if (CEnemyCastBar.bSoloD == nil) then CEnemyCastBar.bSoloD = true; end
		if (CEnemyCastBar.bDRTimer == nil) then CEnemyCastBar.bDRTimer = true; end
		if (CEnemyCastBar.bClassDR == nil) then CEnemyCastBar.bClassDR = true; end
		if (CEnemyCastBar.bSDoTs == nil) then CEnemyCastBar.bSDoTs = true; end
		if (CEnemyCastBar.bPvEWarn == nil) then CEnemyCastBar.bPvEWarn = true; end
		if (CEnemyCastBar.bMouseBar == nil) then -- settings for upgrade to 5.7.0
			CEnemyCastBar.bMouseBar = true; CEnemyCastBar.bDisBorder = true; CEnemyCastBar.bBarTexture = 0;
			CEnemyCastBar.bSpace = 15; CEnemyCastBar.bAlpha = 0.8; CEnemyCastBar.bnecbCBLBias = 20;
		end
		if (CEnemyCastBar.bBossDebuff == nil) then CEnemyCastBar.bBossDebuff = true; end

		if (CEnemyCastBar.tColor == nil) then CEnemyCastBar_SetBarColors();
		else
			if (CEnemyCastBar.tColor[8] == nil) then table.insert(CEnemyCastBar.tColor, 7, { 0.5, 0.2, 0.1 } ); end
			if (CEnemyCastBar.tColor[9] == nil) then table.insert(CEnemyCastBar.tColor, 5, { 0.7, 0, 0.85 } ); end
			if (CEnemyCastBar.tColor[10] == nil) then CEnemyCastBar.tColor[10] = { 0.5, 1, 0.5 }; CEnemyCastBar.tColor[11] = { 1,0,0 }; CEnemyCastBar.tColor[12] = { 0,0,1 }; CEnemyCastBar.tColor[13] = { 0, 0.3, 0 }; end
			if (CEnemyCastBar.tColor[14] == nil) then CEnemyCastBar.tColor[14] = { 1, 1, 1 }; end
			if (#CEnemyCastBar.tColor ~= 14) then
				CEnemyCastBar_SetBarColors(); -- reset, something has gone wrong
			end
		end

		if (not CEnemyCastBar.tDisabledSpells) then CEnemyCastBar.tDisabledSpells = { }; end
		if (not CEnemyCastBar.bNumBarsSep) then CEnemyCastBar.bNumBarsSep = 4; end
		if (not CEnemyCastBar.bBarFont) then CEnemyCastBar.bBarFont = 0; end
		if (CEnemyCastBar.bFocusPvP == nil) then CEnemyCastBar.bFocusPvP = true; CEnemyCastBar.bFocusDebuffs = true; end
		if (CEnemyCastBar.bFillupGains == nil) then CEnemyCastBar.bFillupGains = true; CEnemyCastBar.bFillupDebuffs = true; CEnemyCastBar.bFillupDoTs = true; end
		if (CEnemyCastBar.bPvPSoundWarn == nil) then CEnemyCastBar.bPvPSoundWarn = true; end
		if (CEnemyCastBar.bTimerInside == nil) then CEnemyCastBar.bTimerInside = true; end
		if (CEnemyCastBar.bTargetIcon == nil) then CEnemyCastBar.bTargetIcon = true; end
		if (CEnemyCastBar.bKSoundPvP == nil) then CEnemyCastBar.bKSoundPvP = true; CEnemyCastBar.bKSoundPvE_grouped = true; end
		if (CEnemyCastBar.bturnDoTs == nil) then CEnemyCastBar.bturnDoTs = true; end


		-- initialize addon from settings now
		if (CEnemyCastBar.bTempFPSBar) then
			CECB_FPSBarFree:Show();
		end
		if (CEnemyCastBar.bFPSBarLocked) then
			CECB_FPSBarFree:EnableMouse(0);
		end
		if (CEnemyCastBar.bTempLatencyBar) then
			CECB_LatencyBarFree:Show();
		end
		if (CEnemyCastBar.bLatencyBarLocked) then
			CECB_LatencyBarFree:EnableMouse(0);
		end
		if (CEnemyCastBar.bSeparateBars) then
			CEnemyCastBar.bNumBars = CEnemyCastBar.bNumBarsSep * 9;
		end
		if (not CEnemyCastBar.tFramePoints) then
			NECBCreateBars(); -- CREATE castbar buttons to catch their points in entering_world, before their points were cleared (because they were not found if loaded on entering_world)
		end

		-- all called in NECBCreateBars(); and because at least some bars are created those functions will be called!
			-- and because the layout cache is loaded after variables I have to move the initialization into entering_world for non seperated!!! took me hours to understand :O
			--CEnemyCastBar_FlipBars();
			--CEnemyCastBar_SetTextSize();
			--CEnemyCastBar_SetBorder();
			--CEnemyCastBar_SetTexture();
			--CEnemyCastBar_SetIcon();
			--CEnemyCastBar.bLocked = true; -- remove if lock-option is inserted again
			--CEnemyCastBar_LockPos();
		CECBownCPsHit = 5; -- Set Combopoints to max for all classes, Rogue/DruidClass will fire an event to change this dynamically

		-- fire this one to fix wrongly assigned CEnemyCastBar.bSpellBreaks!
		NECB_SetInterruptCheck();

		-- show/hide Minimap button and set localized tooltip
		if (CEnemyCastBar.bMiniMap) then

			if (not CEnemyCastBar.bStatus) then
				CECBMiniMapButtonTexture:SetTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\CECBButton_off");
			end
			CECBMiniMapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (CEnemyCastBar.bMiniMapRadius * cos(CEnemyCastBar.bMiniMapPos)), (CEnemyCastBar.bMiniMapRadius * sin(CEnemyCastBar.bMiniMapPos)) - 52);
			CECBMiniMapButton:Show();
		else
			CECBMiniMapButton:Hide();
		end

 		-- variables for the addon channel parser
		necb_numspellcast = 0; necb_parserline = 0;
		for i=1, 85 do
			table.insert (NECBParserCollect, "|cffcccccc- |cff666666"..i.."|cffcccccc -");
		end
		table.insert (NECBParserCollect, " ");
		table.insert (NECBParserCollect, "|r==================================");
		table.insert (NECBParserCollect, "|cffffff00Welcome to the NECB AddOn Channel Parser!");
		table.insert (NECBParserCollect, "This parser displays all NECB commands/broadcasts received by your client.");
		table.insert (NECBParserCollect, " ");
		table.insert (NECBParserCollect, "It follows this pattern:");
		table.insert (NECBParserCollect, "|cffffaaaaBroadcaster: |cffccccccDetected AddOn Message [, ClientLanguage, Latency]|cffffff00");
		table.insert (NECBParserCollect, "|cffccccccgrey|cffffff00 = automatic message; |cff66ff66green|cffffff00 = triggered by user input");
		table.insert (NECBParserCollect, "|cffffaaaa(|cffffffffS|cffffaaaa)|cffffff00 = Sender who triggered a castbar for you. |cffffaaaa(|cffccccccC|cffffaaaa)|cffffff00 = Wrong client!");
		table.insert (NECBParserCollect, "|cffffaaaa(|cffffff00n|cffffaaaa)|cffffff00 = n useless broadcasts of this spell event.|cffffff00");
		table.insert (NECBParserCollect, " ");
		table.insert (NECBParserCollect, "100 lines are buffered. Use up/down at topright to scroll the lines.");
		table.insert (NECBParserCollect, "I tried to make it work like the default chatframe :D");
		table.insert (NECBParserCollect, "|r==================================");
		table.insert (NECBParserCollect, " ");

		if (not CEnemyCastBar.bAllowParser) then
			CECBCTRAParserFrameTextDis:Show();
		end
		-- necb parser finished

		necbEPTime = 180; -- Duration (in s) until the Engage Protection is shut off

	end
	
end

function NECB_OnEvent_Global_ChatMsgs(event)
	
	if (event == "CHAT_MSG_ADDON") then
	
		if (arg1 == "NECB" or arg1 == "NECBCHAT" or arg1 == "NECBCTRA") then

			-- necb network infos + calls the parse function: CEnemyCastBar_Parse_RaidChat(arg2, arg4, arg1="NECB, NECBCHAT, NECBCTRA");

			local msg = arg2;
			local msgsender = arg4;

			local necbcmdcheck, necbtcolor, wrongclient = CEnemyCastBar_Parse_RaidChat(msg, msgsender, arg1); -- calls the parse function!
			if (not necbtcolor) then
				necbtcolor = "|cffcccccc";
			end
			if (CEnemyCastBar.bAllowParser and necbcmdcheck) then

				if ( NECBParserCollect[100] ) then
					table.remove (NECBParserCollect, 1);
				end

				local startpos;
				if (string.sub (msg, 1, 11) == ".cecbspell ") then
					startpos = 12;
					if (necb_numspellcast == 99) then
						necb_numspellcast = 0;
						numsender = " (|cffffffffS|cffffaaaa):";
					elseif (wrongclient) then
						numsender = " (|cffccccccC|cffffaaaa):";
					elseif (necb_numspellcast > 0 and msgsender ~= UnitName("player")) then
						numsender = " (|cffffff00"..necb_numspellcast.."|cffffaaaa):";
					else
						numsender = ":";
					end

				elseif (string.sub (msg, 1, 7) == "<NECB> ") then
					startpos = 8;
					numsender = ":";
					
				else
					startpos = 1;
					numsender = ":";
				end

				-- reduce length of line
				local i, cropped = 0, "";
				CECBParserFauxText:SetText("|cffffaaaa"..msgsender..numsender.." |cffcccccc"..string.sub (msg, startpos, string.len (msg)));

				while (CECBParserFauxText:GetStringWidth() > 410) do
					i = i + 1;
					CECBParserFauxText:SetText("|cffffaaaa"..msgsender..numsender.." |cffcccccc"..string.sub (msg, startpos, string.len (msg) -i));
				end

				if (i ~= 0) then
					cropped = "|cffffaaaa...";
				else
					cropped = "";
				end

				table.insert (NECBParserCollect, "|cffffaaaa"..msgsender..numsender.." "..necbtcolor..string.sub (msg, startpos, string.len (msg) -i)..cropped);

				if (CECBParser) then
					if (necb_parserline == 0) then
						CEnemyCastBar_ParserOnClick();
					else
						CECBCTRAParserFrameBOTTOMArrowFlash:Show();
						CEnemyCastBar_ParserOnClick("up");
					end
				end

			end
		end --of "CHAT_MSG_ADDON" block

	else
		CEnemyCastBar_Gfind(arg1, event)

	end
end


function CEnemyCastBar_ParserOnClick(msg)

	if (msg) then
		if ((msg == "down" or msg == -1) and necb_parserline < 0) then
			necb_parserline = necb_parserline + 1;
	
		elseif ((msg == "up"  or msg == 1) and necb_parserline > -80) then
			necb_parserline = necb_parserline - 1;
	
		elseif (msg == 0) then
			necb_parserline = 0;
			CECBCTRAParserFrameUPArrow:Enable();
		end

		if (necb_parserline == -80) then
			CECBCTRAParserFrameUPArrow:Disable();
		elseif (necb_parserline == 0) then
			CECBCTRAParserFrameDOWNArrow:Disable();
			CECBCTRAParserFrameBOTTOMArrow:Disable();
			CECBCTRAParserFrameBOTTOMArrowFlash:Hide();
		else
			CECBCTRAParserFrameUPArrow:Enable();
			CECBCTRAParserFrameDOWNArrow:Enable();
			CECBCTRAParserFrameBOTTOMArrow:Enable();
		end
	end

	CECBCTRAParserFrameLineText:SetText(necb_parserline);
	local parserstring = table.concat (NECBParserCollect, "\n", 81 + necb_parserline, 100 + necb_parserline);
	CECBCTRAParserFrameBGText:SetText(parserstring);
	
end

function CEnemyCastBar_ParserButton_OnUpdate(elapsed)
	if (this:GetButtonState() == "PUSHED") then
		this.clickDelay = this.clickDelay - elapsed;
		if ( this.clickDelay < 0 ) then
			local name = this:GetName();
			if ( name == this:GetParent():GetName().."DOWNArrow" ) then
				CEnemyCastBar_ParserOnClick("down");
			elseif ( name == this:GetParent():GetName().."UPArrow" ) then
				CEnemyCastBar_ParserOnClick("up");
			end
			this.clickDelay = MESSAGE_SCROLLBUTTON_SCROLL_DELAY;
		end
	end
end

function CEnemyCastBar_DelBar(msg, type) --delbar, delete castbar by label

	for i=1, CEnemyCastBar.bNumBars do

		local button = getglobal("Carni_ECB_"..i);
		if (button.label and string.match(button.label, msg) and not (type and not (button.ctype == "friendly" or button.ctype == "hostile")) ) then
				CEnemyCastBar_HideBar(i);
		end
	end
end

function CEnemyCastBar_HideBar(num, shiftright, useradd) --hide + disable spells

	local button;

	if (num) then
		button = getglobal("Carni_ECB_"..num);
	end

	if (shiftright or useradd) then
		local disabled = false;
		local spell;

		if (useradd) then
			spell = useradd;
		elseif (shiftright == "delcolor") then
			spell = "Bartype "..button.ctype;
		else
			spell = button.spell;
			spell = string.gsub(spell, " %(D%)", "");
			if (spell ~= CECB_SPELL_FRENZY_CD) then
				spell = string.gsub(spell, " %(CD%)", "");
			end
		end

		if (spell ~= CECB_SPELL_STUN_DR and not string.find(spell, "DR:") ) then

			if (CEnemyCastBar_Raids[spell]) then
				CEnemyCastBar_Raids[spell].disabled = true;
				disabled = true;
			end
	
			if (CEnemyCastBar_Spells[spell]) then
				CEnemyCastBar_Spells[spell].disabled = true;
				disabled = true;
			end
	
			if (CEnemyCastBar_Afflictions[spell]) then
				CEnemyCastBar_Afflictions[spell].disabled = true;
				disabled = true;
			end

			if (CEnemyCastBar_Colors[spell]) then
				CEnemyCastBar_Colors[spell].disabled = true;
				disabled = true;
				local color = string.match(spell, "Bartype (.+)");
				for i=1, CEnemyCastBar.bNumBars do --getthrough
					if (getglobal("Carni_ECB_"..i).ctype == color) then
						CEnemyCastBar_HideBar(i);
					end
				end
			end
		end

		if (disabled) then
			local spellexists = false;
			for i=1, #CEnemyCastBar.tDisabledSpells do
				if (CEnemyCastBar.tDisabledSpells[i] and CEnemyCastBar.tDisabledSpells[i] == spell) then
					spellexists = true;
					break;
				end
			end

			if (spellexists) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Spell or Color already disabled!");
			else
				table.insert (CEnemyCastBar.tDisabledSpells, spell);
				local color = "|cffffff00";
				if (string.match(spell, "Bartype")) then
					color = "|cffff9900";
				end
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Disabled \""..color..spell.."|r\" (|cffffff00".. #CEnemyCastBar.tDisabledSpells .."|r total).");
				if (not necbdisabledyell) then
					necbdisabledyell = true;
				end
			end
		else
			if (num and button.ctype == "grey" ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rManual timers are not allowed to disable spells!");
			else
				if (useradd) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Entered Spell not found! |r(Spellname is case sensitive.)");
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Spell not found! |rMaybe it was a DR of some spell?");
				end
			end
		end
	end

	if (num) then
		button:Hide();
		--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Deleted \""..button.label.."\"");
		button.spell = false;
		button.mob = false;
		button.ctype = false;
		button.label = false;
		button.channeling = false;
		button.activeHoTEnd = false;

		button.faded = false;
		button.updater = 0; -- force update
		button.stack = false;

		getglobal(button:GetName() .. "_StatusBar_SparkHoT"):Hide();
		getglobal(button:GetName() .. "_FixedIcon"):Hide();
		getglobal(button:GetName() .. "_IconStack"):SetText();
	end
	
end

function CEnemyCastBar_LockPos() --lockpos
	
	CEnemyCastBar.bLocked = not CEnemyCastBar.bLocked;

	if (CEnemyCastBar.bLocked) then

		local i=1;
		while (getglobal("Carni_ECB_"..i)) do

			local frame = getglobal("Carni_ECB_"..i);
			frame:StopMovingOrSizing();
			if (CEnemyCastBar.bMouseBar) then
				frame:EnableMouse(1);
			else
				frame:EnableMouse(0);
			end

			-- write positions, clear userplaced
			if (frame:IsUserPlaced() ) then
				local point,_,_,x,y = frame:GetPoint();
				CEnemyCastBar.tFramePoints[frame:GetName()] = { x, y, point };
				frame:SetUserPlaced(false);
			end
		i=i+1;
		end

	else

		local i=1;
		while (getglobal("Carni_ECB_"..i)) do
	
			local frame = getglobal("Carni_ECB_"..i);

			if (CEnemyCastBar.bSeparateBars) then
				--if (i==1 or i==6 or i==11 or i==16 or i==21 or i==26 or i==31 or i==36 or i==41) then --old code
				if (i % CEnemyCastBar.bNumBarsSep == 1 or CEnemyCastBar.bNumBarsSep == 1) then
					frame:EnableMouse(1);
				else
					frame:EnableMouse(0);
				end

			elseif (i==1) then
				frame:EnableMouse(1);
			else
				frame:EnableMouse(0);
			end
		i=i+1;
		end	

	end
	
end

function CEnemyCastBar_ResetPos() --resetpos

	local i=1;
	while (getglobal("Carni_ECB_"..i)) do
			CEnemyCastBar_HideBar(i);
			getglobal("Carni_ECB_"..i):SetUserPlaced(false);
			getglobal("Carni_ECB_"..i):ClearAllPoints();
	i=i+1;
	end

	--reset database
	for k,v in pairs (CEnemyCastBar.tFramePoints) do
		if (k ~= "CECB_FPSBarFree" and k ~= "CECB_LatencyBarFree") then
			CEnemyCastBar.tFramePoints[k] = nil;
		end
	end

	getglobal("Carni_ECB_1"):SetPoint("TOPLEFT", "UIParent", "TOPLEFT", 50, -500); -- set in xml by parent frame
	local point,_,_,x,y = getglobal("Carni_ECB_1"):GetPoint();
	CEnemyCastBar.tFramePoints["Carni_ECB_1"] = { x,y,point };
	CEnemyCastBar_FlipBars(); -- reorder frame
end

function CEnemyCastBar_FlipBars() --flipbars; sets the SPACE, ICONSIZE and BarLength, too! Called when variables loaded

	local o=1;
	while (getglobal("Carni_ECB_"..o)) do

		local i = o + 1;
		if (getglobal("Carni_ECB_"..i)) then
			local frame = getglobal("Carni_ECB_"..i);
			local factor = 1;
			if (CEnemyCastBar.bFlipB) then
				factor = -1;
			end
			if (CEnemyCastBar.bSeparateBars) then
				--if (not (i==6 or i==11 or i==16 or i==21 or i==26 or i==31 or i==36 or i==41)) then -- old code
				-- still needed for flipbars etc.
				if (i % CEnemyCastBar.bNumBarsSep ~= 1 and CEnemyCastBar.bNumBarsSep ~= 1) then
					frame:SetPoint("TOPLEFT", "Carni_ECB_"..o, "TOPLEFT", 0, factor*CEnemyCastBar.bSpace);
				end
			else
				frame:SetPoint("TOPLEFT", "Carni_ECB_"..o, "TOPLEFT", 0, factor*CEnemyCastBar.bSpace);
			end
		end

		--local buttonicon = getglobal("Carni_ECB_"..o.."_Icon");
		--buttonicon:SetHeight(CEnemyCastBar.bSpace);
		--buttonicon:SetWidth(CEnemyCastBar.bSpace);
		--buttonicon:SetPoint("LEFT", "Carni_ECB_"..o, "LEFT", -CEnemyCastBar.bSpace + 4, 1);

		-- set bar length
		getglobal("Carni_ECB_"..o):SetWidth(206 + CEnemyCastBar.bnecbCBLBias);
		getglobal("Carni_ECB_"..o.."_Border"):SetWidth(205 + CEnemyCastBar.bnecbCBLBias);
		getglobal("Carni_ECB_"..o.."_StatusBar"):SetWidth(195 + CEnemyCastBar.bnecbCBLBias);

		getglobal("Carni_ECB_"..o.."_Text"):ClearAllPoints();
		getglobal("Carni_ECB_"..o.."_CastTimeText"):ClearAllPoints();
		getglobal("Carni_ECB_"..o.."_TargetIcon"):ClearAllPoints();
		getglobal("Carni_ECB_"..o.."_FocusIcon"):ClearAllPoints();
		if (CEnemyCastBar.bTimerInside) then

				getglobal("Carni_ECB_"..o.."_Text"):SetPoint("LEFT", "Carni_ECB_"..o, "LEFT", 8, 2);
				getglobal("Carni_ECB_"..o.."_Text"):SetJustifyH("LEFT");
				if (CEnemyCastBar.bDisBorder) then
					getglobal("Carni_ECB_"..o.."_Text"):SetWidth(160 + CEnemyCastBar.bnecbCBLBias);
					getglobal("Carni_ECB_"..o.."_CastTimeText"):SetPoint("RIGHT", "Carni_ECB_"..o, "RIGHT", -6, 2);

				else
					getglobal("Carni_ECB_"..o.."_Text"):SetWidth(156 + CEnemyCastBar.bnecbCBLBias);
					getglobal("Carni_ECB_"..o.."_CastTimeText"):SetPoint("RIGHT", "Carni_ECB_"..o, "RIGHT", -10, 2);
				end
				getglobal("Carni_ECB_"..o.."_TargetIcon"):SetPoint("LEFT", "Carni_ECB_"..o.."_CastTimeText", "RIGHT", 4, 0);
				getglobal("Carni_ECB_"..o.."_FocusIcon"):SetPoint("LEFT", "Carni_ECB_"..o.."_CastTimeText", "RIGHT", 4, 0);
				getglobal("Carni_ECB_"..o.."_CastTimeText"):SetJustifyH("RIGHT");
				if (not CEnemyCastBar.bTimer) then
						getglobal("Carni_ECB_"..o.."_Text"):SetWidth(190 + CEnemyCastBar.bnecbCBLBias);
				end
		else
				getglobal("Carni_ECB_"..o.."_Text"):SetWidth(190 + CEnemyCastBar.bnecbCBLBias);
				getglobal("Carni_ECB_"..o.."_Text"):SetPoint("CENTER", "Carni_ECB_"..o, "CENTER", 0, 2);
				getglobal("Carni_ECB_"..o.."_Text"):SetJustifyH("CENTER");
				if (CEnemyCastBar.bTargetIcon or CEnemyCastBar.bFocusDebuffs or CEnemyCastBar.bFocusPvP) then
					getglobal("Carni_ECB_"..o.."_CastTimeText"):SetPoint("LEFT", "Carni_ECB_"..o, "LEFT", 202 + 16 + CEnemyCastBar.bnecbCBLBias, 2);
				else
					getglobal("Carni_ECB_"..o.."_CastTimeText"):SetPoint("LEFT", "Carni_ECB_"..o, "LEFT", 202 + CEnemyCastBar.bnecbCBLBias, 2);
				end
				getglobal("Carni_ECB_"..o.."_TargetIcon"):SetPoint("LEFT", "Carni_ECB_"..o.."_CastTimeText", "LEFT", -16, 0);
				getglobal("Carni_ECB_"..o.."_FocusIcon"):SetPoint("LEFT", "Carni_ECB_"..o.."_CastTimeText", "LEFT", -16, 0);
				getglobal("Carni_ECB_"..o.."_CastTimeText"):SetJustifyH("LEFT");
		end

		getglobal("Carni_ECB_"..o):SetScale(CEnemyCastBar.bScale);
		getglobal("Carni_ECB_"..o).updater = 0; -- initialise every bar for update intervalls

		-- fix for line breaks and cropped lines
		local barh = 14;
		if (CEnemyCastBar.bScale < 1 ) then -- remove 'string.sub' part after patch 2.2 release: removed: or string.sub(GetBuildInfo(),1,3) == "2.1" 
				barh = 8;
		end
		getglobal("Carni_ECB_"..o.."_Text"):SetHeight(barh);
		getglobal("Carni_ECB_"..o.."_CastTimeText"):SetHeight(barh);

	o=o+1;
	end
end

function CEnemyCastBar_SetTextSize() --settextsize, called when variables loaded

	local i, size = 1;
	while (getglobal("Carni_ECB_"..i)) do
		if (CEnemyCastBar.bSmallTSize) then
			size = 10;
		else
			size = 12;			
		end

		if ((CEnemyCastBar.bBarFont + 1) > #NECB_Fonts) then CEnemyCastBar.bBarFont = 0; end -- prevent LUA error on conversion to new system (for asian clients)

		getglobal("Carni_ECB_"..i.."_Text"):SetFont(NECB_Fonts[CEnemyCastBar.bBarFont + 1].path, size);
		getglobal("Carni_ECB_"..i.."_CastTimeText"):SetFont(NECB_Fonts[CEnemyCastBar.bBarFont + 1].path, size);
		CECB_FPSBarFree_Text:SetFont(NECB_Fonts[CEnemyCastBar.bBarFont + 1].path, 12);
		CECB_LatencyBarFree_Text:SetFont(NECB_Fonts[CEnemyCastBar.bBarFont + 1].path, 12);
	i=i+1;
	end
end

function CEnemyCastBar_SetBorder() --called when variables loaded

	local i=1;
	while (getglobal("Carni_ECB_"..i)) do
		local border = getglobal("Carni_ECB_"..i.."_Border");
		if (CEnemyCastBar.bDisBorder) then
			border:Hide();
			CECB_FPSBarFree_Border:Hide(); --fps bar
			CECB_LatencyBarFree_Border:Hide(); --Latency bar
		else
			border:Show();
			CECB_FPSBarFree_Border:Show(); --fps bar
			CECB_LatencyBarFree_Border:Show(); --Latency bar

		end
	i=i+1;
	end
end

function CEnemyCastBar_SetIcon() --called when variables loaded

	local i=1;
	while (getglobal("Carni_ECB_"..i)) do
		if (CEnemyCastBar.bShowIcon) then
			getglobal("Carni_ECB_"..i.."_Icon"):Show();
			getglobal("Carni_ECB_"..i.."_FixedIcon"):SetPoint("LEFT", "Carni_ECB_"..i.."_StatusBar", "LEFT", -32, 0);

			getglobal("Carni_ECB_"..i.."_IconStack"):Show();
		else
			getglobal("Carni_ECB_"..i.."_Icon"):Hide();
			getglobal("Carni_ECB_"..i.."_FixedIcon"):SetPoint("LEFT", "Carni_ECB_"..i.."_StatusBar", "LEFT", -16, 0);

			getglobal("Carni_ECB_"..i.."_IconStack"):Hide();
		end
	i=i+1;
	end
end

function CEnemyCastBar_SetTexture() --settexture called when variables loaded

	local i=1;
	while (getglobal("Carni_ECB_"..i)) do
		local statusbar = getglobal("Carni_ECB_"..i.."_StatusBar");
		statusbar:SetStatusBarTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\bartex"..CEnemyCastBar.bBarTexture);
		getglobal("Carni_ECB_"..i.."_StatusBar_SparkHoT"):SetVertexColor(0.3, 1.0, 0.3); --* give it a green touch p2.1.0
	i=i+1;
	end
	CECB_FPSBarFree_StatusBar:SetStatusBarTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\bartex"..CEnemyCastBar.bBarTexture); --fps bar
	CECB_LatencyBarFree_StatusBar:SetStatusBarTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\bartex"..CEnemyCastBar.bBarTexture); --Latency bar
end

function CEnemyCastBar_Boolean(var)

	if (var) then
		return "on";	
	else
		return "off";
	end
end

function CEnemyCastBar_Handler(msg) --Handler

	if (msg == "help" or msg == "?") then

		if (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - HELP" ) then
			CECBHELPFrame:Hide();
		else

			CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb help\n\n" .. table.concat (CEnemyCastBarHelp, "") );
			CECBHELPFrame:SetHeight(300); -- 465 before
			CECBHELPFrameScrollFrame:SetHeight(CECBHELPFrame:GetHeight() - 45);
			CECBHELPFrameScrollFrameBorder:SetHeight(CECBHELPFrameScrollFrame:GetHeight() - 28);
			CECBHELPFrameScrollFrameBG:SetHeight(550); -- set size of help text frame
			CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);

			if (GetCurrentResolution() == 1) then
				CECBHELPFrameScrollFrameBG:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() + 50);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBGText:GetHeight() + 50);
			end

			CECBHELPFrameScrollFrame:UpdateScrollChildRect();

			CECBHELPFrameText:SetText("NECB - HELP");
			CECBHELPFrame:Show();
			CECBHELPFrameWhisper:Hide();
		end


	elseif (msg == "" or msg == nil) then

		local loaded, reason;
		if (CECBOptionsFrame) then
			loaded, reason = LoadAddOn("CECB_Options");
		else
			loaded, reason = LoadAddOn("CECB_Options");
			--collectgarbage("collect");
		end
		if (loaded) then

			if (CECBOptionsFrame:IsVisible()) then
				necbfademenue = 1;
			else
				NECB_calc_performa("reset"); -- set performance bar!
				CECBOptionsFrame:SetAlpha(0);
				necbfademenue = 2;
				CECB_ShowHideOptionsUI();
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_Options' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
		end

	elseif (msg == "gcinfo") then

		if (CECBGCFrame:IsVisible()) then
			CECBGCFrame:Hide();
			cecbgc_last = nil;
		else
			CECBGCFrame:Show();
			collectgarbage("collect"); --BC
		end

	-- see "printversions" in OPTIONS part!
	elseif (msg == "versions") then

		if (CEnemyCastBar.bStatus) then

			if (CEnemyCastBar.bParseC and (GetNumRaidMembers() ~= 0 or GetNumPartyMembers() ~= 0 or GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena() ) ) then
				CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb versions\n\n|cffaaaaaaNECB: |cffffff00Requesting Versions from Raidmembers! |cffff0000Please wait...");
				
				CECBHELPFrameWhisper:Hide();
				CECBHELPFrameText:SetText("NECB - VERSIONS");

				CECBHELPFrame:SetHeight(165);
				CECBHELPFrameScrollFrame:SetHeight(CECBHELPFrame:GetHeight() - 45);
				CECBHELPFrameScrollFrameBorder:SetHeight(CECBHELPFrameScrollFrame:GetHeight() - 28);
				CECBHELPFrameScrollFrameBG:SetHeight(120);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);
				CECBHELPFrameScrollFrame:UpdateScrollChildRect();
				CECBHELPFrame:Show();
	
				NECB_SendMessage("<NECB> Force version collection.");
	
			else
				if (not CEnemyCastBar.bParseC) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to enable NECB's channel parsing to use this!")
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group to use this command!")
				end
			end

		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Enable NECB to use this feature!")

		end

	-- see "printversions" in OPTIONS part!
	elseif (msg == "gversions") then

		if (CEnemyCastBar.bStatus) then

			if (CEnemyCastBar.bParseC and IsInGuild() ) then
				CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb gversions\n\n|cffaaaaaaNECB: |cffffff00Requesting Versions from Guildmembers! |cffff0000Please wait...");

				CECBHELPFrameWhisper:Hide();				
				CECBHELPFrameText:SetText("NECB - GVERSIONS");

				CECBHELPFrame:SetHeight(165);
				CECBHELPFrameScrollFrame:SetHeight(CECBHELPFrame:GetHeight() - 45);
				CECBHELPFrameScrollFrameBorder:SetHeight(CECBHELPFrameScrollFrame:GetHeight() - 28);
				CECBHELPFrameScrollFrameBG:SetHeight(120);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);
				CECBHELPFrameScrollFrame:UpdateScrollChildRect();
				CECBHELPFrame:Show();
	
				NECB_SendMessage("<NECB> Force gversion collection.", nil, "toguild");
	
			else
				if (not CEnemyCastBar.bParseC) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to enable NECB's channel parsing to use this!")
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Guild to use this command!")
				end
			end

		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Enable NECB to use this feature!")

		end

	elseif (msg == "parser") then

		if (CECBParser) then
	
			CECBParser = false;
			CECBCTRAParserFrame:Hide();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Broadcast Parser |cffff9999disabled")
	
		else
		
			CECBParser = true;
				CEnemyCastBar_ParserOnClick(0);
			CECBCTRAParserFrame:Show();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Broadcast Parser |cff99ff99temporary enabled")
		
		end

	elseif (msg == "clear") then		

		necblockshow = nil;

		if (not CEnemyCastBar.bLocked) then
			CEnemyCastBar_LockPos();
		end

		for i=1, CEnemyCastBar.bNumBars do

			CEnemyCastBar_HideBar(i);
		end

	elseif (msg == "restore") then		

		for k,v in pairs (CEnemyCastBar.tDisabledSpells) do

			if (CEnemyCastBar_Raids[v]) then
				CEnemyCastBar_Raids[v].disabled = nil;
			end
	
			if (CEnemyCastBar_Spells[v]) then
				CEnemyCastBar_Spells[v].disabled = nil;
			end
	
			if (CEnemyCastBar_Afflictions[v]) then
				CEnemyCastBar_Afflictions[v].disabled = nil;
			end

			if (CEnemyCastBar_Colors[v]) then
				CEnemyCastBar_Colors[v].disabled = nil;
			end
		end			

		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Restored (|cffffff00".. #CEnemyCastBar.tDisabledSpells .."|r) spells which were disabled.");
		CEnemyCastBar.tDisabledSpells = { };

	elseif (msg == "disabled") then

		local DSpells = "";
		local SpellsTotal = #CEnemyCastBar.tDisabledSpells;
		
		if (SpellsTotal == 0) then
			DSpells = "-.-";
		else
			for i=1, SpellsTotal do
				DSpells = DSpells .. table.concat (CEnemyCastBar.tDisabledSpells, "", i, i) .. " |cffffffff(|r" .. i .. "|cffffffff)";
				if (i < SpellsTotal ) then
					DSpells = DSpells .. "|cffff0000 | |r";
				end
			end
		end
		DSpells = string.gsub(DSpells, "Bartype", "|cffff9900Bartype");
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffffff Disabled Spells: |r"..DSpells, 1, 1, 0);

	elseif (msg == "cooldowns") then

		local DSpells = "";
		local SpellsTotal = #NECB_CD_DB;
		
		if (SpellsTotal == 0) then
			DSpells = "-.-";
		else
			for i=1, SpellsTotal do
				local CDLeft = floor (NECB_CD_DB[i][3] + NECB_CD_DB[i][4] - GetTime() );
				if ( CDLeft < 0 ) then
					CDLeft = 0;
				end
				DSpells = DSpells .. NECB_CD_DB[i][1] .. "|cffffffff - |r" .. NECB_CD_DB[i][2] .. " |cffffffff(|r" .. CDLeft .. "|cffffffff)|r";
				if (i < SpellsTotal ) then
					DSpells = DSpells .. "|cffff0000 | |r";
				end
			end
		end
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffffff Cooldowns: |r"..DSpells, 1, 1, 0);

	elseif (string.sub (msg, 1, 8) == "disable " and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 9, string.len(msg) );
		CEnemyCastBar_HideBar(nil, nil, msg1); -- Hidebar also used for disabled spell commands! Shift + Rightclick...

	elseif (string.sub (msg, 1, 7) == "enable " and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 8, string.len(msg) );
		local spellfound = false;

		local i = 1;
		while CEnemyCastBar.tDisabledSpells[i] do

			if (string.lower(CEnemyCastBar.tDisabledSpells[i]) == string.lower(msg1) or ( tonumber(msg1) and CEnemyCastBar.tDisabledSpells[tonumber(msg1)] ) ) then

					local spell;
					if (tonumber(msg1) and CEnemyCastBar.tDisabledSpells[tonumber(msg1)] ) then
						i = tonumber(msg1);
					end

					spell = CEnemyCastBar.tDisabledSpells[i];

					if (CEnemyCastBar_Raids[spell]) then
						CEnemyCastBar_Raids[spell].disabled = nil;
					end
			
					if (CEnemyCastBar_Spells[spell]) then
						CEnemyCastBar_Spells[spell].disabled = nil;
					end
			
					if (CEnemyCastBar_Afflictions[spell]) then
						CEnemyCastBar_Afflictions[spell].disabled = nil;
					end

					if (CEnemyCastBar_Colors[spell]) then
						CEnemyCastBar_Colors[spell].disabled = nil;
					end

				local color = "|r";
				if (string.match(CEnemyCastBar.tDisabledSpells[i], "Bartype")) then
					color = "|cffff9900";
				end
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffffff Restored Spell: ".. color .. table.concat (CEnemyCastBar.tDisabledSpells, "", i, i), 1, 1, 0);
				table.remove (CEnemyCastBar.tDisabledSpells, i);
				spellfound = true;
				--CEnemyCastBar_Handler("disabled");
				break;
			end
			i = i + 1;
		end

		if (not spellfound) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Spell not found!");
		end

	elseif (string.sub (msg, 1, 7) == "forcebc" and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 9, string.len(msg) );

		if (msg1 == "") then
			msg1 = UnitName("target");
		end

		if (msg1 == nil) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999No name specified and no target selected!")

		elseif (CEnemyCastBar_CheckRaidStatus( UnitName("player") ) == false ) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be leader or promoted to do this!")

		elseif (CEnemyCastBar_CheckRaidStatus( msg1 ) == nil ) then
			if (UnitInRaid("player") ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999The name/target you selected is not found in your raid!")
			else
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a RaidGroup!")
			end

		else
			NECB_SendMessage("<NECB> FORCE "..msg1.." to Broadcast! Change Settings!");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rForced |cffffff00"..msg1.." |rto broadcast!")
		end

	elseif (string.sub (msg, 1, 6) == "stopbc" and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 8, string.len(msg) );

		if (msg1 == "") then
			msg1 = UnitName("target");
		end

		if (msg1 == nil) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999No name specified and no target selected!")

		elseif (CEnemyCastBar_CheckRaidStatus( UnitName("player") ) == false ) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be leader or promoted to do this!")

		elseif (CEnemyCastBar_CheckRaidStatus( msg1 ) == nil ) then
			if (UnitInRaid("player") ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999The name/target you selected is not found in your raid!")
			else
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a RaidGroup!")
			end

		else
			NECB_SendMessage("<NECB> STOP "..msg1.." to Broadcast! Change Settings!");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rStopped broadcasts of |cffffff00"..msg1.." |r!")
		end

	elseif (string.sub (msg, 1, 9) == "countsec " or string.sub (msg, 1, 9) == "countmin ") then

		local msg1 = tonumber (string.match(msg, "(%d+)") );
		local msg2 = string.match(msg, msg1.." (.+)");

		if (msg1 > 999) then msg1 = 999; end

		if (not msg1 or msg1 < 0) then
	
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Invalid value to start the countdown!")
		
		else
		
			if (msg2 == nil) then
				msg2 = "Countdown";
			else
				msg2 = NECB_ChatJokers(msg2);
			end

			if (string.sub (msg, 1, 9) == "countsec ") then
				if ( CEnemyCastBar_UniqueCheck(msg2, msg1, "("..msg1.." Seconds)", nil, nil, nil, "grey") == 0 ) then
					CEnemyCastBar_Show("("..msg1.." Seconds)", msg2, msg1, "grey", nil, "INV_Misc_Bomb_03.blp");
				end
			else
				if ( CEnemyCastBar_UniqueCheck(msg2, msg1 * 60, "("..msg1.." Minutes)", nil, nil, nil,"grey") == 0 ) then
					CEnemyCastBar_Show("("..msg1.." Minutes)", msg2, msg1 * 60, "grey", nil, "INV_Misc_Bomb_03.blp");
				end
			end
		end
		
	elseif (string.sub (msg, 1, 7) == "repeat ") then

		local msg1 = tonumber (string.match(msg, "(%d+)") );
		local msg2 = string.match(msg, msg1.." (.+)");

		if (msg1 > 999) then msg1 = 999; end

		if (not msg1 or msg1 < 2) then
	
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Invalid value to start the countdown!")
		
		else

			if (msg2 == nil) then
				msg2 = "Repeater";
			else
				msg2 = "Repeater: "..NECB_ChatJokers(msg2);
			end
			if ( CEnemyCastBar_UniqueCheck(msg2, msg1, "("..msg1.." Seconds)", nil, nil, nil, "grey") == 0 ) then
				CEnemyCastBar_Show("("..msg1.." Seconds)", msg2, msg1, "grey", nil, "INV_Misc_Bomb_04.blp");
			end
		end
		
	elseif (string.sub (msg, 1, 10) == "stopcount ") then

		local msg1;
		local textlen = string.len (msg);
		if (textlen >= 11) then
			msg1 = string.sub (msg, 11, textlen);
		end

		if (msg1) then

			if (msg1 == "all") then
				msg1 = " ";
			else
				msg1 = NECB_ChatJokers(msg1);
			end

			local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
			if (CEnemyCastBar.bSeparateBars) then
				minbar, maxbar = 8 * CEnemyCastBar.bNumBarsSep + 1, 9 * CEnemyCastBar.bNumBarsSep; --41, 45
			end
			for i=minbar, maxbar do
			
				local button = getglobal("Carni_ECB_"..i);

				if (button.label and string.match (button.label, msg1) and button.ctype == "grey" ) then
						CEnemyCastBar_HideBar(i);
				end
			end
		end

	elseif (string.sub (msg, 1, 10) == "deletebar " and CEnemyCastBar.bStatus) then

		local msg1;
		local textlen = string.len (msg);
		if (textlen >= 11) then
			msg1 = string.sub (msg, 11, textlen);
		end

		if (msg1) then

			if (msg1 == "all") then msg1 = " ";
			end

			for i=1, CEnemyCastBar.bNumBars do

				local button = getglobal("Carni_ECB_"..i);

				if (button.label and string.match(button.label, msg1) and button.mob == UnitName("target") ) then
						CEnemyCastBar_HideBar(i);
				end
			end

		end

	elseif (string.sub (msg, 1, 8) == "showbar " and CEnemyCastBar.bStatus) then
	
		local spell;
		local textlen = string.len (msg);
		if (textlen >= 9) then
			spell = string.sub (msg, 9, textlen);
		end

		local mob = UnitName("target");
		if (not mob) then
			return;
		end

		if (CEnemyCastBar_Afflictions[spell]) then
			if (not UnitIsFriend("player", "target") ) then
				if (CEnemyCastBar_Afflictions[spell].periodicdmg) then
					CEnemyCastBar_Control(mob, spell, "periodicdmg", nil, "customdot");
				else
					CEnemyCastBar_Control(mob, spell, "afflicted");
				end
			end

		elseif (CEnemyCastBar_Spells[spell]) then
			if (UnitIsFriend("player", "target") ) then
				CEnemyCastBar_Control(mob, spell, "gains");
			end

		end
	
	elseif (string.sub (msg, 1, 5) == "chat " and CEnemyCastBar.bStatus) then

		if (GetNumPartyMembers() ~= 0 or GetNumRaidMembers() ~= 0 ) then
			local text;
			local textlen = string.len (msg);
			if (textlen >= 6) then
				text = string.sub (msg, 6, textlen);
				text = NECB_ChatJokers(text);
			end
			
			NECB_SendMessage(text, "CHAT");

		else 
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group to use NECB's Chat!")
		end

	elseif (msg == "setrange") then

		if (tonumber(GetCVar("CombatLogRangeFriendlyPlayers")) and tonumber(GetCVar("CombatLogRangeFriendlyPlayers")) > 50 ) then

			-- "allmax", "cmax", nil for defaults
			CEnemyCastBar_SetRange();
		else
			CEnemyCastBar_SetRange("allmax");
		end

	elseif (msg == "bhill" or msg == "western" or msg == "xfiles" or msg == "mkill" or msg == "lol" or msg == "jaws") then

		if (GetNumRaidMembers() ~= 0 or GetNumPartyMembers() ~= 0 ) then
			if (	(GetNumRaidMembers() ~= 0 and CEnemyCastBar_CheckRaidStatus( UnitName("player") ) == false)
				or (GetNumRaidMembers() == 0 and GetNumPartyMembers() ~= 0 and not UnitIsPartyLeader("player") )
			 ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be leader or promoted to do this!")

			else
				if (not NECB_Sound_Cooldown or GetTime() - NECB_Sound_Cooldown > 10) then
					if (msg == "bhill") then
						msg = "Benny Hill"; -- compatible to pre 7.1.6 NECBs
					end
					CEnemyCastBar_BHWipe(msg);
					NECB_SendMessage("<NECB> Play "..msg.." for us!");
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffffffLast Jingle was played less than 10 seconds ago. |cffffff00Please wait...")
				end
			end

		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group!")
		end

	elseif (msg == "debug") then

		if (NECBDebugMode) then
	
			NECBDebugMode = false;
			CarniEnemyCastBarFrame:UnregisterAllEvents();
			CEnemyCastBar_RegisterEvents("reg_main");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r DebugMode |cffffff99disabled")
		
		else
		
			NECBDebugMode = true;
			CarniEnemyCastBarFrame:RegisterAllEvents();
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r DebugMode |cffffff99enabled")
			NECB_create_patterns();

		end

	elseif (msg == "gettimer") then

		if (GetNumPartyMembers() ~= 0 or GetNumRaidMembers() ~= 0 ) then
			local pvespells;
			for k, v in pairs (CEnemyCastBar_Raids) do
				pvespells = true;
			end

			if (IsInInstance() or (UnitIsGhost("player") and pvespells) ) then
				NECB_requested_PvECDs = GetTime();
				NECB_SendMessage("<NECB> Gimme all your PvE Timers please. "..GetLocale());
				--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You requested cooldowns/respawn timers from your group/raid members!")
			else
				if (pvespells) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be a Ghost or to be in an Instance to request cooldowns/respawn timers! Otherwise the database inherits no spells.")
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You do not have any RaidSpells loaded! RespawnTimers will not be identified.")
				end
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group/Raid to request cooldowns/respawn timers!")
		end

	elseif (msg == "cpu") then

		if (GetCVar("scriptProfile") == "1") then
			SetCVar("scriptProfile" , "0");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r CPU Profiling |cffffff99disabled|r.")
		else
			SetCVar("scriptProfile" , "1");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r CPU Profiling |cffffff99enabled|r. NECB ToolTipp enhanced.")
		end
		ResetCPUUsage();

	else

		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff0000Unknown|r command '|cffffff00"..msg.."|r' entered! (try '|cff00ff00/necb help|r') :O")

	end
end

function NECB_ChatJokers(msg)

	if (UnitName("targettarget")) then
		msg = string.gsub(msg, "%%tt", (UnitName("targettarget")));
	else
		msg = string.gsub(msg, "%%tt", "[TargetTarget]");
	end

	if (UnitName("target")) then
		msg = string.gsub(msg, "%%t", (UnitName("target")));
		msg = string.gsub(msg, "%%c", (UnitClass("target")));

		if (string.match(msg, "%%g")) then
			local group = "[Group]";
			for i = 1, GetNumRaidMembers() do
				if ( (UnitName("raid" .. i)) == (UnitName("target")) ) then
					_, _, group, _, _, plfileName = GetRaidRosterInfo(i);
					break;
				end
			end
			msg = string.gsub(msg, "%%g", group);
		end
	else
		msg = string.gsub(msg, "%%t", "[Target]");
		msg = string.gsub(msg, "%%c", "[Class]");
	end

	if (UnitName("focus")) then
		msg = string.gsub(msg, "%%f", (UnitName("focus")));
	else
		msg = string.gsub(msg, "%%f", "[Focus]");
	end

	return msg;
end


function NECB_Check_PvECDs(author) --Internal

	local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
	if (CEnemyCastBar.bSeparateBars) then
		minbar, maxbar = 7 * CEnemyCastBar.bNumBarsSep + 1, 8 * CEnemyCastBar.bNumBarsSep; --36, 40 Cooldown Bars
	end

	local found;
	for i=minbar, maxbar do

		local button = getglobal("Carni_ECB_"..i);
		if (button.spell and CEnemyCastBar_Raids[button.spell] and CEnemyCastBar_Raids[button.spell].global and button.ctype == "cooldown") then -- PvE Cooldown

			local durpast = string.format("%.3f", (GetTime() - button.startTime) );
			local _,_,latency = GetNetStats();
			if (author) then
				SendAddonMessage("NECB", ".cecbspell "..button.mob..", "..button.spell..", st:"..durpast + (latency/1000)..", "..GetLocale()..", ".."gettimer", "WHISPER", author);
			else
				NECB_SendMessage(".cecbspell "..button.mob..", "..button.spell..", st:"..durpast + (latency/1000)..", "..GetLocale()..", ".."bctimer");
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffffffBroadcasted '|cffffff00"..spell.."|r' to your group/raid.");
			end
			found = true;
		end
	end
	return found;
end

-- Internal Handler -----------------------
function CEnemyCastBar_InternalHandler(msg) --Internal

	if (msg == "printversions") then

		NECBVersionDBTemp = { };

		if (NECBVersionDB and NECBVersionDB[1]) then
			for i=1, #NECBVersionDB do
				NECBVersionDB[i] = string.gsub (NECBVersionDB[i], "BC5.6.0", "5.6.0"); -- fix for old BC5.6.0 version transmits
				table.insert (NECBVersionDBTemp, "|cffaaaaaaNECB: |rVersion |cff00ff00"..NECBVersionDB[i].."|r is used by "..NECBVersionNames[i].."X Y Z.");
				NECBVersionDBTemp[i] = string.gsub (NECBVersionDBTemp[i], ", BCASTER", "");
			end


			table.sort (NECBVersionDBTemp);
			local counter, vcounter = 1, 1;
			while NECBVersionDBTemp[counter] do

				local o = counter + 1;
				if (NECBVersionDBTemp[o]) then
					local nextversion = string.match (NECBVersionDBTemp[o], "Version (.+) is used")
					local thisversion = string.match (NECBVersionDBTemp[counter], "Version (.+) is used")
	
					if (nextversion and thisversion and nextversion == thisversion) then
						local nextname = string.match (NECBVersionDBTemp[o], "is used by (.+).")
						table.remove (NECBVersionDBTemp, o);
						NECBVersionDBTemp[counter] = string.sub (NECBVersionDBTemp[counter], 1, string.len( NECBVersionDBTemp[counter] ) - 1 ) .. ", " ..nextname ..".";
						--DEFAULT_CHAT_FRAME:AddMessage("1)"..counter.." - "..NECBVersionDBTemp[counter]);
						counter = counter - 1;
						vcounter = vcounter + 1;

					else
						if (vcounter > 1) then
							NECBVersionDBTemp[counter] = NECBVersionDBTemp[counter] .. " (|cff00ff00" ..vcounter.. "|r Users)";
						end
						vcounter = 1;
						--DEFAULT_CHAT_FRAME:AddMessage("2)"..counter.." - "..NECBVersionDBTemp[counter]);
					end
	
				else
					if (vcounter > 1 and NECBVersionDBTemp[counter]) then
						NECBVersionDBTemp[counter] = NECBVersionDBTemp[counter] .. " (|cff00ff00" ..vcounter.. "|r Users)";
					end
						--DEFAULT_CHAT_FRAME:AddMessage("3)"..counter);
	
				end
				counter = counter + 1;	
			end

			-- calculate usage ratio
			local necb_ratio = "";
			if (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - GVERSIONS" ) then
				GuildRoster();
				if (GetNumGuildMembers() > 0) then
					necb_ratio = " -> |cff00ff00"..ceil(#NECBVersionDB / GetNumGuildMembers() * 100).."|cffffffff%";
				end
			elseif (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - VERSIONS" ) then
				if (GetNumRaidMembers() ~= 0) then
					necb_ratio = " -> |cff00ff00"..ceil(#NECBVersionDB / GetNumRaidMembers() * 100).."|cffffffff%";
				elseif (GetNumPartyMembers() ~= 0) then
					necb_ratio = " -> |cff00ff00"..ceil(#NECBVersionDB / (GetNumPartyMembers() + 1) * 100).."|cffffffff%";
				end
			end

			-- recolor
			for i=1, #NECBVersionDB do
				local necbbccolor = "|cffcccc00";
				if (string.find(NECBVersionDB[i], ", BCASTER") ) then
					necbbccolor = "|cff9999ff";
				end
				for o=1, #NECBVersionDBTemp do
					if (string.match(NECBVersionDBTemp[o], NECBVersionNames[i].."X Y Z") ) then
						NECBVersionDBTemp[o] = string.gsub(NECBVersionDBTemp[o], NECBVersionNames[i].."X Y Z", necbbccolor..NECBVersionNames[i].."|r");
					end
				end
			end

			-- set output text
			CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb (g)versions\n\n|cffaaaaaaNECB: |cffffff00Client versions which answered (|cff00ff00"..#NECBVersionDB.." |cfffffffftotal"..necb_ratio..", |cff9999ffblue|cffffff00 = broadcaster):\n\n");
			local necblinebreak = 0;

			for i=#NECBVersionDBTemp, 1, -1 do
				CECBHELPFrameScrollFrameBGText:SetText(CECBHELPFrameScrollFrameBGText:GetText()..NECBVersionDBTemp[i].."\n" );

				CECBParserFauxText:SetText(NECBVersionDBTemp[i]);
				if (CECBParserFauxText:GetStringWidth() > 420) then
					--DEFAULT_CHAT_FRAME:AddMessage(NECBVersionDBTemp[1]);
					necblinebreak = necblinebreak + floor(CECBParserFauxText:GetStringWidth() / 420);
				end
			end

			local necbpixellines = (#NECBVersionDBTemp + necblinebreak ) *10;
			--CECBHELPFrameText:SetText("NECB - VERSIONS");
			if (necbpixellines > 60) then
				necbpixellines = necbpixellines - 60;
				CECBHELPFrameScrollFrameBG:SetHeight(110 + necbpixellines);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() );
				CECBHELPFrameScrollFrame:UpdateScrollChildRect();
			end
			--CECBHELPFrame:Show();
			if (#NECBVersionDBTemp > 1) then
				CECBHELPFrameWhisper:Show();
			end

		else
			CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb (g)versions\n\n|cffaaaaaaNECB: |cffff0000Unknown error! No data found :/");
		end

	elseif (msg == "WhisperToObsolete") then

		-- only allow one notify per minute
		if (NECB_upd_notified and GetTime() - NECB_upd_notified < 60) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rThis feature may only be used once a minute. |cffffff00"..ceil(60-(GetTime() - NECB_upd_notified)).."|r secs to wait..")
			return;
		end

		local NECBVersionDBTemp = { };
		for i=1, #NECBVersionDB do
			table.insert (NECBVersionDBTemp, NECBVersionDB[i]);
			NECBVersionDBTemp[i] = string.gsub (NECBVersionDBTemp[i], ", BCASTER", "");
		end

		local necb_newest = " ";
		local necb_whispered;
		for i=1, #NECBVersionDBTemp do
			local necb_checked = string.sub( NECBVersionDBTemp[i], 1, string.len(NECBVersionDBTemp[i]) - 6 );
			if ( necb_checked > necb_newest) then
				necb_newest = necb_checked;
			end
		end

		for i=1, #NECBVersionDBTemp do
			local necb_checked = string.sub( NECBVersionDBTemp[i], 1, string.len(NECBVersionDBTemp[i]) - 6 );
			if ( necb_checked < necb_newest and NECBVersionNames[i] ~= UnitName("player") ) then
				if (not necb_whispered) then
					if (CECBHELPFrameText:GetText() == "NECB - GVERSIONS" ) then
						NECB_SendMessage("<NECB> Whisper old versions of NECB to update!", nil, "toguild");
					else
						NECB_SendMessage("<NECB> Whisper old versions of NECB to update!");
					end

					NECB_upd_notified = GetTime(); -- prevent players with lag to be able to spam
				end
				-- SendChatMessage("*** NECB: Your version ("..necb_checked..") is outdated! Update to the newest detected version ("..necb_newest..") please! ***", "WHISPER", nil, NECBVersionNames[i]);
				--* p2.1.0, new update whisper, because old system will be throttled

				local vold, vnewest = 0, 0;
				for digit in string.gmatch(necb_checked, "(%d+)") do vold = vold .. digit; end
				for digit in string.gmatch(necb_newest, "(%d+)") do vnewest = vnewest .. digit; end
				local warning = "";
				if (tonumber(vnewest) - tonumber(vold) > 100) then warning = "|cffff3333UTTERLY|cffcc99ff "; end
				SendAddonMessage("NECBCHAT","Your version |cffffff00NECB "..necb_checked.."|cffcc99ff is "..warning.."outdated! Update to the newest detected version |cffffff00"..necb_newest.."|cffcc99ff please! |cffaaaaaaDl: http://www.curse-gaming.com/downloads/details/2786/","WHISPER",NECBVersionNames[i]);
				necb_whispered = true;
			end
		end

		if (CECB_status_version_txt < necb_newest) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00Your own version (|cffff0000"..CECB_status_version_txt.."|cffffff00) is out of date! Newest: |cffff0000"..necb_newest)

		elseif (not necb_whispered) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Noone is using an outdated version!")
		end

	elseif (msg == "enable") then

		CEnemyCastBar.bStatus = true;
		CEnemyCastBar_RegisterEvents("reg_main");
		CECBMiniMapButtonTexture:SetTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\CECBButton");
		NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r AddOn |cff99ff99enabled|cffffffff. (Events |cff99ff99registered|cffffffff.)", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);
		--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r AddOn Core |cff99ff99enabled|cffffffff. Events |cff99ff99registered|cffffffff.")
		
	elseif (msg == "disable") then

		CEnemyCastBar_Handler("clear");
		CEnemyCastBar.bStatus = false;
		CEnemyCastBar_RegisterEvents("unreg_main");
		CECBMiniMapButtonTexture:SetTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\CECBButton_off");
		NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r AddOn |cffff9999disabled|cffffffff. (Events |cffff9999unregistered|cffffffff.)", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);
		--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r AddOn Core |cffff9999disabled|cffffffff. Events |cffff9999unregistered|cffffffff.")

	end
end


function CEnemyCastBar_WhisperButtonUpdater() --whisper button updater

	if (NECB_upd_notified and GetTime() - NECB_upd_notified < 60) then
		
		CECBHELPFrameWhisper:Disable();
		CECBHELPFrameWhisper:SetText(ceil(60 - (GetTime() - NECB_upd_notified)) );
		
	else
		CECBHELPFrameWhisper:Enable();
		CECBHELPFrameWhisper:SetText("Whisper old versions of NECB to update!");
	end
end


function CEnemyCastBar_CheckRaidStatus(checkplayer) -- check players raidstatus, leader or promoted -> 1,2 else false or nil

	local plrank, plfileName;
	for i = 1, GetNumRaidMembers() do
		if ( UnitName("raid" .. i) == checkplayer ) then
			_, plrank, _, _, _, plfileName = GetRaidRosterInfo(i);
			break;
		end
	end

	if (plrank == 0) then
		plrank = false;
	end

	return plrank, plfileName;

end

function CEnemyCastBar_BHWipe(song, author) --jingles

	local groupmaster = false;
	if (GetNumRaidMembers() == 0 ) then
		for i=1, GetNumPartyMembers() do
			if (UnitName("party" .. i) == author and UnitIsPartyLeader("party" .. i)) then
				groupmaster = true;
				break
			end
		end
	end

	if (not author or (author ~= UnitName("player") and
			 ((GetNumRaidMembers() ~= 0 and CEnemyCastBar_CheckRaidStatus(author)) or groupmaster)
								)
	 ) then
		if (not NECB_Sound_Cooldown or GetTime() - NECB_Sound_Cooldown > 10) then
			if (song == "bhill" or song == "Benny Hill") then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\BennyHill.mp3");
			elseif (song == "western") then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\NaturTheManWithAHarmonica.mp3");
			elseif (song == "xfiles") then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\NaturXFiles.mp3");
			elseif (song == "mkill") then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\monsterkill.mp3");
			elseif (song == "lol") then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\Lacher64kbitshort.mp3");
			elseif (song == "jaws") then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\NaturJaws64kbit.mp3");
			end
			NECB_Sound_Cooldown = GetTime();
		end
	end

end

function CEnemyCastBar_Show(mob, spell, castime, ctype, turnlabel, icontexture, starttime, DRText, falpha, channeling) --Show

 if (not necblockshow) then

	-- fix for non colored castbars with the new sorting routine ("Boss incoming" fix in general)
	if (not ctype) then
		ctype = "black";
	end

 	-- new "if" for separated feature
	local findctype, foundspace, firstused, insertpos;
	if (not CEnemyCastBar.bSeparateBars) then

		-- new magic sorting routine, don't ask me how it works ;P coded while in delirium
		for i=CEnemyCastBar.bNumBars, 1, -1 do
			local button = getglobal("Carni_ECB_"..i);
			if (not button.label ) then
				foundspace = true;
			elseif (not firstused) then
				firstused = i;
			end
			if (foundspace and button.ctype == ctype) then
				findctype = i;
				break;
			end
		end
	
		-- lets push the bars up to insert a new one
		if (foundspace and findctype) then
	
			for i=CEnemyCastBar.bNumBars-1, findctype+1, -1 do
		
				local CECname = getglobal("Carni_ECB_"..i);
				local CECno = i;
			
				local CECpre = CECno + 1;
				local cecbuttonpre = getglobal("Carni_ECB_"..CECpre);
			
				if (not cecbuttonpre.label and CECname.label ) then -- .label instead of IsShown() = faster
			
					cecbuttonpre.startTime = CECname.startTime
					cecbuttonpre.label = CECname.label;
					cecbuttonpre.updlabel = true;
			
					local r,g,b = getglobal("Carni_ECB_"..CECno.."_Text"):GetShadowColor();
					getglobal("Carni_ECB_"..CECpre.."_Text"):SetShadowColor(r,g,b);

					r,g,b = getglobal("Carni_ECB_"..CECno.."_Text"):GetTextColor();
					getglobal("Carni_ECB_"..CECpre.."_Text"):SetTextColor(r,g,b);
			
					getglobal("Carni_ECB_"..CECpre.."_Icon"):SetTexture(getglobal("Carni_ECB_"..CECno.."_Icon"):GetTexture());

					if (getglobal("Carni_ECB_"..CECno.."_FixedIcon"):IsShown()) then
						getglobal("Carni_ECB_"..CECpre.."_FixedIcon"):Show();
					else
						getglobal("Carni_ECB_"..CECpre.."_FixedIcon"):Hide();
					end

					cecbuttonpre.channeling = CECname.channeling;
					cecbuttonpre.spell = CECname.spell;
					cecbuttonpre.mob = CECname.mob;
					cecbuttonpre.ctype = CECname.ctype;
					cecbuttonpre.endTime = CECname.endTime;

					if (CECname.activeHoTEnd) then
						cecbuttonpre.activeHoTEnd = CECname.activeHoTEnd;
						cecbuttonpre.activeHoTStart = CECname.activeHoTStart;
						getglobal("Carni_ECB_"..CECpre.."_StatusBar_SparkHoT"):Show();
						CECname.activeHoTEnd = 0; -- force to delete spark and stop updating
					end

					local preStatusBar, noStatusBar = getglobal("Carni_ECB_"..CECpre.."_StatusBar"), getglobal("Carni_ECB_"..CECno.."_StatusBar");
					preStatusBar:SetMinMaxValues(noStatusBar:GetMinMaxValues());
					preStatusBar:SetValue(noStatusBar:GetValue());
					preStatusBar:SetStatusBarColor(noStatusBar:GetStatusBarColor());

					cecbuttonpre:SetAlpha(CECname:GetAlpha());
					cecbuttonpre.faded = CECname.faded;
					cecbuttonpre.stack = CECname.stack;

					getglobal("Carni_ECB_"..CECpre.."_IconStack"):SetText( getglobal("Carni_ECB_"..CECno.."_IconStack"):GetText() );

					cecbuttonpre:Show();
			
					CEnemyCastBar_HideBar(CECno);
				end
			end
	
		end
	
		-- prepare to fire the bar into the right position
		--local i; -- now 'insertpos' above
		if (findctype) then
			insertpos = findctype+1;
		elseif (firstused and firstused < CEnemyCastBar.bNumBars) then
			insertpos = firstused+1;
		elseif (firstused and firstused == CEnemyCastBar.bNumBars) then
			insertpos = CEnemyCastBar.bNumBars; -- will call the red barrier (is a visible button)
		else
			insertpos = 1;
		end
	end
	-- "if end" for new separated feature

	local deliverpoint, maxbars; -- new for separated feature
	local red, green, blue = 0, 0, 0;
	if (ctype == "friendly") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[2][1];
		green = CEnemyCastBar.tColor[2][2];
		blue = CEnemyCastBar.tColor[2][3];
		deliverpoint = 1;

	elseif (ctype == "hostile") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[1][1];
		green = CEnemyCastBar.tColor[1][2];
		blue = CEnemyCastBar.tColor[1][3];
		deliverpoint = CEnemyCastBar.bNumBarsSep + 1;
		
	elseif (ctype == "gainsfoe") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[4][1];
		green = CEnemyCastBar.tColor[4][2];
		blue = CEnemyCastBar.tColor[4][3];
		deliverpoint = 2* CEnemyCastBar.bNumBarsSep + 1;

	elseif (ctype == "gainsfriend") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[5][1];
		green = CEnemyCastBar.tColor[5][2];
		blue = CEnemyCastBar.tColor[5][3];
		deliverpoint = 3 * CEnemyCastBar.bNumBarsSep + 1;

	elseif (ctype == "afflict") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[7][1];
		green = CEnemyCastBar.tColor[7][2];
		blue = CEnemyCastBar.tColor[7][3];
		deliverpoint = 4 * CEnemyCastBar.bNumBarsSep + 1;

	elseif (ctype == "stuns") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[8][1];
		green = CEnemyCastBar.tColor[8][2];
		blue = CEnemyCastBar.tColor[8][3];
		deliverpoint = 5 * CEnemyCastBar.bNumBarsSep + 1;

	elseif (ctype == "dots") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[9][1];
		green = CEnemyCastBar.tColor[9][2];
		blue = CEnemyCastBar.tColor[9][3];
		deliverpoint = 6 * CEnemyCastBar.bNumBarsSep + 1;

	elseif (ctype == "cooldown") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[3][1];
		green = CEnemyCastBar.tColor[3][2];
		blue = CEnemyCastBar.tColor[3][3];	
		deliverpoint = 7 * CEnemyCastBar.bNumBarsSep + 1;

	elseif (ctype == "grey") then
		if (turnlabel ~= "forceshow" and CEnemyCastBar_Colors["Bartype "..ctype].disabled) then return; end
		red = CEnemyCastBar.tColor[6][1];
		green = CEnemyCastBar.tColor[6][2];
		blue = CEnemyCastBar.tColor[6][3];
		deliverpoint = 8 * CEnemyCastBar.bNumBarsSep + 1;

	else
		deliverpoint = 8 * CEnemyCastBar.bNumBarsSep + 1;
	end


	if (not CEnemyCastBar.bSeparateBars) then -- new "if else end" for separated feature
		deliverpoint = insertpos;
		maxbars = insertpos;
	else
		maxbars = deliverpoint + (CEnemyCastBar.bNumBarsSep - 1);
	end

	--CEnemyCastBar.bNumBars
	for i=deliverpoint, maxbars do -- new for separated feature
	
		local button = getglobal("Carni_ECB_"..i);

		if (not button.label) then
		
			if (tonumber(starttime) and starttime < GetTime() ) then -- 'starttime < GetTime()' = fix for possible database errors: timeleft of server is longer than duration of database (because of blizz stack duration addition!)
				button.startTime = starttime;
			else
				button.startTime = GetTime();
			end

			if (turnlabel or (ctype == "dots" and CEnemyCastBar.bturnDoTs)) then
				if (DRText and (not CEnemyCastBar.bShowIcon or not string.match(DRText, "(%(%d+%))" ) ) ) then
					button.label = mob.." - "..spell .." "..DRText;
				else
					if (DRText and string.match(DRText, "(.+) (%(%d+%))") ) then
						local poison = string.match(DRText, "(.+) (%(%d+%))");
						button.label = mob.." - "..spell .." "..poison;
					else
						button.label = mob .." - ".. spell;
					end
				end
			else
				if (DRText and (not CEnemyCastBar.bShowIcon or not string.match(DRText, "(%(%d+%))" ) ) ) then
					button.label = spell .." "..DRText.." - ".. mob;
				else
					if (DRText and string.match(DRText, "(.+) (%(%d+%))") ) then
						local poison = string.match(DRText, "(.+) (%(%d+%))");
						button.label = spell .." "..poison.." - ".. mob;
					else
						button.label = spell .." - ".. mob;
					end
				end
			end
			button.updlabel = true;

			local _, playersclass = UnitClass("player");
			local buttonText = getglobal("Carni_ECB_"..i.."_Text");

			if (mob == UnitName("player") ) then
				buttonText:SetShadowColor(CEnemyCastBar.tColor[11][1],CEnemyCastBar.tColor[11][2],CEnemyCastBar.tColor[11][3]);
			elseif (starttime == "unkown spell") then
				buttonText:SetShadowColor(CEnemyCastBar.tColor[13][1],CEnemyCastBar.tColor[13][2],CEnemyCastBar.tColor[13][3]);
			elseif (turnlabel and turnlabel ~= "forceshow") then
				buttonText:SetShadowColor(CEnemyCastBar.tColor[12][1],CEnemyCastBar.tColor[12][2],CEnemyCastBar.tColor[12][3]);
			else
				buttonText:SetShadowColor(0,0,0);
			end

			if (CEnemyCastBar_Afflictions[spell] and playersclass == CEnemyCastBar_Afflictions[spell].cando) then
				buttonText:SetTextColor(CEnemyCastBar.tColor[10][1],CEnemyCastBar.tColor[10][2],CEnemyCastBar.tColor[10][3]);
			else
				buttonText:SetTextColor(1, 1, 1);
			end

			if (not icontexture or icontexture == "") then
				icontexture = "INV_Misc_QuestionMark";
			end
			getglobal("Carni_ECB_"..i.."_Icon"):SetTexture("Interface\\Icons\\"..icontexture);

			if (DRText) then --changed with 8 3 0
				local stack = string.match(DRText, "%((%d+)%)" ); -- only returns the number without brackets
				button.stack = stack;
				getglobal("Carni_ECB_"..i.."_IconStack"):SetText( stack );
			end
			getglobal("Carni_ECB_"..i.."_IconStack"):SetTextColor(CEnemyCastBar.tColor[14][1], CEnemyCastBar.tColor[14][2], CEnemyCastBar.tColor[14][3]);

			if (channeling
				or (not CEnemyCastBar.bFillupGains and (ctype == "gainsfriend" or ctype == "gainsfoe"))
				or (not CEnemyCastBar.bFillupDebuffs and (ctype == "afflict" or ctype == "stuns"))
				or (not CEnemyCastBar.bFillupDoTs and ctype == "dots")
			) then
				button.channeling = true;
			end

			button.spell = spell;
			button.mob = mob;
			button.ctype = ctype;
			button.endTime = button.startTime + castime;

			local buttonStatusBar = getglobal("Carni_ECB_"..i.."_StatusBar");
			buttonStatusBar:SetMinMaxValues(button.startTime,button.endTime);
			buttonStatusBar:SetValue(button.startTime);
			buttonStatusBar:SetStatusBarColor(red, green, blue);

			if (not falpha) then
				falpha = 0; -- for movable bars reduced alpha dummies
			end
			button:SetAlpha(falpha);
			button:Show();

			break; -- new for separated feature

		elseif (not CEnemyCastBar.bSeparateBars) then -- new for separated feature, only "else" before
			-- the limit has been reached if we got here
			NECB_BarrierShown = GetTime();
			CECBBarrierFrame:SetScale(CEnemyCastBar.bScale);
			if (CEnemyCastBar.bFlipB) then
				CECBBarrierFrame:SetPoint("TOP", "Carni_ECB_"..CEnemyCastBar.bNumBars, 0, -13);
			else
				CECBBarrierFrame:SetPoint("TOP", "Carni_ECB_"..CEnemyCastBar.bNumBars, 0, 8);
			end
			CECBBarrierFrame:Show();
			
		end
		
	end
	
 end  

end

function CEnemyCastBar_BarrierUpdater() --barrier updater

	if (GetTime() > NECB_BarrierShown + 5) then 
		CECBBarrierFrame:Hide();
	end
end

function CEnemyCastBar_UniqueCheck(spellname, castime, mob, gspell, DRText, turnit, ctype) --Unique

	-- define search area for maximum performance with new separated bar feature:
	local firstbutton = 1;
	local lastbutton = CEnemyCastBar.bNumBars;
	if (CEnemyCastBar.bSeparateBars) then

		if (ctype == "casts") then
			firstbutton = 1; --1
			lastbutton = 2 * CEnemyCastBar.bNumBarsSep; --10

		elseif (ctype == "allgains") then
			firstbutton = 2 * CEnemyCastBar.bNumBarsSep + 1; --11
			lastbutton = 4 * CEnemyCastBar.bNumBarsSep; --20

		elseif (ctype == "afflictions") then
			firstbutton = 4 * CEnemyCastBar.bNumBarsSep + 1; --21
			lastbutton = 7 * CEnemyCastBar.bNumBarsSep; --35

		elseif (ctype == "cooldown") then
			firstbutton = 7 * CEnemyCastBar.bNumBarsSep + 1; --36
			lastbutton = 8 * CEnemyCastBar.bNumBarsSep; --40

		elseif (ctype == "grey") then
			firstbutton = 8 * CEnemyCastBar.bNumBarsSep + 1; --41
			lastbutton = 9 * CEnemyCastBar.bNumBarsSep; --45
		end
	end


	local ashowing, drstate = 0, 0;

	-- check only, no update
	if (gspell == "true") then

		for i=firstbutton, lastbutton do

			local button = getglobal("Carni_ECB_"..i);
			if (spellname == button.spell and mob == button.mob) then

				ashowing = 1;

				break; -- there can be only one :D
			end
		end

	-- check + update if mob AND spell are the same
	elseif (gspell == "trueupdate") then

		for i=firstbutton, lastbutton do

			local button = getglobal("Carni_ECB_"..i);		
			if ((spellname == button.spell and mob == button.mob)
				and not (turnit == true and not button.channeling)
				and (CEnemyCastBar.bSeparateBars -- used for update of buff/debuff
					or
					not ((ctype == "allgains" or ctype == "afflictions") and (button.ctype == "friendly" or button.ctype == "hostile")) )
					and not (ctype == "casts" and (button.ctype == "gainsfoe" or button.ctype == "gainsfriend") )-- needed for channel_update (possibly gains are updated, not the channeling)
					and not (ctype == "cooldown" and button.ctype ~= "cooldown" )-- the gain is followed after channel start event and CD will overwrite the cast otherwise in non sep mode
				) then

				ashowing = 1;

					--START unique updater
					if (DRText and string.match(DRText, "delay")) then
						-- only allow real casts (or getdebuffs) to be delayed
						if (ctype == "afflictions" or (button.ctype == "friendly" or button.ctype == "hostile")) then
							button.startTime = castime;
							button.endTime = turnit;
							getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
							button.updater = 0; -- force update!
						end

					-- main updater
					else

						if (castime == "renew") then -- debuff/gain renew system
							castime = button.endTime - button.startTime;
						end
						if (GetTime() - button.startTime > 1) then --* p2.1.0 only update if difference is high enough
							button.startTime = GetTime();
							button.endTime = button.startTime + castime;
							getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
							button.updater = 0; -- force update!
						end
					end


					if (DRText and DRText ~= "delay") then
						if (DRText == "HoT") then

							--HoTStack
							if (button.stack) then
								button.stack = button.stack + 1;
							else
								button.stack = 2;
							end
							DRText = "("..button.stack..")";
						end

						-- easy fix for stack counters of 0,1 for cgain spells on renew:
						if (DRText == "(0)" or DRText == "(1)") then
							DRText = "";
						end

						-- gsub reason: possible "delay"..stack from gotdebuffs routine; here from periodicdmg
						if (turnit == "turnit" or (button.ctype == "dots" and CEnemyCastBar.bturnDoTs)) then
							button.label = mob.." - "..spellname .." "..string.gsub(DRText, "delay", "");
						else
							button.label = spellname .." "..string.gsub(DRText, "delay", "").." - "..mob;
						end

						if (DRText == "" or string.match(DRText, "(%(%d+%))" ) ) then

							button.stack = string.match(DRText, "(%d+)" );

							if (CEnemyCastBar.bShowIcon) then
								local poison = string.match(DRText, "(.+) (%(%d+%))");
								if (poison) then
									poison = " "..string.gsub(poison, "delay", "");
								else
									poison = "";
								end
								if (turnit == "turnit" or (button.ctype == "dots" and CEnemyCastBar.bturnDoTs)) then
									button.label = mob.." - "..spellname..poison;
								else
									button.label = spellname..poison.." - "..mob;
								end
							end
						else
							button.stack = false;
						end

						button.updlabel = true;
					end

					if (button.stack and not DRText) then button.stack = false; end --clear stack counter
					getglobal("Carni_ECB_"..i.."_IconStack"):SetText(button.stack);



				break; -- there can be only one :D
			end
		end

	-- check + update if spell is the same
	else

		for i=firstbutton, lastbutton do

			local button = getglobal("Carni_ECB_"..i);
			if ((spellname == button.spell)
				and (CEnemyCastBar.bSeparateBars
					or not ((ctype == "allgains" or ctype == "afflictions") and (button.ctype == "friendly" or button.ctype == "hostile") ) )
				) then
	
				ashowing = 1;

				--START unique updater
				if (mob == UnitName("player")) then
					getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(CEnemyCastBar.tColor[11][1],CEnemyCastBar.tColor[11][2],CEnemyCastBar.tColor[11][3]);
				else
					getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(0,0,0);
				end

				if (DRText and DRText ~= "delay") then
					if (string.find(button.label, "1/2")) then
						drstate = 4; DRText = "(|cffff00001/4|r)"; castime = castime/2 + 15;
					elseif (string.find(button.label, "1/4")) then
						drstate = 6; DRText = "(|cffff0000"..CECB_MISC_IMMUNE.."|r)"; castime = castime/4 + 15;
					elseif (string.find(button.label, CECB_MISC_IMMUNE)) then
						drstate = 2; DRText = "(|cffff00001/2|r)"; castime = castime + 15;
					end

					-- gsub reason: possible "delay"..stack from gotdebuffs routine
					button.label = spellname .." "..string.gsub(DRText, "delay", "").." - "..mob;


					if (DRText == "" or string.match(DRText, "(%(%d+%))" ) ) then

						button.stack = string.match(DRText, "(%d+)" );

						if (CEnemyCastBar.bShowIcon) then

							local poison = string.match(DRText, "(.+) (%(%d+%))");
							if (poison) then
								button.label = spellname .." "..poison.." - ".. mob;
							else
								button.label = spellname.." - "..mob;
							end
						end
					else
						button.stack = false;
					end

				else
					button.label = spellname .." - ".. mob;
				end

				if (button.stack and (not DRText or DRText == "delay")) then button.stack = false; end --clear stack counter
				getglobal("Carni_ECB_"..i.."_IconStack"):SetText( button.stack );
				button.updlabel = true;

				if (DRText and string.match(DRText, "delay")) then
					-- only allow afflictions to be delayed, gotdebuffs routine
					if (ctype == "afflictions") then
						button.startTime = castime;
						button.endTime = turnit;
						if (button.startTime > GetTime() ) then
							button.startTime = GetTime(); -- fix for possible database errors: timeleft of server is longer than duration of database (because of blizz stack duration addition!)
						end
						getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
						button.updater = 0; -- force update!
					end
				else

					if (GetTime() - button.startTime > 1) then --* p2.1.0 only update if difference is high enough
						button.startTime = GetTime();
						button.endTime = button.startTime + castime;
						getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
						button.updater = 0; -- force update!
					end
				end

				button.mob = mob; --END unique updater
					
				break; -- there can be only one :D
			end
		end
	end

	return ashowing, drstate;
end

function CEnemyCastBar_BCast_Control(bcasted, forceit, mob, spell, special) --BCast Control

	local _,_,latency = GetNetStats();

	if (not bcasted and latency < 750 and (CEnemyCastBar.bBCaster or forceit) and CEnemyCastBar.bParseC and (GetNumRaidMembers() ~= 0 or GetNumPartyMembers() ~= 0 or GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena()) ) then
		if (mob == LastSentBCPacket[1] and spell == LastSentBCPacket[2] and special == LastSentBCPacket[3] and (GetTime() - LastSentBCPacket[4]) < 3) then
			return false, latency;
		end
		return true, latency;
	end
	return false, latency;
end

function NECB_SetInterruptCheck()

	if (	not CEnemyCastBar.bGlobalPvP
		or CEnemyCastBar.bGainsOnly
		or not CEnemyCastBar.bPvP
	) then
		CEnemyCastBar.bSpellBreaks = false;
	else
		CEnemyCastBar.bSpellBreaks = true;
	end
end

function NECB_interrupt_casting(spell, mob) --INTERRUPTING Function, idea by Lazarus

	if ( (UnitName("target") == mob and not CEnemyCastBar.bFocusPvPOnly) or (UnitName("focus") == mob and CEnemyCastBar.bFocusPvP) ) then
		--will be catched by new spellcastSTOP event (WoW2.0)
		return;

	elseif ( string.find(NECB_Interruptions, spell) ) then
		CEnemyCastBar_Control_interrupt(mob);
	end
end

function CEnemyCastBar_Player_Target_Changed() --Target changed

	--if not CEnemyCastBar.bStatus then return; end
	-- not needed since all events are unregged then

	-- refire delayed Unit updates of WoW API for unit death
	if (CheckMobDeath) then
		--DEFAULT_CHAT_FRAME:AddMessage("|cffffff00CheckMobDeath: "..GetTime() - CheckMobDeath[1])--
		if (GetTime() - CheckMobDeath[1] < 0.5) then
			CEnemyCastBar_Control(CheckMobDeath[2], CheckMobDeath[2], "died");
		end
		CheckMobDeath = false;
	end

	-- new p2.1.0 UnitDebuff (duration + timeleft of own spells casted)
	if ((UnitExists("target") or UnitExists("focus")) and CEnemyCastBar.bShowafflict) then -- if module not loaded bShowafflict won't be true
		NECBGatherDebuffs(); -- without any time restriction of 'NECB_GatherDebuffsCompensation()'
	end

	-- show possible cast bar instantly on target change
	if ((UnitCastingInfo("target") or UnitChannelInfo("target")) and CEnemyCastBar.bPvP and not CEnemyCastBar.bGainsOnly) then
		NECB_SpellStart("target", true); -- true = update line from delay func
	end

	-- cooldown database updater
	if ((CEnemyCastBar.bCDown and CEnemyCastBar.bPvP) or (CEnemyCastBar.bClassDR and CEnemyCastBar.bShowafflict) ) then

		-- remove other Player CD Bars first
		local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
		if (CEnemyCastBar.bSeparateBars) then
			minbar, maxbar = 7 * CEnemyCastBar.bNumBarsSep + 1, 8 * CEnemyCastBar.bNumBarsSep; --36, 40
		end
		for i=minbar, maxbar do
			local spell = getglobal("Carni_ECB_"..i).spell;
	
			if (spell and string.find(spell, " %(CD%)") and not getglobal("Carni_ECB_"..i.."_FixedIcon"):IsShown() ) then
	
				spell = string.gsub(spell, " %(CD%)", "");
				if (CEnemyCastBar_Spells[spell]) then
					CEnemyCastBar_HideBar(i);
				end
			--DR, remove as well
			elseif (spell and string.match(spell, "DR: ") ) then
				CEnemyCastBar_HideBar(i);
	
			end
		end

		if ( UnitExists("target") ) then --only check on valid target now :D
			-- display CDs from Database for new target and remove obsolete CDs
			local i = 1;
			while i <= #NECB_CD_DB do
				if ( GetTime() > ( NECB_CD_DB[i][3] + NECB_CD_DB[i][4] ) ) then
					table.remove(NECB_CD_DB, i);
					i = i - 1;
				else
					if (NECB_CD_DB[i][1] == UnitName("target") ) then
						local _, targetsclass = UnitClass("target");
						if (UnitIsPlayer("target") and not CEnemyCastBar_Spells[NECB_CD_DB[i][2]].disabled and not (CEnemyCastBar_Spells[NECB_CD_DB[i][2]].cdclass and CEnemyCastBar_Spells[NECB_CD_DB[i][2]].cdclass ~= targetsclass) ) then
							if (CEnemyCastBar_UniqueCheck(NECB_CD_DB[i][2].." (CD)", nil, NECB_CD_DB[i][1], "true", nil, nil, "cooldown") == 0) then
								CEnemyCastBar_Show(NECB_CD_DB[i][1], NECB_CD_DB[i][2].." (CD)", NECB_CD_DB[i][4], "cooldown", nil, CEnemyCastBar_Spells[NECB_CD_DB[i][2]].icontex, NECB_CD_DB[i][3]);
							end
						else
							table.remove(NECB_CD_DB, i);
							i = i - 1;
						end
					end
				end
				i = i + 1;
			end
		
			--DR display DRs from Database for new target and remove obsolete DRs
			local i = 1;
			local _, playersclass = UnitClass("player");
			while i <= #NECB_DR_DB do
				if ( GetTime() > ( NECB_DR_DB[i][3] + NECB_DR_DB[i][4] ) or UnitIsDeadOrGhost("target") ) then
					table.remove(NECB_DR_DB, i);
					i = i - 1;
				else
					if (NECB_DR_DB[i][1] == UnitName("target") and playersclass == CEnemyCastBar_Afflictions[ NECB_DR_DB[i][6] ].spellDR) then
						CEnemyCastBar_Show(NECB_DR_DB[i][1], NECB_DR_DB[i][2], NECB_DR_DB[i][4], "cooldown", nil, CEnemyCastBar_Afflictions[ NECB_DR_DB[i][6] ].icontex, NECB_DR_DB[i][3], NECB_DR_DB[i][5]);
					end
				end
				i = i + 1;
			end
		end
	end

end


function CEnemyCastBar_PvECheck(mob, spell, bcasted, event) --some checks to reduce the situations in which PvP spells are blocked by PvE Spells!

	if (
		CEnemyCastBar_Raids[spell]
		and not (CEnemyCastBar_Raids[spell].mcheck and not string.find(CEnemyCastBar_Raids[spell].mcheck, mob))
		and (bcasted or not (CEnemyCastBar_Raids[spell].checkevent and (not event or not string.find(CEnemyCastBar_Raids[spell].checkevent, event) ) ) )
		) then
		return true;
	end
end

function CEnemyCastBar_Control(mob, spell, special, bcasted, event, rank, stack) --Control

	if (not CEnemyCastBar.bStatus) then
		return;
	end

	-- Convert "You" into Playername, important for broadcasts
	if (mob == CECB_SELF1 or mob == CECB_SELF2) then
		mob = UnitName("player");
	end


	-- crop the german aposthrophes from some spells (') -- obsolete since patterns are generated from globalstrings

		-- stop mirroring spells! only specified Mob, Zone, Event produces castbars else check pvp, debuff section
	if (	NECB_PvE_Module_loaded
		-- and special ~= "fades" -- not needed anymore, since it was outsourced
		and CEnemyCastBar_Raids[spell] -- double check to filter out lots of function calls right here
		and CEnemyCastBar_PvECheck(mob, spell, bcasted, event)
			-- otherwise "interrupt" will be broadcasted for mob death's code and clears timers for BC PvE, Respawn timers (7 0 1 patchnotes)
		-- and not (CEnemyCastBar_Raids[spell].t == 0 and special == "interrupt") -- not needed anymore, since it was outsourced
		) then

		NECB_PvE_Control(mob, spell, special, bcasted, event); -- load on demand addon
		
	else

	-- new block
	-- other than PvE, independent of PvP


		-- clear on mob died; to save some CPU time breackit it out
		if (special == "died") then

			-- Check if mob with same name dies, but was not 'your' mob; refired on "PLAYER_TARGET_CHANGED" (usually happens after mob dies)
			if (UnitName("target") == mob and not UnitIsDeadOrGhost("target")) then
				--sometimes UnitIsDead() is not updated fast enough by WoW API and it is still not true even if combatlog death fired (rare)
				CheckMobDeath = { GetTime(), mob };
				return;
			end

			-- first clear pending debuff casted on the mob; if dead and pending then can not resist etc. -> bar shows up after death
			if (necb_fauxtimer[1] and mob == necb_fauxtimer[3]) then
				CEnemyCastBar_FauxUpdater("clear");
			end

			local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
			if (CEnemyCastBar.bSeparateBars) then
				maxbar = 8 * CEnemyCastBar.bNumBarsSep; --40 (not only 35 to include Cooldowns (DRs))
			end
			for i=minbar, maxbar do

				local button = getglobal("Carni_ECB_"..i);
				if (button.spell) then

					local spellrunning = button.spell; -- needed for spell name change below, do not change spell name in BAR!

					-- remove DR Timers upon death
					if (string.find(spellrunning, "DR:")) then
						spellrunning = CECB_SPELL_STUN_DR;
					end

					if (CEnemyCastBar_Afflictions[spellrunning]) then

						-- "if" mob can't die without removing the debuff, so this wasn't the 'afflicted' mob
						-- "death" negates the above
						local fragile = CEnemyCastBar_Afflictions[spellrunning].fragile;
						local death = CEnemyCastBar_Afflictions[spellrunning].death;

						if (mob == button.mob and (not fragile or death)) then
							
							if (CEnemyCastBar_Afflictions[spellrunning].global) then
							-- Network BCasting
								local freetosend, latency = CEnemyCastBar_BCast_Control(bcasted, nil, mob, spell, special);
								if ( freetosend ) then
									NECB_SendMessage(".cecbspell "..mob..", "..spell..", "..special..", "..GetLocale()..", "..latency);
									NECB_set_LastSentBCPacket(mob, spell, special, GetTime());
									NECB_set_LastGotBCPacket(mob, spell, special, GetTime());
									necb_numspellcast = 0;
								end
							end

							CEnemyCastBar_HideBar(i);
						
						end

					-- to clear all but CD bars if mob dies
					elseif (CEnemyCastBar_Spells[spellrunning]) then

						if (mob == button.mob and not string.match(button.label, "(CD)") ) then
							CEnemyCastBar_HideBar(i);
						end --
					end
				end
			end

		-- other than faded/died
		elseif (NECB_Debuffs_Module_loaded and (special == "afflicted" or special == "periodicdmg") ) then
			NECB_Debuffs_Control(mob, spell, special, bcasted, event, rank, stack) -- load on demand addon

		elseif (NECB_PvP_Module_loaded) then
			NECB_PvP_Control(mob, spell, special, bcasted, event, rank, stack); -- load on demand addon

		end

	end -- finishes pve 'else' pvp, died if afflictions/fades
		
end


function CEnemyCastBar_Control_fades(mob, spell, special, bcasted) --Control fades

	if (not CEnemyCastBar.bStatus) then
		return;
	end

	-- Convert "You" into Playername, important for broadcasts
	if (mob == CECB_SELF1 or mob == CECB_SELF2) then
		mob = UnitName("player");
	end

-- now check everytime, since some gains shall be removed, too (see REMOVALS in afflictions section of localization.lua)
--if (special == "fades") then -- spells fading earlier than bar

	spell = string.gsub(spell, " %(.+%)", ""); -- remove suffix brackets
	for counter=1, #NECB_psuffix do
		if (string.match(spell, NECB_psuffix[counter]) ) then
			spell = string.match(spell, "(.+)"..NECB_psuffix[counter]);
			break;
		end
	end
	-- crop the german aposthrophes from some spells (') -- obsolete since patterns are generated from globalstrings

	local NECBAfflictSpell = false;
	if (CEnemyCastBar_Afflictions[spell]) then
		NECBAfflictSpell = true;
	end

	-- don't remove 'multi' on fade -> REMOVED; they 'stack' now!
	-- don't hide dmg debuffs, can be other player's fade!
	if ((NECBAfflictSpell and not CEnemyCastBar_Afflictions[spell].periodicdmg)
		or (CEnemyCastBar_Spells[spell] and not CEnemyCastBar_Spells[spell].nofade)

	) then

		-- some spells ('Inner Focus') start their CD on fade
		if (CEnemyCastBar.bCDown and CEnemyCastBar_Spells[spell] and CEnemyCastBar_Spells[spell].onfade and mob ~= UnitName("player") ) then
			-- update CD in database
			local i = 1;
			while i <= #NECB_CD_DB do
				if ( NECB_CD_DB[i][1] == mob and NECB_CD_DB[i][2] == spell ) then
					NECB_CD_DB[i][3] = GetTime();
					if (mob == UnitName("target") ) then
						CEnemyCastBar_UniqueCheck(spell.." (CD)", CEnemyCastBar_Spells[spell].d, mob, "trueupdate", nil, nil, "cooldown");
					end
				elseif ( GetTime() > ( NECB_CD_DB[i][3] + NECB_CD_DB[i][4] ) ) then -- remove 'old' cooldowns
					table.remove(NECB_CD_DB, i);
					i = i - 1;
				end
				i = i + 1;
			end
		end

		-- correct DR if a DR Spell fades earlier, NECBAfflictSpell can only be true if Debuffs module loaded (for CEnemyCastBar_DR_DBCheck) ;-)
		if (CEnemyCastBar.bClassDR and NECBAfflictSpell and CEnemyCastBar_Afflictions[spell].spellDR) then
			local drshare = CEnemyCastBar_Afflictions[spell].drshare;
			local drspell;
			if (drshare) then
				drspell = "DR: "..drshare;
			else
				drspell = "DR: "..spell;
			end
			CEnemyCastBar_UniqueCheck(drspell, 15, mob, "trueupdate", nil, nil, "cooldown"); -- update screen
			CEnemyCastBar_DR_DBCheck(mob, drspell, 15, "fadeupdate"); -- update DR DB
		end

		local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
		if (CEnemyCastBar.bSeparateBars) then
			maxbar = 7 * CEnemyCastBar.bNumBarsSep; --35
		end
		for i=minbar, maxbar do

			local button = getglobal("Carni_ECB_"..i);
			if (button.spell) then

				if (mob == button.mob and spell == button.spell and button.ctype ~= "cooldown" and button.ctype ~= "dots") then

					--BC stacking HoT counter (and Debuff multi counter)
					local NECBNoDel;
					if ((CEnemyCastBar_Spells[spell] and CEnemyCastBar_Spells[spell].HoT)
						or (NECBAfflictSpell and CEnemyCastBar_Afflictions[spell].multi)
						) then

						--HoTStack
						if (button.stack) then
							button.stack = button.stack - 1;
							if (button.stack > 1) then
								if (CEnemyCastBar.bShowIcon) then
									button.label = spell .." - "..mob;
								else
									button.label = spell .." ("..button.stack..") - "..mob;
								end
							else
								button.label = spell .." - "..mob;
								button.stack = false; -- for iconstack update below and to prevent < 2 for next fade
							end
							button.updlabel = true;
							getglobal("Carni_ECB_"..i.."_IconStack"):SetText( button.stack );
							NECBNoDel = true; --don't clear bar with stack
						end
					end

					if (not NECBNoDel) then
						CEnemyCastBar_HideBar(i);
					end

					if (NECBAfflictSpell and (CEnemyCastBar_Afflictions[spell].global or CEnemyCastBar_Afflictions[spell].fragile) ) then
					-- Network BCasting
						local freetosend, latency = CEnemyCastBar_BCast_Control(bcasted, nil, mob, spell, special);
						if ( freetosend ) then
							NECB_SendMessage(".cecbspell "..mob..", "..spell..", "..special..", "..GetLocale()..", "..latency);
							NECB_set_LastSentBCPacket(mob, spell, special, GetTime());
							NECB_set_LastGotBCPacket(mob, spell, special, GetTime());
							necb_numspellcast = 0;
						end
					end

					break; -- there can be only one :D
			
				end
			end
		end
	end
 --end

end


function CEnemyCastBar_Control_interrupt(mob) --Control interrupt

	if (not CEnemyCastBar.bStatus) then
		return;
	end

	-- Convert "You" into Playername, important for broadcasts
	if (mob == CECB_SELF1 or mob == CECB_SELF2) then
		mob = UnitName("player");
	end


-- LAZARUS Interrupt effect, modified by Natur
 --if (special == "interrupt") then

	local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
	if (CEnemyCastBar.bSeparateBars) then
		maxbar = 2 * CEnemyCastBar.bNumBarsSep; --10
	end
	for i=minbar, maxbar do

		local button = getglobal("Carni_ECB_"..i);
		if (button.spell) then

			if (not CEnemyCastBar_Raids[button.spell]) then

				if (mob == button.mob and ( button.ctype == "hostile" or button.ctype == "friendly" ) ) then
					CEnemyCastBar_HideBar(i);

					-- Clear Spell in CD Buffer
					if (CEnemyCastBar.bCDown and CEnemyCastBar_Spells[button.spell] and CEnemyCastBar_Spells[button.spell].d and not CEnemyCastBar_Spells[button.spell].channeled) then
						local cdi = 1;
						while cdi <= #NECB_CD_DB do
							if ( NECB_CD_DB[cdi][1] == button.mob and NECB_CD_DB[cdi][2] == button.spell ) then
								table.remove(NECB_CD_DB, cdi);
								-- clear visible bar now
								if (CEnemyCastBar.bSeparateBars) then
									minbar, maxbar = 7 * CEnemyCastBar.bNumBarsSep + 1, 8 * CEnemyCastBar.bNumBarsSep; --36, 40
								end
								for i=minbar, maxbar do
									local cdspell = getglobal("Carni_ECB_"..i).spell;
									if (cdspell and string.find(cdspell, " %(CD%)") ) then

										cdspell = string.gsub(cdspell, " %(CD%)", "");
										if (CEnemyCastBar_Spells[cdspell] and cdspell == button.spell) then
											CEnemyCastBar_HideBar(i);
										end
									end
								end
								break;
							end
							cdi = cdi + 1;
						end
					end
					-- Clear Spell in CD Buffer finished

					-- allow spellbreaker debuff bar to appear now
					if (necb_fauxtimer[1] and CEnemyCastBar_Afflictions[necb_fauxtimer[2]] and CEnemyCastBar_Afflictions[necb_fauxtimer[2]].spellbreaker and mob == necb_fauxtimer[3]) then
						necb_fauxtimer[6] = true; -- done
						necb_fauxtimer[5] = 0; -- triggers the bar instantly (not after delay went off); resists will still be catched

						--DEFAULT_CHAT_FRAME:AddMessage("|cff000099Got Fauxtimer!"..GetTime())--
						--else--
						--DEFAULT_CHAT_FRAME:AddMessage("|cffff0000NO Fauxtimer :O"..GetTime())--
					end
					return; -- no one is able to cast more than one spell at once
				end
			end
		end
	end

end


function CEnemyCastBar_Parse_RaidChat(msg, author, origin) --parse Raid/PartyChat for commands

	-- fix for battleground names from other realms
	if (string.match(author, "%-") ) then
		author = string.sub(author, 1, string.find(author, "%-") - 1);
	end

	if (CEnemyCastBar.bParseC and origin ~= "NECBCHAT") then

		if (
			string.sub (msg, 1, 11) == ".cecbspell "
			or string.sub (msg, 1, 32) == "<NECB> version request detected."
			or string.sub (msg, 1, 33) == "<NECB> gversion request detected."
			or string.sub (msg, 1, 10) == ".countmin "
			or string.sub (msg, 1, 10) == ".countsec "
			or string.sub (msg, 1, 11) == ".stopcount "
			or string.sub (msg, 1, 8) == ".repeat "
			) then


			--Network BC
			if (string.sub (msg, 1, 11) == ".cecbspell ") then

				if (UnitName("player") == author and origin ~= "NECBCTRA" ) then return (not string.match(msg, ", st:") ); -- display all in parser but BC Timers
				end
				--/script NECB_SendMessage(".cecbspell Genesarumia, Verbannen, afflicted, deDE, 250");
				local bcmob, bcspell, bcspecial, bcclientlang, bclatency = string.match (msg, ".cecbspell (.+), (.+), (.+), (.+), (.+)");
				if (bclatency) then

					if (bcclientlang ~= GetLocale()) then
						return true, nil, true; -- > wrongclient = true;
					end

					local stack;
					if (string.match(bcspecial, "st:") ) then -- manually broadcasted/requested PvE Timers
						if (NECB_requested_PvECDs and GetTime() - NECB_requested_PvECDs < 5) then
							NECB_requested_PvECDs = false;
							DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|cffffffff has sent PvE CDs/Respawn timers most fast!")
						end

						CEnemyCastBar_Control(bcmob, bcspell, bcspecial, "true");
						return (bclatency ~= "gettimer"); -- don't show BCed GetTimers in parser (might get flooded)
					else
						stack = string.match(bcspell, "(%(.+%))");
						if ( stack ) then -- check for something in brackets, delete whole part in brackets -- number will be pulled out in control for better performance
							bcspell = string.gsub(bcspell, NECB_Stack_Catcher2, "");
						end
					end

					-- Check if last receive was the same packet within 3 seconds -> then break!
					if (bcmob == LastGotBCPacket[1] and bcspell == LastGotBCPacket[2] and bcspecial == LastGotBCPacket[3] and (GetTime() - LastGotBCPacket[4]) < 3) then
						necb_numspellcast = necb_numspellcast + 1; 
						return true;
					end

					--DEFAULT_CHAT_FRAME:AddMessage("m:"..bcmob.." s:"..bcspell.." t:"..bcspecial)
					necb_numspellcast = 99;
					NECB_set_LastGotBCPacket(bcmob, bcspell, bcspecial, GetTime());

					if (bcspecial == "fades") then
						CEnemyCastBar_Control_fades(bcmob, bcspell, bcspecial, "true");
					else
						CEnemyCastBar_Control(bcmob, bcspell, bcspecial, "true", nil, nil, stack);
					end

					return true;
				end

			else

				-- version harvester
				if (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - VERSIONS" ) then
					local version = string.match(msg, "<NECB> version request detected. (.+)");
					if (version) then
							version = string.sub(version, 2, string.len (version) - 1); -- remove brackets
							table.insert (NECBVersionDB, version);
							table.insert (NECBVersionNames, author);

							NECB_set_fauxtimer(GetTime(), nil, nil, nil, 1, "printversions");
							CECBFauxFrameButton:Show(); -- wait some seconds
							--CEnemyCastBar_InternalHandler("printversions");
						return; -- does not trigger a message anymore
					end

				-- gversion harvester
				elseif (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - GVERSIONS" ) then
					local version = string.match(msg, "<NECB> gversion request detected. (.+)");
					if (version) then
							version = string.sub(version, 2, string.len (version) - 1); -- remove brackets
							table.insert (NECBVersionDB, version);
							table.insert (NECBVersionNames, author);
							NECB_set_fauxtimer(GetTime(), nil, nil, nil, 1, "printversions");
							CECBFauxFrameButton:Show(); -- wait some seconds
							--CEnemyCastBar_InternalHandler("printversions");
						return; -- does not trigger a message anymore
					end
				end

				local msg1 = string.sub (msg, 2, string.len(msg));
				if (string.sub(msg, 1, 6) ~= "<NECB>") then
					CEnemyCastBar_Handler(msg1);
				end

				--[[ fix color if you were not the requester
				local mycolor = "|cffffffcc";
				if (string.match(msg, "version request detected.") ) then
					mycolor = nil;
				end]]

				return (not string.match(msg, "version request detected.") );
			end

		elseif ( string.match(msg, "<NECB> Play (.+) for us!") ) then
			CEnemyCastBar_BHWipe(string.match(msg, "<NECB> Play (.+) for us!"), author);
			return true, "|cff66ff66";

		end

	end

	if (origin == "NECB") then

		if string.match(msg, "<NECB> Force version collection.") then
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Version request detected. Sending data.", 1, 0.5, 0);
			NECBVersionDB = { };
			NECBVersionNames = { };
			local playerbcaster = "";
			if (CEnemyCastBar.bBCaster and CEnemyCastBar.bParseC) then
				playerbcaster = ", BCASTER";
			end
			NECB_SendMessage("<NECB> version request detected. ("..CECB_status_version_txt..", "..GetLocale()..playerbcaster..")");
			return true, "|cff66ff66";

		elseif string.match(msg, "<NECB> Force gversion collection.") then
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r GVersion request detected. Sending data.", 1, 0.5, 0);
			NECBVersionDB = { };
			NECBVersionNames = { };
			local playerbcaster = "";
			if (CEnemyCastBar.bBCaster and CEnemyCastBar.bParseC) then
				playerbcaster = ", BCASTER";
			end
			NECB_SendMessage("<NECB> gversion request detected. ("..CECB_status_version_txt..", "..GetLocale()..playerbcaster..")", nil, "toguild");
			return true, "|cff66ff66";

		elseif string.match(msg, "<NECB> Whisper old versions of NECB to update!") then
			if (author == UnitName("player")) then
				author = "You";
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|r notified some users!");
			NECB_upd_notified = GetTime();
			return true, "|cff66ff66";

		elseif string.match(msg, "<NECB> FORCE (.+) to Broadcast! Change Settings!") then

			local forceplayer = string.match(msg, "FORCE (.+) to");
			if (forceplayer) then

				if (forceplayer == UnitName("player") and CEnemyCastBar_CheckRaidStatus(author) ) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|r has FORCED your NECB client to broadcast!");
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Settings have been changed.");

					CEnemyCastBar.bPvE = true;
					CEnemyCastBar.bShowafflict = true;
					CEnemyCastBar.bGlobalFrag = true;
					CEnemyCastBar.bBossDebuff = true;
					CEnemyCastBar.bParseC = true;
					CEnemyCastBar.bBCaster = true;

 					-- load on demand PvE/Debuffs if not done already
					CEnemyCastBar_RegisterEvents();

					if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
						CECB_ReloadOptionsUI();
					end
				end
			end
			return true, "|cff66ff66";

		elseif string.match(msg, "<NECB> STOP (.+) to Broadcast! Change Settings!") then

			local forceplayer = string.match(msg, "STOP (.+) to");
			if (forceplayer) then

				if (forceplayer == UnitName("player") and CEnemyCastBar_CheckRaidStatus(author) ) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|r has STOPPED your NECB client to broadcast!");
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Settings have been changed.");

					CEnemyCastBar.bBCaster = false;

					if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
						CECB_ReloadOptionsUI();
					end
				end
			end
			return true, "|cff66ff66";

		elseif string.match(msg, "<NECB> Gimme all your PvE Timers please.") then

			if (author ~= UnitName("player") and string.match(msg, "please. (.+)") == GetLocale() and IsInInstance() ) then
				NECB_Check_PvECDs(author);
			end
			return true, "|cff66ff66";

		end

	elseif (origin == "NECBCHAT") then

		local rank, fileName = CEnemyCastBar_CheckRaidStatus(author);
		local color = { };
		if ( not fileName ) then
			color.r, color.g, color.b = 1, 1, 1;
		else
			color = RAID_CLASS_COLORS[fileName];
		end

		DEFAULT_CHAT_FRAME:AddMessage("|cffcc99ff\[NECB\] \[|r"..author.."|cffcc99ff\]: "..msg, color.r, color.g, color.b);

	end
end

function NECB_SendMessage(msgs, prefixadd, toguild) --send

	-- patch 1.12
	if (not prefixadd) then
		prefixadd = "";
	end

	if (toguild) then
		SendAddonMessage("NECB"..prefixadd, msgs, "GUILD");
	elseif (GetNumBattlefieldStats() > 1 or IsActiveBattlefieldArena() ) then
		SendAddonMessage("NECB"..prefixadd, msgs, "BATTLEGROUND");
	elseif (GetNumRaidMembers() ~= 0) then
		SendAddonMessage("NECB"..prefixadd, msgs, "RAID");
	elseif (GetNumPartyMembers() ~= 0 ) then
		SendAddonMessage("NECB"..prefixadd, msgs, "PARTY");
	end

end

function CEnemyCastBar_OnUpdate() --Update

	local now = GetTime();
	local remains = this.endTime - now;

	-- dynamic update window for all bars! (10 sec bar =^ 66fps; 11 min bar =^ 1fps and so on until 0.5fps at 22 min bar is reached)
	if (remains > 10 and this.faded) then
		local timespan = 0.0015 * (this.endTime - this.startTime);
		if timespan > 2 then timespan = 2; end

		if (now - this.updater) < timespan then
			return;
		else
			this.updater = now;
		end
	end

	local CECname=this:GetName();
	local CECno=this:GetID();

	-- Update the spark, status bar and label
	local sparkPos = ((now - this.startTime) / (this.endTime - this.startTime)) * (195 + CEnemyCastBar.bnecbCBLBias);

	if (this.activeHoTEnd) then
		if (now > this.activeHoTEnd) then
			this.activeHoTEnd = false;
			getglobal(CECname .. "_StatusBar_SparkHoT"):Hide();
		else
			local sparkPosHoT = ((now - this.activeHoTStart) / (this.activeHoTEnd - this.activeHoTStart)) * (195 + CEnemyCastBar.bnecbCBLBias);
			if (this.channeling) then
				getglobal(CECname .. "_StatusBar_SparkHoT"):SetPoint("CENTER", CECname .. "_StatusBar", "RIGHT", -sparkPosHoT, 0);
			else
				getglobal(CECname .. "_StatusBar_SparkHoT"):SetPoint("CENTER", CECname .. "_StatusBar", "LEFT", sparkPosHoT, 0);
			end
		end
	end

	if (this.channeling) then
		getglobal(CECname .. "_StatusBar"):SetValue(this.startTime + remains);
		getglobal(CECname .. "_StatusBar_Spark"):SetPoint("CENTER", CECname .. "_StatusBar", "RIGHT", -sparkPos, 0);

	else
		getglobal(CECname .. "_StatusBar"):SetValue(now);
		getglobal(CECname .. "_StatusBar_Spark"):SetPoint("CENTER", CECname .. "_StatusBar", "LEFT", sparkPos, 0);
	end

	if (this.updlabel) then
		this.updlabel = false;
		getglobal(CECname .. "_Text"):SetText( this.label );
	end

	local cbtext = "";
	if (CEnemyCastBar.bTimer) then
		cbtext = CEnemyCastBar_NiceTime(remains);
	end
	getglobal(CECname .. "_CastTimeText"):SetText( cbtext );

	if (this.mob == UnitName("target") and CEnemyCastBar.bTargetIcon) then
		getglobal(CECname .. "_FocusIcon"):Hide();
		getglobal(CECname .. "_TargetIcon"):Show();

	elseif (this.mob == UnitName("focus") and (CEnemyCastBar.bFocusPvP or CEnemyCastBar.bFocusDebuffs)) then
		getglobal(CECname .. "_FocusIcon"):Show();
		getglobal(CECname .. "_TargetIcon"):Hide();
	else
		getglobal(CECname .. "_FocusIcon"):Hide();
		getglobal(CECname .. "_TargetIcon"):Hide();
	end


	-- fantastic fading routine + flashing, fps independent :D
	local framerate = GetFramerate();
	local stepping = 2/framerate;
	if (stepping > 0.4 ) then stepping = 0.4; -- security for very low fps (< 5fps)
	end

	local baralpha = this:GetAlpha();
	local totalTime = this.endTime - this.startTime;
	if (CEnemyCastBar.bFlashit and (remains/totalTime) < 0.20 and remains < 10 and totalTime >= 20 and not necblockshow) then

		stepping2 = stepping/1.2 -- manipulate flashing-speed
		if ((baralpha - stepping2) >= 0.1) then
			baralpha = baralpha - stepping2;
			this:SetAlpha(baralpha);
		else
			this:SetAlpha(1);
		end

		-- Raidwarning /rw
		if ( (CEnemyCastBar.bPvEWarn and not this.warned and CEnemyCastBar_Raids[this.spell] )
			--or (CEnemyCastBar.bDoTWarn and not this.warned and this.ctype == "dots" )
		) then
			PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\bottleopen2.mp3");
			this.warned = true;
		end

	elseif (not necblockshow) then

		-- Raidwarning, reset to allow new warnings for this spell
		if (this.warned) then
			this.warned = nil;
		end

		-- fade in bar
		if ((baralpha + stepping) < CEnemyCastBar.bAlpha) then
			baralpha = baralpha + stepping;
			this:SetAlpha(baralpha);
		else
			if (baralpha ~= CEnemyCastBar.bAlpha) then
				this:SetAlpha(CEnemyCastBar.bAlpha);
				this.faded = true;
			end
		end
	end
	-- fading routine finished

	if (remains < 0) then

		if (string.match(this.spell, "Repeater") ) then

			if ((this.endTime - this.startTime) < 2) then
				CEnemyCastBar_HideBar(CECno);
			else
				CEnemyCastBar_UniqueCheck(this.spell, (this.endTime - this.startTime), this.mob, "trueupdate", nil, nil, "grey");
			end

		else

			if (necblockshow) then
				necblockshow = nil;
				if (CEnemyCastBar.bLocked == false) then
					CEnemyCastBar_LockPos();
				end

			-- check special flags for bars running out
			elseif ( CEnemyCastBar_Raids[this.spell]
				 and
				(
				(CEnemyCastBar_Raids[this.spell].tchange and CEnemyCastBar_Raids[this.spell].tchange[2] == "perm" )
				or
				(UnitAffectingCombat("player") or UnitIsDead("player") )
				)
			 ) then

				-- check for tchange flag; changes the 't' of castbars if current bar runs out
				if ( CEnemyCastBar_Raids[this.spell].tchange) then
					CEnemyCastBar_Raids[CEnemyCastBar_Raids[this.spell].tchange[1]].t = CEnemyCastBar_Raids[this.spell].tchange[3];
					if (CEnemyCastBar_Raids[this.spell].tchange[2] == "perm") then --change permanently if [4] is set
						for k,v in pairs (NECBtchangeSourcePerm) do
							if (v == this.spell) then
								table.remove (NECBtchangeSourcePerm, k);
								break;
							end
						end
						table.insert (NECBtchangeSourcePerm, this.spell);
					else
						for k,v in pairs (NECBtchangeSource) do
							if (v == this.spell) then
								table.remove (NECBtchangeSource, k);
								break;
							end
						end
						table.insert (NECBtchangeSource, this.spell);
						necbengagecd = GetTime(); -- starts the EngageProtection to reset 't' to default for next combat
					end
				end

				-- check for aBar flag; Fires 'aBar' if current bar runs out
				if ( CEnemyCastBar_Raids[this.spell].aBar ) then
					CEnemyCastBar_HideBar(CECno);
					CEnemyCastBar_Control(this.mob, CEnemyCastBar_Raids[this.spell].aBar, "casts", "true"); -- won't be broadcasted!
					return;
				end

			end

			-- trigger cooldown bar at the end of the cast
			if ( CEnemyCastBar.bCDown and CEnemyCastBar_Spells[this.spell] and ( this.ctype == "hostile" or this.ctype == "friendly" ) ) then

				if ( CEnemyCastBar_Spells[this.spell].d and CEnemyCastBar_Spells[this.spell].t and UnitName("target") == this.mob and UnitIsPlayer("target") ) then

					local castime = CEnemyCastBar_Spells[this.spell].d;
					if (CEnemyCastBar_UniqueCheck(this.spell.." (CD)", castime, this.mob, "trueupdate", nil, nil, "cooldown") == 0) then
						local tmpspell, tmpmob = this.spell, this.mob; -- preserve values for code after HideBar
						CEnemyCastBar_HideBar(CECno);
						CEnemyCastBar_Show(tmpmob, tmpspell.." (CD)", castime, "cooldown", nil, CEnemyCastBar_Spells[tmpspell].icontex);
						return;
					end

				end
			end

			-- call custom function, before bar is cleared and values vanish
			NECB_Bar_ended(this.mob, this.spell, this.ctype);

			CEnemyCastBar_HideBar(CECno);

		end


		-- pull the bars together
	elseif (remains >= 1 ) then

		local CECpre = CECno - 1;
		local cecbuttonpre = getglobal("Carni_ECB_"..CECpre);

		-- stop falldown of bars through frames for new separation routine
		if (CECpre > 0 and not cecbuttonpre.label and (not CEnemyCastBar.bSeparateBars or CECpre % CEnemyCastBar.bNumBarsSep ~= 0) ) then

			cecbuttonpre.startTime = this.startTime
			cecbuttonpre.label = this.label;
			cecbuttonpre.updlabel = true;

			local r,g,b = getglobal("Carni_ECB_"..CECno.."_Text"):GetShadowColor();
			getglobal("Carni_ECB_"..CECpre.."_Text"):SetShadowColor(r,g,b);

			r,g,b = getglobal("Carni_ECB_"..CECno.."_Text"):GetTextColor();
			getglobal("Carni_ECB_"..CECpre.."_Text"):SetTextColor(r,g,b);

			getglobal("Carni_ECB_"..CECpre.."_Icon"):SetTexture(getglobal("Carni_ECB_"..CECno.."_Icon"):GetTexture());

			if (getglobal("Carni_ECB_"..CECno.."_FixedIcon"):IsShown()) then
				getglobal("Carni_ECB_"..CECpre.."_FixedIcon"):Show();
			else
				getglobal("Carni_ECB_"..CECpre.."_FixedIcon"):Hide();
			end

			cecbuttonpre.channeling = this.channeling;	
			cecbuttonpre.spell = this.spell;
			cecbuttonpre.mob = this.mob;
			cecbuttonpre.ctype = this.ctype;
			cecbuttonpre.endTime = this.endTime;

			if (this.activeHoTEnd) then
				cecbuttonpre.activeHoTEnd = this.activeHoTEnd;
				cecbuttonpre.activeHoTStart = this.activeHoTStart;
				getglobal("Carni_ECB_"..CECpre.."_StatusBar_SparkHoT"):Show();
				this.activeHoTEnd = 0; -- force to delete spark and stop updating
			end

			local preStatusBar, noStatusBar = getglobal("Carni_ECB_"..CECpre.."_StatusBar"), getglobal("Carni_ECB_"..CECno.."_StatusBar");
			preStatusBar:SetMinMaxValues(noStatusBar:GetMinMaxValues());
			preStatusBar:SetValue(noStatusBar:GetValue());
			preStatusBar:SetStatusBarColor(noStatusBar:GetStatusBarColor());

			cecbuttonpre:SetAlpha(this:GetAlpha());
			cecbuttonpre.faded = this.faded;
			cecbuttonpre.stack = this.stack;

			getglobal("Carni_ECB_"..CECpre.."_IconStack"):SetText( getglobal("Carni_ECB_"..CECno.."_IconStack"):GetText() );

			cecbuttonpre:Show();

			CEnemyCastBar_HideBar(CECno);

			-- force fast drop of all other bars if at least one bar drops
			if (CECno < CEnemyCastBar.bNumBars and (not CEnemyCastBar.bSeparateBars or CECno % CEnemyCastBar.bNumBarsSep ~= 0) ) then
												-- do not force 'anquor' bars to update, they won't drop (CECno+1 ~= 1 -> anquor)
				getglobal("Carni_ECB_"..(CECno+1)).updater = 0; -- force update
			end
		end
	end

end


-- Format seconds into m:ss
function CEnemyCastBar_NiceTime(secs, flag)
	if (secs > 60) then
		secs = ceil(secs);
		return string.format("%d:%02d", secs / 60, math.fmod(secs, 60));
	elseif (secs > 10 or flag) then
		secs = ceil(secs);
		return secs;
			--string.format("%.f", secs); -- I noticed sometimes the ceil command does not work, so it is formatted for that case as well
	else
		if (secs < 0) then secs = 0; end
		return string.format("%.1f", secs);
	end
end


function CEnemyCastBar_FPSBar_OnUpdate() --FPSBar

	local now = GetTime();
	if (NECB_fps_updated and now - NECB_fps_updated < 0.1) then
			return;
	end
	NECB_fps_updated = now;

	local framerate = GetFramerate();
	local g = framerate/30;
	local r = 30/framerate;

	if (g > 1) then g = 1;	end
	if (r > 1) then r = 1;	end

	local frameratesafe;
	if (framerate > 60) then frameratesafe = 60;
	else frameratesafe = framerate;
	end

	CECB_FPSBarFree_StatusBar:SetMinMaxValues(1,60);
	CECB_FPSBarFree_StatusBar:SetValue(frameratesafe);
	CECB_FPSBarFree_StatusBar_Spark:SetPoint("CENTER", "CECB_FPSBarFree_StatusBar", "LEFT", frameratesafe*1.95, 0);
	CECB_FPSBarFree_Text:SetText("|cffffffaaFPS: |cffffcc00"..ceil(framerate));
	CECB_FPSBarFree_StatusBar:SetStatusBarColor(r,g,0);

end

function CEnemyCastBar_FPSBar_DragStop()

	local point,_,_,x,y = CECB_FPSBarFree:GetPoint();
	--DEFAULT_CHAT_FRAME:AddMessage(point..", "..x..", "..y);--
	CEnemyCastBar.tFramePoints["CECB_FPSBarFree"] = {x,y,point};
	CECB_FPSBarFree:SetUserPlaced(false);
end

function CEnemyCastBar_LatencyBar_OnUpdate() --LatencyBar

	if (NECB_latency_updated) then
		if (GetTime() - NECB_latency_updated < 10) then
				return;
		else
			NECB_latency_updated = GetTime();
		end
	else
		NECB_latency_updated = GetTime() - 10;
	end

	local _,_,latency = GetNetStats();
	local g = 400/latency^1.1;
	local r = latency^1.1/400;

	if (g > 1) then g = 1;	end
	if (r > 1) then r = 1;	end

	local latencysafe;
	if (latency > 500) then latencysafe = 500;
	else latencysafe = latency;
	end

	CECB_LatencyBarFree_StatusBar:SetMinMaxValues(1,500);
	CECB_LatencyBarFree_StatusBar:SetValue(latencysafe);
	CECB_LatencyBarFree_StatusBar_Spark:SetPoint("CENTER", "CECB_LatencyBarFree_StatusBar", "LEFT", latencysafe*1.95, 0);
	CECB_LatencyBarFree_Text:SetText("|cffffffaaLatency: |cffffcc00"..ceil(latency));
	CECB_LatencyBarFree_StatusBar:SetStatusBarColor(r,g,0);

end

function CEnemyCastBar_LatencyBar_DragStop()

	local point,_,_,x,y = CECB_LatencyBarFree:GetPoint();
	CEnemyCastBar.tFramePoints["CECB_LatencyBarFree"] = {x,y,point}
	CECB_LatencyBarFree:SetUserPlaced(false);
end

function CECB_GCInfo_OnUpdate() --gcinfo

	local GCTime = GetTime();

	if (not lastgcupdate or GCTime - lastgcupdate > 0.5) then
		lastgcupdate = GCTime;

		local cecbgc_now = collectgarbage("count"); --BC after BC, delete above!
		if (cecbgc_max and cecbgc_now > cecbgc_max) then
			collectgarbage("collect");
		end

		if (not cecbgc_last or cecbgc_last > cecbgc_now) then
			cecbgc_last = cecbgc_now;
			cecbgc_min = cecbgc_now;
			--if (cecbgc_now*2 > tonumber(GetCVar("scriptMemory")) ) then
			--	cecbgc_max = tonumber(GetCVar("scriptMemory"));
			--else
				cecbgc_max = cecbgc_now*2; --BC after BC and use global
			--end
			cecbgc_minupdate = GCTime;
			lastgcdiffupdate = nil;
			cecbgc_purge30 = 0;
		end

		if (not lastgcdiffupdate or GCTime - lastgcdiffupdate > 5) then
			lastgcdiffupdate = GCTime;
	
			cecbgcdiff = (cecbgc_now - cecbgc_last) / 5;
			cecbgc_last = cecbgc_now;

			--BC, clear from here downwards, remove time presumption; BUT possibly not necessary!!! Might still work
			local GCPurgeCalcLength = 30;
			if ((GCTime - cecbgc_minupdate) > GCPurgeCalcLength) then
				if (cecbgc_min == cecbgc_now) then
					cecbgc_purge30 = 0;
				else
					cecbgc_purge30 = (cecbgc_max - cecbgc_now) * (GCTime - cecbgc_minupdate) / (cecbgc_now - cecbgc_min);
				end
				cecbgc_min = cecbgc_now;
				cecbgc_minupdate = GCTime;
			end

			if (cecbgc_min == cecbgc_now and cecbgc_purge30 == 0) then
				--cecbgcpurge = "waiting...";
				cecbgcpurge = "collecting!"; --BC after BC
			else
				if (cecbgc_min == cecbgc_now) then
					cecbgcpurge = cecbgc_purge30;
				else
					if (GCTime - cecbgc_minupdate > GCPurgeCalcLength or cecbgc_purge30 == 0) then
						cecbgcpurge = (cecbgc_max - cecbgc_now) * (GCTime - cecbgc_minupdate) / (cecbgc_now - cecbgc_min);
					else
						cecbgcpurge = (cecbgc_purge30 * (GCPurgeCalcLength - (GCTime - cecbgc_minupdate)) / GCPurgeCalcLength) + (cecbgc_max - cecbgc_now) * (GCTime - cecbgc_minupdate) / (cecbgc_now - cecbgc_min) * (GCTime - cecbgc_minupdate) / GCPurgeCalcLength;
					end
				end

				if (cecbgcpurge >= 3600) then
					cecbgcpurge = string.format("%d:%02d (|cffffccccHour|r:|cffccffccMin|r)", cecbgcpurge / 3600, math.fmod(cecbgcpurge / 60, 60));
				elseif (cecbgcpurge >= 60) then
					cecbgcpurge = string.format("%d:%02d (|cffccffccMin|r:|cffccccffSec|r)", cecbgcpurge / 60, math.fmod(cecbgcpurge, 60));
				else
					if (cecbgcpurge < 0) then
						cecbgcpurge = 0;
					end
					cecbgcpurge = string.format("%d (|cffccccffSeconds|r)", cecbgcpurge);
				end
			end

		end

		local gctext1 = "|cffffff00This displays the memory usage of all addons!\n\n";
		local gctext2 = "|cffcccc00Estimated time until purge: |r"..cecbgcpurge.."\n\n";
		local gctext3 = "|cffccccffUsed Memory |r- |cffffccccGainRate |r- |cffccffccMaximum\n";
		cecbgcdiff = floor(cecbgcdiff * 10) / 10;
		local gctext4 = "|cff9999ff"..floor(cecbgc_now).."|rkb - |cffff9999"..cecbgcdiff.."|rkb/s - |cff99ff99"..floor(cecbgc_max).."|rkb";
		CECBGCFrameBGText:SetText(gctext1..gctext2..gctext3..gctext4, 0.8, 0.8, 0.8);

	end

end

function CEnemyCastBar_Validchar(msg) --validchar

	value = true;

	for i = 1, string.len(msg) do

		local ctable = string.byte(string.sub(msg,i,i));
		if ( not ( (ctable >= 48 and ctable <= 57) or (ctable >= 65 and ctable <= 90) or (ctable >= 97 and ctable <= 122) ) ) then
			value = false;
		end
	end

	return value;
end

function CEnemyCastBar_LoadDisabledSpells(msg) --loaddisabled

	for k,v in pairs (CEnemyCastBar.tDisabledSpells) do

			if (CEnemyCastBar_Raids[v]) then
				CEnemyCastBar_Raids[v].disabled = true;
			end
	
			if (CEnemyCastBar_Spells[v]) then
				CEnemyCastBar_Spells[v].disabled = true;
			end
	
			if (CEnemyCastBar_Afflictions[v]) then
				CEnemyCastBar_Afflictions[v].disabled = true;
			end

			if (CEnemyCastBar_Colors[v]) then
				CEnemyCastBar_Colors[v].disabled = true;
				disabled = true;
			end
	end

	if (not msg) then
		if (#CEnemyCastBar.tDisabledSpells == 0) then
			DSpells = "Nothing disabled found! |rEmpty table loaded.";
		else
			DSpells = #CEnemyCastBar.tDisabledSpells.." |rDisabled Spells loaded. (see |cff00ff00/necb disabled|r)";
		end
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffff00 "..DSpells);
	end

end

function CEnemyCastBar_SetRange(param) --setrange

	local RangeValues;

	if (param == "allmax") then
		RangeValues = {"150", "150", "150", "150", "150", "150", "150", "150"};
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r CombatLogRanges set to |cffffff00maximum|r! (Creature ranges can not be changed.)");
	elseif (param == "cmax") then
		RangeValues = {"150", "150", "50", "50", "50", "50", "50", "50"};
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Creature CombatLogRanges set to |cffffff00maximum|r others set to defaults!");
	else
		RangeValues = {"60", "30", "50", "50", "50", "50", "50", "50"};
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r CombatLogRanges set to |cffffff00defaults|r!");
	end

	SetCVar("CombatDeathLogRange" , RangeValues[1]);
	SetCVar("CombatLogRangeCreature" , RangeValues[2]); 
	SetCVar("CombatLogRangeFriendlyPlayers" , RangeValues[3]);
	SetCVar("CombatLogRangeFriendlyPlayersPets" , RangeValues[4]);
	SetCVar("CombatLogRangeHostilePlayers" , RangeValues[5]);
	SetCVar("CombatLogRangeHostilePlayersPets" , RangeValues[6]);
	SetCVar("CombatLogRangeParty" , RangeValues[7]);
	SetCVar("CombatLogRangePartyPet" , RangeValues[8]);

	--DEFAULT_CHAT_FRAME:AddMessage(GetCVarDefault("CombatLogRangeCreature"));
end

-- Thanks to Yatlas, Gello (Atlas Addon) for base code parts
function NECBButton_BeingDragged()

	local xpos,ypos = GetCursorPosition();
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom();
	
	xpos = -xpos/UIParent:GetScale()+70+xmin
	ypos = ypos/UIParent:GetScale()-70-ymin

	local miniradius = (xpos^2 + ypos^2)^0.5;
	if (miniradius < 100 and miniradius > 60 and not IsAltKeyDown()) then
		miniradius = 80;
	end
	--DEFAULT_CHAT_FRAME:AddMessage(xpos.." "..ypos.." "..miniradius);

	local bpoint = (math.deg(math.atan2(ypos,xpos)));

	if(bpoint < 0) then
		bpoint = bpoint + 360;
	end

	CEnemyCastBar.bMiniMapPos = bpoint;
	CEnemyCastBar.bMiniMapRadius = miniradius;
	CECBMiniMapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (miniradius * cos(bpoint)), (miniradius * sin(bpoint)) - 52);
	CECBMiniMapButton:SetUserPlaced(false);
end

local NECB_CPU_DB = { }; for i=1, GetNumAddOns() do NECB_CPU_DB[i] = {}; end
local function sort_cpu (v1, v2)
	if not v1 then return false; elseif not v2 then return true; end
	return v1.cpu > v2.cpu;
end
function NECBButton_OnEnter(update) --minimap

	if (update and (not GameTooltip:IsVisible() or not string.match(GameTooltipTextLeft1:GetText(), "EnemyCastBar")) ) then
		return;
	end

	GameTooltip:SetOwner(this, "ANCHOR_LEFT");
	GameTooltip:SetText(NECB_Minimap_Tooltip[1]);
	for i=2,5 do
		GameTooltip:AddLine(NECB_Minimap_Tooltip[i]);
	end


	-- BC 2.1.0
	UpdateAddOnMemoryUsage();

	GameTooltip:AddLine("|cffffffffCore System |cffaaaaaa("..ceil(GetAddOnMemoryUsage("CEnemyCastBar")).."kb)");
	if (CECBOptionsFrame) then
		GameTooltip:AddLine("|cffffffffOptions |cffaaaaaa("..ceil(GetAddOnMemoryUsage("CECB_Options")).."kb)");
	end
	if (NECB_PvP_Module_loaded) then
		GameTooltip:AddLine("|cffffffffPvP |cffaaaaaa("..ceil(GetAddOnMemoryUsage("CECB_PvPModule")).."kb)");
	end
	if (NECB_PvE_Module_loaded) then
		GameTooltip:AddLine("|cffffffffPvE/Raid |cffaaaaaa("..ceil(GetAddOnMemoryUsage("CECB_PvEModule")).."kb)");
	end
	if (NECB_Debuffs_Module_loaded) then
		GameTooltip:AddLine("|cffffffffDebuffs |cffaaaaaa("..ceil(GetAddOnMemoryUsage("CECB_Debuffs")).."kb)");
	end
	-- set disabled text if Addon deactivated
	if (not CEnemyCastBar.bStatus) then
		GameTooltip:AddLine(NECB_Minimap_Tooltip[6]);
	end

	-- debuff/buff listing: was my personal debug info before but might be a nice gimmick
	GameTooltip:AddLine(" ");
	GameTooltip:AddLine(NECB_Minimap_Tooltip[7].." |cffff0000DeBuffs:");
	local name, duration, timeLeft;
	local i = 1;
	while UnitDebuff("target", i) do
		name, _, _, _, _, duration, timeLeft = UnitDebuff("target", i);
		if (timeLeft) then
			GameTooltip:AddLine("|cffffffff"..name..": "..CEnemyCastBar_NiceTime(timeLeft, true).."|cffaaaaaa, "..CEnemyCastBar_NiceTime(duration, true) );
		else
			break;
		end
		i = i + 1;
	end
	GameTooltip:AddLine(NECB_Minimap_Tooltip[7].." |cff00ff00Buffs:");
	i = 1;
	while UnitBuff("target", i) do
		name, _, _, _, duration, timeLeft = UnitBuff("target", i);
		if (timeLeft) then
			if (timeLeft ~= 0) then -- some trinkets return a limeLeft of 0!
				GameTooltip:AddLine("|cffffffff"..name..": "..CEnemyCastBar_NiceTime(timeLeft, true).."|cffaaaaaa, "..CEnemyCastBar_NiceTime(duration, true) );
			end
		else
			break;
		end
		i = i + 1;
	end


	-- CPU info (BC 2.1.0):
	if (GetCVar("scriptProfile") == "1" ) then

		local cpu_cdown = "";
		if (NECB_cpu_tooltip and GetTime() - NECB_cpu_tooltip > 10) then

			NECB_totalused = 0;
			NECB_cpu_tooltip = false;
	
			UpdateAddOnCPUUsage();

			for i=1, GetNumAddOns() do
				NECB_CPU_DB[i].name = GetAddOnInfo(i);
				NECB_CPU_DB[i].cpu = GetAddOnCPUUsage(i);

					--GameTooltip:AddLine("|cffffffff"..name.." |cffaaaaaa("..(ceil(GetAddOnCPUUsage(i))/1000).."s)");

				NECB_totalused = NECB_totalused + GetAddOnCPUUsage(i);
			end

			table.sort (NECB_CPU_DB, sort_cpu);

		elseif (not NECB_cpu_tooltip) then
			NECB_cpu_tooltip = GetTime();

		end

		GameTooltip:AddLine(" ");
		GameTooltip:AddLine(NECB_Minimap_Tooltip[8]);

		for i=1, 10 do
			if (NECB_CPU_DB[i] and NECB_CPU_DB[i].cpu ~= 0) then
				GameTooltip:AddLine("|cffffffff"..NECB_CPU_DB[i].name.." |cffaaaaaa(|cff00aa00"..(string.format("%.3f", (ceil(NECB_CPU_DB[i].cpu)/1000)) ).."|cffaaaa00s|cff9999aa "..(string.format("%.1f", (NECB_CPU_DB[i].cpu/NECB_totalused*100)) ).."|cffaaaa00%|cffaaaaaa) "..cpu_cdown);
			elseif (i == 1 and NECB_CPU_DB[i].cpu == 0) then
				GameTooltip:AddLine("|cffffffffDo |cffff0000/reloadui |cffffffffto enable this UI feature for all AddOns!");
			end
		end
	end


	GameTooltip:Show();
end


function NECBCreateBars(msg)

	local newbfound;
	for i=2, CEnemyCastBar.bNumBars do

		if (not getglobal("Carni_ECB_"..i)) then
			newbfound = true;

			local newButton = CreateFrame("Button", "Carni_ECB_"..i, UIParent, "CarniEnemyCastBarTemplate");
			newButton:SetID(i);
			newButton:SetPoint("TOPLEFT", "Carni_ECB_"..i-1, "TOPLEFT", 0, 20);
		end
	end

	if (newbfound) then
		CEnemyCastBar_FlipBars(); -- reorder frame, set icon, space, width for bars
		CEnemyCastBar_SetTextSize();
		CEnemyCastBar_SetBorder();
		CEnemyCastBar_SetTexture();
		CEnemyCastBar_SetIcon();

		CEnemyCastBar.bLocked = false;
		CEnemyCastBar_LockPos();
	end

	if (CEnemyCastBar.tFramePoints and not CEnemyCastBar.tFramePoints["Carni_ECB_1"] ) then
		local point,_,_,x,y = getglobal("Carni_ECB_1"):GetPoint();
		CEnemyCastBar.tFramePoints["Carni_ECB_1"] = { x,y,point };
	end

	if (CEnemyCastBar.bSeparateBars and msg == "reset") then

		local step = 1;
		local point, _, _, x, y = getglobal("Carni_ECB_1"):GetPoint(); -- get bar1 posi instead of hardcoding these points here again
		for i=CEnemyCastBar.bNumBarsSep + 1, CEnemyCastBar.bNumBars, CEnemyCastBar.bNumBarsSep do --i=6, max, 5
			getglobal("Carni_ECB_"..i):ClearAllPoints();
			getglobal("Carni_ECB_"..i):SetPoint(point, "UIParent", point, x, y + step*30);
			getglobal("Carni_ECB_"..i):SetUserPlaced(true); -- and only these points will be stored into savedvariables with LockPos()
			step = step + 1;
		end
	end
end


function NECB_FixMe(bnum)

	local spell = getglobal("Carni_ECB_"..bnum).spell;

	if (spell and string.find(spell, " %(CD%)") ) then

		-- graphical notification
		if (getglobal("Carni_ECB_"..bnum.."_FixedIcon"):IsShown()) then
			getglobal("Carni_ECB_"..bnum.."_FixedIcon"):Hide();
		else
			getglobal("Carni_ECB_"..bnum.."_FixedIcon"):Show();
		end
	end

end

-- added here to be independend of PvP Module loaded!
function NECB_specials_parser(mob)

	-- specials

	-- a) victory rush, check if spell has been learned
	if (CEnemyCastBar_Spells[NECB_Victory_Rush]
		and SpellHasRange(NECB_Victory_Rush) -- warriors with button in any slot only
		--and CEnemyCastBar.bPvP
		and not CEnemyCastBar_Spells[NECB_Victory_Rush].disabled
		and not (UnitName("target") == mob and UnitIsTrivial("target"))
	) then
		--shedule, because the client needs some time to update 'IsUsableSpell' status
		NECB_set_fauxtimer(GetTime(), nil, nil, nil, 1, "VictoryRush");
		CECBFauxFrameButton:Show();
	end

	-- b) play killing sounds :D
	if (UnitName("target") == mob) then
		if ((CEnemyCastBar.bKSoundPvP and UnitIsPlayer("target") and not UnitIsTrivial("target") )
			 or (CEnemyCastBar.bKSoundPvE and not UnitIsPlayer("target") and not UnitIsTrivial("target")
				and (not CEnemyCastBar.bKSoundPvE_grouped or (GetNumRaidMembers() ~= 0 or GetNumPartyMembers() ~= 0) ) )
		) then

			if (not NECB_killing_timer or (GetTime() - NECB_killing_timer > 60) ) then
				PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\firstblood.mp3");
				NECB_killing_counter = 0;

			elseif (GetTime() - NECB_killing_timer <= 60) then
				NECB_killing_counter = NECB_killing_counter + 1;

				if (NECB_killing_counter == 1) then
					PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\dominating.mp3");
				elseif (NECB_killing_counter == 2) then
					PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\killingspree.mp3");
				elseif (NECB_killing_counter == 3) then
					PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\unstoppable.mp3");
				elseif (NECB_killing_counter > 3) then
					PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\godlike.mp3");
				end
			end
			NECB_killing_timer = GetTime();
		end
	end
end


-- define some last variables
NECB_Textures = {
	[1] = "BantoBar";
	[2] = "Dabs";
	[3] = "CharCoal";
	[4] = "Glaze";
	[5] = "Otravi";
	[6] = "Otravi dark";
	[7] = "Claud";
	[8] = "Waves";
	[9] = "Diagonal";
	[10] = "Rain";
	[11] = "Water";
	[12] = "Wisps";
	[13] = "Perl";
	[14] = "Smooth";
	[15] = "Smudge";
	[16] = "Striped";
	[17] = "Marble";
	[18] = "Skewed";
	[19] = "Tube large";
	[20] = "Tube small";
	[21] = "Salinos";
	[22] = "Minimalist";
}


