--[[
========== Enemy CastBar Custom Spell Database =========================================

Instead of using this lines like in the original localization.lua:

	["Unstable Power"] = 		{ t=20.0, d=120, icontex="Spell_Lightning_LightningBolt01" };

you have to use this way to add spells:

	CEnemyCastBar_Spells["Unstable Power"] = { t=20.0, d=120, icontex="Spell_Lightning_LightningBolt01" };

Same for "CEnemyCastBar_Raids" and "CEnemyCastBar_Afflictions" spells :D
========================================================================================


A short description of the spell flags exctracted from the original localization.lua:
-------------------------------------------------------------------------------------

".._Spells" ->
-- IMPORTANT: Maybe some spells which cause debuffs have to be moved to CEnemyCastBar_Afflictions to be shown
-- "t=x" defines the normal length of the castbar. "d=x" will add a cooldown timer for spells with a casttime and for gains.
-- "g=0" prevents a bar if a player gains this spell. "g=x" shows a bar of x seconds instead of "t=x" if it's a gain. (Even prevents CD if it's a gain.)
-- "i=x" shows a bar of x seconds additional to "t" (everytime)
-- HoT=true, spell stacks of HoTs will be counted; spell is able to be updated by player casts on target
-- onfade=true, cooldown timer will be reset to full duration if the spell fades (to have an exact timing for 'Inner Focus' etc.)
-- icasted=true, used for instant casts ("Player xy casts spell.")
-- cgain=true, are able to be updated by player casts on target (HoT=true and cgain=true are beeing treated the same by the update feature.)
-- swarn=true, will play a sound warning if this bar appears
-- callspell={"SpellName", talentTab, talentNumber, checkValue}. Only processed in clients local system (keypress): If invested talent points == checkValue bar will update "SpellName" (current example 'Healing Wave'); Target spell must have "cgain=true" to be updated!

]]

	-- pls tell me at curse-gaming.com what you add here! Maybe I will add it to the official version then ;-) Thanks :D
	-- enter your spells here:

	-- Some EXAMPLES (remove '--' in front of the Spell's line to have a working detection ^^):

	--CEnemyCastBar_Spells["Frostbolt"] = {t=2.5, icontex="Spell_Frost_FrostBolt02"};

	CEnemyCastBar_Spells["YourSpell"] = { t=20.0, icontex="ValidTextureFile or leave blank/delete" }; --> PvP Spells