﻿--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!

if ( GetLocale() == "zhTW" ) then

	-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
	-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
	-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
	-- "active" only allows this spell to be an active cast, no afflictions and something else!
	-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
	-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
	-- "icasted" guides this spell through the instant cast protection
	-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
	-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
	-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
	-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
	-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
	-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
	--  tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas = "納克薩瑪斯";
	NECB_AhnQiraj = "安其拉";
	NECB_AhnQirajRuins = "安其拉廢墟";
	NECB_ZulGurub = "祖爾格拉布";
	NECB_MoltenCore = "熔火之心";
	NECB_OnyxiaLair = "奧妮克希亞的巢穴";
	NECB_BlackwingLair = "黑翼之巢";
	NECB_Stratholme = "斯坦索姆";
	--BC
	NECB_ShatteredHalls = "破碎大廳";
	NECB_Magtheridon = "瑪瑟里頓的巢穴";
	NECB_GruulsLair = "戈魯爾之巢";
	NECB_Karazhan = "卡拉贊";
	NECB_SerpentshrineCavern = "毒蛇神殿洞穴";
	NECB_Tempest_Keep = "風暴要塞";
	NECB_Black_Temple = "黑暗神廟";
	NECB_ZulAman = "祖阿曼";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
	NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
	if not forcereg then
	return;
	end
	break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


	--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
	CEnemyCastBar_Raids = {
	
	-- Magtheridon
	
	-- Respawn timer
	["TrashRespawn"] = {t=7200, c="cooldown", global="true", m="Magtheridon", icontex="Spell_Holy_Resurrection"};
	["地獄火獄吏"] = {t=0, pBar="TrashRespawn"};
	["瑪瑟里頓"] = {t=0, delBar="TrashRespawn"};
	}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Amani'shi Tempest"] = {t=0, pBar="Akil'zon Trash"}; -- translate!
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};

		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Black Temple Respawn timer

			["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["元水領主"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["考斯卡將軍"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["考斯卡獵魚者"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["巨神海蛇"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				-- + Coilskar Soothsayer, Coilskar Wrangler
					["高階督軍納珍塔斯"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"};

			["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["噬骨者勞工"] = {t=0, pBar="Supremus Trash"};
				["噬骨者監工"] = {t=0, pBar="Supremus Trash"};
					["瑟普莫斯"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"};

			["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["灰舌原獵者"] = {t=0, pBar="Akama Trash"}; -- translate!
				["灰舌秘法師"] = {t=0, pBar="Akama Trash"}; -- translate!
				["灰舌戰鬥領主"] = {t=0, pBar="Akama Trash"}; -- translate!
					["阿卡瑪的黑暗面"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"};

			["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["影月勇士"] = {t=0, pBar="Gorefiend Trash"};
				["影月搶奪者"] = {t=0, pBar="Gorefiend Trash"};
					["泰朗·血魔"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"}; 

			["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["噬骨護盾門徒"] = {t=0, pBar="Gurtogg Trash"};
				["噬骨劍刃狂怒者"] = {t=0, pBar="Gurtogg Trash"};
				["突變的戰犬"] = {t=0, pBar="Gurtogg Trash"};
					["葛塔格·血沸"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"}; 

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Temple Concubine"] = {t=0, pBar="Mother Shahraz Trash"};
				["Charming Courtesan"] = {t=0, pBar="Mother Shahraz Trash"};
				["Spellbound Attendant"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pain"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pleasure"] = {t=0, pBar="Mother Shahraz Trash"};
					["Mother Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Promenade Sentinel"] = {t=0, pBar="Illidari Council Trash"}; -- translate!
					["粉碎者高希歐"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	
		}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
	CEnemyCastBar_Raids = {
	
		-- Tempest Keep
	
			-- Respawn timer
			["Al'ar Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["占星者"] = {t=0, pBar="Al'ar Trash"};
				["星術師"] = {t=0, pBar="Al'ar Trash"};
				["血守衛復仇者"] = {t=0, pBar="Al'ar Trash"};
			-- conflict ["血守衛軍團士兵"] = {t=0, pBar="Al'ar Trash"};
					["歐爾"] = {t=0, tchange={"Al'ar Trash", "perm", 0}, delBar="Al'ar Trash"};

			["Void Reaver Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["水晶之核毀壞者"] = {t=0, pBar="Void Reaver Trash"};
				--["水晶之核哨兵"] = {t=0, pBar="Void Reaver Trash"};
					["虛無搶奪者"] = {t=0, tchange={"Void Reaver Trash", "perm", 0}, delBar="Void Reaver Trash"};

			["Astromancer Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["星術領主"] = {t=0, pBar="Astromancer Trash"};
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Astromancer Trash"};
				["星術師初學者"] = {t=0, pBar="Astromancer Trash"};
					["高階星術師索拉瑞恩"] = {t=0, tchange={"Astromancer Trash", "perm", 0}, delBar="Astromancer Trash"};

			["Kael'thas Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["紅手戰鬥法師"] = {t=0, pBar="Kael'thas Trash"};
				["紅手血騎士"] = {t=0, pBar="Kael'thas Trash"};
				["紅手百夫長"] = {t=0, pBar="Kael'thas Trash"};
				["紅手審判官"] = {t=0, pBar="Kael'thas Trash"};
					["凱爾薩斯·逐日者"] = {t=0, tchange={"Kael'thas Trash", "perm", 0}, delBar="Kael'thas Trash"};
		}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	
	CEnemyCastBar_Raids = {
	
	-- Serpentshrine Cavern
		-- Respawn timer
			["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["盤牙訓獸師"] = {t=0, pBar="HydrossTrash"};
				["盤牙憎恨尖嘯者"] = {t=0, pBar="HydrossTrash"};
				["盤牙孢子蝙蝠"] = {t=0, pBar="HydrossTrash"};
					["不穩定者海卓司"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

			["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["瓦司金榮譽守衛"] = {t=0, pBar="LurkerTrash"};
				["盤牙女祭司"] = {t=0, pBar="LurkerTrash"};
					["海底潛伏者"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

			["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["灰色之心虛空法師"] = {t=0, pBar="MixedTrash"};
				["灰色之心浪潮呼喚者"] = {t=0, pBar="MixedTrash"};
				["灰色之心隱藏者"] = {t=0, pBar="MixedTrash"};

			["TidewalkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["潮行者薩滿"] = {t=0, pBar="TidewalkerTrash"};
				["潮行者深淵先知"] = {t=0, pBar="TidewalkerTrash"};
				["潮行者戰士"] = {t=0, pBar="TidewalkerTrash"};
					["莫洛葛利姆·潮行者"] = {t=0, tchange={"TidewalkerTrash", "perm", 0}, delBar="TidewalkerTrash"};

			["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["灰色之心盾衛"] = {t=0, pBar="LeotherasTrash"};
					["『盲目者』李奧薩拉斯"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"};
		}


	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	
	CEnemyCastBar_Raids = {
	
	-- Gruuls
	
	-- Krosh Firehand
	["法術護盾"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"};

	-- Respawn timer
	["OgreRespawn"] = {t=3600, c="cooldown", global="true", m="Gruul", icontex="Spell_Holy_Resurrection"};
	["巢穴蠻兵"] = {t=0, pBar="OgreRespawn"};
	["古羅牧師"] = {t=0, pBar="OgreRespawn"};
	["大君王莫卡爾"] = {t=0, delBar="OgreRespawn"};
	["弒龍者戈魯爾"] = {t=0, delBar="OgreRespawn"};
	}

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

	NECB_PvE_Debuffs = true; -- force register events

	CEnemyCastBar_Raids = {
	["卡加斯的死刑執行者"] = {t=4800, c="cooldown", global="true", m="Heroic Quest", icontex="Spell_Holy_Resurrection"};
	["大酋長卡加斯·刃拳"] = {t=0, delBar="卡加斯的死刑執行者"};
	}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;

	CEnemyCastBar_Raids = {

	-- Respawn timer
	["StableRespawn"] = {t=1500, c="cooldown", global="true", m="Attumen", icontex="Spell_Holy_Resurrection"};
	["鬼魂顝顱馬"] = {t=0, pBar="StableRespawn"};
	["鬼魂戰馬"] = {t=0, pBar="StableRespawn"};
	["獵人阿圖曼"] = {t=0, tchange={"StableRespawn", "perm", 0}, delBar="StableRespawn"};
 
	["DancerRespawn"] = {t=3600, c="cooldown", global="true", m="Moroes", icontex="Spell_Holy_Resurrection"};
	["魅影賓客"] = {t=0, pBar="DancerRespawn"};
	["摩洛"] = {t=0, tchange={"DancerRespawn", "perm", 0}, delBar="DancerRespawn"};

	["GuestQuarterRespawn"] = {t=3600, c="cooldown", global="true", m="Maiden", icontex="Spell_Holy_Resurrection"};
	["魅影守衛"] = {t=0, pBar="GuestQuarterRespawn"};
	["鬼靈侍衛"] = {t=0, pBar="GuestQuarterRespawn"};
	["貞潔聖女"] = {t=0, tchange={"GuestQuarterRespawn", "perm", 0}, delBar="GuestQuarterRespawn"};

	["TheatreRespawn"] = {t=3600, c="cooldown", global="true", m="Opera", icontex="Spell_Holy_Resurrection"};
	["骸骨接待員"] = {t=0, pBar="TheatreRespawn"};
	["老巫婆"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
	["大野狼"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
	["Ghostly Philanthropist"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"}; --! translate

	["GalleryRespawn"] = {t=3600, c="cooldown", global="true", m="Curator", icontex="Spell_Holy_Resurrection"};
	["秘法警備者"] = {t=0, pBar="GalleryRespawn"};
	["監護者"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, delBar="GalleryRespawn"};

	["LibraryRespawn1"] = {t=7200, c="cooldown", global="true", m="Aran", icontex="Spell_Holy_Resurrection"};
	["秘法防禦者"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, pBar="LibraryRespawn1", delBar="GalleryRespawn"};
	["埃蘭之影"] = {t=0, tchange={"LibraryRespawn1", "perm", 0}, delBar="LibraryRespawn1"};

	["LibraryRespawn2"] = {t=7200, c="cooldown", global="true", m="Illhoof", icontex="Spell_Holy_Resurrection"};
	["魔胎"] = {t=0, pBar="LibraryRespawn2"};
	["暗影掠奪者"] = {t=0, pBar="LibraryRespawn2"};
	["泰瑞斯提安·疫蹄"] = {t=0, tchange={"LibraryRespawn2", "perm", 0}, delBar="LibraryRespawn2"};

	["LibraryRespawn3"] = {t=7200, c="cooldown", global="true", m="Netherspite", icontex="Spell_Holy_Resurrection"};
	["巫術鬼魂"] = {t=0, pBar="LibraryRespawn3"};
	["尼德斯"] = {t=0, tchange={"LibraryRespawn3", "perm", 0}, delBar="LibraryRespawn3"};

	["TheTopRespawn"] = {t=7200, c="cooldown", global="true", m="Malchezaar", icontex="Spell_Holy_Resurrection"};
	["食屍獸"] = {t=0, pBar="TheTopRespawn"};
	["巨型食屍獸"] = {t=0, pBar="TheTopRespawn"};
	["莫克札王子"] = {t=0, tchange={"TheTopRespawn", "perm", 0}, delBar="TheTopRespawn"};
	}
	
	CEnemyCastBar_Afflictions["脆弱骨頭"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0
	CEnemyCastBar_Afflictions["烈焰火圈"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
	CEnemyCastBar_Afflictions["超載"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

	NECB_PvE_Debuffs = true; -- force register events

	CEnemyCastBar_Raids = {
	["The Baron's Ultimatum"] = {t=2700, c="cooldown", global="true", m="Baron Run", icontex="Spell_Holy_Resurrection"}; --! translate
	["瑞文戴爾男爵"] = {t=0, delBar="The Baron's Ultimatum"};
	}

	elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["FIRST_LOCUST_SWARM"] = "第一次蝗蟲風暴";
	NECB_PvE_Vars["ENRAGED_MODE1"] = "激怒模式 ";
	NECB_PvE_Vars["WEB_SPRAY"] = "撒網";
	NECB_PvE_Vars["DISRUPTING_SHOUT"] = "混亂怒吼";
	NECB_PvE_Vars["DECIMATE"] = "屠殺";
	NECB_PvE_Vars["BECOME_ENRAGED"] = "變得狂暴!";
	NECB_PvE_Vars["ENRAGE"] = "激怒";
	NECB_PvE_Vars["15SEC_DOOM_CD"] = "15秒末日CD!";
	NECB_PvE_Vars["FIRST_INVITABLE_DOOM"] = "第一次無可避免的末日";
	NECB_PvE_Vars["COMES_DOWN"] = "下來了";
	
	NECB_PvE_Vars["1ST_TRAINEES_INCOME"] = "第一次小兵到來";
	NECB_PvE_Vars["1ST_DK_INCOME"] = "第一次死期到來";
	NECB_PvE_Vars["1ST_RIDER_INCOME"] = "第一次騎兵到來";
	NECB_PvE_Vars["TRAINEES_INCOME"] = "小兵到來";
	NECB_PvE_Vars["DK_INCOME"] = "死亡騎士到來";
	NECB_PvE_Vars["RIDER_INCOME"] = "騎兵到來";
	NECB_PvE_Vars["FIRST_TELEPORT"] = "第一次傳送";
	NECB_PvE_Vars["ON_PLATFORM"] = "上台";
	NECB_PvE_Vars["TELEPORT_CD"] = "傳送 CD";

	CEnemyCastBar_Raids = {
	
	-- Naxxramas

	["Necro Stalker"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};

	-- Anub'Rekhan
	[NECB_PvE_Vars["FIRST_LOCUST_SWARM"]] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
	["蝗蟲風暴"] = {t=23, i=3, c="gainsfoe", delBar="蝗蟲風暴 CD", aBar="蝗蟲風暴 CD", active="true", icontex="Spell_Nature_InsectSwarm"};
	["蝗蟲風暴 CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};

	-- Patchwerk
	[NECB_PvE_Vars["ENRAGED_MODE1"]] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!

	-- Razuvious
	[NECB_PvE_Vars["DISRUPTING_SHOUT"]] = {t=25, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};

	[NECB_PvE_Vars["DISRUPTING_SHOUT"]] = {t=25, c="cooldown", active="true", delBar=NECB_PvE_Vars["DISRUPTING_SHOUT"].." possible", aBar=CECB_SPRLL_DISRUPTING_SHOUT.." possible", icontex="Ability_Creature_Disease_02"};
	[NECB_PvE_Vars["DISRUPTING_SHOUT"].." possible"] = {t=25, c="cooldown", aBar=NECB_PvE_Vars["DISRUPTING_SHOUT"].." possible", icontex="Ability_Creature_Disease_02"};

	-- Gluth
	["恐嚇咆哮"] = {t=20.0, c="cooldown", m="古魯斯", aZone="Naxxramas", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
	[NECB_PvE_Vars["DECIMATE"]] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};

	-- Maexxna
	[NECB_PvE_Vars["WEB_SPRAY"]] = {t=40, c="cooldown", pBar="梅克絲娜之子", m="梅克絲娜", aZone="納克薩瑪斯", icontex="Ability_Ensnare"};
	["梅克絲娜之子"] = {t=30, c="cooldown", pBar="纏繞的蜘蛛網 CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
	["纏繞的蜘蛛網 CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};

	-- Thaddius
	["兩極移形"] = {t=30, i=3, c="cooldown", pBar=NECB_PvE_Vars["BECOME_ENRAGED"], mcheck="泰迪斯", icontex="Spell_Nature_Lightning"};
	["力量澎湃"] = {t=10, c="gainsfoe", mcheck="Stalagg", icontex="Spell_Shadow_SpectralSight"};
	[NECB_PvE_Vars["BECOME_ENRAGED"]] = {t=290, c="cooldown", global="true", tchange={NECB_PvE_Vars["BECOME_ENRAGED"], 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated

	-- Faerlina
	[NECB_PvE_Vars["ENRAGE"]] = {t=60, c="cooldown", mcheck="大寡婦費琳娜", icontex="Spell_Shadow_UnholyFrenzy"};
	["寡婦之擁"] = {t=30, c="cooldown", mcheck="大寡婦費琳娜", icontex="Spell_Arcane_Blink"}; -- Fearlina

	-- Loatheb
	[NECB_PvE_Vars["15SEC_DOOM_CD"]] = {t=299, tchange={"無可避免的末日", 30, 15}, c="cooldown", m="洛斯伯", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
	[NECB_PvE_Vars["FIRST_INVITABLE_DOOM"]] = {t=120, c="cooldown", m="洛斯伯", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
	["無可避免的末日"] = {t=30, c="cooldown", m="洛斯伯", icontex="Spell_Shadow_NightOfTheDead"};

	["召喚孢子"] = {t=12.5, icasted="true", c="cooldown", mcheck="洛斯伯", icontex="Spell_Nature_AbolishMagic"};
	["解除洛斯伯身上的詛咒"] = {t=0.1, icasted="true", c="cooldown", pBar="詛咒已解除", mcheck="洛斯伯"};
	["詛咒已解除"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"};

	-- Gothik
	-- don't translate, ALL used internally!
	[NECB_PvE_Vars["COMES_DOWN"]] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
	["del1"] = {t=0.1, pBar="del2", delBar=NECB_PvE_Vars["TRAINEES_INCOME"]};
	["del2"] = {t=0.1, pBar="del3", delBar=NECB_PvE_Vars["DK_INCOME"]};
	["del3"] = {t=0.1, delBar=NECB_PvE_Vars["RIDER_INCOME"]};

	[NECB_PvE_Vars["1ST_TRAINEES_INCOME"]] = {t=27, c="cooldown", aBar=NECB_PvE_Vars["TRAINEES_INCOME"], icontex="INV_Misc_Head_Undead_01"};
	[NECB_PvE_Vars["1ST_DK_INCOME"]] = {t=77, c="cooldown", aBar=NECB_PvE_Vars["DK_INCOME"], icontex="Spell_Shadow_ShadowWard"};
	[NECB_PvE_Vars["1ST_RIDER_INCOME"]] = {t=137, c="cooldown", aBar=NECB_PvE_Vars["RIDER_INCOME"], icontex="Ability_Mount_Undeadhorse"};
	[NECB_PvE_Vars["TRAINEES_INCOME"]] = {t=20, c="cooldown", aBar=NECB_PvE_Vars["TRAINEES_INCOME"], icontex="INV_Misc_Head_Undead_01"};
	[NECB_PvE_Vars["DK_INCOME"]] = {t=25, c="cooldown", aBar=NECB_PvE_Vars["DK_INCOME"], icontex="Spell_Shadow_ShadowWard"};
	[NECB_PvE_Vars["RIDER_INCOME"]] = {t=30, c="cooldown", aBar=NECB_PvE_Vars["RIDER_INCOME"], icontex="Ability_Mount_Undeadhorse"};


	-- Noth

	["閃現術"] = {t=30, c="cooldown", mcheck="瘟疫者諾斯", aZone="納克薩瑪斯", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
	[NECB_PvE_Vars["FIRST_TELEPORT"]] = {t=90, c="cooldown", aBar="上台 1", aZone="納克薩瑪斯", icontex="Spell_Nature_AstralRecalGroup"};
	["上牆 1"] = {t=70, c="cooldown", aBar="第二次傳送", icontex="Spell_Nature_AstralRecalGroup"};
	["第二次傳送"] = {t=110, c="cooldown", aBar="上台 2", icontex="Spell_Nature_AstralRecalGroup"};
	["上牆 2"] = {t=95, c="cooldown", aBar="第三次傳送", icontex="Spell_Nature_AstralRecalGroup"};
	["第三次傳送"] = {t=180, c="cooldown", aBar="上台 3", icontex="Spell_Nature_AstralRecalGroup"};
	["上牆 3"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};

	-- Heigan

	[NECB_PvE_Vars["ON_PLATFORM"]] = {t=45, c="cooldown", aBar=NECB_PvE_Vars["TELEPORT_CD"], icontex="INV_Enchant_EssenceAstralLarge"};
	[NECB_PvE_Vars["TELEPORT_CD"]] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};

	-- Sapphiron
	["生命吸取警報"] = {t=24, c="cooldown", m="薩菲隆", aZone="納克薩瑪斯", icontex="Spell_Shadow_LifeDrain02"};
	
	}
	
	
	-- Naxxramas
	NECB_PvE_Vars["HEIGAN_YELL1"]	  = "我看到你了……";
	NECB_PvE_Vars["HEIGAN_YELL2"]	  = "你是我的了。";
	NECB_PvE_Vars["HEIGAN_YELL3"]	  = "你……就是下一個。";
	NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]  = "你的生命正走向終結。";
	
	NECB_PvE_Vars["FAER_YELL1"]	= "跪下求饒吧，懦夫！";
	NECB_PvE_Vars["FAER_YELL2"]	= "休想從我面前逃掉！";
	NECB_PvE_Vars["FAER_YELL3"]	= "逃啊！有本事就逃啊！";
	NECB_PvE_Vars["FAER_YELL4"]	= "以主人之名，殺了他們！";
	
	NECB_PvE_Vars["PATCHWERK_NAME"]	= "縫補者";
	
	NECB_PvE_Vars["GOTHIK_YELL"]	= "你愚蠢地尋找自己的困境";
	
	NECB_PvE_Vars["ANUB_NAME"]	 = "阿努比瑞克漢";
	
	NECB_PvE_Vars["ANUB_YELL1"]	= "一些小點心……";
	NECB_PvE_Vars["ANUB_YELL2"]	= "對，跑吧！那樣傷口出血就更多了！";
	NECB_PvE_Vars["ANUB_YELL3"]	= "你們逃不掉的。";
	
	NECB_PvE_Vars["RAZUVIOUS_NAME"]	= "拉祖維斯";
	NECB_PvE_Vars["RAZUVIOUS_NAME_PAT"]    = "拉祖維斯";
	NECB_PvE_Vars["FAERLINA_NAME"]	 = "大寡婦費琳娜";
	NECB_PvE_Vars["FAERLINA_NAME_PAT"]     = "大寡婦費琳娜";
	NECB_PvE_Vars["GOTHIK_NAME"]	= "高希";
	NECB_PvE_Vars["GOTHIK_NAME_PAT"]       = "高希";
	NECB_PvE_Vars["NOTH_NAME"]	 = "諾斯";
	NECB_PvE_Vars["NOTH_NAME_PAT"]	 = "諾斯";
	NECB_PvE_Vars["HEIGAN_NAME"]	= "海根";
	NECB_PvE_Vars["HEIGAN_NAME_PAT"]       = "海根";
	
	NECB_PvE_Vars["SAPPHIRON_NAME"]	= "薩菲隆";

	-- Naxxramas
	CEnemyCastBar_Afflictions["致死傷口"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
	CEnemyCastBar_Afflictions["變異注射"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
	CEnemyCastBar_Afflictions["纏繞的蜘蛛網"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
	CEnemyCastBar_Afflictions["墓地毒"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; -- Maexxna MT -healing Debuff(poison)
	CEnemyCastBar_Afflictions["爆裂法力"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb --! correct? "Detonate Mana"

	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	
	elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["TWIN_TELEPORT"] = "雙子傳送";
	NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"] = "可能發生的奧羅潛水";
	NECB_PvE_Vars["SMALL_EYE_P1"] = "小眼睛階段一";
	NECB_PvE_Vars["SMALL_EYE_P2"] = "小眼睛階段二";
	NECB_PvE_Vars["FIRST_SMALL_EYE_P2"] = "第一次小眼睛階段二";
	NECB_PvE_Vars["AFTER_WEAKENED_EYES"] = "虛弱之後的眼睛";
	NECB_PvE_Vars["WEAKENED"] = "變虛弱!";
	NECB_PvE_Vars["FIRST_DARK_GLARE"] = "第一次黑暗閃耀";
	NECB_PvE_Vars["DARK_GLARE"] = "黑暗閃耀";
	NECB_PvE_Vars["ENRAGED_MODE2"] = "激怒模式";
	NECB_PvE_Vars["ENTER_ENRAGED_MODE"] = "進入激怒模式";
	NECB_PvE_Vars["BERSERK_MODE"] = "狂暴模式";
	NECB_PvE_Vars["ENTER_BERSERK_MODE"] = "進入狂暴模式";

	CEnemyCastBar_Raids = {
	
	-- Ahn'Qiraj

	-- 40 Man
	["黑曜石根除者"] = {t=1800.0, c="cooldown", global="true", m="重生", icontex="Spell_Holy_Resurrection"};

	-- Twin Emperors
	[NECB_PvE_Vars["TWIN_TELEPORT"]] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
	["爆炸蟲"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
	["變形包"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};

	-- Ouro
	["沙塵爆裂"] = {t=2.0, c="hostile", mcheck="奧羅", icontex="Spell_Nature_Cyclone"};
	["橫掃"] = {t=21, i=1.0, c="cooldown", mcheck="奧羅", icontex="Spell_Nature_Thorns"};


	["召喚奧羅土堆"] = {t=0.1, delBar=NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"], icasted="true", pBar="潛水"};
	["潛水"] = {t=30, c="cooldown", delBar="奧羅潛水", aBar=NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"], icontex="INV_Qiraj_OuroHide"};
	[NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"]] = {t=90, c="cooldown", pBar="奧羅潛水", icontex="Spell_Shadow_DemonBreath"};
	["奧羅潛水"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"};


	-- C'Thun
	[NECB_PvE_Vars["FIRST_DARK_GLARE"]] = {t=48, c="cooldown", aBar=NECB_PvE_Vars["DARK_GLARE"], icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
	[NECB_PvE_Vars["WEAKENED"]] = {t=45, c="gainsfoe", delBar=NECB_PvE_Vars["SMALL_EYE_P2"], aBar=NECB_PvE_Vars["AFTER_WEAKENED_EYES"], icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
	[NECB_PvE_Vars["DARK_GLARE"]] = {t=86, i=40, c="cooldown", active="true", aBar=NECB_PvE_Vars["DARK_GLARE"], icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
	[NECB_PvE_Vars["SMALL_EYE_P1"]] = {t=45, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P1"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	[NECB_PvE_Vars["FIRST_SMALL_EYE_P2"]] = {t=42, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	[NECB_PvE_Vars["SMALL_EYE_P2"]] = {t=30, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	[NECB_PvE_Vars["AFTER_WEAKENED_EYES"]] = {t=38, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!

	-- Skeram
	["魔爆術"] = {t=1.2, c="hostile", mcheck="預言者斯克拉姆", icontex="Spell_Nature_WispSplode"};

	-- Sartura (Twin Emps enrage + Hakkar enrage)
	["旋風斬"] = {t=15.0, c="gainsfoe", mcheck="沙爾圖拉", icontex="Ability_Whirlwind"};
	[NECB_PvE_Vars["ENRAGED_MODE2"]] = {t=900, r="沙爾圖拉 哈卡", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	[NECB_PvE_Vars["ENTER_ENRAGED_MODE"]] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!

	-- Huhuran
	[NECB_PvE_Vars["BERSERK_MODE"]] = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
	[NECB_PvE_Vars["ENTER_BERSERK_MODE"]] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
	["翼龍釘刺"] = {t=25, c="cooldown", m="哈霍蘭公主", aZone="安其拉神廟", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};

	-- Yauj
	["恐懼術"] = {t=20, c="cooldown", checkengage="true", m="亞爾基公主", aZone="安其拉神廟", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
	["強效治療術"] = {t=2.0, c="hostile", m="亞爾基公主", mcheck="亞爾基公主", icontex="Spell_Holy_Heal"};
	
	
	}
	
	-- AQ40
	NECB_PvE_Vars["SARTURA_NAME"]	  = "沙爾圖拉";
	NECB_PvE_Vars["SARTURA_NAME_PAT"]      = "沙爾圖拉";
	NECB_PvE_Vars["HUHURAN_NAME"]	  = "哈霍蘭公主";
	NECB_PvE_Vars["HUHURAN_NAME_PAT"]      = "哈霍蘭公主";
	NECB_PvE_Vars["VEKLOR_NAME"]	= "維克洛爾";
	NECB_PvE_Vars["VEKNILASH_NAME"]	= "維克尼拉斯";
	NECB_PvE_Vars["YAUJ_NAME"]	 = "亞爾基公主";
	NECB_PvE_Vars["YAUJ_NAME_PAT"]	 = "亞爾基公主";
	NECB_PvE_Vars["DETECTED_NAME"]	 = "偵測到";
	NECB_PvE_Vars["KRI_NAME"]	  = "克里勳爵";
	NECB_PvE_Vars["KRI_NAME_PAT"]	  = "克里勳爵";
	NECB_PvE_Vars["VEM_NAME"]	  = "維姆";
	NECB_PvE_Vars["GLUTH_NAME"]	= "古魯斯";
	NECB_PvE_Vars["MAEXXAN_NAME"]	  = "梅克絲娜";
	NECB_PvE_Vars["LOATHEB_NAME"]	  = "洛斯伯";
	NECB_PvE_Vars["OURO_NAME"]	 = "奧羅";
	NECB_PvE_Vars["TWINS_NAME"]	= "雙子";
	
	
	NECB_PvE_Vars["SARTURA_CALL"]	  = "我判你死刑！";
	NECB_PvE_Vars["SARTURA_CRAZY"]	 = "變得憤怒了！";
	
	NECB_PvE_Vars["HUHURAN_CRAZY"]	 = "變得狂暴起來！";
	
	NECB_PvE_Vars["CTHUN_NAME1"]	= "克蘇恩之眼";
	NECB_PvE_Vars["CTHUN_NAME2"]	= "克蘇恩";
	NECB_PvE_Vars["CTHUN_WEAKENED"]	= "變弱了！";

	-- AQ40
	CEnemyCastBar_Afflictions["充實"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
	CEnemyCastBar_Afflictions["瘟疫"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
	CEnemyCastBar_Afflictions["糾纏"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	
	elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["UNTIL_STONEFORM"] = "石化狀態";

	CEnemyCastBar_Raids = {
	
	
	-- 20 Man

	["爆炸"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};

	-- Ossirian
	["祕法虛弱"] = {t=45, c="gainsfoe", mcheck="無疤者奧斯里安", icontex="INV_Misc_QirajiCrystal_01"};
	["火焰虛弱"] = {t=45, c="gainsfoe", mcheck="無疤者奧斯里安", icontex="INV_Misc_QirajiCrystal_02"};
	["自然虛弱"] = {t=45, c="gainsfoe", mcheck="無疤者奧斯里安", icontex="INV_Misc_QirajiCrystal_03"};
	["冰霜虛弱"] = {t=45, c="gainsfoe", mcheck="無疤者奧斯里安", icontex="INV_Misc_QirajiCrystal_04"};
	["暗影虛弱"] = {t=45, c="gainsfoe", mcheck="無疤者奧斯里安", icontex="INV_Misc_QirajiCrystal_05"};

	-- Moam
	[NECB_PvE_Vars["UNTIL_STONEFORM"]] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
	["充能"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
	}
	
	-- Ruins of AQ
	NECB_PvE_Vars["MOAM_NAME"]	 = "莫阿姆";
	NECB_PvE_Vars["MOAM_STARTING"]	 = "因神態失常而坐立不安。";

	-- AQ20
	CEnemyCastBar_Afflictions["麻痹"] = {t=10, global="true", aZone="安其拉廢墟", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
	-- Moam removal
	CEnemyCastBar_Afflictions["充能"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;
	NECB_PvE_YellEmoteCombat = true;
	

	NECB_PvE_Vars["BLOOD_SIPHON"] = "血液虹吸";
	NECB_PvE_Vars["ENRAGED_MODE2"] = "激怒模式";

	CEnemyCastBar_Raids = {
	
	-- Zul'Gurub

	-- Hakkar
	[NECB_PvE_Vars["BLOOD_SIPHON"]] = {t=90.0, c="cooldown", mcheck="哈卡", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
	[NECB_PvE_Vars["ENRAGED_MODE2"]] = {t=900, r="沙爾圖拉 哈卡", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
	}
	
	-- Zul'Gurub
	NECB_PvE_Vars["HAKKAR_NAME"]	= "哈卡";
	NECB_PvE_Vars["HAKKAR_YELL"]	= "驕傲會將你送上絕路";

	-- Zul'Gurub
	CEnemyCastBar_Afflictions["金度的欺騙"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
	CEnemyCastBar_Afflictions["導致瘋狂"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
	CEnemyCastBar_Afflictions["威懾凝視"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["SUBMERGE"]   = "暫時消失";
	NECB_PvE_Vars["KNOCKBACK"]  = "群體擊退";
	NECB_PvE_Vars["SONS_OF_FLAME"] = "烈焰之子";

	CEnemyCastBar_Raids = {
	
	-- Molten Core

	-- Shazzrah
	["沙斯拉爾之門"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};

	-- Lucifron
	["末日降臨"] = {t=20.0, c="cooldown", m="魯西弗隆", icontex="Spell_Shadow_NightOfTheDead"};
	["魯西弗隆的詛咒"] = {t=20.0, c="cooldown", m="魯西弗隆", icontex="Spell_Shadow_BlackPlague"};

	-- Magmadar
	["恐慌"] = {t=30.0, c="cooldown", m="瑪格曼達", icontex="Spell_Shadow_DeathScream"};

	-- Gehennas
	["基赫納斯的詛咒"] = {t=30.0, c="cooldown", m="基赫納斯", icontex="Spell_Shadow_GatherShadows"};

	-- Geddon
	["地獄火"] = {t=8.0, c="gainsfoe", mcheck="迦頓男爵", icontex="Spell_Fire_Incinerate"};

	-- Majordomo
	["魔法反射"] = {t=30.0, i=10.0, c="cooldown", m="管理者埃克索圖斯", aZone="熔火之心", icontex="Spell_Frost_FrostShock"};
	["傷害反射護盾"] = {t=30.0, i=10.0, c="cooldown", m="管理者埃克索圖斯", icontex="Spell_Nature_LightningShield"};

	-- Ragnaros
	[NECB_PvE_Vars["SUBMERGE"]] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
	[NECB_PvE_Vars["KNOCKBACK"]] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
	[NECB_PvE_Vars["SONS_OF_FLAME"]] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!
	
	}
	
	-- MC
	NECB_PvE_Vars["RAGNAROS_NAME"]	 = "拉格納羅斯";
	
	NECB_PvE_Vars["RAGNAROS_STARTING"]     = "現在輪到你們了！";
	NECB_PvE_Vars["RAGNAROS_KICKER"]       = "感受薩弗隆的烈焰吧！";
	NECB_PvE_Vars["RAGNAROS_SONS"]	 = "出現吧，我的奴僕";

	-- MC
	CEnemyCastBar_Afflictions["活化炸彈"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["DEEP_BREATH"] = "深呼吸";

	CEnemyCastBar_Raids = {
	
	-- Onyxia
	["火息術"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
	[NECB_PvE_Vars["DEEP_BREATH"]] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"};
	["龍翼打擊"] = {t=31.5, i=0, c="cooldown", icontex="INV_Misc_MonsterScales_14"};
	["低沉咆哮"] = {t=1.5, c="hostile", active="true", icontex="Spell_Shadow_Charm"};
	
	
	}
	
	-- ONY
	NECB_PvE_Vars["ONY_DB"]	= "深深地吸了一口氣";
	NECB_PvE_Vars["ONYXIA_NAME"]	= "奧妮克希亞"; 
	
	elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["MOB_SPAWN_45SEC"] = "怪物出生 (45秒)";
	NECB_PvE_Vars["FIRST_WINGBUFFET"] = "第一次龍翼打擊";
	NECB_PvE_Vars["KILLING_FRENZY"] = "殺戮狂暴";
	NECB_PvE_Vars["NEF_CALLS"]  = "奈法利安點名";
	NECB_PvE_Vars["MOB_SPAWN"]  = "怪物出生";
	NECB_PvE_Vars["LANDING"]    = "降落" ;

	CEnemyCastBar_Raids = {
	
	-- Blackwing Lair

	-- Razorgore
	[NECB_PvE_Vars["MOB_SPAWN_45SEC"]] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!

	-- Firemaw/Flamegor/Ebonroc
	["龍翼打擊"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};

	[NECB_PvE_Vars["FIRST_WINGBUFFET"]] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"}; -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
	["暗影烈焰"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"};

	-- Flamegor
	[CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!

	-- Chromaggus
	["冰霜灼燒"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
	["時間流逝"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
	["點燃軀體"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
	["腐蝕酸液"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
	["焚燒"] = {t=60.0, i=2.0, c="cooldown", active="true", mcheck="克洛瑪古斯", icontex="Spell_Fire_FlameShock"};

	[NECB_PvE_Vars["KILLING_FRENZY"]] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
	-- Chromaggus, Flamegor, Magmadar etc.
	["狂暴"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};

	-- Neferian/Onyxia
	["低沉咆哮"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};

	-- Nefarian
	[NECB_PvE_Vars["NEF_CALLS"]] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	[NECB_PvE_Vars["MOB_SPAWN"]] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
	[NECB_PvE_Vars["LANDING"]] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
	}
	
	-- BWL
	NECB_PvE_Vars["CHROMAGGUS"]	= "克洛瑪古斯";
	
	NECB_PvE_Vars["NEFARIUS_NAME"]	 = "奈法利斯";
	NECB_PvE_Vars["NEFARIAN_NAME"]	 = "奈法利安";
	
	NECB_PvE_Vars["GRETHOK_NAME"]	  = "黑翼控制者";
	NECB_PvE_Vars["GRETHOK_NAME_PAT"]      = "黑翼控制者";
	
	NECB_PvE_Vars["RAZORGORE_NAME"]	= "狂野的拉佐格爾";
	
	NECB_PvE_Vars["RAZORGORE_CALL"]	= "入侵者";
	
	NECB_PvE_Vars["FIREMAW_NAME"]	  = "費爾默";
	NECB_PvE_Vars["EBONROC_NAME"]	  = "埃博諾克";
	NECB_PvE_Vars["FLAMEGOR_NAME"]	 = "弗萊格爾";
	NECB_PvE_Vars["FLAMEGOR_FRENZY"]       = "變得狂暴起來！";
	NECB_PvE_Vars["CHROMAGGUS_FRENZY"]     = "變得極為狂暴！";
	
	NECB_PvE_Vars["NEFARIAN_STARTING"]     = "讓遊戲開始吧！";
	NECB_PvE_Vars["NEFARIAN_LAND"]	 = "幹得好，我的手下。";
	NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"]  = "薩滿，讓我看看";
	NECB_PvE_Vars["NEFARIAN_DRUID_CALL"]   = "德魯伊和你們愚蠢的";
	NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"] = "術士，不要隨便去玩";
	NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"]  = "牧師！如果你要繼續";
	NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"]  = "獵人和你那討厭的豌豆射擊";
	NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"] = "戰士，我知道你應該比較抗打";
	NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"]   = "盜賊？不要躲了";
	NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"] = "聖騎士……聽說你有無數條命";
	NECB_PvE_Vars["NEFARIAN_MAGE_CALL"]    = "還有法師？";

	-- Class Call Name
	NECB_PvE_Vars["CLASS_DRUIDS"]   = "德魯伊們";
	NECB_PvE_Vars["CLASS_HUNTERS"]  = "獵人們";
	NECB_PvE_Vars["CLASS_MAGES"]    = "法師們";
	NECB_PvE_Vars["CLASS_PALADINS"] = "聖騎士們";
	NECB_PvE_Vars["CLASS_PRIESTS"]  = "牧師們";
	NECB_PvE_Vars["CLASS_ROGUES"]   = "盜賊們";
	NECB_PvE_Vars["CLASS_SHAMANS"]  = "薩滿們";
	NECB_PvE_Vars["CLASS_WARLOCKS"] = "術士們";
	NECB_PvE_Vars["CLASS_WARRIORS"] = "戰士們";

	-- BWL
	CEnemyCastBar_Afflictions["燃燒"] = {t=10.0, global="true", aZone="Blackwing Lair", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning
	CEnemyCastBar_Afflictions["燃燒刺激"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA
	CEnemyCastBar_Afflictions["埃博諾克之影"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff
	-- Non Boss DeBuffs:
	CEnemyCastBar_Afflictions["強效變形術"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	else
	CEnemyCastBar_Raids = { };
	NECB_PvE_Vars = { };

	end
	
	-- Other
	
	for k, v in pairs (CEnemyCastBar_Raids) do
	CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
	break;
	end

	--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

	if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
	CECB_ReloadOptionsUI(); -- update tooltip
	end

  end

end