--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!

if ( GetLocale() == "enUS" or GetLocale() == "enGB" ) then

		-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
		-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
		-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
		-- "active" only allows this spell to be an active cast, no afflictions and something else!
		-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
		-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
		-- "icasted" guides this spell through the instant cast protection
		-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
		-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
		-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
		-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
		-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
		-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
		--  tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas = "Naxxramas";
	NECB_AhnQiraj = "Ahn'Qiraj";
	NECB_AhnQirajRuins = "Ruins of Ahn'Qiraj";
	NECB_ZulGurub = "Zul'Gurub";
	NECB_MoltenCore = "Molten Core";
	NECB_OnyxiaLair = "Onyxia's Lair";
	NECB_BlackwingLair = "Blackwing Lair";
	NECB_Stratholme = "Stratholme";
	--BC
	NECB_ShatteredHalls = "The Shattered Halls";
	NECB_Magtheridon = "Magtheridon's Lair";
	NECB_GruulsLair = "Gruul's Lair";
	NECB_Karazhan = "Karazhan";
	NECB_SerpentshrineCavern = "Serpentshrine Cavern";
	NECB_Tempest_Keep = "Tempest Keep";
	NECB_Black_Temple = "Black Temple";
	NECB_ZulAman = "Zul'Aman";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
		NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
		if not forcereg then
			return;
		end
		break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Magtheridon
	
			-- Respawn timer
			["TrashRespawn"] = {t=7200, c="cooldown", global="true", m="Magtheridon", icontex="Spell_Holy_Resurrection"};
				["Hellfire Warder"] = {t=0, pBar="TrashRespawn"};
					["Magtheridon"] = {t=0, delBar="TrashRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Amani'shi Tempest"] = {t=0, pBar="Akil'zon Trash"};
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};

		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Black Temple Respawn timer

			["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Aqueous Lord"] = {t=0, pBar="Naj'entus Trash"};
				["Coilskar General"] = {t=0, pBar="Naj'entus Trash"};
				["Coilskar Harpooner"] = {t=0, pBar="Naj'entus Trash"};
				["Leviathan"] = {t=0, pBar="Naj'entus Trash"};
				-- + Coilskar Soothsayer, Coilskar Wrangler
					["High Warlord Naj'entus"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"};

			["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Ashtongue Primalist"] = {t=0, pBar="Akama Trash"};
				["Ashtongue Mystic"] = {t=0, pBar="Akama Trash"};
				["Ashtongue Battlelord"] = {t=0, pBar="Akama Trash"};
					["Shade of Akama"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"};

			["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Shadowmoon Champion"] = {t=0, pBar="Gorefiend Trash"};
				["Shadowmoon Reaver"] = {t=0, pBar="Gorefiend Trash"};
					["Teron Gorefiend"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"};

			["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Arbeiter der Knochenmalmer"] = {t=0, pBar="Supremus Trash"};
				["Bonechewer Taskmaster"] = {t=0, pBar="Supremus Trash"};
					["Supremus"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"};

			["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Bonechewer Shield Disciple"] = {t=0, pBar="Gurtogg Trash"};
				["Bonechewer Blade Fury"] = {t=0, pBar="Gurtogg Trash"};
				["Mutant War Hound"] = {t=0, pBar="Gurtogg Trash"};
					["Gurtogg Bloodboil"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"}; 

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Temple Concubine"] = {t=0, pBar="Mother Shahraz Trash"};
				["Charming Courtesan"] = {t=0, pBar="Mother Shahraz Trash"};
				["Spellbound Attendant"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pain"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pleasure"] = {t=0, pBar="Mother Shahraz Trash"};
					["Mother Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Promenade Sentinel"] = {t=0, pBar="Illidari Council Trash"};
					["Gathios the Shatterer"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	

		}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Tempest Keep
	
			-- Respawn timer
			["Al'ar Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Star Scryer"] = {t=0, pBar="Al'ar Trash"};
				["Astromancer"] = {t=0, pBar="Al'ar Trash"};
				["Bloodwarder Vindicator"] = {t=0, pBar="Al'ar Trash"};
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Al'ar Trash"};
					["Al'ar"] = {t=0, tchange={"Al'ar Trash", "perm", 0}, delBar="Al'ar Trash"};

			["Void Reaver Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Crystalcore Devastator"] = {t=0, pBar="Void Reaver Trash"};
				--["Crystalcore Sentinel"] = {t=0, pBar="Void Reaver Trash"};
					["Void Reaver"] = {t=0, tchange={"Void Reaver Trash", "perm", 0}, delBar="Void Reaver Trash"};

			["Astromancer Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Astromancer Lord"] = {t=0, pBar="Astromancer Trash"};
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Astromancer Trash"};
				["Novice Astromancer"] = {t=0, pBar="Astromancer Trash"};
					["High Astromancer Solarian"] = {t=0, tchange={"Astromancer Trash", "perm", 0}, delBar="Astromancer Trash"};

			["Kael'thas Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Crimson Hand Battle Mage"] = {t=0, pBar="Kael'thas Trash"};
				["Crimson Hand Blood Knight"] = {t=0, pBar="Kael'thas Trash"};
				["Crimson Hand Centurion"] = {t=0, pBar="Kael'thas Trash"};
				["Crimson Hand Inquisitor"] = {t=0, pBar="Kael'thas Trash"};
					["Kael'thas Sunstrider"] = {t=0, tchange={"Kael'thas Trash", "perm", 0}, delBar="Kael'thas Trash"};
		}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	    
	        CEnemyCastBar_Raids = {
	        
	        -- Serpentshrine Cavern
	        
		        -- Respawn timer
			["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Coilfang Beast-Tamer"] = {t=0, pBar="HydrossTrash"};
				["Coilfang Hate-Screamer"] = {t=0, pBar="HydrossTrash"};
				["Serpentshrine Sporebat"] = {t=0, pBar="HydrossTrash"};
					["Hydross the Unstable"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

			["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Vashj'ir Honor Guard"] = {t=0, pBar="LurkerTrash"};
				["Coilfang Priestess"] = {t=0, pBar="LurkerTrash"};
					["The Lurker Below"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

			["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Greyheart Nether-Mage"] = {t=0, pBar="MixedTrash"};
				["Greyheart Tidecaller"] = {t=0, pBar="MixedTrash"};
				["Greyheart Skulker"] = {t=0, pBar="MixedTrash"};

			["TidewalkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Tidewalker Shaman"] = {t=0, pBar="TidewalkerTrash"};
				["Tidewalker Depth-Seer"] = {t=0, pBar="TidewalkerTrash"};
				["Tidewalker Warrior"] = {t=0, pBar="TidewalkerTrash"};
					["Morogrim Tidewalker"] = {t=0, tchange={"TidewalkerTrash", "perm", 0}, delBar="TidewalkerTrash"};

			["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Greyheart Shield-Bearer"] = {t=0, pBar="LeotherasTrash"};
					["Leotheras the Blind"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"};

	        }

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["Kargath's Executioner"] = {t=4800, c="cooldown", global="true", m="Heroic Quest", icontex="Spell_Holy_Resurrection"};
			["Warchief Kargath Bladefist"] = {t=0, delBar="Kargath's Executioner"};
		}

	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
	
		CEnemyCastBar_Raids = {
	
		-- Gruuls
	
			-- Krosh Firehand
			["Magic Ward"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"}; --!correct?

			-- Respawn timer
			["OgreRespawn"] = {t=3600, c="cooldown", global="true", m="Gruul", icontex="Spell_Holy_Resurrection"};
				["Lair Brute"] = {t=0, pBar="OgreRespawn"};
				["Gronn-Priest"] = {t=0, pBar="OgreRespawn"};
					["High King Maulgar"] = {t=0, delBar="OgreRespawn"};
					["Gruul the Dragonkiller"] = {t=0, delBar="OgreRespawn"};
		}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;

		CEnemyCastBar_Raids = {

			-- Respawn timer
			["StableRespawn"] = {t=1500, c="cooldown", global="true", m="Attumen", icontex="Spell_Holy_Resurrection"};
				["Spectral Stallion"] = {t=0, pBar="StableRespawn"};
				["Spectral Charger"] = {t=0, pBar="StableRespawn"};
					["Attumen the Huntsman"] = {t=0, tchange={"StableRespawn", "perm", 0}, delBar="StableRespawn"};
 
			["DancerRespawn"] = {t=3600, c="cooldown", global="true", m="Moroes", icontex="Spell_Holy_Resurrection"};
				["Phantom Guest"] = {t=0, pBar="DancerRespawn"};
					["Moroes"] = {t=0, tchange={"DancerRespawn", "perm", 0}, delBar="DancerRespawn"};

			["GuestQuarterRespawn"] = {t=3600, c="cooldown", global="true", m="Maiden", icontex="Spell_Holy_Resurrection"};
				["Phantom Guardsman"] = {t=0, pBar="GuestQuarterRespawn"};
				["Spectral Sentry"] = {t=0, pBar="GuestQuarterRespawn"};
					["Maiden of Virtue"] = {t=0, tchange={"GuestQuarterRespawn", "perm", 0}, delBar="GuestQuarterRespawn"};

			["TheatreRespawn"] = {t=3600, c="cooldown", global="true", m="Opera", icontex="Spell_Holy_Resurrection"};
				["Skeletal Usher"] = {t=0, pBar="TheatreRespawn"};
					["The Crone"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
					["The Big Bad Wolf"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
					["Ghostly Philanthropist"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};

			["GalleryRespawn"] = {t=3600, c="cooldown", global="true", m="Curator", icontex="Spell_Holy_Resurrection"};
				["Arcane Watchman"] = {t=0, pBar="GalleryRespawn"};
					["The Curator"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, delBar="GalleryRespawn"};

			["LibraryRespawn1"] = {t=7200, c="cooldown", global="true", m="Aran", icontex="Spell_Holy_Resurrection"};
				["Arcane Protector"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, pBar="LibraryRespawn1", delBar="GalleryRespawn"};
					["Shade of Aran"] = {t=0, tchange={"LibraryRespawn1", "perm", 0}, delBar="LibraryRespawn1"};

			["LibraryRespawn2"] = {t=7200, c="cooldown", global="true", m="Illhoof", icontex="Spell_Holy_Resurrection"};
				["Homunculus"] = {t=0, pBar="LibraryRespawn2"};
				["Shadow Pillager"] = {t=0, pBar="LibraryRespawn2"};
					["Terestian Illhoof"] = {t=0, tchange={"LibraryRespawn2", "perm", 0}, delBar="LibraryRespawn2"};

			["LibraryRespawn3"] = {t=7200, c="cooldown", global="true", m="Netherspite", icontex="Spell_Holy_Resurrection"};
				["Sorcerous Shade"] = {t=0, pBar="LibraryRespawn3"};
					["Netherspite"] = {t=0, tchange={"LibraryRespawn3", "perm", 0}, delBar="LibraryRespawn3"};

			["TheTopRespawn"] = {t=7200, c="cooldown", global="true", m="Malchezaar", icontex="Spell_Holy_Resurrection"};
				["Fleshbeast"] = {t=0, pBar="TheTopRespawn"};
				["Greater Fleshbeast"] = {t=0, pBar="TheTopRespawn"};
					["Prince Malchezaar"] = {t=0, tchange={"TheTopRespawn", "perm", 0}, delBar="TheTopRespawn"};
		}

		CEnemyCastBar_Afflictions["Brittle Bones"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0
		CEnemyCastBar_Afflictions["Flame Wreath"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
		CEnemyCastBar_Afflictions["Overload"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["The Baron's Ultimatum"] = {t=2700, c="cooldown", global="true", m="Baron Run", icontex="Spell_Holy_Resurrection"};
			["Baron Rivendare"] = {t=0, delBar="The Baron's Ultimatum"};
		}

	elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
		
		-- Naxxramas
	
			["Necro Stalker"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
			-- Anub'Rekhan
			["First Locust Swarm"] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
			["Locust Swarm"] = {t=23, i=3, c="gainsfoe", delBar="Locust Swarm CD", aBar="Locust Swarm CD", active="true", icontex="Spell_Nature_InsectSwarm"};
			["Locust Swarm CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
	
			-- Patchwerk
			["Enraged Mode"] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
			-- Razuvious
			["Disrupting Shout"] = {t=25, c="cooldown", active="true", delBar="Disrupting Shout possible", aBar="Disrupting Shout possible", icontex="Ability_Creature_Disease_02"};
			["Disrupting Shout possible"] = {t=25, c="cooldown", aBar="Disrupting Shout possible", icontex="Ability_Creature_Disease_02"};
	
			-- Gluth
			["Terrifying Roar"] = {t=20.0, c="cooldown", m="Gluth", aZone="Naxxramas", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
			["Decimate"] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};
	
			-- Maexxna
			["Web Spray"] = {t=40, c="cooldown", pBar="Mini Spiders", m="Maexxna", aZone="Naxxramas", icontex="Ability_Ensnare"};
			["Mini Spiders"] = {t=30, c="cooldown", pBar="Web Wrap CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
			["Web Wrap CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};
	
			-- Thaddius
			["Polarity Shift"] = {t=30, i=3, c="cooldown", pBar="Becomes enraged!", mcheck="Thaddius", icontex="Spell_Nature_Lightning"};
			["Power Surge"] = {t=10, c="gainsfoe", mcheck="Stalagg", icontex="Spell_Shadow_SpectralSight"};
			["Becomes enraged!"] = {t=290, c="cooldown", global="true", tchange={"Becomes enraged!", 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated
	
			-- Faerlina
			["Enrage"] = {t=60, c="cooldown", mcheck="Grand Widow Faerlina", icontex="Spell_Shadow_UnholyFrenzy"};
			["Widow's Embrace"] = {t=30, c="cooldown", mcheck="Grand Widow Faerlina", icontex="Spell_Arcane_Blink"}; -- Fearlina
	
			-- Loatheb
			["15 sec Doom CD!"] = {t=299, tchange={"Inevitable Doom", 30, 15}, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
			["First Inevitable Doom"] = {t=120, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
			["Inevitable Doom"] = {t=30, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"};
	
			["Summon Spore"] = {t=12.5, icasted="true", c="cooldown", mcheck="Loatheb", icontex="Spell_Nature_AbolishMagic"};
			["Remove Curse on Loatheb"] = {t=0.1, icasted="true", c="cooldown", pBar="Curses Removed", mcheck="Loatheb"};
			["Curses Removed"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"};
	
			-- Gothik
			-- don't translate, ALL used internally!
			["Comes Down"] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
			["del1"] = {t=0.1, pBar="del2", delBar="Trainees INC"};
			["del2"] = {t=0.1, pBar="del3", delBar="Deathknights INC"};
			["del3"] = {t=0.1, delBar="Rider INC"};
			
			["First Trainees"] = {t=27, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
			["First Deathknights"] = {t=77, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
			["First Rider"] = {t=137, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"};
			["Trainees INC"] = {t=20, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
			["Deathknights INC"] = {t=25, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
			["Rider INC"] = {t=30, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"}; 
	
			-- Noth
			["Blink"] = {t=30, c="cooldown", mcheck="Noth the Plaguebringer", aZone="Naxxramas", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
			["First Teleport"] = {t=90, c="cooldown", aBar="On Balcony 1", aZone="Naxxramas", icontex="Spell_Nature_AstralRecalGroup"};
			["On Balcony 1"] = {t=70, c="cooldown", aBar="Second Teleport", icontex="Spell_Nature_AstralRecalGroup"};
			["Second Teleport"] = {t=110, c="cooldown", aBar="On Balcony 2", icontex="Spell_Nature_AstralRecalGroup"};
			["On Balcony 2"] = {t=95, c="cooldown", aBar="Third Teleport", icontex="Spell_Nature_AstralRecalGroup"};
			["Third Teleport"] = {t=180, c="cooldown", aBar="On Balcony 3", icontex="Spell_Nature_AstralRecalGroup"};
			["On Balcony 3"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};
	
			-- Heigan
			["On Platform"] = {t=45, c="cooldown", aBar="Teleport CD", icontex="INV_Enchant_EssenceAstralLarge"};
			["Teleport CD"] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};
	
			-- Sapphiron
			["Life Drain"] = {t=24, c="cooldown", m="Sapphiron", aZone="Naxxramas", icontex="Spell_Shadow_LifeDrain02"};
	
				}
	
	
		-- Naxxramas
		NECB_PvE_Vars["HEIGAN_YELL1"]			= "I see you...";
		NECB_PvE_Vars["HEIGAN_YELL2"]			= "You are mine now.";
		NECB_PvE_Vars["HEIGAN_YELL3"]			= "You... are next.";
		NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]		= "The end is upon you.";
	
		NECB_PvE_Vars["FAER_YELL1"]			= "Kneel before me, worm!";
		NECB_PvE_Vars["FAER_YELL2"]			= "You cannot hide from me!";
		NECB_PvE_Vars["FAER_YELL3"]			= "Run while you still can!";
		NECB_PvE_Vars["FAER_YELL4"]			= "Slay them in the master's name!"; 
	
		NECB_PvE_Vars["PATCHWERK_NAME"]			= "Patchwerk";
	
		NECB_PvE_Vars["GOTHIK_YELL"]			= "Foolishly you have sought your own demise.";
	
		NECB_PvE_Vars["ANUB_YELL1"]			= "Just a little taste...";
		NECB_PvE_Vars["ANUB_YELL2"]			= "Yes, run! It makes the blood pump faster!";
		NECB_PvE_Vars["ANUB_YELL3"]			= "There is no way out.";

		-- Naxxramas
		CEnemyCastBar_Afflictions["Mortal Wound"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
		CEnemyCastBar_Afflictions["Mutating Injection"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
		CEnemyCastBar_Afflictions["Web Wrap"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
		CEnemyCastBar_Afflictions["Necrotic Poison"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; -- Maexxna MT -healing Debuff(poison)
		CEnemyCastBar_Afflictions["Detonate Mana"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	
	elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Ahn'Qiraj
		
			-- 40 Man
				["Obsidian Eradicator"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
				-- Twin Emperors
				["Twin Teleport"] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
				["Explode Bug"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
				["Mutate Bug"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};
	
				-- Ouro
				["Sand Blast"] = {t=2.0, c="hostile", mcheck="Ouro", icontex="Spell_Nature_Cyclone"};
				["Sweep"] = {t=21, i=1.0, c="cooldown", mcheck="Ouro", icontex="Spell_Nature_Thorns"};
	
				["Summon Ouro Mounds"] = {t=0.1, delBar="Possible Ouro Submerge", icasted="true", pBar="Submerged"};
				["Submerged"] = {t=30, c="cooldown", delBar="Ouro Submerges", aBar="Possible Ouro Submerge", icontex="INV_Qiraj_OuroHide"};
				["Possible Ouro Submerge"] = {t=90, c="cooldown", pBar="Ouro Submerges", icontex="Spell_Shadow_DemonBreath"};
				["Ouro Submerges"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"}; 
	
	
				-- C'Thun
				["First Dark Glare"] = {t=48, c="cooldown", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
				["Weakened!"] = {t=45, c="gainsfoe", delBar="Small Eyes P2", aBar="After Weakened Eyes", icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
				["Dark Glare"] = {t=86, i=40, c="cooldown", active="true", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
				["Small Eyes P1"] = {t=45, c="cooldown", aBar="Small Eyes P1", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["First Small Eyes P2"] = {t=42, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["Small Eyes P2"] = {t=30, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["After Weakened Eyes"] = {t=38, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	
				-- Skeram
				["Arcane Explosion"] = {t=1.2, c="hostile", mcheck="The Prophet Skeram", icontex="Spell_Nature_WispSplode"};
	
				-- Sartura (Twin Emps enrage + Hakkar enrage)
				["Whirlwind"] = {t=15.0, c="gainsfoe", mcheck="Battleguard Sartura", icontex="Ability_Whirlwind"};
				["Enraged mode"] = {t=900, r="Battleguard Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
				["Enters Enraged mode"] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
				-- Huhuran
				["Berserk mode"] = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
				["Enters Berserk mode"] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
				["Wyvern Sting"] = {t=25, c="cooldown", m="Huhuran", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};
	
				-- Yauj
				["Fear"] = {t=20, c="cooldown", checkengage="true", m="Yauj", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
				["Great Heal"] = {t=2.0, c="hostile", m="Yauj", mcheck="Princess Yauj", icontex="Spell_Holy_Heal"};
	
	
					}
	
		-- AQ40
		NECB_PvE_Vars["SARTURA_CALL"]			= "You will be judged for defiling";
		NECB_PvE_Vars["SARTURA_CRAZY"]			= "becomes enraged";
	
		NECB_PvE_Vars["HUHURAN_CRAZY"]			= "goes into a berserker rage";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "goes into a frenzy";
	
		NECB_PvE_Vars["CTHUN_NAME1"]	 		= "Eye of C'Thun";
		NECB_PvE_Vars["CTHUN_WEAKENED"]			= "is weakened!";

		-- AQ40
		CEnemyCastBar_Afflictions["True Fulfillment"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
		CEnemyCastBar_Afflictions["Plague"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
		CEnemyCastBar_Afflictions["Entangle"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
	
			-- 20 Man
	
				["Explode"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};
	
				-- Ossirian
				["Arcane Weakness"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_01"};
				["Fire Weakness"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_02"};
				["Nature Weakness"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_03"};
				["Frost Weakness"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_04"};
				["Shadow Weakness"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_05"};
	
				-- Moam
				["Until Stoneform"] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
				["Energize"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
					}
	
		-- Ruins of AQ
		NECB_PvE_Vars["MOAM_STARTING"]			= "senses your fear.";

		-- AQ20
		CEnemyCastBar_Afflictions["Paralyze"] = {t=10, global="true", aZone="Ruins of Ahn'Qiraj", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
		-- Moam removal
		CEnemyCastBar_Afflictions["Energize"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Gurub
	
			-- Hakkar
			["Blood Siphon"] = {t=90.0, c="cooldown", mcheck="Hakkar", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
			["Enraged mode"] = {t=900, r="Battleguard Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
					}
	
		-- Zul'Gurub
		NECB_PvE_Vars["HAKKAR_YELL"]			= "PRIDE HERALDS THE END OF YOUR WORLD";

		-- Zul'Gurub
		CEnemyCastBar_Afflictions["Delusions of Jin'do"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
		CEnemyCastBar_Afflictions["Cause Insanity"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
		CEnemyCastBar_Afflictions["Threatening Gaze"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Molten Core
	
			-- Shazzrah
			["Gate of Shazzrah"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
		
			-- Lucifron
			["Impending Doom"] = {t=20.0, c="cooldown", m="Lucifron", icontex="Spell_Shadow_NightOfTheDead"};
			["Lucifron's Curse"] = {t=20.0, c="cooldown", m="Lucifron", icontex="Spell_Shadow_BlackPlague"};
		
			-- Magmadar
			["Panic"] = {t=30.0, c="cooldown", m="Magmadar", icontex="Spell_Shadow_DeathScream"};
	
			-- Gehennas
			["Gehennas' Curse"] = {t=30.0, c="cooldown", m="Gehennas", icontex="Spell_Shadow_GatherShadows"};
	
			-- Geddon
			["Inferno"] = {t=8.0, c="gainsfoe", mcheck="Baron Geddon", icontex="Spell_Fire_Incinerate"};
	
			-- Majordomo
			["Magic Reflection"] = {t=30.0, i=10.0, c="cooldown", m="Majordomo", aZone="Molten Core", icontex="Spell_Frost_FrostShock"};
			["Damage Shield"] = {t=30.0, i=10.0, c="cooldown", m="Majordomo", icontex="Spell_Nature_LightningShield"};
			
			-- Ragnaros
			["Submerge"] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
			["Knockback"] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
			["Sons of Flame"] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!

					}
	
		-- MC
		NECB_PvE_Vars["RAGNAROS_STARTING"]			= "NOW FOR YOU,";
		NECB_PvE_Vars["RAGNAROS_KICKER"]			= "TASTE THE FLAMES";
		NECB_PvE_Vars["RAGNAROS_SONS"]	 		= "COME FORTH, MY SERVANTS!";

		-- MC
		CEnemyCastBar_Afflictions["Living Bomb"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Onyxia
			["Flame Breath"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
			["Deep Breath"] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"};
			["Wing Buffet"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
			["Bellowing Roar"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
	
	
					}
	
		-- ONY
		NECB_PvE_Vars["ONY_DB"]				= "takes in a deep breath..."; 
	
	elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
				
		-- Blackwing Lair
	
			-- Razorgore
			["Mob Spawn (45sec)"] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
	
			-- Firemaw/Flamegor/Ebonroc
			["Wing Buffet"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
			["First Wingbuffet"] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"}; -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
			["Shadow Flame"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"};
			
			-- Flamegor
			[CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
			
			-- Chromaggus
			["Frost Burn"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
			["Time Lapse"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
			["Ignite Flesh"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
			["Corrosive Acid"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
			["Incinerate"] = {t=60.0, i=2.0, c="cooldown", active="true", mcheck="Chromaggus", icontex="Spell_Fire_FlameShock"};
			["Killing Frenzy"] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
				-- Chromaggus, Flamegor, Magmadar etc.
			["Frenzy"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};
			
			-- Neferian/Onyxia
			["Bellowing Roar"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
			
			-- Nefarian			
			["Nefarian calls"] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
			["Mob Spawn"] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
			["Landing"] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
					}
	
		-- BWL
		NECB_PvE_Vars["RAZORGORE_CALL"]			= "Intruders have breached";
	
		NECB_PvE_Vars["FIREMAW_NAME"]			= "Firemaw";
		NECB_PvE_Vars["EBONROC_NAME"]			= "Ebonroc";
		NECB_PvE_Vars["FLAMEGOR_NAME"]			= "Flamegor";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "goes into a frenzy";
		NECB_PvE_Vars["CHROMAGGUS_FRENZY"]			= "goes into a killing frenzy";
		
		NECB_PvE_Vars["NEFARIAN_STARTING"]			= "Let the games begin!";
		NECB_PvE_Vars["NEFARIAN_LAND"]			= "Well done, my minions";
		NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"]		= "Shamans, show me";
		NECB_PvE_Vars["NEFARIAN_DRUID_CALL"]		= "Druids and your silly";
		NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"]		= "Warlocks, you shouldn't be playing";
		NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"]		= "Priests! If you're going to keep";
		NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"]		= "Hunters and your annoying";
		NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"]		= "Warriors, I know you can hit harder";
		NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"]		= "Rogues";
		NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"]		= "Paladins";
		NECB_PvE_Vars["NEFARIAN_MAGE_CALL"]		= "Mages";

		-- BWL
		CEnemyCastBar_Afflictions["Conflagration"] = {t=10.0, global="true", aZone="Blackwing Lair", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning
		CEnemyCastBar_Afflictions["Burning Adrenaline"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA
		CEnemyCastBar_Afflictions["Shadow of Ebonroc"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff
		-- Non Boss DeBuffs:
		CEnemyCastBar_Afflictions["Greater Polymorph"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	else
		CEnemyCastBar_Raids = { };
		NECB_PvE_Vars = { };

	end
		
			-- Other
	
		for k, v in pairs (CEnemyCastBar_Raids) do
			CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
			break;
		end

		--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

		if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
			CECB_ReloadOptionsUI(); -- update tooltip
		end

  end

end