﻿--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!

if ( GetLocale() == "koKR" ) then

		-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
		-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
		-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
		-- "active" only allows this spell to be an active cast, no afflictions and something else!
		-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
		-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
		-- "icasted" guides this spell through the instant cast protection
		-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
		-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
		-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
		-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
		-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
		-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
		-- tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas = "낙스라마스";
	NECB_AhnQiraj = "안퀴라즈";
	NECB_AhnQirajRuins = "안퀴라즈 폐허";
	NECB_ZulGurub = "줄구룹";
	NECB_MoltenCore = "화산 심장부";
	NECB_OnyxiaLair = "오닉시아의 둥지";
	NECB_BlackwingLair = "검은날개 등지";
	NECB_Stratholme = "스트라솔름";
	--BC
	NECB_ShatteredHalls = "으스러진 손의 전당";
	NECB_Magtheridon = "마그테리돈의 둥지";
	NECB_GruulsLair = "그룰의 둥지";
	NECB_Karazhan = "카라잔";
	NECB_SerpentshrineCavern = "불뱀 제단";
	NECB_Tempest_Keep = "폭풍우 요새";
	NECB_Black_Temple = "검은 사원";
	NECB_ZulAman = "줄아만";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
		NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
		if not forcereg then
			return;
		end
		break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Magtheridon
	
			-- Respawn timer
			["교도관 재생성"] = {t=7200, c="cooldown", global="true", m="마그테리돈", icontex="Spell_Holy_Resurrection"};
				["지옥불 교도관"] = {t=0, pBar="교도관 재생성"};
					["마그테리돈"] = {t=0, delBar="교도관 재생성"};
		}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Amani'shi Tempest"] = {t=0, pBar="Akil'zon Trash"}; -- translate!
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};

		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Black Temple Respawn timer

			["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Aqueous Lord"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["Coilskar General"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["Coilskar Harpooner"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["Leviathan"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				-- + Coilskar Soothsayer, Coilskar Wrangler
					["대장군 나젠투스"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"};

			["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Ashtongue Primalist"] = {t=0, pBar="Akama Trash"}; -- translate!
				["Ashtongue Mystic"] = {t=0, pBar="Akama Trash"}; -- translate!
				["Ashtongue Battlelord"] = {t=0, pBar="Akama Trash"}; -- translate!
					["아카마의 망령"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"}; 

			["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Shadowmoon Champion"] = {t=0, pBar="Gorefiend Trash"}; -- translate!
				["Shadowmoon Reaver"] = {t=0, pBar="Gorefiend Trash"}; -- translate!
					["테론 고어핀드"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"};

			["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Bonechewer Worker"] = {t=0, pBar="Supremus Trash"}; -- translate!
				["Bonechewer Taskmaster"] = {t=0, pBar="Supremus Trash"}; -- translate!
					["Supremus"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"}; -- translate!

			["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Bonechewer Shield Disciple"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
				["Bonechewer Blade Fury"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
				["Mutant War Hound"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
					["Gurtogg Bloodboil"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"}; -- translate!

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Temple Concubine"] = {t=0, pBar="Mother Shahraz Trash"};
				["Charming Courtesan"] = {t=0, pBar="Mother Shahraz Trash"};
				["Spellbound Attendant"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pain"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pleasure"] = {t=0, pBar="Mother Shahraz Trash"};
					["Mother Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Promenade Sentinel"] = {t=0, pBar="Illidari Council Trash"}; -- translate!
					["파괴자 가디오스"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	
		}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Tempest Keep
	
			-- Respawn timer
			["Al'ar Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Star Scryer"] = {t=0, pBar="Al'ar Trash"}; --! translate
				["Astromancer"] = {t=0, pBar="Al'ar Trash"}; --! translate
				["Bloodwarder Vindicator"] = {t=0, pBar="Al'ar Trash"}; --! translate
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Al'ar Trash"}; --! translate
					["알라르"] = {t=0, tchange={"Al'ar Trash", "perm", 0}, delBar="Al'ar Trash"};

			["Void Reaver Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Crystalcore Devastator"] = {t=0, pBar="Void Reaver Trash"}; --! translate
				--["Crystalcore Sentinel"] = {t=0, pBar="Void Reaver Trash"}; --! translate
					["공허의 절단기"] = {t=0, tchange={"Void Reaver Trash", "perm", 0}, delBar="Void Reaver Trash"};

			["Astromancer Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Astromancer Lord"] = {t=0, pBar="Astromancer Trash"}; --! translate
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Astromancer Trash"}; --! translate
				["Novice Astromancer"] = {t=0, pBar="Astromancer Trash"}; --! translate
					["고위 점성술사 솔라리안"] = {t=0, tchange={"Astromancer Trash", "perm", 0}, delBar="Astromancer Trash"};

			["Kael'thas Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Crimson Hand Battle Mage"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
				["Crimson Hand Blood Knight"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
				["Crimson Hand Centurion"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
				["Crimson Hand Inquisitor"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
					["캘타스 선스트라이더"] = {t=0, tchange={"Kael'thas Trash", "perm", 0}, delBar="Kael'thas Trash"};

		}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	    
	        CEnemyCastBar_Raids = {
	        
	        -- Serpentshrine Cavern
	        
		        -- Respawn timer
			["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Coilfang Beast-Tamer"] = {t=0, pBar="HydrossTrash"}; --! translate
				["Coilfang Hate-Screamer"] = {t=0, pBar="HydrossTrash"}; --! translate
				["Serpentshrine Sporebat"] = {t=0, pBar="HydrossTrash"}; --! translate
					["불안정한 히드로스"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

			["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Vashj'ir Honor Guard"] = {t=0, pBar="LurkerTrash"}; --! translate
				["Coilfang Priestess"] = {t=0, pBar="LurkerTrash"}; --! translate
					["심연의 잠복꾼"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

			["PermaTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Greyheart Nether-Mage"] = {t=0, pBar="PermaTrash"}; --! translate
				["Greyheart Tidecaller"] = {t=0, pBar="PermaTrash"}; --! translate
				["Greyheart Skulker"] = {t=0, pBar="PermaTrash"}; --! translate

			["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Tidewalker Shaman"] = {t=0, pBar="MixedTrash"}; --! translate
				["Tidewalker Depth-Seer"] = {t=0, pBar="MixedTrash"}; --! translate
				["Tidewalker Warrior"] = {t=0, pBar="MixedTrash"}; --! translate
					["겅둥파도 모로그림"] = {t=0, tchange={"MixedTrash", "perm", 0}, delBar="MixedTrash"};

			["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Greyheart Shild-Bearer"] = {t=0, pBar="LeotherasTrash"}; --! translate
					["눈먼 레오테라스"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"};

	        }

	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
	
		CEnemyCastBar_Raids = {
	
		-- Gruuls
	
			-- Krosh Firehand
			["마법의 수호물"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"}; 

			-- Respawn timer
			["오우거 재생성"] = {t=3600, c="cooldown", global="true", m="그룰", icontex="Spell_Holy_Resurrection"};
				["그룰의 투사"] = {t=0, pBar="오우거 재생성"};
				["그론 사제"] = {t=0, pBar="오우거 재생성"};
					["왕중왕 마울가르"] = {t=0, delBar="오우거 재생성"};
					["용 학살자 그룰"] = {t=0, delBar="오우거 재생성"};
		}

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["Kargath's Executioner"] = {t=4800, c="cooldown", global="true", m="Heroic Quest", icontex="Spell_Holy_Resurrection"}; --! translate
			["대족장 카르가스 블레이드피스트"] = {t=0, delBar="Kargath's Executioner"};
		}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;

		CEnemyCastBar_Raids = {

			-- Respawn timer
			["StableRespawn"] = {t=1500, c="cooldown", global="true", m="어튜멘", icontex="Spell_Holy_Resurrection"};
				["유령 백마"] = {t=0, pBar="StableRespawn"}; 
				["유령 준마"] = {t=0, pBar="StableRespawn"}; 
					["사냥꾼 어튜멘"] = {t=0, tchange={"StableRespawn", "perm", 0}, delBar="StableRespawn"}; 
 
			["DancerRespawn"] = {t=3600, c="cooldown", global="true", m="모로스", icontex="Spell_Holy_Resurrection"};
				["유령 손님"] = {t=0, pBar="DancerRespawn"}; 
					["모로스"] = {t=0, tchange={"DancerRespawn", "perm", 0}, delBar="DancerRespawn"}; 

			["GuestQuarterRespawn"] = {t=3600, c="cooldown", global="true", m="여신", icontex="Spell_Holy_Resurrection"};
				["유령 경비병"] = {t=0, pBar="GuestQuarterRespawn"}; 
				["유령 보초"] = {t=0, pBar="GuestQuarterRespawn"}; 
					["고결의 여신"] = {t=0, tchange={"GuestQuarterRespawn", "perm", 0}, delBar="GuestQuarterRespawn"}; 

			["TheatreRespawn"] = {t=3600, c="cooldown", global="true", m="오페라", icontex="Spell_Holy_Resurrection"};
				["해골 안내인"] = {t=0, pBar="TheatreRespawn"}; 
					["마녀"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"}; 
					["커다란 나쁜 늑대"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"}; 
					["유령 자선가"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};

			["GalleryRespawn"] = {t=3600, c="cooldown", global="true", m="전시 관리인", icontex="Spell_Holy_Resurrection"};
				["비전 보초"] = {t=0, pBar="GalleryRespawn"};
					["전시 관리인"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, delBar="GalleryRespawn"};

			["LibraryRespawn1"] = {t=7200, c="cooldown", global="true", m="아란", icontex="Spell_Holy_Resurrection"};
				["비전 파수병"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, pBar="LibraryRespawn1", delBar="GalleryRespawn"};
					["아란의 망령"] = {t=0, tchange={"LibraryRespawn1", "perm", 0}, delBar="LibraryRespawn1"};

			["LibraryRespawn2"] = {t=7200, c="cooldown", global="true", m="일후프", icontex="Spell_Holy_Resurrection"};
				["호문쿨루스"] = {t=0, pBar="LibraryRespawn2"};
				["어둠의 약탈자"] = {t=0, pBar="LibraryRespawn2"};
					["테레스티안 일후프"] = {t=0, tchange={"LibraryRespawn2", "perm", 0}, delBar="LibraryRespawn2"};

			["LibraryRespawn3"] = {t=7200, c="cooldown", global="true", m="황천의 원령", icontex="Spell_Holy_Resurrection"};
				["마술의 망령"] = {t=0, pBar="LibraryRespawn3"};
					["황천의 원령"] = {t=0, tchange={"LibraryRespawn3", "perm", 0}, delBar="LibraryRespawn3"};

			["TheTopRespawn"] = {t=7200, c="cooldown", global="true", m="말체자르", icontex="Spell_Holy_Resurrection"};
				["식인괴물"] = {t=0, pBar="TheTopRespawn"};
				["거대한 식인괴물"] = {t=0, pBar="TheTopRespawn"};
					["공작 말체자르"] = {t=0, tchange={"TheTopRespawn", "perm", 0}, delBar="TheTopRespawn"};
		}
	
		CEnemyCastBar_Afflictions["부러진 뼈"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0
		CEnemyCastBar_Afflictions["화염의 고리"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
		CEnemyCastBar_Afflictions["과부하"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["The Baron's Ultimatum"] = {t=2700, c="cooldown", global="true", m="Baron Run", icontex="Spell_Holy_Resurrection"}; --! translate
			["남작 리븐데어"] = {t=0, delBar="The Baron's Ultimatum"};
		}

elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
    		NECB_PvE_Vars["FIRST_LOCUST_SWARM"] = "첫번째 메뚜기 떼";
		NECB_PvE_Vars["ENRAGED_MODE1"] = "격노 모드 ";
		NECB_PvE_Vars["WEB_SPRAY"] = "거미줄 뿌리기";
		NECB_PvE_Vars["DISRUPTING_SHOUT"] = "분열의 외침";
		NECB_PvE_Vars["DECIMATE"] = "척살";
		NECB_PvE_Vars["BECOME_ENRAGED"] = "격노 진입!";
		NECB_PvE_Vars["ENRAGE"] = "격노";
		NECB_PvE_Vars["15SEC_DOOM_CD"] = "15 초 파멸 CD!";
		NECB_PvE_Vars["FIRST_INVITABLE_DOOM"] = "첫번째 피할 수 없는 파멸";
		NECB_PvE_Vars["COMES_DOWN"] = "고딕 등장";
		
		NECB_PvE_Vars["1ST_TRAINEES_INCOME"] = "첫 번째 수습생";
		NECB_PvE_Vars["1ST_DK_INCOME"] = "첫 번째 죽음의 기사";
		NECB_PvE_Vars["1ST_RIDER_INCOME"] = "첫 번째 기병";
		NECB_PvE_Vars["TRAINEES_INCOME"] = "수습생 습격";
		NECB_PvE_Vars["DK_INCOME"] = "죽음의 기사 등장";
		NECB_PvE_Vars["RIDER_INCOME"] = "기병대 등장";
		NECB_PvE_Vars["FIRST_TELEPORT"] = "첫번째 순간이동";
		NECB_PvE_Vars["ON_PLATFORM"] = "단상으로 이동!";
		NECB_PvE_Vars["TELEPORT_CD"] = "순간이동 CD";

		CEnemyCastBar_Raids = {
		
        -- Naxxramas

		["죽음의 동굴거미"] = {t=1800.0, c="cooldown", global="true", m="재생성", icontex="Spell_Holy_Resurrection"};

            -- Anub'Rekhan
            [NECB_PvE_Vars["FIRST_LOCUST_SWARM"]] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
            ["메뚜기 떼"] = {t=23, i=3, c="gainsfoe", delBar="메뚜기 떼 CD", aBar="메뚜기 떼 CD", active="true", icontex="Spell_Nature_InsectSwarm"};
            ["메뚜기 떼 CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};

            -- Patchwerk
            [NECB_PvE_Vars["ENRAGED_MODE1"]] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!

            -- Razuvious
            [NECB_PvE_Vars["DISRUPTING_SHOUT"]] = {t=25, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};

		[NECB_PvE_Vars["DISRUPTING_SHOUT"]] = {t=25, c="cooldown", active="true", delBar=NECB_PvE_Vars["DISRUPTING_SHOUT"].." possible", aBar=CECB_SPRLL_DISRUPTING_SHOUT.." possible", icontex="Ability_Creature_Disease_02"};
		[NECB_PvE_Vars["DISRUPTING_SHOUT"].." possible"] = {t=25, c="cooldown", aBar=NECB_PvE_Vars["DISRUPTING_SHOUT"].." possible", icontex="Ability_Creature_Disease_02"};

            -- Gluth
            ["공포의 포효"] = {t=20.0, c="cooldown", m="글루스", aZone="낙스라마스", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
            [NECB_PvE_Vars["DECIMATE"]] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};

            -- Maexxna
            [NECB_PvE_Vars["WEB_SPRAY"]] = {t=40, c="cooldown", pBar="새끼 거미", m="맥스나", aZone="낙스라마스", icontex="Ability_Ensnare"};
            ["새끼 거미"] = {t=30, c="cooldown", pBar="거미줄 감싸기 CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
            ["거미줄 감싸기 CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};

            -- Thaddius
            ["단계 변경"] = {t=30, i=3, c="cooldown", pBar=NECB_PvE_Vars["BECOME_ENRAGED"], mcheck="타티우스", icontex="Spell_Nature_Lightning"};
            ["마력의 쇄도"] = {t=10, c="gainsfoe", mcheck="스칼라그", icontex="Spell_Shadow_SpectralSight"};
            [NECB_PvE_Vars["BECOME_ENRAGED"]] = {t=290, c="cooldown", global="true", tchange={NECB_PvE_Vars["BECOME_ENRAGED"], 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated

            -- Faerlina
            [NECB_PvE_Vars["ENRAGE"]] = {t=60, c="cooldown", mcheck="귀부인 팰리나", icontex="Spell_Shadow_UnholyFrenzy"};
            ["귀부인의 은총"] = {t=30, c="cooldown", mcheck="귀부인 팰리나", icontex="Spell_Arcane_Blink"}; -- Fearlina

            -- Loatheb
            [NECB_PvE_Vars["15SEC_DOOM_CD"]] = {t=299, tchange={"피할 수 없는 파멸", 30, 15}, c="cooldown", m="로데브", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
            [NECB_PvE_Vars["FIRST_INVITABLE_DOOM"]] = {t=120, c="cooldown", m="로데브", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
            ["피할 수 없는 파멸"] = {t=30, c="cooldown", m="로데브", icontex="Spell_Shadow_NightOfTheDead"};

            ["포자 소환"] = {t=12.5, icasted="true", c="cooldown", mcheck="로데브", icontex="Spell_Nature_AbolishMagic"};
            ["로데브 저주 해제"] = {t=0.1, icasted="true", c="cooldown", pBar="저주 해제", mcheck="로데브"};
            ["저주 사라짐"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"};

		-- Gothik
		-- don't translate, ALL used internally!
		[NECB_PvE_Vars["COMES_DOWN"]] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
		["del1"] = {t=0.1, pBar="del2", delBar=NECB_PvE_Vars["TRAINEES_INCOME"]};
		["del2"] = {t=0.1, pBar="del3", delBar=NECB_PvE_Vars["DK_INCOME"]};
		["del3"] = {t=0.1, delBar=NECB_PvE_Vars["RIDER_INCOME"]};

		[NECB_PvE_Vars["1ST_TRAINEES_INCOME"]] = {t=27, c="cooldown", aBar=NECB_PvE_Vars["TRAINEES_INCOME"], icontex="INV_Misc_Head_Undead_01"};
		[NECB_PvE_Vars["1ST_DK_INCOME"]] = {t=77, c="cooldown", aBar=NECB_PvE_Vars["DK_INCOME"], icontex="Spell_Shadow_ShadowWard"};
		[NECB_PvE_Vars["1ST_RIDER_INCOME"]] = {t=137, c="cooldown", aBar=NECB_PvE_Vars["RIDER_INCOME"], icontex="Ability_Mount_Undeadhorse"};
		[NECB_PvE_Vars["TRAINEES_INCOME"]] = {t=20, c="cooldown", aBar=NECB_PvE_Vars["TRAINEES_INCOME"], icontex="INV_Misc_Head_Undead_01"};
		[NECB_PvE_Vars["DK_INCOME"]] = {t=25, c="cooldown", aBar=NECB_PvE_Vars["DK_INCOME"], icontex="Spell_Shadow_ShadowWard"};
		[NECB_PvE_Vars["RIDER_INCOME"]] = {t=30, c="cooldown", aBar=NECB_PvE_Vars["RIDER_INCOME"], icontex="Ability_Mount_Undeadhorse"};


            -- Noth

            ["점멸"] = {t=30, c="cooldown", mcheck="역병술사 노스", aZone="낙스라마스", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
            [NECB_PvE_Vars["FIRST_TELEPORT"]] = {t=90, c="cooldown", aBar="첫번째 발코니", aZone="낙스라마스", icontex="Spell_Nature_AstralRecalGroup"};
            ["첫번째 발코니"] = {t=70, c="cooldown", aBar="두번째 순간이동", icontex="Spell_Nature_AstralRecalGroup"};
            ["두번째 순간이동"] = {t=110, c="cooldown", aBar="두번째 발코니", icontex="Spell_Nature_AstralRecalGroup"};
            ["두번째 발코니"] = {t=95, c="cooldown", aBar="세번째 순간이동", icontex="Spell_Nature_AstralRecalGroup"};
            ["세번째 순간이동"] = {t=180, c="cooldown", aBar="3번째 발코니", icontex="Spell_Nature_AstralRecalGroup"};
            ["3번째 발코니"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};

            -- Heigan

            [NECB_PvE_Vars["ON_PLATFORM"]] = {t=45, c="cooldown", aBar=NECB_PvE_Vars["TELEPORT_CD"], icontex="INV_Enchant_EssenceAstralLarge"};
            [NECB_PvE_Vars["TELEPORT_CD"]] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};

		-- Sapphiron
		["생명력 흡수"] = {t=24, c="cooldown", m="샤피론", aZone="낙스라마스", icontex="Spell_Shadow_LifeDrain02"};
	
				}
	
	
	    -- Naxxramas
	    NECB_PvE_Vars["HEIGAN_YELL1"]          = "네가 보인다...";
	    NECB_PvE_Vars["HEIGAN_YELL2"]          = "이제 넌 내 것이다.";
	    NECB_PvE_Vars["HEIGAN_YELL3"]          = "다음은... 너다.";
	    NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]  = "여기가 너희 무덤이 되리라.";
	
	    NECB_PvE_Vars["FAER_YELL1"]            = "내 앞에 무릎을 꿇어라, 벌레들아!";
	    NECB_PvE_Vars["FAER_YELL2"]            = "나에게서 도망칠 수는 없다!";
	    NECB_PvE_Vars["FAER_YELL3"]            = "두 발이 성할 때 도망쳐라!";
	    NECB_PvE_Vars["FAER_YELL4"]            = "주인님의 이름으로 처단하라!"; 
	
	    NECB_PvE_Vars["PATCHWERK_NAME"]        = "패치워크";
	
	    NECB_PvE_Vars["GOTHIK_YELL"]           = "어리석은 것들, 스스로 죽음을 자초하다니!";
	
	    NECB_PvE_Vars["ANUB_NAME"]             = "阿努比瑞克漢";
	
	    NECB_PvE_Vars["ANUB_YELL1"]= "어디 맛 좀 볼까...";
	    NECB_PvE_Vars["ANUB_YELL2"]            = "그래, 도망쳐! 더 신선한 피가 솟구칠 테니!";
	    NECB_PvE_Vars["ANUB_YELL3"]            = "나가는 길은 없다.";
	
	NECB_PvE_Vars["RAZUVIOUS_NAME"]        = "라주비어스";
	NECB_PvE_Vars["RAZUVIOUS_NAME_PAT"]    = "라주비어스";
	NECB_PvE_Vars["FAERLINA_NAME"]         = "팰리나";
	NECB_PvE_Vars["FAERLINA_NAME_PAT"]     = "팰리나";
	NECB_PvE_Vars["GOTHIK_NAME"]           = "고딕";
	NECB_PvE_Vars["GOTHIK_NAME_PAT"]       = "고딕";
	NECB_PvE_Vars["NOTH_NAME"]             = "노스";
	NECB_PvE_Vars["NOTH_NAME_PAT"]         = "노스";
	NECB_PvE_Vars["HEIGAN_NAME"]           = "헤이건";
	NECB_PvE_Vars["HEIGAN_NAME_PAT"]      = "헤이건";
	
	NECB_PvE_Vars["SAPPHIRON_NAME"]	= "샤피론";

        -- Naxxramas
        CEnemyCastBar_Afflictions["죽음의 상처"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
        CEnemyCastBar_Afflictions["돌연변이 유발"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
        CEnemyCastBar_Afflictions["거미줄 감싸기"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
        CEnemyCastBar_Afflictions["맹독 충격"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; -- Maexxna MT -healing Debuff(poison)
	CEnemyCastBar_Afflictions["마나 폭발"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb

		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	
elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		    NECB_PvE_Vars["TWIN_TELEPORT"] = "쌍둥이 순간이동";
		    NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"] = "아우로 잠수 가능";
		    NECB_PvE_Vars["SMALL_EYE_P1"] = "작은 눈 P1";
		    NECB_PvE_Vars["SMALL_EYE_P2"] = "작은 눈 P2";
		    NECB_PvE_Vars["FIRST_SMALL_EYE_P2"] = "첫번째 작은 눈 P2";
		    NECB_PvE_Vars["AFTER_WEAKENED_EYES"] = "After Weakened Eyes";
		    NECB_PvE_Vars["WEAKENED"] = "약화!";
		    NECB_PvE_Vars["FIRST_DARK_GLARE"] = "첫번째 암흑의 주시";
		    NECB_PvE_Vars["DARK_GLARE"] = "암흑의 주시";
		    NECB_PvE_Vars["ENRAGED_MODE2"] = "격노 모드";
		    NECB_PvE_Vars["ENTER_ENRAGED_MODE"] = "격노 돌입";
		    NECB_PvE_Vars["BERSERK_MODE"] = "광기";
		    NECB_PvE_Vars["ENTER_BERSERK_MODE"] = "광기 진입";

		CEnemyCastBar_Raids = {
	
        -- Ahn'Qiraj

            -- 40 Man
                ["흑요석 파멸자"] = {t=1800.0, c="cooldown", global="true", m="재생성", icontex="Spell_Holy_Resurrection"};

                -- Twin Emperors
                [NECB_PvE_Vars["TWIN_TELEPORT"]] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
                ["벌레 폭발"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
                ["벌레 돌연변이"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};

                -- Ouro
                ["모래 돌풍"] = {t=2.0, c="hostile", mcheck="아우로", icontex="Spell_Nature_Cyclone"};
                ["휩쓸기"] = {t=21, i=1.0, c="cooldown", mcheck="아우로", icontex="Spell_Nature_Thorns"};


                ["아우로 흙더미 소환"] = {t=0.1, delBar=NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"], icasted="true", pBar="잠수"};
                ["잠수"] = {t=30, c="cooldown", delBar="아우로 잠수", aBar=NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"], icontex="INV_Qiraj_OuroHide"};
                [NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"]] = {t=90, c="cooldown", pBar="아우로 잠수", icontex="Spell_Shadow_DemonBreath"};
                ["아우로 잠수"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"}; 


                -- C'Thun
		        [NECB_PvE_Vars["FIRST_DARK_GLARE"]] = {t=48, c="cooldown", aBar=NECB_PvE_Vars["DARK_GLARE"], icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
		        [NECB_PvE_Vars["WEAKENED"]] = {t=45, c="gainsfoe", delBar=NECB_PvE_Vars["SMALL_EYE_P2"], aBar=NECB_PvE_Vars["AFTER_WEAKENED_EYES"], icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
		        [NECB_PvE_Vars["DARK_GLARE"]] = {t=86, i=40, c="cooldown", active="true", aBar=NECB_PvE_Vars["DARK_GLARE"], icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
		        [NECB_PvE_Vars["SMALL_EYE_P1"]] = {t=45, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P1"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
		        [NECB_PvE_Vars["FIRST_SMALL_EYE_P2"]] = {t=42, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
		        [NECB_PvE_Vars["SMALL_EYE_P2"]] = {t=30, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
		        [NECB_PvE_Vars["AFTER_WEAKENED_EYES"]] = {t=38, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!

                -- Skeram
                ["신비한 폭발"] = {t=1.2, c="hostile", mcheck="예언자 스케람", icontex="Spell_Nature_WispSplode"};

                -- Sartura (Twin Emps enrage + Hakkar enrage)
                ["소용돌이"] = {t=15.0, c="gainsfoe", mcheck="전투감시병 살투라", icontex="Ability_Whirlwind"};
                [NECB_PvE_Vars["ENRAGED_MODE2"]] = {t=900, r="살투라 학카르", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
                [NECB_PvE_Vars["ENTER_ENRAGED_MODE"]] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!

                -- Huhuran
                [NECB_PvE_Vars["BERSERK_MODE"]] = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
                [NECB_PvE_Vars["ENTER_BERSERK_MODE"]] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
                ["비룡 쐐기"] = {t=25, c="cooldown", m="후후란", aZone="안퀴라즈", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};

                -- Yauj
                ["공포"] = {t=20, c="cooldown", checkengage="true", m="야우즈", aZone="안퀴라즈", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
                ["상급 치유"] = {t=2.0, c="hostile", m="야우즈", mcheck="공주 야우즈", icontex="Spell_Holy_Heal"};
	
	
					}
	
	    -- AQ40
	    NECB_PvE_Vars["SARTURA_NAME"]= "살투라";
	    NECB_PvE_Vars["SARTURA_NAME_PAT"]= "살투라";
	    NECB_PvE_Vars["HUHURAN_NAME"]= "후후란";
	    NECB_PvE_Vars["HUHURAN_NAME_PAT"]= "후후란";
	    NECB_PvE_Vars["VEKLOR_NAME"]= "베클로어";
	    NECB_PvE_Vars["VEKNILASH_NAME"]= "베클닐라쉬";
	    NECB_PvE_Vars["YAUJ_NAME"]= "야우즈";
	    NECB_PvE_Vars["YAUJ_NAME_PAT"]= "야우즈";
	    NECB_PvE_Vars["DETECTED_NAME"]= "벌레 무리";
	    NECB_PvE_Vars["KRI_NAME"]= "크리";
	    NECB_PvE_Vars["KRI_NAME_PAT"]= "크리";
	    NECB_PvE_Vars["VEM_NAME"]= "벰";
	    NECB_PvE_Vars["GLUTH_NAME"]= "글루스";
	    NECB_PvE_Vars["MAEXXAN_NAME"]= "맥스나";
	    NECB_PvE_Vars["LOATHEB_NAME"]= "로데브";
	    NECB_PvE_Vars["OURO_NAME"]= "아우로";
	    NECB_PvE_Vars["TWINS_NAME"]= "쌍둥이";
	
	
	    NECB_PvE_Vars["SARTURA_CALL"]= "성스러운 땅을 더럽힌 죗값을 받게 되리라";
	    NECB_PvE_Vars["SARTURA_CRAZY"]= "격노 효과를 얻었습니다.";
	
	    NECB_PvE_Vars["HUHURAN_CRAZY"]= "광폭해집니다!";
	
	    NECB_PvE_Vars["CTHUN_NAME1"]= "쑨의 눈";
	    NECB_PvE_Vars["CTHUN_NAME2"]= "쑨";
	    NECB_PvE_Vars["CTHUN_WEAKENED"]= "약해집니다!";

        -- AQ40
        CEnemyCastBar_Afflictions["예언 실현"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
        CEnemyCastBar_Afflictions["역병"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
        CEnemyCastBar_Afflictions["휘감기"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	
elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		    NECB_PvE_Vars["UNTIL_STONEFORM"]= "모암 마비";

		CEnemyCastBar_Raids = {
	
	
            -- 20 Man

                ["폭파"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};

                -- Ossirian
                ["비전 약점"] = {t=45, c="gainsfoe", mcheck="무적의 오시리안", icontex="INV_Misc_QirajiCrystal_01"};
                ["화염 약점"] = {t=45, c="gainsfoe", mcheck="무적의 오시리안", icontex="INV_Misc_QirajiCrystal_02"};
                ["자연 약점"] = {t=45, c="gainsfoe", mcheck="무적의 오시리안", icontex="INV_Misc_QirajiCrystal_03"};
                ["냉기 약점"] = {t=45, c="gainsfoe", mcheck="무적의 오시리안", icontex="INV_Misc_QirajiCrystal_04"};
                ["암흑 약점"] = {t=45, c="gainsfoe", mcheck="무적의 오시리안", icontex="INV_Misc_QirajiCrystal_05"};

                -- Moam
                [NECB_PvE_Vars["UNTIL_STONEFORM"]] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
                ["마력 충전"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
					}
	
	    -- Ruins of AQ
	    NECB_PvE_Vars["MOAM_NAME"]= "모암";
	    NECB_PvE_Vars["MOAM_STARTING"]= "당신의 공포를 알아챕니다.";

        -- AQ20
        CEnemyCastBar_Afflictions["마비"] = {t=10, global="true", aZone="안퀴라즈 폐허", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
        -- Moam removal
        CEnemyCastBar_Afflictions["마력 충전"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	

    		NECB_PvE_Vars["BLOOD_SIPHON"]= "피의 착취";
		NECB_PvE_Vars["ENRAGED_MODE2"]= "격노 모드";

		CEnemyCastBar_Raids = {
	
        -- Zul'Gurub

            -- Hakkar
            [NECB_PvE_Vars["BLOOD_SIPHON"]] = {t=90.0, c="cooldown", mcheck="학카르", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
            [NECB_PvE_Vars["ENRAGED_MODE2"]] = {t=900, r="살투라 학카르", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
					}
	
	    -- Zul'Gurub
	    NECB_PvE_Vars["HAKKAR_NAME"]= "학카르";
	    NECB_PvE_Vars["HAKKAR_YELL"]= "자만심은 세상의 종말을 불러올 뿐이다. 오너라! 건방진 피조물들이여! 와서 신의 진노에 맞서 보아라!";

        -- Zul'Gurub
        CEnemyCastBar_Afflictions["진도의 망상"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
        CEnemyCastBar_Afflictions["정신 이상 유발"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
        CEnemyCastBar_Afflictions["위협의 눈"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		    NECB_PvE_Vars["SUBMERGE"]   = "재등장";
		    NECB_PvE_Vars["KNOCKBACK"]  = "광역 튕겨냄";
		    NECB_PvE_Vars["SONS_OF_FLAME"] = "피조물 등장";

		CEnemyCastBar_Raids = {
	
        -- Molten Core

		-- Shazzrah
		["샤즈라의 문"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};

            -- Lucifron
            ["파멸의 예언"] = {t=20.0, c="cooldown", m="루시프론", icontex="Spell_Shadow_NightOfTheDead"};
            ["루시프론의 저주?"] = {t=20.0, c="cooldown", m="루시프론", icontex="Spell_Shadow_BlackPlague"};

            -- Magmadar
            ["공황"] = {t=30.0, c="cooldown", m="마그마다르", icontex="Spell_Shadow_DeathScream"};

            -- Gehennas
            ["게헨나스의 저주?"] = {t=30.0, c="cooldown", m="게헨나스", icontex="Spell_Shadow_GatherShadows"};

            -- Geddon
            ["불지옥"] = {t=8.0, c="gainsfoe", mcheck="남작 게돈", icontex="Spell_Fire_Incinerate"};

            -- Majordomo
            ["마법 반사"] = {t=30.0, i=10.0, c="cooldown", m="청지기", aZone="화산 심장부", icontex="Spell_Frost_FrostShock"};
            ["피해 보호막"] = {t=30.0, i=10.0, c="cooldown", m="청지기", icontex="Spell_Nature_LightningShield"};

            -- Ragnaros
            [NECB_PvE_Vars["SUBMERGE"]] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
            [NECB_PvE_Vars["KNOCKBACK"]] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
            [NECB_PvE_Vars["SONS_OF_FLAME"]] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!
	
					}
	
	    -- MC
	    NECB_PvE_Vars["RAGNAROS_NAME"]         = "라그나로스";
	
	    NECB_PvE_Vars["RAGNAROS_STARTING"]     = "이제 너희 놈들 차례다!";
	    NECB_PvE_Vars["RAGNAROS_KICKER"]       = "설퍼론의 유황";
	    NECB_PvE_Vars["RAGNAROS_SONS"]         = "나의 종들아!";

        -- MC
        CEnemyCastBar_Afflictions["살아있는 폭탄"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		    NECB_PvE_Vars["DEEP_BREATH"] = "깊은 숨결";

		CEnemyCastBar_Raids = {
	
        -- Onyxia
            ["화염구"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
            [NECB_PvE_Vars["DEEP_BREATH"]] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"};
            ["폭풍 날개"] = {t=31.5, i=0, c="cooldown", icontex="INV_Misc_MonsterScales_14"};
            ["우레와같은 울부짖음"] = {t=1.5, c="hostile", active="true", icontex="Spell_Shadow_Charm"};
	
	
					}
	
	    -- ONY
	    NECB_PvE_Vars["ONY_DB"]                = "숨을 깊게 들이쉽니다."; 
	    NECB_PvE_Vars["ONYXIA_NAME"]           = "오닉시아"; 
	
elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		    NECB_PvE_Vars["MOB_SPAWN_45SEC"] = "몹 생성 (45초)";
		    NECB_PvE_Vars["FIRST_WINGBUFFET"] = "첫번째 폭풍 날개";
		    NECB_PvE_Vars["KILLING_FRENZY"] = "살기를 띤 듯한 광란";
		    NECB_PvE_Vars["NEF_CALLS"]  = "직업 지목";
		    NECB_PvE_Vars["MOB_SPAWN"]  = "용기병 출현";
		    NECB_PvE_Vars["LANDING"]    = "착지" ;

		CEnemyCastBar_Raids = {
	
        -- Blackwing Lair

            -- Razorgore
            [NECB_PvE_Vars["MOB_SPAWN_45SEC"]] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!

            -- Firemaw/Flamegor/Ebonroc
            ["폭풍 날개"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};

            [NECB_PvE_Vars["FIRST_WINGBUFFET"]] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"}; -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
            ["암흑의 불길"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"};

            -- Flamegor
            [CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!

            -- Chromaggus
            ["동결"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
            ["시간의 쇠퇴"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
            ["살점 태우기"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
            ["부식성 산"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
            ["소각"] = {t=60.0, i=2.0, c="cooldown", active="true", mcheck="크로마구스", icontex="Spell_Fire_FlameShock"};

            [NECB_PvE_Vars["KILLING_FRENZY"]] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
                -- Chromaggus, Flamegor, Magmadar etc.
            ["광기"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};

            -- Neferian/Onyxia
            ["우레와같은 울부짖음"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};

            -- Nefarian
            [NECB_PvE_Vars["NEF_CALLS"]] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
            [NECB_PvE_Vars["MOB_SPAWN"]] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
            [NECB_PvE_Vars["LANDING"]] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
					}
	
	    -- BWL
	    NECB_PvE_Vars["CHROMAGGUS"]            = "크로마구스";
	
	    NECB_PvE_Vars["NEFARIUS_NAME"]         = "군주 빅터 네파리우스";
	    NECB_PvE_Vars["NEFARIAN_NAME"]         = "네파리안";
	
	    NECB_PvE_Vars["GRETHOK_NAME"]          = "그레토크";
	    NECB_PvE_Vars["GRETHOK_NAME_PAT"]      = "그레토크";
	
	    NECB_PvE_Vars["RAZORGORE_NAME"]        = "서슬송곳니";
	
	    NECB_PvE_Vars["RAZORGORE_CALL"]        = "침입자들이 들어왔다! 어떤 희생이 있더라도 알을 반드시 수호하라!";
	
	    NECB_PvE_Vars["FIREMAW_NAME"]          = "화염아귀";
	    NECB_PvE_Vars["EBONROC_NAME"]          = "에본로크";
	    NECB_PvE_Vars["FLAMEGOR_NAME"]         = "플레임고르";
	    NECB_PvE_Vars["FLAMEGOR_FRENZY"]       = "광란의 상태에 빠집니다";
	    NECB_PvE_Vars["CHROMAGGUS_FRENZY"]     = "살기를 띤 듯한 광란의 상태에 빠집니다";
	
	    NECB_PvE_Vars["NEFARIAN_STARTING"]     = "흐흐흐흐... 게임을 시작하자!";
	    NECB_PvE_Vars["NEFARIAN_LAND"]         = "잘했다! 적들의 사기가 떨어지고 있다!";
	    NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"]  = "주술사";
	    NECB_PvE_Vars["NEFARIAN_DRUID_CALL"]   = "드루이드 녀석, 그 바보";
	    NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"] = "흑마법사여, 네가 이해하지도 못하는";
	    NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"]  = "사제야, 그렇게 치유를";
	    NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"]  = "그 장난감";
	    NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"] = "전사들이로군, 네가 그보다 더 강하게 내려 칠 수";
	    NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"]   = "도적들인가?";
	    NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"] = "성기사여";
	    NECB_PvE_Vars["NEFARIAN_MAGE_CALL"]    = "네가 마법사냐?";

		    -- Class Call Name
		    NECB_PvE_Vars["CLASS_DRUIDS"]   = "드루이드";
		    NECB_PvE_Vars["CLASS_HUNTERS"]  = "사냥꾼";
		    NECB_PvE_Vars["CLASS_MAGES"]    = "마법사";
		    NECB_PvE_Vars["CLASS_PALADINS"] = "성기사";
		    NECB_PvE_Vars["CLASS_PRIESTS"]  = "사제";
		    NECB_PvE_Vars["CLASS_ROGUES"]   = "도적";
		    NECB_PvE_Vars["CLASS_SHAMANS"]  = "주술사";
		    NECB_PvE_Vars["CLASS_WARLOCKS"] = "흑마법사";
		    NECB_PvE_Vars["CLASS_WARRIORS"] = "전사";

        -- BWL
        CEnemyCastBar_Afflictions["거대한 불길"] = {t=10.0, global="true", aZone="검은날개 둥지", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning
        CEnemyCastBar_Afflictions["불타는 아드레날린"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA
        CEnemyCastBar_Afflictions["에본로크의 그림자"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff
        -- Non Boss DeBuffs:
        CEnemyCastBar_Afflictions["상급 변이"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	else
		CEnemyCastBar_Raids = { };
		NECB_PvE_Vars = { };
	
	end
		
			-- Other
	
		for k, v in pairs (CEnemyCastBar_Raids) do
			CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
			break;
		end

		--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

		if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
			CECB_ReloadOptionsUI(); -- update tooltip
		end

  end

end
