--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!

if ( GetLocale() == "frFR" ) then

		-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
		-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
		-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
		-- "active" only allows this spell to be an active cast, no afflictions and something else!
		-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
		-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
		-- "icasted" guides this spell through the instant cast protection
		-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
		-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
		-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
		-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
		-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
		-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
		--  tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas = "Naxxramas";
	NECB_AhnQiraj = "Ahn'Qiraj";
	NECB_AhnQirajRuins = "Ruines d'Ahn'Qiraj";
	NECB_ZulGurub = "Zul'Gurub";
	NECB_MoltenCore = "C\197\147ur du Magma";
	NECB_OnyxiaLair = "Repaire d'Onyxia";
	NECB_BlackwingLair = "Repaire de l'Aile noire";
	NECB_Stratholme = "Stratholme";
	--BC
	NECB_ShatteredHalls = "Les Salles bris\195\169es";
	NECB_Magtheridon = "Le repaire de Magtheridon";
	NECB_GruulsLair = "Repaire de Gruul";
	NECB_Karazhan = "Karazhan";
	NECB_SerpentshrineCavern = "Caverne du sanctuaire du Serpent";
	NECB_Tempest_Keep = "Donjon de la Tempête";
	NECB_Black_Temple = "Temple noir";
	NECB_ZulAman = "Zul'Aman";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
		NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
		if not forcereg then
			return;
		end
		break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Magtheridon
	
			-- Respawn timer
			["TrashRespawn"] = {t=7200, c="cooldown", global="true", m="Magtheridon", icontex="Spell_Holy_Resurrection"};
				["Gardien des flammes infernales"] = {t=0, pBar="TrashRespawn"};
					["Magtheridon"] = {t=0, delBar="TrashRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Temp\195\170te amani'shi"] = {t=0, pBar="Akil'zon Trash"};
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};

		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Black Temple Respawn timer

			["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Seigneur aqueux"] = {t=0, pBar="Naj'entus Trash"};
				["G\195\169n\195\169ral glissentaille"] = {t=0, pBar="Naj'entus Trash"};
				["Coilskar Harpooner"] = {t=0, pBar="Naj'entus Trash"};
				["L\195\169viathan"] = {t=0, pBar="Naj'entus Trash"};
				-- + Coilskar Soothsayer, Coilskar Wrangler
					["Grand seigneur de guerre Naj'entus"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"};

			["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Primaliste cendrelangue"] = {t=0, pBar="Akama Trash"};
				["Mystique cendrelangue"] = {t=0, pBar="Akama Trash"};
				["Seigneur de bataille cendrelangue"] = {t=0, pBar="Akama Trash"};
					["Ombre d'Akama"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"};

			["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Champion ombrelune"] = {t=0, pBar="Gorefiend Trash"};
				["Saccageur ombrelune"] = {t=0, pBar="Gorefiend Trash"};
					["Teron Fielsang"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"};

			["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Ouvrier M\195\162che-les-os"] = {t=0, pBar="Supremus Trash"};
				["Sous-chef M\195\162che-les-os"] = {t=0, pBar="Supremus Trash"};
					["Supremus"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"};

			["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Disciple du bouclier M\195\162che-les-os"] = {t=0, pBar="Gurtogg Trash"};
				["Lames-furieuses M\195\162che-les-os"] = {t=0, pBar="Gurtogg Trash"};
				["Chien de guerre mutant"] = {t=0, pBar="Gurtogg Trash"};
					["Gurtogg Fi\195\168vresang"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"};

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Concubine du temple"] = {t=0, pBar="Mother Shahraz Trash"};
				["Charmante courtisane"] = {t=0, pBar="Mother Shahraz Trash"};
				["Domestique envo\195\187t\195\169"] = {t=0, pBar="Mother Shahraz Trash"};
				["Soeur de la douleur"] = {t=0, pBar="Mother Shahraz Trash"};
				["Soeur du plaisir"] = {t=0, pBar="Mother Shahraz Trash"};
					["M\195\168re Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Sentinelle de la Promenade"] = {t=0, pBar="Illidari Council Trash"};
					["Gathios le Briseur"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	
		}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Tempest Keep
	
			-- Respawn timer
			["Al'ar Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Scruteur des \195\169toiles"] = {t=0, pBar="Al'ar Trash"};
				["Astromancien"] = {t=0, pBar="Al'ar Trash"};
				["Redresseur de torts garde-sang"] = {t=0, pBar="Al'ar Trash"};
			-- conflict ["L\195\169gionnaire Garde-sang"] = {t=0, pBar="Al'ar Trash"};
					["Al'ar"] = {t=0, tchange={"Al'ar Trash", "perm", 0}, delBar="Al'ar Trash"};

			["Void Reaver Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["D\195\169vastateur Coeur-de-cristal"] = {t=0, pBar="Void Reaver Trash"};
				--["Sentinelle Coeur-de-cristal"] = {t=0, pBar="Void Reaver Trash"};
					["Saccageur du vide"] = {t=0, tchange={"Void Reaver Trash", "perm", 0}, delBar="Void Reaver Trash"};

			["Astromancer Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Seigneur astromancien"] = {t=0, pBar="Astromancer Trash"};
			-- conflict ["L\195\169gionnaire Garde-sang"] = {t=0, pBar="Astromancer Trash"};
				["Astromancien novice"] = {t=0, pBar="Astromancer Trash"};
					["Grande astromancienne Solarian"] = {t=0, tchange={"Astromancer Trash", "perm", 0}, delBar="Astromancer Trash"};

			["Kael'thas Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Mage de bataille de la Main cramoisie"] = {t=0, pBar="Kael'thas Trash"};
				["Chevalier de sang de la Main cramoisie"] = {t=0, pBar="Kael'thas Trash"};
				["Centurion de la Main cramoisie"] = {t=0, pBar="Kael'thas Trash"};
				["Inquisiteur de la Main cramoisie"] = {t=0, pBar="Kael'thas Trash"};
					["Kael'thas Haut-soleil"] = {t=0, tchange={"Kael'thas Trash", "perm", 0}, delBar="Kael'thas Trash"};

		}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	    
	        CEnemyCastBar_Raids = {
	        
	        -- Serpentshrine Cavern
	        
		        -- Respawn timer
			["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Dompteur de b\195\170tes de Glissecroc"] = {t=0, pBar="HydrossTrash"};
				["Hurle-haine de Glissecroc"] = {t=0, pBar="HydrossTrash"};
				["Sporopt\195\168re du sanctuaire du Serpent"] = {t=0, pBar="HydrossTrash"};
					["Hydross l'Instable"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

			["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Garde d'honneur Vashj'ir"] = {t=0, pBar="LurkerTrash"};
				["Pr\195\170tresse de Glissecroc"] = {t=0, pBar="LurkerTrash"};
					["Le Rôdeur d'En-bas"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

			["PermaTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Mage-du-N\195\169ant griscoeur"] = {t=0, pBar="PermaTrash"};
				["Ma\195\174tre des flots griscoeur"] = {t=0, pBar="PermaTrash"};
				["Furtif griscoeur"] = {t=0, pBar="PermaTrash"};

			["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Chaman marcheur-des-flots"] = {t=0, pBar="MixedTrash"};
				["Voyant des profondeurs marcheur-des-flots"] = {t=0, pBar="MixedTrash"};
				["Guerrier marcheur-des-flots"] = {t=0, pBar="MixedTrash"};
					["Morogrim Marcheur-des-flots"] = {t=0, tchange={"MixedTrash", "perm", 0}, delBar="MixedTrash"};

			["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Porte-bouclier griscoeur"] = {t=0, pBar="LeotherasTrash"};
					["Leotheras l'Aveugle"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"};
	        }

	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
	
		CEnemyCastBar_Raids = {
	
		-- Gruuls
	
			-- Krosh Firehand
			["Gardien de magie"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"}; --!correct?

			-- Respawn timer
			["OgreRespawn"] = {t=3600, c="cooldown", global="true", m="Gruul", icontex="Spell_Holy_Resurrection"};
				["Brute du repaire"] = {t=0, pBar="OgreRespawn"};
				["Pr\195\170tre-Gronn"] = {t=0, pBar="OgreRespawn"};
					["Haut Roi Maulgar"] = {t=0, delBar="OgreRespawn"};
					["Gruul le Tue-dragon"] = {t=0, delBar="OgreRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["Bourreau de Kargath"] = {t=4800, c="cooldown", global="true", m="Heroic Quest", icontex="Spell_Holy_Resurrection"};
			["Chef de guerre Kargath Lamepoing"] = {t=0, delBar="Bourreau de Kargath"};
		}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;

		CEnemyCastBar_Raids = {

			-- Respawn timer
			["StableRespawn"] = {t=1500, c="cooldown", global="true", m="Attumen", icontex="Spell_Holy_Resurrection"};
				["Etalon spectral"] = {t=0, pBar="StableRespawn"};
				["Destrier spectral"] = {t=0, pBar="StableRespawn"};
					["Attumen le Veneur"] = {t=0, tchange={"StableRespawn", "perm", 0}, delBar="StableRespawn"};
 
			["DancerRespawn"] = {t=3600, c="cooldown", global="true", m="Moroes", icontex="Spell_Holy_Resurrection"};
				["Invit\195\169 fant\195\180me"] = {t=0, pBar="DancerRespawn"};
					["Moroes"] = {t=0, tchange={"DancerRespawn", "perm", 0}, delBar="DancerRespawn"};

			["GuestQuarterRespawn"] = {t=3600, c="cooldown", global="true", m="Maiden", icontex="Spell_Holy_Resurrection"};
				["Gardien fant\195\180me"] = {t=0, pBar="GuestQuarterRespawn"};
				["Factionnaire spectral"] = {t=0, pBar="GuestQuarterRespawn"};
					["Damoiselle de vertu"] = {t=0, tchange={"GuestQuarterRespawn", "perm", 0}, delBar="GuestQuarterRespawn"};

			["TheatreRespawn"] = {t=3600, c="cooldown", global="true", m="Opera", icontex="Spell_Holy_Resurrection"};
				["Ouvreur squelettique"] = {t=0, pBar="TheatreRespawn"};
					["La M\195\169g\195\168re"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
					["Le Grand M\195\169chant Loup"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
					["Philanthrope fantomatique"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};

			["GalleryRespawn"] = {t=3600, c="cooldown", global="true", m="Curator", icontex="Spell_Holy_Resurrection"};
				["Veilleur arcanique"] = {t=0, pBar="GalleryRespawn"};
					["Le conservateur"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, delBar="GalleryRespawn"};

			["LibraryRespawn1"] = {t=7200, c="cooldown", global="true", m="Aran", icontex="Spell_Holy_Resurrection"};
				["Protecteur arcanique"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, pBar="LibraryRespawn1", delBar="GalleryRespawn"};
					["Ombre d'Aran"] = {t=0, tchange={"LibraryRespawn1", "perm", 0}, delBar="LibraryRespawn1"};

			["LibraryRespawn2"] = {t=7200, c="cooldown", global="true", m="Illhoof", icontex="Spell_Holy_Resurrection"};
				["Homoncule"] = {t=0, pBar="LibraryRespawn2"};
				["Pilleur d'ombre"] = {t=0, pBar="LibraryRespawn2"};
					["Terestian Malsabot"] = {t=0, tchange={"LibraryRespawn2", "perm", 0}, delBar="LibraryRespawn2"};

			["LibraryRespawn3"] = {t=7200, c="cooldown", global="true", m="Netherspite", icontex="Spell_Holy_Resurrection"};
				["Ombre ensorceleuse"] = {t=0, pBar="LibraryRespawn3"};
					["D\195\169dain-du-N\195\169ant"] = {t=0, tchange={"LibraryRespawn3", "perm", 0}, delBar="LibraryRespawn3"};

			["TheTopRespawn"] = {t=7200, c="cooldown", global="true", m="Malchezaar", icontex="Spell_Holy_Resurrection"};
				["B\195\170te de chair"] = {t=0, pBar="TheTopRespawn"};
				["B\195\170te de chair sup\195\169rieure"] = {t=0, pBar="TheTopRespawn"};
					["Prince Malchezaar"] = {t=0, tchange={"TheTopRespawn", "perm", 0}, delBar="TheTopRespawn"};
		}
	
		CEnemyCastBar_Afflictions["Brittle Bones"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0 --!translate
		CEnemyCastBar_Afflictions["Couronne de flammes"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
		CEnemyCastBar_Afflictions["Overload"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff --! translate
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["L'ultimatum du baron"] = {t=2700, c="cooldown", global="true", m="Baron Run", icontex="Spell_Holy_Resurrection"};
			["Baron Vaillefendre"] = {t=0, delBar="L'ultimatum du baron"};
		}

	elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
		
		-- Naxxramas
	
			["Necro Stalker"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
			-- Anub'Rekhan
			["First Locust Swarm"] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
			["Essaim de sauterelles"] = {t=23, i=3, c="gainsfoe", delBar="Essaim de sauterelles CD", aBar="Essaim de sauterelles CD", active="true", icontex="Spell_Nature_InsectSwarm"}; --? to be checked!
			["Essaim de sauterelles CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
	
			-- Patchwerk
			["Enraged Mode"] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
			-- Razuvious
			["Cri perturbant"] = {t=25, c="cooldown", active="true", delBar="Cri perturbant possible", aBar="Cri perturbant possible", icontex="Ability_Creature_Disease_02"};
			["Cri perturbant possible"] = {t=25, c="cooldown", aBar="Cri perturbant possible", icontex="Ability_Creature_Disease_02"};
	
			-- Gluth
			["Rugissement terrifiant"] = {t=20.0, c="cooldown", m="Gluth", aZone="Naxxramas", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
			["D\195\169cimer"] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};
	
			-- Maexxna
			["Jet de rets"] = {t=40, c="cooldown", pBar="Petite araign\195\169e", m="Maexxna", aZone="Naxxramas", icontex="Ability_Ensnare"};
			["Petite araign\195\169e"] = {t=30, c="cooldown", pBar="Entoilage CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
			["Entoilage CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};
	
			-- Thaddius
			["Changement de polarit\195\169"] = {t=30, i=3, c="cooldown", mcheck="Thaddius", pBar="Becomes enraged!", icontex="Spell_Nature_Lightning"};
			["Vague de puissance"] = {t=10, c="gainsfoe", mcheck="Stalagg", icontex="Spell_Shadow_SpectralSight"};
			["Becomes enraged!"] = {t=290, c="cooldown", global="true", tchange={"Becomes enraged!", 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated
	
			-- Faerlina
			["Enrager"] = {t=60, c="cooldown", mcheck="Grande veuve Faerlina", icontex="Spell_Shadow_UnholyFrenzy"};
			["Etreinte de la veuve"] = {t=30, c="cooldown", mcheck="Grande veuve Faerlina", icontex="Spell_Arcane_Blink"}; -- Fearlina
	
			-- Loatheb
			["15 sec Doom CD!"] = {t=299, tchange={"Mal\195\169diction in\195\169vitable", 30, 15}, c="cooldown", m="Horreb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
			["First Inevitable Doom"] = {t=120, c="cooldown", m="Horreb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
			["Mal\195\169diction in\195\169vitable"] = {t=30, c="cooldown", m="Horreb", icontex="Spell_Shadow_NightOfTheDead"};
	
			["Invocation de spore"] = {t=12.5, icasted="true", c="cooldown", mcheck="Horreb", icontex="Spell_Nature_AbolishMagic"};
			["D\195\169livrance de la mal\195\169diction sur Horreb"] = {t=0.1, icasted="true", c="cooldown", pBar="Curses Removed", mcheck="Horreb"};
			["Curses Removed"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"}; -- TRANSLATE TO Above PBAR only
	
			-- Gothik
			-- don't translate, ALL used internally!
			["Comes Down"] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
			["del1"] = {t=0.1, pBar="del2", delBar="Trainees INC"};
			["del2"] = {t=0.1, pBar="del3", delBar="Deathknights INC"};
			["del3"] = {t=0.1, delBar="Rider INC"};
			
			["First Trainees"] = {t=27, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
			["First Deathknights"] = {t=77, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
			["First Rider"] = {t=137, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"};
			["Trainees INC"] = {t=20, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
			["Deathknights INC"] = {t=25, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
			["Rider INC"] = {t=30, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"};
	
			-- Noth
			["Transfert"] = {t=30, c="cooldown", mcheck="Noth le Porte%-peste", aZone="Naxxramas", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
			["First Teleport"] = {t=90, c="cooldown", aBar="On Balcony 1", aZone="Naxxramas", icontex="Spell_Nature_AstralRecalGroup"};
			["On Balcony 1"] = {t=70, c="cooldown", aBar="Second Teleport", icontex="Spell_Nature_AstralRecalGroup"};
			["Second Teleport"] = {t=110, c="cooldown", aBar="On Balcony 2", icontex="Spell_Nature_AstralRecalGroup"};
			["On Balcony 2"] = {t=95, c="cooldown", aBar="Third Teleport", icontex="Spell_Nature_AstralRecalGroup"};
			["Third Teleport"] = {t=180, c="cooldown", aBar="On Balcony 3", icontex="Spell_Nature_AstralRecalGroup"};
			["On Balcony 3"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};
	
			-- Heigan
			["On Platform"] = {t=45, c="cooldown", aBar="Teleport CD", icontex="INV_Enchant_EssenceAstralLarge"};
			["Teleport CD"] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};
	
			-- Sapphiron
			["Life Drain"] = {t=24, c="cooldown", m="Sapphiron", aZone="Naxxramas", icontex="Spell_Shadow_LifeDrain02"}; --! translate spell!
	
				}
	
	
		-- Naxxramas
		NECB_PvE_Vars["HEIGAN_YELL1"]			= "Je vous vois...";
		NECB_PvE_Vars["HEIGAN_YELL2"]			= "Vous \195\170tes \195\160 moi, maintenant.";
		NECB_PvE_Vars["HEIGAN_YELL3"]			= "Tu es... le suivant.";
		NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]		= "Votre fin est venue.";
	
		NECB_PvE_Vars["FAER_YELL1"]			= "Vous ne pouvez pas m'\195\169chapper !";
		NECB_PvE_Vars["FAER_YELL2"]			= "Tuez-les au nom du ma\195\174tre !";
		NECB_PvE_Vars["FAER_YELL3"]			= "Fuyez tant que vous le pouvez !";
		NECB_PvE_Vars["FAER_YELL4"]			= "A genoux, vermisseau !";
	
		NECB_PvE_Vars["PATCHWERK_NAME"]			= "Patchwerk";
	
		NECB_PvE_Vars["GOTHIK_YELL"]			= "Dans votre folie, vous avez provoqu\195\169 votre propre mort.";
	
		NECB_PvE_Vars["ANUB_YELL1"]			= "Rien qu'une petite bouch\195\169e";
		NECB_PvE_Vars["ANUB_YELL2"]			= "Oui, courez ! Faites circulez le sang !";
		NECB_PvE_Vars["ANUB_YELL3"]			= "Nulle part pour s'enfuir.";

		-- Naxxramas
		CEnemyCastBar_Afflictions["Blessure mortelle"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
		CEnemyCastBar_Afflictions["Injection mutante"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
		CEnemyCastBar_Afflictions["Entoilage"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
		CEnemyCastBar_Afflictions["Poison n\195\169crotique"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; --! validate -- Maexxna MT -healing Debuff(poison)
		CEnemyCastBar_Afflictions["Detonate de mana"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb --! translate "Detonate Mana"
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	
	elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Ahn'Qiraj
		
			-- 40 Man
				["Eradicateur d'obsidienne"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
				-- Twin Emperors
				["T\195\169l\195\169portation des jumeaux"] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
				["Explosion de l'insecte"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
				["Mutation de l'insecte"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};
	
				-- Ouro
				["Explosion de sable"] = {t=2.0, c="hostile", mcheck="Ouro", icontex="Spell_Nature_Cyclone"};
				["Balayer"] = {t=21, i=1.0, c="cooldown", mcheck="Ouro", icontex="Spell_Nature_Thorns"};
	
				["Invocation de Monticules d'Ouro"] = {t=0.1, delBar="Possible Ouro Submerge", icasted="true", pBar="Submerged"};
				["Submerged"] = {t=30, c="cooldown", delBar="Ouro Submerges", aBar="Possible Ouro Submerge", icontex="INV_Qiraj_OuroHide"};
				["Possible Ouro Submerge"] = {t=90, c="cooldown", pBar="Ouro Submerges", icontex="Spell_Shadow_DemonBreath"};
				["Ouro Submerges"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"};
	
				-- C'Thun
				["First Dark Glare"] = {t=48, c="cooldown", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
				["Weakened!"] = {t=45, c="gainsfoe", delBar="Small Eyes P2", aBar="After Weakened Eyes", icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
				["Dark Glare"] = {t=86, i=40, c="cooldown", active="true", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
				["Small Eyes P1"] = {t=45, c="cooldown", aBar="Small Eyes P1", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["First Small Eyes P2"] = {t=42, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["Small Eyes P2"] = {t=30, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["After Weakened Eyes"] = {t=38, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	
				-- Skeram
				["Explosion des arcanes"] = {t=1.2, c="hostile", mcheck="Le Proph\195\168te Skeram", icontex="Spell_Nature_WispSplode"};
	
				-- Sartura (Twin Emps enrage + Hakkar enrage)
				["Tourbillon"] = {t=15.0, c="gainsfoe", mcheck="Garde de guerre Sartura", icontex="Ability_Whirlwind"};
				["Enraged mode"] = {t=900, r="Garde de guerre Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
				["Enters Enraged mode"] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
				-- Huhuran
				["Berserk mode"] = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
				["Enters Berserk mode"] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
				["Piq\195\187re de wyverne"] = {t=25, c="cooldown", m="Huhuran", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};
	
				-- Yauj
				["Peur"] = {t=20, c="cooldown", checkengage="true", m="Yauj", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
				["Soins exceptionnels"] = {t=2.0, c="hostile", m="Yauj", mcheck="Princesse Yauj", icontex="Spell_Holy_Heal"};
	
	
					}
	
		-- AQ40
		NECB_PvE_Vars["SARTURA_CALL"]			= "Vous serez jug\195\169s pour avoir profan\195\169 ces lieux sacr\195\169s";
		NECB_PvE_Vars["SARTURA_CRAZY"]			= "devient fou furieux";
	
		NECB_PvE_Vars["HUHURAN_CRAZY"]			= "entre dans une rage d\195\169mente";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "est pris de fr\195\169n\195\169sie";
	
		NECB_PvE_Vars["CTHUN_NAME1"]	 		= "Oeil de C'Thun";
		NECB_PvE_Vars["CTHUN_WEAKENED"]			= "est affaibli";

		-- AQ40
		CEnemyCastBar_Afflictions["Accomplissement v\195\169ritable"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
		CEnemyCastBar_Afflictions["Peste"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
		CEnemyCastBar_Afflictions["Enchev\195\170trement"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
	
			-- 20 Man
	
				["Exploser"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};
	
				-- Ossirian
				["Sensibilit\195\169 aux Arcanes"] = {t=45, c="gainsfoe", mcheck="Ossirian l'Intouch\195\169", icontex="INV_Misc_QirajiCrystal_01"};
				["Sensibilit\195\169 au Feu"] = {t=45, c="gainsfoe", mcheck="Ossirian l'Intouch\195\169", icontex="INV_Misc_QirajiCrystal_02"};
				["Sensibilit\195\169 \195\160 la Nature"] = {t=45, c="gainsfoe", mcheck="Ossirian l'Intouch\195\169", icontex="INV_Misc_QirajiCrystal_03"};
				["Sensibilit\195\169 au Givre"] = {t=45, c="gainsfoe", mcheck="Ossirian l'Intouch\195\169", icontex="INV_Misc_QirajiCrystal_04"};
				["Sensibilit\195\169 \195\160 l'Ombre"] = {t=45, c="gainsfoe", mcheck="Ossirian l'Intouch\195\169", icontex="INV_Misc_QirajiCrystal_05"};
	
				-- Moam
				["Until Stoneform"] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
				["Dynamiser"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
					}
	
		-- Ruins of AQ
		NECB_PvE_Vars["MOAM_STARTING"]			= "sent votre peur.";

		-- AQ20
		CEnemyCastBar_Afflictions["Paralysie"] = {t=10, global="true", aZone="Ruines d'Ahn'Qiraj", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
		-- Moam
		CEnemyCastBar_Afflictions["Dynamiser"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Gurub
	
			-- Hakkar
			["Siphon de sang"] = {t=90, c="cooldown", mcheck="Hakkar", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
			["Enraged mode"] = {t=900, r="Garde de guerre Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
					}
	
		-- Zul'Gurub
		NECB_PvE_Vars["HAKKAR_YELL"]			= "ANNONCE LA FIN DE VOTRE MONDE";

		-- Zul'Gurub
		CEnemyCastBar_Afflictions["Illusions de Jin'do"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
		CEnemyCastBar_Afflictions["Rendre frou"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
		CEnemyCastBar_Afflictions["Regard mena\195\167ant"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Molten Core
	
			-- Shazzrah
			["Porte de Shazzrah"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
		
			-- Lucifron
			["Mal\195\169diction imminente"] = {t=20, c="cooldown", m="Lucifron", icontex="Spell_Shadow_NightOfTheDead"};
			["Mal\195\169diction de Lucifron"] = {t=20, c="cooldown", m="Lucifron", icontex="Spell_Shadow_BlackPlague"};
		
			-- Magmadar
			["Panique"] = {t=30, c="cooldown", m="Magmadar", icontex="Spell_Shadow_DeathScream"};
	
			-- Gehennas
			["Mal\195\169diction de Gehennas"] = {t=30, c="cooldown", m="Gehennas", icontex="Spell_Shadow_GatherShadows"};
	
			-- Geddon
			["Infernal"] = {t=8.0, c="gainsfoe", mcheck="Baron Geddon", icontex="Spell_Fire_Incinerate"};
	
			-- Majordomo
			["Renvoi de la magie"] = {t=30, i=10.0, c="cooldown", m="Majordomo", aZone="C\197\147ur du Magma", icontex="Spell_Frost_FrostShock"};
			["Bouclier de d\195\169g\195\162ts"] = {t=30, i=10.0, c="cooldown", m="Majordomo", icontex="Spell_Nature_LightningShield"};
			
			-- Ragnaros
			["Submerge"] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
			["Knockback"] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
			["Sons of Flame"] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!
	
					}
	
		-- MC
		NECB_PvE_Vars["RAGNAROS_STARTING"]			= "^ET MAINTENANT,";
		NECB_PvE_Vars["RAGNAROS_KICKER"]			= "^GO\195\155TEZ";
		NECB_PvE_Vars["RAGNAROS_SONS"]	 		= "^VENEZ, MES SERVITEURS";

		-- MC
		CEnemyCastBar_Afflictions["Bombe vivante"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Onyxia
			["Souffle de flammes"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
			["Deep Breath"] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"}; 
			["Frappe des ailes"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
			["Rugissement puissant"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
	
	
					}
	
		-- ONY
		NECB_PvE_Vars["ONY_DB"]				= "prend une grande inspiration..."; 
	
	elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Blackwing Lair
	
			-- Razorgore
			["Mob Spawn (45sec)"] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
	
			-- Firemaw/Flamegor/Ebonroc
			["Frappe des ailes"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
			["First Wingbuffet"] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"};  -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
			["Flamme d'ombre"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"}; 
			
			-- Flamegor
			[CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
			
			-- Chromaggus
			["Br\195\187lure de givre"] = {t=60, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
			["Trou de temps"] = {t=60, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
			["Enflammer la chair"] = {t=60, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
			["Acide corrosif"] = {t=60, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
			["Incin\195\169rer"] = {t=60, i=2.0, c="cooldown", active="true", mcheck="Chromaggus", icontex="Spell_Fire_FlameShock"};
			["Killing Frenzy"] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
				-- Chromaggus, Flamegor, Magmadar etc.
			["Fr\195\169n\195\169sie"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};
	
			-- Neferian/Onyxia
			["Rugissement puissant"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
			
			-- Nefarian
			["Nefarian calls"] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
			["Mob Spawn"] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
			["Landing"] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
					}
	
		-- BWL
		NECB_PvE_Vars["RAZORGORE_CALL"]			= "Sonnez l'alarme";
	
		NECB_PvE_Vars["FIREMAW_NAME"]			= "Gueule-de-feu";
		NECB_PvE_Vars["EBONROC_NAME"]			= "Ebonroc";
		NECB_PvE_Vars["FLAMEGOR_NAME"]			= "Flamegor";	
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "est pris de fr\195\169n\195\169sie";
		NECB_PvE_Vars["CHROMAGGUS_FRENZY"]			= "entre dans une sanglante fr\195\169n\195\169sie";
		
		NECB_PvE_Vars["NEFARIAN_STARTING"]			= "Que les jeux commencent";
		NECB_PvE_Vars["NEFARIAN_LAND"]			= "Beau travail";
		NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"]		= "Chamans, montrez moi";
		NECB_PvE_Vars["NEFARIAN_DRUID_CALL"]		= "Les druides et leur stupides";
		NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"]		= "D\195\169monistes, vous ne devriez pas jouer";
		NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"]		= "Pr\195\170tres ! Si vous continuez";
		NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"]		= "Ah, les chasseurs et les stupides";
		NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"]		= "Guerriers, je sais que vous pouvez frapper plus fort";
		NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"]		= "Voleurs, arr\195\170tez de vous cacher";
		NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"]		= "Les paladins";
		NECB_PvE_Vars["NEFARIAN_MAGE_CALL"]		= "Les mages aussi";

		-- BWL
		CEnemyCastBar_Afflictions["D\195\169flagration"] = {t=10.0, global="true", aZone="Repaire de l'Aile noire", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning
		CEnemyCastBar_Afflictions["Mont\195\169e d'adr\195\169naline"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA
		CEnemyCastBar_Afflictions["Ombre d'Ebonroc"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff
		-- Non Boss DeBuffs:
		CEnemyCastBar_Afflictions["M\195\169tamorphose sup\195\169rieure"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	else
		CEnemyCastBar_Raids = { };
		NECB_PvE_Vars = { };

	end
		
			-- Other
	
		for k, v in pairs (CEnemyCastBar_Raids) do
			CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
			break;
		end

		--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

		if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
			CECB_ReloadOptionsUI(); -- update tooltip
		end

  end

end