--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!
-------------
-- SPANISH --
-------------
--  = \195\161 ----  = Á
--  = \195\169 ----  = \195\137
--  = \195\173 ----  = \195\141
--  = \195\179 ----  = \195\147
--  = \195\186 ----  = \195\154
--  = \195\177 ----  = \195\145
--  = \194\161 ----  = \194\191

if ( GetLocale() == "esES" ) then

		-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
		-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
		-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
		-- "active" only allows this spell to be an active cast, no afflictions and something else!
		-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
		-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
		-- "icasted" guides this spell through the instant cast protection
		-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
		-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
		-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
		-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
		-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
		-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
		--  tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas 		= "Naxxramas";
	NECB_AhnQiraj 		= "Ahn'Qiraj";
	NECB_AhnQirajRuins 	= "Ruinas de Ahn'Qiraj";
	NECB_ZulGurub 		= "Zul'Gurub";
	NECB_MoltenCore 	= "Núcleo de Magma";
	NECB_OnyxiaLair 	= "Guarida de Onyxia";
	NECB_BlackwingLair 	= "Guarida Alanegra";
	NECB_Stratholme 	= "Stratholme";
	--BC
	NECB_ShatteredHalls 	= "Las Salas Arrasadas";
	NECB_Magtheridon 	= "Guarida de Magtheridon";
	NECB_GruulsLair 	= "Guarida de Gruul";
	NECB_Karazhan 		= "Karazhan";
	NECB_SerpentshrineCavern = "Caverna Santuario Serpiente";
	NECB_Tempest_Keep = "El Castillo de la Tempestad";
	NECB_Black_Temple = "El Templo Oscuro";
	NECB_ZulAman = "Zul'Aman";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
		NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
		if not forcereg then
			return;
		end
		break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Magtheridon
	
			-- Respawn timer
			["TrashRespawn"] = {t=7200, c="cooldown", global="true", m="Magtheridon", icontex="Spell_Holy_Resurrection"};
				["Celador Fuego Infernal"] = {t=0, pBar="TrashRespawn"};
					["Magtheridon"] = {t=0, delBar="TrashRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Amani'shi Tempest"] = {t=0, pBar="Akil'zon Trash"}; -- translate!
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};
		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Black Temple Respawn timer

			["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Aqueous Lord"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["Coilskar General"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["Coilskar Harpooner"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				["Leviathan"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
				-- + Coilskar Soothsayer, Coilskar Wrangler
					["High Warlord Naj'entus"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"}; -- translate!

			["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Ashtongue Primalist"] = {t=0, pBar="Akama Trash"}; -- translate!
				["Ashtongue Mystic"] = {t=0, pBar="Akama Trash"}; -- translate!
				["Ashtongue Battlelord"] = {t=0, pBar="Akama Trash"}; -- translate!
					["Shade of Akama"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"}; -- translate! 

			["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Shadowmoon Champion"] = {t=0, pBar="Gorefiend Trash"}; -- translate!
				["Shadowmoon Reaver"] = {t=0, pBar="Gorefiend Trash"}; -- translate!
					["Teron Gorefiend"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"}; -- translate!

			["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"}; -- translate!
				["Bonechewer Worker"] = {t=0, pBar="Supremus Trash"}; -- translate!
				["Bonechewer Taskmaster"] = {t=0, pBar="Supremus Trash"}; -- translate!
					["Supremus"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"};

			["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Bonechewer Shield Disciple"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
				["Bonechewer Blade Fury"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
				["Mutant War Hound"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
					["Gurtogg Bloodboil"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"}; -- translate!

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Temple Concubine"] = {t=0, pBar="Mother Shahraz Trash"};
				["Charming Courtesan"] = {t=0, pBar="Mother Shahraz Trash"};
				["Spellbound Attendant"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pain"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pleasure"] = {t=0, pBar="Mother Shahraz Trash"};
					["Mother Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Promenade Sentinel"] = {t=0, pBar="Illidari Council Trash"}; -- translate!
					["Gathios the Shatterer"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	-- translate!
		}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Tempest Keep
	
			-- Respawn timer
			["Al'ar Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Star Scryer"] = {t=0, pBar="Al'ar Trash"}; --! translate
				["Astromancer"] = {t=0, pBar="Al'ar Trash"}; --! translate
				["Bloodwarder Vindicator"] = {t=0, pBar="Al'ar Trash"}; --! translate
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Al'ar Trash"}; --! translate
					["Al'ar"] = {t=0, tchange={"Al'ar Trash", "perm", 0}, delBar="Al'ar Trash"};

			["Void Reaver Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Crystalcore Devastator"] = {t=0, pBar="Void Reaver Trash"}; --! translate
				--["Crystalcore Sentinel"] = {t=0, pBar="Void Reaver Trash"}; --! translate
					["Void Reaver"] = {t=0, tchange={"Void Reaver Trash", "perm", 0}, delBar="Void Reaver Trash"}; --! translate

			["Astromancer Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Astromancer Lord"] = {t=0, pBar="Astromancer Trash"}; --! translate
			-- conflict ["Bloodwarder Legionnaire"] = {t=0, pBar="Astromancer Trash"}; --! translate
				["Novice Astromancer"] = {t=0, pBar="Astromancer Trash"}; --! translate
					["High Astromancer Solarian"] = {t=0, tchange={"Astromancer Trash", "perm", 0}, delBar="Astromancer Trash"}; --! translate

			["Kael'thas Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Crimson Hand Battle Mage"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
				["Crimson Hand Blood Knight"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
				["Crimson Hand Centurion"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
				["Crimson Hand Inquisitor"] = {t=0, pBar="Kael'thas Trash"}; -- translate!
					["Kael'thas Sunstrider"] = {t=0, tchange={"Kael'thas Trash", "perm", 0}, delBar="Kael'thas Trash"}; -- translate!

		}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	    
	        CEnemyCastBar_Raids = {
	        
	        -- Serpentshrine Cavern
	        
		        -- Respawn timer
			["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Domador de bestia Colmillo Torcido"] = {t=0, pBar="HydrossTrash"}; --! No testeado
				["Gritador Odioso Colmillo Torcido"] = {t=0, pBar="HydrossTrash"}; --! No testeado
				["Serpentshrine Sporebat"] = {t=0, pBar="HydrossTrash"}; --! translate
					["Hydross el Inestable"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

			["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Guardia de Honor Vashj'ir"] = {t=0, pBar="LurkerTrash"}; --! No testeado
				["Suma Sacerdotisa Colmillo Torcido"] = {t=0, pBar="LurkerTrash"}; --! No testeado
					["El Rondador de abajo"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

			["PermaTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Greyheart Nether-Mage"] = {t=0, pBar="PermaTrash"}; --! translate
				["Greyheart Tidecaller"] = {t=0, pBar="PermaTrash"}; --! translate
				["Greyheart Skulker"] = {t=0, pBar="PermaTrash"}; --! translate

			["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Tidewalker Shaman"] = {t=0, pBar="MixedTrash"}; --! translate
				["Tidewalker Depth-Seer"] = {t=0, pBar="MixedTrash"}; --! translate
				["Tidewalker Warrior"] = {t=0, pBar="MixedTrash"}; --! translate
					["Morogrim Tidewalker"] = {t=0, tchange={"MixedTrash", "perm", 0}, delBar="MixedTrash"}; --! translate

			["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Greyheart Shild-Bearer"] = {t=0, pBar="LeotherasTrash"}; --! translate
					["Leotheras the Blind"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"}; --! translate
	        }

	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
	
		CEnemyCastBar_Raids = {
	
		-- Gruuls
	
			-- Krosh Firehand
			["Resguardo contra la Mágia"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"}; --!correct?

			-- Respawn timer
			["OgreRespawn"] = {t=3600, c="cooldown", global="true", m="Gruul", icontex="Spell_Holy_Resurrection"};
				["Tosco de guarida"] = {t=0, pBar="OgreRespawn"};
				["Gronn-Sacerdote"] = {t=0, pBar="OgreRespawn"};
					["Su majestad Maulgar"] = {t=0, delBar="OgreRespawn"};
					["Gruul el Asesino de Dragones"] = {t=0, delBar="OgreRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["Verdugo de Kargath"] = {t=4800, c="cooldown", global="true", m="Heroic Quest", icontex="Spell_Holy_Resurrection"};
			["Jefe de Guerra Garrafilada"] = {t=0, delBar="Verdugo de Kargath"}; --! translate boss name
		}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;

		CEnemyCastBar_Raids = {

			-- Respawn timer
			["StableRespawn"] = {t=1500, c="cooldown", global="true", m="Attumen", icontex="Spell_Holy_Resurrection"};
				["Semental espectral"] = {t=0, pBar="StableRespawn"};
				["Garañón espectral"] = {t=0, pBar="StableRespawn"};
					["Attumen el Montero"] = {t=0, tchange={"StableRespawn", "perm", 0}, delBar="StableRespawn"};
 
			["DancerRespawn"] = {t=3600, c="cooldown", global="true", m="Moroes", icontex="Spell_Holy_Resurrection"};
				["Aparición de invitado"] = {t=0, pBar="DancerRespawn"};
					["Moroes"] = {t=0, tchange={"DancerRespawn", "perm", 0}, delBar="DancerRespawn"};

			["GuestQuarterRespawn"] = {t=3600, c="cooldown", global="true", m="Maiden", icontex="Spell_Holy_Resurrection"};
				["Aparición de custodio"] = {t=0, pBar="GuestQuarterRespawn"};
				["Centinela espectral"] = {t=0, pBar="GuestQuarterRespawn"};
					["Doncella de Virtud"] = {t=0, tchange={"GuestQuarterRespawn", "perm", 0}, delBar="GuestQuarterRespawn"};

			["TheatreRespawn"] = {t=3600, c="cooldown", global="true", m="Opera", icontex="Spell_Holy_Resurrection"};
				["Acomodador esquelético"] = {t=0, pBar="TheatreRespawn"};
					["La Vieja Bruja"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
					["El Gran Lobo Malvado"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};
					["Filántropo fantasmal"] = {t=0, tchange={"TheatreRespawn", "perm", 0}, delBar="TheatreRespawn"};

			["GalleryRespawn"] = {t=3600, c="cooldown", global="true", m="Curator", icontex="Spell_Holy_Resurrection"};
				["Vigilante Arcano"] = {t=0, pBar="GalleryRespawn"};
					["Curator"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, delBar="GalleryRespawn"};

			["LibraryRespawn1"] = {t=7200, c="cooldown", global="true", m="Aran", icontex="Spell_Holy_Resurrection"};
				["Protector Arcano"] = {t=0, tchange={"GalleryRespawn", "perm", 0}, pBar="LibraryRespawn1", delBar="GalleryRespawn"};
					["Sombra de Aran"] = {t=0, tchange={"LibraryRespawn1", "perm", 0}, delBar="LibraryRespawn1"};

			["LibraryRespawn2"] = {t=7200, c="cooldown", global="true", m="Illhoof", icontex="Spell_Holy_Resurrection"};
				["Homunculus"] = {t=0, pBar="LibraryRespawn2"};
				["Saqueador de las sombras"] = {t=0, pBar="LibraryRespawn2"};
					["Terestian Pezuña Enferma"] = {t=0, tchange={"LibraryRespawn2", "perm", 0}, delBar="LibraryRespawn2"};

			["LibraryRespawn3"] = {t=7200, c="cooldown", global="true", m="Netherspite", icontex="Spell_Holy_Resurrection"};
				["Sombra hechichera"] = {t=0, pBar="LibraryRespawn3"};
					["Rencor abisal"] = {t=0, tchange={"LibraryRespawn3", "perm", 0}, delBar="LibraryRespawn3"};

			["TheTopRespawn"] = {t=7200, c="cooldown", global="true", m="Malchezaar", icontex="Spell_Holy_Resurrection"};
				["Bestia de carne"] = {t=0, pBar="TheTopRespawn"};
				["Bestia de carne superior"] = {t=0, pBar="TheTopRespawn"};
					["Príncipe Malchezaar"] = {t=0, tchange={"TheTopRespawn", "perm", 0}, delBar="TheTopRespawn"};
		}

		CEnemyCastBar_Afflictions["Huesos quebradizos"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0
		CEnemyCastBar_Afflictions["Corona de llamas"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
		CEnemyCastBar_Afflictions["Sobrecarga"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["El ultim\195\161tum del bar\195\179n"] = {t=2700, c="cooldown", global="true", m="Baron Run", icontex="Spell_Holy_Resurrection"};
			["Bar\195\179n Rivendare"] = {t=0, delBar="El ultim\195\161tum del bar\195\179n"};
		}

	elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
		
		-- Naxxramas
	
			["Acechamorte"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
			-- Anub'Rekhan
			["Primer Enjambre de langostas"] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
			["Enjambre de langostas"] = {t=23, i=3, c="gainsfoe", delBar="Locust Swarm CD", aBar="Locust Swarm CD", active="true", icontex="Spell_Nature_InsectSwarm"};
			["Enjambre de langostas CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
	
			-- Patchwerk
			["Enraged Mode"] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
			-- Razuvious
			["Grito perturbador"] = {t=25, c="cooldown", active="true", delBar="Disrupting Shout possible", aBar="Disrupting Shout possible", icontex="Ability_Creature_Disease_02"};
			["Posible Grito perturbador"] = {t=25, c="cooldown", aBar="Disrupting Shout possible", icontex="Ability_Creature_Disease_02"};
	
			-- Gluth
			["Rugido aterrorizador"] = {t=20.0, c="cooldown", m="Gluth", aZone="Naxxramas", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
			["Diezmar"] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};
	
			-- Maexxna
			["Pulverizador de telaraña"] = {t=40, c="cooldown", pBar="Mini Spiders", m="Maexxna", aZone="Naxxramas", icontex="Ability_Ensnare"};
			["Arañas pequeñas"] = {t=30, c="cooldown", pBar="Web Wrap CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
			["Trampa arácnida CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};
	
			-- Thaddius
			["Cambio de polaridad"] = {t=30, i=3, c="cooldown", pBar="Becomes enraged!", mcheck="Thaddius", icontex="Spell_Nature_Lightning"};
			["Oleada de poder"] = {t=10, c="gainsfoe", mcheck="Stalagg", icontex="Spell_Shadow_SpectralSight"};
			["Becomes enraged!"] = {t=290, c="cooldown", global="true", tchange={"Becomes enraged!", 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated
	
			-- Faerlina
			["Enfurecer"] = {t=60, c="cooldown", mcheck="Grand Widow Faerlina", icontex="Spell_Shadow_UnholyFrenzy"};
			["Abrazo de la viuda"] = {t=30, c="cooldown", mcheck="Grand Widow Faerlina", icontex="Spell_Arcane_Blink"}; -- Fearlina
	
			-- Loatheb
			["15 sec Doom CD!"] = {t=299, tchange={"Inevitable Doom", 30, 15}, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
			["First Inevitable Doom"] = {t=120, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
			["Condena inevitable"] = {t=30, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"};
	
			["Invocar espora"] = {t=12.5, icasted="true", c="cooldown", mcheck="Loatheb", icontex="Spell_Nature_AbolishMagic"};
			["Deshacer maldición en Loatheb"] = {t=0.1, icasted="true", c="cooldown", pBar="Curses Removed", mcheck="Loatheb"};
			["Maldiciones quitadas"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"};
	
			-- Gothik
			-- don't translate, ALL used internally!
			["Comes Down"] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
			["del1"] = {t=0.1, pBar="del2", delBar="Trainees INC"};
			["del2"] = {t=0.1, pBar="del3", delBar="Deathknights INC"};
			["del3"] = {t=0.1, delBar="Rider INC"};
			
			["First Trainees"] = {t=27, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
			["First Deathknights"] = {t=77, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
			["First Rider"] = {t=137, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"};
			["Trainees INC"] = {t=20, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
			["Deathknights INC"] = {t=25, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
			["Rider INC"] = {t=30, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"}; 
	
			-- Noth
			["Traslación"] = {t=30, c="cooldown", mcheck="Noth the Plaguebringer", aZone="Naxxramas", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
 			["First Teleport"] = {t=90, c="cooldown", aBar="On Balcony 1", aZone="Naxxramas", icontex="Spell_Nature_AstralRecalGroup"};
 			["On Balcony 1"] = {t=70, c="cooldown", aBar="Second Teleport", icontex="Spell_Nature_AstralRecalGroup"};
 			["Second Teleport"] = {t=110, c="cooldown", aBar="On Balcony 2", icontex="Spell_Nature_AstralRecalGroup"};
 			["On Balcony 2"] = {t=95, c="cooldown", aBar="Third Teleport", icontex="Spell_Nature_AstralRecalGroup"};
 			["Third Teleport"] = {t=180, c="cooldown", aBar="On Balcony 3", icontex="Spell_Nature_AstralRecalGroup"};
 			["On Balcony 3"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};
	
			-- Heigan
			["On Platform"] = {t=45, c="cooldown", aBar="Teleport CD", icontex="INV_Enchant_EssenceAstralLarge"};
			["Teleport CD"] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};
	
			-- Sapphiron
			["Drenar vida"] = {t=24, c="cooldown", m="Sapphiron", aZone="Naxxramas", icontex="Spell_Shadow_LifeDrain02"};
	
				}
	
	
		-- Naxxramas
		NECB_PvE_Vars["HEIGAN_YELL1"]			= "Os veo...";
		NECB_PvE_Vars["HEIGAN_YELL2"]			= "Ahora eres mío.";
		NECB_PvE_Vars["HEIGAN_YELL3"]			= "Tú... eres el siguiente.";
		NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]	= "El final está sobre ti.";
	
		NECB_PvE_Vars["FAER_YELL1"]				= "¡Arrodillate ante mi, gusano!";
		NECB_PvE_Vars["FAER_YELL2"]				= "¡No puedes ocultarte de mi!";
		NECB_PvE_Vars["FAER_YELL3"]				= "¡Corre mientra puedas!";
		NECB_PvE_Vars["FAER_YELL4"]				= "¡Matalos en el nombre del maestro!"; 
	
		NECB_PvE_Vars["PATCHWERK_NAME"]			= "Patchwerk";
	
		NECB_PvE_Vars["GOTHIK_YELL"]			= "Tontamente has buscado tu muerte.";
	
		NECB_PvE_Vars["ANUB_YELL1"]				= "Solamente un pequeño bocado...";
		NECB_PvE_Vars["ANUB_YELL2"]				= "¡Sí, corre! ¡Esto hace la sangre bombee más rápido!";
		NECB_PvE_Vars["ANUB_YELL3"]				= "No hay salida.";

		-- Naxxramas
		CEnemyCastBar_Afflictions["Herida mortal"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
		CEnemyCastBar_Afflictions["Inyección mutante"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
		CEnemyCastBar_Afflictions["Trampa arácnida"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
		CEnemyCastBar_Afflictions["Veneno necrótico"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; -- Maexxna MT -healing Debuff(poison)
		CEnemyCastBar_Afflictions["Detonar maná"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	
	elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Ahn'Qiraj
		
			-- 40 Man
				["Erradicador de Obsidiana"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
				-- Twin Emperors
				["Teletransporte gemelo"] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
				["Explotar insecto"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
				["Mutar insecto"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};
	
				-- Ouro
				["Explosión de arena"] = {t=2.0, c="hostile", mcheck="Ouro", icontex="Spell_Nature_Cyclone"};
				["Barrido"] = {t=21, i=1.0, c="cooldown", mcheck="Ouro", icontex="Spell_Nature_Thorns"};
	
				["Invocar túmulos de Ouro"] = {t=0.1, delBar="Possible Ouro Submerge", icasted="true", pBar="Submerged"};
				["Sumergido"] = {t=30, c="cooldown", delBar="Ouro Submerges", aBar="Possible Ouro Submerge", icontex="INV_Qiraj_OuroHide"};
				["Possible Ouro Submerge"] = {t=90, c="cooldown", pBar="Ouro Submerges", icontex="Spell_Shadow_DemonBreath"};
				["Ouro Submerges"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"}; 
	
	
				-- C'Thun
				["First Dark Glare"] = {t=48, c="cooldown", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
				["Weakened!"] = {t=45, c="gainsfoe", delBar="Small Eyes P2", aBar="After Weakened Eyes", icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
				["Dark Glare"] = {t=86, i=40, c="cooldown", active="true", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
				["Small Eyes P1"] = {t=45, c="cooldown", aBar="Small Eyes P1", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["First Small Eyes P2"] = {t=42, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["Small Eyes P2"] = {t=30, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
				["After Weakened Eyes"] = {t=38, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	
				-- Skeram
				["Deflagración Arcana"] = {t=1.2, c="hostile", mcheck="The Prophet Skeram", icontex="Spell_Nature_WispSplode"};
	
				-- Sartura (Twin Emps enrage + Hakkar enrage)
				["Torbellino"] = {t=15.0, c="gainsfoe", mcheck="Battleguard Sartura", icontex="Ability_Whirlwind"};
				["Enraged mode"] = {t=900, r="Battleguard Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
				["Enters Enraged mode"] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
				-- Huhuran
				["Berserk mode"] = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
				["Enters Berserk mode"] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
				["Picadura de dracoleón"] = {t=25, c="cooldown", m="Huhuran", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};
	
				-- Yauj
				["Miedo"] = {t=20, c="cooldown", checkengage="true", m="Yauj", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
				["Gran sanación"] = {t=2.0, c="hostile", m="Yauj", mcheck="Princess Yauj", icontex="Spell_Holy_Heal"};
	
	
					}
	
		-- AQ40
		NECB_PvE_Vars["SARTURA_CALL"]			= "Serás juzgado por profanar";
		NECB_PvE_Vars["SARTURA_CRAZY"]			= "empieza a enfurecerse";
	
		NECB_PvE_Vars["HUHURAN_CRAZY"]			= "entra una rabia del berserker";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]		= "entra un frenesí";
	
		NECB_PvE_Vars["CTHUN_NAME1"]	 		= "Ojo de C'Thun";
		NECB_PvE_Vars["CTHUN_WEAKENED"]			= "¡está debilitado!";

		-- AQ40
		CEnemyCastBar_Afflictions["Consecución veraz"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
		CEnemyCastBar_Afflictions["Peste"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
		CEnemyCastBar_Afflictions["Enredar"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
	
			-- 20 Man
	
				["Explotar"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};
	
				-- Ossirian
				["Debilidad Arcana"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_01"};
				["Debilidad de Fuego"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_02"};
				["Debilidad natural"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_03"};
				["Debilidad a la Escarcha"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_04"};
				["Debilidad a las Sombras"] = {t=45, c="gainsfoe", mcheck="Ossirian the Unscarred", icontex="INV_Misc_QirajiCrystal_05"};
	
				-- Moam
				["Until Stoneform"] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
				["Energizado"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
					}
	
		-- Ruins of AQ
		NECB_PvE_Vars["MOAM_STARTING"]			= "siento tu miedo.";

		-- AQ20
		CEnemyCastBar_Afflictions["Paralizar"] = {t=10, global="true", aZone="Ruins of Ahn'Qiraj", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
		-- Moam removal
		CEnemyCastBar_Afflictions["Energizado"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;

		CEnemyCastBar_Raids = {
	
		-- Zul'Gurub
	
			-- Hakkar
			["Succión de sangre"] = {t=90.0, c="cooldown", mcheck="Hakkar", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
			["Enraged mode"] = {t=900, r="Battleguard Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
					}
	
		-- Zul'Gurub
		NECB_PvE_Vars["HAKKAR_YELL"]			= "EL HERALDO ORGULLOSO ANUNCIA EL FIN DE TU MUNDO";

		-- Zul'Gurub
		CEnemyCastBar_Afflictions["Ilusiones de Jin'do"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
		CEnemyCastBar_Afflictions["Provocar demencia"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
		CEnemyCastBar_Afflictions["Mirada amenazante"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Molten Core
	
			-- Shazzrah
			["Portal de Shazzrah"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
		
			-- Lucifron
			["Condena inminente"] = {t=20.0, c="cooldown", m="Lucifron", icontex="Spell_Shadow_NightOfTheDead"};
			["Maldición de Lucifron"] = {t=20.0, c="cooldown", m="Lucifron", icontex="Spell_Shadow_BlackPlague"};
		
			-- Magmadar
			["Pánico"] = {t=30.0, c="cooldown", m="Magmadar", icontex="Spell_Shadow_DeathScream"};
	
			-- Gehennas
			["Maldición de Gehennas"] = {t=30.0, c="cooldown", m="Gehennas", icontex="Spell_Shadow_GatherShadows"};
	
			-- Geddon
			["Inferno"] = {t=8.0, c="gainsfoe", mcheck="Baron Geddon", icontex="Spell_Fire_Incinerate"};
	
			-- Majordomo
			["Reflejo de magia"] = {t=30.0, i=10.0, c="cooldown", m="Majordomo", aZone="Molten Core", icontex="Spell_Frost_FrostShock"};
			["Escudo de daño"] = {t=30.0, i=10.0, c="cooldown", m="Majordomo", icontex="Spell_Nature_LightningShield"};
			
			-- Ragnaros
			["Submerge"] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
			["Knockback"] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
			["Sons of Flame"] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!

					}
	
		-- MC
		NECB_PvE_Vars["RAGNAROS_STARTING"]			= "AHORA PARA TI,";
		NECB_PvE_Vars["RAGNAROS_KICKER"]			= "PRUEBA LAS LLAMAS";
		NECB_PvE_Vars["RAGNAROS_SONS"]	 		= "¡ID ADELANTE, MIS CRIADOS!";

		-- MC
		CEnemyCastBar_Afflictions["Bomba viva"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
		-- Onyxia
			["Aliento de llamas"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
			["Aliento profundo"] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"};
			["Sacudida de alas"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
			["Rugido bramante"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
	
	
					}
	
		-- ONY
		NECB_PvE_Vars["ONY_DB"]				= "coge aire profundamente..."; 
	
	elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
				
		-- Blackwing Lair
	
			-- Razorgore
			["Mob Spawn (45sec)"] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
	
			-- Firemaw/Flamegor/Ebonroc
			["Sacudida de alas"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
			["First Wingbuffet"] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"}; -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
			["Llama de las Sombras"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"};
			
			-- Flamegor
			[CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
			
			-- Chromaggus
			["Quemadura de Escarcha"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
			["Lapso de tiempo"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
			["Encender carne"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
			["Ácido corrosivo"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
			["Incinerar"] = {t=60.0, i=2.0, c="cooldown", active="true", mcheck="Chromaggus", icontex="Spell_Fire_FlameShock"};
			["Killing Frenzy"] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
				-- Chromaggus, Flamegor, Magmadar etc.
			["Frenesí"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};
			
			-- Neferian/Onyxia
			["Rugido bramante"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
			
			-- Nefarian			
			["Nefarian calls"] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
			["Mob Spawn"] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
			["Landing"] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
					}
	
		-- BWL
		NECB_PvE_Vars["RAZORGORE_CALL"]				= "Los intrusos han hecho una abertura";
	
		NECB_PvE_Vars["FIREMAW_NAME"]				= "Faucefogo";
		NECB_PvE_Vars["EBONROC_NAME"]				= "Ebanorroca";
		NECB_PvE_Vars["FLAMEGOR_NAME"]				= "Flamagor";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "entra en frenesí";
		NECB_PvE_Vars["CHROMAGGUS_FRENZY"]			= "entra en frenesí asesino";
		
		NECB_PvE_Vars["NEFARIAN_STARTING"]			= "¡Vamos a empezar a jugar!";
		NECB_PvE_Vars["NEFARIAN_LAND"]				= "Bien hecho, mis esbirros";
		NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"]		= "Chamanes, miradme";
		NECB_PvE_Vars["NEFARIAN_DRUID_CALL"]		= "Druidas y sus idiotas";
		NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"]		= "Brujos, no debéis jugar";
		NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"]		= "¡Sacerdotes! Si vais a proteger";
		NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"]		= "Cazadores y sus molestias";
		NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"]		= "Guerreros, ¿es todo lo que podéis hacer?";
		NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"]		= "Pícaros";
		NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"]		= "Paladines";
		NECB_PvE_Vars["NEFARIAN_MAGE_CALL"]			= "Magos";

		-- BWL
		CEnemyCastBar_Afflictions["Conflagración"] = {t=10.0, global="true", aZone="Blackwing Lair", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning
		CEnemyCastBar_Afflictions["Adrenalina ardiente"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA
		CEnemyCastBar_Afflictions["Sombra de Ebanorroca"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff
		-- Non Boss DeBuffs:
		CEnemyCastBar_Afflictions["Polimorfia superior"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	else
		CEnemyCastBar_Raids = { };
		NECB_PvE_Vars = { };

	end
		
			-- Other
	
		for k, v in pairs (CEnemyCastBar_Raids) do
			CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
			break;
		end

		--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

		if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
			CECB_ReloadOptionsUI(); -- update tooltip
		end

  end

end