--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!

if ( GetLocale() == "deDE" ) then

		-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
		-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
		-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
		-- "active" only allows this spell to be an active cast, no afflictions and something else!
		-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
		-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
		-- "icasted" guides this spell through the instant cast protection
		-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
		-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
		-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
		-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
		-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
		-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
		--  tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas = "Naxxramas";
	NECB_AhnQiraj = "Ahn'Qiraj";
	NECB_AhnQirajRuins = "Ruinen von Ahn'Qiraj";
	NECB_ZulGurub = "Zul'Gurub";
	NECB_MoltenCore = "Geschmolzener Kern";
	NECB_OnyxiaLair = "Onyxias Hort";
	NECB_BlackwingLair = "Pechschwingenhort";
	NECB_Stratholme = "Stratholme";
	--BC
	NECB_ShatteredHalls = "Die zerschmetterten Hallen";
	NECB_Magtheridon = "Magtheridons Kammer";
	NECB_GruulsLair = "Gruuls Unterschlupf";
	NECB_Karazhan = "Karazhan";
	NECB_SerpentshrineCavern = "H\195\182hle des Schlangenschreins";
	NECB_Tempest_Keep = "Festung der St\195\188rme";
	NECB_Black_Temple = "Der Schwarze Tempel";
	NECB_ZulAman = "Zul'Aman";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
		NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
		if not forcereg then
			return;
		end
		break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Magtheridon
	
			-- Respawn timer
			["TrashRespawn"] = {t=7200, c="cooldown", global="true", m="Magtheridon", icontex="Spell_Holy_Resurrection"};
				["H\195\182llenfeuerw\195\164rter"] = {t=0, pBar="TrashRespawn"};
					["Magtheridon"] = {t=0, delBar="TrashRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Sturmkrieger der Amani'shi"] = {t=0, pBar="Akil'zon Trash"};
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};

		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Black Temple Respawn timer

			["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Aqueouslord"] = {t=0, pBar="Naj'entus Trash"};
				["General der Echsennarbe"] = {t=0, pBar="Naj'entus Trash"};
				["Harpunenk\195\164mpfer der Echsennarbe"] = {t=0, pBar="Naj'entus Trash"};
				["Leviathan"] = {t=0, pBar="Naj'entus Trash"};
				-- + Coilskar Soothsayer, Coilskar Wrangler
					["Oberster Kriegsf\195\188rst Naj'entus"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"};

			["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Primalist der Aschenzungen"] = {t=0, pBar="Akama Trash"};
				["Mystiker der Aschenzungen"] = {t=0, pBar="Akama Trash"};
				["Kampflord der Aschenzungen"] = {t=0, pBar="Akama Trash"};
					["Akamas Schemen"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"};

			["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Held des Schattenmondklans"] = {t=0, pBar="Gorefiend Trash"};
				["H\195\164scher des Schattenmondklans"] = {t=0, pBar="Gorefiend Trash"};
					["Teron Blutschatten"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"};

			["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Bonechewer Worker"] = {t=0, pBar="Supremus Trash"};
				["Sklaventreiber der Knochenmalmer"] = {t=0, pBar="Supremus Trash"};
					["Supremus"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"};

			["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Schildj\195\188nger der Knochenmalmer"] = {t=0, pBar="Gurtogg Trash"};
				["Klingenw\195\188ter der Knochenmalmer"] = {t=0, pBar="Gurtogg Trash"};
				["Mutierter Kriegshund"] = {t=0, pBar="Gurtogg Trash"};
					["Gurtogg Siedeblut"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"};

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Tempelkonkubine"] = {t=0, pBar="Mother Shahraz Trash"};
				["Bezaubernde Kurtisane"] = {t=0, pBar="Mother Shahraz Trash"};
				["Verzauberter Aufseher"] = {t=0, pBar="Mother Shahraz Trash"};
				["Schwester der Schmerzen"] = {t=0, pBar="Mother Shahraz Trash"};
				["Schwester der Freuden"] = {t=0, pBar="Mother Shahraz Trash"};
					["Mutter Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Schildwache der Promenade"] = {t=0, pBar="Illidari Council Trash"};
					["Gathios der Zerschmetterer"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	
		}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Tempest Keep
	
			-- Respawn timer
			["Al'ar Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Sternenseher"] = {t=0, pBar="Al'ar Trash"};
				["Astronom"] = {t=0, pBar="Al'ar Trash"};
				["Verteidiger der Blutw\195\164rter"] = {t=0, pBar="Al'ar Trash"};
			-- conflict ["Legion\195\164r der Blutw\195\164rter"] = {t=0, pBar="Al'ar Trash"};
					["Al'ar"] = {t=0, tchange={"Al'ar Trash", "perm", 0}, delBar="Al'ar Trash"};

			["Leerh\195\164scher Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Kristallkernverw\195\188ster"] = {t=0, pBar="Leerh\195\164scher Trash"};
				--["Kristallkernschildwache"] = {t=0, pBar="Leerh\195\164scher Trash"};
					["Leerh\195\164scher"] = {t=0, tchange={"Leerh\195\164scher Trash", "perm", 0}, delBar="Leerh\195\164scher Trash"};

			["Hochastronom Solarian Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Astronomlord"] = {t=0, pBar="Hochastronom Solarian Trash"};
			-- conflict ["Legion\195\164r der Blutw\195\164rter"] = {t=0, pBar="Hochastronom Solarian Trash"};
				["Astronomnovize"] = {t=0, pBar="Hochastronom Solarian Trash"};
					["Hochastronom Solarian"] = {t=0, tchange={"Hochastronom Solarian Trash", "perm", 0}, delBar="Hochastronom Solarian Trash"};

			["Kael'thas Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Kampfmagier der Purpurhand"] = {t=0, pBar="Kael'thas Trash"};
				["Blutritter der Purpurhand"] = {t=0, pBar="Kael'thas Trash"};
				["Zenturio der Purpurhand"] = {t=0, pBar="Kael'thas Trash"};
				["Inquisitor der Purpurhand"] = {t=0, pBar="Kael'thas Trash"};
					["Kael'thas Sonnenwanderer"] = {t=0, tchange={"Kael'thas Trash", "perm", 0}, delBar="Kael'thas Trash"};

		}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	    
	        CEnemyCastBar_Raids = {
	        
	        -- Serpentshrine Cavern
	        
		        -- Respawn timer
			["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Bestienb\195\164ndiger des Echsenkessels"] = {t=0, pBar="HydrossTrash"};
				["Hasssch\195\188rer des Echsenkessels"] = {t=0, pBar="HydrossTrash"};
				["Sporensegler des Echsenkessels"] = {t=0, pBar="HydrossTrash"};
					["Hydross der Unstete"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

			["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Ehrenwache der Vashj'ir"] = {t=0, pBar="LurkerTrash"};
				["Priesterin des Echsenkessels"] = {t=0, pBar="LurkerTrash"};
					["Das Grauen aus der Tiefe"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

			["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Nethermagier der Grauherzen"] = {t=0, pBar="MixedTrash"};
				["Gezeitenrufer der Grauherzen"] = {t=0, pBar="MixedTrash"};
				["Schleicher der Grauherzen"] = {t=0, pBar="MixedTrash"};

			["TidewalkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Schamane der Gezeitenwandler"] = {t=0, pBar="TidewalkerTrash"};
				["Tiefenseher der Gezeitenwandler"] = {t=0, pBar="TidewalkerTrash"};
				["Krieger der Gezeitenwandler"] = {t=0, pBar="TidewalkerTrash"};
					["Morogrim Gezeitenwandler"] = {t=0, tchange={"TidewalkerTrash", "perm", 0}, delBar="TidewalkerTrash"};

			["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Schildtr\195\164ger der Grauherzen"] = {t=0, pBar="LeotherasTrash"};
					["Leotheras der Blinde"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"};

	        }

	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
	
		CEnemyCastBar_Raids = {
	
		-- Gruuls
	
			-- Krosh Firehand
			["Zauberschild"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"};

			-- Respawn timer
			["OgerRespawn"] = {t=3600, c="cooldown", global="true", m="Gruul", icontex="Spell_Holy_Resurrection"};
				["Schl\195\164ger des Unterschlupfs"] = {t=0, pBar="OgerRespawn"};
				["Gronnpriester"] = {t=0, pBar="OgerRespawn"};
					["Hochk\195\182nig Maulgar"] = {t=0, delBar="OgerRespawn"};
					["Gruul der Drachenschl\195\164chter"] = {t=0, delBar="OgerRespawn"};
		}

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["Kargaths Henker"] = {t=4800, c="cooldown", global="true", m="Heroic Quest", icontex="Spell_Holy_Resurrection"};
			["Kriegsh\195\164uptling Kargath Messerfaust"] = {t=0, delBar="Kargaths Henker"};
		}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;

		CEnemyCastBar_Raids = {

			-- Respawn timer
			["StallRespawn"] = {t=1500, c="cooldown", global="true", m="Attumen", icontex="Spell_Holy_Resurrection"};
				["Spektraler Hengst"] = {t=0, pBar="StallRespawn"};
				["Spektrales Streitross"] = {t=0, pBar="StallRespawn"};
					["Attumen der J\195\164ger"] = {t=0, tchange={"StallRespawn", "perm", 0}, delBar="StallRespawn"};
 
			["BallsaalRespawn"] = {t=3600, c="cooldown", global="true", m="Moroes", icontex="Spell_Holy_Resurrection"};
				["Phantomgast"] = {t=0, pBar="BallsaalRespawn"};
					["Moroes"] = {t=0, tchange={"BallsaalRespawn", "perm", 0}, delBar="BallsaalRespawn"};

			["G\195\164stezimmerRespawn"] = {t=3600, c="cooldown", global="true", m="Maid", icontex="Spell_Holy_Resurrection"};
				["Phantomgardist"] = {t=0, pBar="G\195\164stezimmerRespawn"};
				["Spektraler Wachposten"] = {t=0, pBar="G\195\164stezimmerRespawn"};
					["Tugendhafte Maid"] = {t=0, tchange={"G\195\164stezimmerRespawn", "perm", 0}, delBar="G\195\164stezimmerRespawn"};

			["TheaterRespawn"] = {t=3600, c="cooldown", global="true", m="Oper", icontex="Spell_Holy_Resurrection"};
				["Skelettpf\195\182rtner"] = {t=0, pBar="TheaterRespawn"};
					["Die b\195\182se Hexe"] = {t=0, tchange={"TheaterRespawn", "perm", 0}, delBar="TheaterRespawn"};
					["Der gro\195\159e b\195\182se Wolf"] = {t=0, tchange={"TheaterRespawn", "perm", 0}, delBar="TheaterRespawn"};
					["Geisterhafter Philanthrop"] = {t=0, tchange={"TheaterRespawn", "perm", 0}, delBar="TheaterRespawn"};

			["MenagerieRespawn"] = {t=3600, c="cooldown", global="true", m="Kurator", icontex="Spell_Holy_Resurrection"};
				["Arkanwachmann"] = {t=0, pBar="MenagerieRespawn"};
					["Der Kurator"] = {t=0, tchange={"MenagerieRespawn", "perm", 0}, delBar="MenagerieRespawn"};

			["LibraryRespawn1"] = {t=7200, c="cooldown", global="true", m="Aran", icontex="Spell_Holy_Resurrection"};
				["Arkanbesch\195\188tzer"] = {t=0, tchange={"MenagerieRespawn", "perm", 0}, pBar="LibraryRespawn1", delBar="MenagerieRespawn"};
					["Arans Schemen"] = {t=0, tchange={"LibraryRespawn1", "perm", 0}, delBar="LibraryRespawn1"};

			["LibraryRespawn2"] = {t=7200, c="cooldown", global="true", m="Siechhuf", icontex="Spell_Holy_Resurrection"};
				["Homonculus"] = {t=0, pBar="LibraryRespawn2"};
				["Schattenpl\195\188nderer"] = {t=0, pBar="LibraryRespawn2"};
					["Terestian Siechhuf"] = {t=0, tchange={"LibraryRespawn2", "perm", 0}, delBar="LibraryRespawn2"};

			["LibraryRespawn3"] = {t=7200, c="cooldown", global="true", m="Nethergroll", icontex="Spell_Holy_Resurrection"};
				["Magieschemen"] = {t=0, pBar="LibraryRespawn3"};
					["Nethergroll"] = {t=0, tchange={"LibraryRespawn3", "perm", 0}, delBar="LibraryRespawn3"};

			["TheTopRespawn"] = {t=7200, c="cooldown", global="true", m="Malchezaar", icontex="Spell_Holy_Resurrection"};
				["Fleischbestie"] = {t=0, pBar="TheTopRespawn"};
				["Gro\195\159e Fleischbestie"] = {t=0, pBar="TheTopRespawn"};
					["Prinz Malchezaar"] = {t=0, tchange={"TheTopRespawn", "perm", 0}, delBar="TheTopRespawn"};

		}
	
		CEnemyCastBar_Afflictions["Morsche Knochen"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0
		CEnemyCastBar_Afflictions["Flammenkranz"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
		CEnemyCastBar_Afflictions["\195\156berladung"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

		NECB_PvE_Debuffs = true; -- force register events

		CEnemyCastBar_Raids = {
			["Das Ultimatum des Barons"] = {t=2700, c="cooldown", global="true", m="Baron Run", icontex="Spell_Holy_Resurrection"};
			["Baron Totenschwur"] = {t=0, delBar="Das Ultimatum des Barons"};
		}

	elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
		
			-- Naxxramas
		
				["Nekropirscher"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	
				-- Anub'Rekhan
				["First Locust Swarm"] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
				["Heuschreckenschwarm"] = {t=23, i=3, c="gainsfoe", delBar="Heuschreckenschwarm CD", aBar="Heuschreckenschwarm CD", active="true", icontex="Spell_Nature_InsectSwarm"};
				["Heuschreckenschwarm CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
		
				-- Patchwerk
				["Enraged Mode"] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
		
				-- Razuvious
				["Unterbrechungsruf"] = {t=25, c="cooldown", active="true", delBar="Unterbrechungsruf m\195\182glich", aBar="Unterbrechungsruf m\195\182glich", icontex="Ability_Creature_Disease_02"};
				["Unterbrechungsruf m\195\182glich"] = {t=25, c="cooldown", aBar="Unterbrechungsruf m\195\182glich", icontex="Ability_Creature_Disease_02"};
		
				-- Gluth
				["Erschreckendes Gebr\195\188ll"] = {t=20.0, c="cooldown", m="Gluth", aZone="Naxxramas", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
				["Dezimieren"] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};
		
				-- Maexxna
				["Gespinstschauer"] = {t=40, c="cooldown", pBar="Mini Spinnen", m="Maexxna", aZone="Naxxramas", icontex="Ability_Ensnare"};
				["Mini Spinnen"] = {t=30, c="cooldown", pBar="Fangnetz CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
				["Fangnetz CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};
		
				-- Thaddius
				["Polarit\195\164tsver\195\164nderung"] = {t=30, i=3, c="cooldown", pBar="Becomes enraged!", mcheck="Thaddius", icontex="Spell_Nature_Lightning"};
				["Energieschub"] = {t=10, c="gainsfoe", mcheck="Stalagg", icontex="Spell_Shadow_SpectralSight"};
				["Becomes enraged!"] = {t=290, c="cooldown", global="true", tchange={"Becomes enraged!", 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated
		
				-- Faerlina
				["Wutanfall"] = {t=60, c="cooldown", mcheck="Gro\195\159witwe Faerlina", icontex="Spell_Shadow_UnholyFrenzy"};
				["Umarmung der Witwe"] = {t=30, c="cooldown", mcheck="Gro\195\159witwe Faerlina", icontex="Spell_Arcane_Blink"}; -- Fearlina
		
				-- Loatheb
				["15 sec Doom CD!"] = {t=299, tchange={"Unausweichliches Schicksal", 30, 15}, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally! TRANSLATE 'tchange' ONLY!
				["First Inevitable Doom"] = {t=120, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
				["Unausweichliches Schicksal"] = {t=30, c="cooldown", m="Loatheb", icontex="Spell_Shadow_NightOfTheDead"}; 
		
				["Spore beschw\195\182ren"] = {t=12.5, icasted="true", c="cooldown", mcheck="Loatheb", icontex="Spell_Nature_AbolishMagic"};
				["Fluch aufheben auf Loatheb"] = {t=0.1, icasted="true", c="cooldown", pBar="Fl\195\188che entfernt", mcheck="Loatheb", icontex="Spell_Nature_RemoveCurse"};
				["Fl\195\188che entfernt"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"};
		
		
				-- Gothik
				-- don't translate, ALL used internally!
				["Comes Down"] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
				["del1"] = {t=0.1, pBar="del2", delBar="Trainees INC"};
				["del2"] = {t=0.1, pBar="del3", delBar="Deathknights INC"};
				["del3"] = {t=0.1, delBar="Rider INC"};
				
				["First Trainees"] = {t=27, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
				["First Deathknights"] = {t=77, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
				["First Rider"] = {t=137, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"};
				["Trainees INC"] = {t=20, c="cooldown", aBar="Trainees INC", icontex="INV_Misc_Head_Undead_01"};
				["Deathknights INC"] = {t=25, c="cooldown", aBar="Deathknights INC", icontex="Spell_Shadow_ShadowWard"};
				["Rider INC"] = {t=30, c="cooldown", aBar="Rider INC", icontex="Ability_Mount_Undeadhorse"};
		
				-- Noth
				["Blinzeln"] = {t=30, c="cooldown", mcheck="Noth der Seuchenf\195\188rst", aZone="Naxxramas", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
				["First Teleport"] = {t=90, c="cooldown", aBar="On Balcony 1", aZone="Naxxramas", icontex="Spell_Nature_AstralRecalGroup"};
				["On Balcony 1"] = {t=70, c="cooldown", aBar="Second Teleport", icontex="Spell_Nature_AstralRecalGroup"};
				["Second Teleport"] = {t=110, c="cooldown", aBar="On Balcony 2", icontex="Spell_Nature_AstralRecalGroup"};
				["On Balcony 2"] = {t=95, c="cooldown", aBar="Third Teleport", icontex="Spell_Nature_AstralRecalGroup"};
				["Third Teleport"] = {t=180, c="cooldown", aBar="On Balcony 3", icontex="Spell_Nature_AstralRecalGroup"};
				["On Balcony 3"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};
		
				-- Heigan
				["On Platform"] = {t=45, c="cooldown", aBar="Teleport CD", icontex="INV_Enchant_EssenceAstralLarge"};
				["Teleport CD"] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};
		
				-- Sapphiron
				["Lebenssauger"] = {t=24, c="cooldown", m="Saphiron", aZone="Naxxramas", icontex="Spell_Shadow_LifeDrain02"};
	
				}
	
	
		-- Naxxramas
		NECB_PvE_Vars["HEIGAN_YELL1"]			= "Ihr entgeht mir nicht...";
		NECB_PvE_Vars["HEIGAN_YELL2"]			= "Ihr geh\195\182rt mir...";
		NECB_PvE_Vars["HEIGAN_YELL3"]			= "Ihr seid.... als n\195\164chstes dran.";
		NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]		= "Euer Ende naht.";
	
		NECB_PvE_Vars["FAER_YELL1"]			= "Kniet nieder, Wurm!";
		NECB_PvE_Vars["FAER_YELL2"]			= "Ihr k\195\182nnt euch nicht vor mir verstecken!";
		NECB_PvE_Vars["FAER_YELL3"]			= "Flieht, solange ihr noch k\195\182nnt";
		NECB_PvE_Vars["FAER_YELL4"]			= "T\195\182tet sie im Namen des Meisters!";
	
		NECB_PvE_Vars["PATCHWERK_NAME"]			= "Flickwerk";
	
		NECB_PvE_Vars["GOTHIK_YELL"]			= "Ihr Narren habt euren eigenen Untergang heraufbeschworen.";
	
		NECB_PvE_Vars["ANUB_YELL1"]			= "Nur einmal kosten...";
		NECB_PvE_Vars["ANUB_YELL2"]			= "Rennt! Das bringt das Blut in Wallung!";
		NECB_PvE_Vars["ANUB_YELL3"]			= "Es gibt kein Entkommen.";

		-- Naxxramas
		CEnemyCastBar_Afflictions["T\195\182dliche Wunde"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
		CEnemyCastBar_Afflictions["Mutagene Injektion"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
		CEnemyCastBar_Afflictions["Fangnetz"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
		CEnemyCastBar_Afflictions["Nekrotisches Gift"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; -- Maexxna MT -healing Debuff(poison)
		CEnemyCastBar_Afflictions["Detonierendes Mana"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
			-- Ahn'Qiraj
		
				-- 40 Man
					["Obsidianvernichter"] = {t=1800.0, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
		
					-- Twin Emperors
					["Zwillingsteleport"] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
					["K\195\164fer explodieren lassen"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
					["K\195\164fer mutieren"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};
		
					-- Ouro
					["Sandsto\195\159"] = {t=2.0, c="hostile", mcheck="Ouro", icontex="Spell_Nature_Cyclone"};
					["Feger"] = {t=21, i=1.0, c="cooldown", mcheck="Ouro", icontex="Spell_Nature_Thorns"};
		
					["Ouroh\195\188gel beschw\195\182ren"] = {t=0.1, delBar="Possible Ouro Submerge", icasted="true", pBar="Submerged"};
					["Submerged"] = {t=30, c="cooldown", delBar="Ouro Submerges", aBar="Possible Ouro Submerge", icontex="INV_Qiraj_OuroHide"};
					["Possible Ouro Submerge"] = {t=90, c="cooldown", pBar="Ouro Submerges", icontex="Spell_Shadow_DemonBreath"};
					["Ouro Submerges"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"}; 
		
					-- C'Thun
					["First Dark Glare"] = {t=48, c="cooldown", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
					["Weakened!"] = {t=45, c="gainsfoe", delBar="Small Eyes P2", aBar="After Weakened Eyes", icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
					["Dark Glare"] = {t=86, i=40, c="cooldown", active="true", aBar="Dark Glare", icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
					["Small Eyes P1"] = {t=45, c="cooldown", aBar="Small Eyes P1", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
					["First Small Eyes P2"] = {t=42, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
					["Small Eyes P2"] = {t=30, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
					["After Weakened Eyes"] = {t=38, c="cooldown", aBar="Small Eyes P2", icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
		
					-- Skeram
					["Arkane Explosion"] = {t=1.2, c="hostile", mcheck="Der Prophet Skeram", icontex="Spell_Nature_WispSplode"};
		
					-- Sartura (Twin Emps enrage + Hakkar enrage)
					["Wirbelwind"] = {t=15.0, c="gainsfoe", mcheck="Schlachtwache Sartura", icontex="Ability_Whirlwind"};
					["Enraged mode"] = {t=900, r="Schlachtwache Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
					["Enters Enraged mode"] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
		
					-- Huhuran
					["Berserk mode"] = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
					["Enters Berserk mode"] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
					["Stich des Fl\195\188geldrachen"] = {t=25, c="cooldown", m="Huhuran", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};
		
					-- Yauj
					["Furcht"] = {t=20, c="cooldown", checkengage="true", m="Yauj", aZone="Ahn'Qiraj", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
					["Gro\195\159es Heilen"] = {t=2.0, c="hostile", m="Yauj", mcheck="Prinzessin Yauj", icontex="Spell_Holy_Heal"};
	
	
					}
	
		-- AQ40
		NECB_PvE_Vars["SARTURA_CALL"]			= "Ihr habt heiligen Boden entweiht";
		NECB_PvE_Vars["SARTURA_CRAZY"]			= "wird w\195\188tend";
	
		NECB_PvE_Vars["HUHURAN_CRAZY"]			= "verf\195\164llt in Berserkerwut";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "ger\195\164t in Raserei";
	
		NECB_PvE_Vars["CTHUN_NAME1"]	 		= "Auge von C'Thun";
		NECB_PvE_Vars["CTHUN_WEAKENED"]			= "ist geschw\195\164cht!";

		-- AQ40
		CEnemyCastBar_Afflictions["Wahre Erf\195\188llung"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
		CEnemyCastBar_Afflictions["Seuche"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
		CEnemyCastBar_Afflictions["Umschlingen"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
	
				-- 20 Man
		
					["Explodieren"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};
		
					-- Ossirian
					["Arkanschw\195\164che"] = {t=45, c="gainsfoe", mcheck="Ossirian der Narbenlose", icontex="INV_Misc_QirajiCrystal_01"};
					["Feuerschw\195\164che"] = {t=45, c="gainsfoe", mcheck="Ossirian der Narbenlose", icontex="INV_Misc_QirajiCrystal_02"};
					["Naturschw\195\164che"] = {t=45, c="gainsfoe", mcheck="Ossirian der Narbenlose", icontex="INV_Misc_QirajiCrystal_03"};
					["Frostschw\195\164che"] = {t=45, c="gainsfoe", mcheck="Ossirian der Narbenlose", icontex="INV_Misc_QirajiCrystal_04"};
					["Schattenschw\195\164che"] = {t=45, c="gainsfoe", mcheck="Ossirian der Narbenlose", icontex="INV_Misc_QirajiCrystal_05"};
			
					-- Moam
					["Until Stoneform"] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
					["Energiezufuhr"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
					}
	
		-- Ruins of AQ
		NECB_PvE_Vars["MOAM_STARTING"]			= "sp\195\188rt Eure Angst.";

		-- AQ20
		CEnemyCastBar_Afflictions["Paralisieren"] = {t=10, global="true", aZone="Ruinen von Ahn'Qiraj", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
		-- Moam removal
		CEnemyCastBar_Afflictions["Energiezufuhr"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
			-- ZulGurub
		
				-- Hakkar
				["Bluttrinker"] = {t=90.0, c="cooldown", mcheck="Hakkar", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
				["Enraged mode"] = {t=900, r="Schlachtwache Sartura Hakkar", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
					}
	
		-- Zul'Gurub
		NECB_PvE_Vars["HAKKAR_YELL"]			= "EURE \195\156BERHEBLICHKEIT K\195\156NDET BEREITS VOM ENDE DIESER WELT";

		-- Zul'Gurub
		CEnemyCastBar_Afflictions["Irrbilder von Jin'do"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
		CEnemyCastBar_Afflictions["Wahnsinn verursachen"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
		CEnemyCastBar_Afflictions["Bedrohlicher Blick"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
			-- Molten Core
			
				-- Shazzrah
				["Portal von Shazzrah"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
		
				-- Lucifron
				["Drohende Verdammnis"] = {t=20.0, c="cooldown", m="Lucifron", icontex="Spell_Shadow_NightOfTheDead"};
				["Lucifrons Fluch"] = {t=20.0, c="cooldown", m="Lucifron", icontex="Spell_Shadow_BlackPlague"};
			
				-- Magmadar
				["Panik"] = {t=30.0, c="cooldown", m="Magmadar", icontex="Spell_Shadow_DeathScream"};
		
				-- Gehennas
				["Gehennas Fluch"] = {t=30.0, c="cooldown", m="Gehennas", icontex="Spell_Shadow_GatherShadows"};
		
				-- Geddon
				["Inferno"] = {t=8.0, c="gainsfoe", mcheck="Baron Geddon", icontex="Spell_Fire_Incinerate"};
		
				-- Majordomo
				["Magiereflexion"] = {t=30.0, i=10.0, c="cooldown", m="Majordomo", aZone="Geschmolzener Kern", icontex="Spell_Frost_FrostShock"};
				["Schadenschild"] = {t=30.0, i=10.0, c="cooldown", m="Majordomo", icontex="Spell_Nature_LightningShield"};
				
				-- Ragnaros
				["Submerge"] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
				["Knockback"] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
				["Sons of Flame"] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!
	
					}
	
		-- MC
		NECB_PvE_Vars["RAGNAROS_STARTING"]			= "NUN ZU EUCH, INSEKTEN";
		NECB_PvE_Vars["RAGNAROS_KICKER"]			= "SP\195\156RT DIE FLAMMEN";
		NECB_PvE_Vars["RAGNAROS_SONS"]	 		= "KOMMT HERBEI, MEINE DIENER";

		-- MC
		CEnemyCastBar_Afflictions["Lebende Bombe"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
			-- Onyxia
				["Flammenatem"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
				["Deep Breath"] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"};
				["Fl\195\188gelsto\195\159"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
				["Dr\195\182hnendes Gebr\195\188ll"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
	
	
					}
	
		-- ONY
		NECB_PvE_Vars["ONY_DB"]				= "atmet tief ein..."; 
	
	elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

		NECB_PvE_Gains = true; -- force register events
		NECB_PvE_Debuffs = true; -- force register events
		NECB_PvE_Casts = true; -- force register events
		NECB_PvE_Debuffed_Players_timer_only = true;
		NECB_PvE_YellEmoteCombat = true;
	
		CEnemyCastBar_Raids = {
	
	
				
			-- Blackwing Lair
		
				-- Razorgore
				["Mob Spawn (45sec)"] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
		
				-- Firemaw/Flamegor/Ebonroc
				["Fl\195\188gelsto\195\159"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
				["First Wingbuffet"] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"}; -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
				["Schattenflamme"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"};
				
				-- Flamegor
				[CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
				
				-- Chromaggus
				["Frostbeulen"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
				["Zeitraffer"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
				["Fleisch entz\195\188nden"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
				["\195\132tzende S\195\164ure"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
				["Verbrennen"] = {t=60.0, i=2.0, c="cooldown", active="true", mcheck="Chromaggus", icontex="Spell_Fire_FlameShock"};
				["Killing Frenzy"] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
					-- Chromaggus, Flamegor, Magmadar etc.
				["Raserei"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};
		
				-- Neferian/Onyxia
				["Dr\195\182hnendes Gebr\195\188ll"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
				
				-- Nefarian
				["Nefarian calls"] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
				["Mob Spawn"] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
				["Landing"] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
					}
	
		-- BWL	
		NECB_PvE_Vars["RAZORGORE_CALL"]			= "Eindringlinge sind in die";
	
		NECB_PvE_Vars["FIREMAW_NAME"]			= "Feuerschwinge";
		NECB_PvE_Vars["EBONROC_NAME"]			= "Schattenschwinge";
		NECB_PvE_Vars["FLAMEGOR_NAME"]			= "Flammenmaul";
		NECB_PvE_Vars["FLAMEGOR_FRENZY"]			= "ger\195\164t in Raserei";
		NECB_PvE_Vars["CHROMAGGUS_FRENZY"]			= "ger\195\164t in t\195\182dliche Raserei";
		
		NECB_PvE_Vars["NEFARIAN_STARTING"]			= "Lasst die Spiele beginnen!";
		NECB_PvE_Vars["NEFARIAN_LAND"]			= "Sehr gut, meine Diener";
		NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"]		= "Schamanen";
		NECB_PvE_Vars["NEFARIAN_DRUID_CALL"]		= "Druiden und ihre l\195\164cherliche";
		NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"]		= "Hexenmeister, Ihr solltet nicht";
		NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"]		= "Priester! Wenn Ihr weiterhin";
		NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"]		= "J\195\164ger und ihre l\195\164stigen";
		NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"]		= "Krieger, Ich bin mir";
		NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"]		= "Schurken";
		NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"]		= "Paladine";
		NECB_PvE_Vars["NEFARIAN_MAGE_CALL"]		= "Auch Magier";


		CEnemyCastBar_Afflictions["Gro\195\159brand"] = {t=10.0, global="true", aZone="Pechschwingenhort", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning!
		CEnemyCastBar_Afflictions["Brennendes Adrenalin"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA!
		CEnemyCastBar_Afflictions["Schattenschwinges Schatten"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff

		-- Non Boss DeBuffs (BWL):
		CEnemyCastBar_Afflictions["Gro\195\159e Verwandlung"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
		NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	else
		CEnemyCastBar_Raids = { };
		NECB_PvE_Vars = { };
		
	end
		
			-- Other
	
		for k, v in pairs (CEnemyCastBar_Raids) do
			CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
			break;
		end

		--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

		if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
			CECB_ReloadOptionsUI(); -- update tooltip
		end

  end

end