﻿-- NECB PvEModule Chinese Simplified localization file
-- Maintained by: iCeSun - 五区 元素之力 [MYTH]神話公会 张宝仔
-- Last updated: 2007年10月15日

--NECB PvE localized cast/cooldown Database; Afflictions are still stored in MAIN programme!

if ( GetLocale() == "zhCN" ) then

	-- c="cooldown" (hostile, friendly, gainsfoe, gainsfriend, cooldown, grey, afflicted, stuns, dots)
	-- "mcheck" to only show a bar if cast from this mob. Shows a spell if the mobname is a part of 'mcheck'. mcheck="Ragnaros - Princess Yauj" possible!
	-- "m" sets a mob's name for the castbar; "i" shows a second bar; "r" sets a different CastTime for this Mob (r = "Mob1 Mob2 Mob3" possible *g*)
	-- "active" only allows this spell to be an active cast, no afflictions and something else!
	-- "global" normally is used for afflictions to be shown even it's not your target, but here the important feature is that the castbar won't be updated if active!
	-- "checktarget" checks if the mob casted this spell is your current target. Normally this isn't done with RaidSpells.
	-- "icasted" guides this spell through the instant cast protection
	-- checkevent="Event1 - Event2" to bind spells to only trigger a castbar if these events were fired. (Example: checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" )
	-- checkengage="true" will only trigger a castbar if the engage protection is running! (Used for Yauj fear for example to prevent CBs at other Mobs that fear players within AQ!)
	-- aBar="NextSpellName" will trigger the defined spell instantly when the source CastBar runs out (e.g. 'Dark Glare'). Will only do that if the User is in combat or dead! Won't broadcast the next triggered spell to the raid!
	-- pBar="NextSpellName" will trigger the defined spell instantly when the source CastBar APPEARS! (e.g. 'Web Spray'). Won't broadcast the next triggered spell to the raid!
	-- delBar="SpellName" will delete the defined spell instantly when the source CastBar runs out! (e.g. 'Locust Swarm').
	-- tchange={"SpellName", normal duration, changed duration} will change the duration of defined Spell when the CastBar runs out (e.g. tchange={"Inevitable Doom", 30, 15} for '15 sec Doom CD!' Bar). Duration1 is applied (reset) if the EngageProtection is disabled and the player enters combat the next time! Enables the EngageProtection!
	--	tchange -> if 'normal duration' is set = "perm", then this change will last until player logs out or reloads UI

	-- define instance names:
	NECB_Naxxramas = "纳克萨玛斯";
	NECB_AhnQiraj = "安其拉";
	NECB_AhnQirajRuins = "安其拉废墟";
	NECB_ZulGurub = "祖尔格拉布";
	NECB_MoltenCore = "熔火之心";
	NECB_OnyxiaLair = "奥妮克希亚的巢穴";
	NECB_BlackwingLair = "黑翼之巢";
	NECB_Stratholme = "斯坦索姆";
	--BC
	NECB_ShatteredHalls = "破碎大厅";
	NECB_Magtheridon = "玛瑟里顿的巢穴";
	NECB_GruulsLair = "格鲁尔的巢穴";
	NECB_Karazhan = "卡拉赞";
	NECB_SerpentshrineCavern = "毒蛇神殿";
	NECB_Tempest_Keep = "风暴要塞";
	NECB_Black_Temple = "黑暗神殿";
	NECB_ZulAman = "祖阿曼";


  function NECB_PvE_DBInit(noreg, forcereg)

	if (not NECB_PvE_Vars) then
	NECB_PvE_Vars = { }; -- raids{} will init with NECB anyway
	end

	for k, v in pairs (CEnemyCastBar_Raids) do
	if not forcereg then
	return;
	end
	break;
	end

	-- do not force to register any events:
	NECB_PvE_Gains = false; -- set true for inis if gains are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Casts = false; -- set true for inis if spell casts are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffs = false; -- set true for inis if debuffs are NEEDED to trigger bars (cooldowns etc.)
	NECB_PvE_Debuffed_Players_timer_only = false; -- set true (negates NECB_PvE_Debuffs!) for inis if only timers of players - CEnemyCastBar_Afflictions["Debuff"] - are set for this ini and no debuffs call other PvE timers
	NECB_PvE_YellEmoteCombat = false; -- set true for inis if engage protection needed or boss yells/ emotes are parsed


	--Outland
	if (GetRealZoneText() == NECB_Magtheridon and not noreg) then
	
	CEnemyCastBar_Raids = {
	
	-- Magtheridon
	
	-- Respawn timer
	["玛瑟里顿小怪刷新"] = {t=7200, c="cooldown", global="true", m="玛瑟里顿", icontex="Spell_Holy_Resurrection"};
	["地狱火典狱官"] = {t=0, pBar="玛瑟里顿小怪刷新"};
	["玛瑟里顿"] = {t=0, delBar="玛瑟里顿小怪刷新"};
	}

	elseif (GetRealZoneText() == NECB_ZulAman and not noreg) then
	
		CEnemyCastBar_Raids = {
	
		-- Zul'Aman Respawn timer

			["Akil'zon Trash"] = {t=1740, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Amani'shi Tempest"] = {t=0, pBar="Akil'zon Trash"}; -- translate!
					["Akil'zon"] = {t=0, tchange={"Akil'zon Trash", "perm", 0}, delBar="Akil'zon Trash"};

		}

	elseif (GetRealZoneText() == NECB_Black_Temple and not noreg) then
	
	CEnemyCastBar_Raids = {
	
	-- Black Temple Respawn timer

	["Naj'entus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Aqueous Lord"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
	["Coilskar General"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
	["Coilskar Harpooner"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
	["Leviathan"] = {t=0, pBar="Naj'entus Trash"}; -- translate!
	-- + Coilskar Soothsayer, Coilskar Wrangler
	["High Warlord Naj'entus"] = {t=0, tchange={"Naj'entus Trash", "perm", 0}, delBar="Naj'entus Trash"};

	["Akama Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Ashtongue Primalist"] = {t=0, pBar="Akama Trash"}; -- translate!
	["Ashtongue Mystic"] = {t=0, pBar="Akama Trash"}; -- translate!
	["Ashtongue Battlelord"] = {t=0, pBar="Akama Trash"}; -- translate!
	["Shade of Akama"] = {t=0, tchange={"Akama Trash", "perm", 0}, delBar="Akama Trash"}; 

	["Gorefiend Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Shadowmoon Champion"] = {t=0, pBar="Gorefiend Trash"}; -- translate!
	["Shadowmoon Reaver"] = {t=0, pBar="Gorefiend Trash"}; -- translate!
	["Teron Gorefiend"] = {t=0, tchange={"Gorefiend Trash", "perm", 0}, delBar="Gorefiend Trash"};

	["Supremus Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Bonechewer Worker"] = {t=0, pBar="Supremus Trash"}; -- translate!
	["Bonechewer Taskmaster"] = {t=0, pBar="Supremus Trash"}; -- translate!
	["Supremus"] = {t=0, tchange={"Supremus Trash", "perm", 0}, delBar="Supremus Trash"}; -- translate!

	["Gurtogg Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Bonechewer Shield Disciple"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
	["Bonechewer Blade Fury"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
	["Mutant War Hound"] = {t=0, pBar="Gurtogg Trash"}; -- translate!
	["Gurtogg Bloodboil"] = {t=0, tchange={"Gurtogg Trash", "perm", 0}, delBar="Gurtogg Trash"}; -- translate!

			["Mother Shahraz Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Temple Concubine"] = {t=0, pBar="Mother Shahraz Trash"};
				["Charming Courtesan"] = {t=0, pBar="Mother Shahraz Trash"};
				["Spellbound Attendant"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pain"] = {t=0, pBar="Mother Shahraz Trash"};
				["Sister of Pleasure"] = {t=0, pBar="Mother Shahraz Trash"};
					["Mother Shahraz"] = {t=0, tchange={"Mother Shahraz Trash", "perm", 0}, delBar="Mother Shahraz Trash"};

			["Illidari Council Trash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
				["Promenade Sentinel"] = {t=0, pBar="Illidari Council Trash"}; -- translate!
					["击碎者加西奥斯"] = {t=0, tchange={"Illidari Council Trash", "perm", 0}, delBar="Illidari Council Trash"};	
	}

	elseif (GetRealZoneText() == NECB_Tempest_Keep and not noreg) then
	
	CEnemyCastBar_Raids = {
	
	-- Tempest Keep
	
	-- Respawn timer
	["奥小怪"] = {t=7200, c="cooldown", global="true", m="刷新", icontex="Spell_Holy_Resurrection"};
	["星术师"] = {t=0, pBar="奥小怪刷新"};
	["星占师"] = {t=0, pBar="奥小怪刷新"};
	["血警卫守备官"] = {t=0, pBar="奥小怪刷新"};
	-- conflict ["血警卫军团士兵"] = {t=0, pBar="奥小怪刷新"};
	["奥"] = {t=0, tchange={"奥小怪刷新", "perm", 0}, delBar="奥小怪刷新"};

	["空灵机甲小怪"] = {t=7200, c="cooldown", global="true", m="刷新", icontex="Spell_Holy_Resurrection"};
	["晶核摧毁者"] = {t=0, pBar="空灵机甲小怪刷新"};
	-- conflict ["晶核斥候"] = {t=0, pBar="空灵机甲小怪刷新"};
	["空灵机甲"] = {t=0, tchange={"空灵机甲小怪刷新", "perm", 0}, delBar="空灵机甲小怪刷新"};

	["大星术师小怪"] = {t=7200, c="cooldown", global="true", m="刷新", icontex="Spell_Holy_Resurrection"};
	["星术师领主"] = {t=0, pBar="大星术师小怪"};
	-- conflict ["血警卫军团士兵"] = {t=0, pBar="大星术师小怪"};
	["星术师学徒"] = {t=0, pBar="大星术师小怪"};
	["大星术师索兰莉安"] = {t=0, tchange={"大星术师小怪", "perm", 0}, delBar="大星术师小怪"};

	["凯尔萨斯小怪"] = {t=7200, c="cooldown", global="true", m="刷新", icontex="Spell_Holy_Resurrection"};
	["Crimson Hand Battle Mage"] = {t=0, pBar="凯尔萨斯小怪"}; -- translate!
	["Crimson Hand Blood Knight"] = {t=0, pBar="凯尔萨斯小怪"}; -- translate!
	["Crimson Hand Centurion"] = {t=0, pBar="凯尔萨斯小怪"}; -- translate!
	["Crimson Hand Inquisitor"] = {t=0, pBar="凯尔萨斯小怪"}; -- translate!
	["凯尔萨斯·逐日者"] = {t=0, tchange={"凯尔萨斯小怪", "perm", 0}, delBar="凯尔萨斯小怪"};

	}

	elseif (GetRealZoneText() == NECB_SerpentshrineCavern and not noreg) then
	    
	CEnemyCastBar_Raids = {
	
	-- Serpentshrine Cavern
	
	-- Respawn timer
	["HydrossTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Coilfang Beast-Tamer"] = {t=0, pBar="HydrossTrash"};
	["Coilfang Hate-Screamer"] = {t=0, pBar="HydrossTrash"};
	["Serpentshrine Sporebat"] = {t=0, pBar="HydrossTrash"};
	["Hydross the Unstable"] = {t=0, tchange={"HydrossTrash", "perm", 0}, delBar="HydrossTrash"};

	["LurkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Vashj'ir Honor Guard"] = {t=0, pBar="LurkerTrash"};
	["Coilfang Priestess"] = {t=0, pBar="LurkerTrash"};
	["The Lurker Below"] = {t=0, tchange={"LurkerTrash", "perm", 0}, delBar="LurkerTrash"};

	["MixedTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Greyheart Nether-Mage"] = {t=0, pBar="MixedTrash"};
	["Greyheart Tidecaller"] = {t=0, pBar="MixedTrash"};
	["Greyheart Skulker"] = {t=0, pBar="MixedTrash"};

	["TidewalkerTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Tidewalker Shaman"] = {t=0, pBar="TidewalkerTrash"};
	["Tidewalker Depth-Seer"] = {t=0, pBar="TidewalkerTrash"};
	["Tidewalker Warrior"] = {t=0, pBar="TidewalkerTrash"};
	["Morogrim Tidewalker"] = {t=0, tchange={"TidewalkerTrash", "perm", 0}, delBar="TidewalkerTrash"};
	
	["LeotherasTrash"] = {t=7200, c="cooldown", global="true", m="Respawn", icontex="Spell_Holy_Resurrection"};
	["Greyheart Shield-Bearer"] = {t=0, pBar="LeotherasTrash"};
	["Leotheras the Blind"] = {t=0, tchange={"LeotherasTrash", "perm", 0}, delBar="LeotherasTrash"};

	}

	elseif (GetRealZoneText() == NECB_ShatteredHalls and GetInstanceDifficulty() == 2) then

	NECB_PvE_Debuffs = true; -- force register events

	CEnemyCastBar_Raids = {
	["卡加斯的死刑执行者"] = {t=4800, c="cooldown", global="true", m="英雄模式", icontex="Spell_Holy_Resurrection"};
	["酋长卡加斯·刃拳"] = {t=0, delBar="卡加斯的死刑执行者"};
	}

	elseif (GetRealZoneText() == NECB_GruulsLair and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	
	CEnemyCastBar_Raids = {
	
	-- Gruuls
	
	-- Krosh Firehand
	["法术护盾"] = {t=30.0, c="gainsfoe", icontex="Spell_Arcane_ArcaneResilience"}; --!correct?

	-- Respawn timer
	["食人魔刷新"] = {t=3600, c="cooldown", global="true", m="格鲁尔", icontex="Spell_Holy_Resurrection"};
	["巢穴卫兵"] = {t=0, pBar="食人魔刷新"};
	["戈隆祭司"] = {t=0, pBar="食人魔刷新"};
	["莫加尔大王"] = {t=0, delBar="食人魔刷新"};
	["屠龙者格鲁尔"] = {t=0, delBar="食人魔刷新"};
	}

	elseif (GetRealZoneText() == NECB_Karazhan and not noreg) then

	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;

	CEnemyCastBar_Raids = {

	-- Respawn timer
	["小怪刷新1"] = {t=1500, c="cooldown", global="true", m="阿图门", icontex="Spell_Holy_Resurrection"};
	["鬼灵骏马"] = {t=0, pBar="小怪刷新1"};
	["鬼灵战马"] = {t=0, pBar="小怪刷新1"};
	["猎手阿图门"] = {t=0, tchange={"小怪刷新1", "perm", 0}, delBar="小怪刷新1"};
 
	["小怪刷新2"] = {t=3600, c="cooldown", global="true", m="莫罗斯", icontex="Spell_Holy_Resurrection"};
	["幻影访客"] = {t=0, pBar="小怪刷新2"};
	["莫罗斯"] = {t=0, tchange={"小怪刷新2", "perm", 0}, delBar="小怪刷新2"};

	["小怪刷新3"] = {t=3600, c="cooldown", global="true", m="贞洁圣女", icontex="Spell_Holy_Resurrection"};
	["幻影卫兵"] = {t=0, pBar="小怪刷新3"};
	["鬼灵斥候"] = {t=0, pBar="小怪刷新3"};
	["贞洁圣女"] = {t=0, tchange={"小怪刷新3", "perm", 0}, delBar="小怪刷新3"};

	["小怪刷新3"] = {t=3600, c="cooldown", global="true", m="歌剧院", icontex="Spell_Holy_Resurrection"};
	["骷髅招待员"] = {t=0, pBar="小怪刷新3"};
	["巫婆"] = {t=0, tchange={"小怪刷新3", "perm", 0}, delBar="小怪刷新3"};
	["大灰狼"] = {t=0, tchange={"小怪刷新3", "perm", 0}, delBar="小怪刷新3"};
	["罗密欧"] = {t=0, tchange={"小怪刷新3", "perm", 0}, delBar="小怪刷新3"};

	["小怪刷新4"] = {t=3600, c="cooldown", global="true", m="馆长", icontex="Spell_Holy_Resurrection"};
	["奥术看守"] = {t=0, pBar="小怪刷新4"};
	["馆长"] = {t=0, tchange={"小怪刷新4", "perm", 0}, delBar="小怪刷新4"};

	["小怪刷新5"] = {t=7200, c="cooldown", global="true", m="埃兰", icontex="Spell_Holy_Resurrection"};
	["奥术保卫者"] = {t=0, tchange={"小怪刷新4", "perm", 0}, pBar="小怪刷新5", delBar="小怪刷新4"};
	["埃兰之影"] = {t=0, tchange={"小怪刷新5", "perm", 0}, delBar="小怪刷新5"};

	["小怪刷新6"] = {t=7200, c="cooldown", global="true", m="邪蹄", icontex="Spell_Holy_Resurrection"};
	["矮劣魔"] = {t=0, pBar="小怪刷新6"};
	["暗影掠夺者"] = {t=0, pBar="小怪刷新6"};
	["特雷斯坦·邪蹄"] = {t=0, tchange={"小怪刷新6", "perm", 0}, delBar="小怪刷新6"};

	["小怪刷新7"] = {t=7200, c="cooldown", global="true", m="虚空幽龙", icontex="Spell_Holy_Resurrection"};
	["巫术之影"] = {t=0, pBar="小怪刷新7"};
	["虚空幽龙"] = {t=0, tchange={"小怪刷新7", "perm", 0}, delBar="小怪刷新7"};

	["顶层小怪刷新"] = {t=7200, c="cooldown", global="true", m="玛克扎尔", icontex="Spell_Holy_Resurrection"};
	["血肉兽"] = {t=0, pBar="顶层小怪刷新"};
	["大型血肉兽"] = {t=0, pBar="顶层小怪刷新"};
	["玛克扎尔王子"] = {t=0, tchange={"顶层小怪刷新", "perm", 0}, delBar="顶层小怪刷新"};
	}

	CEnemyCastBar_Afflictions["脆弱骨骼"] = {t=90, global="true", icontex="Spell_Shadow_NetherCloak"}; -- possible armour = 0
	CEnemyCastBar_Afflictions["烈焰花环"] = {t=20, global="true", icontex="Spell_Fire_Incinerate"}; -- Arans Debuff
	CEnemyCastBar_Afflictions["过载"] = {t=10, global="true", icontex="Spell_Nature_WispSplode"}; -- Arcane Watchman Debuff
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

--Azeroth
	elseif (GetRealZoneText() == NECB_Stratholme) then

	NECB_PvE_Debuffs = true; -- force register events

	CEnemyCastBar_Raids = {
	["男爵的通牒"] = {t=2700, c="cooldown", global="true", m="男爵进行中", icontex="Spell_Holy_Resurrection"};
	["瑞文戴尔男爵"] = {t=0, delBar="男爵的通牒"};
	}

	elseif (GetRealZoneText() == NECB_Naxxramas and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["FIRST_LOCUST_SWARM"] = "第一次虫群风暴";
	NECB_PvE_Vars["ENRAGED_MODE1"] = "激怒模式 ";
	NECB_PvE_Vars["WEB_SPRAY"] = "蛛网喷射";
	NECB_PvE_Vars["DISRUPTING_SHOUT"] = "瓦解怒吼";
	NECB_PvE_Vars["DECIMATE"] = "残杀";
	NECB_PvE_Vars["BECOME_ENRAGED"] = "变得狂暴!";
	NECB_PvE_Vars["ENRAGE"] = "激怒";
	NECB_PvE_Vars["15SEC_DOOM_CD"] = "15秒厄运CD!";
	NECB_PvE_Vars["FIRST_INVITABLE_DOOM"] = "第一次必然的厄运";
	NECB_PvE_Vars["COMES_DOWN"] = "下来了";
	
	NECB_PvE_Vars["1ST_TRAINEES_INCOME"] = "第一次学徒";
	NECB_PvE_Vars["1ST_DK_INCOME"] = "第一次死亡骑士";
	NECB_PvE_Vars["1ST_RIDER_INCOME"] = "第一次骑兵";
	NECB_PvE_Vars["TRAINEES_INCOME"] = "学徒";
	NECB_PvE_Vars["DK_INCOME"] = "死亡骑士";
	NECB_PvE_Vars["RIDER_INCOME"] = "骑兵";
	NECB_PvE_Vars["FIRST_TELEPORT"] = "第一次传送";
	NECB_PvE_Vars["ON_PLATFORM"] = "上台";
	NECB_PvE_Vars["TELEPORT_CD"] = "传送 CD";
	
	CEnemyCastBar_Raids = {
	
	-- Naxxramas
	
	["死灵捕猎者"] = {t=1800.0, c="cooldown", global="true", m="刷新", icontex="Spell_Holy_Resurrection"};
	
	-- Anub'Rekhan
	[NECB_PvE_Vars["FIRST_LOCUST_SWARM"]] = {t=90, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
	["虫群风暴"] = {t=23, i=3, c="gainsfoe", delBar="虫群风暴 CD", aBar="虫群风暴 CD", active="true", icontex="Spell_Nature_InsectSwarm"};
	["虫群风暴 CD"] = {t=70, c="cooldown", icontex="Spell_Nature_InsectSwarm"};
	
	-- Patchwerk
	[NECB_PvE_Vars["ENRAGED_MODE1"]] = {t=420, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
	-- Razuvious
	[NECB_PvE_Vars["DISRUPTING_SHOUT"]] = {t=25, c="cooldown", active="true", delBar="可能的 "..NECB_PvE_Vars["DISRUPTING_SHOUT"], aBar="可能的 "..NECB_PvE_Vars["DISRUPTING_SHOUT"], icontex="Ability_Creature_Disease_02"};
	["可能的 "..NECB_PvE_Vars["DISRUPTING_SHOUT"]] = {t=25, c="cooldown", aBar="可能的 "..NECB_PvE_Vars["DISRUPTING_SHOUT"], icontex="Ability_Creature_Disease_02"};
	
	-- Gluth
    ["恐惧怒吼"] = {t=20.0, c="cooldown", m="格拉斯", icontex="Ability_Devour"}; -- Gluth Fears every 20seconds
    [NECB_PvE_Vars["DECIMATE"]] = {t=105, c="cooldown", active="true", icontex="Ability_Creature_Disease_02"};
	
	-- Maexxna
	[NECB_PvE_Vars["WEB_SPRAY"]] = {t=40, c="cooldown", pBar="迈克斯纳之子", m="迈克斯纳", aZone="纳克萨玛斯", icontex="Ability_Ensnare"};
	["迈克斯纳之子"] = {t=30, c="cooldown", pBar="蛛网喷射 CD", icontex="INV_Misc_MonsterSpiderCarapace_01"};
	["蛛网喷射 CD"] = {t=20, c="cooldown", icontex="Spell_Nature_Web"};
	
	-- Thaddius
	["极性转化"] = {t=30, i=3, c="cooldown", pBar=NECB_PvE_Vars["BECOME_ENRAGED"], mcheck="塔迪乌斯", icontex="Spell_Nature_Lightning"};
	["能量涌动"] = {t=10, c="gainsfoe", mcheck="斯塔拉格", icontex="Spell_Shadow_SpectralSight"};
	[NECB_PvE_Vars["BECOME_ENRAGED"]] = {t=290, c="cooldown", global="true", tchange={NECB_PvE_Vars["BECOME_ENRAGED"], 290, 0}, icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! -- wont be updated
	
	-- Faerlina
	[NECB_PvE_Vars["ENRAGE"]] = {t=60, c="cooldown", mcheck="黑女巫法琳娜", icontex="Spell_Shadow_UnholyFrenzy"};
	["黑女巫的拥抱"] = {t=30, c="cooldown", mcheck="黑女巫法琳娜", icontex="Spell_Arcane_Blink"}; -- Fearlina
	
	-- Loatheb
	[NECB_PvE_Vars["15SEC_DOOM_CD"]] = {t=299, tchange={"必然的厄运", 30, 15}, c="cooldown", m="洛欧塞布", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
	[NECB_PvE_Vars["FIRST_INVITABLE_DOOM"]] = {t=120, c="cooldown", m="洛欧塞布", icontex="Spell_Shadow_NightOfTheDead"}; -- don't translate, used internally!
	["必然的厄运"] = {t=30, c="cooldown", m="洛欧塞布", icontex="Spell_Shadow_NightOfTheDead"};
	
	["召唤孢子"] = {t=12.5, icasted="true", c="cooldown", mcheck="洛欧塞布", icontex="Spell_Nature_AbolishMagic"};
	["移处诅咒"] = {t=0.1, icasted="true", c="cooldown", pBar="Curses Removed", mcheck="洛欧塞布"};
	["诅咒被移除了"] = {t=30, c="cooldown", icontex="Spell_Nature_RemoveCurse"};
	
	-- Gothik
	-- don't translate, ALL used internally!
	[NECB_PvE_Vars["COMES_DOWN"]] = {t=270, c="cooldown", aBar="del1", icontex="Spell_Shadow_RaiseDead"};
	["del1"] = {t=0.1, pBar="del2", delBar=NECB_PvE_Vars["TRAINEES_INCOME"]};
	["del2"] = {t=0.1, pBar="del3", delBar=NECB_PvE_Vars["DK_INCOME"]};
	["del3"] = {t=0.1, delBar=NECB_PvE_Vars["RIDER_INCOME"]};

	[NECB_PvE_Vars["1ST_TRAINEES_INCOME"]] = {t=27, c="cooldown", aBar=NECB_PvE_Vars["TRAINEES_INCOME"], icontex="INV_Misc_Head_Undead_01"};
	[NECB_PvE_Vars["1ST_DK_INCOME"]] = {t=77, c="cooldown", aBar=NECB_PvE_Vars["DK_INCOME"], icontex="Spell_Shadow_ShadowWard"};
	[NECB_PvE_Vars["1ST_RIDER_INCOME"]] = {t=137, c="cooldown", aBar=NECB_PvE_Vars["RIDER_INCOME"], icontex="Ability_Mount_Undeadhorse"};
	[NECB_PvE_Vars["TRAINEES_INCOME"]] = {t=20, c="cooldown", aBar=NECB_PvE_Vars["TRAINEES_INCOME"], icontex="INV_Misc_Head_Undead_01"};
	[NECB_PvE_Vars["DK_INCOME"]] = {t=25, c="cooldown", aBar=NECB_PvE_Vars["DK_INCOME"], icontex="Spell_Shadow_ShadowWard"};
	[NECB_PvE_Vars["RIDER_INCOME"]] = {t=30, c="cooldown", aBar=NECB_PvE_Vars["RIDER_INCOME"], icontex="Ability_Mount_Undeadhorse"};
	
	-- Noth
	["闪现术"] = {t=30, c="cooldown", mcheck="瘟疫使者诺斯", aZone="纳克萨玛斯", icontex="Spell_Arcane_Blink"}; --Noth blinks every 30sec, agro reset.
	[NECB_PvE_Vars["FIRST_TELEPORT"]] = {t=90, c="cooldown", aBar="上台 1", aZone="纳克萨玛斯", icontex="Spell_Nature_AstralRecalGroup"};
	["上台 1"] = {t=70, c="cooldown", aBar="第二次传送", icontex="Spell_Nature_AstralRecalGroup"};
	["第二次传送"] = {t=110, c="cooldown", aBar="上台 2", icontex="Spell_Nature_AstralRecalGroup"};
	["上台 2"] = {t=95, c="cooldown", aBar="第三次传送", icontex="Spell_Nature_AstralRecalGroup"};
	["第三次传送"] = {t=180, c="cooldown", aBar="上台 3", icontex="Spell_Nature_AstralRecalGroup"};
	["上台 3"] = {t=120, c="cooldown", icontex="Spell_Nature_AstralRecalGroup"};
	
	-- Heigan
	[NECB_PvE_Vars["ON_PLATFORM"]] = {t=45, c="cooldown", aBar=NECB_PvE_Vars["TELEPORT_CD"], icontex="INV_Enchant_EssenceAstralLarge"};
	[NECB_PvE_Vars["TELEPORT_CD"]] = {t=90, c="cooldown", icontex="INV_Enchant_EssenceAstralLarge"};
	
	-- Sapphiron
	["生命吸取"] = {t=24, c="cooldown", m="萨菲隆", aZone="纳克萨玛斯", icontex="Spell_Shadow_LifeDrain02"};
	
	}
	
	
	-- Naxxramas
	NECB_PvE_Vars["HEIGAN_YELL1"]          = "我看到你了……";
	NECB_PvE_Vars["HEIGAN_YELL2"]          = "你是我的了。";
	NECB_PvE_Vars["HEIGAN_YELL3"]          = "你……就是下一个。";
	NECB_PvE_Vars["HEIGAN_TELEPORT_YELL"]  = "你的生命正走向终结。";
	
	NECB_PvE_Vars["FAER_YELL1"]	= "跪下求饶吧，懦夫！";
	NECB_PvE_Vars["FAER_YELL2"]	= "休想从我面前逃掉！";
	NECB_PvE_Vars["FAER_YELL3"]	= "逃啊！有本事就逃啊！";
	NECB_PvE_Vars["FAER_YELL4"]	= "以主人之名，杀了他们！";
	
	NECB_PvE_Vars["PATCHWERK_NAME"]        = "帕奇维克";
	
	NECB_PvE_Vars["GOTHIK_YELL"]           = "你们这些蠢货已经主动步入了陷阱。";
	
	NECB_PvE_Vars["ANUB_NAME"]	 = "阿努布雷坎";
	
	NECB_PvE_Vars["ANUB_YELL1"]	= "一些小点心……";
	NECB_PvE_Vars["ANUB_YELL2"]	= "对，跑吧！那样伤口出血就更多了！";
	NECB_PvE_Vars["ANUB_YELL3"]	= "你们逃不掉的。";
	
	NECB_PvE_Vars["RAZUVIOUS_NAME"]        = "教官拉苏维奥斯";
	NECB_PvE_Vars["RAZUVIOUS_NAME_PAT"]    = "教官拉苏维奥斯";
	NECB_PvE_Vars["FAERLINA_NAME"]         = "黑女巫法琳娜";
	NECB_PvE_Vars["FAERLINA_NAME_PAT"]     = "黑女巫法琳娜";
	NECB_PvE_Vars["GOTHIK_NAME"]           = "戈提克";
	NECB_PvE_Vars["GOTHIK_NAME_PAT"]       = "戈提克";
	NECB_PvE_Vars["NOTH_NAME"]	 = "诺斯";
	NECB_PvE_Vars["NOTH_NAME_PAT"]         = "诺斯";
	NECB_PvE_Vars["HEIGAN_NAME"]           = "希尔盖";
	NECB_PvE_Vars["HEIGAN_NAME_PAT"]       = "希尔盖";
	NECB_PvE_Vars["GLUTH_NAME"]	= "格拉斯";
	NECB_PvE_Vars["MAEXXAN_NAME"]          = "迈克斯纳";
	NECB_PvE_Vars["LOATHEB_NAME"]          = "洛欧塞布";
	
	NECB_PvE_Vars["SAPPHIRON_NAME"]	= "萨菲隆";

	-- Naxxramas
	CEnemyCastBar_Afflictions["重伤"] = {t=15, global="true", icontex="Ability_CriticalStrike"}; -- Gluth's Healing Debuff
	CEnemyCastBar_Afflictions["变异注射"] = {t=10.0, global="true", icontex="Spell_Shadow_CallofBone"}; -- Grobbulus' Mutagen
	CEnemyCastBar_Afflictions["蛛网裹体"] = {t=60.0, global="true", icontex="Spell_Nature_Web"}; -- Maexxna Web Wraps 3 people after a random ammount of time
	CEnemyCastBar_Afflictions["死灵之毒"] = {t=30.0, global="true", icontex="Ability_Creature_Poison_03"}; -- Maexxna MT -healing Debuff(poison)
	CEnemyCastBar_Afflictions["自爆法力"] = {t=5, global="true", icontex="Spell_Nature_WispSplode"}; -- Kel'Thuzads Mana Bomb
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	
	elseif (GetRealZoneText() == NECB_AhnQiraj and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["TWIN_TELEPORT"] = "双子传送";
	NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"] = "可能发生的奥罗潜没";
	NECB_PvE_Vars["SMALL_EYE_P1"] = "小眼睛阶段一";
	NECB_PvE_Vars["SMALL_EYE_P2"] = "小眼睛阶段二";
	NECB_PvE_Vars["FIRST_SMALL_EYE_P2"] = "第一次小眼睛阶段二";
	NECB_PvE_Vars["AFTER_WEAKENED_EYES"] = "虚弱后的眼睛";
	NECB_PvE_Vars["WEAKENED"] = "被削弱了！";
	NECB_PvE_Vars["FIRST_DARK_GLARE"] = "第一次黑暗闪耀";
	NECB_PvE_Vars["DARK_GLARE"] = "黑暗闪耀";
	NECB_PvE_Vars["ENRAGED_MODE2"] = "激怒模式";
	NECB_PvE_Vars["ENTER_ENRAGED_MODE"] = "进入激怒模式";
	NECB_PvE_Vars["BERSERK_MODE"] = "狂暴模式";
	NECB_PvE_Vars["ENTER_BERSERK_MODE"] = "进入狂暴模式";
	
	CEnemyCastBar_Raids = {
	
	-- Ahn'Qiraj
	
	-- 40 Man
	["黑曜石清除者"] = {t=1800.0, c="cooldown", global="true", m="刷新", icontex="Spell_Holy_Resurrection"};
	
	-- Twin Emperors
	[NECB_PvE_Vars["TWIN_TELEPORT"]] = {t=30.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
	["爆炸虫"] = {t=5.0, c="gainsfoe", icontex="Spell_Fire_Fire"};
	["变形包"] = {t=5.0, c="gainsfoe", icontex="Ability_Hunter_Pet_Scorpid"};
	
	-- Ouro
	["沙尘爆裂"] = {t=2.0, c="hostile", mcheck="奥罗", icontex="Spell_Nature_Cyclone"};
	["横扫"] = {t=21, i=1.0, c="cooldown", mcheck="奥罗", icontex="Spell_Nature_Thorns"};
	
	["召唤奥罗土堆"] = {t=0.1, delBar=NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"], icasted="true", pBar="潜没"};
	["潜没"] = {t=30, c="cooldown", delBar="奥罗潜没", aBar=NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"], icontex="INV_Qiraj_OuroHide"};
	[NECB_PvE_Vars["POSSIBLE_OURO_SUBMERGE"]] = {t=90, c="cooldown", pBar="奥罗潜没", icontex="Spell_Shadow_DemonBreath"};
	["奥罗潜没"] = {t=180, c="cooldown", icontex="Spell_Shadow_DemonBreath"};
	
	
	-- C'Thun
	[NECB_PvE_Vars["FIRST_DARK_GLARE"]] = {t=48, c="cooldown", aBar=NECB_PvE_Vars["DARK_GLARE"], icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
	[NECB_PvE_Vars["WEAKENED"]] = {t=45, c="gainsfoe", delBar=NECB_PvE_Vars["SMALL_EYE_P2"], aBar=NECB_PvE_Vars["AFTER_WEAKENED_EYES"], icontex="Ability_Hunter_SniperShot"}; -- don't translate, used internally!
	[NECB_PvE_Vars["DARK_GLARE"]] = {t=86, i=40, c="cooldown", active="true", aBar=NECB_PvE_Vars["DARK_GLARE"], icontex="Spell_Nature_CallStorm"}; -- don't translate, used internally!
	[NECB_PvE_Vars["SMALL_EYE_P1"]] = {t=45, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P1"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	[NECB_PvE_Vars["FIRST_SMALL_EYE_P2"]] = {t=42, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	[NECB_PvE_Vars["SMALL_EYE_P2"]] = {t=30, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	[NECB_PvE_Vars["AFTER_WEAKENED_EYES"]] = {t=38, c="cooldown", aBar=NECB_PvE_Vars["SMALL_EYE_P2"], icontex="Spell_Shadow_SiphonMana"}; -- don't translate, used internally!
	
	-- Skeram
	["魔爆术"] = {t=1.2, c="hostile", mcheck="预言者斯克拉姆", icontex="Spell_Nature_WispSplode"};
	
	-- Sartura (Twin Emps enrage + Hakkar enrage)
	["旋风斩"] = {t=15.0, c="gainsfoe", mcheck="沙尔图拉", icontex="Ability_Whirlwind"};
	[NECB_PvE_Vars["ENRAGED_MODE2"]] = {t=900, r="沙尔图拉 哈卡", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	[NECB_PvE_Vars["ENTER_ENRAGED_MODE"]] = {t=3, c="gainsfoe", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally!
	
	-- Huhuran
	[NECB_PvE_Vars["BERSERK_MODE"]]  = {t=300, c="cooldown", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally! if player enters combat and target is Huhuran!
	[NECB_PvE_Vars["ENTER_BERSERK_MODE"]] = {t=3, c="gainsfoe", icontex="Racial_Troll_Berserk"}; -- don't translate, used internally!
	["翼龙钉刺"] = {t=25, c="cooldown", m="哈霍兰公主", aZone="安其拉", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="INV_Spear_02"};
	
	-- Yauj
	["Fear"] = {t=20, c="cooldown", checkengage="true", m="亚尔基公主", aZone="安其拉", checkevent="CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE - CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE - CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", icontex="Spell_Shadow_Possession"};
	["强效治疗术"] = {t=2.0, c="hostile", m="亚尔基公主", mcheck="亚尔基公主", icontex="Spell_Holy_Heal"};
	
	
	}
	
	-- AQ40
	NECB_PvE_Vars["SARTURA_NAME"]          = "沙尔图拉";
	NECB_PvE_Vars["SARTURA_NAME_PAT"]      = "沙尔图拉";
	NECB_PvE_Vars["HUHURAN_NAME"]          = "哈霍兰公主";
	NECB_PvE_Vars["HUHURAN_NAME_PAT"]      = "哈霍兰公主";
	NECB_PvE_Vars["VEKLOR_NAME"]           = "维克洛尔大帝";
	NECB_PvE_Vars["VEKNILASH_NAME"]        = "维克尼拉斯大帝";
	NECB_PvE_Vars["YAUJ_NAME"]	 = "亚尔基公主";
	NECB_PvE_Vars["YAUJ_NAME_PAT"]         = "亚尔基公主";
	NECB_PvE_Vars["DETECTED_NAME"]         = "侦测到";
	NECB_PvE_Vars["KRI_NAME"]	  = "克里勋爵";
	NECB_PvE_Vars["KRI_NAME_PAT"]          = "克里勋爵";
	NECB_PvE_Vars["VEM_NAME"]	  = "维姆";
	NECB_PvE_Vars["OURO_NAME"]	 = "奥罗";
	NECB_PvE_Vars["TWINS_NAME"]	= "双子皇帝";
	
	
	NECB_PvE_Vars["SARTURA_CALL"]          = "我宣判你死刑";
	NECB_PvE_Vars["SARTURA_CRAZY"]         = "变得愤怒了！";
	
	NECB_PvE_Vars["HUHURAN_CRAZY"]         = "变得狂暴了！";
	
	NECB_PvE_Vars["CTHUN_NAME1"]           = "克苏恩之眼";
	NECB_PvE_Vars["CTHUN_NAME2"]           = "克苏恩";
	NECB_PvE_Vars["CTHUN_WEAKENED"]        = "被削弱了！";

	-- AQ40
	CEnemyCastBar_Afflictions["充实"] = {t=20, global="true", icontex="Spell_Shadow_Charm"}; -- Skeram MindControl
	CEnemyCastBar_Afflictions["瘟疫"] = {t=40, global="true", icontex="Spell_Shadow_CurseOfTounges"}; -- Anubisath Defenders Plague
	CEnemyCastBar_Afflictions["纠缠"] = {t=10, global="true", icontex="Spell_Nature_StrangleVines"}; -- Fankriss the Unyielding's Entangle
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_AhnQirajRuins and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["UNTIL_STONEFORM"] = "石化状态";
	
	CEnemyCastBar_Raids = {
	
	
	-- 20 Man
	
	["爆炸"] = {t=6.0, c="hostile", icontex="Spell_Fire_SelfDestruct"};
	
	-- Ossirian
	["奥术虚弱"] = {t=45, c="gainsfoe", mcheck="无疤者奥斯里安", icontex="INV_Misc_QirajiCrystal_01"};
	["火焰虚弱"] = {t=45, c="gainsfoe", mcheck="无疤者奥斯里安", icontex="INV_Misc_QirajiCrystal_02"};
	["自然虚弱"] = {t=45, c="gainsfoe", mcheck="无疤者奥斯里安", icontex="INV_Misc_QirajiCrystal_03"};
	["冰霜虚弱"] = {t=45, c="gainsfoe", mcheck="无疤者奥斯里安", icontex="INV_Misc_QirajiCrystal_04"};
	["暗影虚弱"] = {t=45, c="gainsfoe", mcheck="无疤者奥斯里安", icontex="INV_Misc_QirajiCrystal_05"};
	
	-- Moam
	[NECB_PvE_Vars["UNTIL_STONEFORM"]] = {t=90, c="grey", icontex="Spell_Shadow_UnholyStrength"}; -- don't translate, used internally!
	["充能"] = {t=90, c="gainsfoe", icontex="Spell_Nature_Cyclone"};
	
	
	}
	
	-- Ruins of AQ
	NECB_PvE_Vars["MOAM_NAME"] = "莫阿姆";
	NECB_PvE_Vars["MOAM_STARTING"] = "察觉到了你的恐惧。";

	-- AQ20
	CEnemyCastBar_Afflictions["麻痹"] = {t=10, global="true", aZone="安其拉废墟", icontex="Ability_Creature_Poison_05"}; -- Ayamiss the Hunter
	-- Moam removal
	CEnemyCastBar_Afflictions["充能"] = {t=0.1, global="true"}; --0.1 clears it on leaving world/instance
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_ZulGurub and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["BLOOD_SIPHON"] = "血液虹吸";
	NECB_PvE_Vars["ENRAGED_MODE2"] = "激怒模式";
	
	CEnemyCastBar_Raids = {
	
	-- Zul'Gurub
	
	-- Hakkar
	[NECB_PvE_Vars["BLOOD_SIPHON"]] = {t=90.0, c="cooldown", mcheck="哈卡", checkevent="CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", icontex="Spell_Shadow_LifeDrain02"};
	[NECB_PvE_Vars["ENRAGED_MODE2"]] = {t=900, r="沙尔图拉 哈卡", a=600, c="cooldown", icontex="Spell_Shadow_UnholyFrenzy"}; -- don't translate, used internally! +if player enters combat and target are twins!
	
	
	}
	
	-- Zul'Gurub
	NECB_PvE_Vars["HAKKAR_NAME"] = "哈卡";
	NECB_PvE_Vars["HAKKAR_YELL"] = "骄傲会将你送上绝路";

	-- Zul'Gurub
	CEnemyCastBar_Afflictions["金度的欺骗"] = {t=20, global="true", icontex="Spell_Shadow_UnholyFrenzy"}; -- Delusions of Jin'do
	CEnemyCastBar_Afflictions["导致疯狂"] = {t=9.5, global="true", icontex="Spell_Shadow_ShadowWordDominate"}; -- Hakkars Mind Control
	CEnemyCastBar_Afflictions["威慑凝视"] = {t=5.7, global="true", icontex="Spell_Shadow_Charm"}; -- Mandokir's Gaze
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_MoltenCore and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["SUBMERGE"] = "暂时消失";
	NECB_PvE_Vars["KNOCKBACK"] = "群体击退";
	NECB_PvE_Vars["SONS_OF_FLAME"] = "烈焰之子";
	
	CEnemyCastBar_Raids = {
	
	-- Molten Core
	
	-- Shazzrah
	["沙斯拉尔之门"] = {t=45.0, c="cooldown", icasted="true", icontex="Spell_Arcane_Blink"};
	
	-- Lucifron
	["末日降临"] = {t=20.0, c="cooldown", m="鲁西弗隆", icontex="Spell_Shadow_NightOfTheDead"};
	["鲁西弗隆的诅咒"] = {t=20.0, c="cooldown", m="鲁西弗隆", icontex="Spell_Shadow_BlackPlague"};
	
	-- Magmadar
	["恐慌"] = {t=30.0, c="cooldown", m="玛格曼达", icontex="Spell_Shadow_DeathScream"};
	
	-- Gehennas
	["基赫纳斯的诅咒"] = {t=30.0, c="cooldown", m="基赫纳斯", icontex="Spell_Shadow_GatherShadows"};
	
	-- Geddon
	["地狱火"] = {t=8.0, c="gainsfoe", mcheck="迦顿男爵", icontex="Spell_Fire_Incinerate"};
	
	-- Majordomo
	["魔法反射"] = {t=30.0, i=10.0, c="cooldown", m="管理者埃克索图斯", aZone="熔火之心", icontex="Spell_Frost_FrostShock"};
	["伤害反射护盾"] = {t=30.0, i=10.0, c="cooldown", m="管理者埃克索图斯", icontex="Spell_Nature_LightningShield"};
	
	-- Ragnaros
	[NECB_PvE_Vars["SUBMERGE"]] = {t=180.0, c="cooldown", icontex="Spell_Fire_Volcano"}; -- don't translate, used internally!
	[NECB_PvE_Vars["KNOCKBACK"]] = {t=28.0, c="cooldown", icontex="Ability_Kick"}; -- don't translate, used internally!
	[NECB_PvE_Vars["SONS_OF_FLAME"]] = {t=90.0, c="cooldown", icontex="ell_Fire_LavaSpawn"}; -- don't translate, used internally!

	}
	
	-- MC
	NECB_PvE_Vars["RAGNAROS_NAME"] = "拉格纳罗斯";
	
	NECB_PvE_Vars["RAGNAROS_STARTING"] = "现在轮到你们了！";
	NECB_PvE_Vars["RAGNAROS_KICKER"] = "尝尝萨弗隆的火焰吧";
	NECB_PvE_Vars["RAGNAROS_SONS"] = "出现吧";

	-- MC
	CEnemyCastBar_Afflictions["活化炸弹"] = {t=8, global="true", icontex="INV_Enchant_EssenceAstralSmall"}; -- Geddon's Bomb
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world
	
	elseif (GetRealZoneText() == NECB_OnyxiaLair and not noreg) then

	NECB_PvE_Casts = true; -- force register events
	
	NECB_PvE_Vars["DEEP_BREATH"] = "深呼吸";
	
	CEnemyCastBar_Raids = {
	
	-- Onyxia
	["火息术"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Fire"};
	[NECB_PvE_Vars["DEEP_BREATH"]] = {t=5.0, c="hostile", icontex="Spell_Fire_Incinerate"};
	["龙翼打击"] = {t=31.5, i=1.2, c="cooldown", r="奥妮克希亚", a=0, icontex="INV_Misc_MonsterScales_14"};
	["低沉咆哮"] = {t=2.0, c="hostile", r="奥妮克希亚", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
	
	
	}
	
	-- ONY
	NECB_PvE_Vars["ONY_DB"]	 = "深深地吸了一口气"; 
	NECB_PvE_Vars["ONYXIA_NAME"] = "奥妮克希亚";
	
	elseif (GetRealZoneText() == NECB_BlackwingLair and not noreg) then

	NECB_PvE_Gains = true; -- force register events
	NECB_PvE_Debuffs = true; -- force register events
	NECB_PvE_Casts = true; -- force register events
	NECB_PvE_Debuffed_Players_timer_only = true;
	NECB_PvE_YellEmoteCombat = true;
	
	NECB_PvE_Vars["MOB_SPAWN_45SEC"] = "怪物出现 (45秒)";
	NECB_PvE_Vars["FIRST_WINGBUFFET"] = "第一次龙翼打击";
	NECB_PvE_Vars["KILLING_FRENZY"] = "极为狂暴";
	NECB_PvE_Vars["NEF_CALLS"] = "奈法利安点名";
	NECB_PvE_Vars["MOB_SPAWN"] = "怪物出现";
	NECB_PvE_Vars["LANDING"] = "降落" ;
	
	CEnemyCastBar_Raids = {
	
	
	-- Blackwing Lair
	
	-- Razorgore
	[NECB_PvE_Vars["MOB_SPAWN_45SEC"]] = {t=45.0, c="cooldown", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
	
	-- Firemaw/Flamegor/Ebonroc
	["龙翼打击"] = {t=31.5, i=1.2, c="cooldown", r="Onyxia", a=0, icontex="INV_Misc_MonsterScales_14"};
	[NECB_PvE_Vars["FIRST_WINGBUFFET"]] = {t=30.0, c="cooldown", icontex="INV_Misc_MonsterScales_14"}; -- don't translate, used internally! if player enters combat and target is firemaw or flamegor this castbar appears to catch the first wingbuffet!
	["暗影烈焰"] = {t=2.0, c="hostile", active="true", icontex="Spell_Fire_Incinerate"};
	
	-- Flamegor
	[CECB_SPELL_FRENZY_CD] = {t=10.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
	
	-- Chromaggus
	["冰霜灼烧"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Frost_ChillingBlast"};
	["时间流逝"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Arcane_PortalOrgrimmar"};
	["点燃躯体"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Fire_Fire"};
	["腐蚀酸液"] = {t=60.0, i=2.0, c="cooldown", active="true", icontex="Spell_Nature_Acid_01"};
	["焚烧"] = {t=60.0, i=2.0, c="cooldown", active="true", mcheck="克洛玛古斯", icontex="Spell_Fire_FlameShock"};
	[NECB_PvE_Vars["KILLING_FRENZY"]] = {t=15.0, c="cooldown", icontex="INV_Misc_MonsterClaw_03"}; -- don't translate, used internally!
	-- Chromaggus, Flamegor, Magmadar etc.
	["狂暴"] = {t=8.0, c="gainsfoe", checktarget="true", icontex="INV_Misc_MonsterClaw_03"};
	
	-- Neferian/Onyxia
	["低沉咆哮"] = {t=2.0, c="hostile", r="Onyxia", a=1.5, active="true", icontex="Spell_Shadow_Charm"};
	
	-- Nefarian	
	 [NECB_PvE_Vars["NEF_CALLS"]] = {t=30.0, c="gainsfoe", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	 [NECB_PvE_Vars["MOB_SPAWN"]] = {t=8.0, c="hostile", icontex="Spell_Shadow_RaiseDead"}; -- don't translate, used internally!
	 [NECB_PvE_Vars["LANDING"]] = {t=10.0, c="hostile", icontex="INV_Misc_Head_Dragon_Black"}; -- don't translate, used internally!
	
	
	}
	
	-- BWL
	NECB_PvE_Vars["CHROMAGGUS"] = "克洛玛古斯";
	
	NECB_PvE_Vars["NEFARIUS_NAME"] = "维克多·奈法里奥斯";
	NECB_PvE_Vars["NEFARIAN_NAME"] = "奈法利安";
	
	NECB_PvE_Vars["GRETHOK_NAME"] = "黑翼控制者";
	NECB_PvE_Vars["GRETHOK_NAME_PAT"] = "黑翼控制者";
	
	NECB_PvE_Vars["RAZORGORE_NAME"] = "狂野的拉佐格尔";
	
	NECB_PvE_Vars["RAZORGORE_CALL"]	 = "入侵者";
	
	NECB_PvE_Vars["FIREMAW_NAME"] = "费尔默";
	NECB_PvE_Vars["EBONROC_NAME"] = "埃博诺克";
	NECB_PvE_Vars["FLAMEGOR_NAME"]	= "弗莱格尔";
	NECB_PvE_Vars["FLAMEGOR_FRENZY"] = "变得狂怒无比！";
	NECB_PvE_Vars["CHROMAGGUS_FRENZY"]	= "变得极为狂暴！";
	
	NECB_PvE_Vars["NEFARIAN_STARTING"] = "比赛开始！";
	NECB_PvE_Vars["NEFARIAN_LAND"] = "干得好，我的手下。";
	NECB_PvE_Vars["NEFARIAN_SHAMAN_CALL"] = "萨满祭司";
	NECB_PvE_Vars["NEFARIAN_DRUID_CALL"] = "德鲁伊";
	NECB_PvE_Vars["NEFARIAN_WARLOCK_CALL"] = "术士";
	NECB_PvE_Vars["NEFARIAN_PRIEST_CALL"] = "牧师";
	NECB_PvE_Vars["NEFARIAN_HUNTER_CALL"] = "猎人";
	NECB_PvE_Vars["NEFARIAN_WARRIOR_CALL"] = "战士";
	NECB_PvE_Vars["NEFARIAN_ROGUE_CALL"] = "潜行者";
	NECB_PvE_Vars["NEFARIAN_PALADIN_CALL"] = "圣骑士";
	NECB_PvE_Vars["NEFARIAN_MAGE_CALL"] = "你们也是法师";
	
	-- Class Call Name
	NECB_PvE_Vars["CLASS_DRUIDS"] = "德鲁伊";
	NECB_PvE_Vars["CLASS_HUNTERS"] = "猎人";
	NECB_PvE_Vars["CLASS_MAGES"] = "法师";
	NECB_PvE_Vars["CLASS_PALADINS"] = "圣骑士";
	NECB_PvE_Vars["CLASS_PRIESTS"] = "牧师";
	NECB_PvE_Vars["CLASS_ROGUES"] = "潜行者";
	NECB_PvE_Vars["CLASS_SHAMANS"] = "萨满祭司";
	NECB_PvE_Vars["CLASS_WARLOCKS"] = "术士";
	NECB_PvE_Vars["CLASS_WARRIORS"] = "战士";

	-- BWL
	CEnemyCastBar_Afflictions["燃烧"] = {t=10.0, global="true", aZone="黑翼之巢", icontex="Spell_Fire_Incinerate"}; -- Razorgores (and Drakkisaths) Burning
	CEnemyCastBar_Afflictions["燃烧刺激"] = {t=20.0, global="true", icontex="INV_Gauntlets_03"}; -- Vaelastrasz BA
	CEnemyCastBar_Afflictions["埃博诺克之影"] = {t=8.0, global="true", icontex="Spell_Shadow_GatherShadows"}; -- Ebonroc selfheal debuff
	-- Non Boss DeBuffs:
	CEnemyCastBar_Afflictions["强效变形术"] = {t=20.0, fragile="true", icontex="Spell_Nature_Brilliance"}; -- Polymorph of BWL Spellbinders
	NECB_BossDB_loaded = true; --to let necb know that it has to remove on leave world

	else
	CEnemyCastBar_Raids = { };
	NECB_PvE_Vars = { };

	end
	
	-- Other
	
	for k, v in pairs (CEnemyCastBar_Raids) do
	CEnemyCastBar_Raids["Boss incoming"] = {t=0}; -- don't translate, used internally!
	break;
	end

	--DEFAULT_CHAT_FRAME:AddMessage(GetRealZoneText())

	if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
	CECB_ReloadOptionsUI(); -- update tooltip
	end

	end

end