-- Natur EnemyCastBar PvE Module LUA


function NECB_PvE_Control(mob, spell, special, bcasted, event)

	if (CEnemyCastBar.bPvE) then

		-- Network BC TempBCaster
		local clientlang = GetLocale();
		
		-- stop Boss CDs from beeing updated by fault when player enters combat
		if (special == "engage") then
			if (CEnemyCastBar_EngageProtection() ) then
				necbengagecd = GetTime();
				return;
			end
			necbengagecd = GetTime();
			NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r EngageProtection enabled!", 1, 1, 0, 1, UIERRORS_HOLD_TIME);
			PlaySoundFile("Sound\\interface\\AuctionWindowOpen.wav");
		else
			if (CEnemyCastBar_EngageProtection() ) then
				necbengagecd = GetTime();
				-- if more than necbEPTime secs have passed without a countdown restart it will be nil'ed in enter combat function later!
			end
		end

		-- logical barrier (+if clause at beginning!):
		if (
					-- only allow instant casts with a flag pass to avoid spell mirroring
				(special == "instcast" and not CEnemyCastBar_Raids[spell].icasted)
					-- stop mirroring spells! only if casted actively
			or	(CEnemyCastBar_Raids[spell].active and not (special == "casts" or special == "performs" or special == "engage") )
					-- check if previously disabled with shift + rightclick;
			or	(CEnemyCastBar_Raids[spell].disabled)
					-- only show bar if player has this target (if defined)
			or	(CEnemyCastBar_Raids[spell].checktarget and UnitName("target") ~= mob and UnitName("focus") ~= mob)
			or	(CEnemyCastBar_Raids[spell].checkengage and not CEnemyCastBar_EngageProtection() )

			) then
			return;
		end

		local icontex = CEnemyCastBar_Raids[spell].icontex; -- > get icon texture
		local globalspell = CEnemyCastBar_Raids[spell].global; -- > This castbar won't be updated if already active!
		local castime = CEnemyCastBar_Raids[spell].t;
		local ctype = CEnemyCastBar_Raids[spell].c;

		-- MANUALLY broadcasted PvE spells (respawn timers)
		if (bcasted and string.match (special, "st:") ) then
			special = GetTime() - string.match (special, "st:(%d+)"); -- transform into time past
		end
		
		-- Spell might have the same name but a different cast time on another mob, ie. Onyxia/Nefarian on Bellowing Roar
		if (CEnemyCastBar_Raids[spell].r) then
		
			if ( string.find(CEnemyCastBar_Raids[spell].r, mob) ) then
			
				castime = CEnemyCastBar_Raids[spell].a;
			
			end
		
		end

		local mobbuffer;
		if (CEnemyCastBar_Raids[spell].m) then

			mobbuffer = mob;
			mob = CEnemyCastBar_Raids[spell].m;
		
		end

		local alreadyshowing = CEnemyCastBar_UniqueCheck(spell,castime,mob,globalspell);

		if (alreadyshowing == 0) then

			CEnemyCastBar_Show(mob, spell, castime, ctype, nil, icontex, special); -- special = durleft if number! checked for number in "show"
		
		end
		
		if (CEnemyCastBar_Raids[spell].i) then

			castime = CEnemyCastBar_Raids[spell].i;

			alreadyshowing = CEnemyCastBar_UniqueCheck(spell.." (D)",castime,mob,globalspell);
	
			if (alreadyshowing == 0) then

				CEnemyCastBar_Show(mob, spell.." (D)", castime, "hostile", nil, icontex);
			
			end
		
		end

		-- delete bar if defined
		if (CEnemyCastBar_Raids[spell].delBar) then
			CEnemyCastBar_DelBar(CEnemyCastBar_Raids[spell].delBar);
		end

		-- trigger next bars if defined
		if (CEnemyCastBar_Raids[spell].pBar) then
			CEnemyCastBar_Control(mob, CEnemyCastBar_Raids[spell].pBar, "casts", "true"); -- won't be broadcasted!
		end

		-- Network BCasting
		-- restore unchanged mobname
		if (mobbuffer) then
			mob = mobbuffer;
		end

		if (special == "afflicted" and mob ~= CEnemyCastBar_Raids[spell].mcheck) then
			mob = "CECBName"; -- so no channel spam appears after the raid got feared etc.
		end

		local freetosend, latency = CEnemyCastBar_BCast_Control(bcasted, nil, mob, spell, special);
		if ( freetosend ) then
			NECB_SendMessage(".cecbspell "..mob..", "..spell..", "..special..", "..clientlang..", "..latency);
			NECB_set_LastSentBCPacket(mob, spell, special, GetTime());
			NECB_set_LastGotBCPacket(mob, spell, special, GetTime());
			necb_numspellcast = 0;
		end

		-- recall control function for mobs dying (Obsidian Destroyer) to clear all bars
		if (special == "died") then
			CEnemyCastBar_Control(mob, "dummy_xyz", "died");
		end

	end

end

function CEnemyCastBar_Player_Enter_Combat(arg1) --enter combat (Aggro etc., not only melee autoattack -> "regen. disabled" event)

	if (CEnemyCastBar.bStatus and CEnemyCastBar.bPvE) then

		if (necbengagecd and (GetTime() - necbengagecd) > necbEPTime) then
			-- unregister additional Events used for Bosses (fight seems to be over)
			NECBEvents4:UnregisterEvent("CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE");
			NECBEvents4:UnregisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE");
			necbengagecd = nil;
	
			-- reset modified 't' to default
			while (NECBtchangeSource[1]) do
				CEnemyCastBar_Raids[CEnemyCastBar_Raids[ NECBtchangeSource[1] ].tchange[1]].t = CEnemyCastBar_Raids[ NECBtchangeSource[1] ].tchange[2];
				table.remove (NECBtchangeSource, 1);
			end
	
		end
	
		local targetmob;
		if (not CEnemyCastBar_EngageProtection() ) then
	
			if (UnitIsPlusMob("focus") and (UnitName("focustarget") or UnitAffectingCombat("focus")) ) then
				targetmob = UnitName("focus");
				--DEFAULT_CHAT_FRAME:AddMessage("NECB: |cffffff00-= GO GO GO GO GO =-")
			elseif (UnitIsPlusMob("target") and (UnitName("targettarget") or UnitAffectingCombat("target")) ) then
				targetmob = UnitName("target");
				--DEFAULT_CHAT_FRAME:AddMessage("NECB: |cffffff00-= GO GO GO GO GO =-")
			elseif (not UnitIsPlusMob("target") and not UnitIsPlusMob("focus")) then
				--DEFAULT_CHAT_FRAME:AddMessage("NECB: |cffffff00-= no valid target =-")
				if (not necbengagedelay) then
					return;
				end
			elseif ((arg1 == "target" and not UnitIsPlusMob("target")) or (arg1 == "focus" and not UnitIsPlusMob("focus")) ) then
				--DEFAULT_CHAT_FRAME:AddMessage("NECB: |cffffff00-= wrong unit =-")
				return;
			elseif (not necbengagedelay) then
				-- recharge the above check, because this event mostly is fired too fast for following checks or Warrior used Bloodrage right before engaging
				CarniEnemyCastBarFrame:RegisterEvent("UNIT_TARGET");
				necbengagedelay = true;
				--DEFAULT_CHAT_FRAME:AddMessage("NECB: REDOING")
				return;
			end
	
		end
	
		CarniEnemyCastBarFrame:UnregisterEvent("UNIT_TARGET");
		necbengagedelay = false;
	
		if (targetmob and not CEnemyCastBar_EngageProtection() ) then
			--DEFAULT_CHAT_FRAME:AddMessage("NECB: ENGAGE - |cffffff00Name Check: "..targetmob)
			NECB_PvE_EnterCombat(targetmob); --calls the localized part of 'enter combat'
		end
	end
end

function CEnemyCastBar_EngageProtection()

	if (necbengagecd and (GetTime() - necbengagecd) < necbEPTime) then
		return true;
	else
		return false;
	end
end

-- initialize functions to prevent errors when entering an instance the first time and PvE events happen within 5 seconds:
NECB_PvE_CodeInit(true); --initialize: NECB_PvE_Yell() NECB_PvE_Emote() NECB_PvE_EnterCombat() CEnemyCastBar_Gfind_PvE() NECB_PvE_death()
-- finished

NECB_PvE_Module_loaded = true;
if (not CEnemyCastBar.bPvE and CEnemyCastBar.bShowafflict and CEnemyCastBar.bBossDebuff) then
	NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r PvE Module loaded into memory! |cffff0000Reason: Boss Debuffs enabled!", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);
else
	NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r PvE Module loaded into memory! |cffff0000Reason: Any instance found!", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);
end