-- Natur EnemyCastBar Options LUA


--NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r Options Module loaded into memory!", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);

necbmenuesizex = 500;
necbmshrinksizex = 260;
necbmenuesizey = 595;
necbmshrinksizey = 150;

CECBOptionsFrame:SetHeight(necbmenuesizey); -- set optionframe size, not needed atm
CECBOptionsFrame:SetWidth(necbmenuesizex);

CEnemyCastBar_SetBarColors("SetColors");

-- set frames to be hidden if addon disabled
NECBOptionFrameNames = { CECBOptionsFrameCECB_pvp_check, CECBOptionsFrameCECB_hiderank_check, CECBOptionsFrameCECB_globalpvp_check, CECBOptionsFrameCECB_gainsonly_check, CECBOptionsFrameCECB_pvpswarn_check, CECBOptionsFrameCECB_screamwarn_check,
	CECBOptionsFrameCECB_cdown_check, CECBOptionsFrameCECB_hostileonly_check, CECBOptionsFrameCECB_usecddb_frame, CECBOptionsFrameCDDBReset,
	CECBOptionsFrameCECB_gains_check, CECBOptionsFrameCECB_pve_check, CECBOptionsFramebctimer, CECBOptionsFrameCECB_pvew_check, CECBOptionsFrameCECB_afflict_check,
	CECBOptionsFrameCECB_globalfrag_check, CECBOptionsFrameCECB_magecold_check, CECBOptionsFrameCECB_solod_check, CECBOptionsFrameCECB_fragonly_check,
	CECBOptionsFrameCECB_drtimer_check, CECBOptionsFrameCECB_classdr_check, CECBOptionsFrameCECB_sdots_check, CECBOptionsFrameCECB_turndots_check,
	CECBOptionsFrameCECB_bossdebuff_check, CECBOptionsFrameCECB_hotfilter_check,
	CECBOptionsFrameCECB_timer_check, CECBOptionsFrameCECB_parseC_check, CECBOptionsFrameCECB_throtparser_check,
	CECBOptionsFrameCECB_broadcast_check, CECBOptionsFrameBGFrameNet,
	CECBOptionsFrameCECB_flipb_check, CECBOptionsFrameCECB_border_check, CECBOptionsFrameCECB_togglemouse_check, CECBOptionsFrameCECB_timerinside_check, CECBOptionsFrameCECB_targeticon_check,
	CECBOptionsFrameCECB_showicon_check, CECBOptionsFrameCECB_tsize_check, CECBOptionsFrameCECB_focuspvp_check, CECBOptionsFrameCECB_focusdebuffs_check, CECBOptionsFrameCECB_MiniMap_check, CECBOptionsFrameCECB_SepBar_check,
	CECBOptionsFrameCECB_focuspvponly_check, CECBOptionsFrameCECB_focusdebuffsonly_check, CECBOptionsFrameCECB_healonlypvp_check,
	CECBOptionsFrameCECB_scale_Slider, CECBOptionsFrameCECB_alpha_Slider, CECBOptionsFrameCECB_numbars_Slider,
	CECBOptionsFrameCECB_space_Slider, CECBOptionsFrameCECB_blength_Slider, CECBOptionsFrameCECB_texture_Slider, CECBOptionsFrameCECB_font_Slider,
	CECBOptionsFrameCECB_filling_frame, CECBOptionsFrameCECB_filling_gains, CECBOptionsFrameCECB_filling_debuffs, CECBOptionsFrameCECB_filling_dots,
	CECBOptionsFrameCECB_PerfomaEsti1_frame, CECBOptionsFrameCECB_PerfomaEsti2_frame,
	CECBOptionsFrameCECB_KillSound_frame, CECBOptionsFrameCECB_KSoundPvP, CECBOptionsFrameCECB_KSoundPvE, CECBOptionsFrameCECB_KSoundPvE_grouped,
	CECBOptionsFrameBGLine1, CECBOptionsFrameBGLine2, CECBOptionsFrameBGLineR1, CECBOptionsFrameBGLineR2, CECBOptionsFrameBGLineR3, CECBOptionsFrameBGFrameFreeBars,
	CECBOptionsFrameBGFrame2, CECBOptionsFrameBGFrame3,
	CECBOptionsFrameMoveBar, CECBOptionsFrameBGFrameFPSBar_check, CECBOptionsFrameBGFrameFPSBarLock_check, CECBOptionsFrameBGFrameLatencyBar_check, CECBOptionsFrameBGFrameLatencyBarLock_check };


function CEnemyCastBar_ShowAllBars(duration, msg) --ShowAllBars

		if (CEnemyCastBar.bSeparateBars) then
			CEnemyCastBar_Show("Friendly Casts", msg, duration, "friendly", "forceshow", "Spell_Holy_GreaterHeal",nil,nil,1);
			CEnemyCastBar_Show("Hostile Casts", msg, duration, "hostile", "forceshow", "Spell_Fire_FlameBolt",nil,nil,1);
			CEnemyCastBar_Show("Cooldowns", msg, duration, "cooldown", "forceshow", "Spell_Frost_Frost",nil,nil,1);
			CEnemyCastBar_Show("Hostile Gains", msg, duration, "gainsfoe", "forceshow", "Spell_Shadow_UnholyFrenzy",nil,nil,1);
			CEnemyCastBar_Show("Friendly Gains", msg, duration, "gainsfriend", "forceshow", "Spell_Nature_Lightning",nil,nil,1);
			CEnemyCastBar_Show("Custom Bars", msg, duration, "grey", "forceshow", "INV_Misc_Bomb_03",nil,nil,1);
			CEnemyCastBar_Show("Debuffs", msg, duration, "afflict", "forceshow", "Ability_ShockWave",nil,nil,1);
			CEnemyCastBar_Show("Stuns", msg, duration, "stuns", "forceshow", "Spell_Frost_Stun",nil,nil,1);
			CEnemyCastBar_Show("DoTs", msg, duration, "dots", "forceshow", "Spell_Shadow_ShadowWordPain",nil,nil,1);

			for k,v in pairs (cecbcolors) do
				for i=1, CEnemyCastBar.bNumBarsSep - 1 do
					CEnemyCastBar_Show("", "", duration, string.lower(v), "forceshow", "",nil,nil,0.2); --alpha only accepted if bars unlocked
				end
			end
		else
			CEnemyCastBar_Show("CastBarFrame", msg, duration, "friendly", "forceshow", "Spell_Holy_GreaterHeal",nil,nil,1);
			for i=1, CEnemyCastBar.bNumBars - 1 do
				CEnemyCastBar_Show("", "", duration, "friendly", "forceshow", "Spell_Holy_GreaterHeal",nil,nil,0.2); --alpha only accepted if bars unlocked
			end

		end

end


-- Options Handler -----------------------
function CEnemyCastBar_Options(msg) --Options
		
	if (msg == "show") then

		if (getglobal("Carni_ECB_1"):GetFrameLevel() < 2) then
			getglobal("Carni_ECB_1"):SetFrameLevel(2); -- fixes wrongly assined levels by earlier NECBs that cause trouble now
		end

		local timeleft = 0;
		if (getglobal("Carni_ECB_1"):IsVisible() and necblockshow) then
			timeleft = getglobal("Carni_ECB_1").endTime - GetTime();
			if (timeleft > 14) then
				timeleft = timeleft + 15;
			end
		end

		CEnemyCastBar_Handler("clear");
		if (CEnemyCastBar.bLocked) then
			CEnemyCastBar_LockPos(); --unlock bars
		end

		local duration = 15;
		if (timeleft > 300) then
			return;
		elseif (timeleft > 15) then
			duration = timeleft;
		end

		CEnemyCastBar_ShowAllBars(duration, "Move this bar!")

		necblockshow = true; -- stops fading in/ alpha manipulation and prevents new bars
		
	elseif (msg == "reset") then

		-- reset can only be applied through the options frame, so it has been loaded ;-)
		CEnemyCastBar_Handler("clear");
		CEnemyCastBar_DefaultVars(); CECB_FPSBarFree:Hide(); CECB_LatencyBarFree:Hide();
		NECBCreateBars(); -- create bars from default values
		CEnemyCastBar_ResetPos(); -- calls flipbars + force full reset until existing maxbars for normal frame (protection if no new bars are created) AND clears UserPlaced value!
		CEnemyCastBar_SetTextSize();
		CEnemyCastBar_SetTexture();
		CEnemyCastBar_SetBorder(); 
		CECB_FPSBarFree:EnableMouse(1); CECB_LatencyBarFree:EnableMouse(1);
		CECBOptionsFrameCECB_scale_Slider:SetValue(CEnemyCastBar.bScale); -- set sliders to default
		CECBOptionsFrameCECB_alpha_Slider:SetValue(CEnemyCastBar.bAlpha);
		CECBPickColorOptions:Hide(); NECBProfilesFrame:Hide(); CECBOptionsFrame:SetAlpha(1);
		CEnemyCastBar_SetBarColors();
		CEnemyCastBar_SetBarColors("SetColors");

		CECB_ReloadOptionsUI();
		CECB_FPSBarFree:SetPoint("TOPLEFT", "UIParent", 50, -550);
		CECB_LatencyBarFree:SetPoint("TOPLEFT", "UIParent", 50, -570);
		CEnemyCastBar.bLocked = false; --forces lock below
		CEnemyCastBar_LockPos();
		CEnemyCastBar_OnEvent("VARIABLES_LOADED");
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r AddOn settings set to |cff99ff99defaults")

	elseif (msg == "globalpvp") then

		if (CEnemyCastBar.bGlobalPvP) then
	
			CEnemyCastBar.bGlobalPvP = false;
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Show all PvP spells in range even w/o a target |cffff9999disabled")
		
		else
		
			CEnemyCastBar.bGlobalPvP = true;

			-- rebuild disabled gains caused by channeling detection:
			for k, v in pairs (CEnemyCastBar_Spells) do
				if (CEnemyCastBar_Spells[k].tdis) then
					CEnemyCastBar_Spells[k].t = CEnemyCastBar_Spells[k].tdis;
					CEnemyCastBar_Spells[k].tdis = nil;
				end
			end
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Show all PvP spells in range even w/o a target |cff99ff99enabled")

		end

		CECB_ReloadOptionsUI();

	elseif (msg == "cdown") then

		if (CEnemyCastBar.bCDown) then

			NECB_CD_DB = { };
			CECBOptionsFrameCECB_usecddb_frameText:SetText(CECB_usecddb_txt);
			CEnemyCastBar.bCDown = false;
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Show some CoolDowns |cffff9999disabled")
		
		else
		
			CEnemyCastBar.bCDown = true;
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Show some CoolDowns |cff99ff99enabled")
		end

		CECB_ReloadOptionsUI();

	elseif (msg == "classdr") then

		if (CEnemyCastBar.bClassDR) then
	
			NECB_DR_DB = { };
			CECBOptionsFrameCECB_classdr_checkText:SetText(CECB_classdr_txt);
			CEnemyCastBar.bClassDR = false;
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Consider Class specific 'Diminishing Return' |cffff9999disabled")
		
		else
		
			CEnemyCastBar.bClassDR = true;
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Consider Class specific 'Diminishing Return' |cff99ff99enabled")

		end

	elseif (msg == "minimap") then

		CECBMiniMapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (80 * cos(356)), (80 * sin(356)) - 52);
		if (CEnemyCastBar.bMiniMap) then
	
			CEnemyCastBar.bMiniMap = false;
			CECBMiniMapButton:Hide();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r MiniMap button |cffff9999disabled")
		
		else
		
			CEnemyCastBar.bMiniMap = true;
			CECBMiniMapButton:Show();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r MiniMap button |cff99ff99enabled")

		end

	elseif (msg == "togglemouse") then

		if (CEnemyCastBar.bMouseBar) then
	
			CEnemyCastBar.bMouseBar = false;
			CEnemyCastBar.bLocked = not CEnemyCastBar.bLocked;
			CEnemyCastBar_LockPos();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r MouseInput |cffff9999disabled")
		
		else
		
			CEnemyCastBar.bMouseBar = true;
			CEnemyCastBar.bLocked = not CEnemyCastBar.bLocked;
			CEnemyCastBar_LockPos();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r MouseInput |cff99ff99enabled")
		
		end

		if (not CEnemyCastBar.bLocked) then
			CEnemyCastBar_Handler("clear");
		end

	elseif (msg == "separatebars") then

		--reset scale or anchor 'jumps'
		CECBOptionsFrameCECB_scale_Slider:SetValue(1.0); -- set sliders to default

		CEnemyCastBar_Handler("clear");
		CECB_ShowHideOptionsUI(); --hide it, because on show changes will be ignored for 0.5 secs

		if (CEnemyCastBar.bSeparateBars) then

			CEnemyCastBar.bSeparateBars = false;
			CEnemyCastBar.bNumBars = 15;
			CEnemyCastBar_ResetPos(); -- resets the anchor points and first bar position + rebuilds the normal frame (FlipBars func)
			NECBCreateBars(); -- if only 9 bars were generated after login :O
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Separate CastBar Types into different frames |cffff9999disabled")
		
		else
	
			CEnemyCastBar.bSeparateBars = true;
			CEnemyCastBar.bNumBars = 9 * CEnemyCastBar.bNumBarsSep; --45
			CEnemyCastBar_ResetPos(); -- resets the anchor points and first bar position, reorders frame
			NECBCreateBars("reset"); -- "reset" forces the new frame order (41, 36, .., 6 stick to 1)
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Separate CastBar Types into different frames |cff99ff99enabled")

		end

		CEnemyCastBar_Options("show");
		CECB_ShowHideOptionsUI();
	end
end

-- Show/hide Options
function CECB_ShowHideOptionsUI()
	if (CECBOptionsFrame:IsVisible()) then
		CECBOptionsFrame:Hide();
	else

		if (CEnemyCastBar.bPvP) then
			--cdown also triggers 'gains', 'globalpvp', 'spellbreak', 'focuspvp'
			CECB_Checkbox_toggle("cdown", "enable");

			if (CEnemyCastBar.bGains) then
				CECB_Checkbox_toggle("gainsonly", "enable");
			else
				CECB_Checkbox_toggle("gainsonly", "disable");
			end

			if (CEnemyCastBar.bGlobalPvP) then
				CECB_Checkbox_toggle("hostileonly", "enable");
			else
				CECB_Checkbox_toggle("hostileonly", "disable");
			end			

		else
			CECB_Checkbox_toggle("cdown", "disable");
			CECB_Checkbox_toggle("gainsonly", "disable");
			CECB_Checkbox_toggle("hostileonly", "disable");
		end

		if (CEnemyCastBar.bShowafflict) then
			-- + 'solo debuffs', raiddebuffs + all DR Checkboxes under 'globalfrag'
			CECB_Checkbox_toggle("globalfrag", "enable");
		else
			CECB_Checkbox_toggle("globalfrag", "disable");
		end

		if (CEnemyCastBar.bPvE) then
			CECBOptionsFrameCECB_pvew_check:Enable();
			CECBOptionsFrameCECB_pvew_checkText:SetText(CECB_pvew_txt);
		else
			CECBOptionsFrameCECB_pvew_check:Disable();
			CECBOptionsFrameCECB_pvew_checkText:SetText("|cffaaaaaa"..CECB_pvew_txt);
		end

		if (CEnemyCastBar.bParseC) then
			CECBOptionsFrameCECB_broadcast_check:Enable();
			CECBOptionsFrameCECB_broadcast_checkText:SetText(CECB_broadcast_txt);
			--CECBOptionsFrameCECB_throtparser_check:Enable();
			--CECBOptionsFrameCECB_throtparser_checkText:SetText(CECB_throtparser_txt);
		else
			CECBOptionsFrameCECB_broadcast_check:Disable();
			CECBOptionsFrameCECB_broadcast_checkText:SetText("|cffaaaaaa"..CECB_broadcast_txt);
			--CECBOptionsFrameCECB_throtparser_check:Disable();
			--CECBOptionsFrameCECB_throtparser_checkText:SetText("|cffaaaaaa"..CECB_throtparser_txt);
		end

		if (CEnemyCastBar.bTimer) then
			CECBOptionsFrameCECB_timerinside_check:Enable();
			CECBOptionsFrameCECB_timerinside_checkText:SetText(CECB_timerinside_txt);
		else
			CECBOptionsFrameCECB_timerinside_check:Disable();
			CECBOptionsFrameCECB_timerinside_checkText:SetText("|cffaaaaaa"..CECB_timerinside_txt);
		end

		if (CEnemyCastBar.bKSoundPvE) then
			CECBOptionsFrameCECB_KSoundPvE_grouped:Enable();
			CECBOptionsFrameCECB_KSoundPvE_groupedText:SetText(CECB_ksoundpvegrouped_txt);
		else
			CECBOptionsFrameCECB_KSoundPvE_grouped:Disable();
			CECBOptionsFrameCECB_KSoundPvE_groupedText:SetText("|cffaaaaaa"..CECB_ksoundpvegrouped_txt);
		end

		if (CEnemyCastBar.bTempFPSBar) then
			CECBOptionsFrameBGFrameFPSBarLock_check:Enable();
			CECBOptionsFrameBGFrameFPSBarLock_checkText:SetText(CECB_lockfps_txt);
		else
			CECBOptionsFrameBGFrameFPSBarLock_check:Disable();
			CECBOptionsFrameBGFrameFPSBarLock_checkText:SetText("|cffaaaaaa"..CECB_lockfps_txt);
		end

		if (CEnemyCastBar.bTempLatencyBar) then
			CECBOptionsFrameBGFrameLatencyBarLock_check:Enable();
			CECBOptionsFrameBGFrameLatencyBarLock_checkText:SetText(CECB_locklatency_txt);
		else
			CECBOptionsFrameBGFrameLatencyBarLock_check:Disable();
			CECBOptionsFrameBGFrameLatencyBarLock_checkText:SetText("|cffaaaaaa"..CECB_locklatency_txt);
		end

		CECBOptionsFrame:Show();
	end
end

function CECB_ReloadOptionsUI()
	CECB_ShowHideOptionsUI();
	CECB_ShowHideOptionsUI();
end

function CECB_Checkbox_toggle(which, todo) --toggle

	if (which == "status") then
	
		if (todo == "enable") then
			CECBOptionsFrameCECB_status_check:Enable();
			CECBOptionsFrameCECB_status_checkText:SetText(CECB_status_txt);

		elseif (CECBOptionsFrameCECB_status_check:IsEnabled() ) then
			CECBOptionsFrameCECB_status_check:Disable();
			CECBOptionsFrameCECB_status_checkText:SetText("|cffaaaaaa"..CECB_status_txt);
		end

	elseif (which == "cdown") then

		local color1 = "";
		if (CEnemyCastBar.bGlobalPvP or CEnemyCastBar.bCDown) then
			color1 = "|cffff9900";
		end
	
		if (todo == "enable") then
			CECBOptionsFrameCECB_cdown_check:Enable();
			CECBOptionsFrameCECB_cdown_checkText:SetText(color1..CECB_cdown_txt);
			CECBOptionsFrameCECB_globalpvp_check:Enable();
			CECBOptionsFrameCECB_globalpvp_checkText:SetText(color1..CECB_globalpvp_txt);
			CECBOptionsFrameCECB_gains_check:Enable();
			CECBOptionsFrameCECB_gains_checkText:SetText(CECB_gains_txt);
			CECBOptionsFrameCECB_focuspvp_check:Enable();
			CECBOptionsFrameCECB_focuspvp_checkText:SetText(CECB_focuspvp_txt);
			CECBOptionsFrameCECB_hiderank_check:Enable();
			CECBOptionsFrameCECB_hiderank_checkText:SetText(CECB_hiderank_txt);

			if (CEnemyCastBar.bFocusPvP) then
				CECBOptionsFrameCECB_focuspvponly_check:Enable();
				CECBOptionsFrameCECB_focuspvponly_checkText:SetText(CECB_focuspvponly_txt);
			else
				CECBOptionsFrameCECB_focuspvponly_check:Disable();
				CECBOptionsFrameCECB_focuspvponly_checkText:SetText("|cffaaaaaa"..CECB_focuspvponly_txt);
			end

			CECBOptionsFrameCECB_hotfilter_check:Enable();
			CECBOptionsFrameCECB_hotfilter_checkText:SetText(CECB_hotfilter_txt);
			CECBOptionsFrameCECB_healonlypvp_check:Enable();
			CECBOptionsFrameCECB_healonlypvp_checkText:SetText(CECB_healonlypvp_txt);

		else
			CECBOptionsFrameCECB_cdown_check:Disable();
			CECBOptionsFrameCECB_cdown_checkText:SetText("|cffaaaaaa"..CECB_cdown_txt);
			CECBOptionsFrameCECB_globalpvp_check:Disable();
			CECBOptionsFrameCECB_globalpvp_checkText:SetText("|cffaaaaaa"..CECB_globalpvp_txt);
			CECBOptionsFrameCECB_gains_check:Disable();
			CECBOptionsFrameCECB_gains_checkText:SetText("|cffaaaaaa"..CECB_gains_txt);
			CECBOptionsFrameCECB_focuspvp_check:Disable();
			CECBOptionsFrameCECB_focuspvp_checkText:SetText("|cffaaaaaa"..CECB_focuspvp_txt);
			CECBOptionsFrameCECB_hiderank_check:Disable();
			CECBOptionsFrameCECB_hiderank_checkText:SetText("|cffaaaaaa"..CECB_hiderank_txt);
			CECBOptionsFrameCECB_focuspvponly_check:Disable();
			CECBOptionsFrameCECB_focuspvponly_checkText:SetText("|cffaaaaaa"..CECB_focuspvponly_txt);
			CECBOptionsFrameCECB_hotfilter_check:Disable();
			CECBOptionsFrameCECB_hotfilter_checkText:SetText("|cffaaaaaa"..CECB_hotfilter_txt);
			CECBOptionsFrameCECB_healonlypvp_check:Disable();
			CECBOptionsFrameCECB_healonlypvp_checkText:SetText("|cffaaaaaa"..CECB_healonlypvp_txt);
		end

	elseif (which == "gainsonly") then
	
		if (todo == "enable") then
			CECBOptionsFrameCECB_gainsonly_check:Enable();
			CECBOptionsFrameCECB_gainsonly_checkText:SetText(CECB_focuspvponly_txt);
			CECBOptionsFrameCECB_pvpswarn_check:Enable();
			CECBOptionsFrameCECB_pvpswarn_checkText:SetText(CECB_pvpswarn_txt);
			CECBOptionsFrameCECB_hotfilter_check:Enable();
			CECBOptionsFrameCECB_hotfilter_checkText:SetText(CECB_hotfilter_txt);

			if (CEnemyCastBar.bPvPSoundWarn) then
				CECBOptionsFrameCECB_screamwarn_check:Enable();
			else
				CECBOptionsFrameCECB_screamwarn_check:Disable();
			end
		else
			CECBOptionsFrameCECB_gainsonly_check:Disable();
			CECBOptionsFrameCECB_gainsonly_checkText:SetText("|cffaaaaaa"..CECB_focuspvponly_txt);
			CECBOptionsFrameCECB_pvpswarn_check:Disable();
			CECBOptionsFrameCECB_pvpswarn_checkText:SetText("|cffaaaaaa"..CECB_pvpswarn_txt);
			CECBOptionsFrameCECB_hotfilter_check:Disable();
			CECBOptionsFrameCECB_hotfilter_checkText:SetText("|cffaaaaaa"..CECB_hotfilter_txt);
			CECBOptionsFrameCECB_screamwarn_check:Disable();
		end

	elseif (which == "hostileonly") then
	
		if (todo == "enable") then
			CECBOptionsFrameCECB_hostileonly_check:Enable();
			CECBOptionsFrameCECB_hostileonly_checkText:SetText(CECB_hostileonly_txt);
		else
			CECBOptionsFrameCECB_hostileonly_check:Disable();
			CECBOptionsFrameCECB_hostileonly_checkText:SetText("|cffaaaaaa"..CECB_hostileonly_txt);
		end

	-- plus 'solo debuffs', plus 'mages cold effects' + raiddebuffs
	elseif (which == "globalfrag") then
	
		if (todo == "enable") then
			CECBOptionsFrameCECB_magecold_check:Enable();
			CECBOptionsFrameCECB_magecold_checkText:SetText(CECB_magecold_txt);
			CECBOptionsFrameCECB_solod_check:Enable();
			CECBOptionsFrameCECB_solod_checkText:SetText(CECB_solod_txt);
			CECBOptionsFrameCECB_globalfrag_check:Enable();
			CECBOptionsFrameCECB_globalfrag_checkText:SetText(CECB_globalfrag_txt);
			CECBOptionsFrameCECB_drtimer_check:Enable();
			CECBOptionsFrameCECB_drtimer_checkText:SetText(CECB_drtimer_txt);
			CECBOptionsFrameCECB_classdr_check:Enable();
			CECBOptionsFrameCECB_classdr_checkText:SetText(CECB_classdr_txt);
			CECBOptionsFrameCECB_sdots_check:Enable();
			CECBOptionsFrameCECB_sdots_checkText:SetText(CECB_sdots_txt);
			CECBOptionsFrameCECB_bossdebuff_check:Enable();
			CECBOptionsFrameCECB_bossdebuff_checkText:SetText(CECB_bossdebuff_txt);
			CECBOptionsFrameCECB_focusdebuffs_check:Enable();
			CECBOptionsFrameCECB_focusdebuffs_checkText:SetText(CECB_focuspvp_txt);

			if (CEnemyCastBar.bFocusDebuffs) then
				CECBOptionsFrameCECB_focusdebuffsonly_check:Enable();
				CECBOptionsFrameCECB_focusdebuffsonly_checkText:SetText(CECB_focuspvponly_txt);
			else
				CECBOptionsFrameCECB_focusdebuffsonly_check:Disable();
				CECBOptionsFrameCECB_focusdebuffsonly_checkText:SetText("|cffaaaaaa"..CECB_focuspvponly_txt);
			end

			if (CEnemyCastBar.bSDoTs) then
				CECBOptionsFrameCECB_turndots_check:Enable();
			else
				CECBOptionsFrameCECB_turndots_check:Disable();
			end

			CECBOptionsFrameCECB_fragonly_check:Enable();
			CECBOptionsFrameCECB_fragonly_checkText:SetText(CECB_fragonly_txt);

		else
			CECBOptionsFrameCECB_magecold_check:Disable();
			CECBOptionsFrameCECB_magecold_checkText:SetText("|cffaaaaaa"..CECB_magecold_txt);
			CECBOptionsFrameCECB_solod_check:Disable();
			CECBOptionsFrameCECB_solod_checkText:SetText("|cffaaaaaa"..CECB_solod_txt);
			CECBOptionsFrameCECB_globalfrag_check:Disable();
			CECBOptionsFrameCECB_globalfrag_checkText:SetText("|cffaaaaaa"..CECB_globalfrag_txt);
			CECBOptionsFrameCECB_drtimer_check:Disable();
			CECBOptionsFrameCECB_drtimer_checkText:SetText("|cffaaaaaa"..CECB_drtimer_txt);
			CECBOptionsFrameCECB_classdr_check:Disable();
			CECBOptionsFrameCECB_classdr_checkText:SetText("|cffaaaaaa"..CECB_classdr_txt);
			CECBOptionsFrameCECB_sdots_check:Disable();
			CECBOptionsFrameCECB_turndots_check:Disable();
			CECBOptionsFrameCECB_sdots_checkText:SetText("|cffaaaaaa"..CECB_sdots_txt);
			CECBOptionsFrameCECB_bossdebuff_check:Disable();
			CECBOptionsFrameCECB_bossdebuff_checkText:SetText("|cffaaaaaa"..CECB_bossdebuff_txt);
			CECBOptionsFrameCECB_focusdebuffs_check:Disable();
			CECBOptionsFrameCECB_focusdebuffs_checkText:SetText("|cffaaaaaa"..CECB_focuspvp_txt);
			CECBOptionsFrameCECB_focusdebuffsonly_check:Disable();
			CECBOptionsFrameCECB_focusdebuffsonly_checkText:SetText("|cffaaaaaa"..CECB_focuspvponly_txt);
			CECBOptionsFrameCECB_fragonly_check:Disable();
			CECBOptionsFrameCECB_fragonly_checkText:SetText("|cffaaaaaa"..CECB_fragonly_txt);
		end

	end
end

-- Show/hide ApplyReset
function CECB_ApplyResetFrame()

	if (CECBApplyResetFrame:IsVisible()) then

		CECBApplyResetFrame:Hide();
		if (not NECB_sub_options_visible() ) then
			CECBOptionsFrame:SetAlpha(1);
		end
	else
		CECBOptionsFrame:SetAlpha(0.5);
		CECBApplyResetFrame:Show();
	end
end

function CECB_Options_Sub(todo, value) --options sub

	local i = 1;
	while (NECBOptionFrameNames[i]) do

		if (todo == "alpha") then
			NECBOptionFrameNames[i]:SetAlpha(value);

		elseif (todo == "hide") then
			NECBOptionFrameNames[i]:Hide();

		elseif (todo == "show") then
			NECBOptionFrameNames[i]:Show();
		end

		i = i + 1;
	end
end

function CEnemyCastBar_Options_OnUpdate() --Menue on update

	if (not cecbmaxsize and CECBOptionsFrame:GetHeight() > (necbmenuesizey - 1)) then
		bgalpha = 1;
		cecbmaxsize = true; cecbminsize = false;
		CECB_Options_Sub("show");
		CECB_Checkbox_toggle("status", "enable");
	elseif (not cecbminsize and CECBOptionsFrame:GetHeight() < (necbmshrinksizey + 1)) then
		bgalpha = 0;
		cecbminsize = true; cecbmaxsize = false;
		CECB_Options_Sub("hide");
		CECB_Checkbox_toggle("status", "enable");
	end

	local framerate = GetFramerate();
	local stepping = 2/framerate;
	if (stepping > 0.4 ) then stepping = 0.4; -- security for very low fps (< 5fps)
	end

	if (CEnemyCastBar.bCDown and CEnemyCastBar.bPvP) then
		CECBOptionsFrameCECB_usecddb_frame:SetAlpha(1);
		CECBOptionsFrameCDDBReset:SetAlpha(1);
		if (#NECB_CD_DB > 0) then
			CECBOptionsFrameCDDBReset:Enable();
		else
			CECBOptionsFrameCDDBReset:Disable();
		end
	else
		CECBOptionsFrameCECB_usecddb_frame:SetAlpha(0.5);
		CECBOptionsFrameCDDBReset:SetAlpha(0.5);
		CECBOptionsFrameCDDBReset:Disable();
	end
	CECBOptionsFrameCECB_usecddb_frameText:SetText(CECB_usecddb_txt.." |cffaaaaaa"..#NECB_CD_DB.."/50");

	if (CEnemyCastBar.bClassDR and CEnemyCastBar.bShowafflict) then
		CECBOptionsFrameCECB_classdr_checkText:SetText(CECB_classdr_txt.." |cffaaaaaa"..#NECB_DR_DB.."/15");
	end

-- now we start
	if (necbfademenue == 1) then
		local malpha = CECBOptionsFrame:GetAlpha() - stepping*2;
		if (malpha > 0) then
			CECBOptionsFrame:SetAlpha(malpha);
		else
			CECBOptionsFrame:Hide();
			necbfademenue = false;
		end

	elseif (necbfademenue == 2) then
		local malpha = CECBOptionsFrame:GetAlpha() + stepping*2;
		if (malpha < 1) then
			CECBOptionsFrame:SetAlpha(malpha);
		else
			NECBUnLockSliders = true; -- fix for WoW 2.3, see below in sliders section; allow ValueChanged functions of sliders to work now
			CECBOptionsFrame:SetAlpha(1);
			necbfademenue = false;
		end
	end

	if (not CEnemyCastBar.bStatus) then

		if (not cecbminsize) then

			local optionsheight = CECBOptionsFrame:GetHeight();
			local optionswidth = CECBOptionsFrame:GetWidth();
			if ((optionsheight - stepping*200) > (necbmshrinksizey +1)) then
				CECB_Checkbox_toggle("status", "disable");
				optionsheight = optionsheight - stepping*200;
				CECBOptionsFrame:SetHeight(optionsheight);
				
				if ((optionswidth - stepping*200) > (necbmshrinksizex +1)) then
					optionswidth = optionswidth - stepping*200;
					CECBOptionsFrame:SetWidth(optionswidth);
				else
					CECBOptionsFrame:SetWidth(necbmshrinksizex);
				end
	
				if ((bgalpha - stepping) >= 0) then bgalpha = bgalpha - stepping;
					CECB_Options_Sub("alpha", bgalpha);
					CECBOptionsFrameBGFrame1:SetBackdropBorderColor(1 - bgalpha, 0, 0);
				else
					CECB_Options_Sub("alpha", 0);
				end

			else
				CECB_Options_Sub("hide");
				CECBOptionsFrame:SetHeight(necbmshrinksizey);
			end
		end

	elseif (not cecbmaxsize) then

		local optionsheight = CECBOptionsFrame:GetHeight();
		local optionswidth = CECBOptionsFrame:GetWidth();
		CECBOptionsFrameBGFrame1:SetBackdropBorderColor(0.4, 0.4, 0.4);

		CECB_Options_Sub("show");

		if ((optionsheight + stepping*200) < (necbmenuesizey -1)) then
			CECB_Checkbox_toggle("status", "disable");
			optionsheight = optionsheight + stepping*200;
			CECBOptionsFrame:SetHeight(optionsheight);

			if ((optionswidth + stepping*200) < (necbmenuesizex -1)) then
				optionswidth = optionswidth + stepping*200;
				CECBOptionsFrame:SetWidth(optionswidth);
			else
				CECBOptionsFrame:SetWidth(necbmenuesizex);
			end

			if ((bgalpha + stepping) <= 1) then bgalpha = bgalpha + stepping;
				CECB_Options_Sub("alpha", bgalpha);
			else
				CECB_Options_Sub("alpha", 1);
			end
		else
			CECBOptionsFrame:SetHeight(necbmenuesizey);
			CECB_Options_Sub("alpha", 1);
		end
	end
end

function CECB_scale_Slider_OnShow()
	getglobal(this:GetName().."High"):SetText("180%");
	getglobal(this:GetName().."Low"):SetText("50%");

	getglobal(this:GetName() .. "Text"):SetText(CECB_scale_txt .."|cffffffff".. CEnemyCastBar.bScale * 100 .. "%");

	this:SetMinMaxValues(0.5, 1.8);
	this:SetValueStep(0.1);
	this:SetValue(CEnemyCastBar.bScale);
end

function CECB_scale_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	local delta = abs(CEnemyCastBar.bScale - this:GetValue()) * 100;
	local BarScaleOld = CEnemyCastBar.bScale;
	-- DEFAULT_CHAT_FRAME:AddMessage("old: " .. CEnemyCastBar.bScale .. " | new: " .. this:GetValue() .." | delta "..delta)

	CEnemyCastBar.bScale = this:GetValue() * 10;

	if (CEnemyCastBar.bScale < 0) then
		CEnemyCastBar.bScale = ceil(CEnemyCastBar.bScale - 0.5)
	else
		CEnemyCastBar.bScale = floor(CEnemyCastBar.bScale + 0.5)
	end

	CEnemyCastBar.bScale = CEnemyCastBar.bScale / 10;

	getglobal(this:GetName() .. "Text"):SetText(CECB_scale_txt .."|cffffffff".. CEnemyCastBar.bScale * 100 .. "%");

	if (delta >= 1) then

		CEnemyCastBar_Handler("clear");
	
		local BarScaleFactor = BarScaleOld / CEnemyCastBar.bScale;

		-- set all bar points
		if (CEnemyCastBar.tFramePoints) then -- only set points if already catched them; otherwise they will be generated in Enter_World

			for k,v in pairs (CEnemyCastBar.tFramePoints) do
				if (getglobal(k) and k ~= "CECB_FPSBarFree" and k ~= "CECB_LatencyBarFree") then

					local frame = getglobal(k);
					local point, _, _, x, y = frame:GetPoint();
					x = x * BarScaleFactor;
					y = y * BarScaleFactor;

					CEnemyCastBar.tFramePoints[k] = { x,y,point };
					frame:SetPoint(point, "UIParent", point, x, y );
				end
			end
		end

		CEnemyCastBar_FlipBars(); -- sets the scale, too!
		CEnemyCastBar_ShowAllBars(5, "Scale of CastBars");

	end

end


function CECB_alpha_Slider_OnShow()
	getglobal(this:GetName().."High"):SetText("1");
	getglobal(this:GetName().."Low"):SetText("0.1");

	getglobal(this:GetName() .. "Text"):SetText(CECB_alpha_txt .."|cffffffff".. CEnemyCastBar.bAlpha);

	this:SetMinMaxValues(0.1, 1.0);
	this:SetValueStep(0.1);
	this:SetValue(CEnemyCastBar.bAlpha);
end

function CECB_alpha_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	local delta = abs(CEnemyCastBar.bAlpha - this:GetValue()) * 100;

	CEnemyCastBar.bAlpha = this:GetValue() * 10;
	if (CEnemyCastBar.bAlpha < 0) then
		CEnemyCastBar.bAlpha = ceil(CEnemyCastBar.bAlpha - 0.5)
	else
		CEnemyCastBar.bAlpha = floor(CEnemyCastBar.bAlpha + 0.5)
	end
	CEnemyCastBar.bAlpha = CEnemyCastBar.bAlpha / 10;

	getglobal(this:GetName() .. "Text"):SetText(CECB_alpha_txt .."|cffffffff".. CEnemyCastBar.bAlpha);

	if (delta >= 1) then
		CEnemyCastBar_Handler("clear");
		CEnemyCastBar_ShowAllBars(5, "Transparency of CastBars");
	end
end

function CECB_numbars_Slider_OnShow()

	NECBDestroyUpdate = GetTime(); -- prevents on numbars slider update for 0.5 secs!
	if (CEnemyCastBar.bSeparateBars) then

		getglobal(this:GetName().."High"):SetText("54");
		getglobal(this:GetName().."Low"):SetText("9");
	
		getglobal(this:GetName() .. "Text"):SetText(CECB_numbars_txt .."|cffffffff".. CEnemyCastBar.bNumBarsSep * 9);
		getglobal(this:GetName()).tooltipText = CECB_numbars_tooltip..CECB_numbarssep_tooltip;
	
		this:SetMinMaxValues(9, 54);
		this:SetValueStep(9);
		this:SetValue(CEnemyCastBar.bNumBarsSep * 9);
	else
		getglobal(this:GetName().."High"):SetText("25");
		getglobal(this:GetName().."Low"):SetText("5");
	
		getglobal(this:GetName() .. "Text"):SetText(CECB_numbars_txt .."|cffffffff".. CEnemyCastBar.bNumBars);
		getglobal(this:GetName()).tooltipText = CECB_numbars_tooltip;
	
		this:SetMinMaxValues(5, 25);
		this:SetValueStep(1);
		this:SetValue(CEnemyCastBar.bNumBars);
	end
end

function CECB_numbars_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	if (NECBDestroyUpdate and GetTime() - NECBDestroyUpdate < 0.5) then

		local numbars = CEnemyCastBar.bNumBars;
		if (CEnemyCastBar.bSeparateBars) then
			numbars = CEnemyCastBar.bNumBarsSep * 9;
		end
		getglobal(this:GetName() .. "Text"):SetText(CECB_numbars_txt .."|cffffffff".. numbars);

		return;
	else
		NECBDestroyUpdate = false;
	end

	if (CEnemyCastBar.bSeparateBars) then

		local delta = abs(CEnemyCastBar.bNumBarsSep * 9 - this:GetValue()) * 10;
	
		if (delta >= 1) then
	
			CEnemyCastBar_Handler("clear");
	
			CEnemyCastBar.bNumBarsSep = this:GetValue() / 9;
			CEnemyCastBar.bNumBars = CEnemyCastBar.bNumBarsSep * 9;
			CEnemyCastBar_ResetPos(); -- resets the anchor points and first bar posi
			NECBCreateBars("reset"); -- "reset" forces the new frame order (41, 36, .., 6 stick to 1)

			getglobal(this:GetName() .. "Text"):SetText(CECB_numbars_txt .."|cffffffff".. CEnemyCastBar.bNumBarsSep * 9);
		
			CEnemyCastBar_Options("show");

	
		end

	else
		local delta = abs(CEnemyCastBar.bNumBars - this:GetValue()) * 10;
		--DEFAULT_CHAT_FRAME:AddMessage("old: " .. CEnemyCastBar.bNumBars .. " | new: " .. this:GetValue() .." | delta "..delta)
	
		if (delta >= 1) then
	
			CEnemyCastBar_Handler("clear");
	
			CEnemyCastBar.bNumBars = this:GetValue();
			if (not getglobal("Carni_ECB_"..CEnemyCastBar.bNumBars)) then
				NECBCreateBars(); -- create new bars
			end
		
			getglobal(this:GetName() .. "Text"):SetText(CECB_numbars_txt .."|cffffffff".. CEnemyCastBar.bNumBars);

			CEnemyCastBar_ShowAllBars(5, "Number of CastBars!");
	
		end
	end

	NECB_calc_performa("reset");
	--DEFAULT_CHAT_FRAME:AddMessage(CEnemyCastBar.bNumBars)
end

function CECB_space_Slider_OnShow()
	getglobal(this:GetName().."High"):SetText("25");
	getglobal(this:GetName().."Low"):SetText("12");

	getglobal(this:GetName() .. "Text"):SetText(CECB_space_txt .."|cffffffff".. CEnemyCastBar.bSpace);

	this:SetMinMaxValues(12, 25);
	this:SetValueStep(1);
	this:SetValue(CEnemyCastBar.bSpace);
end

function CECB_space_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	local delta = abs(CEnemyCastBar.bSpace - this:GetValue()) * 10;

	if (delta >= 1) then

		CEnemyCastBar_Handler("clear");
	
		CEnemyCastBar.bSpace = this:GetValue();
	
		getglobal(this:GetName() .. "Text"):SetText(CECB_space_txt .."|cffffffff".. CEnemyCastBar.bSpace);
	
		CEnemyCastBar_FlipBars(); -- sets the space, too!

		CEnemyCastBar_ShowAllBars(5, "Space between CastBars!");
	end
end

function CECB_blength_Slider_OnShow()
	getglobal(this:GetName().."High"):SetText("+100");
	getglobal(this:GetName().."Low"):SetText("-50");

	if (CEnemyCastBar.bnecbCBLBias >= 0) then
		getglobal(this:GetName() .. "Text"):SetText(CECB_blength_txt .."|cffffffff+" .. CEnemyCastBar.bnecbCBLBias);
	else
		getglobal(this:GetName() .. "Text"):SetText(CECB_blength_txt .."|cffffffff".. CEnemyCastBar.bnecbCBLBias);
	end

	this:SetMinMaxValues(-50, 100);
	this:SetValueStep(10);
	this:SetValue(CEnemyCastBar.bnecbCBLBias);
end

function CECB_blength_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	local delta = abs(CEnemyCastBar.bnecbCBLBias - this:GetValue()) * 10;

	if (delta >= 1) then

		CEnemyCastBar_Handler("clear");
	
		CEnemyCastBar.bnecbCBLBias = this:GetValue();
	
		if (CEnemyCastBar.bnecbCBLBias >= 0) then
			getglobal(this:GetName() .. "Text"):SetText(CECB_blength_txt .."|cffffffff+" .. CEnemyCastBar.bnecbCBLBias);
		else
			getglobal(this:GetName() .. "Text"):SetText(CECB_blength_txt .."|cffffffff".. CEnemyCastBar.bnecbCBLBias);
		end
	
		CEnemyCastBar_FlipBars(); -- sets the width, too!

		CEnemyCastBar_ShowAllBars(5, "Width of CastBars!");
	end
end

function CECB_texture_Slider_OnShow()
	getglobal(this:GetName().."High"):SetText((#NECB_Textures - 1));
	getglobal(this:GetName().."Low"):SetText("0");

		getglobal(this:GetName() .. "Text"):SetText(CECB_texture_txt .."|cffffffff" .. CEnemyCastBar.bBarTexture.."|r - |cffffffff"..NECB_Textures[CEnemyCastBar.bBarTexture + 1]);

	this:SetMinMaxValues(0, (#NECB_Textures - 1));
	this:SetValueStep(1);
	this:SetValue(CEnemyCastBar.bBarTexture);
end

function CECB_texture_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	local delta = abs(CEnemyCastBar.bBarTexture - this:GetValue()) * 10;

	if (delta >= 1) then

		CEnemyCastBar_Handler("clear");
	
		CEnemyCastBar.bBarTexture = this:GetValue();
		getglobal(this:GetName() .. "Text"):SetText(CECB_texture_txt .."|cffffffff" .. CEnemyCastBar.bBarTexture.."|r - |cffffffff"..NECB_Textures[CEnemyCastBar.bBarTexture + 1]);
	
		CEnemyCastBar_SetTexture();

		CEnemyCastBar_ShowAllBars(5, "Texture of CastBars!");
	end
end

function CECB_font_Slider_OnShow()
	getglobal(this:GetName().."High"):SetText((#NECB_Fonts - 1)); -- dynamically set now, no need to change :D
	getglobal(this:GetName().."Low"):SetText("0");

		getglobal(this:GetName() .. "Text"):SetText(CECB_font_txt .."|cffffffff" .. CEnemyCastBar.bBarFont.."|r - |cffffffff"..NECB_Fonts[CEnemyCastBar.bBarFont + 1].name);

	this:SetMinMaxValues(0, #NECB_Fonts - 1); -- dynamically set now, no need to change :D
	this:SetValueStep(1);
	this:SetValue(CEnemyCastBar.bBarFont);
end

function CECB_font_Slider_OnValueChanged()

	if (not NECBUnLockSliders) then return end; -- fix for WoW 2.3 :/ they changed something, OnShow is delayed

	local delta = abs(CEnemyCastBar.bBarFont - this:GetValue()) * 10;

	if (delta >= 1) then

		CEnemyCastBar_Handler("clear");
	
		CEnemyCastBar.bBarFont = this:GetValue();
		getglobal(this:GetName() .. "Text"):SetText(CECB_font_txt .."|cffffffff" .. CEnemyCastBar.bBarFont.."|r - |cffffffff"..NECB_Fonts[CEnemyCastBar.bBarFont + 1].name);
	
		CEnemyCastBar_SetTextSize();

		CEnemyCastBar_ShowAllBars(5, "Font of CastBars!");
	end
end

--Color wheel functions
function CEnemyCastBar_ColorWheel()
	local button = this;
	local cecboldcolor1 = CEnemyCastBar.tColor[button:GetID()][1];
	local cecboldcolor2 = CEnemyCastBar.tColor[button:GetID()][2];
	local cecboldcolor3 = CEnemyCastBar.tColor[button:GetID()][3];
	ColorPickerFrame.func = function() CEnemyCastBar_SetBarColor(button) end;
	ColorPickerFrame:SetColorRGB(button[1], button[2], button[3]);
	ColorPickerFrame.cancelFunc = function() CEnemyCastBar_SetBarColor(button, cecboldcolor1, cecboldcolor2, cecboldcolor3) end;
	ColorPickerFrame:Show();
end

function CEnemyCastBar_SetBarColor(button, r, g, b)
	if (not r) then
		--Set Bar Color from color wheel
		local r,g,b = ColorPickerFrame:GetColorRGB();
		CEnemyCastBar_SetBarColorSub(button, r, g, b);
	else
		--Restore old colors, canceled
		CEnemyCastBar_SetBarColorSub(button, r, g, b)
	end
end

function CEnemyCastBar_SetBarColorSub(button, r, g, b)
	local CECBno = button:GetID();
	getglobal("CECBPickColorOptions_"..cecbcolors[CECBno].."NormalTexture"):SetVertexColor(r, g, b);

	CEnemyCastBar.tColor[CECBno][1] = r;
	CEnemyCastBar.tColor[CECBno][2] = g;
	CEnemyCastBar.tColor[CECBno][3] = b;

	for j=1, 3 do
		getglobal("CECBPickColorOptions_"..cecbcolors[CECBno])[j] = CEnemyCastBar.tColor[CECBno][j];
	end
end

function CEnemyCastBar_ShowHideColorOptions(msg)

	if ( CECBPickColorOptions:IsVisible() or msg == "hide") then

		CECBPickColorOptions:Hide();
		if (msg ~= "hide") then
			if (not NECB_sub_options_visible() ) then
				CECBOptionsFrame:SetAlpha(1);
			end
		end
	else
		CECBOptionsFrame:SetAlpha(0.5);
		CECBPickColorOptions:Show();
	end
end


--profiles
function NECB_scramble_settings(table)

	if (not table or type(table) ~= "table") then
		return;
	end
	
	local ret = {};
	for k, v in pairs (table) do
		if (type(v) == "table") then
			ret[k] = NECB_scramble_settings(v);
		else
			ret[k] = v;
		end
	end
	return ret;
end


function NECB_save_profile(number)

	if (not NECB_global_profile) then
		NECB_global_profile = { };
	end

	NECB_global_profile[number] = NECB_scramble_settings(CEnemyCastBar);
	local num = tonumber(string.match(this:GetName(), "(%d+)"));
	local profilename = getglobal("NECBProfilesFrame_EditBox"..num):GetText();
	if (profilename == "empty" or profilename == "") then
		profilename = UnitName("player").." - "..GetRealmName();
	end	
	NECB_global_profile[number]["ProfileID"] = { profilename, CECB_status_version_txt };
	NECB_check_profiles();

	DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Profile '|cffffff00"..profilename.."|r' has been |cffff9999saved|r to |cffffff00slot "..num.."|r!")
end

function NECB_load_profile(number)

	CEnemyCastBar_Handler("clear");
	NECB_check_profiles(); -- reload unchanged names

	-- checken ob berhaupt profil vorhanden! ggf. multiple profile zulassen?
	CEnemyCastBar = NECB_scramble_settings(NECB_global_profile[number]);

	CECBMiniMapButtonTexture:SetTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\CECBButton");
	CECB_FPSBarFree:Hide(); CECB_LatencyBarFree:Hide();
	CECB_FPSBarFree:EnableMouse(1); CECB_LatencyBarFree:EnableMouse(1);

	CEnemyCastBar_OnEvent("VARIABLES_LOADED");

	local num = tonumber(string.match(this:GetName(), "(%d+)"));
	local profilename = getglobal("NECBProfilesFrame_EditBox"..num):GetText();
	DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Profile '|cffffff00"..profilename.."|r' has been |cffff9999loaded|r from |cffffff00slot "..num.."|r!")

	necbalreadywarned = false; -- redo init
	CEnemyCastBar_OnEvent("PLAYER_ENTERING_WORLD");

	CEnemyCastBar_FlipBars(); -- reorder frame, set icon, space, width for bars
	CEnemyCastBar_SetTextSize();	CEnemyCastBar_SetBorder();	CEnemyCastBar_SetTexture();	CEnemyCastBar_SetIcon();
	CEnemyCastBar.bLocked = false;	CEnemyCastBar_LockPos();

	if (CECB_ReloadOptionsUI) then
		CECBOptionsFrameCECB_scale_Slider:SetValue(CEnemyCastBar.bScale);
		CECBOptionsFrameCECB_alpha_Slider:SetValue(CEnemyCastBar.bAlpha);
		CECBPickColorOptions:Hide();
		CECB_ReloadOptionsUI();
	end

	NECBButton_OnEnter(true);

	CEnemyCastBar["ProfileID"] = nil; -- remove ID tag for character settings
end

function NECB_check_profiles()

	-- check for profiles and disable load buttons
	for i=1,5 do
		local text;
		if (NECB_global_profile and NECB_global_profile[i] and NECB_global_profile[i]["ProfileID"]) then
			text = NECB_global_profile[i]["ProfileID"][1];
		end
		if (text) then
			getglobal("NECBProfilesFrame_EditBox"..i):SetText(text);
			getglobal("NECBProfilesFrame_EditBox"..i.."_X"):Show();
			getglobal("NECBProfilesFrame_Load"..i):Enable();
		else
			getglobal("NECBProfilesFrame_EditBox"..i):SetText("empty");
			getglobal("NECBProfilesFrame_EditBox"..i.."_X"):Hide();
			getglobal("NECBProfilesFrame_Load"..i):Disable();
		end
		getglobal("NECBProfilesFrame_EditBox"..i):ClearFocus();
	end
end


function NECB_ShowHideProfiles()

	if ( NECBProfilesFrame:IsVisible() ) then

		NECBProfilesFrame:Hide();
		if (not NECB_sub_options_visible() ) then
			CECBOptionsFrame:SetAlpha(1);
		end
	else
		CECBOptionsFrame:SetAlpha(0.5);
		NECBProfilesFrame:Show();
	end
end

function NECB_sub_options_visible()

	local value;
	if (CECBPickColorOptions:IsVisible() or NECBProfilesFrame:IsVisible() or CECBApplyResetFrame:IsVisible() ) then
		value = true;
	end
	return value;
end

function NECB_bctimer_options()

	if (GetNumPartyMembers() ~= 0 or GetNumRaidMembers() ~= 0 ) then

		local found = NECB_Check_PvECDs(); -- search and BC timers
		if (not found) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff0000No|r PvE respawn timer found!");
		end

	else 
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group/Raid to broadcast cooldowns/respawn timers!")
	end
end

function NECB_bctimer_button_state()

	if (necb_bctimer_checked and GetTime() - necb_bctimer_checked > 1) then

		necb_bctimer_checked = GetTime();
		if (CEnemyCastBar_Raids ~= { } and (GetNumPartyMembers() ~= 0 or GetNumRaidMembers() ~= 0) ) then
		
			local minbar, maxbar = 1, CEnemyCastBar.bNumBars;
			if (CEnemyCastBar.bSeparateBars) then
				minbar, maxbar = 7 * CEnemyCastBar.bNumBarsSep + 1, 8 * CEnemyCastBar.bNumBarsSep; --36, 40 Cooldown Bars
			end

			for i=minbar, maxbar do
		
				local spell = getglobal("Carni_ECB_"..i).spell;
				if (spell and CEnemyCastBar_Raids[spell] and CEnemyCastBar_Raids[spell].global and getglobal("Carni_ECB_"..i).ctype == "cooldown") then -- PvE Cooldown
					CECBOptionsFramebctimer:Enable();
					return;
				end
			end

		end
		CECBOptionsFramebctimer:Disable();

	elseif (not necb_bctimer_checked) then
		necb_bctimer_checked = GetTime() - 1;
	end
end

function NECB_calc_performa(reset)

	if (not NECB_perform_estima) then NECB_perform_estima = 0; end -- fix for people who had NECB disabled and didn't get through register events

	-- 'reset' to basic (registered counter) needed if option does not register events (reset in register funnction, too)
	if (reset and NECB_perform_estima_basic) then NECB_perform_estima = NECB_perform_estima_basic;
	else NECB_perform_estima_basic = NECB_perform_estima; end

	if (CEnemyCastBar.bGlobalPvP and CEnemyCastBar.bPvP) then NECB_perform_estima = NECB_perform_estima + 4; end
	if (CEnemyCastBar.bCDown and CEnemyCastBar.bPvP) then NECB_perform_estima = NECB_perform_estima + 2; end

	if (CEnemyCastBar.bPvE) then NECB_perform_estima = NECB_perform_estima + 1; end	

	if (CEnemyCastBar.bDRTimer and CEnemyCastBar.bShowafflict) then NECB_perform_estima = NECB_perform_estima + 1; end
	if (CEnemyCastBar.bClassDR and CEnemyCastBar.bShowafflict) then NECB_perform_estima = NECB_perform_estima + 1; end

	if (CEnemyCastBar.bFocusPvP and CEnemyCastBar.bPvP and not CEnemyCastBar.bFocusPvPOnly) then NECB_perform_estima = NECB_perform_estima + 1.5; end
	if (CEnemyCastBar.bFocusDebuffs and CEnemyCastBar.bShowafflict and not CEnemyCastBar.bFocusDebuffsOnly) then NECB_perform_estima = NECB_perform_estima + 1; end

	if (CEnemyCastBar.bParseC) then NECB_perform_estima = NECB_perform_estima + 1; end
	if (CEnemyCastBar.bAllowParser) then NECB_perform_estima = NECB_perform_estima + 1; end

	if (CEnemyCastBar.bSeparateBars) then NECB_perform_estima = NECB_perform_estima + ( 3 * CEnemyCastBar.bNumBars / 54 );
	else NECB_perform_estima = NECB_perform_estima + (3 * CEnemyCastBar.bNumBars / 25 ); end -- +1

	if (CEnemyCastBar.bTempFPSBar) then NECB_perform_estima = NECB_perform_estima + 0.5; end

	--if (not CEnemyCastBar.bStatus) then NECB_perform_estima = 1; end

	
	local procent = ceil ( (NECB_perform_estima / 59.2) * 1000 ) / 1000;

	if (procent > 1) then
		procent = 1;
		--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r ERROR in Performance calculation! Tell Naturfreund that 'procent > 1'", 1, 0.5, 0);
	end

	--DEFAULT_CHAT_FRAME:AddMessage(NECB_perform_estima.."-"..procent);--

	CECBOptionsFrameCECB_PerfomaEsti1_frame:SetWidth( (240 * procent) );
	CECBOptionsFrameCECB_PerfomaEsti1_frame:SetBackdropColor(procent, (1 - procent), 0.1, 1);

	CECBOptionsFrameCECB_PerfomaEsti2_frameText:SetText(CECB_performest_txt.."|cffffffff"..(procent*100).."%")

end