--[[
========== Enemy CastBar Custom Spell Database =========================================

Instead of using this lines like in the original localization.lua:

	["Unstable Power"] = 		{ t=20.0, d=120, icontex="Spell_Lightning_LightningBolt01" };

you have to use this way to add spells:

	CEnemyCastBar_Spells["Unstable Power"] = { t=20.0, d=120, icontex="Spell_Lightning_LightningBolt01" };

Same for "CEnemyCastBar_Raids" and "CEnemyCastBar_Afflictions" spells :D
========================================================================================


A short description of the spell flags exctracted from the original localization.lua:
-------------------------------------------------------------------------------------

".._Afflictions" ->
-- Warning: only add Spells with the "CEnemyCastBar_SPELL_AFFLICTED" pattern here!
-- fragile="true", if mob with the same name dies, the bar won't be removed; Multiple bars allowed and displayed even if not targetted (optional)
-- multi="true", the bar is not removed if debuff fades earlier (usefull if one spell is allowed to produce multiple afflictions)
-- stun="true", flags all spells which use the same Diminishing Return timer. These 8 Spells were tested to use one and the same timer.
-- death="true", removes the castbar although it is a "fragile"
-- periodicdmg="true" -> don't update and remove those castbars, only allows periodic damage done by yourself
-- spellDR triggers a separate class DR Timer if spellDR="PlayersCLASS";
-- affmob="true", this stun triggers a class specific DR Timer on a mob (not player), too
-- drshare="name", all spells with the same drshare name will trigger the same DR Timer called 'name'
-- checkclass="classname", will only show this spell to specified class
-- tskill={talentTab, talentNumber, talentTimeBonus, talentClass, offset, relativeTimeBonus(optional) }, adds "talentTimeBonus" to the duration of this skill dependend on invested skillpoints! "Offset" is additionally added to the duration if more than one talentpoint is invested.
-- more to tskill: if "talentTimeBonus" is 0 then the relativeTimeBonus(optional) is used (percentage), needed for hunters talent
-- plevel={durationBonusPerSkillLevel, PlayerLevelAbleToLearnNewSkillLevel (e.g. 60, 40, 20), exchangeLowestLevelWith "0" ALWAYS!} (correct examples are below)
-- blockZone="ZoneName" blocks the spell for the specified Zone (example: blockZone="Ahn'Qiraj" for 'Entangling Roots')
-- cpinterval=X, reduces spell duration by X for every ComboPoint lower than 5 (maximum); ALWAYS use with cpclass="CHARACTERCLASS"!
-- norenew=true won't update or trigger a castbar for this spell for "UNIT_SPELLCAST_SUCCEEDED"
-- flying=true will add some time to the renew buff/debuff miss/resist system depending on the distance to the target (flying spells need from 0,2 to 1,4 seconds to hit their target and return a message)
-- notdetected=true, use for spells not detected by combatlog messages ONLY! Will trigger a bar only for the player who casted it.
-- spellbreaker=true indicates that this bar shall only be triggered if a spell interruption of your target has been detected
-- cando="CLASS", will apply a green shadow to normal Debuffs that are castable by the player's class.
-- rankmod={durationMalusPerRank, rankhigh, ranklower, ranklowest...}, reduces spell duration by rank used, example: "Frostbolt"
-- callspell={SpellName, talentTab, talentNumber, checkValue}, the update feature will use this spell instead and in case this is used with a spell that triggers its own bar, this will trigger a 'callspell' bar simultaniously after resist/miss checks! :D
-- pvpdur=X, when used versus other Players the duration X is used!

]]

	-- pls tell me at curse-gaming.com what you add here! Maybe I will add it to the official version then ;-) Thanks :D
	-- enter your spells here:

	-- Some EXAMPLES (remove '--' in front of the Spell's line to have a working detection ^^):

	-- Mage afflictions
	--CEnemyCastBar_Afflictions["Pyroblast"] = {t=12, periodicdmg="true", icontex="Spell_Fire_Fireball02"};
	--CEnemyCastBar_Afflictions["Fireball"] = {t=8, periodicdmg="true", icontex="Spell_Fire_FlameBolt"};
	--CEnemyCastBar_Afflictions["Ignite"] = {t=4, periodicdmg="true", icontex="Spell_Fire_Incinerate"};

	-- Warrior afflictions (Remember renewed debuffs trigger NO combatlog message! NECB won't recognize it without combatlog messages!)
	--CEnemyCastBar_Afflictions["Sunder Armor"] = {t=30, cando="WARRIOR", checkclass="WARRIOR", stacks=true, icontex="Ability_Warrior_Sunder"};

	CEnemyCastBar_Afflictions["YourSpell"] = { t=00.0, icontex="ValidTextureFile or leave blank/delete" };