--[[ $Id: Core.lua 68737 2008-04-09 10:24:22Z borlox $ ]]--
local CCopy = LibStub("AceAddon-3.0"):NewAddon("CCopy", "AceTimer-3.0", "AceHook-3.0")

local CLEANUP_DELAY = 600 -- 10 minutes
local KEEP_NUM_MESSAGES = 20

local link_msg = "|HCCopy:%d|h%s|h %s"
local find_id  = "^CCopy:(%d+)"

local ChatFrameEditBox = ChatFrameEditBox

function CCopy:OnInitialize()
	self.messages = {} -- this table is getting realy! big after some time, so it's cleared out every 10 minutes
	self.dot = '*'
end

function CCopy:OnEnable()
	self:RawHook("SetItemRef", true)
	local _G = _G
	for i=1, NUM_CHAT_WINDOWS do
		self:RawHook(_G["ChatFrame"..i], "AddMessage", true)
	end
	self:ScheduleRepeatingTimer("CleanUp", CLEANUP_DELAY)
end

function CCopy:ClearMessage(msg)
	msg = msg:gsub("|H.-|h(.-)|h", "%1")	-- clear links
	msg = msg:gsub("|c%x%x%x%x%x%x%x%x(.-)|r", "%1") -- clear colors
	return msg
end

function CCopy:ShowMessage(id)
	local msg = self.messages[id]
	msg = self:ClearMessage(msg)
	
	ChatFrameEditBox:SetText(ChatFrameEditBox:GetText() .. msg)
	if not ChatFrameEditBox:IsShown() then
		ChatFrameEditBox:Show()
		ChatFrameEditBox:HighlightText()
	end
end

function CCopy:AddMessage(chatFrame, msg, ...)
	local id = #self.messages + 1
	self.messages[id] = msg
	msg = link_msg:format(id, self.dot, msg)
	self.hooks[chatFrame].AddMessage(chatFrame, msg, ...)
end

function CCopy:SetItemRef(link, ...)
	if link:sub(1, 5) == "CCopy" then
		local _,_,id = link:find(find_id)
		self:ShowMessage(tonumber(id))
	else
		self.hooks.SetItemRef(link, ...)
	end
end

function CCopy:CleanUp()
	local messages = self.messages
	local newMessages = {}
	for i=(#messages - KEEP_NUM_MESSAGES), #messages do
		newMessages[i] = messages[i]
	end
	self.messages = newMessages
	if not InCombatLockdown() then
		collectgarbage("collect")
	end
end
