--[[ HKitty for ButtonFacade ]]

local LibButtonFacade = LibStub("LibButtonFacade",true)
if not LibButtonFacade then
	return
end

LibButtonFacade:AddSkin("HelloKitty",{
	Backdrop = {
		Width = 46,
		Height = 46,
		Color = {1, 1, 1, 1},
		Texture = [[Interface\AddOns\ButtonFacade_HKitty\textures\HKittyBase]],
	},
	Icon = {
		Width = 26,
		Height = 25,
		TexCoords = {0.07,0.93,0.07,0.93},
	},
	Flash = {
		Width = 30,
		Height = 30,
		Color = {1, 0, 0, 1},
		Texture = [[Interface\AddOns\ButtonFacade_HKitty\textures\overlayred]],
	},
	Normal = {
		Width = 46,
		Height = 46,
		Static = true,
		Texture = [[Interface\AddOns\ButtonFacade_HKitty\textures\HKittyActive]],
		OffsetY = 2,
	},
	Pushed = {
		Width = 40,
		Height = 40,
		BlendMode = "ADD",
		Color = {0, 1, 1, 1},
		Texture = [[Interface\AddOns\ButtonFacade_HKitty\textures\overlayred]],
	},
	Cooldown = {
		Width = 36,
		Height = 36,
		Scale = 0.7,
	},
	AutoCast = {
		Width = 30,
		Height = 30,
		Scale = 0.76,
	},
	Border = {
		Width = 42,
		Height = 42,
		BlendMode = "ADD",
		Color = {0, 1, 0, 1},
		Texture = [[Interface\Buttons\UI-ActionButton-Border]],
	},
	Disabled = {
		Hide = true,
	},
	Checked = {
		Width = 42,
		Height = 42,
		BlendMode = "ADD",
		Color = {0, 0.75, 1, 1},
		Texture = [[Interface\AddOns\ButtonFacade_HKitty\textures\HKittyBase]],
	},
	AutoCastable = {
		Width = 57,
		Height = 62,
		OffsetX = 0.5,
		OffsetY = -0.5,
	},
	Highlight = {
		Width = 40,
		Height = 40,
		BlendMode = "ADD",
		Color = {1, 1, 1, 0.5},
		Texture = [[Interface\AddOns\ButtonFacade_HKitty\textures\HKittyHighlight]],
	},
	Gloss = {
		Hide = true
	},
	HotKey = {
		OffsetX = 2,
		OffsetY = 11,
	},
	Count = {
		OffsetX = 10,
		OffsetY = -8,
	},
	Name = {
		Width = 36,
		Height = 10,
		OffsetY = -10,
	},
},true)