
-- Interface Options Panel Objects
-- Group 1 : "Location, Movability, and Color Options" --
	local group1Label;
	--  Edit Boxes  --
		-- x_loc - Determines how far from the left side of the screen the warning frame will be placed
			local xlocEditBox;
		-- y_loc - Determines how far from the top of the screen the warning frame will be placed
			local ylocEditBox;
	-- Buttons --
		-- Test Button - used for checking the x-loc and y-loc values 
			local locTestbtn;
		-- Reset Button - used for checking the x-loc and y-loc values 
			local locResetbtn;
	--  Check Boxes --
		-- isMovable - Determines whether the warning frame can be moved using the mouse or not
			local isMovableChkBtn;
		-- showIcons - Determines whether the warning frame will display the icon of the missing buff
			local showIconChkBtn;
		-- showText - Determines whether the warning frame will show text for the missing buff
			local showTextChkBtn;
		-- showAllBuffs - Determines whether the warning frame will show all missing buffs, or only one at a time
			local showAllBuffsChkBtn;
		-- innCheck - Determines whether to check for missing buffs inside an inn or major city (aka while resting)
			local innCheckChkBtn;
	-- Sliders --
		-- BGcheck - determines when to check for missing buffs in BG
			--1-- as normal (like outside a BG)
			--2-- only if "prep" or "spirit healed"
			--3-- not at all
			local bgCheckSlider;
		-- fontSize - Determines how large the font used by the warning frame will be 
			-- minimum = 10
			-- maximum = 72
			local fontSizeSlider;
-- Group 2 : "Class-generic Options" --
	local group2Label;
	-- Edit Boxes --
	-- Check Boxes --
		-- checkFood - Determines whether to check for the "Well Fed" food buff or not
			local checkFoodChkBtn;
		-- checkMH - Determines whether to check for a temporary weapon buff (sharpening stone, shaman weapon enchant, rogue poison, etc) on the Main-Hand weapon
			local checkMHChkBtn;
		-- checkOH - Determines whether to check for a temporary weapon buff (sharpening stone, shaman weapon enchant, rogue poison, etc) on the Off-Hand weapon
			local checkOHChkBtn;
	-- Sliders --
-- Group 3 : "Class-specific Options" --
	local group3Label;
	-- Edit Boxes --
	-- Check Boxes --
		-- Class : "Paladin" --
			-- checkRF - if "Righteous Fury" should display, having this false (unchecked) will prevent it from displaying. This is typically undesireable, so it will always reset to the default (true) on login
				local checkRFChkBtn;
		-- Class : "Priest" --
			-- checkSP - Determines whether to check for "Shadow Protection" or not
				local checkSPChkBtn;
			-- checkIF - Determines whether to check for "Inner Fire" or not
				local checkIFChkBtn;
		-- Class : "Rogue" --
			-- checkSnD - Determines whether to check for "Slice and Dice" (combat only) or not
				local checkSnDChkBtn;
		-- All other classes
			-- label - Lets the player know that the class they are playing has no class-specific options
				local classSpecificLabel;
	-- Sliders --



--=================================================--
--================ GLOBAL VARIABLES ===============--
--=================================================--

local playerclass = UnitClass("player"); -- this is a useful comment
local buffwatcherdisplaypanel; -- the frame that will be used as for the interface panel
local buffwatcherpanel; -- the frame that will be used for the class panel

BuffWatcher_SVO = {}; -- a table containing the variables and their saved values. Create without "local" to make it save-able
local BuffWatcher_TMP = {};  -- a table to store the variables that will be saved on "OK". It will be initialized in buffwatcherdisplaypanel_Initialize()

local defaults = {
	-- Location Variables
		x_loc = 400, --initial x-coordinate from the left of the screen
		y_loc = -300, -- initial y-coordinate from the top of the screen
		
	-- Movability Variables
		isMovable = true, -- if true, the warning frame can be moved
		mouseEnabled = true, -- if true, then players can use their mouse to move the warning frame
		dragButton = "LeftButton", -- this is the button that players will click to move the frame. Should be either "" or "LeftButton"
		
	-- Display Variables
		fontSize = 22, -- the size of the font used by the warning frame
		BGcheck = 2, -- check for missing buffs in BG -1- as normal (like outside a BG), -2- only if "prep" or "spirit healed", or -3- not at all
		innCheck = false, -- check for missing buffs inside an inn or major city (aka while resting)
		showAllBuffs = false, -- if multiple buffs are missing, show them all (true) or 1 at a time (false)
		showIcons = true, -- if true, the warning message will include the icon of the missing buff
		showText = true, -- if true, the warning message will include the text for the missing buff
		anchorPoint = "Left", -- determines where to anchor the warning frame
		
	-- Class-generic Variables
		checkFood = false, -- determines whether to check for the "Well Fed" buff or not
		checkMH = true, -- determines whether to check if the player's main-hand weapon is buffed or not
		checkOH = true, -- determines whether to check if the player's off-hand weapon is buffed or not
		
	-- Class-specific Variables
		checkRF = true, -- if "Righteous Fury" should display, having this false (unchecked) will prevent it from displaying. This is typically undesireable, so it will always reset to the default (true) on login
		checkSP = false, -- determines whether to check for a Priest's Shadow Protection buff or not
		checkIF = true, -- determines whether to check for a Priest's Inner Fire buff or not
		rogueSND = true, -- determines whether to check for a Rogue's Slice and Dice ability or not
};


--=================================================--
--========== Interface Frame and Options ==========--
--=================================================--

--[[ Create a frame to use as the panel ]] --
buffwatcherpanel = CreateFrame("FRAME", "BuffWatcherInterfacePanel");
buffwatcherpanel.name = "Buff Watcher";

--[[ Create a frame to use as a subpanel, for class-specific options ]] --
buffwatcherdisplaypanel = CreateFrame("FRAME", "BuffWatcherDisplayPanel");
buffwatcherdisplaypanel.name = "Display options";
buffwatcherdisplaypanel.parent = buffwatcherpanel;


-- [[ Add the panels to the Interface Options ]] --
InterfaceOptions_AddCategory(buffwatcherpanel);
InterfaceOptions_AddCategory(buffwatcherdisplaypanel);



-- [[ When the player clicks okay, set the current value to the new setting ]] --
buffwatcherpanel.okay =
function (self)
	
	-- if there's a new font size, let the user know that it's only ugly temporarily
	if (BuffWatcher_SVO["fontSize"] ~= BuffWatcher_TMP["fontSize"]) then
		DEFAULT_CHAT_FRAME:AddMessage("[BW] The warning frame font size has been set to " .. BuffWatcher_TMP["fontSize"] .. ". It will look prettier the next time you login or reload the UI (\"/console reloadui\")", 0.39, 0.58, 0.93);
	end
	
	-- save all the new variables via a loop
	for index,value in pairs(BuffWatcher_TMP) do
		BuffWatcher_SVO[index] = value;
	end
	
	-- check if the addon is soft-disabled, and warn if so
	if ((BuffWatcher_SVO["showIcons"] == false) and (BuffWatcher_SVO["showText"] == false)) then
		DEFAULT_CHAT_FRAME:AddMessage("[BW] BuffWatcher is set to display neither icons nor text for missing buffs. If this is intentional, you might want to just disable this AddOn.", 0.39, 0.58, 0.93);
	end
	
	testButton(BuffWatcher_SVO["x_loc"], BuffWatcher_SVO["y_loc"]);
end

buffwatcherdisplaypanel.okay = buffwatcherpanel.okay;


-- [[ When the player clicks cancel, set the current setting to the previous value ]] --
buffwatcherpanel.cancel =
function (self)
	testButton(BuffWatcher_SVO["x_loc"], BuffWatcher_SVO["y_loc"]);
	
	-- reset all the variables via a loop
	for index,value in pairs(BuffWatcher_SVO) do
		BuffWatcher_TMP[index] = value;
	end
	
	-- Update the Panel graphics to reflect the new changes
	buffwatcherUpdateGraphics();
end

buffwatcherdisplaypanel.cancel = buffwatcherpanel.cancel;


-- [[ When the player clicks default, set the current setting to the default value ]] --
buffwatcherpanel.default =
function (self)
	if (BuffWatcher_SVO["fontSize"] ~= defaults["fontSize"]) then
		DEFAULT_CHAT_FRAME:AddMessage("[BW] The warning frame font size has been set to " .. defaults["fontSize"] .. ". It will look prettier the next time you login or reload the UI (\"/console reloadui\")", 0.39, 0.58, 0.93);
	end
	
	-- reset all the variables via a loop
	for index,value in pairs(defaults) do
		BuffWatcher_SVO[index] = value;
		BuffWatcher_TMP[index] = value;
	end
	
	testButton(defaults["x_loc"], defaults["y_loc"]);
	
	-- Update the Panel graphics to reflect the new changes
	buffwatcherUpdateGraphics();
end

buffwatcherpanel.default = buffwatcherdisplaypanel.okay;






-- Group 1 : "Location, Movability, and Color Options" --
	group1Label = buffwatcherdisplaypanel:CreateFontString("group1LabelFontString");
	group1Label:SetPoint("TOPLEFT", 10, -10);
	
	group1Label:SetFontObject("GameFontNormal");
	group1Label:SetText("Display Options");
	
	--  Edit Boxes  --
		-- x_loc - Determines how far from the left side of the screen the warning frame will be placed
			xlocLabel = buffwatcherdisplaypanel:CreateFontString("xloc_eb_LabelFontString");
			xlocLabel:SetPoint("TOPLEFT", 20, -160);
			xlocLabel:SetFontObject("GameFontNormal");
			xlocLabel:SetText("x-location:");
			
			xlocEditBox = CreateFrame("EditBox", "xloc_EditBox", buffwatcherdisplaypanel, "InputBoxTemplate");
			xlocEditBox:SetPoint("TOPLEFT", buffwatcherdisplaypanel, "TOPLEFT", 100, -160);
			xlocEditBox:SetWidth(35);
			xlocEditBox:SetHeight(13);
			
			xlocEditBox:SetAutoFocus(false)
			xlocEditBox:SetMaxLetters(4);
			xlocEditBox:SetNumeric(true);
			
			xlocEditBox:SetScript("OnEnterPressed",
				function()
					BuffWatcher_TMP["x_loc"] = xlocEditBox:GetNumber();
					ylocEditBox:SetFocus();
				end
			);
			
			xlocEditBox:SetScript("OnTabPressed",
				function()
					ylocEditBox:SetFocus();
				end
			);
			
		-- y_loc - Determines how far from the top of the screen the warning frame will be placed
			ylocLabel = buffwatcherdisplaypanel:CreateFontString("yloc_eb_LabelFontString");
			ylocLabel:SetPoint("TOPLEFT", 20, -180);
			ylocLabel:SetFontObject("GameFontNormal");
			ylocLabel:SetText("y-location:");
			
			ylocEditBox = CreateFrame("EditBox", "yloc_EditBox", buffwatcherdisplaypanel, "InputBoxTemplate");
			ylocEditBox:SetPoint("TOPLEFT", buffwatcherdisplaypanel, "TOPLEFT", 100, -180);
			ylocEditBox:SetWidth(35);
			ylocEditBox:SetHeight(13);
			
			ylocEditBox:SetAutoFocus(false);
			ylocEditBox:SetMaxLetters(4);
			ylocEditBox:SetNumeric(true);
			
			ylocEditBox:SetScript("OnEnterPressed",
				function()
					local tempY = ylocEditBox:GetNumber();
					
					-- ensure that tempY is negative (for easier coding below)
					if (tempY > 0) then
						tempY = tempY * -1;
					end
					
					BuffWatcher_TMP["y_loc"] = tempY;
					xlocEditBox:SetFocus();
				end
			);
			
			ylocEditBox:SetScript("OnTabPressed",
				function()
					xlocEditBox:SetFocus();
				end
			);
			
	-- Buttons --
		-- Test Button - used for checking the x-loc and y-loc values
			locTestbtn = CreateFrame("Button", "xylocTest_Button", buffwatcherdisplaypanel, "OptionsButtonTemplate");
			locTestbtn:SetPoint("TOPLEFT", buffwatcherdisplaypanel, "TOPLEFT", 17, -200);
			locTestbtn:SetWidth(120);
			locTestbtn:SetHeight(25);
			locTestbtn:SetText("Test");
			
			locTestbtn:SetScript("OnClick",
				function()
					tempX = xlocEditBox:GetNumber();
					tempY = ylocEditBox:GetNumber();
					
					-- ensure that tempY is negative (for easier coding below)
					if (tempY > 0) then
						tempY = tempY * -1;
					end
					
					BuffWatcher_TMP["x_loc"] = tempX;
					BuffWatcher_TMP["y_loc"] = tempY;
					
					testButton(BuffWatcher_TMP["x_loc"], BuffWatcher_TMP["y_loc"]);
				end
			);
			
		-- Reset Button - used for resetting the x-loc and y-loc values to the default
			locResetbtn = CreateFrame("Button", "xylocReset_Button", buffwatcherdisplaypanel, "OptionsButtonTemplate");
			locResetbtn:SetPoint("TOPLEFT", buffwatcherdisplaypanel, "TOPLEFT", 17, -250);
			locResetbtn:SetWidth(120);
			locResetbtn:SetHeight(25);
			locResetbtn:SetText("Reset");
			
			locResetbtn:SetScript("OnClick",
				function()
					BuffWatcher_TMP["x_loc"] = defaults["x_loc"];
					BuffWatcher_TMP["y_loc"] = defaults["y_loc"];
					
					testButton(BuffWatcher_TMP["x_loc"], BuffWatcher_TMP["y_loc"]);
				end
			);
			
	--  Check Boxes --
		-- isMovable - Determines whether the warning frame can be moved using the mouse or not
			isMovableChkBtn = CreateFrame("CheckButton", "isMovable_ChkBtn", buffwatcherdisplaypanel, "ChatConfigCheckButtonTemplate");
			isMovableChkBtn:SetPoint("TOPLEFT", 15, -30);
			
			isMovableChkBtn.tooltip = "If this is checked, the missing buff notification frame can be clicked and dragged to a new position.";
			isMovable_ChkBtnText:SetText("Movable");
			
			function isMovableChkBtn.func(checked)
				if (checked) then
					-- temporarily save the new values. They will be permasaved on the "OK" function
					BuffWatcher_TMP["isMovable"] = true;
					BuffWatcher_TMP["mouseEnabled"] = true;
					BuffWatcher_TMP["dragButton"] = "LeftButton";
				else
					BuffWatcher_TMP["isMovable"] = false;
					BuffWatcher_TMP["mouseEnabled"] = false;
					BuffWatcher_TMP["dragButton"] = "";
				end
			end
			
		-- showIcons - Determines whether the warning frame will display the icon of the missing buff
			showIconChkBtn = CreateFrame("CheckButton", "showIcon_ChkBtn", buffwatcherdisplaypanel, "ChatConfigCheckButtonTemplate");
			showIconChkBtn:SetPoint("TOPLEFT", 15, -300);
			
			showIconChkBtn.tooltip = "If this is checked, the missing buff notification frame will display the icon for the missing buff.";
			showIcon_ChkBtnText:SetText("Show Icon");
			
			function showIconChkBtn.func(checked)
				if (checked) then
					-- temporarily save the new values. They will be permasaved on the "OK" function
					BuffWatcher_TMP["showIcons"] = true;
				else
					BuffWatcher_TMP["showIcons"] = false;
				end
			end
			
		-- showText - Determines whether the warning frame will show text for the missing buff
			showTextChkBtn = CreateFrame("CheckButton", "showText_ChkBtn", buffwatcherdisplaypanel, "ChatConfigCheckButtonTemplate");
			showTextChkBtn:SetPoint("TOPLEFT", 15, -280);
			
			showTextChkBtn.tooltip = "If this is checked, the missing buff notification frame will display the text for the missing buff.";
			showText_ChkBtnText:SetText("Show Text");
			
			function showTextChkBtn.func(checked)
				if (checked) then
					-- temporarily save the new values. They will be permasaved on the "OK" function
					BuffWatcher_TMP["showText"] = true;
				else
					BuffWatcher_TMP["showText"] = false;
				end
			end
			
		-- showAllBuffs - Determines whether the warning frame will show all missing buffs, or only one at a time
			local showAllBuffsChkBtn = CreateFrame("CheckButton", "showAllBuffs_ChkBtn", buffwatcherdisplaypanel, "ChatConfigCheckButtonTemplate");
			showAllBuffsChkBtn:SetPoint("TOPLEFT", 190, -300);
			
			showAllBuffsChkBtn.tooltip = "If this is checked, all your missing buffs will be displayed. If unchecked, they'll be displayed one at a time.";
			showAllBuffs_ChkBtnText:SetText("Show all missing buffs");
			
			function showAllBuffsChkBtn.func(checked)
				if (checked) then
					-- temporarily save the new values. They will be permasaved on the "OK" function
					BuffWatcher_TMP["showAllBuffs"] = true;
				else
					BuffWatcher_TMP["showAllBuffs"] = false;
				end
			end
			
		-- innCheck - Determines whether to check for missing buffs inside an inn or major city (aka while resting)
			innCheckChkBtn = CreateFrame("CheckButton", "innCheck_ChkBtn", buffwatcherdisplaypanel, "ChatConfigCheckButtonTemplate");
			innCheckChkBtn:SetPoint("TOPLEFT", 190, -280);
			
			innCheckChkBtn.tooltip = "If this is checked, BuffWatcher will display your missing buffs even if you are in an inn or major city (resting)";
			innCheck_ChkBtnText:SetText("Display while resting");
			
			function innCheckChkBtn.func(checked)
				if (checked) then
					BuffWatcher_TMP["innCheck"] = true;
				else
					BuffWatcher_TMP["innCheck"] = false;
				end
			end
			
	-- Sliders --
		-- BGcheck - determines when to check for missing buffs in BG
			--1-- as normal (like outside a BG)
			--2-- only if "prep" or "spirit healed"
			--3-- not at all
			bgCheckSlider = CreateFrame("Slider", "bgCheck_Slider", buffwatcherdisplaypanel, "InterfaceOptionsSliderTemplate");
			bgCheckSlider:SetPoint("TOPLEFT", 20, -80);
			
			bgCheckSlider:SetMinMaxValues(1, 3);
			bgCheckSlider:SetValueStep(1);
			bgCheckSlider:SetOrientation("HORIZONTAL");
			
			bgCheck_SliderLow:SetText(1);
			bgCheck_SliderHigh:SetText(3);
			bgCheck_SliderText:SetText("Battleground Checking");
			bgCheckSlider.tooltipText = "This slider determines when to check for missing buffs in a Battleground:\n -1- Normal Checking.\n <2> Only when \"Preparing\" or recently rezzed.\n -3- Not at all.";
			
			bgCheckSlider:SetScript("OnValueChanged",
				function ()
					BuffWatcher_TMP["BGcheck"] = bgCheckSlider:GetValue();
					if (BuffWatcher_TMP["BGcheck"] == 1) then
						bgCheckSlider.tooltipText = "This slider determines when to check for missing buffs in a Battleground:\n <1> Normal Checking.\n -2- Only when \"Preparing\" or recently rezzed.\n -3- Not at all.";
					elseif (BuffWatcher_TMP["BGcheck"] == 2) then
						bgCheckSlider.tooltipText = "This slider determines when to check for missing buffs in a Battleground:\n -1- Normal Checking.\n <2> Only when \"Preparing\" or recently rezzed.\n -3- Not at all.";
					elseif (BuffWatcher_TMP["BGcheck"] == 3) then
						bgCheckSlider.tooltipText = "This slider determines when to check for missing buffs in a Battleground:\n -1- Normal Checking.\n -2- Only when \"Preparing\" or recently rezzed.\n <3> Not at all.";
					end
				end
			);
			
		-- fontSize - Determines how large the font used by the warning frame will be
			-- minimum = 10
			-- maximum = 72
			fontSizeSlider = CreateFrame("Slider", "fontSize_Slider", buffwatcherdisplaypanel, "InterfaceOptionsSliderTemplate");
			fontSizeSlider:SetPoint("TOPLEFT", 20, -130);
			
			fontSizeSlider:SetMinMaxValues(10, 72);
			fontSizeSlider:SetValueStep(2);
			fontSizeSlider:SetOrientation("HORIZONTAL");
			
			fontSize_SliderLow:SetText(10);
			fontSize_SliderHigh:SetText(72);
			fontSize_SliderText:SetText("Font Size");
			fontSizeSlider.tooltipText = "This slider controls the font size.\nCurrent font size: 22";
			
			fontSizeSlider:SetScript("OnValueChanged",
				function ()
					BuffWatcher_TMP["fontSize"] = fontSizeSlider:GetValue();
					fontSizeSlider.tooltipText = "This slider controls the font size.\nCurrent font size: " .. BuffWatcher_TMP["fontSize"];
				end
			);
		
-- Group 2 : "Class-generic Options" --
	group2Label = buffwatcherpanel:CreateFontString("group2LabelFontString");
	group2Label:SetPoint("TOPLEFT", 10, -10);
	
	group2Label:SetFontObject("GameFontNormal");
	group2Label:SetText("Class-generic Options");
	
	-- Edit Boxes --
	-- Check Boxes --
		-- checkFood - Determines whether to check for the "Well Fed" food buff or not
			checkFoodChkBtn = CreateFrame("CheckButton", "checkFood_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
			checkFoodChkBtn:SetPoint("TOPLEFT", 15, -30);
			
			checkFoodChkBtn.tooltip = "If this is checked, BuffWatcher will check for the \"Well Fed\" buff.";
			checkFood_ChkBtnText:SetText("Food Buff");
			
			function checkFoodChkBtn.func(checked)
				if (checked) then
					BuffWatcher_TMP["checkFood"] = true;
				else
					BuffWatcher_TMP["checkFood"] = false;
				end
			end
			
		-- checkMH - Determines whether to check for a temporary weapon buff (sharpening stone, shaman weapon enchant, rogue poison, etc) on the Main-Hand weapon
			checkMHChkBtn = CreateFrame("CheckButton", "checkMH_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
			checkMHChkBtn:SetPoint("TOPLEFT", 15, -50);
			
			checkMHChkBtn.tooltip = "If this is checked, BuffWatcher will check your main-hand weapon for a temporary weapon buff. This includes\n - Rogue poisons\n - Shaman weapon buffs\n - Sharpening stones\n - Weapon Oils";
			checkMH_ChkBtnText:SetText("Main-hand buff");
			
			function checkMHChkBtn.func(checked)
				if (checked) then
					BuffWatcher_TMP["checkMH"] = true;
				else
					BuffWatcher_TMP["checkMH"] = false;
				end
			end
			
		-- checkOH - Determines whether to check for a temporary weapon buff (sharpening stone, shaman weapon enchant, rogue poison, etc) on the Off-Hand weapon
			checkOHChkBtn = CreateFrame("CheckButton", "checkOH_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
			checkOHChkBtn:SetPoint("TOPLEFT", 190, -50);
			
			checkOHChkBtn.tooltip = "If this is checked, BuffWatcher will check your off-hand weapon for a temporary weapon buff, if you have a weapon equipped in your off-hand. This includes\n - Rogue poisons\n - Shaman weapon buffs\n - Sharpening stones\n - Weapon Oils";
			checkOH_ChkBtnText:SetText("Off-hand buff");
			
			function checkOHChkBtn.func(checked)
				if (checked) then
					BuffWatcher_TMP["checkOH"] = true;
				else
					BuffWatcher_TMP["checkOH"] = false;
				end
			end
			
	-- Sliders --
	
-- Group 3 : "Class-specific Options" --
	group3Label = buffwatcherpanel:CreateFontString("group3LabelFontString");
	group3Label:SetPoint("TOPLEFT", 10, -280);
	
	group3Label:SetFontObject("GameFontNormal");
	group3Label:SetText("Class-specific Options");
	
	-- Edit Boxes --
	-- Check Boxes --
		-- Class : "Paladin" --
		if (playerclass == "Paladin") then
			-- checkRF - if "Righteous Fury" should display, having this false (unchecked) will prevent it from displaying. This is typically undesireable, so it will always reset to the default (true) on login
				checkRFChkBtn = CreateFrame("CheckButton", "checkRF_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
				checkRFChkBtn:SetPoint("TOPLEFT", 15, -300);
				
				checkRFChkBtn.tooltip = " If \"Righteous Fury\" should display, having this false (unchecked) will prevent it from displaying. This is typically undesireable, so it will always reset to the default (true) on login.\n - Paladin only.";
				checkRF_ChkBtnText:SetText("Righteous Fury");
				
				function checkRFChkBtn.func(checked)
					if (checked) then
						BuffWatcher_TMP["checkRF"] = true;
					else
						BuffWatcher_TMP["checkRF"] = false;
					end
				end
				
		-- Class : "Priest" --
		elseif (playerclass == "Priest") then
			-- checkSP - Determines whether to check for "Shadow Protection" or not
				checkSPChkBtn = CreateFrame("CheckButton", "checkSP_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
				checkSPChkBtn:SetPoint("TOPLEFT", 15, -300);
				
				checkSPChkBtn.tooltip = "If this is checked, BuffWatcher will check your buffs for Shadow Protection.\n - Priest only.";
				checkSP_ChkBtnText:SetText("Shadow Protection");
				
				function checkSPChkBtn.func(checked)
					if (checked) then
						BuffWatcher_TMP["checkSP"] = true;
					else
						BuffWatcher_TMP["checkSP"] = false;
					end
				end
				
			-- checkIF - Determines whether to check for "Inner Fire" or not
				checkIFChkBtn = CreateFrame("CheckButton", "checkIF_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
				checkIFChkBtn:SetPoint("TOPLEFT", 15, -320);
				
				checkIFChkBtn.tooltip = "If this is checked, BuffWatcher will check your buffs for Inner Fire.\n - Priest only.";
				checkIF_ChkBtnText:SetText("Inner Fire");
				
				function checkIFChkBtn.func(checked)
					if (checked) then
						BuffWatcher_TMP["checkIF"] = true;
					else
						BuffWatcher_TMP["checkIF"] = false;
					end
				end
				
		-- Class : "Rogue" --
		elseif (playerclass == "Rogue") then
			-- checkSnD - Determines whether to check for "Slice and Dice" (combat only) or not
				checkSnDChkBtn = CreateFrame("CheckButton", "checkSnD_ChkBtn", buffwatcherpanel, "ChatConfigCheckButtonTemplate");
				checkSnDChkBtn:SetPoint("TOPLEFT", 15, -300);
				
				checkSnDChkBtn.tooltip = "If this is checked, BuffWatcher will check your buffs for Slice and Dice.\n - Rogue only\n - Combat only.";
				checkSnD_ChkBtnText:SetText("Slice and Dice");
				
				function checkSnDChkBtn.func(checked)
					if (checked) then
						BuffWatcher_TMP["rogueSND"] = true;
					else
						BuffWatcher_TMP["rogueSND"] = false;
					end
				end
		else
			classSpecificLabel = buffwatcherpanel:CreateFontString("group3LabelFontString");
			classSpecificLabel:SetPoint("TOPLEFT", 35, -300);
			
			classSpecificLabel:SetFontObject("GameFontNormal");
			classSpecificLabel:SetText(playerclass .. "s have no class-specific options.");
		end
	-- Sliders --



-- Updates the Panel graphics to reflect the actual state of the saved variables
--	It became cumbersome to maintain the list of buttons and such per click
function buffwatcherUpdateGraphics()
	-- Group 1 : "Location, Movability, and Color Options" --
		--  Edit Boxes  --
			-- x_loc - Determines how far from the left side of the screen the warning frame will be placed
				--xlocEditBox:Insert(BuffWatcher_SVO["x_loc"]);
				xlocEditBox:SetNumber(BuffWatcher_SVO["x_loc"]);
			-- y_loc - Determines how far from the top of the screen the warning frame will be placed
				--ylocEditBox:Insert(BuffWatcher_SVO["y_loc"]);
				xlocEditBox:SetNumber(BuffWatcher_SVO["x_loc"]);
		--  Check Boxes --
			-- isMovable - Determines whether the warning frame can be moved using the mouse or not
				isMovableChkBtn:SetChecked(BuffWatcher_SVO["isMovable"]);
			-- showIcons - Determines whether the warning frame will display the icon of the missing buff
				showIconChkBtn:SetChecked(BuffWatcher_SVO["showIcons"]);
			-- showText - Determines whether the warning frame will show text for the missing buff
				showTextChkBtn:SetChecked(BuffWatcher_SVO["showText"]);
			-- showAllBuffs - Determines whether the warning frame will show all missing buffs, or only one at a time
				showAllBuffsChkBtn:SetChecked(BuffWatcher_SVO["showAllBuffs"]);
			-- innCheck - Determines whether to check for missing buffs inside an inn or major city (aka while resting)
				innCheckChkBtn:SetChecked(BuffWatcher_SVO["innCheck"]);
		-- Sliders --
			-- BGcheck - determines when to check for missing buffs in BG
				--1-- as normal (like outside a BG)
				--2-- only if "prep" or "spirit healed"
				--3-- not at all
				bgCheckSlider:SetValue(BuffWatcher_SVO["BGcheck"]);
			-- fontSize - Determines how large the font used by the warning frame will be
				fontSizeSlider:SetValue(BuffWatcher_SVO["fontSize"]);
	-- Group 2 : "Class-generic Options" --
		-- Edit Boxes --
		-- Check Boxes --
			-- checkFood - Determines whether to check for the "Well Fed" food buff or not
				checkFoodChkBtn:SetChecked(BuffWatcher_SVO["checkFood"]);
			-- checkMH - Determines whether to check for a temporary weapon buff (sharpening stone, shaman weapon enchant, rogue poison, etc) on the Main-Hand weapon
				checkMHChkBtn:SetChecked(BuffWatcher_SVO["checkMH"]);
			-- checkOH - Determines whether to check for a temporary weapon buff (sharpening stone, shaman weapon enchant, rogue poison, etc) on the Off-Hand weapon
				checkOHChkBtn:SetChecked(BuffWatcher_SVO["checkOH"]);
		-- Sliders --
	-- Group 3 : "Class-specific Options" --
		-- Edit Boxes --
		-- Check Boxes --
			-- Class : "Paladin" --
			if (playerclass == "Paladin") then 
				-- checkRF - if "Righteous Fury" should display, having this false (unchecked) will prevent it from displaying. This is typically undesireable, so it will always reset to the default (true) on login
					checkRFChkBtn:SetChecked(BuffWatcher_SVO["checkRF"]);
			-- Class : "Priest" --
			elseif (playerclass == "Priest") then
				-- checkSP - Determines whether to check for "Shadow Protection" or not
					checkSPChkBtn:SetChecked(BuffWatcher_SVO["checkSP"]);
				-- checkIF - Determines whether to check for "Inner Fire" or not
					checkIFChkBtn:SetChecked(BuffWatcher_SVO["checkIF"]);
			-- Class : "Rogue" --
			elseif (playerclass == "Rogue") then
				-- checkSnD - Determines whether to check for "Slice and Dice" (combat only) or not
					checkSnDChkBtn:SetChecked(BuffWatcher_SVO["rogueSND"]);
			end
		-- Sliders --
end




function buffwatcherpanel_Initialize()
	
	-- Initialize the values of the temporary storage, so all the variables can be saved easily
	for index,value in pairs(BuffWatcher_SVO) do
		BuffWatcher_TMP[index] = value;
	end
	
	-- Update the Panel graphics to reflect the new changes
	buffwatcherUpdateGraphics();
end

--[[
	local sortDropDown = CreateFrame("Frame", "PRFrames_SortDropDown", frame, "UIDropDownMenuTemplate")
	local clickFunc = function() UIDropDownMenu_SetSelectedValue(sortDropDown, this.value) end
	sortDropDown.Initialize = function()
		UIDropDownMenu_AddButton{text = "None", value = -1, func = clickFunc}
		UIDropDownMenu_AddButton{text = "Name", value = "NAME", func = clickFunc}
		UIDropDownMenu_AddButton{text = "Index", value = "INDEX", func = clickFunc}
	end
	sortDropDown:SetScript("OnShow", function(f)
		UIDropDownMenu_Initialize(sortDropDown, sortDropDown.Initialize)
	end)
	sortDropDown:SetPoint("RIGHT", groupByDropDown, "LEFT", -150, 0)
	local font = sortDropDown:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
	font:SetText(L["Sort Frames By:"])
	font:SetPoint("BOTTOMLEFT", sortDropDown, "TOPLEFT", 0, 0)
]]

--[[

http://lua-users.org/wiki/TablesTutorial


local random_array = { mug = "coffee", [42] = "universe", true = "false" }

for index,value in pairs(random_array) do 
	if (type(index) == "number") then
		index = tostring(index)
	elseif (type(index) == "boolean") then
		if (index) then
			index = "true"
		else
			index = "false"
		end
	end
DEFAULT_CHAT_FRAME:AddMessage(index.." : "..value)
end

 mug : coffee
 42 : universe
 true : false


 
]]

--[[
-- Show Button - Shows the buff warning notification frame
showbtn = CreateFrame("Button", "frameShow_Button", buffwatcherdisplaypanel, "OptionsButtonTemplate");
showbtn:SetPoint("TOPLEFT", buffwatcherdisplaypanel, "TOPLEFT", 190, -30);
showbtn:SetWidth(120);
showbtn:SetHeight(25);
showbtn:SetText("Show");

showbtn:SetScript("OnClick",
	function()
		buffwatcher_showFrame();
	end
);
]]