--[[
	BuffWatcher v2.44
		By Azmenen of Lothar
		
		Special thanks to:
			Alestane - Slider:GetValue() help
				"Great thing about being a 'lock...you don't have to eat; you don't have to drink; you don't even have to BREATHE. You can subsist entirely on the suffering of your enemies." 
			Zakrus - providing the EditBox template
			Mairelon - EditBox:AutoFocus() and basically doing (and completely teaching me about) CheckButton
				"Ho! HaHa! Guard! Turn! Parry! Dodge! Spin! Ha! Thrust!" 
			Nitelily - Namespaces and general help
			Maul - global variable help and type conversion
			Atradies - variable value and saving help
			
		TO DO:
			- Allow dynamic font-recoloring
			- Create more options for players to further customize BW's behavior
				- allow for custom buff checks, and custom messaegs when a buff is missing
			
http://www.wowwiki.com/API_FontString_SetTextColor
]]


DEFAULT_CHAT_FRAME:AddMessage("[BW] BuffWatcher active.", 0.39, 0.58, 0.93);



--=================================================--
--================ GLOBAL VARIABLES ===============--
--=================================================--

local buffwatcherframe, buffwatchertext; -- the name of the warning frame and its FontString 
local playerclass = UnitClass("player"); -- this is a useful comment
local checkTalent, nameTalent, iconPath, tier, column, currentRank; -- used in the talent check, updated in buffwatcher_TalentChange()

local warriorShout = "Battle Shout "; -- if the player is a warrior, this will be updated whenever they cast a shout spell to the name of that shout, allowing correct shout-checking independent of the number of warriors in the group. Initialized to a bum value for easier coding
local warrShoutIcon = "Ability_Warrior_BattleShout"; -- if the player is a warrior, this will be updated whenever they cast a shout spell to the icon of that shout, allowing correct shout-checking independent of the number of warriors in the group. Initialized to Battle Shout for easier coding

local i,j; -- used to index loops
local beenFormatted = false; -- used in formatDisplay to keep track of whether it's the first string or not

BuffWatcher_SVO = {}; -- a table containing the variables and their saved values. Create without "local" to make it save-able

local defaults = {
	-- Location Variables
		x_loc = 400, --initial x-coordinate from the left of the screen
		y_loc = -300, -- initial y-coordinate from the top of the screen
		
	-- Movability Variables
		isMovable = true, -- if true, the warning frame can be moved
		mouseEnabled = true, -- if true, then players can use their mouse to move the warning frame
		dragButton = "LeftButton", -- this is the button that players will click to move the frame. Should be either "" or "LeftButton"
		
	-- Display Variables
		fontSize = 22, -- the size of the font used by the warning frame
		BGcheck = 2, -- check for missing buffs in BG -1- as normal (like outside a BG), -2- only if "prep" or "spirit healed", or -3- not at all
		innCheck = false, -- check for missing buffs inside an inn or major city (aka while resting)
		showAllBuffs = false, -- if multiple buffs are missing, show them all (true) or 1 at a time (false)
		showIcons = true, -- if true, the warning message will include the icon of the missing buff
		showText = true, -- if true, the warning message will include the text for the missing buff
		anchorPoint = "Left", -- determines where to anchor the warning frame
		
	-- Class-generic Variables
		checkFood = false, -- determines whether to check for the "Well Fed" buff or not
		checkMH = true, -- determines whether to check if the player's main-hand weapon is buffed or not
		checkOH = true, -- determines whether to check if the player's off-hand weapon is buffed or not
		
	-- Class-specific Variables
		checkRF = true, -- if "Righteous Fury" should display, having this false (unchecked) will prevent it from displaying. This is typically undesireable, so it will always reset to the default (true) on login
		checkSP = false, -- determines whether to check for a Priest's Shadow Protection buff or not
		checkIF = true, -- determines whether to check for a Priest's Inner Fire buff or not
		rogueSND = true, -- determines whether to check for a Rogue's Slice and Dice ability or not
}







--=================================================--
--=================== FUNCTIONS ===================--
--=================================================--

-- This is the "workhorse" function. It handles all events, and checks if you are resting, in a battleground or arena, and it also performs the buff check.
function buffwatcher_OnEvent(this, event, ...)
	
	-- OnLoad, create the frame and fontString objects
	if (event == "VARIABLES_LOADED") then
		buffwatcher_initializeFrame();
		return;
	end
	
	
	-- did the player change his/her talents?
	if ((event == "CHARACTER_POINTS_CHANGED") or (event == "PLAYER_ALIVE")) then
		buffwatcher_TalentChange();
		buffwatcherframe:Hide();
	end
	
	
	-- if the player is a warrior, did they just cast a spell?
	if (event == "UNIT_SPELLCAST_SUCCEEDED") then
		if (arg1 ~= "player") then
			return;
		else
			buffwatcher_WarriorShouted(arg2);
		end
		buffwatcherframe:Hide();
	end
	
	
	-- Don't want the addon complaining when you're in an inn or major city, unless you do want it to
	if ((BuffWatcher_SVO["innCheck"] == false) and IsResting()) then
		buffwatcherframe:Hide();
		return;
	end
	
	
	-- I included this "is dead?" check because getting the message when you were dead and running back to your corpse is annoying
	if (UnitIsDeadOrGhost("player") == 1) then
		buffwatcherframe:Hide();
		return;
	end
	
	
	local status = "";
	local buffName = "";
	local buffIsActive = -1;
	
	
	--[[ Checks for missing buffs in BG
		-A- as normal (like outside a BG)
		-B- only if "preparing" or "spirit healed"
		-C- not at all
	]]
	local bg_Check = buffwatcher_BGcheck();
	if (bg_Check == false) then
		buffwatcherframe:Hide();
		return;
	end
	
	
	
	local displayText = ""; -- this is the string that will be printed in the event that a buff is not found
	local buff1, buff2, buff3, buff4, buff5, buff6 = false, false, false, false, false, false; -- these are the buffs to check for. buff1 to buff4 are used in the class-specific buff checks, buff5 is for food, buff6 is for temporary weapon enchants
	buffName = nil; -- the name of the buff that's currently being checked for
	buffIsActive = nil; -- is the buff being checked the buff we are looking for?
	
	-- This will only be true if the buff should only be displayed during combat (warrior shouts, for example)
	local combatonly = false;
	
	
	-- Check through the buffs on the player, on a per-class basis
	if (playerclass == "Druid") then							-- DRUID BUFF CHECK
	for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				-- If there are no buffs, check for the talent so as to not mess up the display
				if (i <= 1) then
					buff1 = true;
				end
				
				break;
			else
				-- only want to check for Omen of Clarity if you have the talent for it
				if (checkTalent == true) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Omen of Clarity");
					if (buffIsActive ~= nil) then
						buff1 = true;
					end
				else
					buff1 = true;
				end
				
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Thorns");
				if (buffIsActive ~= nil) then
					buff2 = true;
				end
				
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "of the Wild");
				if (buffIsActive ~= nil) then
					buff3 = true;
				end
			end
		end
		
		-- If there is a missing buff, set up the message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Nature_CrystalBall", "OoC");
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Spell_Nature_Thorns", "Thorns");
		end
		if (buff3 == false) then
			displayText = displayText .. formatDisplay("Spell_Nature_Regeneration", "MotW");
		end
		
		
		
	elseif (playerclass == "Hunter") then						-- HUNTER BUFF CHECK			
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				-- If there are no buffs, check for the talent so as to not mess up the display
				if (i <= 1) then
					buff2 = true;
				end
				
				break;
			else
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Aspect of the");
				if (buffIsActive ~= nil) then
					buff1 = true;
				end
				
				-- only want to check for Trueshot Aura if you have the talent for it
				if (checkTalent == true) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Trueshot Aura");
					if (buffIsActive ~= nil) then
						buff2 = true;
					end
				else
					buff2 = true;
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Nature_RavenForm", "Aspect");
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Ability_TrueShot", "Trueshot Aura");
		end
		
		
		
	elseif (playerclass == "Mage") then							-- MAGE BUFF CHECK
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				break;
			else
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Arcane Brilliance");
				if (buffIsActive ~= nil) then
					buff1 = true;
				else
					buffIsActive = strfind(buffName, "Arcane Intellect");
					if (buffIsActive ~= nil) then
						buff1 = true;
					end
				end
				
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Frost Armor");
				if (buffIsActive ~= nil) then
					buff2 = true;
				else
					buffIsActive = strfind(buffName, "Ice Armor");
					if (buffIsActive ~= nil) then
						buff2 = true;
					else
						buffIsActive = strfind(buffName, "Mage Armor");
						if (buffIsActive ~= nil) then
							buff2 = true;
						else
							buffIsActive = strfind(buffName, "Molten Armor");
							if (buffIsActive ~= nil) then
								buff2 = true;
							end
						end
					end
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_MagicalSentry", "Int Buff");
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Ability_Mage_MoltenArmor", "Armor");
		end
		
		
		
	elseif (playerclass == "Paladin") then						-- PALADIN BUFF CHECK
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				-- If there are no buffs, check for the talent so as to not mess up the display
				if (i <= 1) then
					buff1 = true;
				end
				
				break;
			else
				-- only want to check for Righteous Fury if you have at least 1 point into the talent improving it
				if (BuffWatcher_SVO["checkRF"] == true) then
					if (checkTalent == true) then
						buffIsActive = nil;
						buffIsActive = strfind(buffName, "Righteous Fury");
						if (buffIsActive ~= nil) then
							buff1 = true;
						end
					else
						buff1 = true;
					end
				else
					buff1 = true;
				end
				
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Blessing of Auch");
				if (buffIsActive ~= nil) then
					-- do nothing, we don't want Blessing of Auchindoun
				else
					buffIsActive = strfind(buffName, "Blessing of");
					if (buffIsActive ~= nil) then
						buff2 = true;
					end
				end
			end
		end
		
		-- new way to check for aura, guaranteed to detect only your aura, even if multiple paladins in party
		local numAuras = GetNumShapeshiftForms();
		for i=1, numAuras do
			local auraIcon, auraName, auraActive = GetShapeshiftFormInfo(i);
			
			if (auraActive) then
				buff3 = true;
				
				if ((auraName == "Crusader Aura") and (UnitAffectingCombat("player") == 1)) then -- don't want Crusader Aura active in combat
					displayText = displayText .. formatDisplay("Spell_Holy_CrusaderAura", "Combat Aura");
				end
				
				break;
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_SealOfFury", "Threat buff");
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_SealOfWisdom", "Blessing");
		end
		if (buff3 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_DevotionAura", "Aura");
		end
		
		
		
	elseif (playerclass == "Priest") then						-- PRIEST BUFF CHECK
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				-- If there are no buffs, check for the talent so as to not mess up the display
				if (i <= 1) then
					buff1 = true;
					buff4 = true;
				end
				
				break;
			else	
				if (BuffWatcher_SVO["checkIF"] == true) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Inner Fire");
					if (buffIsActive ~= nil) then
						buff1 = true;
					end
				else
					buff1 = true;
				end
				
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Power Word: Fortitude");
				if (buffIsActive ~= nil) then
					buff2 = true;
				else
					buffIsActive = strfind(buffName, "Prayer of Fortitude");
					if (buffIsActive ~= nil) then
						buff2 = true;
					end
				end
				
				-- only want to check for the spirit buff if you have the talent for it
				if (checkTalent == true) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Divine Spirit");
					if (buffIsActive ~= nil) then
						buff3 = true;
					else
						buffIsActive = strfind(buffName, "Prayer of Spirit");
						if (buffIsActive ~= nil) then
							buff3 = true;
						end
					end
				else
					buff3 = true;
				end
				
				-- only want to check for Shadow Protection if the player wants to check for it
				if (BuffWatcher_SVO["checkSP"] == true) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Shadow Protection");
					if (buffIsActive ~= nil) then
						buff4 = true;
					else
						buffIsActive = strfind(buffName, "Prayer of Shadow Protection");
						if (buffIsActive ~= nil) then
							buff4 = true;
						end
					end
				else
					buff4 = true;
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_InnerFire", "Inner Fire");
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_WordFortitude", "Fort");
		end
		if (buff3 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_DivineSpirit", "Spirit buff");
		end
		if (buff4 == false) then
			displayText = displayText .. formatDisplay("Spell_Holy_PrayerofShadowProtection", "Shadow Protection");
		end
		
		
		
	elseif (playerclass == "Rogue") then						-- ROGUE BUFF CHECK
		combatonly = true; -- Rogues only care if their buffs are up during combat
		
		if (BuffWatcher_SVO["rogueSND"] == true) then
			for i=1, 40 do
				buffName = GetPlayerBuffName(i);
				
				if (buffName == nil) then
					break;
				else
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Slice");
					if (buffIsActive ~= nil) then
						buff1 = true;
					end
				end
			end
		else
			buff1 = true;
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Ability_Rogue_SliceDice", "SnD");
		end
		
		
		
	elseif (playerclass == "Shaman") then						-- SHAMAN BUFF CHECK
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				break;
			else
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Water Shield");
				if (buffIsActive ~= nil) then
					buff1 = true;
				else
					buffIsActive = strfind(buffName, "Lightning Shield");
					if (buffIsActive ~= nil) then
						buff1 = true;
					else
						buffIsActive = strfind(buffName, "Earth Shield");
						if (buffIsActive ~= nil) then
							buff1 = true;
						end
					end
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Nature_LightningShield", "Shield");
		end
		
		
		
	elseif (playerclass == "Warlock") then						-- WARLOCK BUFF CHECK
		local hasPetUI, isHunterPet = HasPetUI(); -- returns 1 if the player has a pet User Interface
		
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				-- If there are no buffs, check for the talent so as to not mess up the display
				if (i <= 1) then
					buff2 = true;
				end
				
				break;
			else
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Demon Armor");
				if (buffIsActive ~= nil) then
					buff1 = true;
				else
					buffIsActive = strfind(buffName, "Demon Skin");
					if (buffIsActive ~= nil) then
						buff1 = true;
					else
						buffIsActive = strfind(buffName, "Fel Armor");
						if (buffIsActive ~= nil) then
							buff1 = true;
						end
					end
				end
				
				-- only want to check for Soul Link if you have the talent for it, and if your pet is active
				if ((checkTalent == true) and (hasPetUI == 1)) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Soul Link");
					if (buffIsActive ~= nil) then
						buff2 = true;
					end
				else
					buff2 = true;
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay("Spell_Shadow_RagingScream", "Armor");
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Spell_Shadow_GatherShadows", "Soul Link");
		end
		
		
		
	elseif (playerclass == "Warrior") then						-- WARRIOR BUFF CHECK
		combatonly = true; -- Warriors only care if their buffs are up during combat
		
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				break;
			else
				buffIsActive = nil;
				buffIsActive = strfind(buffName, warriorShout); -- warriorShout is variable, depending on the most-recently cast shout spell. Modified in buffwatcher_WarriorShouted(...)
				if (buffIsActive ~= nil) then
					buff1 = true;
				end
				
				-- only want to check for Rampage if you have the talent for it
				if (checkTalent == true) then
					buffIsActive = nil;
					buffIsActive = strfind(buffName, "Rampage");
					if (buffIsActive ~= nil) then
						buff2 = true;
					end
				else
					buff2 = true;
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff1 == false) then
			displayText = displayText .. formatDisplay(warrShoutIcon, warriorShout);
		end
		if (buff2 == false) then
			displayText = displayText .. formatDisplay("Ability_Warrior_Rampage", "Rampage");
		end
		
		
		
	end -- end class-specific player buff checks
	
	-- Check through the buffs on the player that any class would want
	if (BuffWatcher_SVO["checkFood"] == true) then 						-- FOOD BUFF CHECK
		for i=1, 40 do
			buffName = GetPlayerBuffName(i);
			
			if (buffName == nil) then
				break;
			else
				buffIsActive = nil;
				buffIsActive = strfind(buffName, "Well Fed");
				if (buffIsActive ~= nil) then
					buff5 = true;
				end
			end
		end
		
		-- If there is a missing buff, set up the warning message
		if (buff5 == false) then
			displayText = displayText .. formatDisplay("Spell_Misc_Food", "Food buff");
		end
	end
	
	-- check for temporary weapon enchants, only if needed, on a per-hand basis
	if ((BuffWatcher_SVO["checkMH"] == true) or (BuffWatcher_SVO["checkOH"] == true)) then
		
		local has_mh_enchant, mh_expiration, mh_charges, has_oh_enchant, oh_expiration, oh_charges = GetWeaponEnchantInfo();
		local hasWeapon = OffhandHasWeapon();
		
		if (BuffWatcher_SVO["checkMH"] == true) then
			if (mh_expiration == nil) then
				buff6 = false;
				combatonly = false; -- this buff should only really be applied out-of-combat, so override combatonly behavior for these buffs
				
				-- If player is a Rogue or Shaman, use a special texture for the missing weapon buffs
				if (playerclass == "Rogue") then
					displayText = displayText .. formatDisplay("Ability_Rogue_DualWeild", "Weapon buff");
				elseif (playerclass == "Shaman") then
					displayText = displayText .. formatDisplay("Spell_Nature_Cyclone", "Weapon buff");
				else
					texture = GetInventoryItemTexture("player", 16)
					displayText = displayText .. formatDisplay(texture, "Weapon buff");
				end
			end
		end
		if ((BuffWatcher_SVO["checkOH"] == true) and (hasWeapon == 1)) then
			if (oh_expiration == nil) then
				buff6 = false;
				combatonly = false; -- this buff should only really be applied out-of-combat, so override combatonly behavior for these buffs
				
				-- If player is a Rogue or Shaman, use a special texture for the missing weapon buffs
				if (playerclass == "Rogue") then
					displayText = displayText .. formatDisplay("Ability_Rogue_DualWeild", "Weapon buff");
				elseif (playerclass == "Shaman") then
					displayText = displayText .. formatDisplay("Spell_Nature_Cyclone", "Weapon buff");
				else
					texture = GetInventoryItemTexture("player", 17)
					displayText = displayText .. formatDisplay(texture, "Weapon buff");
				end
			end
		end
		
		
		
	end -- end generic player buff checks
	
	
	-- If one of the buffs is missing, display the message
	if (displayText ~= "") then
		if (combatonly == true) then
			if (UnitAffectingCombat("player") == 1) then
				buffwatcherframe:Show();
				buffwatchertext:SetText(displayText);
			else
				buffwatcherframe:Hide();
			end
		else
			buffwatcherframe:Show();
			buffwatchertext:SetText(displayText);
		end
	else
		buffwatcherframe:Hide();
	end
	
	beenFormatted = false;
	
end -- end onEvent




-- This function is called once onLoad and whenever the "CHARACTER_POINTS_CHANGED" event fires.
	-- The "CHARACTER_POINTS_CHANGED" event is fired whenever someone gains a talent (from leveling up) or loses a talent (learning a new talent)
	-- (X, Y) is the location of the talent, this is NOT set in stone, it's dependent on the current layout of the talent tree. Whenever talent trees change, these numbers might need to be updated!
			-- GetTalentInfo(tabIndex, talentIndex)
			-- tabIndex: Integer - Specifies which tab the talent is in.  [ 1 ][ 2 ][ 3 ]
			-- talentIndex: Integer - Specifies which talent in the given tab. The talentIndex is counted left-to-right, top-to-bottom. Meaning that the left-most talent in the top row is number 1, followed by the one immediately to its right being number 2. If there are no more talents to the right then it continues from the left-most talent on the next row. 
function buffwatcher_TalentChange()
	
	checkTalent = false;
	currentRank = 0;
	
	if (playerclass == "Druid") then
		-- Does the player have the talented skill Omen of Clarity?
		nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(3,8);
		if (currentRank > 0) then
			checkTalent = true;
		end
		
		
	elseif (playerclass == "Hunter") then
		-- Does the player have the talented skill Trueshot Aura?
		nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(2, 17);
		if (currentRank > 0) then
			checkTalent = true;
		end
		
		
	elseif (playerclass == "Mage") then
		
		-- Mages currently have no talent to check for
		
		
	elseif (playerclass == "Paladin") then
		-- Does the player have talents in Improved Righteous Fury?
		nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(2, 7);
		if (currentRank > 0) then
			checkTalent = true;
		end
		
		
	elseif (playerclass == "Priest") then
		-- Does the player have the talented skill Divine Spirit?
		nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(1, 14);
		if (currentRank > 0)  then
			checkTalent = true;
		end
		
		
	elseif (playerclass == "Shaman") then
		
		-- Shamans currently have no talent to check for
		
		
	elseif (playerclass == "Warlock") then
		-- Does the player have the talented skill Soul Link?
		nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(2, 19);
		if (currentRank > 0) then
			checkTalent = true;
		end
		
		
	elseif (playerclass == "Warrior") then
		-- Does the player have the talented skill Rampage?
		nameTalent, iconPath, tier, column, currentRank = GetTalentInfo(2, 21);
		if (currentRank > 0) then
			checkTalent = true;
		end
		
		
	end
	
	-- Once the player is in the world, want to make sure the addon is movable and clickable only if they want it to be
	buffwatcherframe:SetMovable(BuffWatcher_SVO["isMovable"]);
	buffwatcherframe:EnableMouse(BuffWatcher_SVO["mouseEnabled"]);
	
	-- If the talent was successfully checked for, then unregister this event to prevent wasting computer resources on useless events.
	if (nameTalent ~= nil) then
		buffwatcherframe:UnregisterEvent("PLAYER_ALIVE");
	end
end



-- Whenever a warrior casts a spell, the spell is checked to see if it's Battle or Commanding Shout, so BuffWatcher knows which of the shouts to check for
function buffwatcher_WarriorShouted(theSpell)
	if (theSpell == "Battle Shout") then
		warriorShout = "Battle Shout";
		warrShoutIcon = "Ability_Warrior_BattleShout";
	elseif (theSpell == "Commanding Shout") then
		warriorShout = "Commanding Shout";
		warrShoutIcon = "Ability_Warrior_RallyingCry";
	end
end



--[[ buffwatcher_BGcheck - determines when to check for missing buffs in BG 
				-A- as normal (like outside a BG)
				-B- only if "prep" or "spirit healed"
				-C- not at all
	returns 'true' if BGcheck == (1) or (2 && the player is either recently rezzed or preparing)
	returns 'false' if BGcheck == (3) or (2 && the player is neither recently rezzed nor preparing)
]]
function buffwatcher_BGcheck()
	if (BuffWatcher_SVO["BGcheck"] == 1) then
		return true;
		
		
	elseif (BuffWatcher_SVO["BGcheck"] == 2) then
		for i=1, MAX_BATTLEFIELD_QUEUES do										-- for all the BGs you're queued for ...
			status = GetBattlefieldStatus(i);									-- ... check if you're in one.
			if (status == "active") then											-- If you are ...
				for j=1, 10, 1 do												-- ... then for 10 of your buffs (won't be more if you're dead/recently rezzed) ...
					buffName = GetPlayerBuffName(j);							--... get the name of the current buff ...
					if (buffName ~= nil) then									-- ... and if it exists ...
						buffIsActive = strfind(buffName, "Spirit Heal");			-- ...then check if the buff is "Spirit Heal".
						if (buffIsActive ~= nil) then							-- If it is ...
							-- you have the "recently rezzed" buff
							return true;										-- then we want to check for missing buffs (in the main function).
						else 													-- The buff isn't "Spirit Heal" ...
							buffIsActive = strfind(buffName, "Preparation");		-- ... so is it "Preparation" ?
							if (buffIsActive ~= nil) then						-- ... If it is ...
								-- you are "preparing"
								return true;									-- then we want to check for missing buffs (in the main function).
							end
						end
					else
						return false;	-- The buff we're checking doesn't exist, which means we checked all the buffs, and none of them were "Spirit Heal" nor "Preparation", so we don't want to check for missing buffs (in the main function)
					end
				end
				--[[local spiHealBuff, _ = GetPlayerBuffName("Spirit Heal");
				local prepBuff, _ = GetPlayerBuffName("Preparation");
				if ((spiHealBuff ~= nil) or (spiHealBuff ~= nil)) then
					return true;
				else
					return false;
				end]]
			end
		end
		
		
	elseif (BuffWatcher_SVO["BGcheck"] == 3) then
		return false;
	end
end



-- This function formats the warning message that is displayed when a buff is missing.
	-- iconName - This should be the name of the icon, found inside the Interface\\Icons\\ folder
	-- missingText - This is the name of the buff that is missing.
		-- Omen of Clarity would be "OoC", Mark of the Wild would be "MotW", Righteous Fury would be "Threat buff", etc
function formatDisplay(iconName, missingText)
	toReturn = "";
	
	if (BuffWatcher_SVO["showAllBuffs"] == true) then
		toReturn = "\n";
	elseif (beenFormatted == true) then
		return toReturn;
	end
	if (BuffWatcher_SVO["showIcons"] == true) then
		toReturn = toReturn .. "|TInterface\\Icons\\" .. iconName .. ":" .. BuffWatcher_SVO["fontSize"] * 1.25 .. "|t ";
	end
	if (BuffWatcher_SVO["showText"] == true) then
		toReturn = toReturn .. missingText .. " Missing!";
	end
	
	beenFormatted = true;
	
	return toReturn;
end








--=================================================--
--====== SLASH COMMANDS & RELATED FUNCTIONS =======--
--=================================================--

-- This function is called when the player inputs a string starting with "/bw"
	-- It takes the input (the rest of the command, if any) and calls the appropriate function on it, if needed
function buffwatcher_commandParser(msg)
	local Cmd, SubCmd = buffwatcher_GetCmd(msg);
	
	if (Cmd == "show") then
		buffwatcher_showFrame(); -- WORKS ! !
		
		
	elseif (Cmd == "hide") then
		buffwatcher_hideFrame(); -- WORKS ! !
		
		
	else
		DEFAULT_CHAT_FRAME:AddMessage("[BW] That command was not understood.", 0.39, 0.58, 0.93);
	end
end


-- This function is called when the player inputs	"/bw show"
	-- it forces the warning frame to show
function buffwatcher_showFrame()
	buffwatcherframe:Show();
	DEFAULT_CHAT_FRAME:AddMessage("[BW] The warning frame is now showing.", 0.39, 0.58, 0.93);
end


-- This function is called when the player inputs	"/bw hide"
	-- it forces the warning frame to hide
function buffwatcher_hideFrame()
	buffwatcherframe:Hide();
	DEFAULT_CHAT_FRAME:AddMessage("[BW] The warning frame is now hidden.", 0.39, 0.58, 0.93);
end

-- SUPPORT FUNCTION --
-- This function returns the first word (seperated by a space) as Cmd, and the rest of the input as the Subcmd
	-- From wowwiki.com
function buffwatcher_GetCmd(msg)
	if msg then
		local a,b,c=strfind(msg, "(%S+)"); -- contiguous string of non-space characters
		if a then
			return c, strsub(msg, b+2);
		else	
			return "";
		end
	end
end


SLASH_BUFFWATCHER1 = "/buffwatcher";
SLASH_BUFFWATCHER2 = "/bw"; -- A shortcut or alias
SlashCmdList["BUFFWATCHER"] = buffwatcher_commandParser;








--=================================================--
--========= FRAME & FONTSTRING VARIABLES ==========--
--=================================================--

-- create the frame. Register the events that make it activate, and set scripts on it such that it is good
buffwatcherframe = CreateFrame("Frame", "BuffWatcherFrame", UIParent);

buffwatcherframe:SetScript("OnEvent", buffwatcher_OnEvent);

-- these are needed to allow the frame to be movable
buffwatcherframe:SetScript("OnMouseDown",
	-- This function is called when the player attempts to begin moving buffwatcherframe
	function ()
		buffwatcherframe:StartMoving();
	end
);
	
buffwatcherframe:SetScript("OnMouseUp",
	-- This function is called when the player stops moving buffwatcherframe
	function ()
		buffwatcherframe:StopMovingOrSizing();
		
		BuffWatcher_SVO["x_loc"] = buffwatcherframe:GetLeft();
		BuffWatcher_SVO["y_loc"] = buffwatcherframe:GetTop();
		
		DEFAULT_CHAT_FRAME:AddMessage("[BW] The frame has been repositioned to " .. BuffWatcher_SVO["x_loc"] .. ", " .. BuffWatcher_SVO["y_loc"] .. ".", 0.39, 0.58, 0.93);
	end
);


-- register the events for the frame
buffwatcherframe:RegisterEvent("PLAYER_AURAS_CHANGED"); -- Fires when a buff or debuff is either applied to or is removed from the player
buffwatcherframe:RegisterEvent("CHARACTER_POINTS_CHANGED"); -- Fires when a player gains or uses a talent point
buffwatcherframe:RegisterEvent("PLAYER_REGEN_DISABLED"); -- Fires whenever you enter combat, as normal regen rates are disabled during combat
buffwatcherframe:RegisterEvent("PLAYER_REGEN_ENABLED"); -- Fires after ending combat, as regen rates return to normal
buffwatcherframe:RegisterEvent("PLAYER_UPDATE_RESTING"); -- Fires when the player starts or stops resting, i.e. when entering/leaving inns/major towns
buffwatcherframe:RegisterEvent("VARIABLES_LOADED"); -- Fires during the loading phase of the UI to indicate that the Saved Variables of all AddOns that will be loaded during the initial load (or reload) of the UI have have been read into memory from their files. 

if (playerclass == "Warrior") then
	-- Fires when a spell is successfully cast. 
		-- This will allow tracking of Battle/Commanding Shout, independent of the number of warriors in the party.
	buffwatcherframe:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
end

-- This event will be unregistered soon after the player logs in, so it actually only gets fired once
buffwatcherframe:RegisterEvent("PLAYER_ALIVE"); -- This event fires after PLAYER_ENTERING_WORLD. Talent information is now available to the UI 

buffwatcherframe:SetWidth(150);
buffwatcherframe:SetHeight(10);
buffwatcherframe:SetFrameStrata("HIGH");

-- Create the FontObject that will actually display the text when an error occurs
buffwatchertext = buffwatcherframe:CreateFontString("BuffWatcherFontString");
buffwatchertext:SetFontObject("GameFontNormalLarge");
buffwatchertext:SetText(" ");
buffwatchertext:SetPoint("TOPLEFT", 0, 0);




-- This function is called from buffwatcherIOPanel.lua, when the player clicks the locTestbtn
function testButton(tempX, tempY)
	buffwatcherframe:SetPoint("TOPLEFT", tempX, tempY);
end



function buffwatcher_initializeFrame()
	
	for index,value in pairs(defaults) do
		if (BuffWatcher_SVO[index] == nil) then
			BuffWatcher_SVO[index] = value;
		end
	end
	
	buffwatcherframe:SetPoint("TOPLEFT", BuffWatcher_SVO["x_loc"], BuffWatcher_SVO["y_loc"]);
	buffwatcherframe:SetMovable(BuffWatcher_SVO["isMovable"]);
	buffwatcherframe:EnableMouse(BuffWatcher_SVO["mouseEnabled"]);
	buffwatcherframe:RegisterForDrag(BuffWatcher_SVO["dragButton"]);
	
	buffwatchertext:SetFont("GameFontNormalLarge", BuffWatcher_SVO["fontSize"]);
	buffwatchertext:SetTextHeight(BuffWatcher_SVO["fontSize"]);
	
	
	buffwatcherframe:Hide();
	DEFAULT_CHAT_FRAME:AddMessage("[BW] BuffWatcher initialized.", 0.39, 0.58, 0.93);
	
	-- This function is inside buffwatcherIOPanel.lua
	--	It is only called now, and it sets the checked/unchecked, slider thumb position, etc, so they reflect the settings that are actually saved
	buffwatcherpanel_Initialize();
	
end
