BombersBuddy = LibStub("AceAddon-3.0"):NewAddon("BombersBuddy", "AceHook-3.0")

local bombersButton -- our secure button
local overrideOn = false -- do we have the override click active?
local ACTIONDOUBLEWAIT = 0.4 -- seconds to wait for the next click for doubleclicking
local lastClickTime = nil -- used to store the last click time for doubleclick detection
local armedBomb = false

local bombs = 
{
	[32406] = 
	{ 
		-- "Skyguard Blasting Charges"
		["l"] = {
					"Terokkar Forest"
				},
		["s"] = nil
	},
	[34475] =
	{
		-- "Arcane Charges"
		["l"] = {
					"Isle of Quel'Danas"
				},
		["s"] = {
					"The Dead Scar"
				}
	},
	[34489] =
	{
		-- "Flaming Oil"
		["l"] = {
					"Isle of Quel'Danas",
					"The North Sea"
				},
		["s"] = {
					"Sun's Reach Harbor",
					"The Bloodoath",
					"The Sin'loren",
					"The Dawnchaser"
				}		
	},
	[24538] =
	{
		-- "Fire Bomb"
		["l"] = {
					"Nagrand"
				},
		["s"] = nil		
	},
	[32456] =
	{
		-- "Skyguard Bombs"
		["l"] = {
					"Blade's Edge Mountains"
				},
		["s"] = nil		
	},
	[34862] =
	{
		-- "Practice Torches"
		["l"] = {
					"Orgrimmar"
				},
		["s"] = nil		
	},
}

function BombersBuddy:OnInitialize()
    -- Called when the addon is loaded
end

function BombersBuddy:OnEnable()

	self:CreateButton()
	self:HookScript( WorldFrame, "OnMouseDown", "WorldFrameOnMouseDown" )	

end

function BombersBuddy:OnDisable()
    -- Called when the addon is disabled
end

function BombersBuddy:ArmBomb()
	
	local bombName = self:GetBombInInventory()
	
	armedBomb = false

	if ( bombName and IsMounted() ) or ( bombName and bombName == "Practice Torches" ) then

		bombersButton:SetAttribute("type", "item")
		bombersButton:SetAttribute("item", bombName )
		armedBomb = true;

	end

	return armedBomb
	
end

function BombersBuddy:GetBombInInventory()
	
	for id, bomb in pairs( bombs ) do
		
		if( GetItemCount( id ) > 0 ) then
			
			if( self:MatchZoneText( GetRealZoneText(), bomb.l ) and ( not bomb.s or self:MatchZoneText( GetSubZoneText(), bomb.s ) ) ) then
				
				return GetItemInfo( id )
								
			end			
			
		end 
		
	end
	
	return nil

end

local function CheckForDoubleClick()
	
	if lastClickTime then
		
		local pressTime = GetTime()
		local doubleTime = pressTime - lastClickTime
		lastClickTime = pressTime
		if ( doubleTime < ACTIONDOUBLEWAIT ) then
			return true
		end
	
	end
	
	lastClickTime = GetTime()
	return false

end

function BombersBuddy:MatchZoneText( ZoneText, ZoneTable )
	
	if ZoneText == "" then
		
		return true
		
	end
	
	for index = 1, #ZoneTable, 1 do
		
		if ZoneText == ZoneTable[ index ] then
			
			return true
			
		end	
		
	end
	
	return false
	
end

function BombersBuddy:CreateButton()
	
	-- button already exists
	if bombersButton then return end
	
		bombersButton = CreateFrame("CheckButton", "BombersBuddyButton", UIParent, "ActionBarButtonTemplate")
		bombersButton:SetScript("OnAttributeChanged", ActionButton_Update)
		-- place ouside frame
		bombersButton:SetPoint("LEFT", UIParent, "RIGHT", 10000, 0)
		bombersButton:EnableMouse(true)
		bombersButton:RegisterForClicks("RightButtonUp")
		bombersButton:Hide()
		bombersButton:SetScript("PostClick", CleanupOverride)
	
end

-- Remove the overridebinding click after clicking or after setting a bomb
local function CleanupOverride()
	local wait = false
	
	if InCombatLockdown() then
		wait = true
	elseif overrideOn then
		ClearOverrideBindings( bombersButton )
		overrideOn = false		
	end

	if wait then
		BombersBuddy:ScheduleTimer( CleanupOverride, 1 )
	end
end

function BombersBuddy:WorldFrameOnMouseDown( this, button )
	
	if armedBomb and not CheckForDoubleClick() then
		
		CleanupOverride()
		armedBomb = false
		
	end
	
	if button == "RightButton" and not InCombatLockdown() and CheckForDoubleClick() then		
		-- We're stealing the mouse-up event, make sure we exit MouseLook
		if IsMouselooking() then MouselookStop() end
		
		if not armedBomb and self:ArmBomb() then
		
			SetOverrideBindingClick( bombersButton, true, "BUTTON2", "BombersBuddyButton" )
			overrideOn = true
		
		end
	end
	
end