﻿------------------------------
--      Are you local?      --
------------------------------

local name = "Vashj FFA"
local L = AceLibrary("AceLocale-2.2"):new("BigWigs"..name)
local boss = BB["Lady Vashj"]
local LBW = AceLibrary("AceLocale-2.2"):new("BigWigs"..boss)

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	cmd = "VashjFFA",

	enabled = "Enable FFA",
	enabled_desc = "Turn on setting loot to Free-For-All when engaging Vashj. (Needs Raid Leader)",

	ml = "Phase 3 ML",
	ml_desc = "Set loot to Master Looter in Phase 3.",

	ffa_msg = "Setting loot to FFA.",
	master_msg = "Setting loot to Master Looter.",
} end )

L:RegisterTranslations("frFR", function() return {
	enabled = "Activer Accès libre",
	enabled_desc = "Passe le butin en Accès libre lors de l'engagement de Dame Vashj (nécessite d'être le chef du raid).",

	master = "Désactiver le MB en phase 3",
	master_desc = "Désactive le Maître du butin en phase 3.",

	ffa_msg = "Passage du butin en Accès libre.",
	master_msg = "Passage du butin en Maître du butin.",
} end )

L:RegisterTranslations("zhCN", function() return {
	enabled = "启用自由拾取（FFA）",
	enabled_desc = "当激活瓦丝琪时，自动改变拾取模式为：自由拾取（FFA）！（需要团长权限）",

	ml = "第三阶段队长分配",
	ml_desc = "第三阶段时设置队长分配为启用。",

	ffa_msg = "设置拾取为：自由拾取（FFA）。",
	master_msg = "设置拾取为：队长分配（ML）。",
} end )

L:RegisterTranslations("koKR", function() return {
	enabled = "FFA 사용",
	enabled_desc = "2 단계시 자유 획득(FFA), 3단계시 담당자 획득으로 전환합니다.(지휘관 권한 요구)",

	master = "3 단계시 담당자 획득 사용안함",
	master_desc = "3 단계시 담당자 획득으로 설정하지 않습니다.",

	ffa_msg = "획득 방식을 자유 획득으로 설정하였습니다.",
	master_msg = "획득 방식을 담당자 획득으로 설정하였습니다.",
} end )

L:RegisterTranslations("zhTW", function() return {
	enabled = "啟用自由拾取（FFA）",
	enabled_desc = "當與瓦許女士戰鬥時，自動改變拾取方式為自由拾取（FFA）！（需要團長權限）",

	ml = "第三階段隊長分配",
	ml_desc = "第三階段時改回隊長分配。",

	ffa_msg = "拾取方式設定為：自由拾取（FFA）。",
	master_msg = "拾取方式設定為：隊長分配（ML）。",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

local mod = BigWigs:NewModule(name, "AceConsole-2.0")
mod.synctoken = name
mod.zonename = BZ["Serpentshrine Cavern"]
mod.enabletrigger = {boss}
mod.toggleoptions = {"enabled", "ml"}
mod.revision = tonumber(("$Revision: 76599 $"):sub(12, -3))
mod.external = true

------------------------------
--      Initialization      --
------------------------------

function mod:OnEnable()
	self:RegisterEvent("CHAT_MSG_MONSTER_YELL")
	self:RegisterEvent("BigWigs_RecvSync")
end

------------------------------
--      Event Handlers      --
------------------------------

function mod:BigWigs_RecvSync(sync, rest)
	if sync == "BWBossDeath" and rest == "Lady Vashj" then
		BigWigs:ToggleModuleActive(self, false)
	end
end

function mod:CHAT_MSG_MONSTER_YELL(msg)
	if not IsRaidLeader() then return end

	if self.db.profile.enabled and msg == LBW["phase2_trigger"] then
		SetLootMethod("freeforall")
		self:Print(L["ffa_msg"])
	end

	if self.db.profile.ml and msg == LBW["phase3_trigger"] then
		SetLootMethod("master", UnitName("player"))
		self:Print(L["master_msg"])
	end
end
