﻿--[[

Addon to display raid members with HP lower than 8500 on the Najentus encounter
Thanks to the BigWigs proximity module by Ammo from which a lot of this code is copied

]]

------------------------------
--      Are you local?      --
------------------------------

local name = "Naj Assist"
local L = AceLibrary("AceLocale-2.2"):new("BigWigs"..name)
local boss = BB["High Warlord Naj'entus"]
local LBW = AceLibrary("AceLocale-2.2"):new("BigWigs"..boss)

local BWNajHP = nil
local lowHP = {}

local table_insert = table.insert
local table_concat = table.concat
local fmt = string.format
local GetRaidRosterInfo = GetRaidRosterInfo
local select = select
local UnitHealth = UnitHealth
local UnitIsUnit = UnitIsUnit
local GetNumRaidMembers = GetNumRaidMembers
local UnitClass = UnitClass
local UnitExists = UnitExists
local UnitIsDeadOrGhost = UnitIsDeadOrGhost
local pairs = pairs

local hexColors = {}
for k, v in pairs(RAID_CLASS_COLORS) do
	hexColors[k] = ("|cff%02x%02x%02x"):format(v.r * 255, v.g * 255, v.b * 255)
end

-- Helper table to cache colored player names.
local coloredNames = setmetatable({}, {__index =
	function(self, key)
		if type(key) == "nil" then return nil end
		local _, class = UnitClass(key)
		if class then
			self[key] = hexColors[class] .. key .. "|r"
			return self[key]
		else
			return key
		end
	end
})

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	cmd = "NajAssist",

	on = "On",
	on_desc = "Toggle BigWigs_NajAssist on or off.",

	["Members < 8500 HP"] = true,
	["|cff777777Nobody|r"] = true,
	font = "Fonts\\FRIZQT__.TTF",
} end )

L:RegisterTranslations("koKR", function() return {
	on = "사용",
	on_desc = "BigWigs_NajAssist 켜거나 끕니다.",

	["Members < 8500 HP"] = "공대원 < 8500 체력",
	["|cff777777Nobody|r"] = "|cff777777아무도 없음|r",
	font = "Fonts\\2002.TTF",
} end )

L:RegisterTranslations("frFR", function() return {
	on = "Actif",
	on_desc = "Active ou non BigWigs_NajAssist.",

	["Members < 8500 HP"] = "Membres < 8500 PV",
	["|cff777777Nobody|r"] = "|cff777777Personne|r",
} end )

L:RegisterTranslations("zhCN", function() return {
	on = "启用",
	on_desc = "启用或禁用 BigWigs 高阶督军纳因图斯助手插件。",

	["Members < 8500 HP"] = "队员生命值 < 8500 HP",
	["|cff777777Nobody|r"] = "|cff777777没有玩家|r",
	font = "Fonts\\ZYKai_T.TTF",
} end )

L:RegisterTranslations("zhTW", function() return {
	on = "啟用",
	on_desc = "啟用或關閉 BigWigs 高階督軍納珍塔斯助手插件",

	["Members < 8500 HP"] = "隊員生命值 < 8500 HP",
	["|cff777777Nobody|r"] = "|cff777777没有玩家|r",
	font = "Fonts\\bHEI01B.TTF",
} end )

L:RegisterTranslations("ruRU", function() return {
	on = "On",
	on_desc = "Toggle BigWigs_NajAssist on or off.",

	["Members < 8500 HP"] = "Members < 8500 HP",
	["|cff777777Nobody|r"] = "|cff777777Nobody|r",
	font = "Fonts\\FRIZQT__.TTF",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

local mod = BigWigs:NewModule(name)
mod.synctoken = name
mod.zonename = BZ["Black Temple"]
mod.enabletrigger = boss
mod.toggleoptions = {"on"}
mod.revision = tonumber(("$Revision: 81684 $"):sub(12, -3))
mod.external = true

------------------------------
--      Initialization      --
------------------------------

function mod:OnEnable()
	self:RegisterEvent("BigWigs_RecvSync")
	self:RegisterEvent("CHAT_MSG_MONSTER_YELL")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")

	if BWNajHP then
		BWNajHP:Hide()
	end
end

------------------------------
--      Events              --
------------------------------

function mod:CHAT_MSG_MONSTER_YELL(msg)
	if not self.db.profile.on then return end

	if msg == LBW["start_trigger"] then
		if not BWNajHP then
			self:SetupFrames()
		else
			BWNajHP:Show()
		end

		self:ScheduleRepeatingEvent("BWNajHPCheck", self.Update, 0.5, self)
	end
end

function mod:BigWigs_RecvSync(sync, rest)
	if sync == "BWBossDeath" and rest == "High Warlord Naj'entus" then
		BigWigs:ToggleModuleActive(self, false)
		if BWNajHP then
			BWNajHP:Hide()
		end
	end
end

function mod:PLAYER_REGEN_ENABLED()
	if not self.db.profile.on then return end

	local go = self:Scan()
	local running = self:IsEventScheduled("Najentus_CheckWipe")
	if not go then
		self:TriggerEvent("BigWigs_RebootModule", self)
	elseif not running then
		self:ScheduleRepeatingEvent("Najentus_CheckWipe", self.PLAYER_REGEN_ENABLED, 2, self)
	end
end

local BT = BZ["Black Temple"]
function mod:Update()
	for i = 1, GetNumRaidMembers() do
		local name, _, _, _, _, _, zone = GetRaidRosterInfo(i)
		zone = zone or "Unknown"
		if UnitExists(name) and not UnitIsDeadOrGhost(name) and not UnitIsUnit(name, "player") and
		UnitHealth(name) <= 8500 and zone == BT then
			table_insert(lowHP, coloredNames[name])
		end
		if #lowHP > 4 then break end
	end
	if #lowHP == 0 then
		BWNajHP.text:SetText(L["|cff777777Nobody|r"])
	else
		BWNajHP.text:SetText(table_concat(lowHP, "\n"))
		for k in pairs(lowHP) do lowHP[k] = nil end
	end
end

function mod:SetupFrames()
	BWNajHP = CreateFrame("Frame", "BWNajHPDisplay", UIParent)

	BWNajHP:SetWidth(170)
	BWNajHP:SetHeight(100)

	BWNajHP:SetBackdrop({
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,
		edgeFile = "Interface\\AddOns\\BigWigs\\Textures\\otravi-semi-full-border", edgeSize = 32,
		insets = {left = 1, right = 1, top = 20, bottom = 1},
	})

	BWNajHP:SetBackdropColor(1, 1, 1, 0.2)
	BWNajHP:ClearAllPoints()
	BWNajHP:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	BWNajHP:EnableMouse(true)
	BWNajHP:RegisterForDrag("LeftButton")
	BWNajHP:SetClampedToScreen(true)
	BWNajHP:SetMovable(true)
	BWNajHP:SetScript("OnDragStart", function() this:StartMoving() end)
	BWNajHP:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		self:SavePosition()
	end)

	local cheader = BWNajHP:CreateFontString(nil, "OVERLAY")
	cheader:ClearAllPoints()
	cheader:SetWidth(190)
	cheader:SetHeight(15)
	cheader:SetPoint("TOP", BWNajHP, "TOP", 0, -14)
	cheader:SetFont(L["font"], 12)
	cheader:SetJustifyH("CENTER")
	cheader:SetText(L["Members < 8500 HP"])
	cheader:SetShadowOffset(.8, -.8)
	cheader:SetShadowColor(0, 0, 0, 1)
	BWNajHP.cheader = cheader

	local text = BWNajHP:CreateFontString(nil, "OVERLAY")
	text:ClearAllPoints()
	text:SetWidth( 190 )
	text:SetHeight( 80 )
	text:SetPoint( "TOP", BWNajHP, "TOP", 0, -35 )
	text:SetJustifyH("CENTER")
	text:SetJustifyV("TOP")
	text:SetFont(L["font"], 12)
	BWNajHP.text = text

	local x = self.db.profile.posx
	local y = self.db.profile.posy
	if x and y then
		local s = BWNajHP:GetEffectiveScale()
		BWNajHP:ClearAllPoints()
		BWNajHP:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
	end

	for k in pairs(lowHP) do lowHP[k] = nil end
end

function mod:SavePosition()
	if not BWNajHP then self:SetupFrames() end

	local s = BWNajHP:GetEffectiveScale()
	self.db.profile.posx = BWNajHP:GetLeft() * s
	self.db.profile.posy = BWNajHP:GetTop() * s
end
