﻿--[[

Frame to show:
Lady Sacrolash Threat Position 3
Grand Warlock Alythess Threat Position 2

]]

------------------------------
--      Are you local?      --
------------------------------

local name = "Eredar Threat"
local L = AceLibrary("AceLocale-2.2"):new("BigWigs"..name)
local lady = BB["Lady Sacrolash"]
local lock = BB["Grand Warlock Alythess"]
local boss = BB["The Eredar Twins"]
local ladyGUID = nil
local lockGUID = nil
local threat = LibStub("Threat-2.0")

local BWEredarFrame = nil

local hexColors = {}
for k, v in pairs(RAID_CLASS_COLORS) do
	hexColors[k] = ("|cff%02x%02x%02x"):format(v.r * 255, v.g * 255, v.b * 255)
end

-- Helper table to cache colored player names.
local coloredNames = setmetatable({}, {__index =
	function(self, key)
		if type(key) == "nil" then return nil end
		local _, class = UnitClass(key)
		if class then
			self[key] = hexColors[class] .. key .. "|r"
			return self[key]
		else
			return key
		end
	end
})

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	cmd = "EredarThreat",

	on = "On",
	on_desc = "Toggle BigWigs_EredarThreat on or off.",

	threat = "Threat",

	font = "Fonts\\FRIZQT__.TTF",
} end )

L:RegisterTranslations("koKR", function() return {
	on = "사용",
	on_desc = "BigWigs_EredarThreat 켜거나 끕니다.",
	
	threat = "위협",

	font = "Fonts\\2002.TTF",
} end )

L:RegisterTranslations("frFR", function() return {
	on = "Actif",
	on_desc = "Active ou non BigWigs_EredarThreat.",

	threat = "Menace",
} end )

L:RegisterTranslations("zhCN", function() return {
	on = "启用",
	on_desc = "启用或禁用 BigWigs 艾瑞达双子仇恨插件。",

	threat = "仇恨",

	font = "Fonts\\ZYKai_T.TTF",
} end )

L:RegisterTranslations("zhTW", function() return {
	on = "啟用",
	on_desc = "啟用或關閉 BigWigs 埃雷達爾雙子仇恨插件。",

	threat = "仇恨",

	font = "Fonts\\bHEI01B.TTF",
} end )


----------------------------------
--      Module Declaration      --
----------------------------------

local mod = BigWigs:NewModule(name)
mod.synctoken = name
mod.zonename = BZ["Sunwell Plateau"]
mod.enabletrigger = {lady, lock}
mod.toggleoptions = {"on"}
mod.revision = tonumber(("$Revision: 76599 $"):sub(12, -3))
mod.external = true

------------------------------
--      Initialization      --
------------------------------

function mod:OnEnable()
	self:RegisterEvent("BigWigs_RecvSync")
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")

	if not BWEredarFrame then
		self:SetupFrames()
	else
		BWEredarFrame:Show()
	end
	if self.db.profile.on then
		self:ScheduleRepeatingEvent("BWEredarFrameCheck", self.Update, 1, self)
	end

	self:Throttle(600, "LADY", "LOCK")
end

------------------------------
--      Events              --
------------------------------

function mod:BigWigs_RecvSync(sync, rest)
	if sync == "BWMultiBossDeath" and rest == "The Eredar Twins" then
		BigWigs:ToggleModuleActive(self, false)
		if BWEredarFrame then
			BWEredarFrame:Hide()
		end
	elseif sync == "LADY" and rest then
		ladyGUID = rest
	elseif sync == "LOCK" and rest then
		lockGUID = rest
	end
end

function mod:UPDATE_MOUSEOVER_UNIT()
	self:TargetCheck("mouseover")
end

function mod:PLAYER_TARGET_CHANGED()
	self:TargetCheck("target")
end

function mod:TargetCheck(unit)
	if UnitIsCorpse(unit) or UnitIsDead(unit) or UnitPlayerControlled(unit) then return end
	local guid = UnitGUID(unit)
	if not guid then return end
	local mobid = tonumber(guid:sub(-12, -7), 16)
	if mobid == 25165 then
		self:Sync("LADY", guid)
	elseif mobid == 25166 then
		self:Sync("LOCK", guid)
	end
end

function mod:Update()
	if not ladyGUID then
		BWEredarFrame.text:SetText("nil")
		return BigWigs:Print("Mouseover "..lady..". GUID not found!")
	elseif not lockGUID then
		BWEredarFrame.text:SetText("nil")
		return BigWigs:Print("Mouseover "..lock..". GUID not found!")
	end

	local lady_player, lady_threat = threat:GetPlayerAtPosition(ladyGUID, 3)
	local lock_player, lock_threat = threat:GetPlayerAtPosition(lockGUID, 2)

	if not lady_player or not lock_player then
		BWEredarFrame.text:SetText("nil")
	end

	lady_player = threat.GUIDNameLookup[lady_player]
	lock_player = threat.GUIDNameLookup[lock_player]

	lady_player = coloredNames[lady_player]
	lock_player = coloredNames[lock_player]

	BWEredarFrame.text:SetText(lady..": #3 ("..lady_player..")\n"..lock..": #2 ("..lock_player..")")
end

function mod:SetupFrames()
	BWEredarFrame = CreateFrame("Frame", "BWEredarFrameDisplay", UIParent)

	BWEredarFrame:SetWidth(210)
	BWEredarFrame:SetHeight(100)

	BWEredarFrame:SetBackdrop({
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,
		edgeFile = "Interface\\AddOns\\BigWigs\\Textures\\otravi-semi-full-border", edgeSize = 32,
		insets = {left = 1, right = 1, top = 20, bottom = 1},
	})

	BWEredarFrame:SetBackdropColor(24/255, 24/255, 24/255)
	BWEredarFrame:ClearAllPoints()
	BWEredarFrame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	BWEredarFrame:EnableMouse(true)
	BWEredarFrame:RegisterForDrag("LeftButton")
	BWEredarFrame:SetClampedToScreen(true)
	BWEredarFrame:SetMovable(true)
	BWEredarFrame:SetScript("OnDragStart", function() this:StartMoving() end)
	BWEredarFrame:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		self:SavePosition()
	end)

	local cheader = BWEredarFrame:CreateFontString(nil, "OVERLAY")
	cheader:ClearAllPoints()
	cheader:SetWidth(190)
	cheader:SetHeight(15)
	cheader:SetPoint("TOP", BWEredarFrame, "TOP", 0, -14)
	cheader:SetFont(L["font"], 12)
	cheader:SetJustifyH("CENTER")
	cheader:SetText(L["threat"])
	cheader:SetShadowOffset(.8, -.8)
	cheader:SetShadowColor(0, 0, 0, 1)
	BWEredarFrame.cheader = cheader

	local text = BWEredarFrame:CreateFontString(nil, "OVERLAY")
	text:ClearAllPoints()
	text:SetWidth(190)
	text:SetHeight(250)
	text:SetPoint("TOP", BWEredarFrame, "TOP", 0, -35)
	text:SetJustifyH("CENTER")
	text:SetJustifyV("TOP")
	text:SetFont(L["font"], 12)
	BWEredarFrame.text = text

	local x = self.db.profile.posx
	local y = self.db.profile.posy
	if x and y then
		local s = BWEredarFrame:GetEffectiveScale()
		BWEredarFrame:ClearAllPoints()
		BWEredarFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
	end
end

function mod:SavePosition()
	if not BWEredarFrame then self:SetupFrames() end

	local s = BWEredarFrame:GetEffectiveScale()
	self.db.profile.posx = BWEredarFrame:GetLeft() * s
	self.db.profile.posy = BWEredarFrame:GetTop() * s
end
