--[[
--
-- BigWigs Strategy Module 
--
-- Warns the raid when a dispel is resisted.
--
--]]

------------------------------
--      Are you local?      --
------------------------------

local name = "Dispel Resist"
local L = AceLibrary("AceLocale-2.2"):new("BigWigs"..name)

local times = nil

L:RegisterTranslations("enUS", function() return {
	["Dispel Resist"] = true,
	["DispelResist"] = true,
	["Optionally broadcast the raid when a dispel is resisted."] = true,
	["broadcast"] = true,
	["Broadcast"] = true,
	["Toggle broadcasting."] = true,
	["On"] = true,
	["on"] = true,
	["Toggles the plugin on and off."] = true,
	["Mass Dispel"] = true,
	["Dispel Magic"] = true,
	["Purge"] = true,
	["%s's %s was resisted by %s!"] = true,
} end )

L:RegisterTranslations("zhCN", function() return {
	["Dispel Resist"] = "驱散抵抗",
	["Optionally broadcast the raid when a dispel is resisted."] = "当驱散被抵抗发出警报",
	["broadcast"] = "警报",
	["Broadcast"] = "警报",
	["Toggle broadcasting."] = "切换警报",
	["On"] = "打开",
	["on"] = "打开",
	["Toggles the plugin on and off."] = "切换打开/关闭插件",
	["Mass Dispel"] = "群体驱散",
	["Dispel Magic"] = "驱散魔法",
	["Purge"] = "净化术",
	["%s's %s was resisted by %s!"] = "%s的%s被%s抵抗了!",
} end )

BigWigsDispelResist = BigWigs:NewModule(name)
BigWigsDispelResist.defaultDB = {
	broadcast = false,
	on = true,
}

BigWigsDispelResist.consoleCmd = L["DispelResist"]
BigWigsDispelResist.consoleOptions = {
	type = "group",
	name = L["Dispel Resist"],
	desc = L["Optionally broadcast the raid when a dispel is resisted."],
	args   = {
		[L["on"]] = {
			type = "toggle",
			name = L["On"],
			desc = L["Toggles the plugin on and off."],
			get = function() return BigWigsDispelResist:IsEventRegistered("COMBAT_LOG_EVENT_UNFILTERED") end,
			set = function(v)
				BigWigsDispelResist.db.profile.on = v
				if v then
					BigWigsDispelResist:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				else
					BigWigsDispelResist:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				end
			end,
		},
		[L["broadcast"]] = {
			type = "toggle",
			name = L["Broadcast"],
			desc = L["Toggle broadcasting."],
			get = function() return BigWigsDispelResist.db.profile.broadcast end,
			set = function(v) BigWigsDispelResist.db.profile.broadcast = v end,
		},
	}
}
BigWigsDispelResist.revision = 1
BigWigsDispelResist.external = true

function BigWigsDispelResist:OnEnable()
	if self.db.profile.on then
		self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	end
	times = {}
end

function BigWigsDispelResist:COMBAT_LOG_EVENT_UNFILTERED(tstamp, event, srcGUID, srcName, srcFlags, destGUID, destName, destFlags, spellId, spellName, spellSchool,...)
	if not UnitInRaid("player") then return end
	
	if spellName == L["Dispel Magic"] or spellName == L["Mass Dispel"] or spellName == L["Purge"] then
		if event == "SPELL_DISPEL_FAILED" then
			self:TriggerEvent("BigWigs_Message", format(L["%s's %s was resisted by %s!"], srcName, spellName, destName), "Orange", not self.db.profile.broadcast)
			return
		end
	end
end