local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("Tooltips", "AceHook-3.0")

function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("Tooltips", {profile = {enabled = true,},})
end

function module:OnModuleEnable()
	self:HookScript(GameTooltip, "OnTooltipSetUnit")
	self:HookScript(GameTooltip, "OnTooltipSetItem")
end

function module:OnTooltipSetUnit(tooltip, ...)
	local name = tooltip:GetUnit()
	if name and quixote:IsQuestMob(name) then
		for _, uid in quixote:IterateQuestsForMob(name) do
			local _, _, title = quixote:GetQuestByUid(uid)
			local _, got, need = quixote:GetQuestObjective(uid, name)
			tooltip:AddDoubleLine(title, got..'/'..need, 1, 1, 1, core:GetColorFromCompletion(got/need))
		end
	end
end

function module:OnTooltipSetItem(tooltip, ...)
	local t = tooltip:GetItem()
	if t then
		local uid, objective, got, need = quixote:IsQuestItem(t)
		if uid then
			local _, _, title = quixote:GetQuestByUid(uid)
			tooltip:AddDoubleLine(title, got..'/'..need, 1, 1, 1, core:GetColorFromCompletion(got/need))
		end
	end
end
