local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")

local module = core:NewModule("Spam")

function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("Spam", {
		profile = {
			questcomplete = false,
			objcomplete = false,
			objprogress = false,
			enabled = false,
		},
	})
	self.menu = {
		questcomplete = {name = "Quest Completion", type = "toggle",},
		objcomplete = {name = "Objective Completion", type = "toggle",},
		objprogress = {name = "Objective Progress", type = "toggle",},
	}
end

function module:OnModuleEnable()
	quixote.RegisterCallback(self, "Objective_Update")
	quixote.RegisterCallback(self, "Quest_Complete")
	quixote.RegisterCallback(self, "Quest_Failed")
end

function module:Quest_Complete(event, title, uid)
	if self.db.profile.questcomplete and GetNumPartyMembers() > 0 then
		SendChatMessage(ERR_QUEST_COMPLETE_S:format(title), "PARTY")
	end
end
function module:Quest_Failed(event, title, uid)
	if self.db.profile.questcomplete and GetNumPartyMembers() > 0 then
		SendChatMessage(ERR_QUEST_FAILED_S:format(title), "PARTY")
	end
end
function module:Objective_Update(event, title, uid, description, had, got, need, otype)
	local db = self.db.profile
	if GetNumPartyMembers() > 0 and (db.objcomplete or db.objprogress) then
		if got == need then
			if db.objprogress or db.objcomplete then
				SendChatMessage(ERR_QUEST_COMPLETE_S:format("("..title..") "..description), "PARTY")
			end
		else
			SendChatMessage(ERR_QUEST_ADD_ITEM_SII:format("("..title..") "..description, numGot, numNeeded), "PARTY")
		end
	end
end
