local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("Sounds")

local function indexof(t, value)
	for i,v in ipairs(t) do
		if v == value then
			return i
		end
	end
end
local sound_files = {
	[[Interface\Addons\BetterQuest\modules\sounds\Peasant_work_done.mp3]], -- Work done!
	[[Sound\Creature\Peasant\PeasantWhat3.wav]], --More work?
	[[Sound\Creature\Peon\PeonBuildingComplete1.wav]], -- Work complete!
	[[Sound\Creature\Peon\PeonReady1.wav]], -- Ready to work!
	[[QUESTADDED]],
	[[QUESTCOMPLETED]],
	[[Sound\Interface\igPlayerBind.wav]],
	[[LEVELUPSOUND]],
	[[Interface\Quiet.mp3]],
}
local sound_names = {
	"Peasant: Work done!",
	"Peasant: More work?",
	"Peon: Work complete!",
	"Peon: Ready to work!",
	"Quest added",
	"Quest completed",
	"Thrumm",
	"Level up",
	"None",
}

local db
function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("Sounds", {
		profile = {
			complete = indexof(sound_names, "Peasant: Work done!"),
			progress = indexof(sound_names, "Peon: Ready to work!"),
			failed = indexof(sound_names, "Thrumm"),
			enabled = true,
		},
	})
	db = self.db
	local play_set = function(info, value)
		self.db.profile[info[#info]] = value
		self:PlaySound(sound_files[value])
	end
	self.menu = {
		complete = {name = "Quest complete", type = "select", style = "dropdown", values = sound_names, set = play_set,},
		progress = {name = "Quest progress", type = "select", style = "dropdown", values = sound_names, set = play_set,},
		failed = {name = "Quest failed", type = "select", style = "dropdown", values = sound_names, set = play_set,},
	}
end

function module:OnModuleEnable()
	quixote.RegisterCallback(self, "Objective_Update")
	quixote.RegisterCallback(self, "Quest_Complete")
	quixote.RegisterCallback(self, "Quest_Failed")
end

function module:PlaySound(sound)
	if sound:match([[\]]) then
		PlaySoundFile(sound)
	else
		PlaySound(sound)
	end
end

function module:Objective_Update(event, title, uid, desc, old, got, need)
	local complete = select(7, quixote:GetQuestByUid(uid))
	if complete == nil and got == need then
		self:PlaySound(sound_files[db.profile.progress])
	end
end

function module:Quest_Complete(event, title, uid)
	self:PlaySound(sound_files[db.profile.complete])
end

function module:Quest_Failed(event, title, uid)
	self:PlaySound(sound_files[db.profile.failed])
end
