local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("Sink", "AceHook-3.0", "LibSink-2.0")

function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("Sink", {
		profile = {
			self = {
				questcomplete = true,
				objcomplete = true,
				objprogress = true,
			},
			party = {
				questcomplete = true,
				objcomplete = true,
				objprogress = true,
			},

			questnames = true,
			suppress = true,
			enabled = true,

			sink = {},
		},
	})
	local args = {
		questcomplete = {name = "Quest Completion", type = "toggle",},
		objcomplete = {name = "Objective Completion", type = "toggle",},
		objprogress = {name = "Objective Progress", type = "toggle",},
	}
	local get = function(info) return self.db.profile[info[#info - 1]][info[#info]] end
	local set = function(info, value) self.db.profile[info[#info - 1]][info[#info]] = value end
	self.menu = {
		self = {
			name = "Player", type = "group",
			get = get, set = set, args = args,
		},
		party = {
			name = "Party", type = "group",
			get = get, set = set, args = args,
		},
		questnames = {name = "Show quest names", type = "toggle",},
		suppress = {name = "Suppress default", desc = "Hide quest messages that would display in the UIErrorsFrame", type = "toggle",},
	}
	self.menu.output = self:GetSinkAce3OptionsDataTable()
	self:SetSinkStorage(self.db.profile.sink)
end

function module:OnModuleEnable()
	quixote.RegisterCallback(self, "Objective_Update")
	quixote.RegisterCallback(self, "Quest_Complete")
	quixote.RegisterCallback(self, "Quest_Failed")
	quixote.RegisterCallback(self, "Party_Objective_Update")
	quixote.RegisterCallback(self, "Party_Quest_Complete")
	quixote.RegisterCallback(self, "Party_Quest_Failed")
	self:RawHook("UIErrorsFrame_OnEvent", true)
end

local function patternize(s) return '^' .. s:gsub('(%%.)', '(.+)') .. '$' end
local found = patternize(ERR_QUEST_ADD_FOUND_SII) -- "%s: %d/%d"
local item = patternize(ERR_QUEST_ADD_ITEM_SII) -- "%s: %d/%d"
local kill = patternize(ERR_QUEST_ADD_KILL_SII) -- "%s slain: %d/%d"
local complete = patternize(ERR_QUEST_OBJECTIVE_COMPLETE_S) -- "%s (Complete)"
function module:UIErrorsFrame_OnEvent(...)
	if self.db.profile.suppress and event == "UI_INFO_MESSAGE" and
		(msg:match(found) or msg:match(item) or msg:match(kill) or msg:match(complete)) then return end
	return self.hooks["UIErrorsFrame_OnEvent"](...)
end

function module:Quest_Complete(event, title, uid)
	if self.db.profile.self.questcomplete then
		--ERR_QUEST_ACCEPTED_S = "Quest accepted: %s"
		self:Pour(ERR_QUEST_COMPLETE_S:format(title), core:GetColorFromCompletion(1))
	end
end
function module:Quest_Failed(event, title, uid)
	if self.db.profile.self.questcomplete then
		--ERR_QUEST_FAILED_S = "%s failed."
		self:Pour(ERR_QUEST_FAILED_S:format(title), core:GetColorFromCompletion(0))
	end
end
function module:Objective_Update(event, title, uid, description, had, got, need, otype)
	local db = self.db.profile
	if db.questnames then
		description = "("..title..") "..description
	end
	if got == need then
		local objectives, complete = quixote:GetNumQuestObjectives(uid)
		if db.self.questcomplete and objectives == complete then return end
		if db.self.objcomplete or db.self.objprogress then
			-- ERR_QUEST_COMPLETE_S = "%s completed."
			self:Pour(ERR_QUEST_COMPLETE_S:format(description), core:GetColorFromCompletion(1))
		end
	elseif db.self.objprogress then
		-- ERR_QUEST_ADD_ITEM_SII = "%s: %d/%d"
		if otype == 'reputation' then
			self:Pour(ERR_QUEST_ADD_ITEM_SII:format(description, got, need), core:GetColorFromCompletion(quixote:GetReactionLevel(got)/quixote:GetReactionLevel(need)))
		else
			self:Pour(ERR_QUEST_ADD_ITEM_SII:format(description, got, need), core:GetColorFromCompletion(tonumber(got)/tonumber(need)))
		end
	end
end

function module:Party_Quest_Complete(event, sender, uid, title)
	if self.db.profile.party.questcomplete then
		--ERR_QUEST_ACCEPTED_S = "Quest accepted: %s"
		self:Pour(ERR_QUEST_COMPLETE_S:format("(" .. sender .. ") " .. title), core:GetColorFromCompletion(1))
	end
end
function module:Party_Quest_Failed(event, sender, uid, title)
	if self.db.profile.party.questcomplete then
		--ERR_QUEST_FAILED_S = "%s failed."
		self:Pour(ERR_QUEST_FAILED_S:format("(" .. sender .. ") " .. title), core:GetColorFromCompletion(0))
	end
end
function module:Party_Objective_Update(event, sender, uid, title, description, got, need, isrep)
	local db = self.db.profile
	if db.questnames then
		description = "("..sender..':'..title..") "..description
	else
		description = "("..sender..") "..description
	end
	if got == need then
		local objectives, complete = quixote:GetPartyQuestNumObjectives(sender, uid)
		if db.party.questcomplete and objectives == complete then return end
		if db.party.objcomplete or db.party.objprogress then
			-- ERR_QUEST_COMPLETE_S = "%s completed."
			self:Pour(ERR_QUEST_COMPLETE_S:format(description), core:GetColorFromCompletion(1))
		end
	elseif db.party.objprogress then
		-- ERR_QUEST_ADD_ITEM_SII = "%s: %d/%d"
		if isrep then
			self:Pour(ERR_QUEST_ADD_ITEM_SII:format(description, got, need), core:GetColorFromCompletion(quixote:GetReactionLevel(got)/quixote:GetReactionLevel(need)))
		else
			self:Pour(ERR_QUEST_ADD_ITEM_SII:format(description, got, need), core:GetColorFromCompletion(tonumber(got)/tonumber(need)))
		end
	end
end

