local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("Givers", "AceHook-3.0")

function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("Givers", {char = {givers = {},},})
end

function module:OnModuleEnable()
	--self:Hook("AcceptQuest", true) -- TODO: This should probably be in Quixote
	self:SecureHook("QuestLog_SetSelection")
	quixote.RegisterCallback(self, "Quest_Gained")
	quixote.RegisterCallback(self, "Quest_Lost")
	quixote.RegisterCallback(self, "Update", "Cleanup")
end

function module:Cleanup()
	for uid in pairs(self.db.char.givers) do
		if not quixote:GetQuestByUid(uid) then
			self.db.char.givers[uid] = nil
		end
	end
	quixote.UnregisterCallback(self, "Update")
end

function module:Quest_Gained(event, title, uid, objectives, zone, npc, npc_is_player)
	if (not npc) or npc_is_player then
		self.db.char.givers[GetTitleText()] = "Item or other player"
	else
		local x,y = GetPlayerMapPosition("player")
		self.db.char.givers[uid] = ("%s in %s (%d,%d)"):format(npc, GetZoneText(), floor(x*100), floor(y*100))
	end
end

function module:Quest_Lost(title, uid)
	self.db.char.givers[uid] = nil
end

function module:QuestLog_SetSelection(id)
	local uid, qid, title = quixote:GetQuestById(id)
	local giver = self.db.char.givers[uid]
	if giver then
		QuestLogObjectivesText:SetText(giver .. '\n\n' .. QuestLogObjectivesText:GetText())
	end
end
