local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("FuBar", "LibFuBarPlugin-Mod-3.0")

local db
function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("FuBar", {
		profile = {enabled = true,},
	})
	db = self.db
	--self.menu = {}
	self:SetFuBarOption('iconPath', [[Interface\Icons\INV_Misc_Shovel_01]])
	self:SetFuBarOption('tooltipType', "Custom")
	self:SetFuBarOption('configType', "AceConfigDialog-3.0")
	self:SetFuBarOption('aceConfig3', "Better Quest Tracker")
	self:SetFuBarOption('defaultPosition', "RIGHT")
end

function module:OnModuleEnable()
	self.tooltip = core:CreateTracker('fubar')
	self.tooltip:Hide()
	--core.db.profile.trackers['fubar'].enabled = true
end

function module:OnUpdateFuBarText()
	local total, complete = quixote:GetNumQuests()
	self:SetFuBarText(("%d/%d"):format(complete, total))
end

function module:OnUpdateFuBarTooltip()
	-- /script LibStub("AceAddon-3.0"):GetAddon("BetterQuest"):GetModule("FuBar"):UpdateFuBarTooltip()
	local is_shown = self.tooltip:IsShown()
	core:UpdateTracker('fubar')
	if not is_shown then self.tooltip:Hide() end
end

function module:OnFuBarEnter()
	self.tooltip:Attach("TOPLEFT", self:GetFrame(), "BOTTOMLEFT"):SetPosition():Show()
end

function module:OnFuBarLeave()
	self.tooltip:Hide()
end
