local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("Blizzard", "AceHook-3.0", "AceEvent-3.0")

local db
function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("Blizzard", {
		profile = {
			levels_log = true,
			levels_dialog = true,
			--levels_lfg = true,
			icons_dialog = true,
			enabled = true,
		},
	})
	db = self.db
	self.menu = {
		levels_log = {name = "Levels in questlog", type = "toggle",},
		levels_dialog = {name = "Levels in NPC dialogs", type = "toggle",},
		icons_dialog = {name = "Fade icons in NPC dialogs", type = "toggle",},
	}
end

function module:OnModuleEnable()
	self:OnSettingsUpdate()
end

function module:OnSettingsUpdate()
	-- In quest log
	if db.profile.levels_log then
		if not self:IsHooked("QuestLog_Update") then
			self:SecureHook("QuestLog_Update")
		end
	elseif self:IsHooked("QuestLog_Update") then
		self:Unhook("QuestLog_Update")
	end
	-- In dialogs
	if db.profile.levels_dialog or db.profile.icons_dialog then
		self:RegisterEvent("GOSSIP_SHOW")
		self:RegisterEvent("QUEST_GREETING")
	else
		self:UnregisterEvent("GOSSIP_SHOW")
		self:UnregisterEvent("QUEST_GREETING")
	end
end

-- Levels in the quest log:

function module:QuestLog_Update()
	local offset, numEntries = FauxScrollFrame_GetOffset(QuestLogListScrollFrame), GetNumQuestLogEntries()
	for i = 1, QUESTS_DISPLAYED, 1 do
		local index = offset + i
		if index > numEntries then break end
		local titleLine = _G["QuestLogTitle"..i]
		if titleLine then
			local uid, id, _, _, _, _, complete = quixote:GetQuestById(i + offset)
			if uid then
				-- If the quest isn't complete, clear out the tag, for its info has been moved to the title.
				local tag = _G["QuestLogTitle"..i.."Tag"]
				if (not complete) or (complete == 0) then
					tag:SetText("")
				end
				local title = quixote:GetTaggedQuestName(uid)
				titleLine:SetText(title)
				QuestLogDummyText:SetText(title)
				_G["QuestLogTitle"..i.."NormalText"]:SetWidth(math.min(QuestLogDummyText:GetWidth(), QuestLogListScrollFrame:GetWidth() - tag:GetWidth() - 15))
				
				local check = _G["QuestLogTitle" .. i .. "Check"]
				if check:IsVisible() then
					check:SetPoint("RIGHT", titleLine, "LEFT")
				end
			end
		end
	end
end

-- Levels in NPC dialogs:

local function quest_icon_faded(title)
	local objectives, complete = select(6, quixote:GetQuest(title))
	-- if we don't have the quest, we don't fade it:
	if objectives == nil and complete == nil then return false end
	return not (complete == 1 or objectives == 0)
end

local function gossip_loop(buttonindex, do_texture, ...)
	local numQuests = select('#', ...)
	for i=2, numQuests, 3 do
		local button = _G["GossipTitleButton"..buttonindex]
		local level = select(i, ...)
		button:SetText(format('[%s] %s', level == -1 and '*' or level, button:GetText()))
		if do_texture and quest_icon_faded(quixote:GetQuest(select(i-1, ...))) then
			_G["GossipTitleButton"..buttonindex.."GossipIcon"]:SetVertexColor(0.5, 0.5, 0.5, 0.5)
		else
			_G["GossipTitleButton"..buttonindex.."GossipIcon"]:SetVertexColor(1, 1, 1, 1)
		end
		buttonindex = buttonindex + 1
	end
	return buttonindex + 1
end

function module:GOSSIP_SHOW()
	local buttonindex = 1
	if GetGossipAvailableQuests() then
		buttonindex = gossip_loop(buttonindex, false, GetGossipAvailableQuests())
	end
	if GetGossipActiveQuests() then
		buttonindex = gossip_loop(buttonindex, db.profile.icons_dialog, GetGossipActiveQuests())
	end
end

function module:QUEST_GREETING()
	local do_texture = db.profile.icons_dialog
	local numactive, numavailable = GetNumActiveQuests(), GetNumAvailableQuests()
	local title, level
	local o,GetTitle,GetLevel = 0,GetActiveTitle,GetActiveLevel
	for i=1, numactive + numavailable do
		if i == numactive + 1 then
			o,GetTitle,GetLevel = numactive,GetAvailableTitle,GetAvailableLevel
		end
		title, level = GetTitle(i-o), GetLevel(i-o)
		_G["QuestTitleButton"..i]:SetText(format('[%d] %s', level == -1 and '*' or level, title))
		if do_texture and quest_icon_faded(title) then
			_G["QuestTitleButton"..i.."QuestIcon"]:SetVertexColor(0.5, 0.5, 0.5, 0.5)
		else
			_G["QuestTitleButton"..i.."QuestIcon"]:SetVertexColor(1, 1, 1, 1)
		end
	end
end
