local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local quixote = LibStub("LibQuixote-2.0")

local base = {}
local disable = {
	name = "Disable", type = "execute", order = -1,
	func = function(info) core:DisableModule(info[#info - 1]) end
}
function base:OnInitialize()
	self:OnModuleInitialize()
	if not self.menu then self.menu = {} end
	self.menu.disable = disable
	core.options.modules.args[self.moduleName] = {
		name = self.moduleName, type = "group",
		get = function(info) return self.db.profile[info[#info]] end,
		set = function(info, value)
			self.db.profile[info[#info]] = value
			if self.OnSettingsUpdate then self:OnSettingsUpdate(info[#info], value) end
		end,
		args = self.menu,
	}
	if self.db and not self.db.profile.enabled then
		self:SetEnabledState(false)
		self:Disable()
		self:OnDisable()
	end
end

function base:OnEnable()
	if self.db then self.db.profile.enabled = true end
	if self.OnModuleEnable then self:OnModuleEnable() end
	core.options.modules.args[self.moduleName].args = self.menu
end

function base:OnDisable()
	if self.db then self.db.profile.enabled = false end
	quixote.UnregisterAll(self)
	core.options.modules.args[self.moduleName].args = {
		enable = {
			name = "Enable", type = "execute",
			func = function(info) core:EnableModule(info[#info - 1]) end
		},
	}
	if self.OnModuleDisable then self:OnModuleDisable() end
end

core:SetDefaultModulePrototype(base)
