local quixote = LibStub("LibQuixote-2.0")
local core = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local module = core:NewModule("AutoTrack", "AceEvent-3.0")

local db
function module:OnModuleInitialize()
	self.db = core.db:RegisterNamespace("AutoTrack", {
		profile = {
			zone = false,
			nearby = true,
			gained = false,
			progress = true,
			removeCompleted = false,
			enabled = true,
		},
		char = {
			autotracked = {},
		}
	})
	db = self.db
	self.menu = {
		zone = {name = "Zone", type = "toggle", desc = "Track quests when you enter their zone",},
		nearby = {name = "Nearby", type = "toggle", desc = "Track quests when you're close to locations they mention in their text",},
		progress = {name = "Progress", type = "toggle", desc = "Track quests when you make progress on them",},
		gained = {name = "Gained", type = "toggle", desc = "Track quests when you pick them up",},
		removeCompleted = {name = "Remove completed", type = "toggle", desc = "Stop tracking quests when you complete them",},
	}
end

function module:OnModuleEnable()
	self:RegisterEvent("MINIMAP_ZONE_CHANGED", "OnZoneChange")
	self:RegisterEvent("ZONE_CHANGED", "OnZoneChange")
	self:RegisterEvent("ZONE_CHANGED_INDOORS", "OnZoneChange")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "OnZoneChange")
	quixote.RegisterCallback(self, "Objective_Update")
	quixote.RegisterCallback(self, "Quest_Gained")
	quixote.RegisterCallback(self, "Quest_Complete")
	quixote.RegisterCallback(self, "Quest_Lost")
	quixote.RegisterCallback(self, "Update")
end

function module:OnZoneChange()
	if not (db.profile.zone or db.profile.nearby) then return end
	if UnitIsDead("player") then return end
	local zone = GetRealZoneText()
	local subzone = GetSubZoneText()
	
	for uid, qid in pairs(db.char.autotracked) do
		RemoveQuestWatch(qid)
		db.char.autotracked[uid] = nil
	end
	for _, uid, qid, title, level, _, objectives, complete, group, daily, zone in quixote:IterateQuestsInZone(zone) do
		self:TrackIfZoneOrNearby(uid, qid, zone)
	end
end
module.OnSettingsUpdate = OnZoneChange

function module:Update()
	self:OnZoneChange()
	quixote.UnregisterCallback(self, "Update")
end

function module:Objective_Update(event, title, uid)
	if AUTO_QUEST_WATCH=="0" and db.profile.progress then
		quixote:AddQuestWatchByUid(uid)
	end
end

function module:Quest_Gained(event, title, uid, objectives, zone)
	if db.profile.gained then
		quixote:AddQuestWatchByUid(uid)
	else
		self:TrackIfZoneOrNearby(uid, zone)
	end
end

function module:Quest_Complete(event, title, uid)
	if db.profile.removeCompleted then
		quixote:RemoveQuestWatchByUid(uid)
	end
end

function module:Quest_Lost(event, title, uid)
	db.char.autotracked[uid] = nil
end

function module:TrackIfZoneOrNearby(uid, zone)
	local current_zone = GetRealZoneText()
	if not core.db.char.tracked[uid] then
		if (db.profile.zone and zone == current_zone) or (db.profile.nearby and self:QuestIsNearby(uid)) then
			db.char.autotracked[uid] = quixote:AddQuestWatchByUid(uid)
		end
	end
end

function module:QuestIsNearby(uid)
	local subzone = GetSubZoneText()
	local objective, description = quixote:GetQuestText(uid)
	if subzone ~= "" and objective and description then
		return objective:find(subzone, 1, true) or description:find(subzone, 1, true)
	end
end
