local addon = LibStub("AceAddon-3.0"):GetAddon("BetterQuest")
local quixote = LibStub("LibQuixote-2.0")
local LSM3_font = LibStub("LibSharedMedia-3.0"):List("font")

function addon:ConfigSetup()
	local function color_get(t)
		-- e.g. self.db.profile.colors.impossible
		return unpack(t)
	end
	local function color_set(c, r, g, b, a)
		c[1] = r
		c[2] = g
		c[3] = b
		c[4] = a
	end
	local function tracker_color_get(info)
		return color_get(self.db.profile.trackers[info[#info - 2]][info[#info - 1]][info[#info]])
	end
	local function tracker_color_set(info, r, g, b, a)
		color_set(self.db.profile.trackers[info[#info - 2]][info[#info - 1]][info[#info]], r, g, b, a)
		self:UpdateTrackers()
	end
	local function subgroup_get(info)
		return self.db.profile.trackers[info[#info - 2]][info[#info - 1]][info[#info]]
	end
	local function subgroup_set(info, value)
		self.db.profile.trackers[info[#info - 2]][info[#info - 1]][info[#info]] = value
		self:UpdateTrackers()
	end
	
	local trackers = {
		name = "Trackers",
		type = "group",
		get = function(info) return self.db.profile.trackers[info[#info - 2]][info[#info]] end,
		set = function(info, value)
			self.db.profile.trackers[info[#info - 2]][info[#info]] = value
			self:UpdateTrackers()
		end,
		--inline = true,
		childGroups = "tab",
		args = {},
	}
	
	local tag_values = {ANY = "Disabled", NONE = "No tag",}
	for tag, localtag in pairs(quixote.tags) do
		if tag ~= "DAILY" then tag_values[localtag] = localtag end
	end
	local boolean_values = {[1] = "Yes", [0] = "No", [-1] = "Disabled"}
	local tracker_options = {
		display = {
			type = "group", name = "Display",
			args = {
				head_colors = {name = "Colors", type = "header", order=1,},
				colorTitles = {name = "Color titles", type = "toggle", order=2,},
				colorObjectives = {name = "Color objectives", type = "toggle", order=3,},
				colorPartyObjectives = {name = "Color objectives", type = "toggle", order=4,},
				
				head_show = {name = "What to show", type = "header", order=10,},
				groupBy = {name = "Group by", type = "select", values = {level="Level", zone="Zone",}, style = "dropdown", order=11,},
				headers = {name = "Grouping headers", type = "toggle", order=12,},
				descIfNoObjective = {name = "Description if no objectives", type = "toggle", order=13,},
				partyCount = {name = "Party count", type = "toggle", order=14,},
				partyObjectives = {name = "Party status", type = "toggle", order=15,},
				hideCompletedObjectives = {name = "Hide completed objectives", type = "toggle", order=16,},
				hideWhenEmpty = {name = "Hide when empty", type = "toggle", order=17,},
				
				head_text = {name = "The text itself", type = "header", order=20,},
				font = {
					name = "Font", type = "select", values = LSM3_font, style = "dropdown",
					get = function(info)
						for k, v in pairs(LSM3_font) do
							if self.db.profile.trackers[info[#info - 2]][info[#info]] == v then
								return k
							end
						end
					end,
					set = function(info, value)
						self.db.profile.trackers[info[#info - 2]][info[#info]] = LSM3_font[value]
						self:UpdateTrackers()
					end,
					order=21,
				},
				font_size = {name = "Font size", type="range", min = 6, max = 20, step = 1, order=22,},
				wrapTitles = {name = "Wrap titles", type = "toggle", order=23,},
				wrapObjectives = {name = "Wrap objectives", type = "toggle", order=24,},
			},
		},
		header = {
			type = "group", name = "Header",
			get = subgroup_get, set = subgroup_set,
			args = {
				show = {name = "Show the header", type = "toggle",},
				name = {name = "Show tracker's name", type = "toggle",},
				counts = {name = "Show a count of quests", type = "toggle",},
				buttons = {name = "Show buttons", type = "toggle",},
				background = {type = 'color', name = "Background", order = 15, hasAlpha = true, get = tracker_color_get, set = tracker_color_set,},
				border = {type = 'color', name = "Border", order = 16, hasAlpha = true, get = tracker_color_get, set = tracker_color_set,},
				attach = {name = "Attach to", type = "select", values = {top="Top", bottom="Bottom"},},
				adjust = {name = "Position adjust", type = "range", isPercent = false, min = -50, max = 50, step = 5,},
			},
		},
		filters = {
			type = "group", name = "Filters",
			get = subgroup_get, set = subgroup_set,
			args = {
				zone = {
					--Might want to make this allow multiples in the future?
					name = "In zone...", type = "input",
				},
				tag = {
					name = "Has tag", type = "multiselect",
					values=tag_values, style="dropdown",
					get = function(info, key)
						return self.db.profile.trackers[info[#info - 2]][info[#info - 1]][info[#info]][key]
					end,
					set = function(info, key, value)
						self.db.profile.trackers[info[#info - 2]][info[#info - 1]][info[#info]][key] = value
						self:UpdateTrackers()
					end,
				},
				current_zone = {name = "In current zone", type="select", values = boolean_values, style="dropdown",},
				daily = {name = "Is daily", type="select", values = boolean_values, style="dropdown",},
				tracked = {name = "Is tracked", type="select", values = boolean_values, style="dropdown",},
				complete = {name = "Is complete", type="select", values = boolean_values, style="dropdown",},
			},
		},
		frame = {
			type = "group", name = "Frame",
			get = subgroup_get, set = subgroup_set,
			args = {
				lock = { name = "Lock", desc = "Lock the tracker in place (hold ALT to move)", type = "toggle",
					set = function(info, v) if self.trackers[info[#info - 2]] then self.trackers[info[#info - 2]]:Lock(v) end end,
				},
				scale = {name = "Scale", type = "range", isPercent = true, min = 0.5, max = 1.5, step = 0.1,},
				strata = {name = "Strata", type = "select", values = {LOW="Low", MEDIUM="Medium", HIGH="High",}, style = "dropdown",},
				fade = {name = "Fade", desc = "Fade when cursor isn't over the tracker", type = "range", isPercent = true, min = 0, max = 1, step = 0.1,},
				opacity = {name = "Opacity", desc = "Transparency of the tracker", type = "range", isPercent = true, min = 0, max = 1, step = 0.1,},
				width = {name = "Width", type = "range", min = 100, max = 400, step = 10,},
				min_height = {name = "Minimum height", type = "range", min = 20, max = 400, step = 10,},
				background = {type = 'color', name = "Background", order = 15, hasAlpha = true, get = tracker_color_get, set = tracker_color_set,},
				border = {type = 'color', name = "Border", order = 16, hasAlpha = true, get = tracker_color_get, set = tracker_color_set,},
			},
		},
		enabled = {
			name = "Enabled", type = "toggle",
			get = function(info) return self.db.profile.trackers[info[#info - 1]][info[#info]] end,
			set = function(info, value)
				self.db.profile.trackers[info[#info - 1]][info[#info]] = value
				self:UpdateTrackers()
			end,
		},
		delete = {
			name = "Delete", type = "execute",
			func = function(info)
				self.db.profile.trackers[info[#info - 1]] = nil
				trackers.args[info[#info - 1]] = nil
				self:DeleteTracker(info[#info - 1])
				self:UpdateTrackers()
			end,
		},
	}
	local options = {
		type = "group",
		get = function(info) return self.db.profile[info[#info]] end,
		set = function(info, value) self.db.profile[info[#info]] = value end,
		childGroups = "tab",
		args = {
			hideDefault = {name="Hide Default", desc = "Hide the standard quest watch frame", type = "toggle",},
		},
	}
	local modules = {
		name = "Modules",
		type = "group",
		childGroups = "tab",
		get = function(info) return false end,
		set = function(info, value) self:EnableModule(info[#info]) end,
		args = {},
	}
	local colors = {
		type = "group", name = "Colors",
		--inline = true,
		get = function(info) return color_get(self.db.profile.colors[info[#info]]) end,
		set = function(info, r, g, b, a)
			color_set(self.db.profile.colors[info[#info]])
			self:UpdateTrackers()
		end,
		args = {
			difficulty = {type = 'header', name = "Difficulty", order = 1,},
			trivial = {type = 'color', name = "Trivial", order = 2,},
			standard = {type = 'color', name = "Standard", order = 3,},
			difficult = {type = 'color', name = "Difficult", order = 4,},
			verydifficult = {type = 'color', name = "Very difficult", order = 5,},
			impossible = {type = 'color', name = "Impossible", order = 6,},
			completion = {type = 'header', name = "Completion", order = 7,},
			notstarted = {type = 'color', name = "Not started", order = 8,},
			underway = {type = 'color', name = "Underway", order = 10,},
			done = {type = 'color', name = "Done", order = 12,},
			other = {type = 'header', name = "Other", order = 13,},
			header = {type = 'color', name = "Header", order = 14,},
		},
	}
	local function make_tracker_args(id)
		return {name=id, type="group", args=tracker_options, childGroups='tab',}
	end
	trackers.args.new = {
		name = "New tracker",
		type = "input",
		validate = function(info, name)
			if name == "" or strtrim(name) == "" then
				return "Name needed"
			elseif self.db.profile.trackerNames[name] then
				return "Name taken"
			end
			return true
		end,
		get = function() return '' end,
		set = function(info, name)
			trackers.args[name] = make_tracker_args(name)
			self:CreateTracker(name, self.db.profile.trackers[name])
			--self.db.profile.trackers[name].enabled = true
			self:UpdateTrackers()
		end,
		order = 0,
	}
	for id, settings in pairs(self.db.profile.trackers) do
		trackers.args[id] = make_tracker_args(id)
	end
	self.options = {
		core = options,
		colors = colors,
		trackers = trackers,
		modules = modules,
	}
	
	local acreg = LibStub("AceConfigRegistry-3.0")
	acreg:RegisterOptionsTable("BetterQuest", options)
	acreg:RegisterOptionsTable("BetterQuest Colors", colors)
	acreg:RegisterOptionsTable("BetterQuest Trackers", trackers)
	acreg:RegisterOptionsTable("BetterQuest Modules", modules)
	acreg:RegisterOptionsTable("BetterQuest Profiles", LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db))
	
	local acdia = LibStub("AceConfigDialog-3.0")
	acdia:AddToBlizOptions("BetterQuest", "BetterQuest")
	acdia:AddToBlizOptions("BetterQuest Profiles", "Profiles", "BetterQuest")
	acdia:AddToBlizOptions("BetterQuest Modules", "Modules", "BetterQuest")
	acdia:AddToBlizOptions("BetterQuest Colors", "Colors", "BetterQuest")
	acdia:AddToBlizOptions("BetterQuest Trackers", "Trackers", "BetterQuest")
	
	local function openblizz() InterfaceOptionsFrame_OpenToCategory(acdia.BlizOptions["BetterQuest"].frame) end
	self:RegisterChatCommand("betterquest", openblizz)
	self:RegisterChatCommand("bq", openblizz)
end
