local PrevX, PrevY, Shown, LastSpeed, Distance, ElapsedTime;
local DefaultCali = 1 / 0.001912388;
local Calibration = DefaultCali;
local CustomCali;
local LastMap, Incomplete;
local UpdateCali = true;
local UpdateFreq = 0.2;
--Tests show there is no accuracy below 0.000001
local MeasureStart;
local DistanceTotal = 0;


local WorldMapSize = {
  World = 44531.82907938571,

  Kalimdor  = 36798.56388065484,
  Ashenvale = 5766.471113365881,
  Aszhara = 5070.669448432522,
  AzuremystIsle = 4070.691916244019,
  Barrens = 10132.98626357964,
  BloodmystIsle = 3262.385067990556,
  Darkshore = 6549.780280774227,
  Darnassis = 1058.300884213672,
  Desolace = 4495.726850591814,
  Durotar = 5287.285801274457,
  Dustwallow = 5249.824712249077,
  Felwood = 5749.8046476606,
  Feralas = 6949.760203962193,
  Moonglade = 2308.253559286662,
  Mulgore = 5137.32138887616,
  Ogrimmar = 1402.563051365538,
  Silithus = 3483.224287356748,
  StonetalonMountains = 4883.173287670144,
  Tanaris = 6899.765399158026,
  Teldrassil = 5091.467863261982,
  TheExodar = 1056.732317707213,
  ThousandNeedles = 4399.86408093722,
  ThunderBluff = 1043.762849319158,
  UngoroCrater = 3699.872808671186,
  Winterspring = 7099.756078049357,

  Azeroth = 37649.15159852673, --EasternKingdoms
  Alterac = 2799.820894040741,
  Arathi = 3599.78645678886,
  Badlands = 2487.343589680943,
  BlastedLands = 3349.808966078055,
  BurningSteppes = 2928.988452241535,
  DeadwindPass = 2499.848163715574,
  DunMorogh = 4924.664537147015,
  Duskwood = 2699.837284973949,
  EasternPlaguelands = 3870.596078314358,
  Elwynn = 3470.62593362794,
  EversongWoods = 4924.70470173181,
  Ghostlands = 3299.755735439147,
  Hilsbrad = 3199.802496078764,
  Hinterlands = 3849.77134323942,
  Ironforge = 790.5745810546713,
  LochModan = 2758.158752877019,
  Redridge = 2170.704876735185,
  SearingGorge = 2231.119799153945,
  SilvermoonCity = 1211.384457945605,
  Silverpine = 4199.739879721531,
  Stormwind = 1344.138055148283,
  Stranglethorn = 6380.866711475876,
  SwampOfSorrows = 2293.606089974149,
  Tirisfal = 4518.469744413802,
  Undercity = 959.3140238076666,
  WesternPlaguelands = 4299.7374000546,
  Westfall = 3499.786489780177,
  Wetlands = 4135.166184805389,

  Expansion01 = 17463.5328406368, --Outland
  BladesEdgeMountains = 5424.84803598309,
  Hellfire = 5164.421615455519,
  Nagrand = 5524.827295176373,
  Netherstorm = 5574.82788866266,
  ShadowmoonValley = 5499.827432644566,
  ShattrathCity = 1306.210386847456,
  TerokkarForest = 5399.832305361811,
  Zangarmarsh = 5026.925554043871,

  WarsongGulch = 1146.2,
  AlteracValley = 4237.4,
  NetherstormArena = 2271.6, --Eye of the Storm
  ArathiBasin = 1306.3,
};


BaudSpeed_Debug = false;

local function DebugMsg(Message)
  if BaudSpeed_Debug then
    DEFAULT_CHAT_FRAME:AddMessage(Message);
  end
end


local EventFuncs = {
  PLAYER_LOGIN = function()
    CustomCali = BaudSpeedCalibration;
    if(type(CustomCali)~="table")then
      CustomCali = {};
      BaudSpeedCalibration = CustomCali;
    end
  end,

	ZONE_CHANGED_NEW_AREA = function()
	  if not WorldMapFrame:IsShown()then
      SetMapToCurrentZone();
    end
  end,

  WORLD_MAP_UPDATE = function()
    UpdateCali = true;
    BaudSpeedFrame:Show();
  end,
};


function BaudSpeed_OnLoad(self)
  for Key, Value in pairs(EventFuncs)do
    self:RegisterEvent(Key);
  end
  self:SetScript("OnEvent", function()
    EventFuncs[event]();
  end);
  self:SetScript("OnUpdate", BaudSpeed_OnUpdate);
end


WorldMapFrame:HookScript("OnHide",function()
  SetMapToCurrentZone();
end);


function BaudSpeedLoadCali()
  local Instance, Type = IsInInstance();
  if Instance and(Type~="pvp")then
    DebugMsg("No map for this area.");
    Calibration = nil;
    BaudSpeedFrame:Hide();
    BaudSpeedDisplay:Hide();
    Shown = false;
  else
    local MapName = GetMapInfo()or "World";
    if(MapName~=LastMap)then
      Calibration = CustomCali[MapName];
      if not Calibration then
        Calibration = WorldMapSize[MapName];
        if Calibration then
          Calibration = Calibration / 10.5;
        else
          Calibration = DefaultCali;
        end
      end
      DebugMsg("Calibration "..Calibration.." ("..MapName..")");
      LastMap = MapName;
      PrevX = nil;
      if Incomplete then
        --More than one incomplete speed measurement will hide the display
        BaudSpeedDisplay:Hide();
        Shown = false;
      end
      Incomplete = true;
    end
  end
end


function BaudSpeedCalibrateButton_OnLoad(self)
  self:GetPushedTexture():SetVertexColor(0.8,0.8,0.8);
end


local Slots = {8,10,13,14};
function BaudSpeedCalibrateButton_OnClick()
  PlaySound("gsTitleOptionOK");
  if(LastSpeed==0)then
    UIErrorsFrame:AddMessage("You must be moving to calibrate.", 1.0, 0.1, 0.1, 1.0, UIERRORS_HOLD_TIME);
    return;
  end
  local BaseSpeed = 1;
  local BuffSpeed = 1;

  local Name, Rank;
  for Tab = 1, GetNumTalentTabs()do
    for Talent = 1, GetNumTalents(Tab)do
      Name, _, _, _, Rank = GetTalentInfo(Tab, Talent);
      if(Name=="Fleet Footed")or(Name=="Pursuit of Justice")then
         BuffSpeed = 1 + 0.08 * Rank;
         break;
      end
    end
  end

  if IsMounted()then
    local Increase, Type;
    for Buff = 1, 99 do
      if not UnitBuff("player",Buff)then
        break;
      else
        BaudSpeedTooltip:SetUnitBuff("player",Buff);
        --There can be 2 buffs:  Mount and crusader aura.
        Type, Increase = string.match(BaudSpeedTooltipTextLeft2:GetText(),"(%l+) speed by (%d+)%%");
        if Increase then
          Increase = 1 + tonumber(Increase) / 100;
          if(Increase > 2)and not IsFlying()then
            Increase = 2;  --Epic flying mounts are 100% speed on ground
          end
          if(Type~="mounted")then
            BaseSpeed = Increase;
          else
            BuffSpeed = Increase;
          end
        end
      end
    end
  end
  local ItemID, Enchant;
  local ItemSpeed = 1;
  for Key, Value in ipairs(Slots)do
    ItemID, Enchant = string.match(GetInventoryItemLink("player",Value)or "", "item:(%d+):(%d+):");
    if ItemID then
      if IsMounted()then
        if(ItemID=="25653")or(ItemID=="32481")or(ItemID=="32863")then
          --Riding crop / Druid trinket / Skybreaker Whip (Overrides other speed items)
          ItemSpeed = 1.1;
          break;

        elseif(ItemID=="11122")then
          --Carrot on a stick
          ItemSpeed = ItemSpeed * 1.03;
        elseif(Enchant=="930")then
          --Riding skill enchant
          ItemSpeed = ItemSpeed * 1.02;
        elseif(Enchant=="464")then
          --Mithril spurs
          ItemSpeed = ItemSpeed * 1.04;
        end
      elseif(Enchant=="911")or(Enchant=="2829")or(Enchant=="2939")or(Enchant=="2940")or(Enchant=="2969")or(Enchant=="2970")then
        ItemSpeed = 1.08;
        break;
      end
    end
  end

  if(ItemSpeed > BuffSpeed)then
    BuffSpeed = ItemSpeed;
  end

  DebugMsg("Expected speed:  "..(BaseSpeed * BuffSpeed));

--  ChatFrame1:AddMessage(LastSpeed);
  Calibration = 1 / (LastSpeed / (BaseSpeed * BuffSpeed));
  local MapName = GetMapInfo()or "World";
  CustomCali[MapName] = Calibration;

  local Name = MapName;
  if IsInInstance()then
    local Status, MapName;
    for Index = 1, MAX_BATTLEFIELD_QUEUES do
      Status, MapName = GetBattlefieldStatus(Index);
      if(Status=="active")then
        Name = MapName;
        break;
      end
    end
  else
    local Continent = GetCurrentMapContinent();
    local Zone = GetCurrentMapZone();
    if(Zone==0)then
      if(Continent==0)then
        Name = "world";
      else
        Name = select(Continent,GetMapContinents());
      end
    else
      Name = select(Zone,GetMapZones(Continent));
    end
  end
  DEFAULT_CHAT_FRAME:AddMessage("Calibration set for "..Name..".",1,1,0);
  DebugMsg("Map name "..MapName);
end


local NewX, NewY;
function BaudSpeed_OnUpdate()
  if UpdateCali then
    UpdateCali = nil;
    BaudSpeedLoadCali();
  end
  NewX, NewY = GetPlayerMapPosition("player");
  if(NewX==0)and(NewY==0)or not NewX then
    PrevX = nil;
    if Shown then
      Shown = false;
      BaudSpeedDisplay:Hide();
    end
  else
    if PrevX then
      Distance = Distance + sqrt(math.pow((NewX - PrevX)*1.5, 2)+math.pow(NewY - PrevY, 2));
      ElapsedTime = ElapsedTime + arg1;
      if(ElapsedTime > UpdateFreq)then
        LastSpeed = Distance / ElapsedTime;
        BaudSpeedDisplayText:SetText(floor(LastSpeed * Calibration * 100 + 0.5).."%");
        if not Shown then
          Shown = true;
          BaudSpeedDisplay:Show();
        end
        Distance, ElapsedTime = 0, 0;
        Incomplete = nil;
      end
--[[      if MeasureStart then
        DistanceTotal = DistanceTotal + sqrt(math.pow((NewX - PrevX)*1.5, 2)+math.pow(NewY - PrevY, 2)) * 100;
      end
      if(IsSpellInRange("Scare Beast")==1)then
        if MeasureStart then
          local Elapsed = GetTime() - MeasureStart;
          ChatFrame1:AddMessage("Moved "..DistanceTotal.." in "..(GetTime()-MeasureStart));
          ChatFrame1:AddMessage("Speed: "..(31 / Elapsed));
          MeasureStart = nil;
        end
      elseif(IsSpellInRange("Arcane Shot")==1)then
        if not DistanceTotal then
          ChatFrame1:AddMessage("Timer Started");
          MeasureStart = GetTime();
          DistanceTotal = 0;
        end
      else
        MeasureStart = nil;
        DistanceTotal = nil;
      end]]

    else
      Distance, ElapsedTime = 0, 0;
    end
    PrevX, PrevY = NewX, NewY;
  end
end