local SelectedError = 1;
local ErrorList = {};
local SoundTime = 0;
local QueueError = {};

StaticPopupDialogs["CHANGE_ERROR_SOUND"] = {
  text = "Enter path (eg. Interface\\AddOns\\AddOnName\\MySound.wav):",
  button1 = TEXT(ACCEPT),
  button2 = TEXT(CANCEL),
  hasEditBox = 1,
  maxLetters = 100,
  OnAccept = function()
    BaudErrorFrameAcceptSound();
  end,
  OnShow = function()
    local EditBox = getglobal(this:GetName().."EditBox");
    EditBox:SetText(BaudErrorFrameConfig.Sound or "");
    EditBox:HighlightText();
    EditBox:SetFocus();
  end,
  OnHide = function()
    if ChatFrameEditBox:IsVisible()then
      ChatFrameEditBox:SetFocus();
    end
    getglobal(this:GetName().."EditBox"):SetText("");
  end,
  EditBoxOnEnterPressed = function()
    BaudErrorFrameAcceptSound();
    this:GetParent():Hide();
  end,
  EditBoxOnEscapePressed = function()
    this:GetParent():Hide();
  end,
  timeout = 0,
  exclusive = 1,
  whileDead = 1,
  hideOnEscape = 1
};

function BaudErrorFrame_OnLoad()
  BaudErrorFrameVersionText:SetText("Version "..GetAddOnMetadata("!BaudErrorFrame","Version"));

  this:RegisterEvent("VARIABLES_LOADED");
  this:RegisterEvent("ADDON_ACTION_BLOCKED");
  this:RegisterEvent("MACRO_ACTION_BLOCKED");
  this:RegisterEvent("ADDON_ACTION_FORBIDDEN");
  UIParent:UnregisterEvent("ADDON_ACTION_FORBIDDEN");
  this:RegisterEvent("MACRO_ACTION_FORBIDDEN");
  UIParent:UnregisterEvent("MACRO_ACTION_FORBIDDEN");

  tinsert(UISpecialFrames,this:GetName());

  SlashCmdList["BaudErrorFrame"] = function()
    BaudErrorFrame:Show();
  end
  SLASH_BaudErrorFrame1 = "/bauderror";
  
  seterrorhandler(BaudErrorFrameHandler);
end


function BaudErrorFrame_OnEvent()
  if(event=="VARIABLES_LOADED")then
    if(type(BaudErrorFrameConfig)~="table")then
      BaudErrorFrameConfig = {};
    end
    if(BaudErrorFrameConfig.Sound == nil)then
      --Backwards compatability
      BaudErrorFrameConfig.Sound = BaudErrorFrameSound or "Sound\\Character\\PlayerExertions\\GnomeMaleFinal\\GnomeMaleMainDeathA.wav";
    end
    if(BaudErrorFrameConfig.Messages == nil)then
      BaudErrorFrameConfig.Messages = true;
    end
    BaudErrorFrameChatEnabledText:SetText("Enable Chat Messages");
    BaudErrorFrameChatEnabled:SetChecked(BaudErrorFrameConfig.Messages);

    for Key, Value in ipairs(QueueError)do
      BaudErrorFrameShowError(Value);
    end
    QueueError = nil;
    
  elseif(event=="ADDON_ACTION_BLOCKED")then
    BaudErrorFrameAdd(arg1.." blocked from using "..arg2,4);

  elseif(event=="MACRO_ACTION_BLOCKED")then
    BaudErrorFrameAdd("Macro blocked from using "..arg1,4);

  elseif(event=="ADDON_ACTION_FORBIDDEN")then
    BaudErrorFrameAdd(arg1.." forbidden from using "..arg2.." (Only usable by Blizzard)",4);

  elseif(event=="MACRO_ACTION_FORBIDDEN")then
    BaudErrorFrameAdd("Macro forbidden from using "..arg1.." (Only usable by Blizzard)",4);
  end  
end


function BaudErrorFrameChatEnabled_OnClick()
  if this:GetChecked()then
    PlaySound("igMainMenuOptionCheckBoxOff");
  else
    PlaySound("igMainMenuOptionCheckBoxOn");
  end
  BaudErrorFrameConfig.Messages = this:GetChecked()and true or false;
end


function BaudErrorFrameMinimapButton_OnEnter()
  if this.Dragging then
    return;
  end
  GameTooltip:SetOwner(this, "ANCHOR_TOPRIGHT");
  GameTooltip:AddLine("Baud Error Frame");
  GameTooltip:AddLine("Click to view errors.",1,1,1);
  GameTooltip:AddLine("Shift-drag to move button.",1,1,1);
  GameTooltip:Show();
end


function BaudErrorFrameMinimapButton_OnLeave()
  GameTooltip:Hide();
end


function BaudErrorFrameMinimapButton_OnDragStart()
  if IsShiftKeyDown()then
    this.Dragging = true;
    BaudErrorFrameMinimapButton_OnLeave();
  end
end


function BaudErrorFrameMinimapButton_OnDragStop()
  this:StopMovingOrSizing();
  this.Dragging = nil;
  this.Moving = nil;
end


function BaudErrorFrameMinimapButton_OnUpdate()
  if not this.Dragging then
    return;
  end
  local MapScale = Minimap:GetEffectiveScale();
  local CX, CY = GetCursorPosition();
  local X, Y = (Minimap:GetRight() - 70) * MapScale, (Minimap:GetTop() - 70) * MapScale;
  local Dist = sqrt(math.pow(X - CX, 2) + math.pow(Y - CY, 2)) / MapScale;
  local Scale = this:GetEffectiveScale();
  if(Dist <= 90)then
    if this.Moving then
      this:StopMovingOrSizing();
      this.Moving = nil;
    end
    local Angle = atan2(CY - Y, X - CX) - 90;
    this:ClearAllPoints();
    this:SetPoint("CENTER", Minimap, "TOPRIGHT", (sin(Angle) * 80 - 70) * MapScale / Scale, (cos(Angle) * 77 - 73) * MapScale / Scale);
    
  elseif not this.Moving then
    this:ClearAllPoints();
    this:SetPoint("CENTER", UIParent, "BOTTOMLEFT",CX / Scale, CY / Scale);
    this:StartMoving();
    this.Moving = true;
  end
end


function BaudErrorFrameHandler(Error)
  BaudErrorFrameAdd(Error,3);
end


function BaudErrorFrameShowError(Error)
  if BaudErrorFrameConfig.Messages then
    DEFAULT_CHAT_FRAME:AddMessage(Error,0.8,0.1,0.1);
  end
  if(GetTime() > SoundTime)then
    PlaySoundFile(BaudErrorFrameConfig.Sound);
    SoundTime = GetTime() + 1;
  end
end


function BaudErrorFrameAdd(Error, Retrace)
  for Key, Value in pairs(ErrorList)do
    if(Value.Error==Error)then
      if(Value.Count < 99)then
        Value.Count = Value.Count + 1;
        BaudErrorFrameEditBoxUpdate();
      end
      return;
    end
  end
  if BaudErrorFrameConfig then
    BaudErrorFrameShowError(Error);
  else
    tinsert(QueueError, Error);
  end
  tinsert(ErrorList,{Error=Error,Count=1,Stack=debugstack(Retrace)});
  BaudErrorFrameMinimapCount:SetText(getn(ErrorList));  
  BaudErrorFrameMinimapButton:Show();
  BaudErrorFrameScrollBar_Update();
end


function BaudErrorFrame_Select(Index)
  SelectedError = Index;
  BaudErrorFrameScrollBar_Update();
  BaudErrorFrameDetailScrollFrameScrollBar:SetValue(0);
end


function BaudErrorFrame_OnShow()
  PlaySound("gsTitleOptionExit");
  BaudErrorFrameScrollBar_Update();
end


function BaudErrorFrame_OnHide()
  PlaySound("gsTitleOptionExit");
end


function BaudErrorFrameEntry_OnClick()
  BaudErrorFrame_Select(this:GetID());
end


function BaudErrorFrameClearButton_OnClick()
  ErrorList = {};
  BaudErrorFrameMinimapButton:Hide();
  this:GetParent():Hide();
end


function BaudErrorFrameSoundButton_OnClick()
  PlaySound("gsTitleOptionExit");
  StaticPopup_Show("CHANGE_ERROR_SOUND");
end


function BaudErrorFrameAcceptSound()
  BaudErrorFrameConfig.Sound = getglobal(this:GetParent():GetName().."EditBox"):GetText();
end


function BaudErrorFrameScrollBar_Update()
  if not BaudErrorFrame:IsShown()then
    return;
  end
  local Index, Button, ButtonText, Text;

  local Frame = BaudErrorFrameListScrollBox;
  local FrameName = Frame:GetName();
  local ScrollBar = getglobal(FrameName.."ScrollBar");
  local Highlight = getglobal(FrameName.."Highlight");
  local Total = getn(ErrorList);
  FauxScrollFrame_Update(ScrollBar,Total,Frame.Entries,16);
  Highlight:Hide();
  for Line = 1, Frame.Entries do
    Index = Line + FauxScrollFrame_GetOffset(ScrollBar);
    Button = getglobal(FrameName.."Entry"..Line);
    ButtonText = getglobal(FrameName.."Entry"..Line.."Text");
    if(Index <= Total)then
      Button:SetID(Index);
      ButtonText:SetText(ErrorList[Index].Error);
      Button:Show();
      if(Index==SelectedError)then
        Highlight:SetPoint("TOP",Button);
        Highlight:Show();
      end
    else
      Button:Hide();
    end
  end
  BaudErrorFrameEditBoxUpdate();
end


function BaudErrorFrameEditBoxUpdate()
  if ErrorList[SelectedError]then
    BaudErrorFrameEditBox.TextShown = ErrorList[SelectedError].Error.."\nCount: "..ErrorList[SelectedError].Count.."\n\nCall Stack:\n"..ErrorList[SelectedError].Stack;
  else
    BaudErrorFrameEditBox.TextShown = "";
  end
  BaudErrorFrameEditBox:SetText(BaudErrorFrameEditBox.TextShown);
--  BaudErrorFrameDetailScrollFrame:UpdateScrollChildRect();
end


function BaudErrorFrameEditBox_OnTextChanged()
  if(this:GetText()~=this.TextShown)then
    this:SetText(this.TextShown);
    this:ClearFocus();
    return;
  end
  BaudErrorFrameDetailScrollFrame:UpdateScrollChildRect();
end


function BaudErrorFrameEditBox_OnTextSet()
end