local EditBox, MinimapButton;
local Config;
local LastValue, LastMod, SelectedOperation, Clear, ClearOperation, Decimals;
local CurrValue = 0;
local LastAns = 0;
local MsgPrefix = "|cffffff00Baud Calculator:|r ";

local function CheckClear()
  if Clear then
    if ClearOperation then
      ClearOperation = nil;
      SelectedOperation = nil;
    end
    CurrValue = 0;
    Decimals = nil;
    Clear = nil;
  end
end


local function UpdateNumber()
  if(abs(CurrValue)==math.huge)then
    EditBox:SetText("Infinity");
  elseif not(CurrValue > 0)and not(CurrValue <= 0)then
    EditBox:SetText("Not a Number");
  elseif not Clear and Decimals then
    if(Decimals <= 0)then
      EditBox:SetText(CurrValue..".");
    else
      EditBox:SetText(format("%."..Decimals.."f", CurrValue));
    end
  else
    EditBox:SetText(CurrValue);
  end
end


local function NumberFunc(Number)
  CheckClear();
  Number = tonumber(strsub(Number, 7));
  if(CurrValue < 0)then
    Number = -Number;
  end
  if Decimals then
    Decimals = Decimals + 1;
    CurrValue = CurrValue + Number * math.pow(10, -Decimals)
  else
    CurrValue = CurrValue * 10 + Number;
  end
  UpdateNumber();
end


local function BackspaceFunc()
  CheckClear();
  if Decimals then
    if(Decimals <= 0)then
      Decimals = nil;
    else
      Decimals = Decimals - 1;
      local X = math.pow(10, Decimals);
      CurrValue = floor(CurrValue * X) / X;
    end
  else
    CurrValue = floor(CurrValue / 10);
  end
  UpdateNumber();
end


local function DecimalFunc()
  CheckClear();
  if Decimals then
    return;
  end
  Decimals = 0;
  UpdateNumber();
end


local function SignFunc()
  CheckClear();
  CurrValue = -CurrValue;
  UpdateNumber();
end


local function Calculate()
  if not LastValue or Clear then
    return;
  end
  LastMod = CurrValue;
  CurrValue = SelectedOperation(LastValue, CurrValue);
  UpdateNumber();
  ClearOperation = true;
  LastValue = nil;
end


local Operators = {
  MULTIPLY = function(a, b)
    return(a * b);
  end,
  DIVIDE = function(a, b)
    return(a / b);
  end,
  MINUS = function(a, b)
    return(a - b);
  end,
  PLUS = function(a, b)
    return(a + b);
  end,
};


local function OperatorFunc(Key)
  Calculate();
  SelectedOperation = Operators[strsub(Key, 7)];
  ClearOperation = nil;
  LastValue = CurrValue;
  Clear = true;
end


local function EqualsFunc()
  if not SelectedOperation then
    LastAns = CurrValue;
    Clear = true;
    return;
  end
  Clear = nil;
  if not LastValue then
    LastValue = CurrValue;
    CurrValue = LastMod;
  end
  Calculate();
  LastAns = CurrValue;
  Clear = true;
end


local function AnswerFunc()
  CurrValue = LastAns;
  Clear = true;
  UpdateNumber();
end


local Buttons = {
  {Key="NUMPAD1", Func = NumberFunc},
  {Key="NUMPAD2", Func = NumberFunc},
  {Key="NUMPAD3", Func = NumberFunc},
  {Key="NUMPADDIVIDE", Text = "/", Func = OperatorFunc},
  {Key="BACKSPACE", Text = "<", Func = BackspaceFunc},

  {Key="NUMPAD4", Func = NumberFunc},
  {Key="NUMPAD5", Func = NumberFunc},
  {Key="NUMPAD6", Func = NumberFunc},
  {Key="NUMPADMULTIPLY", Text = "*", Func = OperatorFunc},
  {Text = "ans", Func = AnswerFunc},

  {Key="NUMPAD7", Func = NumberFunc},
  {Key="NUMPAD8", Func = NumberFunc},
  {Key="NUMPAD9", Func = NumberFunc},
  {Key="NUMPADMINUS", Text = "-", Func = OperatorFunc},
  false,

  {Key="NUMPAD0", Func = NumberFunc},
  {Text = "+/-", Func = SignFunc},
  {Key="NUMPADDECIMAL", Text = ".", Func = DecimalFunc},
  {Key="NUMPADPLUS", Text = "+", Func = OperatorFunc},
  {Key="ENTER", Text = "=", Func = EqualsFunc},
};


local function SetTexture(self, Texture)
  getglobal(self:GetName().."Center"):SetTexture(Texture);
  getglobal(self:GetName().."Left"):SetTexture(Texture);
  getglobal(self:GetName().."Right"):SetTexture(Texture);
end


local function SlashCommandFunc(Input)
  Input = (Input=="")and "DEFAULT" or strupper(Input);

  if(Input=="DEFAULT")then
    if InCombatLockdown()then
      DEFAULT_CHAT_FRAME:AddMessage(MsgPrefix.."This slash command cannot be used in combat.  Try using a hotkey or \"/click BaudCalculatorToggle\" (without the quotes).");
      return;
    end
    MinimapButton:Click("LeftButton");

  elseif(Input=="MINIMAP")then
    if InCombatLockdown()then
      DEFAULT_CHAT_FRAME:AddMessage(MsgPrefix.."This slash command cannot be used in combat.");
      return;
    end
    Config.MinimapShown = not Config.MinimapShown;
    if Config.MinimapShown then
      MinimapButton:Show();
    else
      MinimapButton:Hide();
    end
    DEFAULT_CHAT_FRAME:AddMessage(MsgPrefix.."Minimap button "..(Config.MinimapShown and "shown." or "hidden."));

  else
    DEFAULT_CHAT_FRAME:AddMessage("Baud Calculator command list:\n  |cffffffffDefault|r: Toggle calculator display.\n  |cffffffffMinimap|r: Toggle minimap button display.", 1, 1, 0);
  end
end


function BaudCalculator_OnLoad(self)
  self:RegisterForDrag("LeftButton");
  self:RegisterEvent("VARIABLES_LOADED");

  local Parent = self:GetParent();
  Parent:SetAttribute("statemap-child", "$input")
  Parent:SetAttribute("addchild", self);

  self:SetAttribute("headofsx", 0);
  self:SetAttribute("headofsy", 0);
  self:SetAttribute("statemap-parent", "$input")
  self:SetAttribute("statebindings", "1:enabled;*:disabled");
  self:SetAttribute("showstates", 1);
  self:SetAttribute("exportstate", "child");

  --Doing this in the XML will generate errors, even if it isn't harmful
  BaudCalculatorEditBox:SetFontObject("GameFontHighlight");
  BaudCalculatorEditBox:SetJustifyH("RIGHT");

  local Button;
  for Key, Value in ipairs(Buttons)do
    if Value then
      Button = CreateFrame("Button", "BaudCalcButton"..Key, self, "BaudCalculatorButtonTemplate");
      Value.Button = Button;
      Button:SetPoint("TOPLEFT", 20 + 32 * ((Key - 1) % 5), -40 - 32 * floor((Key - 1) / 5));
      Button:SetID(Key);
      Button:SetText(Value.Text or strsub(Value.Key, 7));
      Button.SetTexture = SetTexture;
      Button:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
      if Value.Key then
        self:SetAttribute("addchild", Button);
        Button:SetAttribute("bindings-enabled", Value.Key);
      end
    end
  end
  EditBox = BaudCalculatorEditBox;
  EditBox:SetText(CurrValue);
  getglobal(EditBox:GetName().."Right"):SetPoint("RIGHT", 5, 0);

  SlashCmdList["BaudCalculator"] = SlashCommandFunc;
  SLASH_BaudCalculator1 = "/baudcalculator";
  SLASH_BaudCalculator2 = "/baudcalc";
  SLASH_BaudCalculator3 = "/calculator";
  SLASH_BaudCalculator4 = "/calc";
  SLASH_BaudCalculatorMenuName = "Baud Calculator";

  BINDING_HEADER_BaudCalculator = "Baud Calculator";
  setglobal("BINDING_NAME_CLICK BaudCalculatorToggle:LeftButton", "Toggle Calculator");

  Button = getglobal(self:GetName().."CloseButton");
  self:SetAttribute("addchild", Button);
  Button:SetAttribute("bindings-enabled", "ESCAPE");
  Button:SetAttribute("newstate", 0);

  MinimapButton = getglobal(Parent:GetName().."Toggle");
  Parent:SetAttribute("addchild", MinimapButton);
  MinimapButton:SetAttribute("newstate", "0-1");
  MinimapButton:RegisterForClicks("LeftButtonUp", "RightButtonUp");
  MinimapButton:RegisterForDrag("LeftButton");
  MinimapButton:SetFrameLevel(Button:GetFrameLevel()+1);
  MinimapButton:RegisterEvent("PLAYER_REGEN_DISABLED");
  getglobal(MinimapButton:GetName().."Texture"):SetVertexColor(0.80, 0.68, 0.05);

  Parent:SetAttribute("state", 0);

  Parent.StateChanged = function()
    PlaySound("UChatScrollButton");
  end
end


local function SetMinimapButtonPosition()
  local Scale = Minimap:GetEffectiveScale() / MinimapButton:GetEffectiveScale();
  MinimapButton:ClearAllPoints();
  MinimapButton:SetPoint("CENTER", Minimap, "TOPRIGHT", (sin(Config.MinimapButtonPosition) * 80 - 70) * Scale, (cos(Config.MinimapButtonPosition) * 77 - 73) * Scale);
end


function BaudCalculator_OnEvent(self, event)
  if(event=="VARIABLES_LOADED")then
    Config = BaudCalculatorConfig;
    if(Config==nil)then
      Config = {};
      BaudCalculatorConfig = Config;
    end
    if(Config.MinimapButtonPosition==nil)then
      Config.MinimapButtonPosition = 172;
    end
    if Config.MinimapButtonPosition then
      SetMinimapButtonPosition();
    else
      MinimapButton:SetClampedToScreen(true);
    end
    if(Config.MinimapShown==nil)then
      Config.MinimapShown = true;
    elseif not Config.MinimapShown then
      MinimapButton:Hide();
    end
  end
end


function BaudCalculatorButton_OnClick(self)
  Buttons[self:GetID()].Func(Buttons[self:GetID()].Key);
end


function BaudCalculatorButton_OnMouseDown(self)
  self:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
end


function BaudCalculatorButton_OnMouseUp(self)
 self:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
end


function BaudCalculatorEditBox_OnTextChanged(self)
  self:ClearFocus();
  UpdateNumber();
end


function BaudCalculatorMinimapButton_OnEnter(self)
  if self.Dragging then
    return;
  end
  GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT");
  GameTooltip:AddLine("Baud Calculator");
  GameTooltip:AddLine("Shift-drag to move button.",1,1,1);
  GameTooltip:Show();
end


function BaudCalculatorMinimapButton_OnLeave()
  GameTooltip:Hide();
end


function BaudCalculatorMinimapButton_OnDragStart(self)
  MinimapButton_OnMouseUp();
  if InCombatLockdown()then
    DEFAULT_CHAT_FRAME:AddMessage(MsgPrefix.."This button cannot be moved in combat.");
    return;
  end
  if IsShiftKeyDown()then
    self:SetScript("OnUpdate", BaudCalculatorMinimapButton_OnUpdate);
    self.Dragging = true;
    BaudCalculatorMinimapButton_OnLeave();
  end
end


function BaudCalculatorMinimapButton_OnDragStop(self)
  if self.Dragging then
    self:SetScript("OnUpdate", nil);
    self:StopMovingOrSizing();
    self.Dragging = nil;
    self.Moving = nil;
  end
end


function BaudCalculatorMinimapButton_OnUpdate(self)
  local MapScale = Minimap:GetEffectiveScale();
  local CX, CY = GetCursorPosition();
  local X, Y = (Minimap:GetRight() - 70) * MapScale, (Minimap:GetTop() - 70) * MapScale;
  local Dist = sqrt(math.pow(X - CX, 2) + math.pow(Y - CY, 2)) / MapScale;
  local Scale = self:GetEffectiveScale();
  if(Dist <= 90)and Minimap:IsVisible()then
    if self.Moving then
      self:StopMovingOrSizing();
      self.Moving = nil;
    end
    Config.MinimapButtonPosition = (atan2(CY - Y, X - CX) + 270) % 360;
    MinimapButton:SetClampedToScreen(false);
    SetMinimapButtonPosition();

  elseif not self.Moving then
    Config.MinimapButtonPosition = false;
    MinimapButton:SetClampedToScreen(true);
    self:ClearAllPoints();
    self:SetPoint("CENTER", UIParent, "BOTTOMLEFT", CX / Scale, CY / Scale);
    self:StartMoving();
    self.Moving = true;
  end
end
