local ReportAfter = 120;
local CheckFrequency = 30;
local PlayerCoords = {};
local NextAFKCheck = 0;

function BaudAFKReporter_OnLoad(self)
  self:RegisterEvent("PLAYER_ENTERING_WORLD");

  SlashCmdList["BaudAFKReporter"] = function()
    BaudAFKReporterSound = (BaudAFKReporterSound==false);
    DEFAULT_CHAT_FRAME:AddMessage("Baud AFK Reporter: Sound "..(BaudAFKReporterSound and "Enabled" or "Disabled")..".", 1, 1, 0);
  end
  SLASH_BaudAFKReporter1 = "/baudafk";
  SLASH_BaudAFKReporter2 = "/baudafkreporter";

  DEFAULT_CHAT_FRAME:AddMessage("Baud AFK Reporter: AddOn Loaded. Use /baudafk to toggle sound. Version "..GetAddOnMetadata("BaudAFKReporter","Version")..".");
end


function BaudAFKReporter_OnEvent(self, event)
  if(event=="PLAYER_ENTERING_WORLD")then
    local InInstance, InstanceType = IsInInstance();
    if(InstanceType~="pvp")then
      self:Hide();
      return;
    end
    for Key, Value in pairs(PlayerCoords)do
      PlayerCoords[Key] = nil;
    end
    self:Show();
    SetMapToCurrentZone();
  end
end


function BaudAFKReporter_OnUpdate()
  if(NextAFKCheck > GetTime())then
    return;
  end
  NextAFKCheck = GetTime() + CheckFrequency;
  local Name, Server, Key, X, Y, Unit, PlayedSound;
  if(GetNumRaidMembers() > 0)then
    for Index = 1, MAX_RAID_MEMBERS do
      Unit = "raid"..Index;
      Name, Server = UnitName(Unit);
      if Name and not UnitIsUnit(Unit, "player")then
        Key = Name;
        if Server and(Server~="")then
          Key = Key.."-"..Server;
        end
        X, Y = GetPlayerMapPosition(Unit);
        if(X==0)and(Y==0)then
          if PlayerCoords[Key]then
            PlayerCoords[Key] = nil;
          end
        else
          if PlayerCoords[Key]then
            if(PlayerCoords[Key].X==X)and(PlayerCoords[Key].Y==Y)then
              if(GetTime() - PlayerCoords[Key].Start >= ReportAfter)and not PlayerCoords[Key].Reported then
                DEFAULT_CHAT_FRAME:AddMessage("Reporting AFK player: "..Key, 1, 0, 1);
                ReportPlayerIsPVPAFK(Unit);
                PlayerCoords[Key].Reported = true;
                if not PlayedSound and(BaudAFKReporterSound~=false)then
                  PlaySoundFile("Sound\\Creature\\MaidenOfVirtue\\MaidenSlay03.wav");
                  PlayedSound = true;
                end
              end
            else
              PlayerCoords[Key].X = X;
              PlayerCoords[Key].Y = Y;
              PlayerCoords[Key].Start = GetTime();
              PlayerCoords[Key].Reported = nil;
            end
          else
            PlayerCoords[Key] = {Start = GetTime(), X = X, Y = Y};
          end
        end
      end
    end
  end
end