#!/usr/local/bin/lua

local locale = {
	"deDE",
	"frFR",
	"esES",
	"zhCN",
	"zhTW",
	"koKR",
	"ruRU"
}
local files = {
	"Bartender4.lua",
	"Options.lua",
	"actionBar/Prototype.lua",
	"actionBar/Options.lua",
	"actionBar/ActionBars.lua",
	"actionBar/States.lua",
	"actionBar/StatesOptions.lua",
	"barPrototype/Prototype.lua",
	"barPrototype/Options.lua",
	"buttonBarPrototype/Prototype.lua",
	"buttonBarPrototype/Options.lua",
	"buttonPrototypes/ActionButton.lua",
	"buttonPrototypes/PetButton.lua",
	"specialBars/BagBar.lua",
	"specialBars/BagBarOptions.lua",
	"specialBars/MicroMenu.lua",
	"specialBars/MicroMenuOptions.lua",
	"specialBars/PetBar.lua",
	"specialBars/PetBarOptions.lua",
	"specialBars/StanceBar.lua",
	"specialBars/StanceBarOptions.lua",
}

local strings = {}

-- extract data from specified lua files
for idx,filename in pairs(files) do
	local file = io.open("../"..filename, "r")
	assert(file, "Could not open " .. filename)
	local text = file:read("*all")

	for match in string.gmatch(text, "L%[\"(.-)\"%]") do
		strings[match] = true
	end
end

local work = {}

for k,v in pairs(strings) do table.insert(work, k) end
table.sort(work)

local AceLocaleHeader = "local L ="
local BabbleFishHeader = "L = {} -- "

local function replaceHeader(content)
	return content:gsub(AceLocaleHeader, BabbleFishHeader):gsub("\\", "\\\\"):gsub("\\\"", "\\\\\"")
end

local localizedStrings = {}

-- load existing data from locale files
for idx, lang in ipairs(locale) do
	local file = io.open(lang .. ".lua", "r")
	assert(file, "Could not open ".. lang .. ".lua for reading")
	local content = file:read("*all")
	content = replaceHeader(content)
	assert(loadstring(content))()
	localizedStrings[lang] = L
	file:close()
end

-- Write enUS file
local file = io.open("enUS.lua", "w")
assert(file, "Could not open enUS.lua for writing")
file:write("--[[ $Id$ ]]\n")
file:write("-- Generated by Babelfish script, do not edit directly.\n")
file:write("local L = LibStub(\"AceLocale-3.0\"):NewLocale(\"Bartender4\", \"enUS\", true)\n")
file:write("\n\n")
for idx, match in ipairs(work) do
	file:write(string.format("L[\"%s\"] = true\n", match))
end
file:close()

-- Write locale files
for idx, lang in ipairs(locale) do
	local file = io.open(lang .. ".lua", "w")
	assert(file, "Could not open ".. lang .. ".lua for writing")
	file:write("--[[ $Id$ ]]\n")
	file:write("-- Please make sure to save the file as UTF-8, BUT WITHOUT THE UTF-8 BOM HEADER; ¶\n")
	file:write(string.format("local L = LibStub(\"AceLocale-3.0\"):NewLocale(\"Bartender4\", \"%s\")\n", lang))
	file:write("if not L then return end\n")
	file:write("\n")
	local L = localizedStrings[lang]
	for idx, match in ipairs(work) do
		if L[match] then
			file:write(string.format("L[\"%s\"] = \"%s\"\n", match, L[match]))
		else
			file:write(string.format("-- L[\"%s\"] = true\n", match))
		end
	end
	file:close()
end
