﻿BangItHarder = LibStub("AceAddon-3.0"):NewAddon("BangItHarder", "AceEvent-3.0", "AceConsole-3.0", "AceTimer-3.0", "LibBars-1.0");
local Bars = LibStub("LibBars-1.0");
local Media = LibStub("LibSharedMedia-3.0");
local L = LibStub("AceLocale-3.0"):GetLocale("BangItHarder");

local AnchorPositionsText = {
  L["Topleft"],
  L["Top"],
  L["Topright"],
  L["Left"],
  L["Center"],
  L["Right"],
  L["Bottomleft"],
  L["Bottom"],
  L["Bottomright"],
};
local AnchorPositions = {
  "TOPLEFT",
  "TOP",
  "TOPRIGHT",
  "LEFT",
  "CENTER",
  "RIGHT",
  "BOTTOMLEFT",
  "BOTTOM",
  "BOTTOMRIGHT",
};
local GrowthOptions = {
  L["Up"],
  L["Down"],
};
local Anchors = {
  L["Active"],
  L["Cooldown"],
};

local DrumLookup = {
  [35476] = L["Battle"],
  [35474] = L["Panic"],
  [35478] = L["Restoration"],
  [35477] = L["Speed"],
  [35475] = L["War"],
  -- [2457] = "uber",
};

local options = {
  ["type"] = "group",
  ["handler"] = BangItHarder,
  ["set"] = "OptionsSet",
  ["get"] = "OptionsGet",
  ["args"] = {
    ["Enable"] = {
      ["name"] = L["Enable"],
      ["desc"] = L["Options_Enable_Desc"],
      ["type"] = "toggle",
      ["set"] = "ToggleEnable",
      ["get"] = function(Info) return BangItHarder.enabledState end,
      ["order"] = 0,
    },
    ["BarSettings"] = {
      ["type"] = "group",
      ["name"] = L["Options_BarSettings_Name"],
      ["order"] = 10,
      ["args"] = {
        ["TestBars"] = {
          ["type"] = "execute",
          ["name"] = L["Options_BarSettings_TestBars_Name"],
          ["desc"] = L["Options_BarSettings_TestBars_Desc"],
          ["order"] = 0,
          ["func"] = "CreateTestBars",
        },
        ["Active"] = {
          ["type"] = "group",
          ["name"] = L["Options_BarSettings_Active_Bars_Name"],
          ["order"] = 10,
          ["args"] = {
            ["Anchors"] = {
              ["type"] = "group",
              ["name"] = L["Options_BarSettings_Anchors_Name"],
              ["order"] = 10,
              ["inline"] = true,
              ["args"] = {
                ["ShowAnchor"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Show_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_ShowCooldown_Desc"],
                  ["type"] = "toggle",
                  ["set"] = "OptionsShowAnchorSet",
                  ["arg"] = { "BarSettings", "Active", "ShowAnchor" },
                  ["order"] = 10,
                },
                ["AnchorPoint"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Point_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_Point_Desc"],
                  ["type"] = "select",
                  ["style"] = "dropdown",
                  ["set"] = "OptionsAnchorPointSet",
                  ["values"] = AnchorPositionsText,
                  ["arg"] = { "BarSettings", "Active", "AnchorPoint" },
                  ["order"] = 30,
                },
                ["AnchorRelative"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Relative_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_Relative_Desc"],
                  ["type"] = "select",
                  ["style"] = "dropdown",
                  ["set"] = "OptionsAnchorRelativeSet",
                  ["values"] = AnchorPositionsText,
                  ["arg"] = { "BarSettings", "Active", "AnchorRelative" },
                  ["order"] = 40,
                },
              },
            },
            ["Scale"] = {
              ["name"] = L["Options_BarSettings_Scale_Name"],
              ["desc"] = L["Options_BarSettings_Scale_Desc"],
              ["type"] = "range",
              ["min"] = 0.5,
              ["max"] = 3,
              ["step"] = 0.05,
              ["set"] = "OptionsScaleSet",
              ["arg"] = { "BarSettings", "Active", "Scale" },
              ["isPercent"] = true,
              ["order"] = 20,
            },
            ["Growth"] = {
              ["name"] = L["Options_BarSettings_Growth_Name"],
              ["desc"] = L["Options_BarSettings_Growth_Desc"],
              ["type"] = "select",
              ["style"] = "dropdown",
              ["set"] = "OptionsGrowthSet",
              ["values"] = GrowthOptions,
              ["arg"] = { "BarSettings", "Active", "Growth" },
              ["order"] = 30,
            },
            ["Texture"] = {
              ["name"] = L["Options_BarSettings_Texture_Name"],
              ["desc"] = L["Options_BarSettings_Texture_Desc"],
              ["type"] = "select",
              ["style"] = "dropdown",
              ["set"] = "OptionsTextureSet",
              ["get"] = "OptionsTextureGet",
              ["values"] = Media:List("statusbar"),
              ["arg"] = { "BarSettings", "Active", "Texture" },
              ["order"] = 40,
            },
            ["FlashTimeRemaining"] = {
              ["name"] = L["Options_BarSettings_FlashTimeRemaining_Name"],
              ["desc"] = L["Options_BarSettings_FlashTimeRemaining_Desc"],
              ["type"] = "range",
              ["min"] = 0,
              ["max"] = 15,
              ["step"] = 1,
              ["arg"] = { "BarSettings", "Active", "FlashTimeRemaining" },
              ["order"] = 50,
            },
          },
        },
        ["Cooldown"] = {
          ["type"] = "group",
          ["name"] = L["Options_BarSettings_Cooldown_Bars_Name"],
          ["order"] = 20,
          ["args"] = {
            ["Anchors"] = {
              ["type"] = "group",
              ["name"] = L["Options_BarSettings_Anchors_Name"],
              ["order"] = 10,
              ["inline"] = true,
              ["args"] = {
                ["ShowAnchor"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Show_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_ShowCooldown_Desc"],
                  ["type"] = "toggle",
                  ["set"] = "OptionsShowAnchorSet",
                  ["arg"] = { "BarSettings", "Cooldown", "ShowAnchor" },
                  ["order"] = 10,
                },
                ["AnchorFrame"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Frame_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_Frame_Desc"],
                  ["type"] = "select",
                  ["style"] = "dropdown",
                  ["set"] = "OptionsAnchorFrameSet",
                  ["values"] = Anchors,
                  ["arg"] = { "BarSettings", "Cooldown", "AnchorFrame" },
                  ["order"] = 20,
                },
                ["AnchorPoint"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Point_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_Point_Desc"],
                  ["type"] = "select",
                  ["style"] = "dropdown",
                  ["set"] = "OptionsAnchorPointSet",
                  ["values"] = AnchorPositionsText,
                  ["arg"] = { "BarSettings", "Cooldown", "AnchorPoint" },
                  ["order"] = 30,
                },
                ["AnchorRelative"] = {
                  ["name"] = L["Options_BarSettings_Anchor_Relative_Name"],
                  ["desc"] = L["Options_BarSettings_Anchor_Relative_Desc"],
                  ["type"] = "select",
                  ["style"] = "dropdown",
                  ["set"] = "OptionsAnchorRelativeSet",
                  ["values"] = AnchorPositionsText,
                  ["arg"] = { "BarSettings", "Cooldown", "AnchorRelative" },
                  ["order"] = 40,
                },
              },
            },
            ["Scale"] = {
              ["name"] = L["Options_BarSettings_Scale_Name"],
              ["desc"] = L["Options_BarSettings_Scale_Desc"],
              ["type"] = "range",
              ["min"] = 0.5,
              ["max"] = 3,
              ["step"] = 0.05,
              ["set"] = "OptionsScaleSet",
              ["arg"] = { "BarSettings", "Cooldown", "Scale" },
              ["isPercent"] = true,
              ["order"] = 20,
            },
            ["Growth"] = {
              ["name"] = L["Options_BarSettings_Growth_Name"],
              ["desc"] = L["Options_BarSettings_Growth_Desc"],
              ["type"] = "select",
              ["style"] = "dropdown",
              ["set"] = "OptionsGrowthSet",
              ["values"] = GrowthOptions,
              ["arg"] = { "BarSettings", "Cooldown", "Growth" },
              ["order"] = 30,
            },
            ["Texture"] = {
              ["name"] = L["Options_BarSettings_Texture_Name"],
              ["desc"] = L["Options_BarSettings_Texture_Desc"],
              ["type"] = "select",
              ["style"] = "dropdown",
              ["set"] = "OptionsTextureSet",
              ["get"] = "OptionsTextureGet",
              ["values"] = Media:List("statusbar"),
              ["arg"] = { "BarSettings", "Cooldown", "Texture" },
              ["order"] = 40,
            },
            ["FlashTimeRemaining"] = {
              ["name"] = L["Options_BarSettings_FlashTimeRemaining_Name"],
              ["desc"] = L["Options_BarSettings_FlashTimeRemaining_Desc"],
              ["type"] = "range",
              ["min"] = 0,
              ["max"] = 30,
              ["step"] = 1,
              ["arg"] = { "BarSettings", "Cooldown", "FlashTimeRemaining" },
              ["order"] = 50,
            },
          },
        },
      },
    },
    ["Whisper"] = {
      ["type"] = "group",
      ["name"] = L["Options_Whisper_Name"],
      ["order"] = 30,
      ["args"] = {
        ["Enable"] = {
          ["name"] = L["Enable"],
          ["desc"] = L["Options_Whisper_Enable_Desc"],
          ["type"] = "toggle",
          ["arg"] = { "Whisper", "Enabled" },
          ["order"] = 0,
        },
        ["Name"] = {
          ["name"] = L["Options_Whisper_Name_Name"],
          ["desc"] = L["Options_Whisper_Name_Desc"],
          ["type"] = "input",
          ["arg"] = { "Whisper", "Name" },
          ["order"] = 10,
        },
        ["Message"] = {
          ["name"] = L["Options_Whisper_Message_Name"],
          ["desc"] = L["Options_Whisper_Message_Desc"],
          ["type"] = "input",
          ["arg"] = { "Whisper", "Message" },
          ["order"] = 20,
        },
      },
    },
    ["PartyAnnounce"] = {
      ["type"] = "group",
      ["name"] = L["Options_Party_Name"],
      ["order"] = 40,
      ["args"] = {
        ["General"] = {
          ["type"] = "group",
          ["name"] = L["Options_Party_General_Name"],
          ["order"] = 10,
          ["inline"] = true,
          ["args"] = {
            ["Enable"] = {
              ["name"] = L["Enable"],
              ["desc"] = L["Options_Party_General_Enable_Desc"],
              ["type"] = "toggle",
              ["arg"] = { "Party", "Enabled" },
              ["order"] = 0,
            },
            ["Variables"] = {
              ["name"] = L["Options_Party_General_Variable_Display"],
              ["type"] = "description",
              ["order"] = 5,
            },
            ["Start"] = {
              ["name"] = L["Options_Party_General_Start_Name"],
              ["desc"] = L["Options_Party_General_Start_Desc"],
              ["type"] = "input",
              ["arg"] = { "Party", "Start" },
              ["order"] = 10,
            },
            ["Finish"] = {
              ["name"] = L["Options_Party_General_Finish_Name"],
              ["desc"] = L["Options_Party_General_Finish_Desc"],
              ["type"] = "input",
              ["arg"] = { "Party", "Finish" },
              ["order"] = 20,
            },
          },
        },
        ["EarlyWarning"] = {
          ["type"] = "group",
          ["name"] = L["Options_Party_EarlyWarning_Name"],
          ["order"] = 20,
          ["inline"] = true,
          ["args"] = {
            ["Variables"] = {
              ["name"] = L["Options_Party_EarlyWarning_Variable_Display"],
              ["type"] = "description",
              ["order"] = 0,
            },
            ["Time"] = {
              ["name"] = L["Options_Party_EarlyWarning_Time_Name"],
              ["desc"] = L["Options_Party_EarlyWarning_Time_Desc"],
              ["type"] = "range",
              ["min"] = 0,
              ["max"] = 15,
              ["step"] = 1,
              ["arg"] = { "Party", "EarlyWarningTime" },
              ["order"] = 10,
            },
            ["Message"] = {
              ["name"] = L["Options_Party_EarlyWarning_Message_Name"],
              ["desc"] = L["Options_Party_EarlyWarning_Message_Desc"],
              ["type"] = "input",
              ["arg"] = { "Party", "EarlyWarningMessage" },
              ["order"] = 20,
            },
          },
        },
      },
    },
  },
};

local defaults = {
  ["profile"] = {
    ["BarSettings"] = {
      ["Active"] = {
        ["ShowAnchor"] = false,
        ["Scale"] = 1,
        ["AnchorPoint"] = 2,
        ["AnchorRelative"] = 5,
        ["Growth"] = 2,
        ["Texture"] = "Blizzard",
        ["FlashTimeRemaining"] = 5,
      },
      ["Cooldown"] = {
        ["ShowAnchor"] = false,
        ["Scale"] = 1,
        ["AnchorFrame"] = 1,
        ["AnchorPoint"] = 8,
        ["AnchorRelative"] = 5,
        ["Growth"] = 1,
        ["Texture"] = "Blizzard",
        ["FlashTimeRemaining"] = 0,
      },
    },
    ["Whisper"] = {
      ["Enabled"] = false,
      ["Name"] = "",
      ["Message"] = L["Defaults_Whisper_Message"],
    },
    ["Party"] = {
      ["Enabled"] = true,
      ["Start"] = L["Defaults_Party_Start"],
      ["Finish"] = L["Defaults_Party_Finish"],
      ["EarlyWarningTime"] = 0,
      ["EarlyWarningMessage"] = L["Defaults_Party_EarlyWarningMessage"],
    },
  },
};

function BangItHarder:OnInitialize()
  self.db = LibStub("AceDB-3.0"):New("BangItHarderVars", defaults, "Default");
  LibStub("AceConfig-3.0"):RegisterOptionsTable(L["Bang It Harder"], options);
  -- self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("BangItHarder", "BangItHarder");
  self:RegisterChatCommand(L["bangitharder"], "ChatCommand");
  self:RegisterChatCommand(L["bi"], "ChatCommand");
  self:RegisterChatCommand(L["bih"], "ChatCommand");
  self.ActiveDrums = self:NewBarGroup("Active Drums", Bars.LEFT_TO_RIGHT, 175, 15);
  self.ActiveDrums:HideAnchor();
  self.ActiveDrums:SetFont(nil, 11);
  self.ActiveDrums:SetColorAt(1.00, 0.470588237, 0.698039234, 0, 1);
  self.ActiveDrums:SetScale(self.db.profile.BarSettings.Active.Scale);
  self.CooldownDrums = self:NewBarGroup("Cooldown Drums", Bars.LEFT_TO_RIGHT, 175, 15);
  self.CooldownDrums:HideAnchor();
  self.CooldownDrums:SetFont(nil, 11);
  self.CooldownDrums:SetColorAt(1.00, 1, 0, 0, 1);
  self.CooldownDrums:SetScale(self.db.profile.BarSettings.Cooldown.Scale);

  self:SetTextures();
  self:AnchorPoints();
  self:SetGrowth();
end

function BangItHarder:OnEnable()
  self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
  self:ShowAnchor();
  self.CurrentDrums = {};
  self.LastBarStarted = {};
end

function BangItHarder:OnDisable()
  self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
  for Key, Value in pairs(self.CooldownDrums:GetBars()) do
    self.CooldownDrums:RemoveBar(Key);
  end
  for Key, Value in pairs(self.ActiveDrums:GetBars()) do
    self.ActiveDrums:RemoveBar(Key);
  end
end

-- Ace adds in Event name in the Event field.
function BangItHarder:COMBAT_LOG_EVENT_UNFILTERED(Event, TimeStamp, EventType, SrcGUID, SrcName, SrcFlags, DstGUID, DstName, DstFlags, ...)
  local SpellID, SpellName, SpellSchool, AuraType = ...;
  if ( EventType == "SPELL_CAST_SUCCESS" and SrcName and UnitInParty(SrcName) ) then
    if ( DrumLookup[SpellID] ) then
      self:CreateActiveBar(SrcName, SpellID, SpellName);
    end
  end
end

function BangItHarder:CreateActiveBar(SrcName, SpellID, SpellName)
  local DrumID = SrcName.."-"..DrumLookup[SpellID];
  self.CurrentDrums[DrumID] = GetTime();
  local DrumText = L["DrumText"];
  DrumText = string.gsub(DrumText, "%%name%%", SrcName);
  DrumText = string.gsub(DrumText, "%%drum%%", DrumLookup[SpellID]);
  local DrumVariable = string.gsub(L["DRUM VARIABLE"], "%%", "%%%%");
  local BarID = DrumLookup[SpellID];
  local Bar = self.ActiveDrums:GetBar(BarID);
  if ( Bar and Bar.value > 0 ) then --Specific Drum bar is active
    self:CreateCooldownBar(self.LastBarStarted[SpellID], SpellID);
  end
  Bar = self.ActiveDrums:NewTimerBar(BarID, DrumText, 30 - (GetTime() - self.CurrentDrums[DrumID]), 30, nil, self.db.profile.BarSettings.Active.FlashTimeRemaining);
  Bar.RegisterCallback(self, "TimerFinished", function() self:CreateCooldownBar(SrcName, SpellID, self.CurrentDrums[DrumID]) end);
  self.LastBarStarted[SpellID] = SrcName;
  if ( SrcName == UnitName("player") or SrcName == YOU ) then
    self:ScheduleTimer("MyDrumsAreDone", 30 - (GetTime() - self.CurrentDrums[DrumID]), SpellName);
    if ( self.db.profile.Party.EarlyWarningTime > 0 ) then
      self:ScheduleTimer("MyDrumsAreAlmostDone", 30 - (GetTime() - self.CurrentDrums[DrumID]) - self.db.profile.Party.EarlyWarningTime, self.CurrentDrums[DrumID]);
    end
    if ( self.db.profile.Party.Enabled and GetNumPartyMembers() > 0 ) then
      local Message = string.gsub(self.db.profile.Party.Start, DrumVariable, SpellName);
      SendChatMessage(Message, "PARTY");
    end
  end
end

function BangItHarder:CreateCooldownBar(SrcName, SpellID, TimeBarStarted)
  local DrumID = SrcName.."-"..DrumLookup[SpellID];
  local DrumText = L["DrumText"];
  DrumText = string.gsub(DrumText, "%%name%%", SrcName);
  DrumText = string.gsub(DrumText, "%%drum%%", DrumLookup[SpellID]);
  TimeBarStarted = TimeBarStarted or self.CurrentDrums[DrumID] or (GetTime() - 30);
  local BarID = DrumID;
  local Bar = self.CooldownDrums:NewTimerBar(BarID, DrumText, 120 - (GetTime() - TimeBarStarted), 120, nil, self.db.profile.BarSettings.Cooldown.FlashTimeRemaining);
  Bar.RegisterCallback(self, "TimerFinished", function() self.CurrentDrums[DrumText] = nil end);
end

function BangItHarder:MyDrumsAreDone(SpellName)
  local Message;
  local DrumVariable = string.gsub(L["DRUM VARIABLE"], "%%", "%%%%");
  if ( self.db.profile.Party.Enabled and GetNumPartyMembers() > 0 ) then
    Message = string.gsub(self.db.profile.Party.Finish, DrumVariable, SpellName);
    SendChatMessage(Message, "PARTY");
  end
  if ( self.db.profile.Whisper.Enabled and self.db.profile.Whisper.Name ~= "" ) then
    Message = string.gsub(self.db.profile.Whisper.Message, DrumVariable, SpellName);
    SendChatMessage(Message, "WHISPER", nil, self.db.profile.Whisper.Name);
  end
end

function BangItHarder:MyDrumsAreAlmostDone(StartingTime)
  local Message;
  local TimeVariable = string.gsub(L["TIME VARIABLE"], "%%", "%%%%");
  if ( GetNumPartyMembers() > 0 ) then
    Message = string.gsub(self.db.profile.Party.EarlyWarningMessage, TimeVariable, math.floor((30 - (GetTime() - StartingTime)) * 10 + .5) / 10);
    SendChatMessage(Message, "PARTY");
  end
end

function BangItHarder:ChatCommand(input)
  if ( not input or input:trim() == "" ) then
    LibStub("AceConfigDialog-3.0"):Open(L["Bang It Harder"]);
    -- InterfaceOptionsFrame_OpenToFrame(self.optionsFrame);
  else
    LibStub("AceConfigCmd-3.0").HandleCommand(BangItHarder, "bi", L["Bang It Harder"], input);
  end
end

function BangItHarder:CreateTestBars()
  self:CreateActiveBar(L["NameA"], 35476, L["Test Drums1"]);
  self:CreateCooldownBar(L["NameB"], 35476, GetTime() - 30);
  self:CreateCooldownBar(L["NameC"], 35476, GetTime() - 59.4);
  self:ScheduleTimer(function() self:CreateActiveBar(L["NameD"], 35475, L["Test Drums2"]) end, 1.2);
end

function BangItHarder:ToggleEnable(Info, Value)
  if ( self.enabledState ) then
    self:Disable();
  else
    self:Enable();
  end
end

function BangItHarder:OptionsSet(Info, Value)
  local Table = self.db.profile;
  for Key = 1, (#Info.arg - 1) do
    if ( not Table[Info.arg[Key]] ) then
      Table[Info.arg[Key]] = {};
    end
    Table = Table[Info.arg[Key]];
  end
  Table[Info.arg[#Info.arg]] = Value;
end

function BangItHarder:OptionsGet(Info)
  local Table = self.db.profile;
  for Key = 1, (#Info.arg - 1) do
    if ( not Table[Info.arg[Key]] ) then
      Table[Info.arg[Key]] = {};
    end
    Table = Table[Info.arg[Key]];
  end
  return Table[Info.arg[#Info.arg]];
end

function BangItHarder:OptionsShowAnchorSet(Info, Value)
  self:OptionsSet(Info, Value);
  self:ShowAnchor();
end

function BangItHarder:OptionsScaleSet(Info, Value)
  self:OptionsSet(Info, Value);
  self.ActiveDrums:SetScale(self.db.profile.BarSettings.Active.Scale);
  self.CooldownDrums:SetScale(self.db.profile.BarSettings.Cooldown.Scale);
end

function BangItHarder:OptionsAnchorPointSet(Info, Value)
  self:OptionsSet(Info, Value);
  self:AnchorPoints();
end

function BangItHarder:OptionsAnchorRelativeSet(Info, Value)
  self:OptionsSet(Info, Value);
  self:AnchorPoints();
end

function BangItHarder:OptionsAnchorFrameSet(Info, Value)
  self:OptionsSet(Info, Value);
  self:AnchorPoints();
end

function BangItHarder:OptionsGrowthSet(Info, Value)
  self:OptionsSet(Info, Value);
  self:SetGrowth();
end

function BangItHarder:OptionsTextureSet(Info, Value)
  self:OptionsSet(Info, Media:List("statusbar")[Value]);
  self:SetTextures();
end

function BangItHarder:OptionsTextureGet(Info)
  return self:OptionsTextureFind(self.db.profile.BarSettings[Info.arg[2]].Texture);
end

function BangItHarder:OptionsTextureFind(Texture)
  for Key, Value in pairs(Media:List("statusbar")) do
    if ( Texture == Value ) then
      return Key;
    end
  end
  return nil;
end

function BangItHarder:ShowAnchor()
  if ( self.db.profile.BarSettings.Active.ShowAnchor ) then
    BangItHarder_ActiveBars:Show();
  else
    BangItHarder_ActiveBars:Hide();
  end
  if ( self.db.profile.BarSettings.Cooldown.ShowAnchor ) then
    BangItHarder_CooldownBars:Show();
  else
    BangItHarder_CooldownBars:Hide();
  end
end

function BangItHarder:AnchorPoints()
  local AnchorsLocale = {
    [L["Active"]] = "Active",
    [L["Cooldown"]] = "Cooldown",
  };
  local AnchorFrame, AnchorPoint, RelativePoint;
  AnchorFrame = BangItHarder_ActiveBars;
  AnchorPoint = AnchorPositions[self.db.profile.BarSettings.Active.AnchorPoint];
  RelativePoint = AnchorPositions[self.db.profile.BarSettings.Active.AnchorRelative];
  self.ActiveDrums:ClearAllPoints();
  self.ActiveDrums:SetPoint(AnchorPoint, AnchorFrame, RelativePoint, 0, 0);

  AnchorFrame = getglobal("BangItHarder_"..AnchorsLocale[Anchors[self.db.profile.BarSettings.Cooldown.AnchorFrame]].."Bars");
  AnchorPoint = AnchorPositions[self.db.profile.BarSettings.Cooldown.AnchorPoint];
  RelativePoint = AnchorPositions[self.db.profile.BarSettings.Cooldown.AnchorRelative];
  self.CooldownDrums:ClearAllPoints();
  self.CooldownDrums:SetPoint(AnchorPoint, AnchorFrame, RelativePoint, 0, 0);
end

function BangItHarder:SetGrowth()
  local Lookup = {
    [L["Up"]] = true,
    [L["Down"]] = false,
  };
  self.ActiveDrums:ReverseGrowth(Lookup[GrowthOptions[self.db.profile.BarSettings.Active.Growth]]);
  self.CooldownDrums:ReverseGrowth(Lookup[GrowthOptions[self.db.profile.BarSettings.Cooldown.Growth]]);
end

function BangItHarder:SetTextures()
  self.ActiveDrums:SetTexture(Media:Fetch("statusbar", self.db.profile.BarSettings.Active.Texture or "Blizzard"));
  self.CooldownDrums:SetTexture(Media:Fetch("statusbar", self.db.profile.BarSettings.Cooldown.Texture or "Blizzard"));
end
