
-- Guildbank functionality by Mikk

local addon = assert(_G.BagginsAnywhereBags)

function addon:GUILDBANKFRAME_CLOSED()
	self:UnregisterEvent('GUILDBANKFRAME_CLOSED')	-- gets re-regged when bank is opened
	
	local guildName = "<"..GetGuildInfo("player")..">"
	local r = self.db.realm

	local old = r[guildName]
	r[guildName] = {}
	r[guildName].Money = GetGuildBankMoney()
	r[guildName].BankSlots = nil
	
	addon.options.args[guildName] = addon.options.args[guildName] or {}
	addon.options.args[guildName].args = addon.options.args[guildName].args or {}

	local tabsNotScanned = {}
	
	for tab=1,GetNumGuildBankTabs() do
		local name, icon, isViewable, canDeposit, numWithdrawals, remainingWithdrawals = GetGuildBankTabInfo(tab);
		
		if isViewable then
			local data = {}
			for slot=1,MAX_GUILDBANK_SLOTS_PER_TAB do
				local link = GetGuildBankItemLink(tab, slot) 
				if link then
					local texture,count = GetGuildBankItemInfo(tab, slot)
					data[slot] = {
						link,
						count,
						texture,
						1,
						name
					}
				end
			end
			if next(data) then
				-- We could scan it, store it!
				r[guildName][name] = data
			else
				-- We couldn't scan it!
				tinsert(tabsNotScanned, name)
				-- Do we have an old version to keep?
				if old[name] and next(old[name]) then
					r[guildName][name] = old[name]
				end
			end
		end
	end
	
	if next(tabsNotScanned) then
		-- Tabs never opened cannot be scanned. And no, force looping SetGuildCurrentGuildBankTab() doesn't work either, you really do have to wait until it populates (server roundtrip). This obviously can't be done on the bank closing.
		self:Print("Guild bank tabs not scanned: "..table.concat(tabsNotScanned, ", "))
	end
	
	self:RebuildOptions()

end

